/* ***********************************************************/
/* Copyright (c) 2010-2016 by Progress Software Corporation       */
/*                                                           */
/* All rights reserved.  No part of this program or document */
/* may be  reproduced in  any form  or by  any means without */
/* permission in writing from Progress Software Corporation. */
/*************************************************************/


/* this procedure file dumps the incremental data definition */
/* in two database schema, it generates a .df file at the    */
/* specified location which contains the schema changes      */

DEFINE INPUT PARAMETER cparam AS CHARACTER NO-UNDO.
DEFINE VARIABLE dumpalias AS CHARACTER NO-UNDO.
DEFINE VARIABLE incrdumpalias AS CHARACTER NO-UNDO.
DEFINE VARIABLE dumpelements AS CHARACTER NO-UNDO INITIAL "".
DEFINE VARIABLE dumplocation AS CHARACTER NO-UNDO INITIAL "".
DEFINE VARIABLE dumpcodepage AS CHARACTER NO-UNDO INITIAL "?".

&GLOBAL-DEFINE COMMAND_SEPARATOR CHR(3)
&GLOBAL-DEFINE OPTION_SEPARATOR CHR(4)

RUN separateParams.

CREATE ALIAS DICTDB FOR DATABASE VALUE(dumpalias).
CREATE ALIAS DICTDB2 FOR DATABASE VALUE(incrdumpalias).

SESSION:APPL-ALERT-BOXES = NO.

DEFINE VARIABLE h AS HANDLE NO-UNDO. 

RUN prodict/dump_inc.r PERSISTENT SET h . 
RUN setFileName IN h(dumplocation). 
RUN setCodePage IN h(dumpcodepage). 
RUN setIndexMode IN h("active"). 
RUN setRenameFilename IN h("c:/tmp/master.rf"). 
RUN setDebugMode IN h(1). 
RUN setSilent IN h(YES). 
RUN dodumpincr IN h. 
DELETE PROCEDURE h. 

CATCH e AS Progress.Lang.AppError : 
    MESSAGE e:ReturnValue 
    VIEW-AS  ALERT-BOX .  
END CATCH.

PROCEDURE separateParams.

    DEFINE VARIABLE i           AS INTEGER   NO-UNDO.
    
    DEFINE VARIABLE OptionCount AS INTEGER   NO-UNDO.
    DEFINE VARIABLE cOption     AS CHARACTER NO-UNDO.
    DEFINE VARIABLE optName     AS CHARACTER NO-UNDO.
    DEFINE VARIABLE optValue    AS CHARACTER NO-UNDO.
    
    OptionCount = NUM-ENTRIES(cparam, {&COMMAND_SEPARATOR}).
    /*
        Should we reset to Unknown. If so we need to use. Whose responsibility to 
        reset this?
    */
    SECURITY-POLICY:XCODE-SESSION-KEY  =  ?.    
    DO i = 1 TO OptionCount:
        cOption = ENTRY(i, cparam, {&COMMAND_SEPARATOR}).
        OptName = ENTRY(1, cOption, {&OPTION_SEPARATOR}).
        optValue = ENTRY(2, cOption, {&OPTION_SEPARATOR}).
        CASE optName:
            WHEN "INPUT" THEN
                DO:
                    dumpelements = REPLACE(optValue, "~\", "/").                
                END.
            WHEN "DB" THEN
                DO:
                    dumpalias = REPLACE(optValue, "~\", "/").                
                END.   
            WHEN "INCRDB" THEN
                DO:
                    incrdumpalias = REPLACE(optValue, "~\", "/").                
                END.     
            WHEN "OUTPUT" THEN
                DO:
                    dumplocation = REPLACE(optValue, "~\", "/").   
                END.
            WHEN "CODEPAGE" THEN
               DO:
                    dumpcodepage = REPLACE(optValue, "~\", "/").                
                END.
        END CASE.

    END.
    
END PROCEDURE.
