/* ***********************************************************/
/* Copyright (c) 1984-2016 by Progress Software Corporation  */
/*                                                           */
/* All rights reserved.  No part of this program or document */
/* may be  reproduced in  any form  or by  any means without */
/* permission in writing from Progress Software Corporation. */
/*************************************************************/
/* Author: Per S Digre / PSC                                 */
/*************************************************************/

/* schema.p - Eclipse grab schema procedure */
DEFINE NEW GLOBAL SHARED VARIABLE OEIDE_Context    AS HANDLE NO-UNDO.
function getServerDirectory returns character (  ) in OEIDE_Context.

DEFINE INPUT PARAMETER cPrm AS character NO-UNDO.
DEFINE variable cRet AS character NO-UNDO.
DEFINE variable cDB  AS character NO-UNDO.
DEFINE variable c1   AS character NO-UNDO.
DEFINE variable i1   AS INTEGER  NO-UNDO.

ASSIGN cPrm = TRIM(cPrm).
DO i1 = 1 to NUM-DBS:
  cDB = (IF cDB > "" THEN cDB + "," ELSE "") + LDBNAME(i1).
END.

IF cPrm = "" THEN RETURN cDB.
IF NOT CAN-DO(cDB,ENTRY(1,cPrm,".")) THEN 
  RETURN ERROR "Database " + ENTRY(1,cPrm,".") + " not connected.".

CREATE ALIAS OEIDE_DICTDB FOR DATABASE VALUE(ENTRY(1,cPrm,".")) NO-ERROR.
RUN VALUE(getServerDirectory() + "_dbtable.p") ( ENTRY(2,cPrm + ".",".") ) NO-ERROR.  /* Pass table name if given */
IF ERROR-STATUS:ERROR THEN RETURN ERROR RETURN-VALUE.
RETURN RETURN-VALUE.
