/* ***********************************************************/
/* Copyright (c) 2008-2016 by Progress Software Corporation  */
/*                                                           */
/* All rights reserved.  No part of this program or document */
/* may be  reproduced in  any form  or by  any means without */
/* permission in writing from Progress Software Corporation. */
/*************************************************************/
/*------------------------------------------------------------------------
    File        : runtime/_oeidecontext.p
    Purpose     : Keeps oeide context for runtime servers (plugin scopes or default) 
                  and for the Appbuilder.  
    Syntax      :

    Description : 

    Author(s)   : hdaniels
    Created     : Thu Dec 11 21:32:57 EST 2008
    Notes       : This is started/managed by the runtime/_server.p and is used to 
                  keep ide context for various runtime servers and for the 
                  Appbuilder. 
                - A server that implements setContextHandle will receive 
                  this-procedure when it is started.
                - The AppBuilder - adecomm/oeideservice.p publishes OEIDE_context 
                  to find this-procedure.
  ----------------------------------------------------------------------*/
using Progress.Lang.*.

/* ***************************  Definitions  ************************** */
define variable fProjectName          as character no-undo. 
define variable fProjectFullPath      as character no-undo. 
define variable fServerDirectory      as character no-undo. 
define variable fWorkDirectory        as character no-undo. 
define variable fProjectWorkDirectory as character no-undo. 
define variable fAppbuilderMode       as character no-undo.
define variable fIsAppbuilderRunning  as log  no-undo.
define variable fSocketClient         as handle no-undo.
define variable fCurrentEventObject   as Object no-undo.
define variable fReqestContext        as character no-undo.
define variable fHasNextDialog        as log no-undo.
define variable fApplicationWait      as log no-undo.

/* This new file name could possibly be managed elsewhere, but _oeideuib 
   starts the wizard and saves on completion. The completion is triggered from 
   the finish with a new filename from the _oeidewizard. This provides an easy   
   place to store this and retrieve this for those involved */
define variable fNewFileName          as character no-undo. 

define temp-table ttWindow 
    field type as character
    field name as character 
    field winhwnd  as int64
    field winhandle as handle
    field ablobject as Object
    field timeStamp as datetime
    field linkedFileName as character INITIAL ?
index filename as unique type name
index linkedFileName as unique linkedFileName
index winhwnd as unique winhwnd.
/* ********************  Preprocessor Definitions  ******************** */
/* define type keys for ttwindow */
&SCOPED-DEFINE DESIGN_TYPE "Design"
&SCOPED-DEFINE DIALOG_TYPE "Dialog"


/* ************************  Function Prototypes ********************** */
function clearNewFileName returns logical () forward. 
function createLinkedFile returns character (piHwnd as int64,pcfileName as character) forward. 
function getABLHandle returns handle (piHwnd as int64) forward.
function getApplicationWait returns logical () forward. 
function getCurrentEventObject returns Object () forward.
function getDesignFileName returns character (piHwnd as int64) forward.
function getDesignHwnd returns int64 (pcFile as character) forward.
function getDesignWindow returns handle (piHwnd as int64) forward.
function getHasNextDialog returns logical () forward.
/*function getIsAppbuilderRunning returns logical (  ) forward.*/
function getNewFileName returns character  (  ) forward. 
function getLinkFileFileName returns character (pcLinkFile as character) forward. 

/* need different name than oeideservice internal procedure */
function getLinkFileName returns character (piHwnd as int64) forward. 
function getLinkFileTimeStamp returns datetime (pcLinkFile as character) forward. 
function getLinkFileWindow returns handle (pcLinkFile as character) forward. 
function getObject returns Object (piHwnd as int64) forward.  
function getOpenDialogHwnd returns int64 () forward. 
function getProjectName returns character  (  ) forward.
function getProjectFullPath returns character (  ) forward.
function getRequestContext returns character (  ) forward.
function getServerDirectory returns character (  ) forward.
function getWorkDirectory returns character (  ) forward.
function getProjectWorkDirectory returns character  (  ) forward.
function getSocketClient returns handle () forward. 
function registerObject returns logical (piHwnd as int64,pObject as Object) forward.
function removeHwnd returns logical (piHwnd as int64) forward.
function sendRequest returns logical (pcName as character,pcMessage as character) forward.
function setApplicationWait returns logical (pisWait as logical) forward. 
function setCurrentEventObject returns logical (pobj as Object) forward.
function setDesignFileName returns logical (piHwnd as int64,pcFilename as character) forward.
function setDesignHwnd returns logical (pcFile as character, piHwnd as int64) forward.
function setLinkFileTimeStamp returns logical     (pcLinkFile as character,dt as datetime) forward. 
function setNextEventObject returns logical (pobj as Object) forward.
function setNewFileName returns logical (pcNewFileName as character) forward. 
function setOpenDialogHwnd returns logical (piHwnd as int64 ) forward.
function setRequestContext returns logical (pcContext as character) forward. 
function setWindowHandle returns logical (piHwnd as int64,phhandle as handle) forward. 
function setServerDirectory returns logical (pcDir as character) forward.
function setSocketClient returns logical (phClient as handle) forward. 
/* ***************************  Main Block  *************************** */
fProjectName = os-getenv("ECLIPSE_PROJECT"). 
if fProjectName = ? or fProjectName = "" then
    fProjectName = "unknown".

assign    
  fProjectFullPath = os-getenv("ECLIPSE_ROOT")
  fProjectFullPath = replace(fProjectFullPath, "~\", "/") 
  fWorkDirectory   = os-getenv("ECLIPSE_WORK")
  fProjectWorkDirectory = fWorkDirectory + "/" + fProjectName.
  
/* adecomm/oeideservice.p started by ade publishes OEIDE_context to find this */
subscribe procedure this-procedure to "OEIDE_CONTEXT" anywhere run-procedure "thisProcedure".

/* **********************  Internal Procedures  *********************** */

/* hide unless show ade object in the persistent procedure viewer  */
procedure adepersistent:
end.    

/* see fNewFileName comments */
function portableFileName returns character private
    (pcFileName as character):
    return replace(pcfilename,"~\","/").
end function.

/* handler for publish OEIDE_CONTEXT */
procedure thisProcedure :
    define output parameter phHandle as handle no-undo.
    phHandle = this-procedure.
end procedure.
  
/* ************************  Function Implementations ***************** */
/* we're only supporting one mode... 'integrated', the embedded mode 
   is not supported (and will disappear from the code eventually) */
function getAppbuilderMode returns character
        ( ):    
    return fAppbuilderMode.         
end function.  

function getDesignFileName returns character 
        (piHwnd as int64):
            
    find ttWindow where ttWindow.winhwnd = piHwnd no-error.
    
    if AVAILABLE ttWindow then
       return ttWindow.name.
    
    return "". 
end function.

function getDesignHwnd returns int64
        (pcFile as character ):
     
 
    if pcFile <> "DIALOG" THEN 
    DO: 
        if not (pcfile begins "new") and pcFile <> "wizard" then
        do:
            if index(pcfile,"~\") > 0 then 
                assign 
/*                    pcFile = search(pcfile)*/
                    pcfile = replace(pcfile,"~\","/").
        end.
    END.
   
    if pcfile <> ? then
    do:
        find ttWindow where ttWindow.type = {&DESIGN_TYPE} 
                        and ttWindow.name = pcfile no-error.
        if AVAILABLE ttWindow then
            return ttWindow.winhwnd.
    end. 
    return ?.
end function.

function getDesignWindow returns handle  (piHwnd as int64):
    find ttWindow where ttWindow.winhwnd = piHwnd no-error.
    if AVAILABLE ttWindow then
       return ttwindow.winhandle.
    return ?.  
end function.

/** get the hwnd of the dialog that is being opened */
function getOpenDialogHwnd returns int64 
        ( ):
   
   find ttWindow where ttWindow.type = {&DIALOG_TYPE} 
                   and ttWindow.ablobject = ?.
   return ttWindow.winhwnd.
   catch e as progress.Lang.error :
       undo, throw new Progress.Lang.AppError("getOpenDialogHwnd Error: " + e:GetMessage(1)).
   end catch.
end function.

function getHasNextDialog returns logical 
    () :
     return fHasNextDialog.  
end.     
   
/** 
   call from _oeideuib methods that opens a dialog 
   @param hwnd handle Dev Studio composite that hosts the dialog
   @return true   thows error if dialog already being opened with this name 
 */
function setOpenDialogHwnd returns logical  
        (piHwnd as int64 ):
    
    /* set open dialog means that the next dialog now is executed if it was true 
       (and in the unlikely case that's not true we still should turn it off  )*/         
    fHasNextDialog = false.  
    /* each dialog will be registered with registerObject 
       so there should only be one dialog with unknown object.
       This find could fail (in theory) if a dialog is 
       called from another dialog that did not register */ 
    
    find ttWindow where ttWindow.type = {&DIALOG_TYPE} 
                    and ttwindow.ablobject = ? no-error.
    if not AVAILABLE ttWindow then
    do:
       create ttWindow.
       assign
          ttWindow.type = {&DIALOG_TYPE} 
          ttWindow.name = string(piHwnd)
          ttWindow.winhwnd  = piHwnd.
/*               message "setOpenDialogHwnd"  ttWindow.type ttwindow.winhwnd  ttwindow.ablobject       */
/*                     if valid-handle(ttwindow.winhandle)  then ttwindow.winhandle:title else "no win"*/
/*                                                                                                     */
/*      view-as alert-box.                                                                             */
       return true.
    end.
    undo, throw new Progress.Lang.AppError("setOpenDialogHwnd called when another dialog is being opened.").   
end function.

function createUniqueLinkFile returns character private
         (user_chars   as character,
          extension    as character) :
/*------------------------------------------------------------------------------
  Purpose:  Creates an available temporary file in the linked_resources area.
    Notes:  The return parameter is a complete name that includes the path.
    
    This code is based on adecomm/_tmpfile.p.
------------------------------------------------------------------------------*/
    
    define variable name           as character no-undo.
    define variable name1           as character no-undo.
    
    define variable base           as integer.
    define variable check_name     as character.
    define variable lastChar         as character no-undo.
    /*
     * Loop until we find a name that hasn't been used. In theory, if the
     * temp directory gets filled, this could be an infinite loop. But, the
     * likelihood of that is low.
     */
    check_name = "something":U.
     
    do while check_name <> ?:
      /* Take the lowest 5 digits (change the format so that everything works out to have exactly 5
         characters. */
         
      assign
        base = ( time * 1000 + etime ) modulo 100000
        name1 = string(base,"99999":U)
        lastChar = substring(name1,length(name1,"CHARACTER") - 1,length(name1,"CHARACTER"),"CHARACTER").
         /* Add in the extension and directory into the name. */
        name = getProjectWorkDirectory() 
              + (if not (lastChar = "~\" or lastChar ="/") then "/" else "") 
              + "p":U + name1 + user_chars + extension.
              
      check_name = search(name).
      
    end.
    /* Creates the linked file */
    output TO VALUE(name).
    output CLOSE.
    
    name = replace(name, "~\", "/").
    name = replace(name, "//", "/").
       
    return name.

end function.

function createLinkedFile returns character (piHwnd as int64,pcfileName as character):
    define variable cLinkedFile  as character no-undo.
    define variable ll as logical no-undo.
    
    if index(pcfileName,"~\") > 0 then 
       assign 
           pcfileName = replace(pcfileName,"~\","/").
    
    find ttWindow where ttWindow.winhwnd = piHwnd no-error.
    if AVAILABLE ttWindow then
    do:
        if ttwindow.linkedFileName > "" then 
           os-delete value(ttwindow.linkedFileName).
       assign cLinkedFile = createUniqueLinkFile("lnk", ".tmp").
       assign   
            ttWindow.Name     = pcfileName
            ttWindow.linkedFileName   = cLinkedFile
            /* the filename may have changed - save-as - repos dialogs*/
            ttWindow.name = pcfileName.
        os-copy VALUE(pcfileName) VALUE(cLinkedFile).
        return cLinkedFile.
    end.      
    else
        undo, throw new Progress.Lang.AppError("Unexpected error. Eclipse editor reference not found in ABL context.",?). 
       
end function.


/** register an ABL object with the eclipse composite/window */
function registerObject returns logical  
        (piHwnd as int64,phobj as object):
   
    find ttWindow where ttWindow.winhwnd = piHwnd  no-error.
    if AVAILABLE ttWindow then
    do:
        
        ttWindow.ablobject = phobj.
/*            message "registerObject"  ttWindow.type ttwindow.winhwnd  ttwindow.ablobject             */
/*                     if valid-handle(ttwindow.winhandle)  then ttwindow.winhandle:title else "no win"*/
/*        view-as alert-box.                                                                           */
        return true.
    end.
    return false.   
end function.


/** set the current event to fire on the next dialog call from ide  */
function setCurrentEventObject returns logical  
        (pobj as Object):
    fCurrentEventObject = pObj.
    /* turn off just in case. normally turned of in setOpenDialogHwnd 
     (will be set back to true when called from setNextEventObject()) */  
    fHasNextDialog = false.      
end function.

/** set the next event to fire in the current dialog call from ide  */
function setNextEventObject returns logical  
        (pobj as Object):
    setCurrentEventObject(pObj).
    fHasNextDialog = true.        
end function.

/** register an ABL object with the eclipse composite/window */
function getCurrentEventObject returns object  
        ( ):
    return fCurrentEventObject.   
end function.

/** remove the reference to the eclipse composite/window */
function removeHwnd returns logical  
        (piHwnd as int64):
   
    find ttWindow where ttWindow.winhwnd = piHwnd  no-error.
    if AVAILABLE ttWindow then
    do:
        if ttwindow.linkedFileName > "" then 
             os-delete value(ttwindow.linkedFileName).
/*        message "remove"  ttWindow.type ttwindow.winhwnd  ttwindow.ablobject                         */
/*                     if valid-handle(ttwindow.winhandle)  then ttwindow.winhandle:title else "no win"*/
/*        view-as alert-box.                                                                           */
        delete ttWindow.         
        return true.
    end.
    return false.   
end function.

/** returns an object (service) registered with the eclipse composite/window */
function getObject returns Object 
        (piHwnd as int64):  
    find ttWindow where ttWindow.winhwnd = piHwnd  no-error.
    if AVAILABLE ttWindow then
        return ttWindow.ablobject.
    return ?.   
end function.

/*function getIsAppbuilderRunning returns logical*/
/*    (  ):                                      */
/*    return fIsAppbuilderRunning.               */
/*end function.                                  */

/* see fNewFileName comments */
function getNewFileName returns character 
        (  ):
    return fNewFileName.        
end function.

/* see fNewFileName comments */
function clearNewFileName returns logical 
        (  ):
    fNewFileName = "".        
end function.

function getLinkFileName returns character (piHwnd as int64):
    find ttWindow where ttWindow.winhwnd = piHwnd no-error.
    if AVAILABLE ttWindow then
       return ttwindow.linkedFileName.
    return "".    
end function.

function getLinkFileFileName returns character (pcLinkFile as character):
    pcLinkFile = portableFileName(pcLinkFile).
    find ttWindow where ttWindow.linkedFileName  = pcLinkFile no-error.
    if AVAILABLE ttWindow then
       return ttwindow.Name.
    return ?.   
end function.

function showFiles return log(): 
     define variable cc as character no-undo.
      for each ttWindow:
          cc = cc + "~n" + ttWindow.name + " " 
               + (if ttWindow.linkedFileName = ? then "?" else ttWindow.linkedFileName).
      end.
      message cc
      view-as alert-box.
end.    

function getLinkFileTimeStamp returns datetime (pcLinkFile as character): 
    pcLinkFile = portableFileName(pcLinkFile).
    find ttWindow where ttWindow.linkedFileName = pcLinkFile no-error.
    if AVAILABLE ttWindow then
       return ttwindow.timeStamp.
    return ?.  
end function.

function getLinkFileWindow returns handle (pcLinkFile as character): 
    pcLinkFile = portableFileName(pcLinkFile).
    find ttWindow where ttWindow.linkedFileName  = pcLinkFile no-error.
    if AVAILABLE ttWindow then
       return ttwindow.winhandle.
    return ?.  
end function.

function setLinkFileTimeStamp returns logical (pcLinkFile as character,timedt as datetime): 
    pcLinkFile = portableFileName(pcLinkFile).
    find ttWindow where ttWindow.linkedFileName  = pcLinkFile no-error.
    if AVAILABLE ttWindow then
    do:
        ttwindow.timeStamp = timedt.
        return true.
    end.
    return false.  
end function.

function getProjectName returns character 
        (  ):
    return fProjectName.        
end function.

function getProjectFullPath returns character 
        (  ):
    return fProjectFullPath.                    
end function.

/* The full path of the com.openedge.pdt.text.Runtime directory  */
function getServerDirectory returns character 
    (  ):
    return fServerDirectory.         
end function.

/* Eclipse's writeable working directory */ 
function getWorkDirectory returns character 
        (  ):
    return fWorkDirectory.        
end function.

/* Eclipse's writeable working directory for the project */ 
function getProjectWorkDirectory returns character 
        (  ):
    return fProjectWorkDirectory.        
end function.

/* Get the handle of the socket client procedure that communicates with Eclipse */ 
function getSocketClient returns handle 
        (  ):
    return fSocketClient.        
end function.

/* true if wait is NET      System.Windows.Forms.Application:run
 Could just use the System.Windows.Forms.Application:MessageLoop, but 
 as of current allow this without net reference   
 */ 
function getApplicationWait returns logical 
        (  ):
    return fApplicationWait.  
end function.

/* we're only supporting one mode... 'integrated', the embedded mode 
   is not supported (and will disappear from the code eventually) */
function setAppbuilderMode returns logical
        (pcMode as character  ):
    fAppbuilderMode = pcMode.        
    return true.         
end function.

/* set the wait type NET or ABL.  set from _server 
   see comments in get */ 
function setApplicationWait returns logical
        ( pisAppWait as log ):
    fApplicationWait = pisAppWait.
    return true.        
end function.

function setDesignFileName returns logical 
        (piHwnd as int64,pcFilename as character):
            
    find ttWindow where ttWindow.winhwnd = piHwnd no-error.
    
    if AVAILABLE ttWindow then
    do:
        ttWindow.name = pcFilename.
        return true.
    end.
    return false. 
end function.

function setWindowHandle returns logical (piHwnd as int64,phhandle as handle): 
    
    find ttWindow where ttWindow.winhwnd = piHwnd  no-error.
    if AVAILABLE ttWindow then
    do:
        ttwindow.winhandle = phhandle.
        return true.
    end.
    return false.  
end function.


/* store the IDE handle that is used to host the design window  */
function setDesignHwnd returns logical 
        (pcFile as character,
         piHwnd as int64):
  
  if index(pcfile,"~\") > 0 then 
    assign 
        pcfile = replace(pcfile,"~\","/").
  find ttWindow where ttWindow.type = {&DESIGN_TYPE} 
                  and ttWindow.name = pcfile no-error.
  if not AVAILABLE ttWindow then
  do:
      create ttWindow.
      assign
         ttWindow.type = {&DESIGN_TYPE} 
         ttWindow.name = pcFile.      
  end.
  ttWindow.winhwnd  = piHwnd.
 
  return true.
end function.

/*function setIsAppbuilderRunning returns logical*/
/*    (plIsrunning as log):                      */
/*                                               */
/*  fIsAppbuilderRunning = plIsrunning.           */
/*  return true.                                  */
/*end function.                                  */

/* see fNewFileName comments */
function setNewFileName returns logical 
    (pcNewFileName as character):
    
    fNewFileName = pcNewFileName.        
    return true.         
end function.

/* Used for pds requests in cases where we do not support with paramters all the way.. 
   for example if the info is needed very far down or by many   
   used for project info for shared projects in adm2/support/_wizard and others that 
   starts the smart object  chooser */
function getRequestContext returns character 
    ():
    return fReqestContext.
end function.

/* set from _oeideuib.opennewfile and  _oeideuib.runchilddialog  */
function setRequestContext returns logical 
    (pcContext as character):
    fReqestContext = pcContext.        
    return true.         
end function.


/* set the full path of the com.openedge.pdt.text.Runtime directory  */
function setServerDirectory returns logical 
        (pcDir as character  ):
    fServerDirectory = pCdir.        
    return true.         
end function.

/* Get the handle of the socket client procedure that communicates with Eclipse */ 
function setSocketClient returns logical
        ( phClient as handle ):
    fSocketClient = phClient.
    return true.        
end function.
  


  
    