/* *****************************************************************/
/* Copyright (c) 1984-2016 by Progress Software Corporation        */
/*                                                                 */
/* All rights reserved.  No part of this program or document       */
/* may be  reproduced in  any form  or by  any means without       */
/* permission in writing from Progress Software Corporation.       */
/*******************************************************************/
/*  File:        _idesetcrc.p                                      */
/*  Description: Sets the CRC-VALUE of the specified               */
/*		   file in the metaschema                            */
/*  Parameters:  pcParams a CHR(3) delimited list containing       */
/*               1. The relative file name                         */
/*               2. The table of the trigger. If this is a         */
/*                  column trigger, contains table.column          */
/*               3. The event of the trigger                       */
/*  ReturnValue: Returns CRC if it is updated.                     */
/*               Returns "" if CRC is not updatabale               */
/*               Returns "Error:" + message if not found           */
/*                                                                 */
/*  Author:      Don S. Bulua                                      */
/*******************************************************************/

    DEFINE INPUT PARAMETER  pcParams AS CHARACTER NO-UNDO.
    
    DEFINE VARIABLE cInputFile  AS CHARACTER  NO-UNDO.
    DEFINE VARIABLE cInputTable AS CHARACTER  NO-UNDO.
    DEFINE VARIABLE cInputEvent AS CHARACTER  NO-UNDO.
    
    DEFINE VARIABLE crc_val     AS INTEGER NO-UNDO.
    DEFINE VARIABLE proc        AS CHARACTER    NO-UNDO.
    DEFINE VARIABLE trigProc    AS CHARACTER    NO-UNDO.
    DEFINE VARIABLE trigProcAbs AS CHARACTER    NO-UNDO.
    DEFINE VARIABLE cReturn     AS CHARACTER    NO-UNDO.
    DEFINE VARIABLE i           AS INTEGER NO-UNDO.
    DEFINE VARIABLE cFileTrg    AS CHARACTER    NO-UNDO.
    DEFINE VARIABLE cFile       AS CHARACTER    NO-UNDO.
    DEFINE VARIABLE cField      AS CHARACTER    NO-UNDO.
    DEFINE VARIABLE cFieldTrig  AS CHARACTER    NO-UNDO.
    DEFINE VARIABLE hBufTrig    AS HANDLE  NO-UNDO.
    DEFINE VARIABLE hBufFile    AS HANDLE  NO-UNDO.
    DEFINE VARIABLE hBufField   AS HANDLE  NO-UNDO.
    DEFINE VARIABLE hBufFieldTrig AS HANDLE  NO-UNDO.
    DEFINE VARIABLE qh          AS HANDLE  NO-UNDO.
    DEFINE VARIABLE cQuery      AS CHARACTER    NO-UNDO.

    ASSIGN cInputFile  = TRIM(ENTRY(1,pcParams,CHR(3)))
           cInputTable = TRIM(ENTRY(2,pcParams,CHR(3)))
           cInputEvent = TRIM(ENTRY(3,pcParams,CHR(3)))
           NO-ERROR.
    /* Ensure File has forward slashes only */
    cInputFile = REPLACE(cInputFile ,"~\","~/"). 
   
    proc = SEARCH(cInputFile).
    if proc = ? then 
      return "ERROR: The specified file '" + cFile + "' cannot be found in the propath".

 
   /* Find whether the trigger exists in the connected databases */
   DO i = 1 to NUM-DBS:
      ASSIGN cFile      = LDBNAME(i) + "._File"
             cField     = LDBNAME(i) + "._Field"
             cFileTrg   = LDBNAME(i) + "._File-Trig"
             cFieldTrig = LDBNAME(i) + "._Field-Trig".
                  
      /* Check for Table event, not assign trigger */
      IF NUM-ENTRIES(cInputTable,".") <= 1 THEN
      DO:
        CREATE BUFFER hBufFile FOR TABLE cFile.
        CREATE BUFFER hBufTrig FOR TABLE cFileTrg.
      
        CREATE QUERY qh.
        qh:SET-BUFFERS(hBufFile,hBufTrig).
        cQuery = "FOR EACH _FILE, EACH _FILE-TRIG " + 
                 " WHERE RECID(_FILE) = _FILE-TRIG._File-recid" +
                 " AND _File._File-Name = " + QUOTER(cInputTable) +
                 " AND _File-trig._event = " + QUOTER(cInputEvent).
        qh:QUERY-PREPARE(cQuery).
        qh:QUERY-OPEN().
        qh:GET-FIRST(NO-LOCK) NO-ERROR.
        
        IF hBufTrig:AVAILABLE THEN
        DO:
          ASSIGN trigProc = hBufTrig::_proc-Name
                 trigProc = REPLACE(trigProc ,"~\","~/")
                 trigProcAbs = SEARCH(trigProc). 

          /* Update the metaschema CRC */
          IF trigProcAbs = proc AND hBufTrig::_Trig-Crc NE ? AND hBufTrig::_Trig-Crc NE 0 THEN
          DO:
            COMPILE VALUE(proc) NO-ERROR.
            IF NOT COMPILER:ERROR THEN
            DO:
               ASSIGN  RCODE-INFORMATION:FILENAME = proc
                       crc_val = RCODE-INFORMATION:crc-value
                       hBufTrig::_Trig-Crc = crc_val 
                       NO-ERROR.
                   
               cReturn = STRING(crc_val).
            END.
            ELSE
               cReturn = "ERROR:" + ERROR-STATUS:GET-MESSAGE(1).
          END.
        END.
      END.
      ELSE IF NUM-ENTRIES(cInputTable,".") = 2 THEN 
      DO:
        /* Check for Column trigger */
        CREATE BUFFER hBufFile FOR TABLE cFile.
        CREATE BUFFER hBufField FOR TABLE cField.
        CREATE BUFFER hBufFieldTrig FOR TABLE cFieldTrig.

        CREATE QUERY qh.
        qh:SET-BUFFERS(hBufFile,hBufField,hBufFieldTrig).
        cQuery = "FOR EACH _FILE, EACH _FIELD, EACH _FIELD-TRIG " + 
                 " WHERE RECID(_FILE) = _FIELD._File-recid" +
                 " AND RECID(_FILE) = _FIELD-TRIG._File-recid" + 
                 " AND RECID(_FIELD) = _FIELD-TRIG._Field-Recid" +
                 " AND _FILE._File-Name = " + QUOTER(ENTRY(1,cInputTable,".")) +
                 " AND _FIELD._Field-Name = " + QUOTER(ENTRY(2,cInputTable,".")) +
                 " AND _FIELD-TRIG._event = " + QUOTER(cInputEvent).
        qh:QUERY-PREPARE(cQuery).
        qh:QUERY-OPEN().
        qh:GET-FIRST(NO-LOCK) NO-ERROR.
        IF hBufFieldTrig:AVAILABLE THEN
        DO:
           ASSIGN trigProc = hBufFieldTrig::_proc-Name
                  trigProc = REPLACE(trigProc ,"~\","~/")
                  trigProcAbs = SEARCH(trigProc). 
 
           IF trigProcAbs = proc AND hBufFieldTrig::_Trig-Crc NE ? 
                                     AND hBufFieldTrig::_Trig-Crc NE 0 THEN
           DO:
             COMPILE VALUE(proc) NO-ERROR.
              IF NOT COMPILER:ERROR THEN
              DO:
                ASSIGN  RCODE-INFORMATION:FILENAME = proc
                        crc_val = RCODE-INFORMATION:crc-value
                        hBufFieldTrig::_Trig-Crc = crc_val 
                        NO-ERROR.
                   
                cReturn = STRING(crc_val).
             END.
            ELSE
               cReturn = "ERROR:" + ERROR-STATUS:GET-MESSAGE(1).
          END.                       
        END.
      END.
   END.  /* End NUM-DBS */    

   RETURN cReturn.
   

	
