/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.java.oea.plugins.querygenerator;

import com.openedge.core.runtime.IAVMClient;
import com.openedge.pdt.project.IOpenEdgeProject;
import com.openedge.pdt.project.OEProjectPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class QueryGeneratorItem
extends CompoundContributionItem
implements IWorkbenchContribution {
    private IServiceLocator serviceLocator;

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    protected IContributionItem[] getContributionItems() {
        OEProjectPlugin projectPlugin = OEProjectPlugin.getDefault();
        IOpenEdgeProject[] projects = projectPlugin.getOpenEdgeModel().getOpenEdgeProjects();
        Arrays.sort(projects, new OpenEdgeProjectComparator());
        ArrayList<Object> itemList = new ArrayList<Object>();
        int i = 0;
        while (i < projects.length) {
            IAVMClient runtime = projects[i].getRuntime();
            if (runtime != null && runtime.isConnected()) {
                HashMap<String, String> parameterMap = new HashMap<String, String>();
                parameterMap.put("com.proalpha.java.oea.plugins.querygenerator.avmTypeParameter", "ProjectAVM");
                parameterMap.put("com.proalpha.java.oea.plugins.querygenerator.avmNameParameter", runtime.getName());
                CommandContributionItemParameter itemParameter = new CommandContributionItemParameter(this.serviceLocator, "com.proalpha.java.oea.plugins.querygenerator.commands.startQueryGenerator", "com.proalpha.java.oea.plugins.querygenerator.commands.startQueryGenerator", 8);
                itemParameter.label = runtime.getName();
                itemParameter.parameters = parameterMap;
                CommandContributionItem item = new CommandContributionItem(itemParameter);
                item.setVisible(true);
                itemList.add(item);
            }
            ++i;
        }
        if (projects.length > 0) {
            Separator separator = new Separator();
            itemList.add(separator);
        }
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("com.proalpha.java.oea.plugins.querygenerator.avmTypeParameter", "SharedAVM");
        CommandContributionItemParameter itemParameter = new CommandContributionItemParameter(this.serviceLocator, "com.proalpha.java.oea.plugins.querygenerator.commands.startQueryGenerator", "com.proalpha.java.oea.plugins.querygenerator.commands.startQueryGenerator", 8);
        itemParameter.label = "Shared AVM";
        itemParameter.parameters = parameterMap;
        CommandContributionItem item = new CommandContributionItem(itemParameter);
        item.setVisible(true);
        itemList.add(item);
        return itemList.toArray(new IContributionItem[itemList.size()]);
    }

    private class OpenEdgeProjectComparator
    implements Comparator<IOpenEdgeProject> {
        private OpenEdgeProjectComparator() {
        }

        @Override
        public int compare(IOpenEdgeProject project1, IOpenEdgeProject project2) {
            if (project1 == null) {
                return project2 == null ? 0 : -1;
            }
            if (project2 == null) {
                return 1;
            }
            return project1.getName().compareTo(project2.getName());
        }
    }
}

