/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.checks;

import com.proalpha.pds.gitutils.Activator;
import com.proalpha.pds.gitutils.checks.RepositoryTools;
import com.proalpha.pds.paconnector.PaProject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CompileStagedHandler
extends AbstractHandler {
    private static final String CHANGED_FILES = "changed.inp";
    private static final String STAGED_FILES = "stagedfiles.inp";
    private static final String COMPILER_INPUT_FILE = "compiler.inp";
    private static final String COMPILER_FILES = "compiler.pro,compiler.str,compiler.inp";
    private String patempdir = "";
    private String compilerimpfile = "compiler.inp";
    private String changedFileName = "changed.inp";
    RepositoryTools repositoryTools;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.repositoryTools = new RepositoryTools(event);
        PaProject paProject = this.repositoryTools.getPaProject();
        this.setCompilerimpfile(STAGED_FILES);
        if (!this.checkPreconditions(paProject)) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"compile staged files", (String)"There is no active proALPHA project associated with this git repository.\n\nIs the OE project opened and proALPHA running?");
            return null;
        }
        List<String> checkList = this.repositoryTools.getStagedFiles();
        if (!checkList.isEmpty()) {
            try {
                if (!this.extendAndWriteInputFile(checkList)) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"compile staged files", (String)"No compiler input file generated. Check Console for Details.");
                    return null;
                }
            }
            catch (IOException e) {
                return null;
            }
            paProject.getBridge().startCompilerOpt(this.getCompilerInputFilename(), Boolean.valueOf(true));
        } else {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"compile staged files", (String)"No staged files found. compile will not be performed.");
        }
        return null;
    }

    private boolean checkPreconditions(PaProject paProject) {
        if (paProject == null || !paProject.isAvailable()) {
            this.patempdir = "";
            return false;
        }
        this.patempdir = paProject.getBridge().getpAStartupParam("temp", "");
        return this.deleteCompilerFiles();
    }

    private boolean deleteCompilerFiles() {
        ArrayList<String> fileList = new ArrayList<String>(Arrays.asList(COMPILER_FILES.split(",")));
        fileList.add(STAGED_FILES);
        fileList.add(CHANGED_FILES);
        fileList.add(this.compilerimpfile);
        for (String filename : fileList) {
            File resultFile = new Path(this.patempdir).append(filename).toFile();
            if (!resultFile.isFile()) continue;
            try {
                Files.delete(resultFile.toPath());
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    private boolean extendAndWriteInputFile(List<String> checkList) throws IOException {
        if (checkList.size() > 1000) {
            checkList.clear();
            checkList.add("*");
            Activator.logToConsole("More than 1000 files changed. Compile ALL");
            return this.writeInputFile(this.getCompilerInputFilename(), checkList);
        }
        Activator.logToConsole(String.format("Getting dependencies for %d file(s)", checkList.size()));
        return this.ExtendInputFile(checkList);
    }

    private boolean ExtendInputFile(List<String> checkList) {
        if (this.writeInputFile(this.getChangedFilePath(), checkList)) {
            List<String> command = this.build_command();
            return this.run_command(command);
        }
        return false;
    }

    private List<String> build_command() {
        LinkedList<String> command = new LinkedList<String>();
        command.add("python");
        command.add("-m");
        command.add("pa_common.pds_functions.ext_comp_list");
        command.add("-git");
        command.add(this.repositoryTools.getDirectory());
        command.add("-cf");
        command.add(this.getChangedFilePath());
        command.add("-inp");
        command.add(this.getCompilerInputFilename());
        command.add("-l");
        command.add("INFO");
        return command;
    }

    private boolean run_command(List<String> command) {
        boolean result = false;
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(command);
        try {
            Process p = builder.start();
            Integer callExitValue = p.waitFor();
            if (callExitValue != 0) {
                String line;
                Activator.logToConsole("ERROR while running command");
                Activator.logToConsole(command.toString());
                InputStream inputStream = p.getErrorStream();
                BufferedReader bufRead = new BufferedReader(new InputStreamReader(inputStream));
                while ((line = bufRead.readLine()) != null) {
                    Activator.logToConsole(line);
                }
                result = false;
            } else {
                result = true;
            }
        }
        catch (IOException | InterruptedException e) {
            Activator.logToConsole(e.toString());
            result = false;
        }
        return result;
    }

    private boolean writeInputFile(String impfilename, List<String> checkList) {
        try {
            FileWriter fileWriter = new FileWriter(impfilename);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            for (String filename : checkList) {
                printWriter.println(filename);
            }
            printWriter.close();
        }
        catch (IOException e) {
            Activator.logToConsole(String.format("IO ERROR while writeInputFile %s", impfilename));
            return false;
        }
        return true;
    }

    private String getCompilerInputFilename() {
        File compimpfile = new Path(this.patempdir).append(this.compilerimpfile).toFile();
        return compimpfile.toString();
    }

    public String getChangedFilePath() {
        File compimpfile = new Path(this.patempdir).append(this.changedFileName).toFile();
        return compimpfile.toString();
    }

    public void setCompilerimpfile(String compilerimpfile) {
        this.compilerimpfile = compilerimpfile;
    }

    public void setChangedFileName(String changedFiles) {
        this.changedFileName = changedFiles;
    }
}

