/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.mylyn;

import com.proalpha.pds.gitutils.mylyn.ActionResult;
import com.proalpha.pds.gitutils.mylyn.ActionResultDialog;
import com.proalpha.pds.gitutils.mylyn.FeatureBranchOperation;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureBranchJob
extends Job {
    private final Logger logger = LoggerFactory.getLogger(FeatureBranchJob.class);
    private final FeatureBranchOperation operation;

    public FeatureBranchJob(FeatureBranchOperation operation) {
        super("Feature branch creation/checkout job");
        this.operation = operation;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.operation.setProgressMonitor(monitor);
        this.operation.execute();
        this.showResultDialog(this.operation.getResult());
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        if (JobFamilies.CHECKOUT.equals(family)) {
            return true;
        }
        return super.belongsTo(family);
    }

    private void showResultDialog(List<ActionResult> results) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            int n = new ActionResultDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), results).open();
        });
    }
}

