/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.external;

import com.proalpha.pds.gitutils.external.DbAndBinaryOperation;
import com.proalpha.pds.gitutils.mylyn.ActionResult;
import com.proalpha.pds.gitutils.mylyn.ActionResultDialog;
import com.proalpha.pds.gitutils.mylyn.ReconcileActionSettings;
import com.proalpha.pds.paconnector.Activator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.PlatformUI;

public class DbAndBinaryJob
extends Job {
    private final DbAndBinaryOperation operation;
    private final ReconcileActionSettings recoSettings;
    private final Repository repository;

    public DbAndBinaryJob(Repository repository, ReconcileActionSettings recoSettings) {
        super("Running database reconcile and update of binaries");
        this.operation = new DbAndBinaryOperation(repository, recoSettings);
        this.recoSettings = recoSettings;
        this.repository = repository;
    }

    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor progressMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"checking for relevant updates on current branch...", (int)1);
        IProject[] projects = ProjectUtil.getProjects((Repository)this.repository);
        ArrayList<IProject> openedProjects = new ArrayList<IProject>(Arrays.asList(projects));
        SubMonitor subMonitorArtifacts = SubMonitor.convert((IProgressMonitor)monitor, (String)"database reconcile and artifact update", (int)this.recoSettings.getPaUpdateStages().size());
        if (this.recoSettings.isLoadDf()) {
            Activator.getDefault().getProjectManager().closeProjects(openedProjects, subMonitorArtifacts);
        }
        this.operation.setProgressMonitor(progressMonitor);
        this.operation.execute();
        if (this.recoSettings.isLoadDf()) {
            Activator.getDefault().getProjectManager().openProjects(openedProjects, subMonitorArtifacts);
        }
        this.showResultDialog(this.operation.getActionResults());
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        if (JobFamilies.CHECKOUT.equals(family)) {
            return true;
        }
        return super.belongsTo(family);
    }

    private void showResultDialog(List<ActionResult> results) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            int n = new ActionResultDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), results).open();
        });
    }
}

