/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.pagit.util;

import com.proalpha.pds.pagit.exceptions.WindowsCredentialException;
import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.WString;
import com.sun.jna.ptr.PointerByReference;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsCredentials {
    private String credentialName;
    private CREDENTIAL cred;
    protected static final Logger logger = LoggerFactory.getLogger(WindowsCredentials.class);

    public WindowsCredentials() {
    }

    public WindowsCredentials(String credentialName) {
        this.credentialName = credentialName;
    }

    private CREDENTIAL getCredentialsObject() throws WindowsCredentialException {
        String missingCredentialsNameMessage = "Missing Windows Generic Credential name";
        String invalidPlatformMessage = "This class requires a Windows environment, it uses wincred.h";
        if (!Platform.isWindows()) {
            if (logger.isErrorEnabled()) {
                logger.error(invalidPlatformMessage);
            }
            throw new UnsatisfiedLinkError(invalidPlatformMessage);
        }
        if (this.credentialName == null || this.credentialName.isEmpty()) {
            if (logger.isErrorEnabled()) {
                logger.error(missingCredentialsNameMessage);
            }
            throw new WindowsCredentialException(missingCredentialsNameMessage);
        }
        PointerByReference pptr = new PointerByReference();
        WinCrypt.INSTANCE.CredReadW(new WString(this.credentialName), 1, 0, pptr);
        return new CREDENTIAL(pptr.getValue());
    }

    public String getGenericPassword(String credentialName) throws WindowsCredentialException {
        this.credentialName = credentialName;
        return this.getGenericPassword();
    }

    public String getGenericPassword() throws WindowsCredentialException {
        String password = "";
        try {
            if (this.cred == null) {
                this.cred = this.getCredentialsObject();
            }
            password = new String(this.cred.credentialBlob.getByteArray(0L, this.cred.credentialBlobSize), "UTF-16LE");
        }
        catch (LastErrorException error) {
            if (logger.isErrorEnabled()) {
                logger.error(error.getMessage());
            }
            throw new WindowsCredentialException(error.getMessage());
        }
        catch (UnsupportedEncodingException error) {
            String msg = String.format("Unsupported encoding: %s", error.getMessage());
            if (logger.isErrorEnabled()) {
                logger.error(msg);
            }
            throw new WindowsCredentialException(msg);
        }
        return password;
    }

    public String getGenericUsername(String credentialName) throws WindowsCredentialException {
        this.credentialName = credentialName;
        return this.getGenericUsername();
    }

    public String getGenericUsername() throws WindowsCredentialException {
        String username = "";
        try {
            if (this.cred == null) {
                this.cred = this.getCredentialsObject();
            }
            username = this.cred.userName.toString();
        }
        catch (LastErrorException error) {
            if (logger.isErrorEnabled()) {
                logger.error(error.getMessage());
            }
            throw new WindowsCredentialException(error.getMessage());
        }
        return username;
    }

    @Structure.FieldOrder(value={"flags", "type", "targetName", "comment", "lastWritten", "credentialBlobSize", "credentialBlob", "persist", "attributeCount", "attributes", "targetAlias", "userName"})
    public static class CREDENTIAL
    extends Structure {
        public int flags;
        public int type;
        public WString targetName;
        public WString comment;
        public FILETIME lastWritten;
        public int credentialBlobSize = 256;
        public Pointer credentialBlob;
        public int persist;
        public int attributeCount;
        public CREDENTIAL_ATTRIBUTE.ByReference attributes;
        public WString targetAlias;
        public WString userName;

        public CREDENTIAL() {
        }

        public CREDENTIAL(Pointer memory) {
            super(memory);
            this.read();
        }

        public static class ByReference
        extends CREDENTIAL
        implements Structure.ByReference {
            public ByReference() {
            }

            public ByReference(Pointer memory) {
                super(memory);
            }
        }
    }

    public static class CREDENTIAL_ATTRIBUTE
    extends Structure {
        public String Keyword;
        public int Flags;
        public int ValueSize;
        public byte[] Value = new byte[128];

        protected List<String> getFieldOrder() {
            return Arrays.asList("Keyword", "Flags", "ValueSize", "Value");
        }

        public static class ByReference
        extends CREDENTIAL_ATTRIBUTE
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"dwLowDateTime", "dwHighDateTime"})
    public static final class FILETIME
    extends Structure {
        public int dwLowDateTime;
        public int dwHighDateTime;
    }

    public static interface WinCrypt
    extends Library {
        public static final WinCrypt INSTANCE = (WinCrypt)Native.load((String)"Advapi32", WinCrypt.class);

        public boolean CredReadW(WString var1, int var2, int var3, PointerByReference var4) throws LastErrorException;

        public static final class Type {
            static final int CRED_TYPE_GENERIC = 1;
        }
    }
}

