/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.search;

import org.eclipse.jface.dialogs.IDialogSettings;

public class GitGrepSearchSettings {
    private static final String PHRASE = "phrase";
    private static final String MATCHES = "matches";
    private static final String CASE = "case";
    private static final String FINDS = "finds";
    private static final String REPOSITORY = "repository";
    private static final String FILESCOPE = "filescope";
    private String textPhrase = "";
    private String repositoryPath = "";
    private String branchName = "";
    private String fileNamePhrase = "**/*.*";
    private String fileType = "ALL";
    private int maxFinds = 100;
    private boolean isCaseSensitive = false;

    public String getTextPhrase() {
        return this.textPhrase;
    }

    public void setTextPhrase(String textPhrase) {
        this.textPhrase = textPhrase;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public void setRepositoryPath(String repositoryPath) {
        this.repositoryPath = repositoryPath;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public String getFileNamePhrase() {
        return this.fileNamePhrase;
    }

    public void setFileNamePhrase(String fileNamePhrase) {
        this.fileNamePhrase = fileNamePhrase;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public int getMaxFinds() {
        return this.maxFinds;
    }

    public void setMaxFinds(int maxFinds) {
        this.maxFinds = maxFinds;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    public void save(IDialogSettings settings) {
        IDialogSettings section = settings.getSection("searchSection");
        if (section == null) {
            section = settings.addNewSection("searchSection");
        }
        section.put(PHRASE, this.textPhrase);
        section.put(MATCHES, this.fileNamePhrase);
        section.put(CASE, !this.isCaseSensitive);
        section.put(FINDS, this.maxFinds);
        section.put(FILESCOPE, this.fileType);
        section.put(REPOSITORY, this.repositoryPath);
    }

    public static GitGrepSearchSettings load(IDialogSettings settings) {
        IDialogSettings section = settings.getSection("searchSection");
        GitGrepSearchSettings searchSettings = new GitGrepSearchSettings();
        if (section != null) {
            searchSettings.setTextPhrase(section.get(PHRASE));
            searchSettings.setFileNamePhrase(section.get(MATCHES));
            searchSettings.setCaseSensitive(!section.getBoolean(CASE));
            searchSettings.setMaxFinds(section.getInt(FINDS));
            searchSettings.setFileType(section.get(FILESCOPE));
            searchSettings.setRepositoryPath(section.get(REPOSITORY));
        }
        return searchSettings;
    }

    public static GitGrepSearchSettings init() {
        return new GitGrepSearchSettings();
    }
}

