/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.external;

import com.proalpha.pds.gitutils.Activator;
import com.proalpha.pds.gitutils.mylyn.ActionResult;
import com.proalpha.pds.gitutils.mylyn.ReconcileActionSettings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbAndBinaryOperation {
    private final Logger logger = LoggerFactory.getLogger(DbAndBinaryOperation.class);
    private Repository repository;
    private ReconcileActionSettings recoActionSettings;
    private List<ActionResult> actionResults = new ArrayList<ActionResult>();
    private SubMonitor monitor;

    public DbAndBinaryOperation(Repository repository, ReconcileActionSettings recoSettings) {
        this.repository = repository;
        this.recoActionSettings = recoSettings;
    }

    public void execute() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ArrayList stages = (ArrayList)DbAndBinaryOperation.this.recoActionSettings.getPaUpdateStages();
                DbAndBinaryOperation.this.monitor.setWorkRemaining(stages.size());
                String gitDir = DbAndBinaryOperation.this.repository.getDirectory().getAbsolutePath();
                File parentDir = new File(gitDir.substring(0, gitDir.lastIndexOf(File.separator)));
                try {
                    try {
                        for (String stage : stages) {
                            DbAndBinaryOperation.this.monitor.setTaskName("Running action: " + stage);
                            DbAndBinaryOperation.this.runPaUpdateStage(parentDir, stage, DbAndBinaryOperation.this.monitor.newChild(1));
                        }
                    }
                    catch (Exception e) {
                        block12: {
                            DbAndBinaryOperation.this.logger.info("Restoring the Git repository after an error...");
                            DbAndBinaryOperation.this.monitor.setWorkRemaining(1);
                            DbAndBinaryOperation.this.monitor.setTaskName("Restoring repository");
                            try {
                                try {
                                    Git gitRepository = Git.open((File)DbAndBinaryOperation.this.repository.getDirectory());
                                    gitRepository.reset().setMode(ResetCommand.ResetType.HARD).call();
                                    gitRepository.clean().setCleanDirectories(true).setForce(true).call();
                                }
                                catch (IOException | GitAPIException | NoWorkTreeException e1) {
                                    DbAndBinaryOperation.this.logger.error("An error occurred trying to restore the Git repository. This may have left it in an undefined state.");
                                    DbAndBinaryOperation.this.monitor.worked(1);
                                    break block12;
                                }
                            }
                            catch (Throwable throwable) {
                                DbAndBinaryOperation.this.monitor.worked(1);
                                throw throwable;
                            }
                            DbAndBinaryOperation.this.monitor.worked(1);
                        }
                        this.deleteReconcileFile(parentDir);
                        DbAndBinaryOperation.this.monitor.done();
                    }
                }
                finally {
                    this.deleteReconcileFile(parentDir);
                    DbAndBinaryOperation.this.monitor.done();
                }
            }

            private void deleteReconcileFile(File parentDir) {
                Path reconcileFile = Paths.get(parentDir.getAbsolutePath(), "reconcile.state");
                if (reconcileFile.toFile().exists()) {
                    try {
                        Files.delete(reconcileFile);
                    }
                    catch (Exception e) {
                        DbAndBinaryOperation.this.logger.error("An error occurred while deleting reconcilefile in {}", (Object)reconcileFile);
                    }
                }
            }
        };
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)runnable);
    }

    private void runPaUpdateStage(File parentDir, String stage, SubMonitor subMonitor) throws IOException {
        String errorMsg = "";
        ActionResult actionStageResult = new ActionResult(stage);
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        String profile = com.proalpha.pds.paconnector.Activator.getDefault().getPreferenceStore().getString("AWSCodeArtifactProfile");
        builder.command("python", "-u", "-m", "pa_installer.reconcile", "--stage", stage, "--topodir", parentDir.toString(), "--env", "dev", "--useRCode", "--profile", profile, "--login");
        builder.directory(parentDir);
        builder.redirectErrorStream(true);
        builder.redirectInput(ProcessBuilder.Redirect.PIPE);
        builder.redirectOutput(ProcessBuilder.Redirect.PIPE);
        if (!(this.recoActionSettings.isLoadXml() || stage != "createdf" && stage != "loaddf")) {
            builder.command().add("--bruteForce");
        }
        try {
            try {
                Process p = builder.start();
                this.logger.info("Start reconcile action: Running '{}' in {}", builder.command(), (Object)parentDir);
                this.parseOutputStream(subMonitor, actionStageResult, p);
                subMonitor.worked(1);
                Integer callExitValue = p.waitFor();
                if (callExitValue > 0) {
                    this.parseErrorStream(actionStageResult, p);
                    errorMsg = MessageFormat.format("Error while running stage {0} of python package pa_installer.reconcile with exitcode {1}", stage, callExitValue);
                    Activator.logToConsole(errorMsg);
                    this.logError(errorMsg, actionStageResult);
                    throw new RuntimeException(errorMsg);
                }
            }
            catch (IOException e) {
                Integer callExitValue = 1;
                errorMsg = MessageFormat.format("Exception while running stage {0} of python package pa_installer.reconcile with exitcode {1} and {2}", stage, callExitValue, e.getMessage());
                this.logError(errorMsg, actionStageResult);
                throw e;
            }
            catch (InterruptedException e) {
                errorMsg = MessageFormat.format("Error {0} occured", e.getMessage());
                this.logError(errorMsg, actionStageResult);
                Thread.currentThread().interrupt();
                subMonitor.done();
                this.actionResults.add(actionStageResult);
            }
        }
        finally {
            subMonitor.done();
            this.actionResults.add(actionStageResult);
        }
    }

    private void logError(String errorMsg, ActionResult actionStageResult) {
        actionStageResult.addToLog(errorMsg);
        actionStageResult.setStatus("FAIL");
        this.logger.error(errorMsg);
    }

    public void parseErrorStream(ActionResult actionStageResult, Process p) throws IOException {
        InputStreamReader rErr = new InputStreamReader(p.getErrorStream());
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedReader inErr = new BufferedReader(rErr);){
            String line;
            do {
                if ((line = inErr.readLine()) == null) continue;
                actionStageResult.addToLog(line);
                Activator.logToConsole(line);
            } while (line != null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseOutputStream(SubMonitor subMonitor, ActionResult actionStageResult, Process p) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            InputStreamReader rOut = new InputStreamReader(p.getInputStream());
            try {
                try (BufferedReader inOut = new BufferedReader(rOut);){
                    String line;
                    do {
                        if ((line = inOut.readLine()) == null) continue;
                        int indexOfFourthSpace = StringUtils.ordinalIndexOf((String)line, (String)" ", (int)4);
                        if (indexOfFourthSpace > -1) {
                            subMonitor.setTaskName(line.substring(indexOfFourthSpace));
                        }
                        actionStageResult.addToLog(line);
                        Activator.logToConsole(line);
                    } while (line != null);
                }
                if (rOut == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (rOut == null) throw throwable;
                ((Reader)rOut).close();
                throw throwable;
            }
            ((Reader)rOut).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public void setProgressMonitor(SubMonitor monitor) {
        this.monitor = monitor;
    }

    public List<ActionResult> getActionResults() {
        return this.actionResults;
    }
}

