/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.checks;

import com.proalpha.pds.gitutils.checks.CompileJob;
import com.proalpha.pds.gitutils.checks.CompileOptions;
import com.proalpha.pds.gitutils.checks.CompileType;
import com.proalpha.pds.gitutils.checks.RepositoryTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class CompileBranchesPage
extends WizardPage {
    private Repository repository;
    private RepositoryTools repositoryTools;
    private Combo cmb_source;
    private Combo cmb_target;
    private List<String> localBranches;

    public CompileBranchesPage(Repository repository) {
        super("wizardPage");
        this.repository = repository;
        this.repositoryTools = new RepositoryTools(repository);
        this.setTitle("Select Branches");
        this.setDescription("Select the source and target branch for Differeces");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        this.cmb_source = new Combo(container, 8);
        this.cmb_source.setBounds(174, 41, 173, 23);
        Label lblSourceBranch = new Label(container, 0);
        lblSourceBranch.setBounds(27, 49, 141, 15);
        lblSourceBranch.setText("Source Branch");
        this.cmb_target = new Combo(container, 8);
        this.cmb_target.setBounds(173, 70, 174, 23);
        Label lblTargetBranch = new Label(container, 0);
        lblTargetBranch.setBounds(27, 78, 141, 15);
        lblTargetBranch.setText("Target Branch");
        try {
            String curBranch = this.repositoryTools.extendBanchName(this.repositoryTools.getBranch());
            String masterBranch = this.repositoryTools.extendBanchName(this.repositoryTools.getMasterBranch());
            this.localBranches = this.getBranches();
            Integer itemcount = 0;
            for (String branch : this.localBranches) {
                this.cmb_source.add(branch);
                this.cmb_target.add(branch);
                if (curBranch.equals(branch)) {
                    this.cmb_source.select(itemcount.intValue());
                }
                if (masterBranch.equals(branch)) {
                    this.cmb_target.select(itemcount.intValue());
                }
                itemcount = itemcount + 1;
            }
        }
        catch (IOException | GitAPIException throwable) {
            // empty catch block
        }
    }

    private List<String> getBranches() throws IOException, GitAPIException {
        ArrayList<String> allBranches = new ArrayList<String>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (Git git = new Git(this.repository);){
            List call = git.branchList().call();
            for (Ref ref : call) {
                allBranches.add(ref.getName());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return allBranches;
    }

    public boolean selection_done() {
        if (this.cmb_source.getText().length() == 0 || this.cmb_target.getText().length() == 0) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"branch selection error", (String)"not all branches are selected.");
            return false;
        }
        String source_branch = this.getSingleBranchName(this.cmb_source.getText());
        String target_branch = this.getSingleBranchName(this.cmb_target.getText());
        String relativeInputFile = String.valueOf(source_branch) + '_' + target_branch + ".inp";
        String titletxt = String.format("get compiler listing between %s and %s", source_branch, target_branch);
        CompileOptions options = new CompileOptions();
        options.type = CompileType.DIFF;
        options.commit1 = source_branch;
        options.commit2 = target_branch;
        options.compilerInputFileName = relativeInputFile;
        CompileJob branchDeptCollectorJob = new CompileJob(titletxt, this.repositoryTools, options);
        branchDeptCollectorJob.setUser(true);
        branchDeptCollectorJob.schedule();
        return true;
    }

    private String getSingleBranchName(String branch) {
        String[] refs;
        if (branch.contains("/") && (refs = branch.split("/")).length > 1) {
            branch = refs[refs.length - 1];
        }
        return branch;
    }
}

