/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.mylyn;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.tasks.core.ITask;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class RepositoryFilter
extends ViewerFilter {
    private String searchString = ".*";
    private boolean showAllProjects = false;
    private Set<String> potentialJiraProjects;

    public RepositoryFilter(ITask activatedJiraTask) {
        this.setPotentialJiraProjects(activatedJiraTask);
    }

    public void setSearchText(String s) {
        this.searchString = ".*" + s + ".*";
    }

    private String extractProjectFromTask(ITask task) {
        String taskKey = task.getTaskKey();
        String[] splitTaskKey = taskKey.split("-");
        return splitTaskKey[0];
    }

    public void setShowAllProjects(boolean showAll) {
        this.showAllProjects = showAll;
    }

    private void setPotentialJiraProjects(ITask activatedJiraTask) {
        this.potentialJiraProjects = new TreeSet<String>();
        try {
            JSONParser parser = new JSONParser();
            JSONObject data = (JSONObject)parser.parse((Reader)new FileReader("\\\\wei-vsagit01\\DeMaS_configurations\\to_install\\allprojects.json"));
            JSONArray projectArray = (JSONArray)data.get((Object)"Projects");
            String jiraProjectTask = this.extractProjectFromTask(activatedJiraTask);
            for (Object object : projectArray) {
                JSONObject project = (JSONObject)object;
                String projectName = (String)project.get((Object)"project");
                String variant = (String)project.get((Object)"variant");
                String version = ((String)project.get((Object)"version")).replace(".", "");
                String jiraProject = (String)project.get((Object)"jira_project");
                if (StringUtils.isEmpty((String)projectName) || StringUtils.isEmpty((String)variant) || StringUtils.isEmpty((String)jiraProject) || StringUtils.isEmpty((String)version) || !jiraProject.equals(jiraProjectTask)) continue;
                this.potentialJiraProjects.add(String.valueOf(projectName) + "-" + variant + "-" + version);
            }
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
        }
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        RepositoryNode repository = (RepositoryNode)element;
        String[] pathArray = repository.getPath().toString().split("/");
        if (pathArray.length <= 3) {
            return true;
        }
        String projectName = pathArray[3];
        if (projectName.matches(this.searchString)) {
            if (this.showAllProjects) {
                return true;
            }
            if (this.potentialJiraProjects.contains(projectName)) {
                return true;
            }
        }
        return false;
    }
}

