/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.common;

import com.proalpha.pds.gitutils.common.CheckoutOperation;
import com.proalpha.pds.pagit.PaGit;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.jgit.api.DiffCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.filter.PathSuffixFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffOperation
extends CheckoutOperation {
    private DiffCommand cmd;
    private String dbCommit;
    private String artifactsCommit;
    private String targetRefName;
    private String newHead;
    private List<DiffEntry> pdiDiffList;
    private List<DiffEntry> stateInfoDiffList;
    private boolean isAssembliesXmlChanged;
    private final Logger logger = LoggerFactory.getLogger(DiffOperation.class);

    public DiffOperation(Repository repository, String remote, String sourceRef, String targetRef, boolean updateSourceRef, boolean updateTargetRef, String dbCommit, String artifactsCommit) {
        super(repository, remote, sourceRef, targetRef, updateSourceRef, updateTargetRef);
        this.dbCommit = dbCommit;
        this.artifactsCommit = artifactsCommit;
        this.isAssembliesXmlChanged = false;
    }

    public DiffOperation(Repository repository, String remote, String sourceRef, String targetRef, boolean updateSourceRef, boolean updateTargetRef, String dbCommit) {
        super(repository, remote, sourceRef, targetRef, updateSourceRef, updateTargetRef);
        this.dbCommit = dbCommit;
        this.artifactsCommit = dbCommit;
        this.isAssembliesXmlChanged = false;
    }

    public DiffOperation(Repository repository, String targetRef) {
        super(repository, targetRef);
    }

    @Override
    public void run() throws InvocationTargetException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Get diff between selected commits");
        }
        try {
            try {
                if (this.isLocalBranch(this.targetRef)) {
                    this.targetRefName = this.targetRef;
                    if (this.updateTargetRef) {
                        this.tryFetch(this.targetRef);
                    }
                } else if (this.isServerBranch(this.targetRef)) {
                    this.targetRefName = "remotes/" + this.remote + "/" + this.targetRef;
                    if (this.updateTargetRef) {
                        this.tryFetch(this.targetRef);
                    }
                } else {
                    this.targetRefName = "remotes/" + this.remote + "/" + this.sourceRef;
                    if (this.updateSourceRef) {
                        this.tryFetch(this.sourceRef);
                    }
                }
                this.newHead = PaGit.getInstance().getGit().getRepository().findRef(this.targetRefName).getObjectId().getName();
                this.logger.info("New head is {}", (Object)this.newHead);
                this.pdiDiffList = this.executeCommand(this.dbCommit, this.targetRefName, ".pdi");
                this.stateInfoDiffList = this.executeCommand(this.artifactsCommit, this.targetRefName, ".state_info");
                this.isAssembliesXmlChanged = !this.executeCommand(this.artifactsCommit, this.targetRefName, "assemblies.xml").isEmpty();
            }
            catch (IOException e) {
                this.logger.info(e.getMessage());
                e.printStackTrace();
                PaGit.getInstance().close();
            }
            catch (GitAPIException e) {
                e.printStackTrace();
                PaGit.getInstance().close();
            }
        }
        finally {
            PaGit.getInstance().close();
        }
    }

    private List<DiffEntry> executeCommand(String commitId, String refName, String pathFilter) throws GitAPIException, IOException {
        AbstractTreeIterator oldTreeParser = DiffOperation.prepareTreeParserWithCommitId(this.repository, commitId);
        AbstractTreeIterator newTreeParser = DiffOperation.prepareTreeParserWithRef(this.repository, refName);
        this.cmd = PaGit.getInstance().getGit().diff().setOldTree(oldTreeParser).setNewTree(newTreeParser).setShowNameAndStatusOnly(true).setPathFilter((TreeFilter)PathSuffixFilter.create((String)pathFilter));
        List diffList = this.cmd.call();
        if (this.logger.isDebugEnabled()) {
            for (DiffEntry entry : diffList) {
                this.logger.debug("Entry: {}", (Object)entry);
            }
        }
        return diffList;
    }

    private static AbstractTreeIterator prepareTreeParserWithRef(Repository repository, String ref) throws IOException {
        ObjectId treeId = repository.resolve(String.valueOf(ref) + "^{tree}");
        Throwable throwable = null;
        Object var4_5 = null;
        try (RevWalk walk = new RevWalk(repository);){
            RevTree tree = walk.parseTree((AnyObjectId)treeId);
            CanonicalTreeParser treeParser = new CanonicalTreeParser();
            Throwable throwable2 = null;
            Object var9_12 = null;
            try (ObjectReader reader = repository.newObjectReader();){
                treeParser.reset(reader, (AnyObjectId)tree.getId());
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            walk.dispose();
            return treeParser;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private static AbstractTreeIterator prepareTreeParserWithCommitId(Repository repository, String objectId) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (RevWalk walk = new RevWalk(repository);){
            RevCommit commit = walk.parseCommit((AnyObjectId)ObjectId.fromString((String)objectId));
            RevTree tree = walk.parseTree((AnyObjectId)commit.getTree().getId());
            CanonicalTreeParser treeParser = new CanonicalTreeParser();
            Throwable throwable2 = null;
            Object var9_12 = null;
            try (ObjectReader reader = repository.newObjectReader();){
                treeParser.reset(reader, (AnyObjectId)tree.getId());
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            walk.dispose();
            return treeParser;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public String getDbCommit() {
        return this.dbCommit;
    }

    public String getArtifactsCommit() {
        return this.artifactsCommit;
    }

    public String getTargetRefName() {
        return this.targetRefName;
    }

    public String getNewHead() {
        return this.newHead;
    }

    public List<DiffEntry> getPdiDiffList() {
        return this.pdiDiffList;
    }

    public List<DiffEntry> getStateInfoDiffList() {
        return this.stateInfoDiffList;
    }

    public boolean isAssembliesXmlChanged() {
        return this.isAssembliesXmlChanged;
    }
}

