/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.cherrypick;

import com.proalpha.pds.gitutils.Activator;
import com.proalpha.pds.gitutils.cherrypick.CherryPickSettings;
import com.proalpha.pds.gitutils.cherrypick.MultiCherryPickCredentialsPage;
import com.proalpha.pds.gitutils.cherrypick.MultiCherryPickWizard;
import com.proalpha.pds.gitutils.cherrypick.PrefixMatchFilter;
import com.proalpha.pds.pagit.PaGitConfig;
import com.proalpha.pds.pagit.model.server.GitServerRepository;
import com.proalpha.pds.pagit.util.PaRepository;
import com.proalpha.pds.pagit.util.bitbucket.BitbucketRestCallGetRepoList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.osgi.framework.Bundle;

public class MultiCherryPickPage
extends WizardPage {
    private Repository targetRepository;
    private List<GitServerRepository> currRepos;
    private Map<String, Set<String>> projectRepositoryMap;
    private ComboViewer cvSrcProject;
    private ComboViewer cvSrcRepository;
    private ComboViewer cvSrcBranch;
    private Text txtSrcFeature;
    private Text txtTargetBranchPoint;
    private Button btnOnlyShowMaster;
    private Button btnRunTest;
    private Button btnRunTarget;
    private org.eclipse.swt.widgets.List infoList;
    private Label infoLabel;
    private Display display;
    ScrolledComposite scrolledComposite;
    private CherryPickSettings cherryPickSettings;
    private Map<String, List<String>> causedIssues;
    private static final String PAGE_NAME = "pAGitMultiCherryPickPage";

    public MultiCherryPickPage(Repository repository) {
        super(MultiCherryPickPage.class.getName());
        this.targetRepository = repository;
        this.setTitle("Proalpha Multicherry-pick");
        this.setMessage("Select repository and branch which needs to get picked into your current repository", 1);
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"com.proalpha.pds.gitutils"), (IPath)new Path("icons/pA-logox72.png"), Collections.emptyMap());
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)url));
        this.causedIssues = new HashMap<String, List<String>>();
    }

    private void disableAll() {
        this.cvSrcBranch.getCombo().setEnabled(false);
        this.cvSrcProject.getCombo().setEnabled(false);
        this.cvSrcRepository.getCombo().setEnabled(false);
        this.btnRunTest.setEnabled(false);
        this.txtSrcFeature.setEnabled(false);
        this.txtTargetBranchPoint.setEnabled(false);
        this.btnOnlyShowMaster.setEnabled(false);
        this.display.update();
    }

    private void enableAll() {
        this.cvSrcBranch.getCombo().setEnabled(true);
        this.cvSrcProject.getCombo().setEnabled(true);
        this.cvSrcRepository.getCombo().setEnabled(true);
        this.btnRunTest.setEnabled(true);
        this.txtSrcFeature.setEnabled(true);
        this.txtTargetBranchPoint.setEnabled(true);
        this.btnOnlyShowMaster.setEnabled(true);
        this.display.update();
    }

    public void createControl(Composite parent) {
        this.cherryPickSettings = ((MultiCherryPickWizard)this.getWizard()).getSettings();
        this.currRepos = this.getServerRepositories();
        this.projectRepositoryMap = this.fillProjectRepositoryMap();
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        this.display = this.getShell().getDisplay();
        container.setLayout((Layout)new GridLayout(1, false));
        this.createSourceControls(container);
        this.createTargetControls(container);
        this.setControl((Control)container);
        GridData gridData = new GridData(4, 0x1000000, false, false, 3, 1);
        Composite container_bottom = new Composite(container, 0);
        container_bottom.setLayoutData((Object)gridData);
        gridData.widthHint = 488;
        gridData.heightHint = 100;
        this.scrolledComposite = new ScrolledComposite(container_bottom, 768);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setBounds(0, 0, 408, 100);
        this.infoList = new org.eclipse.swt.widgets.List((Composite)this.scrolledComposite, 0);
        this.infoList.setBounds(0, 0, 408, 100);
        this.infoList.add("");
        this.infoLabel = new Label((Composite)this.scrolledComposite, 0);
        this.infoLabel.setBounds(0, 0, 408, 100);
        this.infoLabel.setText("");
        this.infoLabel.moveAbove((Control)this.infoList);
        this.scrolledComposite.setContent((Control)this.infoLabel);
        this.btnRunTest = new Button(container_bottom, 0);
        this.btnRunTest.setBounds(408, 0, 80, 30);
        this.btnRunTest.setText("Test Merge");
        this.btnRunTarget = new Button(container_bottom, 0);
        this.btnRunTarget.setBounds(408, 45, 80, 30);
        this.btnRunTarget.setText("Target Merge");
        this.btnRunTarget.setEnabled(false);
        this.addSrcWidgetListeners();
        this.addTargetWidgetListeners();
        this.addButtonWidgetListeners();
        this.checkRepoAndProposeBranches();
    }

    private void createTargetControls(Composite container) {
        Group grpTarget = new Group(container, 0);
        GridData gdGrpTarget = new GridData(4, 0x1000000, false, false, 2, 1);
        gdGrpTarget.widthHint = 450;
        gdGrpTarget.heightHint = 60;
        grpTarget.setLayoutData((Object)gdGrpTarget);
        grpTarget.setText("Target");
        Label label1 = new Label((Composite)grpTarget, 0);
        label1.setText("Repository");
        label1.setBounds(10, 22, 80, 15);
        Text txtTargetRepository = new Text((Composite)grpTarget, 0);
        txtTargetRepository.setBounds(96, 23, 347, 21);
        txtTargetRepository.setText(this.targetRepository.getDirectory().toString());
        txtTargetRepository.setEnabled(false);
        Label lblBranchPoint = new Label((Composite)grpTarget, 0);
        lblBranchPoint.setText("Branch Point");
        lblBranchPoint.setBounds(10, 49, 80, 15);
        this.txtTargetBranchPoint = new Text((Composite)grpTarget, 2048);
        this.txtTargetBranchPoint.setBounds(96, 46, 212, 21);
        try {
            String remoteTrackingRef;
            List<String> branches = PaRepository.getMasterBranches(this.targetRepository);
            String mainBranch = null;
            if (branches != null && !branches.isEmpty()) {
                mainBranch = branches.get(0);
            } else {
                branches = PaRepository.getCodeFreezeBranches(this.targetRepository);
                if (branches != null && !branches.isEmpty()) {
                    mainBranch = branches.get(0);
                }
            }
            if (mainBranch == null) {
                mainBranch = this.targetRepository.getFullBranch();
            }
            if ((remoteTrackingRef = PaRepository.getRemoteTrackingBranch(this.targetRepository, mainBranch)) == null || remoteTrackingRef.isEmpty()) {
                remoteTrackingRef = "HEAD";
            }
            this.txtTargetBranchPoint.setText(remoteTrackingRef);
            this.cherryPickSettings.setTargetBranchPoint(remoteTrackingRef);
        }
        catch (IOException ex) {
            this.setMessage("Could not determine the branch name to be used as branching point!", 3);
        }
    }

    private void createSourceControls(Composite container) {
        String gitDefaultRepo = com.proalpha.pds.paconnector.Activator.getDefault().getPreferenceStore().getString("PaGitDefaultRepo");
        String gitDefaultProject = "";
        String gitShortDefaultRepo = "";
        if (gitDefaultRepo.contains("/")) {
            String[] splitGitDefaultRepo = gitDefaultRepo.split("/");
            gitDefaultProject = splitGitDefaultRepo[0];
            gitShortDefaultRepo = splitGitDefaultRepo[1];
        }
        Group grpSource = new Group(container, 0);
        GridData gdGrpSource = new GridData(4, 128, true, false, 2, 1);
        gdGrpSource.heightHint = 111;
        gdGrpSource.widthHint = 450;
        grpSource.setLayoutData((Object)gdGrpSource);
        grpSource.setText("Source");
        Label lblProject = new Label((Composite)grpSource, 0);
        lblProject.setText("Project");
        lblProject.setBounds(10, 22, 80, 15);
        Label lblRepository = new Label((Composite)grpSource, 0);
        lblRepository.setText("Repository");
        lblRepository.setBounds(10, 49, 80, 15);
        Label lblBranch = new Label((Composite)grpSource, 0);
        lblBranch.setText("Branch");
        lblBranch.setBounds(10, 76, 80, 15);
        Label lblFeature = new Label((Composite)grpSource, 0);
        lblFeature.setText("Feature");
        lblFeature.setBounds(10, 103, 80, 15);
        PrefixMatchFilter projectFilter = new PrefixMatchFilter();
        this.cvSrcProject = new ComboViewer((Composite)grpSource, 2048);
        this.cvSrcProject.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cvSrcProject.getCombo().setBounds(96, 19, 212, 21);
        this.cvSrcProject.addFilter((ViewerFilter)projectFilter);
        Set<String> projectsSet = this.projectRepositoryMap.keySet();
        Object[] projects = new String[projectsSet.size()];
        projectsSet.toArray(projects);
        Arrays.sort(projects);
        this.cvSrcProject.setInput((Object)projects);
        this.cvSrcProject.setSelection((ISelection)new StructuredSelection((Object)gitDefaultProject));
        PrefixMatchFilter repositoryFilter = new PrefixMatchFilter();
        this.cvSrcRepository = new ComboViewer((Composite)grpSource, 2048);
        this.cvSrcRepository.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cvSrcRepository.getCombo().setBounds(96, 46, 212, 21);
        this.cvSrcRepository.addFilter((ViewerFilter)repositoryFilter);
        Set<String> repositorySet = this.projectRepositoryMap.get(gitDefaultProject);
        if (repositorySet == null) {
            repositorySet = new HashSet<String>();
        }
        Object[] repositories = new String[repositorySet.size()];
        repositorySet.toArray(repositories);
        Arrays.sort(repositories);
        this.cvSrcRepository.setInput((Object)repositories);
        this.cvSrcRepository.setSelection((ISelection)new StructuredSelection((Object)gitShortDefaultRepo));
        PrefixMatchFilter branchFilter = new PrefixMatchFilter();
        this.cvSrcBranch = new ComboViewer((Composite)grpSource, 2048);
        this.cvSrcBranch.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cvSrcBranch.getCombo().setBounds(96, 73, 212, 21);
        this.cvSrcBranch.addFilter((ViewerFilter)branchFilter);
        this.txtSrcFeature = new Text((Composite)grpSource, 2048);
        this.txtSrcFeature.setBounds(96, 100, 162, 21);
        Button btnRefreshRepos = new Button((Composite)grpSource, 0);
        btnRefreshRepos.setToolTipText("Reload repositories from server");
        btnRefreshRepos.setImage(ResourceManager.getPluginImage("com.proalpha.pds.gitutils", "icons/refresh.gif"));
        btnRefreshRepos.setBounds(314, 18, 28, 23);
        IDialogSettings settings = this.getDialogSettings();
        this.btnOnlyShowMaster = new Button((Composite)grpSource, 32);
        this.btnOnlyShowMaster.setBounds(314, 75, 129, 16);
        this.btnOnlyShowMaster.setText("only show master");
        this.btnOnlyShowMaster.setSelection(settings.getBoolean("ONLY_SHOW_MASTER"));
    }

    private void addSrcWidgetListeners() {
        this.cvSrcProject.getCombo().addModifyListener(modifyEvent -> this.proposeRepositories());
        this.cvSrcRepository.getCombo().addModifyListener(modifyEvent -> this.checkRepoAndProposeBranches());
        this.cvSrcRepository.getCombo().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                MultiCherryPickPage.this.setMessage("Choose your source repository");
            }

            public void focusLost(FocusEvent e) {
                if (MultiCherryPickPage.this.cvSrcBranch.getCombo().getText().length() != 0) {
                    MultiCherryPickPage.this.checkBranch();
                }
            }
        });
        this.cvSrcBranch.getCombo().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                MultiCherryPickPage.this.setMessage("Choose your source branch");
            }

            public void focusLost(FocusEvent e) {
                String featureByBranch;
                if (MultiCherryPickPage.this.cvSrcBranch.getCombo().getText().length() != 0 && MultiCherryPickPage.this.checkBranch() && (featureByBranch = MultiCherryPickPage.this.getFeatureText(MultiCherryPickPage.this.cvSrcBranch.getCombo().getText())) != null) {
                    MultiCherryPickPage.this.setTxtFeatureText(featureByBranch);
                }
            }
        });
        this.txtSrcFeature.addModifyListener(modifyEvent -> {
            if (this.cvSrcBranch.getCombo().getText().length() != 0) {
                this.checkBranch();
                this.cherryPickSettings.setSourceIssue(this.txtSrcFeature.getText());
                this.btnRunTarget.setEnabled(false);
            }
        });
        this.txtSrcFeature.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                MultiCherryPickPage.this.setMessage("Type your feature to pick");
            }

            public void focusLost(FocusEvent e) {
                String features_string = MultiCherryPickPage.this.txtSrcFeature.getText();
                features_string = features_string.replaceAll("\\s", "");
                String[] features = features_string.split(",");
                MultiCherryPickPage.this.setInfoText("");
                String[] stringArray = features;
                int n = features.length;
                int n2 = 0;
                while (n2 < n) {
                    String feature = stringArray[n2];
                    if (!MultiCherryPickPage.this.causedIssues.containsKey(feature)) {
                        MultiCherryPickPage.this.fillCausedIssues(feature);
                    }
                    ++n2;
                }
                MultiCherryPickPage.this.printCausedIssues(features);
            }
        });
        KeyListener projectKeyListener = this.createKeyListener(this.cvSrcProject);
        this.cvSrcProject.getCombo().addKeyListener(projectKeyListener);
        KeyListener repositoryKeyListener = this.createKeyListener(this.cvSrcRepository);
        this.cvSrcRepository.getCombo().addKeyListener(repositoryKeyListener);
        KeyListener branchKeyListener = this.createKeyListener(this.cvSrcBranch);
        this.cvSrcBranch.getCombo().addKeyListener(branchKeyListener);
        this.cvSrcBranch.getCombo().addModifyListener(modifyListener -> {
            String featureByBranch;
            if (this.cvSrcBranch.getCombo().getText().length() != 0 && this.checkBranch() && (featureByBranch = this.getFeatureText(this.cvSrcBranch.getCombo().getText())) != null) {
                this.setTxtFeatureText(featureByBranch);
            }
        });
    }

    private void printCausedIssues(String[] features) {
        this.infoList.removeAll();
        List<String> featuresList = Arrays.asList(features);
        String[] stringArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            String causesIssue = stringArray[n2];
            List<String> caused = this.causedIssues.get(causesIssue);
            for (String causedIssue : caused) {
                if (featuresList.contains(causedIssue)) continue;
                String line = "The issue " + causesIssue + " causes the following issue " + causedIssue;
                this.infoList.add(line);
                this.infoList.moveAbove((Control)this.infoLabel);
            }
            ++n2;
        }
    }

    private KeyListener createKeyListener(final ComboViewer viewer) {
        return new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                String currentInput = viewer.getCombo().getText();
                String inputFilter = ((PrefixMatchFilter)viewer.getFilters()[0]).getInput();
                if (currentInput.length() < inputFilter.length() || Character.isDigit(e.character) || Character.isAlphabetic(e.character)) {
                    if (e.keyCode == 27) {
                        ((PrefixMatchFilter)viewer.getFilters()[0]).setInput("");
                        currentInput = "";
                    } else {
                        ((PrefixMatchFilter)viewer.getFilters()[0]).setInput(currentInput);
                    }
                    viewer.refresh(true);
                    viewer.getCombo().setListVisible(e.keyCode != 27);
                    viewer.getCombo().setText(currentInput);
                    viewer.getCombo().setSelection(new Point(currentInput.length(), currentInput.length()));
                }
            }
        };
    }

    private void addTargetWidgetListeners() {
        this.txtTargetBranchPoint.addModifyListener(modifyEvent -> {
            if (this.txtTargetBranchPoint.getText().length() != 0) {
                this.cherryPickSettings.setTargetBranchPoint(this.txtTargetBranchPoint.getText());
                this.btnRunTarget.setEnabled(false);
            }
        });
        this.txtTargetBranchPoint.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                MultiCherryPickPage.this.setMessage("Type your new branch point");
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.btnRunTest.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiCherryPickPage.this.display.asyncExec(() -> MultiCherryPickPage.this.runTest());
            }
        });
        this.btnRunTarget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiCherryPickPage.this.display.asyncExec(() -> MultiCherryPickPage.this.runTarget());
            }
        });
        this.infoList.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                int[] selections;
                int[] nArray = selections = MultiCherryPickPage.this.infoList.getSelectionIndices();
                int n = selections.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    String[] caused = MultiCherryPickPage.this.infoList.getItem(i).split(" ");
                    String causedIssue = caused[caused.length - 1];
                    String features = MultiCherryPickPage.this.txtSrcFeature.getText();
                    features = String.valueOf(features) + "," + causedIssue;
                    MultiCherryPickPage.this.setTxtFeatureText(features);
                    ++n2;
                }
            }
        });
    }

    private final String encodeText(String text) throws Exception {
        int[] offsets = new int[]{47, 28, 36, 28, 122, 26, 32, 42, 73, 109, 50, 64, 89, 85, 83, 40};
        byte[] text_bytes = text.getBytes(StandardCharsets.UTF_8);
        int offset_index = 0;
        int i = 0;
        while (i < text_bytes.length) {
            int utf_char = text_bytes[i] - 32 + offsets[offset_index];
            utf_char = utf_char % 95 + 32;
            text_bytes[i] = (byte)utf_char;
            offset_index = (offset_index + 1) % offsets.length;
            ++i;
        }
        String newText = new String(text_bytes, StandardCharsets.UTF_8);
        String finalText = "";
        int i2 = 0;
        while (i2 < newText.length()) {
            char c = newText.charAt(i2);
            if (Character.toString(c).equals("\"")) {
                finalText = String.valueOf(finalText) + "\\";
            }
            finalText = String.valueOf(finalText) + Character.toString(c);
            ++i2;
        }
        return finalText;
    }

    private void setTxtFeatureText(String text) {
        this.txtSrcFeature.setText(text);
        this.txtSrcFeature.setFocus();
        this.getShell().setFocus();
    }

    public boolean runTarget() {
        MultiCherryPickCredentialsPage credentialPage = new MultiCherryPickCredentialsPage(this.getShell());
        credentialPage.open();
        String user = credentialPage.getUser();
        String password = credentialPage.getPassword();
        String encPassword = "";
        String encUser = "";
        try {
            encPassword = this.encodeText(password);
            encUser = this.encodeText(user);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.cvSrcBranch.getCombo().setEnabled(false);
        this.display.syncExec(() -> this.disableAll());
        List<String> command = null;
        try {
            command = this.createCommand();
        }
        catch (Exception e) {
            this.setInfoText("Not all fields set!");
            this.enableAll();
            return false;
        }
        command.add("-r");
        command.add("target");
        command.add("-u");
        command.add(encUser);
        command.add("-p");
        command.add(encPassword);
        this.setInfoText("Cherry Pick Issues:");
        boolean result = this.run_command(command);
        this.display.syncExec(() -> this.enableAll());
        return result;
    }

    private void runTest() {
        this.cvSrcBranch.getCombo().setEnabled(false);
        this.display.syncExec(() -> this.disableAll());
        List<String> command = null;
        try {
            command = this.createCommand();
        }
        catch (Exception e) {
            this.setInfoText("Not all fields set!");
            this.enableAll();
        }
        command.add("-r");
        command.add("test");
        command.add("-u");
        command.add("None");
        command.add("-p");
        command.add("None");
        this.setInfoText("Testrun:");
        boolean result = this.run_command(command);
        this.btnRunTarget.setEnabled(result);
        this.display.syncExec(() -> this.enableAll());
    }

    private void fillCausedIssues(String issue) {
        LinkedList<String> command = new LinkedList<String>();
        command.add("python");
        command.add("-m");
        command.add("pa_common.pds_functions.jira_issue_links");
        command.add("-i");
        command.add(issue);
        command.add("-l");
        command.add("INFO");
        List<String> caused = this.getCausedIssues(command, issue);
        this.causedIssues.put(issue, caused);
    }

    private List<String> getCausedIssues(List<String> command, String issue) {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(command);
        LinkedList<String> caused = new LinkedList<String>();
        try {
            String line;
            Process p = builder.start();
            InputStream inputStream = p.getErrorStream();
            BufferedReader bufRead = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = bufRead.readLine()) != null) {
                if (!line.contains("INFO") && !line.contains("ERROR") || !line.contains(issue)) continue;
                String[] splitLine = line.split(" ");
                String causedIssue = splitLine[2];
                caused.add(causedIssue);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return caused;
    }

    private boolean run_command(List<String> command) {
        boolean result = false;
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(command);
        try {
            String line;
            Process p = builder.start();
            InputStream inputStream = p.getErrorStream();
            BufferedReader bufRead = new BufferedReader(new InputStreamReader(inputStream));
            String pythonOutput = "";
            boolean pythonHasLogged = false;
            while ((line = bufRead.readLine()) != null) {
                pythonOutput = String.valueOf(pythonOutput) + "\n" + line;
                if (!line.contains("INFO") && !line.contains("ERROR")) continue;
                pythonHasLogged = true;
                String text = this.infoLabel.getText();
                String textLine = line;
                this.display.syncExec(() -> this.setInfoText(String.valueOf(text) + "\n" + textLine));
                if (!line.contains("Cherry Pick Finished")) continue;
                result = true;
            }
            if (!pythonHasLogged) {
                String info = "Following command has failed:";
                info = String.valueOf(info) + "\n" + this.commandToString(command);
                info = String.valueOf(info) + "\n" + pythonOutput;
                this.setInfoText(info);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void setInfoText(String text) {
        this.infoLabel.setText(text);
        this.scrolledComposite.setMinSize(this.infoLabel.computeSize(-1, -1));
        this.infoLabel.moveAbove((Control)this.infoList);
        this.display.update();
    }

    private String commandToString(List<String> command) {
        String outputCommand = "";
        for (String commandArgument : command) {
            outputCommand = String.valueOf(outputCommand) + " " + commandArgument;
        }
        return outputCommand;
    }

    public List<String> createCommand() {
        String gitServerPath = com.proalpha.pds.paconnector.Activator.getDefault().getPreferenceStore().getString("PaGitServerUrl");
        if (!gitServerPath.endsWith("/")) {
            gitServerPath = String.valueOf(gitServerPath) + '/';
        }
        String source_repo = String.valueOf(gitServerPath) + "scm/";
        String settings_target_branch = this.cherryPickSettings.getTargetBranchPoint();
        String[] settings_target_branch_split = settings_target_branch.split("/");
        String target_remote = settings_target_branch_split[0];
        String target_branch = settings_target_branch_split[1];
        String source_branch = this.cherryPickSettings.getSourceBranch();
        source_repo = String.valueOf(source_repo) + this.cherryPickSettings.getSourceRepoString();
        String issues_no_spaces = this.txtSrcFeature.getText().replaceAll("\\s", "");
        String work_space = this.targetRepository.getDirectory().getParent();
        String[] issues = issues_no_spaces.split(",");
        LinkedList<String> command = new LinkedList<String>();
        command.add("python");
        command.add("-m");
        command.add("pa_common.pds_functions.cherry_pick_issues");
        command.add("-tr");
        command.add(target_remote);
        command.add("-tb");
        command.add(target_branch);
        command.add("-sr");
        command.add(source_repo);
        command.add("-sb");
        command.add(source_branch);
        command.add("-w");
        command.add(work_space);
        command.add("-l");
        command.add("info");
        command.add("-i");
        String[] stringArray = issues;
        int n = issues.length;
        int n2 = 0;
        while (n2 < n) {
            String issue = stringArray[n2];
            command.add(issue);
            ++n2;
        }
        return command;
    }

    private void addButtonWidgetListeners() {
        this.btnOnlyShowMaster.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IDialogSettings settings = MultiCherryPickPage.this.getDialogSettings();
                settings.put("ONLY_SHOW_MASTER", MultiCherryPickPage.this.btnOnlyShowMaster.getSelection());
                MultiCherryPickPage.this.checkRepoAndProposeBranches();
            }
        });
    }

    private List<GitServerRepository> getServerRepositories() {
        BitbucketRestCallGetRepoList restcall = new BitbucketRestCallGetRepoList();
        restcall.setSubUrl("repos");
        restcall.execute();
        ArrayList serverRepositories = (ArrayList)restcall.getRestResponse();
        if (serverRepositories == null || serverRepositories.isEmpty()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"An unexpeted error occurred when trying to get list of repositories from the server.");
        }
        return serverRepositories;
    }

    private String getFeatureText(String branchText) {
        Pattern p = Pattern.compile("(.*\\.)?(" + PaGitConfig.getStringFromConfig("issue_key_format") + ")$");
        Matcher m = p.matcher(branchText);
        if (m.find()) {
            return m.group(2);
        }
        return null;
    }

    private boolean checkBranch() {
        boolean foundIt = false;
        String srcBranchName = this.cvSrcBranch.getCombo().getText();
        this.setMessage(null, 1);
        this.setErrorMessage(null);
        if (srcBranchName.length() == 0) {
            return false;
        }
        String projectname = this.cvSrcProject.getCombo().getText();
        String repoName = this.cvSrcRepository.getCombo().getText();
        for (GitServerRepository repository : this.currRepos) {
            if (repository.getProject().equals(projectname) && repository.getName().equals(repoName)) {
                for (String actBranch : repository.getBranches()) {
                    if (!actBranch.equals(srcBranchName)) continue;
                    foundIt = true;
                }
            }
            if (foundIt) break;
        }
        if (!foundIt) {
            this.setMessage("Branch not found!", 2);
            return false;
        }
        this.cherryPickSettings.setSourceBranch(srcBranchName);
        this.btnRunTarget.setEnabled(false);
        return true;
    }

    protected void checkRepoAndProposeBranches() {
        boolean foundIt = false;
        this.setMessage(null, 1);
        this.setErrorMessage(null);
        String projectname = this.cvSrcProject.getCombo().getText();
        String repoName = this.cvSrcRepository.getCombo().getText();
        for (GitServerRepository repository : this.currRepos) {
            if (!repository.getProject().equals(projectname) || !repository.getName().equals(repoName)) continue;
            List<String> allBranches = repository.getBranches();
            Collections.sort(allBranches);
            String[] branches = (String[])allBranches.stream().toArray(String[]::new);
            if (this.btnOnlyShowMaster.getSelection()) {
                branches = this.filterMasterBranches(branches);
            }
            this.cvSrcBranch.setInput((Object)branches);
            foundIt = true;
            break;
        }
        if (!foundIt) {
            this.setMessage("Repository not found!", 2);
            this.cvSrcBranch.setInput((Object)new String[0]);
            return;
        }
        this.cherryPickSettings.setSourceRepoString(projectname, repoName);
        this.btnRunTarget.setEnabled(false);
    }

    protected void proposeRepositories() {
        String projectname = this.cvSrcProject.getCombo().getText();
        if (!this.projectRepositoryMap.containsKey(projectname)) {
            this.setMessage("Project not found!", 2);
            this.cvSrcRepository.setInput((Object)new String[0]);
            return;
        }
        Set<String> repoSet = this.projectRepositoryMap.get(projectname);
        Object[] repos = new String[repoSet.size()];
        repoSet.toArray(repos);
        Arrays.sort(repos);
        this.cvSrcRepository.setInput((Object)repos);
        this.btnRunTarget.setEnabled(false);
    }

    private Map<String, Set<String>> fillProjectRepositoryMap() {
        this.projectRepositoryMap = new HashMap<String, Set<String>>();
        for (GitServerRepository repository : this.currRepos) {
            Set<String> repositoriesForProject = this.projectRepositoryMap.get(repository.getProject());
            if (repositoriesForProject != null) {
                repositoriesForProject.add(repository.getName());
                continue;
            }
            String projectName = repository.getProject();
            String repositoryName = repository.getName();
            HashSet<String> repositories = new HashSet<String>();
            repositories.add(repositoryName);
            this.projectRepositoryMap.put(projectName, repositories);
        }
        return this.projectRepositoryMap;
    }

    private String[] filterMasterBranches(String[] branches) {
        ArrayList<String> masterBranches = new ArrayList<String>();
        String[] stringArray = branches;
        int n = branches.length;
        int n2 = 0;
        while (n2 < n) {
            String branch = stringArray[n2];
            if (branch.contains("master")) {
                masterBranches.add(branch);
            }
            ++n2;
        }
        String[] masterArray = new String[masterBranches.size()];
        masterBranches.toArray(masterArray);
        return masterArray;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings dialogSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(PAGE_NAME);
        if (section == null) {
            section = dialogSettings.addNewSection(PAGE_NAME);
        }
        return section;
    }
}

