/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.pagit.util.bitbucket;

import com.google.api.client.http.BasicAuthentication;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.proalpha.pds.pagit.PaGitConfig;
import com.proalpha.pds.pagit.util.WindowsCredentials;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BitbucketRestCall<T> {
    private final Logger logger = LoggerFactory.getLogger(BitbucketRestCall.class);
    private final String baseUrl = PaGitConfig.getStringFromConfig("bitbucket.server");
    private final String apiPath = PaGitConfig.getStringFromConfig("bitbucket.api_path");
    private final String accessToken = PaGitConfig.getStringFromConfig("bitbucket.legacy_bearer_token");
    private static final Integer PAGE_SIZE = 100;
    private T restResponse;
    private Boolean isCloud = false;
    private String subUrl;
    private Integer startEntry = 0;

    public T getRestResponse() {
        return this.restResponse;
    }

    public String getSubUrl() {
        return this.subUrl;
    }

    public void setSubUrl(String subUrl) {
        this.subUrl = subUrl;
    }

    public Integer getStartEntry() {
        return this.startEntry;
    }

    public void setStartEntry(Integer startEntry) {
        this.startEntry = startEntry;
    }

    public BitbucketRestCall() {
        if (this.baseUrl.contains("bitbucket.org")) {
            this.isCloud = true;
            this.startEntry = 1;
        }
    }

    public void execute() {
        URL url = this.buildUrl();
        try {
            NetHttpTransport httpTransport = new NetHttpTransport();
            HttpRequestFactory requestFactory = httpTransport.createRequestFactory();
            HttpRequest request = requestFactory.buildGetRequest(new GenericUrl(url));
            if (this.isCloud.booleanValue()) {
                String username = System.getenv(PaGitConfig.getStringFromConfig("bitbucket.env_vars.auth_username"));
                String password = System.getenv(PaGitConfig.getStringFromConfig("bitbucket.env_vars.auth_password"));
                if (username == null || username.isEmpty() || password == null || password.isEmpty()) {
                    WindowsCredentials creds = new WindowsCredentials(PaGitConfig.getStringFromConfig("bitbucket.windows_cred_manager_credential"));
                    username = creds.getGenericUsername();
                    password = creds.getGenericPassword();
                }
                if (username.isEmpty() || password.isEmpty()) {
                    throw new Exception("Unable to locate Bitbucket credentials\nThere are two ways to fix this:\n" + String.format("1. Set environment variables %s and %s with your email and API token\n", PaGitConfig.getStringFromConfig("bitbucket.env_vars.auth_username"), PaGitConfig.getStringFromConfig("bitbucket.env_vars.auth_password")) + String.format("2. Set %s as a generic credential (Generische Anmeldeinformationen) ", PaGitConfig.getStringFromConfig("bitbucket.windows_cred_manager_credential")) + "in the Windows Credential Manager (Anmeldeinformationsverwaltung) with your email and API token (This is the preferred way for a developer.) " + "See https://proalpha.atlassian.net/l/cp/4YmjB1hH#Aramis:InstallationInstructions-Credentials_Manager for more details.");
                }
                BasicAuthentication auth = new BasicAuthentication(username, password);
                auth.initialize(request);
            } else {
                final String token = this.accessToken;
                request.setInterceptor(new HttpExecuteInterceptor(){

                    public void intercept(HttpRequest req) {
                        req.getHeaders().setAuthorization("Bearer " + token);
                    }
                });
            }
            HttpResponse response = request.execute();
            Throwable throwable = null;
            Object var7_9 = null;
            try (InputStream in = response.getContent();){
                this.restResponse = this.parseRestResponse(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
        }
    }

    private URL buildUrl() {
        StringBuilder sb = new StringBuilder(this.baseUrl);
        sb.append(this.apiPath);
        sb.append(this.subUrl);
        if (this.isCloud.booleanValue()) {
            sb.append("?pagelen=");
            sb.append(PAGE_SIZE);
            sb.append("&page=");
            sb.append(this.startEntry);
        } else {
            sb.append("?limit=");
            sb.append(PAGE_SIZE);
            sb.append("&start=");
            sb.append(this.startEntry);
        }
        URL url = null;
        try {
            url = new URL(sb.toString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
        }
        return url;
    }

    protected abstract T parseRestResponse(InputStream var1) throws IOException;
}

