/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.paconnector;

import com.openedge.core.runtime.IAVMClient;
import com.openedge.core.runtime.IAVMRuntimeListener;
import com.openedge.core.runtime.IPropath;
import com.openedge.pdt.project.OEProject;
import com.proalpha.pds.paconnector.Activator;
import com.proalpha.pds.paconnector.PaPreference;
import com.proalpha.pds.paconnector.PaVersion;
import com.proalpha.pds.paconnector.PaVersionParser;
import com.proalpha.pds.paconnector.RunCommonPaProgram;
import com.proalpha.pds.paconnector.exception.ProALPHANotAvailableException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaProject {
    private static final Logger logger = LoggerFactory.getLogger(PaProject.class);
    private static final String PLUGIN_ID = Activator.getDefault().getBundle().getSymbolicName();
    private final OEProject oeProject;
    private IAVMRuntimeListener avmRuntimeListener;
    private String customLevel = "";
    private String codepage;
    private String wrkDir;
    private String tstDir;
    private int rayPort;
    private PaVersion version;
    private IPropath propath;
    private IPath bridgePath;
    private boolean available;
    private RunCommonPaProgram bridge;

    public PaProject(OEProject oeProject) {
        this.oeProject = oeProject;
        this.available = false;
        this.avmRuntimeListener = new AVMRuntimeListener();
        this.oeProject.getRuntime().addAVMRuntimeListener(this.avmRuntimeListener);
    }

    public IPropath getPropath() {
        return this.propath;
    }

    public RunCommonPaProgram getBridge() {
        return this.bridge;
    }

    public void setPropath(IPropath propath) {
        this.propath = propath;
    }

    public IPath getBridgePath() {
        return this.bridgePath;
    }

    public void setBridgePath(IPath bridgePath) {
        this.bridgePath = bridgePath;
    }

    public String getCodepage() {
        return this.codepage;
    }

    public void setCodepage(String codepage) {
        this.codepage = codepage;
    }

    public PaVersion getVersion() {
        return this.version;
    }

    public void setVersion(PaVersion version) {
        this.version = version;
    }

    public void setVersion(String version) {
        try {
            this.version = PaVersionParser.parseVersionString(version);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public String getWrkdir() {
        return this.wrkDir;
    }

    public void setWrkdir(String wrkdir) {
        this.wrkDir = wrkdir;
    }

    public String getTstDir() {
        return this.tstDir;
    }

    public void setTstDir(String tstDir) {
        this.tstDir = tstDir;
    }

    public int getRayPort() {
        return this.rayPort;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        if (!available) {
            this.bridge = null;
        }
        this.available = available;
    }

    public OEProject getOeProject() {
        return this.oeProject;
    }

    public String getCustomLevel() {
        return this.customLevel;
    }

    public void setCustomLevel(String customLevel) {
        this.customLevel = customLevel;
    }

    public void setRayPort(int rayPort) {
        this.rayPort = rayPort;
    }

    public String getName() {
        return this.getOeProject().getProject().toString();
    }

    public String toString() {
        return "proALPHA Project: " + this.getName();
    }

    public List<PaPreference> loadPaPrefs() {
        ProjectScope ctxt = new ProjectScope(this.getOeProject().getProject());
        IEclipsePreferences prefs = ctxt.getNode(PLUGIN_ID);
        ArrayList<PaPreference> paPrefs = new ArrayList<PaPreference>();
        try {
            String[] stringArray = prefs.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String pakey = stringArray[n2];
                PaPreference tmpPref = new PaPreference(pakey, prefs.get(pakey, ""));
                paPrefs.add(tmpPref);
                ++n2;
            }
            return paPrefs;
        }
        catch (BackingStoreException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new ArrayList<PaPreference>();
        }
    }

    public boolean savePaPref(String name, String value) {
        ProjectScope ctxt = new ProjectScope(this.getOeProject().getProject());
        IEclipsePreferences prefs = ctxt.getNode(PLUGIN_ID);
        if (name == null || value == null || prefs == null) {
            return false;
        }
        prefs.put(name, value);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            return false;
        }
        return true;
    }

    public void dispose() {
        if (this.avmRuntimeListener != null) {
            this.oeProject.getRuntime().removeAVMRuntimeListener(this.avmRuntimeListener);
            this.avmRuntimeListener = null;
        }
    }

    private class AVMRuntimeListener
    implements IAVMRuntimeListener {
        private AVMRuntimeListener() {
        }

        public void runtimeStarted(IAVMClient runtime) {
            logger.info("Runtime of project {} started", (Object)PaProject.this.getName());
            PaProject.this.setAvailable(false);
        }

        public void runtimeStopped(IAVMClient runtime) {
            logger.info("Runtime of project {} stopped", (Object)PaProject.this.getName());
            PaProject.this.setAvailable(false);
        }

        public void runtimeShutdown(IAVMClient rutime) {
            logger.info("Runtime of project {} shut down", (Object)PaProject.this.getName());
            PaProject.this.setAvailable(false);
        }

        public void runtimeInitialized(IAVMClient runtime) {
            logger.info("Runtime of project {} initialized", (Object)PaProject.this.getName());
        }

        public void runtimeAvailable(IAVMClient runtime) {
            logger.info("Runtime of project {} available", (Object)PaProject.this.getName());
            try {
                PaProject.this.bridge = new RunCommonPaProgram(PaProject.this);
            }
            catch (ProALPHANotAvailableException e) {
                e.printStackTrace();
            }
        }
    }
}

