/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.paconnector;

import com.proalpha.pds.paconnector.PaVersionComparator;

public class PaVersion {
    private static final PaVersionComparator comparator = new PaVersionComparator();
    private int majorVersionNo = 0;
    private int minorVersionNo = 0;
    private int patchNo = 0;
    private char patchChar = '\u0000';
    private int buildNo = 0;

    public PaVersion() {
    }

    public PaVersion(int majorVersionNo) {
        this.setMajorVersionNo(majorVersionNo);
    }

    public PaVersion(int majorVersionNo, int minorVersionNo) {
        this(majorVersionNo);
        this.setMinorVersionNo(minorVersionNo);
    }

    public PaVersion(int majorVersionNo, int minorVersionNo, int patchNo) {
        this(majorVersionNo, minorVersionNo);
        this.setPatchNo(patchNo);
    }

    public PaVersion(int majorVersionNo, int minorVersionNo, char patchChar) {
        this(majorVersionNo, minorVersionNo);
        this.setPatchChar(patchChar);
    }

    public PaVersion(int majorVersionNo, int minorVersionNo, int patchNo, int buildNo) {
        this(majorVersionNo, minorVersionNo, patchNo);
        this.setBuildNo(buildNo);
    }

    public PaVersion(int majorVersionNo, int minorVersionNo, char patchChar, int buildNo) {
        this(majorVersionNo, minorVersionNo, patchChar);
        this.setBuildNo(buildNo);
    }

    public int getMajorVersionNo() {
        return this.majorVersionNo;
    }

    public void setMajorVersionNo(int majorVersionNo) {
        this.majorVersionNo = majorVersionNo;
    }

    public int getMinorVersionNo() {
        return this.minorVersionNo;
    }

    public void setMinorVersionNo(int minorVersionNo) {
        this.minorVersionNo = minorVersionNo;
    }

    public int getPatchNo() {
        return this.patchNo;
    }

    public void setPatchNo(int patchNo) {
        this.patchNo = patchNo;
        int byteRefrence = 97;
        this.patchChar = (char)(byteRefrence + patchNo - 1);
    }

    public char getPatchChar() {
        return this.patchChar;
    }

    public void setPatchChar(char patchChar) {
        this.patchChar = patchChar;
        byte patchByte = (byte)Character.toLowerCase(patchChar);
        int byteRefrence = 97;
        this.patchNo = patchByte - byteRefrence + 1;
    }

    public int getBuildNo() {
        return this.buildNo;
    }

    public void setBuildNo(int buildNo) {
        this.buildNo = buildNo;
    }

    public String toString() {
        if (this.majorVersionNo >= 9) {
            return String.format("%d.%d.%d", this.majorVersionNo, this.minorVersionNo, this.patchNo);
        }
        if (this.patchChar != '\u0000' || this.buildNo > 0) {
            return String.format("%d.%d%s%02d", this.majorVersionNo, this.minorVersionNo, Character.valueOf(this.patchChar), this.buildNo);
        }
        return String.format("%d.%d", this.majorVersionNo, this.minorVersionNo);
    }

    public boolean equals(Object other) {
        if (other instanceof PaVersion) {
            return comparator.compare(this, (PaVersion)other) == 0;
        }
        return super.equals(other);
    }

    public boolean isLowerThan(PaVersion other) {
        return comparator.compare(this, other) < 0;
    }

    public boolean isLowerOrEqualThan(PaVersion other) {
        return comparator.compare(this, other) <= 0;
    }

    public boolean isHigherThan(PaVersion other) {
        return comparator.compare(this, other) > 0;
    }

    public boolean isHigherOrEqualThan(PaVersion other) {
        return comparator.compare(this, other) >= 0;
    }
}

