/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.paconnector.utils;

import com.proalpha.pds.paconnector.parameter.CustomLevel;
import com.proalpha.pds.paconnector.repository.RepositoryInformations;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class PaOOABLUtil {
    private static final String CLASS_SUFFIX = ".cls";
    private static final Set<String> CUSTOM_CLASS_SUFFIXES = new HashSet<String>();
    private static final Set<String> SINGLETON_INTERFACE_NAMES = new HashSet<String>(Arrays.asList("DMISingletonFrw"));
    private static final String DI_SERVICE_CLASS = "DMCDISvc.cls";

    static {
        CustomLevel[] customLevelArray = CustomLevel.values();
        int n = customLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            CustomLevel customLevel = customLevelArray[n2];
            CUSTOM_CLASS_SUFFIXES.add(String.valueOf(customLevel.getClassSuffix()) + CLASS_SUFFIX);
            ++n2;
        }
    }

    public static String getParentClassForDIClass(RepositoryInformations repositoryInformations, CustomLevel sessionCustomLevel, String mainClassName, String className) {
        if (className.equals(mainClassName)) {
            return "";
        }
        CustomLevel[] customLevels = CustomLevel.values();
        CustomLevel mainClassCustomLevel = CustomLevel.getByIdentChar(mainClassName.substring(0, 1));
        int customLevelCounter = customLevels.length - 1;
        while (customLevelCounter >= 0) {
            CustomLevel customLevel = customLevels[customLevelCounter];
            if (!customLevel.isHigherOrEqualThan(sessionCustomLevel)) {
                if (customLevel.isLowerThan(mainClassCustomLevel)) break;
                String customLevelClassName = mainClassName.concat(customLevel.getClassSuffix());
                if (repositoryInformations.existsInstanceInRepository(customLevelClassName.concat(CLASS_SUFFIX)).booleanValue()) {
                    return customLevelClassName;
                }
            }
            --customLevelCounter;
        }
        return mainClassName;
    }

    public static boolean useDIFramework(RepositoryInformations repositoryInformations) {
        return repositoryInformations != null && repositoryInformations.existsInstanceInRepository(DI_SERVICE_CLASS) != false;
    }

    public static boolean useDIFramework(RepositoryInformations repositoryInformations, String className) {
        if (repositoryInformations == null) {
            return false;
        }
        String baseClassName = PaOOABLUtil.getBaseClassName(repositoryInformations, className);
        if (repositoryInformations.existsInstanceInRepository(String.valueOf(baseClassName) + CustomLevel.STANDARD.getClassSuffix() + CLASS_SUFFIX).booleanValue()) {
            return false;
        }
        return PaOOABLUtil.useDIFramework(repositoryInformations);
    }

    public static String getBaseClassName(RepositoryInformations repositoryInformations, String className) {
        className = PaOOABLUtil.removeClassSuffix(className);
        CustomLevel[] customLevelArray = CustomLevel.values();
        int n = customLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            CustomLevel customLevel = customLevelArray[n2];
            if (className.endsWith(customLevel.getClassSuffix())) {
                String baseClassName = className.substring(0, className.length() - customLevel.getClassSuffix().length());
                if (repositoryInformations == null || repositoryInformations.existsInstanceInRepository(baseClassName).booleanValue()) {
                    return baseClassName;
                }
            }
            ++n2;
        }
        return className;
    }

    public static String removeClassSuffix(String className) {
        return PaOOABLUtil.removeClassSuffix(className, CLASS_SUFFIX);
    }

    public static String removeCustomClassSuffix(String className) {
        for (String suffix : CUSTOM_CLASS_SUFFIXES) {
            if (!className.endsWith(suffix)) continue;
            return className.substring(0, className.length() - suffix.length());
        }
        return PaOOABLUtil.removeClassSuffix(className);
    }

    public static String removeClassSuffix(String className, String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            return className;
        }
        if (!className.endsWith(suffix)) {
            return className;
        }
        className = className.substring(0, className.length() - suffix.length());
        return className;
    }

    public static String addClassSuffix(String className) {
        return PaOOABLUtil.addClassSuffix(className, CLASS_SUFFIX);
    }

    public static String addClassSuffix(String className, CustomLevel customLevel) {
        if (customLevel == null) {
            return className;
        }
        return PaOOABLUtil.addClassSuffix(className, String.valueOf(customLevel.getClassSuffix()) + CLASS_SUFFIX);
    }

    public static String addClassSuffix(String className, String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            return className;
        }
        if (className.endsWith(suffix)) {
            return className;
        }
        return String.valueOf(className) + suffix;
    }

    public static String getQualifiedClassName(String classPackage, String className) {
        return classPackage == null || classPackage.isEmpty() ? className : String.valueOf(classPackage) + "." + className;
    }

    public static String getClassNameFromQualifiedName(String className) {
        return className.substring(className.lastIndexOf(46) + 1);
    }

    public static String getPackageFromQualifiedName(String className) {
        int lastIndex = className.lastIndexOf(46);
        if (lastIndex > 0) {
            return className.substring(0, lastIndex);
        }
        return "";
    }

    public static boolean isInterface(String className) {
        char indicatorChar = (className = PaOOABLUtil.getClassNameFromQualifiedName(className)).charAt(2);
        return indicatorChar == 'I' || indicatorChar == 'i';
    }

    public static boolean isSingletonInterface(String interfaceName) {
        return SINGLETON_INTERFACE_NAMES.contains(PaOOABLUtil.getClassNameFromQualifiedName(interfaceName));
    }

    public static boolean isSingletonClass(Set<String> implementedInterfaces) {
        if (implementedInterfaces == null) {
            return false;
        }
        for (String interfaceName : implementedInterfaces) {
            if (!PaOOABLUtil.isSingletonInterface(interfaceName)) continue;
            return true;
        }
        return false;
    }
}

