/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.generator;

import com.proalpha.pds.paconnector.PaProject;
import com.proalpha.pds.paconnector.RunProgramInPa;
import com.proalpha.pds.paconnector.exception.PaProgramNotFoundException;
import com.proalpha.pds.paconnector.exception.ProALPHANotAvailableException;
import com.proalpha.pds.templates.data.IGeneratorDataContainer;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class DIConfigGenerator {
    private static final String AddClassBindingToDIConfigProcedurePathName = "resources/di/AddClassBindingToDIConfig.p";
    private static File AddClassBindingToDIConfigProcedureFile = null;
    private final IGeneratorDataContainer dataContainer;

    public DIConfigGenerator(IGeneratorDataContainer dataContainer) throws PaProgramNotFoundException {
        this.dataContainer = dataContainer;
        if (AddClassBindingToDIConfigProcedureFile == null) {
            AddClassBindingToDIConfigProcedureFile = this.getAddClassBindingToDIConfigProcedureResource();
        }
    }

    public void generate() throws ProALPHANotAvailableException {
        this.addClassToDIConfig(this.dataContainer.getPaProject(), this.dataContainer.getQualifiedMainClassName(), this.dataContainer.getQualifiedClassName());
    }

    private void addClassToDIConfig(PaProject paProject, String baseClass, String targetClass) throws ProALPHANotAvailableException {
        if (paProject == null) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"No Project", (String)"No proALPHA project found");
            return;
        }
        if (!paProject.isAvailable()) {
            throw new ProALPHANotAvailableException();
        }
        RunProgramInPa runPaProgram = new RunProgramInPa(paProject);
        runPaProgram.runExternalProcedure(AddClassBindingToDIConfigProcedureFile.getAbsolutePath(), new String[]{baseClass, targetClass});
    }

    private File getAddClassBindingToDIConfigProcedureResource() throws PaProgramNotFoundException {
        Bundle bundle = Platform.getBundle((String)"com.proalpha.pds.templates");
        Path procedurePath = new Path(AddClassBindingToDIConfigProcedurePathName);
        URL procedureLocation = FileLocator.find((Bundle)bundle, (IPath)procedurePath, null);
        try {
            procedureLocation = FileLocator.toFileURL((URL)procedureLocation);
        }
        catch (IOException e) {
            throw new PaProgramNotFoundException("com.proalpha.pds.templates", AddClassBindingToDIConfigProcedurePathName);
        }
        return new File(procedureLocation.getFile()).getAbsoluteFile();
    }
}

