
/*------------------------------------------------------------------------
    File        : AddClassBindingToDIConfig.p
    Purpose     : 

    Syntax      :

    Description : 

    Author(s)   : Thiemann_M
    Created     : Thu May 16 09:13:47 CEST 2024
    Notes       :
  ----------------------------------------------------------------------*/

/* ***************************  Definitions  ************************** */

block-level on error undo, throw.

using Progress.Json.ObjectModel.JsonObject.
using Progress.Json.ObjectModel.JsonArray.
using Progress.Json.ObjectModel.ObjectModelParser.
using adm.method.cls.DMCOpSysSvc.

/* ********************  Preprocessor Definitions  ******************** */

/* ************************  Function Prototypes ********************** */

function oGetBindingEntryOrNull returns JsonObject 
  (poBindingArray as JsonArray,
   pcBaseClass    as character) forward.

/* ***************************  Main Block  *************************** */

define input parameter gpcBaseClass   as character no-undo.
define input parameter gpcTargetClass as character no-undo.

run addClassToDIConfig(gpcBaseClass, gpcTargetClass).

/* **********************  Internal Procedures  *********************** */

procedure addClassToDIConfig :
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Adds binding for given base class to given source class.                   */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* pcBaseClass                                                                */
/* pcTargetClass                                                              */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define input parameter pcBaseClass   as character no-undo.
define input parameter pcTargetClass as character no-undo.

define variable cBaseClassFileName as character no-undo.
define variable cModule            as character  no-undo.
define variable cConfigDir         as character  no-undo.
define variable cConfigFilename    as character  no-undo.

define variable oConfigRoot        as JsonObject no-undo.
define variable oBindingsArray     as JsonArray  no-undo.
define variable oBinding           as JsonObject no-undo.

assign
  cBaseClassFileName = DMCOpSysSvc:cFileNameFromPath(pcBaseClass)
  cModule            = caps(substring(cBaseClassFileName, 1, 1))
  cConfigDir         = DMCOpSysSvc:cConcatPath(pACStartupSvc:cParameterValue('RessourceDir':U),
                                               'DIConfig':U)
  .

/* If no config has been created yet, the config dir iteslf might still be    */
/* missing as well.                                                           */
DMCOpSysSvc:createDirectory(cConfigDir).

assign
  cConfigFilename = DMCOpSysSvc:cConcatPath(cConfigDir,
                                            substitute('DIConfig_&1.json':U, cModule))
  oConfigRoot     = (if DMCOpSysSvc:lIsFileExistingSilent(cConfigFilename, 'File':U) then
                       cast(new ObjectModelParser():ParseFile(cConfigFilename), JsonObject)
                     else
                       new JsonObject()).
  .

if oConfigRoot:Has('bindings':U) then
  oBindingsArray = oConfigRoot:GetJsonArray('bindings':U).

else
do:
  oBindingsArray = new JsonArray().
  oConfigRoot:Add('bindings':U, oBindingsArray).
end.

oBinding = oGetBindingEntryOrNull(oBindingsArray, pcBaseClass).

if not valid-object(oBinding) then
do:
  oBinding = new JsonObject().
  oBindingsArray:Add(oBinding).
  oBinding:Add('objectType':U, pcBaseClass).
end.

if oBinding:Has('resolveTo':U) then
  oBinding:Set('resolveTo':U, pcTargetClass).
else
  oBinding:Add('resolveTo':U, pcTargetClass).

oConfigRoot:WriteFile(cConfigFilename, yes).

end procedure.

/* ************************  Function Implementations ***************** */

function oGetBindingEntryOrNull returns JsonObject 
  ( poBindingArray as JsonArray,
    pcBaseClass    as character ):
/* Description ---------------------------------------------------------------*/
/*                                                                            */
/* Returs the binding for given base class. Returns ?, if the binding does    */
/* not yet exist.                                                             */
/*                                                                            */
/* Parameters ----------------------------------------------------------------*/
/*                                                                            */
/* poBindingArray                                                             */
/* pcBaseClass                                                                */
/*                                                                            */
/*----------------------------------------------------------------------------*/

define variable iBindingCounter as integer    no-undo.
define variable oBinding        as JsonObject no-undo.

do iBindingCounter = 1 to poBindingArray:length:
  
  oBinding = poBindingArray:GetJsonObject(iBindingCounter).
  
  if    oBinding:Has('objectType':U)
    and oBinding:GetCharacter('objectType':U) = pcBaseClass then
    return oBinding.
  
end.

return ?.

end function.
