/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.templates.helper;

import com.proalpha.pds.paconnector.Activator;
import com.proalpha.pds.paconnector.PaProject;
import com.proalpha.pds.paconnector.PaProjectManager;
import com.proalpha.pds.paconnector.PaVersion;
import com.proalpha.pds.templates.helper.CommentStyle;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.swt.widgets.Display;

public final class CodeFormatter {
    private static final int RIGHTMARGIN = 80;

    private CodeFormatter() {
    }

    public static String SingleLineComment(String Line, CommentStyle commentStyle) {
        return CodeFormatter.SingleLineComment(Line, commentStyle, 1);
    }

    public static String SingleLineComment(String Line, CommentStyle commentStyle, int StartColumn) {
        int i;
        int length = Line.length();
        switch (commentStyle) {
            case SINGLE_LINE_COMMENT: {
                Line = "// " + Line;
                break;
            }
            case MULTI_LINE_COMMENT_SINGLE: {
                i = 0;
                while (i < 74 - length - (StartColumn - 1)) {
                    Line = String.valueOf(Line) + " ";
                    ++i;
                }
                Line = "/* " + Line + " */";
                break;
            }
            case ABL_DUCK: {
                Line = " * " + Line;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Multi line comments are not supported by the code formatter");
            }
        }
        i = 0;
        while (i < StartColumn - 1) {
            Line = " " + Line;
            ++i;
        }
        return Line;
    }

    public static String MultiLineComment(String CommentText, CommentStyle commentStyle) {
        return CodeFormatter.MultiLineComment(CommentText, commentStyle, 1);
    }

    public static String MultiLineComment(String CommentText, CommentStyle commentStyle, int StartColumn) {
        String[] commentLineSepArray;
        String content = "";
        int counter = 0;
        String lineSeparator = System.getProperties().getProperty("line.separator");
        String[] stringArray = commentLineSepArray = CommentText.split(lineSeparator);
        int n = commentLineSepArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            content = String.valueOf(content) + CodeFormatter.SingleLineComment(s, commentStyle, StartColumn);
            if (commentLineSepArray.length - 1 > counter) {
                content = String.valueOf(content) + lineSeparator;
            }
            ++counter;
            ++n2;
        }
        return content;
    }

    public static String pad(String src, int padTo, char padChar) {
        int numPad = padTo - src.length();
        if (numPad > 0) {
            StringBuffer sb = new StringBuffer();
            char[] pad = new char[numPad];
            Arrays.fill(pad, padChar);
            sb.append(src);
            sb.append(pad);
            return sb.toString();
        }
        return src;
    }

    public static boolean isCompactComments() {
        final PaProjectManager paProjectManager = Activator.getDefault().getProjectManager();
        final AtomicReference paRef = new AtomicReference();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                paRef.set(paProjectManager.getPaProjectByTextSelection());
            }
        });
        PaProject paProject = (PaProject)paRef.get();
        if (paProject == null || !paProject.isAvailable()) {
            return false;
        }
        return CodeFormatter.isCompactComments(paProject);
    }

    public static boolean isCompactComments(PaProject paProject) {
        return paProject != null && paProject.getVersion().isHigherOrEqualThan(new PaVersion(9, 6, 0));
    }
}

