/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.handlers;

import com.proalpha.pds.generator.GeneratorFactory;
import com.proalpha.pds.generator.OOABLExitFileGenerator;
import com.proalpha.pds.generator.UserExitFileGenerator;
import com.proalpha.pds.paconnector.PaProject;
import com.proalpha.pds.paconnector.parameter.ParameterFactory;
import com.proalpha.pds.paconnector.parameter.StartparameterReader;
import com.proalpha.pds.paconnector.repository.RepositoryInformations;
import com.proalpha.pds.paconnector.utils.ExceptionUtils;
import com.proalpha.pds.paconnector.utils.PaOOABLUtil;
import com.proalpha.pds.templates.data.DataContainerFactory;
import com.proalpha.pds.templates.data.IGeneratorDataContainer;
import com.proalpha.pds.ui.Activator;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.IProgressService;

public class UserExitGeneratorHandler
extends AbstractHandler {
    private DataContainerFactory dataContainerFactory = new DataContainerFactory();
    private GeneratorFactory generatorFactory = new GeneratorFactory();
    private ParameterFactory parameterFactory = new ParameterFactory();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        PaProject paProject = com.proalpha.pds.paconnector.Activator.getDefault().getProjectManager().getPaProjectByTextSelection();
        if (paProject != null && paProject.isAvailable()) {
            this.generateUserExits(paProject);
        }
        return null;
    }

    private void generateUserExits(PaProject paProject) {
        IRunnableWithProgress runnable = monitor -> {
            IFile file = null;
            String pAProcedure = null;
            try {
                monitor.beginTask("Generate Userexit", 4);
                monitor.worked(1);
                IGeneratorDataContainer datacontainer = this.dataContainerFactory.createDataContainer(paProject);
                StartparameterReader pAStartParam = this.parameterFactory.createStartparameterReader(paProject);
                file = com.proalpha.pds.paconnector.Activator.getDefault().getProjectManager().getFileFromActiveSelection();
                if (file == null) {
                    Shell activeShell = Display.getDefault().getActiveShell();
                    MessageDialog.openError((Shell)activeShell, (String)"no procedure name", (String)"can't find filename in current selection.");
                    return;
                }
                pAProcedure = file.getName();
                monitor.worked(2);
                datacontainer.setFileName(pAProcedure);
                datacontainer.setVersion(paProject.getVersion());
                datacontainer.setCustomLevel(paProject.getCustomLevel());
                datacontainer.setObjectInfo(datacontainer.getRepositoryInformations().getProgramShortDesc(pAProcedure));
                if (pAProcedure.endsWith(".cls")) {
                    String pAParentClassObj = datacontainer.getRepositoryInformations().getClassOBJ(pAProcedure);
                    datacontainer.setParentObject(datacontainer.getRepositoryInformations().getClassName(pAParentClassObj));
                    OOABLExitFileGenerator gen = null;
                    gen = pAProcedure.length() >= 3 && Character.toLowerCase(pAProcedure.charAt(2)) == 'i' ? this.generatorFactory.createOOABLExitFileGenerator(datacontainer, "pAOOABLStdInterface") : this.generatorFactory.createOOABLExitFileGenerator(datacontainer, PaOOABLUtil.useDIFramework((RepositoryInformations)this.generatorFactory.getRepositoryInformations(paProject), (String)pAProcedure) ? "pAOOABLClassDI" : "pAOOABLStdClass");
                    gen.generateUserExitClassAndBalpEntry();
                } else {
                    datacontainer.setParentObject(pAProcedure);
                    UserExitFileGenerator gen = this.generatorFactory.createUserExitFileGenerator(datacontainer);
                    gen.generateUserExitClassAndBalpEntry();
                }
                monitor.worked(2);
                pAStartParam.getWorkingDirectory().refreshLocal(2, monitor);
                monitor.done();
            }
            catch (Exception exception) {
                ExceptionUtils.showAndLogErrorMessage((AbstractUIPlugin)Activator.getDefault(), (Throwable)exception);
            }
        };
        IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
        IProgressService context = PlatformUI.getWorkbench().getProgressService();
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, runnable, (ISchedulingRule)rule);
        }
        catch (InvocationTargetException e) {
            ExceptionUtils.showAndLogErrorMessage((AbstractUIPlugin)Activator.getDefault(), (Throwable)e);
        }
        catch (InterruptedException e) {
            ExceptionUtils.showAndLogErrorMessage((AbstractUIPlugin)Activator.getDefault(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

