/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class ProgressServiceUtil {
    public static void runInProgressService(String taskName, IRunnableWithProgress runnableWithProgress) {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnableWithProgress);
        }
        catch (Exception e) {
            ProgressServiceUtil.showAndLogError(taskName, e);
        }
    }

    public static void runInUI(String taskName, IRunnableWithProgress runnableWithProgress) {
        try {
            IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
            IProgressService context = PlatformUI.getWorkbench().getProgressService();
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, runnableWithProgress, (ISchedulingRule)rule);
        }
        catch (Exception e) {
            ProgressServiceUtil.showAndLogError(taskName, e);
        }
    }

    public static void runInNewThread(String taskName, IRunnableWithProgress runnableWithProgress) {
        try {
            PlatformUI.getWorkbench().getProgressService().run(Boolean.TRUE.booleanValue(), Boolean.TRUE.booleanValue(), runnableWithProgress);
        }
        catch (Exception e) {
            ProgressServiceUtil.showAndLogError(taskName, e);
        }
    }

    private static void showAndLogError(String taskName, Exception e) {
        String message = e.getMessage();
        if (message == null || message.isEmpty()) {
            message = e.getCause().getMessage();
        }
        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)taskName, (String)message);
    }
}

