
/*------------------------------------------------------------------------
    File        : runAblUnitFromPDS.p
    Purpose     : 

    Syntax      :

    Description : 

    Author(s)   : Schmaranzer_M
    Created     : Tue May 31 10:11:11 CEST 2022
    Notes       :
  ----------------------------------------------------------------------*/

/* ***************************  Definitions  ************************** */

block-level on error undo, throw.

/* ********************  Preprocessor Definitions  ******************** */
using OpenEdge.ABLUnit.Runner.*.
using Progress.Json.ObjectModel.*.
using Progress.OpenEdge.Core.Util.*.
using System.IO.*.

define input parameter pcClassname as character no-undo. 
define input parameter pcResultFolder as character no-undo. 


/* ******************************************************************** */
define /*{&ACCESS-LEVEL}*/ temp-table Source no-undo /*{&REFERENCE-ONLY}*/
    field File-name   as character xml-node-type 'attribute':u 
    field Source-guid as character 
    field File-num    as integer
    
    index idx1 as primary unique Source-guid File-num
    index idx2                   File-name
    .

define /*{&ACCESS-LEVEL}*/ temp-table String-ref no-undo /*{&REFERENCE-ONLY}*/
    field Source-guid   as character
    field Ref-seq       as integer 
    field Max-length    as integer
    field Justification as character
    field Translatable  as logical
    
    index idx1 as unique Source-guid Ref-seq.

define /*{&ACCESS-LEVEL}*/ temp-table Parameter-ref no-undo /*{&REFERENCE-ONLY}*/
    field Source-guid    as character
    field Ref-seq        as integer
    field Order          as integer   xml-node-type 'attribute':u 
    field Parameter-mode as character xml-node-type 'attribute':u 
    field Parameter-name as character xml-node-type 'attribute':u 
    field Parameter-type as character xml-node-type 'attribute':u 
    field Dimension      as integer
    field Is-append      as logical
    field Dataset-guid   as character
    
    index idx1 as unique Source-guid Ref-seq Order.

define /*{&ACCESS-LEVEL}*/ temp-table Class-ref no-undo /*{&REFERENCE-ONLY}*/
    field Source-guid     as character
    field Ref-seq         as integer
    field Inherited-list  as character
    field Implements-list as character
    field Has-use-pool    as logical
    field Is-final        as logical
    field Is-serializable as logical
    field Dataset-guid    as character
    
    index idx1 as unique Source-guid Ref-seq.

define /*{&ACCESS-LEVEL}*/ temp-table Reference no-undo /*{&REFERENCE-ONLY}*/
    field Object-identifier as character xml-node-type 'attribute':u 
    field Reference-type    as character xml-node-type 'attribute':u 
    field Source-guid       as character
    field File-num          as integer 
    field Ref-seq           as integer 
    field Line-num          as integer 
    field Object-context    as character 
    field Access-mode       as character 
    field Data-member-ref   as character 
    field Temp-ref          as character 
    field Detail            as character 
    field Is-static         as logical
    field Is-abstract       as logical
    
    index idx1 as primary unique Source-guid Ref-seq Line-num
    .

define /*{&ACCESS-LEVEL}*/ temp-table Interface-ref no-undo /*{&REFERENCE-ONLY}*/
    field Source-guid    as character
    field Ref-seq        as integer
    field Inherited-list as character
    
    index idx1 is unique primary Source-guid Ref-seq.

define /*{&ACCESS-LEVEL}*/ temp-table Dataset-ref no-undo /*{&REFERENCE-ONLY}*/
    field Source-guid  as character
    field Dataset-guid as character
    field Ref-seq      as integer
    field N-uri        as character
    field N-prefix     as character
    field Is-reference as logical
    field Buffer-list  as character
    field Data-links   as integer
    
    index idx1 is unique primary Source-guid Dataset-guid Ref-seq.

define /*{&ACCESS-LEVEL}*/ temp-table Relation no-undo /*{&REFERENCE-ONLY}*/
    field Source-guid        as character
    field Dataset-guid       as character
    field Relation-name      as character xml-node-type 'attribute':u
    field Parent-buffer-name as character
    field Child-buffer-name  as character
    field Relation-list      as character
    
    index idx1 is primary Source-guid Dataset-guid.


define /*{&ACCESS-LEVEL}*/ dataset dsXref /*{&REFERENCE-ONLY}*/
    namespace-uri 'uri:schemas-progress-com:XREFD:0005':u 
    serialize-name 'Cross-reference':u 
    for Source, Reference, Class-ref, Interface-ref, String-ref, Parameter-ref, Dataset-ref, Relation
    data-relation for Source, Reference
        relation-fields (Source-guid, Source-guid,File-num, File-num) 
        nested
    data-relation for Reference, Class-ref
        relation-fields (Source-guid, Source-guid,Ref-seq, Ref-seq)
        nested
    data-relation for Reference, Interface-ref
        relation-fields (Source-guid, Source-guid,Ref-seq, Ref-seq)
        nested
    data-relation for Reference, String-ref
        relation-fields (Source-guid, Source-guid,Ref-seq, Ref-seq)
        nested
    data-relation for Reference, Parameter-ref
        relation-fields (Source-guid, Source-guid,Ref-seq, Ref-seq) 
        nested
    data-relation for Reference, Dataset-ref
        relation-fields (Source-guid, Source-guid,Ref-seq, Ref-seq)
        nested
    data-relation for Dataset-ref, Relation
        relation-fields (Source-guid, Source-guid,Dataset-guid, Dataset-guid)
        nested
    .

/* Function prototype  */    
function TestClassSeemsToBeATestClass returns logical (pcTestClassFullPath as character) forward.
function getFileListFromInput returns 'System.String[]':U (pcTestFileOrDirectory as character) forward.
function GetTestArrayForConfig returns JSONArray (oTestFiles   as 'System.String[]':U) forward.
function GetOutputOptions returns JsonObject (pcFolder   as character) forward.

/* ***************************  Main Block  *************************** */
define variable lSuccessMessage        as logical    no-undo.
define variable gcTestFileOrDirectory  as character  no-undo.
define variable goTestRunner           as ABLRunner  no-undo.
define variable goTestConfig           as TestConfig no-undo.
define variable goFiles                as 'System.String[]':U  no-undo.

lSuccessMessage = no.

{adecomm/oeideservice.i}

gcTestFileOrDirectory = pcClassname.

goFiles = getFileListFromInput(gcTestFileOrDirectory).

if goFiles:length = 1 then
do:

  if not TestClassSeemsToBeATestClass(string(goFiles:getValue(0))) then 
  do:
    message substitute('Sorry, I got &1 as test class name.':U,string(goFiles:getValue(0))) skip 
    'I cannot idetify that as a test class.' skip
    'Seems you lost focus on your test class.'.
  return.
  end.

end.


run buildTestConfig(GetTestArrayForConfig(goFiles),
                    GetOutputOptions(pcResultFolder),
                    output goTestConfig).

goTestRunner = new ABLRunner(goTestConfig,'ABLUnitResult.log':U).

if lSuccessMessage then 
  etime(yes).

// to test pA error messages, it is easier to not see them, so we disable them
adm.method.cls.DMCMessageSvc:prpoInstance:prplSuppressAllMessages = yes.

goTestRunner:RunTests().

if lSuccessMessage then
  message "Test done in " etime " ms".

catch oError as Progress.lang.error:
  message oError:GetMessage(1).
end catch.

finally:
  // activate proALPHA Error Messages again
  delete object goFiles.
  adm.method.cls.DMCMessageSvc:prpoInstance:prplSuppressAllMessages = no.
end.

/* -------- Procedures and Functions ----------*/ 

procedure buildTestConfig:
  define input parameter poTestArray  as JSONArray no-undo.
  define input parameter poOutputs  as JsonObject no-undo.
  define output parameter poTestConfig as TestConfig no-undo.

  define variable oOptions as JSONObject no-undo.
  define variable oTestConfigJson       as JSONObject no-undo.

  oTestConfigJson       = new JSONObject().
  
  oOptions = new JsonObject().
  oOptions:add('output':U,poOutputs).
  oTestConfigJson:add('options':U,oOptions).
  
  oTestConfigJson:add('tests', poTestArray).
  
  poTestConfig = new TestConfig(oTestConfigJson).
  
end.

function GetTestArrayForConfig returns JSONArray (oTestFiles   as 'System.String[]':U):
  define variable oTestConfigTest       as JSONOBject no-undo.
  define variable oTestConfigTestArray  as JSONArray  no-undo.
  define variable iFiles as integer no-undo.

  oTestConfigTestArray  = new JSONArray().

  do iFiles = 0 to oTestFiles:length - 1
  on error undo, throw:

    if not TestClassSeemsToBeATestClass(string(oTestFiles:GetValue(iFiles))) then
      next.
      
    oTestConfigTest = new JSONOBject().
    oTestConfigTest:Add('test':U,string(oTestFiles:GetValue(iFiles))).
  oTestConfigTestArray:Add(oTestConfigTest).
  end. 
  
  return oTestConfigTestArray.

end function.

function GetOutputOptions returns JSONObject (pcFolder as character):
  
  define variable oOutputs as JsonObject no-undo.
  
  oOutputs = new JsonObject().
  oOutputs:add('location':U,pcFolder).
  return oOutputs.

end function.

function TestClassSeemsToBeATestClass returns logical (pcTestClassFullPath as character):

  if pcTestClassFullPath matches '*Tst.cls':U then 
    return yes.
  
  if pcTestClassFullPath matches '*Tsts.cls':U then 
    return yes.

  if pcTestClassFullPath matches '*Tst..':U then 
    return yes.
  
  if pcTestClassFullPath matches '*Tsts..':U then 
    return yes.


  
  return no.
  
end function.

function getFileListFromInput returns 'System.String[]':U (pcTestFileOrDirectory as character):
  
  define variable oFiles as 'System.String[]':U  no-undo.
  define variable fileAttribs as FileAttributes no-undo.
  
  fileAttribs  = System.IO.File:GetAttributes(pcTestFileOrDirectory).
  
  if fileAttribs:HasFlag(FileAttributes:Directory) then
    oFiles = System.IO.Directory:GetFiles(pcTestFileOrDirectory,
                                         '*Tst.cls':U,
                                        System.IO.SearchOption:AllDirectories).
  else do:

    oFiles = cast(System.Array:CreateInstance(Progress.Util.TypeHelper:GetType ("System.String"),1),"System.String[]") . 
    oFiles:SetValue(pcTestFileOrDirectory,0).
  
  end.

  return oFiles.

end function.
