/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.handlers;

import com.proalpha.pds.paconnector.Activator;
import com.proalpha.pds.paconnector.PaProject;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class RayHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        PaProject paProject = Activator.getDefault().getProjectManager().getPaProjectByTextSelection();
        if (paProject != null) {
            if (paProject.isAvailable()) {
                int rayPort = paProject.getRayPort();
                if (RayHandler.isRayAvailable("localhost", rayPort)) {
                    try {
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL("http://localhost:" + String.valueOf(rayPort) + "/skin-client/"));
                    }
                    catch (MalformedURLException | PartInitException e) {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"pA Ray", (String)"Error while calling browser");
                    }
                } else {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"pA Ray", (String)"Ray not active");
                }
            } else {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"pA not available", (String)"no Proalpha Project available or still starting");
            }
        } else {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"No Project", (String)"no Proalpha Project found");
        }
        return null;
    }

    public static boolean isRayAvailable(String host, int portNumber) {
        boolean isAvailable;
        if (portNumber == 0) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (Socket ignored = new Socket(host, portNumber);){
                isAvailable = true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            isAvailable = false;
        }
        return isAvailable;
    }
}

