/*
 * Decompiled with CFR 0.152.
 */
package com.progress.tools.installinfo.util;

import com.progress.tools.installinfo.BrandingInfo;
import com.progress.tools.installinfo.CustomIcon;
import com.progress.tools.installinfo.IProduct;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public final class ProductInfoUtil {
    private static ProductInfoUtil instance = new ProductInfoUtil();
    private Map<IProduct, BrandingInfo> productVsBrandingMap = null;

    private ProductInfoUtil() {
    }

    public static ProductInfoUtil getInstance() {
        return instance;
    }

    public Map<IProduct, BrandingInfo> getBrandingProductsMap() {
        if (this.productVsBrandingMap != null) {
            return this.productVsBrandingMap;
        }
        this.productVsBrandingMap = new HashMap<IProduct, BrandingInfo>();
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("com.progress.tools.installinfo.InstallInfo");
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                IConfigurationElement[] children = iConfigurationElement.getChildren();
                IProduct product = null;
                BrandingInfo brandInfo = null;
                IConfigurationElement[] iConfigurationElementArray2 = children;
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement child = iConfigurationElementArray2[n4];
                    if (child.getName().equals("productInfo")) {
                        product = this.getProductFromConfig(child);
                    } else if (child.getName().equals("brandingInfo")) {
                        brandInfo = this.getBrandingInfoFromConfig(child);
                    }
                    ++n4;
                }
                if (product != null) {
                    this.productVsBrandingMap.put(product, brandInfo);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.productVsBrandingMap;
    }

    public IProduct[] getProducts() {
        IProduct[] productArray = this.getBrandingProductsMap().keySet().toArray(new IProduct[0]);
        Arrays.sort(productArray, new ProductComparator());
        return productArray;
    }

    private BrandingInfo getBrandingInfoFromConfig(IConfigurationElement child) {
        BrandingInfo brandInfo = new BrandingInfo();
        brandInfo.setPluginID(child.getDeclaringExtension().getContributor().getName());
        brandInfo.setSplashIconSmallPath(child.getAttribute("splashIconSmallPath"));
        brandInfo.setSplashIconMediumPath(child.getAttribute("splashIconMediumPath"));
        brandInfo.setSplashIconLargePath(child.getAttribute("splashIconLargePath"));
        brandInfo.setWelcomeIconPath(child.getAttribute("welcomeIconPath"));
        brandInfo.setCopyrightStart(child.getAttribute("copyrightYearStart"));
        brandInfo.setCopyrightEnd(child.getAttribute("copyrightYearEnd"));
        brandInfo.setProductIconPath(child.getAttribute("productIconPath"));
        IConfigurationElement[] customElements = child.getChildren();
        if (customElements != null && customElements.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = customElements;
            int n = customElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals("customIcon")) {
                    CustomIcon icon = new CustomIcon();
                    icon.setThirdPartyIconPath(element.getAttribute("thirdpartyIcon"));
                    brandInfo.addCustomIcon(icon);
                }
                ++n2;
            }
        }
        return brandInfo;
    }

    private IProduct getProductFromConfig(IConfigurationElement child) throws CoreException {
        return (IProduct)child.createExecutableExtension("class");
    }

    private class ProductComparator
    implements Comparator<IProduct> {
        private ProductComparator() {
        }

        @Override
        public int compare(IProduct product1, IProduct product2) {
            String name1 = product1.getName();
            String name2 = product2.getName();
            if (name1 == null) {
                if (name2 == null) {
                    return 0;
                }
                return -1;
            }
            if (name2 == null) {
                return 1;
            }
            return name1.compareToIgnoreCase(name2);
        }
    }
}

