/*
 * Decompiled with CFR 0.152.
 */
package com.progress.tools.reportbug.ui.wizard.composite;

import com.progress.tools.installinfo.IProduct;
import com.progress.tools.installinfo.util.ProductInfoUtil;
import com.progress.tools.reportbug.model.BugData;
import com.progress.tools.reportbug.model.BugType;
import com.progress.tools.reportbug.model.Priority;
import com.progress.tools.reportbug.ui.Messages;
import com.progress.tools.reportbug.ui.ReportBugDialog;
import com.progress.tools.reportbug.ui.Utility;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BasicInfoComposite
extends Composite
implements ModifyListener {
    private Text summaryText;
    private BugData bugData;
    private Text descriptionText;
    private Combo productCombo;
    private Combo priorityCombo;
    private ReportBugDialog dialog;

    public BasicInfoComposite(ReportBugDialog dialog, Composite parent, int style, BugData bugData) {
        super(parent, style);
        this.dialog = dialog;
        this.bugData = bugData;
        this.setLayout((Layout)new GridLayout(1, false));
        this.createUI();
        this.init();
        this.addListeners();
    }

    private void addListeners() {
        this.summaryText.addModifyListener((ModifyListener)this);
        this.descriptionText.addModifyListener((ModifyListener)this);
        this.productCombo.addModifyListener((ModifyListener)this);
        this.priorityCombo.addModifyListener((ModifyListener)this);
    }

    private void init() {
        if (this.bugData.getBugType().getSummary() != null) {
            this.summaryText.setText(this.bugData.getBugType().getSummary());
        }
        if (this.bugData.getBugType().getDescription() != null) {
            this.descriptionText.setText(this.bugData.getBugType().getDescription());
        }
        if (this.bugData.getBugType().getProduct() != null) {
            int indexOf = Arrays.asList(this.productCombo.getItems()).indexOf(this.bugData.getBugType().getProduct());
            if (indexOf != -1) {
                this.productCombo.select(indexOf);
            } else {
                this.productCombo.select(0);
            }
        } else {
            this.productCombo.select(0);
        }
    }

    private void createUI() {
        Group basicInfoGroup = Utility.getNewGroup(this, Messages.BasicInformationWizardPage_basicInformation, 2, true, true);
        Label summaryLabel = new Label((Composite)basicInfoGroup, 0);
        summaryLabel.setText(Messages.BasicInformationWizardPage_summary);
        this.summaryText = new Text((Composite)basicInfoGroup, 2048);
        GridData layoutData = new GridData(4, 4, true, false);
        this.summaryText.setLayoutData((Object)layoutData);
        this.summaryText.setToolTipText(Messages.BasicInfoComposite_summaryTooltip);
        Label descriptionLabel = new Label((Composite)basicInfoGroup, 0);
        descriptionLabel.setText(Messages.BasicInformationWizardPage_desc);
        GridData gridData = new GridData(16384, 128, false, true);
        descriptionLabel.setLayoutData((Object)gridData);
        this.descriptionText = new Text((Composite)basicInfoGroup, 2882);
        GridData layoutData2 = new GridData(4, 4, true, true);
        this.descriptionText.setLayoutData((Object)layoutData2);
        this.descriptionText.setToolTipText(Messages.BasicInfoComposite_descriptionTooltip);
        Label productLabel = new Label((Composite)basicInfoGroup, 0);
        productLabel.setText(Messages.BasicInformationWizardPage_product);
        Composite composite = new Composite((Composite)basicInfoGroup, 0);
        composite.setLayoutData((Object)new GridData(16384, 4, true, false));
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.productCombo = new Combo(composite, 8);
        this.productCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.productCombo.setItems(this.getProducts());
        this.productCombo.setToolTipText(Messages.BasicInfoComposite_productComboTooltip);
        Label priorityLabel = new Label(composite, 0);
        priorityLabel.setText(Messages.BasicInformationWizardPage_priority);
        this.priorityCombo = new Combo(composite, 8);
        this.priorityCombo.setItems(Priority.getPriorityDisplayValues());
        this.priorityCombo.setLayoutData((Object)new GridData(16384, 4, true, false));
        this.priorityCombo.setToolTipText(Messages.BasicInfoComposite_priorityComboTooltip);
        this.dialog.setErrorMessage(null);
    }

    private String[] getProducts() {
        ArrayList<String> productNames = new ArrayList<String>();
        IProduct[] products = ProductInfoUtil.getInstance().getProducts();
        int i = 0;
        while (i < products.length) {
            productNames.add(products[i].getName());
            ++i;
        }
        return productNames.toArray(new String[productNames.size()]);
    }

    public BugType getModel() {
        BugType basicInfo = new BugType();
        basicInfo.setDescription(this.descriptionText.getText());
        basicInfo.setSummary(this.summaryText.getText());
        basicInfo.setPriority(this.getPriority());
        basicInfo.setProduct(this.productCombo.getItem(this.productCombo.getSelectionIndex()));
        return basicInfo;
    }

    public String getPriority() {
        if (this.priorityCombo == null || this.priorityCombo.getSelectionIndex() == -1 || this.priorityCombo.getSelectionIndex() >= Priority.getPriorityNames().length) {
            return "";
        }
        return Priority.getPriorityNames()[this.priorityCombo.getSelectionIndex()];
    }

    public void modifyText(ModifyEvent e) {
        this.dialog.validate();
    }

    public String getSummary() {
        return this.summaryText == null ? "" : this.summaryText.getText();
    }

    public String getDescription() {
        return this.descriptionText.getText();
    }
}

