/*
 * Decompiled with CFR 0.152.
 */
package com.progress.tools.reportbug.ui.dialogs;

import com.progress.tools.reportbug.model.Response;
import com.progress.tools.reportbug.ui.Messages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ResponseDialog
extends TitleAreaDialog {
    private Response response;

    public ResponseDialog(Shell parentShell, Response response) {
        super(parentShell);
        this.response = response;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Browser browser = new Browser(parentComposite, 2048);
        browser.setLayoutData((Object)new GridData(4, 4, true, true));
        browser.setBackground(Display.getDefault().getSystemColor(1));
        if (this.response.isSuccessful()) {
            this.setTitle(Messages.ResponseDialog_TITLE);
            this.getShell().setText(Messages.ResponseDialog_TITLE);
        } else {
            this.setTitle(Messages.ResponseDialog_ERROR_TITLE);
            this.getShell().setText(Messages.ResponseDialog_ERROR_TITLE);
        }
        if (this.response.getMessage() != null) {
            browser.setText(this.response.getMessage());
        }
        browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent event) {
                String location = event.location;
                if (location != null && !location.equals("")) {
                    Program.launch((String)location);
                    event.doit = false;
                }
            }
        });
        this.setContextHelp();
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    void setContextHelp() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.progress.tools.reportbug.ui.ResponseDialog");
    }
}

