/* ***********************************************************/
/* Copyright (c) 2008-2016 by Progress Software Corporation  */
/*                                                           */
/* All rights reserved.  No part of this program or document */
/* may be  reproduced in  any form  or by  any means without */
/* permission in writing from Progress Software Corporation. */
/*************************************************************/

&global-define OPTION_SEPARATOR chr(4)
   
define variable fLoggerHandle  as handle    no-undo.
define variable fContextHandle as handle    no-undo.

/* we set this from getServerDirctory immediately in setContextHandle  */
define variable fRunDir        as character no-undo.
define variable PARAMETER_DELIMITER as character no-undo initial "|".
/**  **/
on close of this-procedure
    do: 
        run destroyObject.
    end.

/* 
* this is declaration for logging mechanism 
*/
function log returns character 
    ( input msg as character) forward.

function getWorkDirectory returns character 
    ( ) in fContextHandle.

function getServerDirectory returns character 
    ( ) in fContextHandle.

function getObject returns Progress.Lang.Object 
    (piHwnd as int64 ) in fContextHandle.
   
function removeHwnd returns logical  
    (piHwnd as int64 ) in fContextHandle.
    
function setOpenDialogHwnd returns logical  
    (piHwnd as int64 ) in fContextHandle.  
     
/* **********************  Main Block ************************************** */
 


/* **********************  Internal Procedures  *********************** */
/* hide as ade object in the persistent procedure viewer  */
procedure adepersistent:
end.   
/* retrieve the propath 
*/
procedure PROPATH:
    define input parameter cPrm as character no-undo.
    if cPrm <> "" then propath = cPrm.
    return REPLACE(propath,",",";").
end procedure.

procedure getWindowThreadId:
    define input parameter cPrm as character no-undo.
    define variable result as integer no-undo.
  
    run GetCurrentThreadId(output result).
    return string(result).  
end.

/* Return the proversion for an old project 
*/
procedure proversion:
    define input parameter cPrm as character no-undo.
    return proversion.
end procedure.

/* run a particular procedure persistently 
*/
procedure launch:
    define input parameter cPrm as character no-undo.
    define variable h as handle.
    log( "Running " + cPrm + " persistently").
    do on error undo, leave
        on quit  undo, leave
        on stop  undo, leave:
		
        run adecomm/_runcode.p ( input  cPrm,
            input  "_PERSISTENT,_KEEP-WIDGETS" ,
            input  ? ,
            output h ) .
    end.
    if error-status:error then 
    do:
        log( "Completed Error " + cPrm).
        log( "Completed Error " + error-status:get-message(1)).
        return "ERROR:" + cPrm. 
    end.
    else if VALID-HANDLE(h) then 
    do:
        log( "Completed " + cPrm).
        return "OK".
    end.
    else 
    do:
        log( "Completed Error " + cPrm).
        return "ERROR:" + cPrm.
    end.
end procedure.

procedure launch_with_param:
    define input parameter cCmd as character no-undo.
  
    define variable h    as handle.
    define variable cPrm as character no-undo.
  
    assign
        cCmd = cCmd + " "
        cPrm = TRIM(SUBSTRING(cCmd,INDEX(cCmd,' ') + 1))
        cCmd = TRIM(ENTRY(1,cCmd,' ')).
    
	    
    run VALUE(cCmd) persistent set h (input cPrm) no-error.
    if error-status:error or error-status:get-message(1) > "" then 
    do:
        log( "Error: " + cPrm + " " + error-status:get-message(1)).	
        message error-status:get-message(1)
            view-as alert-box error.
        return "ERROR:" + cPrm.
    end.
    else 
    do:
        return "OK".
    end.
end procedure.

procedure runproc:
    define input parameter cPrm as character no-undo.
  
    run VALUE(cPrm) no-error.
    if error-status:error or error-status:get-message(1) > "" then 
    do:
        log( "Error: " + cPrm + " " + error-status:get-message(1)).	
        message error-status:get-message(1)
            view-as alert-box error.
        return "ERROR:" + cPrm.
    end.
    else 
    do:
        return "OK".
    end.
end procedure.


procedure runproc_with_param:
    define input parameter cCmd as character no-undo.
  
    define variable h    as handle.
    define variable cPrm as character no-undo.
  
    assign
        cCmd = cCmd + " "
        cPrm = TRIM(SUBSTRING(cCmd,INDEX(cCmd,' ') + 1))
        cCmd = TRIM(ENTRY(1,cCmd,' ')).
 
    run VALUE(cCmd) (input cPrm) no-error.
    if error-status:error or error-status:get-message(1) > "" then 
    do:
        log( "Error: " + cPrm + " " + error-status:get-message(1)).	
        message error-status:get-message(1)
            view-as alert-box error.
        return "ERROR:" + cPrm.
    end.
    else 
    do:
        return "OK".
    end.
end procedure.

/* run a program non-persist
*/
procedure rungui:
    define input parameter cPrm as character no-undo.
    define variable h as handle.
    log( "Running " + cPrm).
    do on error undo, leave
        on quit  undo, leave
        on stop  undo, leave:
		
        run adecomm/_runcode.p ( input  cPrm,
            input  "_PAUSE,_TOFRONT,_KEEP-WIDGETS" ,
            input  ? ,
            output h ) .
    end.
    if error-status:error then 
    do:
        log( "Completed Error " + cPrm).
        return "ERROR:" + cPrm. 
    end.
    else 
    do:
        log( "Completed " + cPrm).
        return "OK:" + cPrm .
    end.
end procedure.

procedure pingProgressSession:
    define input parameter cPrm as character no-undo.
	
    return "OK:pingProgressSession:" + cPrm.
end procedure.

/* receives an event from the ide and republishes it 
   to any subsribed ABL programs.  Anyone is free
   to subscribe to this method.  Unlike _adeevent.p these events
   are simply notifications are no response to them is possible.  These are
   not published in a specific handle so to subscribe to them use the following
   syntax:
   
   SUBSCRIBE PROCEDURE THIS-PROCEDURE TO "OEIDE_EVENT" ANYWHERE.
   
   Parameters:
   
   eventName	This is the name of the event.  It is always passed.
   projectName	This is always passed and will always be the name of the project
                   in context.  Only events from the current project are passed so each
                   OpenEdge runtime environment will only receive events from a single
                   project.
   programName	This is only published for file operations.  This is the full
                   name file location of the program in context
   eventData	This is unused at the moment, but may be used in the future.
*/
procedure PublishIDEEvent.

    define input parameter cPrm as character no-undo.

    define variable eventName   as character no-undo.
    define variable projectName as character no-undo.
    define variable programName as character no-undo.
    define variable eventData   as character no-undo.
	
    assign
        eventName   = ENTRY(1, cPrm, {&OPTION_SEPARATOR})
        projectName = ENTRY(2, cPrm, {&OPTION_SEPARATOR})
        programName = ENTRY(3, cPrm, {&OPTION_SEPARATOR})
        eventData   = ENTRY(4, cPrm, {&OPTION_SEPARATOR}).
	
    publish "OEIDE_EVENT" (input eventName, input projectName, input programName, input eventData).
		
end procedure.


procedure setLoggerHandle:
    define input  parameter hLogger as handle no-undo.
    fLoggerHandle = hLogger.
end.   

procedure setContextHandle:
    define input  parameter hLogger as handle no-undo.
    fContextHandle = hLogger.
    fRunDir = getServerDirectory().
end.   


function log returns character 
    ( input msg as character).
	
    if VALID-HANDLE(fLoggerHandle) then 
    do:
	
        DYNAMIC-FUNCTION("log" in fLoggerHandle, msg).
    end.
	
end function.

&IF '{&WINDOW-SYSTEM}' = 'TTY':U &THEN
procedure GetCurrentThreadId:
    define output parameter windowID as integer no-undo.
    windowID = 0.
end.
&ELSE
procedure GetCurrentThreadId external "kernel32.dll":
    define return parameter result as LONG.
end.
&ENDIF

procedure destroyObject:
    delete procedure this-procedure.
end.    

procedure ReloadAssemblies:
	define input parameter cPrm as character no-undo.
	
	run value(fRunDir + "_idereloadasmbly.p") (cPrm) no-error.
	if error-status:error then
		return error-status:get-message(1).
	return return-value.
end procedure.

procedure LoadAssembly:
	define input parameter cPrm as character no-undo.
	
	run value(fRunDir + "_ideldasmbly.p") (cPrm) no-error.
	if error-status:error then
		return error-status:get-message(1).
	return return-value.

end procedure.

procedure getKeyInfo:
    define INPUT PARAMETER pLabel  as character no-undo. 
    
    define variable cFunc as character no-undo.
    define variable cLabel as character no-undo.
    
    cFunc = keyfunction(keycode(pLabel)).
    cLabel = keylabel(keycode(pLabel)).
     
     RETURN (if cFunc = "" then cLabel else cFunc) + PARAMETER_DELIMITER + cLabel.               
end.    


/* We do not need as PDS already has some method to fetch it. */
/*
PROCEDURE getMessageDescription:
    DEFINE INPUT PARAMETER pnumber AS CHARACTER NO-UNDO.
    DEFINE VARIABLE phand   AS HANDLE NO-UNDO.
    DEFINE VARIABLE msgDesc AS CHARACTER NO-UNDO.
    RUN adeuib/ide/_ide_msgs.p PERSISTENT SET phand.
    RUN GetMessageDescription IN phand (integer(pnumber), OUTPUT msgDesc).
    IF VALID-HANDLE(phand) THEN 
    DELETE OBJECT phand NO-ERROR. 
    
    
    RETURN msgDesc.
END PROCEDURE.

*/
procedure RunProTools:
    define input parameter ProgramName as character no-undo.
    define input parameter RunPersistent as logical no-undo.
    if RunPersistent then 
       run value(ProgramName) persistent.
    else
       run value(ProgramName).
end procedure.    

procedure DBlist:
 define INPUT PARAMETER cParam  as character no-undo.   
 run RunProTools("protools/_dblist.w",yes).
end procedure. 

procedure ColorChanger:
  define INPUT PARAMETER cParam  as character no-undo.   
  run RunProTools("protools/_colorch.w",yes).  
end procedure.  

procedure ProcedureViewer:
  define INPUT PARAMETER cParam  as character no-undo.
  run RunProTools("protools/_ppmgr.w", yes).   
end procedure.
    
procedure OSPrompt:
  define INPUT PARAMETER cParam  as character no-undo.   
  run RunProTools("protools/_osprmt.p",no).  
end procedure.  

procedure SessionSettings:
  define INPUT PARAMETER cParam  as character no-undo.   
  run RunProTools("protools/_session.w",no).  
end procedure.

procedure ScreenCapture:
  define INPUT PARAMETER cParam  as character no-undo.   
  run RunProTools("protools/_scrcap.w",yes).
end procedure.  

procedure Protogen:
  define INPUT PARAMETER cParam  as character no-undo.   
  run RunProTools("protools/_protgen.w",yes).
end procedure.   

procedure ProSpy:
  define INPUT PARAMETER cParam  as character no-undo.   
  run RunProTools("protools/_psplus.w",yes).
end procedure.

procedure  WebClientApplicationAssembler:
  define INPUT PARAMETER cParam  as character no-undo.   
  run RunProTools("protools/_prowcapped.p",no).    
end procedure.   

procedure WebclientDeploymentPackager:
  define INPUT PARAMETER cParam  as character no-undo.   
  run RunProTools("protools/_prowcappdp.p",no).  
end procedure. 

procedure ConfigInfo:
  define INPUT PARAMETER cParam  as character no-undo.   
  
  run RunProTools("protools/_procfg.w",yes).
end procedure.

procedure ServiceParameterMaintenance:
  define INPUT PARAMETER cParam  as character no-undo.
  define variable hdl as handle no-undo.  
  run protools/waspartn.w persistent set hdl.
  run initializeObject in hdl.  
end procedure.

procedure SmartObjectUtility:
  define INPUT PARAMETER cParam  as character no-undo.   
  run RunProTools("protools/_v89conv.w",yes).
end procedure.

procedure ADM2ToDynamics:
  define INPUT PARAMETER cParam  as character no-undo.   
  run RunProTools("adeuib/_convertadm2dynamics.w",yes).
end procedure.

procedure XMLSchemaMapping:
  define INPUT PARAMETER cParam  as character no-undo.
  define variable h_xml as handle no-undo. 
  RUN adexml/_xmlview.w PERSISTENT SET h_xml.
  RUN initializeObject IN h_xml.

end procedure.    

procedure ScreenScalingUtility: 
  define INPUT PARAMETER cParam  as character no-undo.   
  run RunProTools("protools/_ppuscl.p",no).
end procedure.

procedure COMObjectViewer:
    define INPUT PARAMETER cParam  as character no-undo.   
    run RunProTools("protools/_proobjv.p",no).
end procedure.    

procedure StaticWidgetIDAssignment:
    define INPUT PARAMETER cParam  as character no-undo.   
    run RunProTools("protools/_widgetidassign.p",no). 
end procedure.

procedure RuntimeWidgetIDAssignment:
    define INPUT PARAMETER cParam  as character no-undo.   
    run RunProTools("protools/_runtimewidgetid.p",no).
end procedure.

procedure RunAuditPolicyMaintenance:
    define INPUT PARAMETER cParam  as character no-undo.
    run auditing/_apmt.p. 
end procedure.

procedure RunResults:
    define INPUT PARAMETER cParam  as character no-undo.
    run RunProTools("results.p",no).
end procedure.

procedure RunTranslationManager:
    define INPUT PARAMETER cParam  as character no-undo.   
    run RunProTools("_tran.p",no).
end procedure.

procedure RunVisualTranslator:
    define INPUT PARAMETER cParam  as character no-undo.   
    run RunProTools("_vtran.p",no).
 
end procedure.

procedure propathSearch:
    define input  parameter pcFile as character no-undo.
    &IF '{&WINDOW-SYSTEM}' = 'TTY':U &THEN
        return "ERROR:TTY".
    &ELSE
   
    define variable pid as int64 no-undo.
    assign pid = int64(entry(1,pcFile,PARAMETER_DELIMITER)).
    
    setOpenDialogHwnd(pid).
    run adeuib/ide/_dialog_search.p.
    if return-value > "" then
        return return-value.
    return "OK":U. 
    finally:
        removeHwnd(pid).          
    end finally.
   
   &ENDIF    
    
end.   
    
&IF '{&WINDOW-SYSTEM}' NE 'TTY':U &THEN
procedure cancelCurrentDialog:
   
    define input parameter pcHwnd as character no-undo.
    define variable dialogService as adeuib.idialogservice no-undo.
    dialogService = cast(getObject(int64(pcHwnd)),adeuib.idialogservice). 
    
    if not valid-object(dialogService) then
        return "ERROR:NoDialogAvail":U.  
    dialogService:Cancel().    
    
    return "OK" .
end.

/** return size and title to the embedding dialog */
procedure getCurrentDialogInfo:
    define input parameter pcHwnd as character no-undo.
    define variable cReturn as character no-undo.
    define variable dialogService as adeuib.idialogservice no-undo.
    dialogService = cast(getObject(int64(pcHwnd)),adeuib.idialogservice). 
    if not valid-object(dialogService) then
        return "ERROR:NoDialogAvail":U.  
    
    return 
       quoter(dialogService:title) + PARAMETER_DELIMITER +
       quoter(dialogService:WidthPixels) + PARAMETER_DELIMITER +
       quoter(dialogService:HeightPixels). 
    
end procedure.    
&ELSE 
procedure getCurrentDialogInfo:
    define input parameter pcHwnd as character no-undo.
    return "ERROR:TTY":U.  
end procedure.    

&ENDIF
