/* *****************************************************************/
/* Copyright (c) 2007 by Progress Software Corporation             */
/*                                                                 */
/* All rights reserved.  No part of this program or document       */
/* may be  reproduced in  any form  or by  any means without       */
/* permission in writing from Progress Software Corporation.       */
/*******************************************************************/

/*  this class tells the pvm to reload the assemblies.xml file from
    the one that is under the control of the visual designer
*/

USING Progress.ClrBridge.AssemblyStore FROM ASSEMBLY.

DEFINE INPUT PARAMETER pcParams AS CHARACTER NO-UNDO.
DEFINE VARIABLE assemblyStore AS Progress.ClrBridge.AssemblyStore NO-UNDO.

DEFINE VARIABLE oldAssemblyDir AS CHARACTER NO-UNDO.

assemblyStore = Progress.ClrBridge.AssemblyStore:Instance.

oldAssemblyDir = assemblyStore:AssembliesPath.

IF LENGTH(pcParams) > 0 THEN DO:
	assemblyStore:AssembliesPath = pcParams.	
END.

assemblyStore:Load() NO-ERROR.

assemblyStore:AssembliesPath  = oldAssemblyDir.

IF VALID-OBJECT(assemblyStore) THEN
	DELETE OBJECT assemblyStore.

IF ERROR-STATUS:error THEN
	RETURN ERROR-STATUS:GET-MESSAGE(1).
ELSE
	RETURN "OK".