/* ***********************************************************/
/* Copyright (c) 2009 by Progress Software Corporation       */
/*                                                           */
/* All rights reserved.  No part of this program or document */
/* may be  reproduced in  any form  or by  any means without */
/* permission in writing from Progress Software Corporation. */
/*************************************************************/

define variable fLoggerHandle  as handle    no-undo.
define variable fContextHandle as handle    no-undo.

/* This is calculated on startup from setContextHandle  */
define variable fRunDir        as character no-undo.

fRunDir = replace(this-procedure:file-name,"runtime/_idewsruntime.p","").

function log returns character 
    ( input msg as character).
	
    if VALID-HANDLE(fLoggerHandle) then 
    do:
	
        DYNAMIC-FUNCTION("log" in fLoggerHandle, msg).
    end.
end function.

function getWorkDirectory returns character 
    ( ) in fContextHandle.

/* hide as ade object in the persistent procedure viewer  */
procedure adepersistent:
end.

procedure destroyObject:
    delete procedure this-procedure.
end procedure.

procedure setLoggerHandle:
    define input parameter hLogger as handle no-undo.
    fLoggerHandle = hLogger.
end.   

procedure setContextHandle:
    define input parameter hContext as handle no-undo.
    fContextHandle = hContext.
end.

procedure RunWebObject:
    define input parameter cPrm as character no-undo.
    define variable WebObject as character no-undo.
    define variable DataFile  as character no-undo.
  
    webobject = ENTRY(1, cPrm, "|").
    datafile  = ENTRY(2, cPrm, "|").
  
    log( "WEBSPEED:" + webobject + "=>" + datafile).
    run VALUE(fRunDir + "runtime/_wswebspeed.p") (WebObject, DataFile).
    return "OK".
end.
