&ANALYZE-SUSPEND _VERSION-NUMBER AB_v10r12 GUI
&ANALYZE-RESUME
/* Connected Databases 
*/
&Scoped-define WINDOW-NAME hQueryWindow

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CUSTOM _DECLARATIONS hQueryWindow 
routine-level on error undo, throw.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CUSTOM _DEFINITIONS hQueryWindow 
/**
 * @COPYRIGHT@
 * Project Proalpha
 * Name    query_generator_source.w
 * Created <version> as of <created>/<author>
 * Current @PAVERSION@ as of @PADATE@/@PALASTAUTHOR@
 *
 *
 * ## HISTORY
 * @FILEHISTORY@
 */

/*----------------------------------------------------------------------------*/
/*          This .W file was created with the Progress AppBuilder.            */
/*----------------------------------------------------------------------------*/

create widget-pool.

/*----------------------------------------------------------------------------*/
/* Options                                                                    */
/*----------------------------------------------------------------------------*/

&SCOPED-DEFINE K_SHOW_QUERY_TYPE_MODIFIER            no
&SCOPED-DEFINE K_ALWAYS_USE_FIND_FIRST               no
&SCOPED-DEFINE K_ALWAYS_USE_CANFIND_FIRST            no

&SCOPED-DEFINE K_SET_SLIM_MODE_ON_STARTUP            no

&SCOPED-DEFINE K_SHOW_GRID_ON_BROWSE                 no
&SCOPED-DEFINE K_TOGGLE_GRID_ON_BROWSE               no
&SCOPED-DEFINE K_SELECT_COLUMN_ON_BROWSE             yes
&SCOPED-DEFINE K_EXPORT_ON_BROWSE                    yes
&SCOPED-DEFINE K_RECORD_COUNT_ON_BROWSE              yes

&SCOPED-DEFINE K_EDITMODE_ENABLED                    yes
&SCOPED-DEFINE K_COLORED_INDEX_USAGE                 no

&SCOPED-DEFINE K_MAX_FIELD_HISTORY_ENTRIES           50

&SCOPED-DEFINE K_SESSIONTRIGGER_SHOWMESSAGE          yes
&SCOPED-DEFINE K_SESSIONTRIGGER_WRITELOG             no
&SCOPED-DEFINE K_SESSIONTRIGGER_LOGFILENAME          '':U
&SCOPED-DEFINE K_SESSIONTRIGGER_INDEXVALUES          yes
&SCOPED-DEFINE K_SESSIONTRIGGER_STACKTRACE           yes

&SCOPED-DEFINE K_AUTOFILTER_OMIT_TABLE_SUFFIX        '':U

&SCOPED-DEFINE K_DEFAULT_REPOSITORY_LANGUAGE         'D':U

/*----------------------------------------------------------------------------*/
/* Defaults                                                                   */
/*----------------------------------------------------------------------------*/

&SCOPED-DEFINE K_DEFAULT_BUFFER_PATTERN              '&1':U
&SCOPED-DEFINE K_DEFAULT_DEFINE_BUFFER               no

&SCOPED-DEFINE K_DEFAULT_EXCLUSIVE_LOCK              no
&SCOPED-DEFINE K_DEFAULT_COMPANY_VIA_CLASS           yes
&SCOPED-DEFINE K_DEFAULT_NO_ERROR                    yes
&SCOPED-DEFINE K_DEFAULT_IF_STATEMENT                yes
&SCOPED-DEFINE K_DEFAULT_NOT                         no
&SCOPED-DEFINE K_DEFAULT_DO_BLOCK                    no
&SCOPED-DEFINE K_DEFAULT_DEFINE_VARIABLES            yes
&SCOPED-DEFINE K_DEFAULT_USE_VIRTUAL_INDEX_API       yes
&SCOPED-DEFINE K_DEFAULT_USE_VIRTUAL_INDEX_INCLUDES  no

&SCOPED-DEFINE K_DEFAULT_ON_ERROR                    yes
&SCOPED-DEFINE K_DEFAULT_ON_ERROR_PHRASE             ~{&K_ON_ERROR_PHRASE_THROW}
&SCOPED-DEFINE K_DEFAULT_BLOCK_PATTERN               '':U
&SCOPED-DEFINE K_DEFAULT_DEFINE_BLOCK                no
&SCOPED-DEFINE K_DEFAULT_RETRY_BLOCK                 no
&SCOPED-DEFINE K_DEFAULT_FINALLY_BLOCK               no

&SCOPED-DEFINE K_DEFAULT_QUERY_TYPE                  ~{&K_QUERYTYPE_FINDFIRST}

&SCOPED-DEFINE K_DEFAULT_INDENTATION                 0

&SCOPED-DEFINE K_DEFAULT_INSERT_MODE                 yes

/*----------------------------------------------------------------------------*/
/* Buffer-Buttons                                                             */
/*----------------------------------------------------------------------------*/

/* Use &1 as table name replacement and # as a counter replacement. Use ## to */
/* actually insert the # character                                            */

&SCOPED-DEFINE K_BUFFER_PATTERN_1                    'b#&1':U
&SCOPED-DEFINE K_BUFFER_PATTERN_LABEL_1              'b#':U

&SCOPED-DEFINE K_BUFFER_PATTERN_2                    'gb#&1':U
&SCOPED-DEFINE K_BUFFER_PATTERN_LABEL_2              'gb#':U

&SCOPED-DEFINE K_BUFFER_PATTERN_3                    'bx#&1':U
&SCOPED-DEFINE K_BUFFER_PATTERN_LABEL_3              'bx#':U

&SCOPED-DEFINE K_BUFFER_PATTERN_4                    'gbx#&1':U
&SCOPED-DEFINE K_BUFFER_PATTERN_LABEL_4              'gbx#':U

&SCOPED-DEFINE K_NUM_BUFFER_PATTERN_INDICES          5

/*----------------------------------------------------------------------------*/
/* Block-Buttons                                                              */
/*----------------------------------------------------------------------------*/

&SCOPED-DEFINE K_BLOCK_PATTERN_1                     'FE_&1':U
&SCOPED-DEFINE K_BLOCK_PATTERN_LABEL_1               'FE':U

&SCOPED-DEFINE K_BLOCK_PATTERN_2                     'Main':U
&SCOPED-DEFINE K_BLOCK_PATTERN_LABEL_2               'Main':U

&SCOPED-DEFINE K_BLOCK_PATTERN_3                     '':U
&SCOPED-DEFINE K_BLOCK_PATTERN_LABEL_3               '':U

&SCOPED-DEFINE K_BLOCK_PATTERN_4                     '':U
&SCOPED-DEFINE K_BLOCK_PATTERN_LABEL_4               '':U


/*----------------------------------------------------------------------------*/
/* Other constants                                                            */
/*----------------------------------------------------------------------------*/

&SCOPED-DEFINE K_Version                           '4.0.0 Dev 33':U
&GLOBAL-DEFINE xITCFramework_VERSION               40033

&IF proversion < '11.3':U &THEN

  /* The progress system constant PROCESS-ARCHITECTURE was introduced in      */
  /* progress version 11.3. To avoid compile errors in version prior to that  */
  /* we declare it as 32 bit. Chances are very slim that it is anything else  */
  /* in earlier progress versions.                                            */

  &GLOBAL-DEFINE PROCESS-ARCHITECTURE  32

&ENDIF

&SCOPED-DEFINE K_FIELD_TYPE_DB_FIELD               0
&SCOPED-DEFINE K_FIELD_TYPE_VIRTUAL_DB_FIELD       10

&SCOPED-DEFINE K_BASE_DB_NAME                      'basis':U

&SCOPED-DEFINE K_QG_WIKI_URL                       'https://paworld.proalpha.com/x/eFKjAg':U
&SCOPED-DEFINE K_QG_CUSTOMER_WIKI_URL              'https://b2b.proalpha.de/wiki/index.php?title=Query%20Generator':U
&SCOPED-DEFINE K_PLUGIN_WIKI_URL                   'https://paworld.proalpha.com/x/iFKjAg':U
&SCOPED-DEFINE K_PLUGIN_CUSTOMER_WIKI_URL          'https://b2b.proalpha.de/wiki/index.php?title=Query%20Generator%20(Eclipse%20Plugin)':U

&SCOPED-DEFINE K_COMPANY_FIELDS                    'Firma,Company':U
&SCOPED-DEFINE K_COMPANY_INCLUDE_BLACKLIST         '*dt_fir00.fir*':U
&SCOPED-DEFINE K_OBJECT_ID_DOMAIN                  'Object ID':U

&SCOPED-DEFINE K_QUERYRANGE_DEFAULT                1
&SCOPED-DEFINE K_QUERYRANGE_FIRST                  2
&SCOPED-DEFINE K_QUERYRANGE_LAST                   3

&SCOPED-DEFINE K_QUERYTYPE_FINDFIRST               1
&SCOPED-DEFINE K_QUERYTYPE_FOREACH                 2
&SCOPED-DEFINE K_QUERYTYPE_CANFIND                 3

&SCOPED-DEFINE K_ACCESS_MODE_PHYSICAL              0
&SCOPED-DEFINE K_ACCESS_MODE_VIRTUAL_INDEX_API     1
&SCOPED-DEFINE K_ACCESS_MODE_VIRTUAL_INDEX_INCLUDE 2

&SCOPED-DEFINE K_ON_ERROR_PHRASE_LEAVE             1
&SCOPED-DEFINE K_ON_ERROR_PHRASE_NEXT              2
&SCOPED-DEFINE K_ON_ERROR_PHRASE_RETRY             3
&SCOPED-DEFINE K_ON_ERROR_PHRASE_THROW             4

&SCOPED-DEFINE K_DISPLAYMODE_FIELD                 1
&SCOPED-DEFINE K_DISPLAYMODE_INDEX                 2
&SCOPED-DEFINE K_DISPLAYMODE_RELATION              3

&SCOPED-DEFINE K_EDITACTION_EDIT                   1
&SCOPED-DEFINE K_EDITACTION_CREATE                 2
&SCOPED-DEFINE K_EDITACTION_DUPLICATE              3

&SCOPED-DEFINE K_WINDOW_MAXIMIZED                  1
&SCOPED-DEFINE K_WINDOW_MINIMIZED                  2
&SCOPED-DEFINE K_WINDOW_NORMAL                     3
&SCOPED-DEFINE K_WINDOW_DELAYED_MINIMIZE           4

&SCOPED-DEFINE K_WINDOW_MAXIMIZED_STR              'maximized':U
&SCOPED-DEFINE K_WINDOW_MINIMIZED_STR              'minimized':U
&SCOPED-DEFINE K_WINDOW_NORMAL_STR                 'normal':U

&SCOPED-DEFINE K_CLASS_COMPANY_STATEMENT           pACConnectionSvc:prpcCompany

&SCOPED-DEFINE K_PARAM_SPLITTER                    chr(3)

&SCOPED-DEFINE K_EDITOR_INSERT_REQUEST_HANDLER     'EditorInsertRequestId':U
&SCOPED-DEFINE K_SAVE_PLUGIN_SETTING_HANDLER       'SavePluginSettingId':U
&SCOPED-DEFINE K_LOAD_PLUGIN_SETTING_HANDLER       'LoadPluginSettingId':U

&SCOPED-DEFINE K_WINDOW_MIN_WIDTH                  210
&SCOPED-DEFINE K_WINDOW_MIN_WIDTH_SLIM             85
&SCOPED-DEFINE K_WINDOW_MIN_HEIGHT                 24
&SCOPED-DEFINE K_WINDOW_MIN_HEIGHT_SLIM            22
&SCOPED-DEFINE K_SLIM_MODE_FACTOR                  (231 / 121)

&SCOPED-DEFINE K_COLOR_BLACK                       1
&SCOPED-DEFINE K_COLOR_DARK_RED                    4
&SCOPED-DEFINE K_COLOR_GREEN                       10
&SCOPED-DEFINE K_COLOR_RED                         12
&SCOPED-DEFINE K_COLOR_YELLOW                      14
&SCOPED-DEFINE K_COLOR_DARK_GREY                   7
&SCOPED-DEFINE K_COLOR_LIGHT_GREY                  8

&SCOPED-DEFINE K_WHERE_DATA_TYPE_BLACKLIST         'BLOB,CLOB':U

&SCOPED-DEFINE K_MAX_INT64_FORMAT                  '-z,zzz,zzz,zzz,zzz,zzz,zz9':U

&SCOPED-DEFINE K_PROGRESS_TTNAME                   'PROGRESST':U
&SCOPED-DEFINE K_PERSISTENT_TT_DBNAME              'Persistent':U
&SCOPED-DEFINE K_PERSISTENT_TT_PHYSICALNAME        '*** Virtual persistent temp-table database ***':T
&SCOPED-DEFINE K_SNAPSHOT_DBNAME                   'Snapshots':U
&SCOPED-DEFINE K_SNAPSHOT_PHYSICALNAME             '*** Virtual snapshot database ***':T

&SCOPED-DEFINE K_QUERY_SIZE_MODE_DEFAULT           0
&SCOPED-DEFINE K_QUERY_SIZE_MODE_DEFAULT_SPLITTER  1
&SCOPED-DEFINE K_QUERY_SIZE_MODE_SMALL             2
&SCOPED-DEFINE K_QUERY_SIZE_MODE_MINIMUM           3
&SCOPED-DEFINE K_QUERY_SIZE_MODE_BIG               4
&SCOPED-DEFINE K_RECORD_SIZE_MODE_DEFAULT          5

&SCOPED-DEFINE K_VALUE_MODE_DATA_TYPE              0
&SCOPED-DEFINE K_VALUE_MODE_DEFAULT_VALUE          1
&SCOPED-DEFINE K_VALUE_MODE_PARAMETER              2

&SCOPED-DEFINE K_WIN_CONST_VK_SCROLL               0x91
&SCOPED-DEFINE K_WIN_CONST_VK_NUMLOCK              0x90
&SCOPED-DEFINE K_WIN_CONST_VK_CAPITAL              0x14
&SCOPED-DEFINE K_WIN_CONST_VK_CTRL                 0x11
&SCOPED-DEFINE K_WIN_CONST_VK_ALT                  0x12
&SCOPED-DEFINE K_WIN_CONST_VK_SHIFT                0x10

&GLOBAL-DEFINE K_WIN_CONST_HKEY_CURRENT_USER       -2147483647
&GLOBAL-DEFINE K_WIN_CONST_HKEY_LOCAL_MACHINE      -2147483646
&GLOBAL-DEFINE K_WIN_CONST_HKEY_CURRENT_CONFIG     -2147483643
&GLOBAL-DEFINE K_WIN_CONST_HKEY_CLASSES_ROOT       -2147483648

&GLOBAL-DEFINE K_WIN_CONST_KEY_QUERY_VALUE         1

&GLOBAL-DEFINE K_WIN_CONST_GWL_STYLE               -16
&GLOBAL-DEFINE K_WIN_CONST_WS_BORDER               0x00800000
&GLOBAL-DEFINE K_WIN_CONST_WS_CHILD                0x40000000
&GLOBAL-DEFINE K_WIN_CONST_WS_CLIPCHILDREN         0x02000000
&GLOBAL-DEFINE K_WIN_CONST_WS_POPUP                0x80000000
&GLOBAL-DEFINE K_WIN_CONST_WS_TABSTOP              0x00010000
&GLOBAL-DEFINE K_WIN_CONST_WS_HSCROLL              0x00100000
&GLOBAL-DEFINE K_WIN_CONST_WS_VSCROLL              0x00200000

&GLOBAL-DEFINE K_WIN_CONST_SWP_NOSIZE              1
&GLOBAL-DEFINE K_WIN_CONST_SWP_FRAMECHANGED        32

&GLOBAL-DEFINE K_QUERY_WINDOW_MODE_QUERY           0
&GLOBAL-DEFINE K_QUERY_WINDOW_MODE_QUERY_STR       'query':U
&GLOBAL-DEFINE K_QUERY_WINDOW_MODE_RECORD          1
&GLOBAL-DEFINE K_QUERY_WINDOW_MODE_RECORD_STR      'record':U

&GLOBAL-DEFINE K_NAVIGATE_FIRST                    1
&GLOBAL-DEFINE K_NAVIGATE_PREV                     2
&GLOBAL-DEFINE K_NAVIGATE_NEXT                     3
&GLOBAL-DEFINE K_NAVIGATE_LAST                     4

&GLOBAL-DEFINE K_QUERY_WINDOW_LINK_MODE_FIX_ROWID  1
&GLOBAL-DEFINE K_QUERY_WINDOW_LINK_MODE_FIX_INDEX  2
&GLOBAL-DEFINE K_QUERY_WINDOW_LINK_MODE_LINKED     3

&SCOPED-DEFINE K_DIRECTION_UP                      0
&SCOPED-DEFINE K_DIRECTION_DOWN                    1
&SCOPED-DEFINE K_DIRECTION_LEFT                    2
&SCOPED-DEFINE K_DIRECTION_RIGHT                   3

&SCOPED-DEFINE K_QP_TOKEN_TYPE_UNDEFINED           0
&SCOPED-DEFINE K_QP_TOKEN_TYPE_EOF                 1
&SCOPED-DEFINE K_QP_TOKEN_TYPE_KEYWORD             2
&SCOPED-DEFINE K_QP_TOKEN_TYPE_STRING              3
&SCOPED-DEFINE K_QP_TOKEN_TYPE_COMMENT             4
&SCOPED-DEFINE K_QP_TOKEN_TYPE_OPERATOR            5
&SCOPED-DEFINE K_QP_TOKEN_TYPE_NUMBER              6
&SCOPED-DEFINE K_QP_TOKEN_TYPE_DATE                7
&SCOPED-DEFINE K_QP_TOKEN_TYPE_PUNCTUATION         8
&SCOPED-DEFINE K_QP_TOKEN_TYPE_PREPROCESSOR        9
&SCOPED-DEFINE K_QP_TOKEN_TYPE_BRACE_OPEN          10
&SCOPED-DEFINE K_QP_TOKEN_TYPE_BRACE_CLOSE         11
&SCOPED-DEFINE K_QP_TOKEN_TYPE_BRACKET_OPEN        12
&SCOPED-DEFINE K_QP_TOKEN_TYPE_BRACKET_CLOSE       13
&SCOPED-DEFINE K_QP_TOKEN_TYPE_PARENTHESE_OPEN     14
&SCOPED-DEFINE K_QP_TOKEN_TYPE_PARENTHESE_CLOSE    15
&SCOPED-DEFINE K_QP_TOKEN_TYPE_IDENTIFIER          16
&SCOPED-DEFINE K_QP_TOKEN_TYPE_EXTERNAL_REFERENCE  17

&SCOPED-DEFINE K_QP_NODE_TYPE_NODE                 0
&SCOPED-DEFINE K_QP_NODE_TYPE_TOKEN                1

&SCOPED-DEFINE K_QP_COMPARATOR_OPERATORS ~
    'EQ,LT,LE,GT,GE,NE,BEGINS,MATCHES,CONTAINS,=,<,<=,>,>=,<>':U

&SCOPED-DEFINE K_QP_CONDITION_BREAK_KEYWORDS ~
      'FOR,EACH,FIRST,LAST,BREAK,BY,COLLATE,TRANSACTION,STOP-AFTER':U ~
    + ',ON,USE-INDEX,NO-LOCK,SHARE-LOCK,EXCLUSIVE-LOCK,NO-PREFETCH':U ~
    + ',LOOKAHEAD,NO-LOOKAHEAD,DEBUG,NO-DEBUG,SEPARATE-CONNECTION':U ~
    + ',NO-SEPARATE-CONNECTION,JOIN-BY-SQLDB,NO-JOIN-BY-SQLDB,BIND-WHERE':U ~
    + ',NO-BIND-WHERE,INDEX-HINT,NO-INDEX-HINT,SKIP-GROUP-DUPLICATES':U ~
    + ',TABLE-SCAN,USING':U

&SCOPED-DEFINE K_QP_KEYWORD_FUNCTIONS ~
      'TODAY,NOW,ETIME,ALIAS,ASC,AVAILABLE,CAN-DO,CAN-FIND,CAST,COUNT-OF':U ~
    + ',CURRENT-CHANGED,CURRENT-LANGUAGE,DATASERVERS,DBCODEPAGE,DBCOLLATION':U ~
    + ',DBNAME,DBPARAM,DBRESTRICTIONS,DBTASKID,DBTYPE,DBVERSION':U ~
    + ',DYNAMIC-function,ENCODE,ENTRY,ETIME,FILL,FIRST-OF,FRAME-COL':U ~
    + ',FRAME-DB,FRAME-DOWN,FRAME-FIELD,FRAME-FILE,FRAME-INDEX,FRAME-LINE':U ~
    + ',FRAME-NAME,FRAME-ROW,FRAME-VALUE,GET-BYTE,GET-CODEPAGES':U ~
    + ',GET-COLLATIONS,INDEX,INPUT,IS-ATTR-SPACE,KBLABEL,KEYCODE':U ~
    + ',KEYFUNCTION,KEYLABEL,KEYWORD,LAST-OF,LASTKEY,LDBNAME,LIBRARY':U ~
    + ',LINE-COUNTER,LOCKED,LOOKUP,MEMBER,MESSAGE-LINES,NEW,NUM-ALIASES':U ~
    + ',NUM-DBS,NUM-ENTRIES,OS-DRIVES,OS-ERROR,PAGE-NUMBER,PDBNAME':U ~
    + ',PROC-HANDLE,PROC-STATUS,PROGRAM-NAME,R-INDEX,RECID,RECORD-LENGTH':U ~
    + ',RETRY,RETURN-VALUE,SCREEN-LINES,SDBNAME,SEARCH,SEEK,SETUSERID,SUPER':U ~
    + ',TERMINAL,TIME,TRIM,USERID':U

&SCOPED-DEFINE K_CASEMODE_TABLE                    1
&SCOPED-DEFINE K_CASEMODE_FIELD                    2
&SCOPED-DEFINE K_CASEMODE_TABLE_FIELD              3
&SCOPED-DEFINE K_CASEMODE_TABLE_FIELD_LABEL        4
&SCOPED-DEFINE K_CASEMODE_TABLE_INDEX              5
&SCOPED-DEFINE K_CASEMODE_TABLE_RELATION           6

&SCOPED-DEFINE K_SNAPSHOT_SCOPE_RECORD             'rec':U
&SCOPED-DEFINE K_SNAPSHOT_SCOPE_ALL                'all':U

&SCOPED-DEFINE K_OVERLAY_TYPE_OBJ_STR              'obj':U

&SCOPED-DEFINE K_OBJECTID_OVERLAY_FGCOLOR          5
&SCOPED-DEFINE K_OBJECTID_OVERLAY_DEFAULT_WIDTH    35
&SCOPED-DEFINE K_OBJECTID_OVERLAY_FORMAT           'x(1024)':U
&SCOPED-DEFINE K_OBJECTID_OVERLAY_NAME_PATTERN     '$resolve( &1 )':U
&SCOPED-DEFINE K_OBJECTID_OVERLAY_LABEL_PATTERN    '&1 <resolved>':U

&SCOPED-DEFINE K_IMPORT_TYPE_DATASET               0
&SCOPED-DEFINE K_IMPORT_TYPE_TEMP_TABLE            1

define stream strExport.
define stream strClipboard.
define stream strSeTrigger.
define stream strTemp.

define new global shared variable pa-broker-hdl  as handle no-undo.

define variable gcCustomLevel               as character no-undo.

define variable gcBufferBaseName            as character no-undo.
define variable gcBufferPattern             as character no-undo.
define variable gcBlockPattern              as character no-undo.

define variable gcStatusText60              as character no-undo format 'x(60)':U.
define variable gcStatusText120             as character no-undo format 'x(120)':U.

define variable giQuerySeq                  as integer   no-undo.

define variable gcExportFilename            as character no-undo.
define variable gcQRScenarioFileName        as character no-undo.

define variable glShowHiddenTables          as logical   no-undo.

define variable glShowChildRelations        as logical   no-undo initial yes.
define variable glShowParentRelations       as logical   no-undo initial yes.

define variable giIndentation               as integer   no-undo.

define variable gcIDEProjectName            as character no-undo.

define variable glIDECanInsert              as logical   no-undo.
define variable glIDECanSaveSetting         as logical   no-undo.
define variable glIDECanLoadSetting         as logical   no-undo.

define variable glInsertMode                as logical   no-undo.

define variable gdOriginalWidth             as decimal   no-undo.
define variable gdMinWidth                  as decimal   no-undo initial {&K_WINDOW_MIN_WIDTH}.
define variable gdOriginalHeight            as decimal   no-undo.
define variable gdMinHeight                 as decimal   no-undo initial {&K_WINDOW_MIN_HEIGHT}.

define variable gcFieldDatatypeFilter       as character no-undo.

define variable gcSessionTitle              as character no-undo.
define variable gcTitlePrefix               as character no-undo.
define variable gcIconDir                   as character no-undo.

define variable giRecentQueriesSeq          as integer   no-undo.

define variable glBrowseFields              as logical   no-undo initial no.
define variable glRawValues                 as logical   no-undo initial no.
define variable glCopyRawValues             as logical   no-undo initial yes.
define variable glShowLinkedChildWindows    as logical   no-undo initial yes.

define variable gcPersitentTTProcedure      as character no-undo.

define variable gcTTWidgetPool              as character no-undo.

define variable gcCursorHand                as character no-undo.

define variable giQueryParserSeq            as integer   no-undo.

define variable gcQPQueryText               as character no-undo.
define variable giQPOffset                  as integer   no-undo.
define variable giQPTokenStart              as integer   no-undo.
define variable giQPTokenEnd                as integer   no-undo.
define variable gcQPToken                   as character no-undo.
define variable giQPTokenType               as integer   no-undo.

define variable glShowQueryTypeModifier     as logical   no-undo.
define variable glAlwaysUseFindFirst        as logical   no-undo.
define variable glAlwaysUseCanFindFirst     as logical   no-undo.
define variable glUseVirtualIndexApi        as logical   no-undo.
define variable glSlimMode                  as logical   no-undo.

define variable glUnicode                   as logical   no-undo.
define variable gcSpace                     as character no-undo.
define variable gcBulletChar1               as character no-undo.
define variable gcBulletChar1White          as character no-undo.
define variable gcBulletChar2               as character no-undo.
define variable gcBulletChar2White          as character no-undo.
define variable gcLineVertical              as character no-undo.
define variable gcLineUpAndRight            as character no-undo.
define variable gcLineVerticalAndRight      as character no-undo.

define variable giSessionTriggerSeq         as integer   no-undo.
define variable giSessionTriggerInstSeq     as integer   no-undo.

define variable ghSessionTriggersWindow     as handle    no-undo.
define variable ghSessionTriggersBrowse     as handle    no-undo.
define variable ghSessionTriggerShowMessage as handle    no-undo.
define variable ghSessionTriggerWriteLog    as handle    no-undo.
define variable ghSessionTriggerLogFileName as handle    no-undo.
define variable ghSessionTriggerIndexValues as handle    no-undo.
define variable ghSessionTriggerStackTrace  as handle    no-undo.

define variable glSessionTriggerShowMessage as logical   no-undo.
define variable glSessionTriggerWriteLog    as logical   no-undo.
define variable gcSessionTriggerLogFileName as character no-undo.
define variable glSessionTriggerIndexValues as logical   no-undo.
define variable glSessionTriggerStackTrace  as logical   no-undo.

define variable giRelationSeq               as integer   no-undo.
define variable giRelationViewSeq           as integer   no-undo.
define variable giRelationId                as integer   no-undo.
define variable glParentRelation            as logical   no-undo.
define variable gcRelationBufferName        as character no-undo.
define variable ghRelationWindow            as handle    no-undo.

define variable glRefreshFieldBrowse        as logical   no-undo.
define variable glRefreshIndexBrowse        as logical   no-undo.
define variable glRefreshRelationBrowse     as logical   no-undo.

define variable gchMerge                    as com-handle no-undo.
define variable gcBufferComparison1Tables   as character no-undo.
define variable gcBufferComparison1Buffers  as character no-undo.
define variable gcBufferComparison1RowIds   as character no-undo.
define variable gcBufferComparison2Tables   as character no-undo.
define variable gcBufferComparison2Buffers  as character no-undo.
define variable gcBufferComparison2RowIds   as character no-undo.

define variable giFilterSeq                 as integer   no-undo.

define variable gcRepositoryLanguage        as character no-undo initial {&K_DEFAULT_REPOSITORY_LANGUAGE}.

define temp-table ttDatabase no-undo
  field DatabaseName            as character
    format 'x(30)':U
    label 'Database':T
  field PhysicalName            as character
    format 'x(255)':U
    label 'Physical name':T
  field DisplayPriority         as integer
  field DirectoryName           as character
  field HostName                as character
  field ServiceName             as integer /* = Port */
  field TempDB                  as logical
  field BasisDB                 as logical
  field BasisDBName             as character
  field PhysicalDB              as logical
  field SharedMemory            as logical
  field VirtualDBFieldsPossible as logical
  field VirtualIndicesPossible  as logical
  index Main is primary unique
    DatabaseName
  index PhysicalName is unique
    PhysicalName
    DatabaseName
  index TempDB
    TempDB
    DatabaseName
  index DirectoryBasisDB
    DirectoryName
    BasisDB
    DatabaseName
  index HostBasisDB
    HostName
    BasisDB
    ServiceName
    DatabaseName
  index DisplayPriority
    DisplayPriority
    DatabaseName
    .

define temp-table ttTable no-undo
  field DatabaseName            like ttDatabase.DatabaseName
  field TableName               as character
    format 'x(32)':U
    label 'Table':T
  field ShortDescription        as character
    format 'x(80)':U
    label 'Short Description':U
  field TableFilterMatches      as logical
  field TableFieldFilterMatches as logical
  field CreateTrigger           as character
  field CreateTriggerProcName   as character
    format 'x(32)':U
    label 'Create trigger':T
  field WriteTrigger            as character
  field WriteTriggerProcName    as character
    format 'x(32)':U
    label 'Write trigger':T
  field DeleteTrigger           as character
  field DeleteTriggerProcName   as character
    format 'x(32)':U
    label 'Delete trigger':T
  field CompanyInclude          as character
    format 'x(12)':U
    label 'Company include':T
  field KeyInclude              as character
    format 'x(12)':U
    label 'Key include':T
  field FillInclude              as character
    format 'x(12)':U
    label 'Key include':T
  field InternalIdentifier      as character
  field PrimaryIndexName        as character
  field DetailsLoaded           as logical
  field DescriptionLoaded       as logical
  field PhysicalTable           as logical
  field TableHandle             as handle
  field OriginalTableHandle     as handle
  field Snapshot                as logical
  field RepObjectId             as character
  field RepTableId              as character
  index Main is primary unique
    DatabaseName
    TableName
  index RepObjectId
    RepObjectId
    DatabaseName
    TableName
  index Filter
    DatabaseName
    TableFilterMatches
    TableFieldFilterMatches
    TableName
  index PhysicalTable
    PhysicalTable
    DatabaseName
    TableName
  index InternalId
    DatabaseName
    InternalIdentifier
    TableName
  index DescriptionLoaded
    DescriptionLoaded
    DatabaseName
    TableName
    .

define temp-table ttField no-undo
  field DatabaseName       like ttDatabase.DatabaseName
  field TableName          like ttTable.TableName
  field FieldName          as character
    format 'x(32)':U
    label 'Field':T
  field RepObjectId        as character
  field DataType           as character
    format 'x(13)':U
    label 'Data type':T
  field FieldFormat        as character
    format 'x(30)':U
    label 'Format':T
  field FieldExtent        as integer
    format '>>>9':U
    label 'Extent':T
  field FieldDecimals      as integer
    format '>>>9':U
    label 'Decimals':T
  field FieldInitialValue  as character
    format 'x(30)':U
    label 'Initial':U
  field FieldLabel         as character
    format 'x(30)':U
    label 'Label':T
  field FieldColumnLabel   as character
    format 'x(30)':U
    label 'Column-Label':T
  field IsMandatory        as logical
    format 'yes/no':U
    label 'Mandatory':T
    view-as toggle-box
  field Domain             as character
    format 'x(40)':U
    label 'Domain':T
  field FieldViewAs        as character
    format 'x(50)':U
    label 'View as':T
  field IsObjectId         as logical
  field IsVirtual          as logical
    format '*/':U
    label 'Virtual Field':T
    column-label 'V':T
  field FieldType          as integer
  field FieldFilterMatches as logical
  index Main is primary unique
    DatabaseName
    TableName
    FieldName
  index RepObjectId
    RepObjectId
    DatabaseName
    TableName
    FieldName
  index FieldName
    DatabaseName
    FieldName
    TableName
  index VirtualField
    DatabaseName
    TableName
    IsVirtual
    FieldType
    DataType
    FieldName
  index FieldLabel
    DatabaseName
    FieldLabel
    TableName
    FieldName
  index Filter
    DatabaseName
    TableName
    FieldFilterMatches
    FieldName
    .

define temp-table ttIndex no-undo
  field DatabaseName                   like ttDatabase.DatabaseName
  field TableName                      like ttTable.TableName
  field IndexName                      as character
    format 'x(32)':U
    label 'Index':T
  field IsPrimary                      as logical
    format '*/ ':U
    label 'P':T
  field IndexFields                    as character
    format 'x(255)':U
    label 'Fields':T
  field IndexFieldList                 as character
  field IsUnique                       as logical
    format '*/ ':U
    label 'U':T
  field IndexFilterMatches             as logical
  field IndexFieldFilterMatches        as logical
  field IsVirtual                      as logical
    format '*/':U
    label 'V':U
  field VirtualFieldList               as character
  field VirtualFieldDataTypes          as character
  field VirtualIndexDataFieldList      as character
  field VirtualIndexDataFieldLabels    as character
  field VirtualIndexDataUntaggedValues as character
  field VirtualIndexDataTaggedValues   as character
  index Main is primary unique
    DatabaseName
    TableName
    IndexName
  index IsPrimary
    DatabaseName
    TableName
    IsPrimary
    IndexName
  index IsUnique
    DatabaseName
    TableName
    IsUnique
    IndexName
  index Filter
    DatabaseName
    TableName
    IndexFilterMatches
    IndexFieldFilterMatches
    IndexName
    .

define temp-table ttIndexField no-undo
  field DatabaseName  like ttDatabase.DatabaseName
  field TableName     like ttTable.TableName
  field IndexName     as character
  field IndexSequence as integer
  field FieldName     like ttField.FieldName
  field DataType      as character
  field SortAscending as logical
  index Main is primary unique
    DatabaseName
    TableName
    IndexName
    IndexSequence
  index FieldName
    DatabaseName
    TableName
    IndexName
    FieldName
    IndexSequence
    .

define temp-table ttTableRelation no-undo
  field RelationId       as integer
  field DatabaseName     like ttDatabase.DatabaseName
  field ParentTableName  like ttTable.TableName
    label 'Parent table':T
  field ChildTableName   like ttTable.TableName
    label 'Child table':T
  field SequentialNumber as integer
  field RelationType     as character
  field ParentFields     as character
  field ChildFields      as character
  field ParentFieldList  as character
  field ChildFieldList   as character
  index Main is primary unique
    RelationId
  index ParentTableName is unique
    DatabaseName
    ParentTableName
    ChildTableName
    SequentialNumber
  index ChildTableName is unique
    DatabaseName
    ChildTableName
    ParentTableName
    SequentialNumber
    .

define temp-table ttTableRelationField no-undo
  field RelationId         as integer
  field Order              as integer
  field ParentFieldName    like ttField.FieldName
    label 'Parent field':U
  field ParentConstantData as character
  field ChildFieldName     like ttField.FieldName
    label 'Child field':U
  field ChildConstantData  as character
  field FieldRelationType  as character
  index Main is primary unique
    RelationId
    Order
  index ParentFieldName
    ParentFieldName
    RelationId
    Order
  index ChildFieldName
    ChildFieldName
    RelationId
    Order
    .

define temp-table ttTableRelationView no-undo
  field RelationViewId     as integer
  field RelationId         like ttTableRelation.RelationId
  field DatabaseName       like ttTableRelation.DatabaseName
  field ReferenceTableName like ttTable.TableName
  field RelatedTableName   like ttTable.TableName
  field RelationType       as character
    label 'Type':T
    format 'x(4)':U
  field ReferenceFields    as character
    label 'Fields':T
    format 'x(1024)':U
  field RelatedFields      as character
    label 'Fields':T
    format 'x(1024)':U
  field FieldDetails      as character
    label 'Field details':T
    format 'x(1024)':U
  field ParentRelation    as logical
    label 'Parent Relation':T
    column-label 'CP':U
    format 'P/C':U
  field ReferenceFieldList as character
  field RelatedFieldList   as character
  field TableFilterMatches as logical
  field FieldFilterMatches as logical
  field ParentRelationFilterMatches as logical
  index Main is primary unique
    RelationViewId
  index RelationId
    RelationId
    DatabaseName
    ReferenceTableName
    RelatedTableName
    RelationViewId
  index TableName
    DatabaseName
    ReferenceTableName
    RelatedTableName
    RelationId
    RelationViewId
    .

define temp-table ttBufferComparisonField no-undo
  field FieldName    as character
  field FieldIndex   as integer
  field BufferNo     as integer
  field DataType     as character
  field FieldFormat  as character
  field DatabaseName as character
  field TableName    as character
  field BufferName   as character
  field FieldValue   as clob
  field IsEqual      as logical initial ?
  field IsVirtual    as logical
  field FieldType    as integer
  index Main is primary unique
    FieldName
    FieldIndex
    BufferNo
  index BufferNo
    BufferNo
    FieldName
    FieldIndex
  index IsEqual
    IsEqual
    BufferNo
    FieldName
    FieldIndex
  index DataType
    DataType
    FieldName
    FieldIndex
    BufferNo
    .

define temp-table ttFilterMatch no-undo
  field FilterId as integer
  field RecordRowId as rowid
  field RecordMatches as logical
  index Main is primary unique
    FilterId
    RecordRowId
  index RecordMatch
    FilterId
    RecordMatches
    RecordRowId
    .

define temp-table ttQueryWindow no-undo
  field WindowHandle                 as handle
  field QuerySeq                     as integer
  field WindowMode                   as integer
  field QueryText                    as character
  field QueryHandle                  as handle
  field QueryFrameHandle             as handle
  field QueryMenuHandle              as handle
  field QueryTextEditorHandle        as handle
  field QueryFieldBrowseHandle       as handle
  field QueryFieldBrowseBufferHandle as handle
  field QueryFieldBrowseColHandles   as handle extent 4
  field QueryBrowseHandle            as handle
  field QueryBrowseSelectedColumn    as handle
  field RecordFrameHandle            as handle
  field RecordMenuHandle             as handle
  field RecordQueryHandle            as handle
  field RecordBrowseHandle           as handle
  field RecordBrowseColHandles       as handle extent 5
  field DisplayRawValues             as logical
  field ApplyColumnFormats           as logical
  field ObjSourceQuerySeq            as integer
  field ObjSourceBufferName          as character
  field ObjSourceFieldName           as character
  field ObjSourceFieldIndex          as integer
  field ObjTargetTableId             as character
  field ObjTargetTableName           as character
  field DeepResolveObjectIds         as logical
  field WindowTitle                  as character
    label 'Query window':T
    format 'x(255)':U
  field Updated                    as logical
  field MissingObjectIdFields      as character
  field LastMissingObjectIdRecords as character
  index Main is primary unique
    WindowHandle
  index QuerySeq is unique
    QuerySeq
    .

define temp-table ttQueryWindowQueryBrowseColumn no-undo
  field WindowHandle   as handle
  field ColumnHandle   as handle
  field OriginalFormat as character
  field RawFormat      as character
  index Main is primary unique
    ColumnHandle
  index WindowHandle is unique
    WindowHandle
    ColumnHandle
    .

define temp-table ttQueryWindowField no-undo
  field WindowHandle            as handle
  field BufferId                as integer
  field DatabaseName            like ttDatabase.DatabaseName
  field TableName               like ttTable.TableName
  field BufferName              like ttTable.TableName
    label 'Buffer':T
    column-label 'Buffer':T
  field FieldName               like ttField.FieldName
  field FieldIndex              as integer
    format '>>>9':U
    label 'Idx':T
  field IsOverlay               as logical
  field IsOverlayResolved       as logical
  field FieldLabel              as character
    format 'x(30)':U
    label 'Label':T
  field DisplayName             like ttField.FieldName
    format 'x(255)':U
  field DataType                like ttField.DataType
  field FieldFormat             like ttField.FieldFormat
  field FieldViewAs             like ttField.FieldViewAs
  field FieldType               like ttField.FieldType
  field IsVirtual               like ttField.IsVirtual
  field IsObjectId              like ttField.IsObjectId
  field BufferHandle            as handle
  field FieldHandle             as handle
  field OldFormattedValue       as clob
  field OldUnformattedValue     as clob
  field OldDisplayValue         as character
    format 'x(255)':U
    label 'Old value':U
  field CurrentFormattedValue   as clob
  field CurrentUnformattedValue as clob
  field CurrentDisplayValue     as character
    format 'x(255)':U
    label 'Current value':U
  field Order                   as integer
  index Main is primary unique
    WindowHandle
    BufferId
    FieldName
    FieldIndex
    IsOverlay
  index BufferName
    WindowHandle
    BufferName
    FieldName
    FieldIndex
    IsOverlay
  index Order
    WindowHandle
    Order
    BufferId
    FieldName
    FieldIndex
    IsOverlay
  index IsVirtual
    WindowHandle
    BufferId
    IsVirtual
    FieldName
    FieldIndex
    IsOverlay
    .

define temp-table ttQueryWindowFieldChanges no-undo like ttQueryWindowField.

define temp-table ttQueryWindowObjField no-undo
  field WindowHandle       as handle
  field DatabaseName       like ttDatabase.DatabaseName
  field TableName          like ttTable.TableName
  field BufferName         like ttTable.TableName
    label 'Buffer':T
    column-label 'Buffer':T
  field FieldName          like ttField.FieldName
  field FieldIndex         as integer
    format '>>>9':U
    label 'Idx':T
  field DisplayName        like ttField.FieldName
    format 'x(255)':U
  field IsObjectId         like ttField.IsObjectId
  field IsVirtual          like ttField.IsVirtual
  field FieldType          like ttField.FieldType
  field ContainsObj        as logical
  field TargetDatabaseName like ttDatabase.DatabaseName
    label 'Target database':T
    column-label 'Target db':T
  field TargetTableName    like ttTable.TableName
    label 'Target table':T
    column-label 'Target table':T
  field Priority           as integer
  index Main is primary unique
    WindowHandle
    BufferName
    FieldName
    FieldIndex
  index TableName
    WindowHandle
    DatabaseName
    TableName
    FieldName
    FieldIndex
  index Priority
    WindowHandle
    Priority
    DatabaseName
    TableName
    FieldName
    FieldIndex
    .

define temp-table ttFieldOverlay no-undo
  field OwnerHandle         as handle
  field DatabaseName        as character
  field BufferName          as character
  field FieldName           like ttField.FieldName
  field FieldIndex          as integer
  field ColumnHandle        as handle
  field FieldHandle         as handle
  field OverlayTableId      as character
  field OverlayBufferHandle as handle
  field OverlayColumnHandle as handle
  index Main is primary unique
    OwnerHandle
    BufferName
    FieldName
    FieldIndex
  index ColumnHandle
    OwnerHandle
    ColumnHandle
  index OverlayColumnHandle
    OwnerHandle
    OverlayColumnHandle
    .

define temp-table ttQueryWindowView no-undo
  field Id                 as integer
  field Root               as integer
  field ParentWindowHandle as handle
  field WindowHandle       as handle
  field WindowMode         as integer
  field Depth              as integer
  field LineText           as character
    label 'Query window':T
    format 'x(255)':U
  index Main is primary unique
    ParentWindowHandle
    WindowHandle
  index WindowHandle
    WindowHandle
    ParentWindowHandle
  index Id
    Id
  index Root
    Root
    Id
  index Depth
    Depth
    Root
    Id
    .

define temp-table ttSessionTrigger no-undo
  field Id                   as integer
  field TriggerEvent         as character
    label 'Trigger-Event':T 
    format 'x(6)':U
  field DatabaseName         like ttDatabase.DatabaseName
  field TableName            like ttTable.TableName
  field FieldName            like ttField.FieldName
  field ShowMessage          as logical initial yes
    label 'Show message':T
    column-label 'Msg':T
    view-as toggle-box
  field WriteLogfile         as logical initial yes
    label 'Write logfile':T
    column-label 'Log':T
    view-as toggle-box
  field LogfileName          as character
    label 'Logfile name':T
    column-label 'Logfile name':T
  field AddSnapshot          as logical
    label 'Add snapshot':T
    column-label 'Sn':T
    view-as toggle-box
  field SnapshotName         as character
    label 'Snapshot name':T
    column-label 'Snapshot name':T
    format 'x(32)':U
  field SnapshotScope        as character initial {&K_SNAPSHOT_SCOPE_RECORD}
    label 'Snapshot scope':T
    column-label 'SnSc':T
  field AdditionalInfoFields as character
    label 'Additional info fields':T
    format 'x(1024)':U
  field AdditionalInfo       as logical
  field AdditionalInfoText   as character
  field Condition            as logical
  field ConditionText        as character
  field CustomCode           as logical
  field CustomCodeText       as character
  field TriggerActive         as logical
    label 'Act':U
    view-as toggle-box
  field TriggerFileName      as character
  field ProcedureHandle      as handle
  index Main is primary unique
    Id
  index TriggerEvent
    TriggerEvent
    DatabaseName
    TableName
    FieldName
  index TriggerObject
    DatabaseName
    TableName
    FieldName
    TriggerEvent
    .

define temp-table ttRecentQuery no-undo
  field WindowHandle as handle
  field Order        as integer
  field QueryText    as character
  field OrderLabel   as integer
  field QueryLabel   as character
  index Main is primary unique
    WindowHandle
    QueryText
  index Order
    WindowHandle
    Order descending
    .

define temp-table ttRecentQueryBuffer no-undo
  field WindowHandle  as handle
  field RecentQueryId as integer
  field DatabaseName  as character
  field TableName     as character
  field BufferName    as character
  field Order         as integer

  .

define temp-table ttQueryLink no-undo
  field SourceSeq  as integer
  field TargetSeq  as integer
  field StartPos   as integer
  field EndPos     as integer
  field BufferName as character
  field FieldName  like ttField.FieldName
  field FieldIndex as integer
  index Main is primary unique
    TargetSeq
    SourceSeq
    StartPos
    EndPos
  index StartPos
    TargetSeq
    StartPos
    EndPos
    SourceSeq
    .

define temp-table ttExternalRecord no-undo
  field Id             as integer
  field DatabaseName   like ttDatabase.DatabaseName
  field TableName      like ttTable.TableName
  field BufferHandle   as handle
  field TableHandle    as handle
  field RecordRowId    as rowid
  field RecordKey      as character
    format 'x(32000)':U
    label 'Key':U
  index Main is primary unique
    Id
  index Record
    TableName
    RecordRowId
    .

define temp-table ttQueryBuffer no-undo
  field QuerySeq       as integer
    format 'zzzzz9':U
    label 'Id':T
  field BufferName     as character
    format 'x(50)':U
    label 'Buffer name':T
  field BufferHandle     as handle
  field DatabaseName     like ttDatabase.DatabaseName
  field TableName        like ttTable.TableName
  field TableDisplayName as character
    format 'x(1024)':U
    label 'Table':U
  field Order            as integer
  index Main is primary unique
    QuerySeq
    BufferName
  index Order
    QuerySeq
    Order
    BufferName
    .

define temp-table ttQueryBufferField no-undo
  field FieldHandle    as handle
  field FieldName      like ttField.FieldName
  field FieldIndex     as integer
  field DisplayName    as character
    format 'x(32)':U
    label 'Field name':T
  field IsVirtual      like ttField.IsVirtual
  index Main is primary unique
    FieldName
    FieldIndex
    .

define temp-table ttIDEHandler no-undo
  field HandlerName as character
  field HandlerId   as integer
  index Main is primary unique
    HandlerName
    .

define temp-table ttQueryWindowExport no-undo
  &IF proversion >= '11.2':U &THEN
    serialize-name 'QueryWindow':U
  &ELSE
    xml-node-name 'QueryWindow':U
  &ENDIF
  field QuerySeq             as integer
    &IF proversion >= '11.2':U &THEN
      serialize-name 'QueryId':U
    &ELSE
      xml-node-name 'QueryId':U
    &ENDIF
    column-label 'Id':T
  field WindowMode           as character
  field WindowState          as character
  field QueryText            as character
  field WindowWidth          as decimal
  field WindowHeight         as decimal
  field WindowColumn         as decimal
  field WindowRow            as decimal
  field BrowseColumns        as character initial ?
  field HideFieldList        as logical   initial ?
  field Splitter1Pos         as integer   initial ?
  field RecordBrowseColumns  as character initial ?
  field RecordBrowseFields   as character initial ?
  field DisplayRawValues     as logical   initial ?
  field ObjSourceQuerySeq    as integer
  field ObjSourceBufferName  as character
  field ObjSourceFieldName   as character
  field ObjSourceFieldIndex  as integer
  field DeepResolveObjectIds as logical
  field NewQuerySeq          as integer
    &IF proversion >= '11.2':U &THEN
      serialize-hidden
    &ELSE
      xml-node-type 'HIDDEN':U
    &ENDIF
  field WindowSelected       as logical
    initial yes
    column-label '':U
    &IF proversion >= '11.2':U &THEN
      serialize-hidden
    &ELSE
      xml-node-type 'HIDDEN':U
    &ENDIF
  field BufferList           as character
    format 'x(120)':U
    column-label 'Buffers':T
    &IF proversion >= '11.2':U &THEN
      serialize-hidden
    &ELSE
      xml-node-type 'HIDDEN':U
    &ENDIF
  index Main is primary unique
    QuerySeq
  index WindowSelected
    WindowSelected
    QuerySeq
    .

define temp-table ttQueryBufferExport no-undo
  &IF proversion >= '11.2':U &THEN
    serialize-name 'QueryBuffer':U
  &ELSE
    xml-node-name 'QueryBuffer':U
  &ENDIF
  field QuerySeq       as integer
    &IF proversion >= '11.2':U &THEN
      serialize-hidden
    &ELSE
      xml-node-type 'HIDDEN':U
    &ENDIF
  field BufferId       as integer
  field DatabaseName   like ttDatabase.DatabaseName
  field TableName      like ttTable.TableName
  field BufferName     as character
  index Main is primary unique
    QuerySeq
    BufferId
  index BufferName is unique
    QuerySeq
    BufferName
    .

define temp-table ttQueryFieldOverlayExport no-undo
  &IF proversion >= '11.2':U &THEN
    serialize-name 'FieldOverlay':U
  &ELSE
    xml-node-name 'FieldOverlay':U
  &ENDIF
  field QuerySeq    as integer
    &IF proversion >= '11.2':U &THEN
      serialize-hidden
    &ELSE
      xml-node-type 'HIDDEN':U
    &ENDIF
  field BufferId    as integer
    &IF proversion >= '11.2':U &THEN
      serialize-hidden
    &ELSE
      xml-node-type 'HIDDEN':U
    &ENDIF
  field FieldName   like ttField.FieldName
  field FieldIndex  as integer
  field OverlayType as character
    xml-node-type 'ATTRIBUTE':U
  index Main is primary unique
    QuerySeq
    BufferId
    FieldName
    FieldIndex
    .

define temp-table ttRecentQueryExport no-undo
  &IF proversion >= '11.2':U &THEN
    serialize-name 'QueryHistory':U
  &ELSE
    xml-node-name 'QueryHistory':U
  &ENDIF
  field QuerySeq   as integer
    &IF proversion >= '11.2':U &THEN
      serialize-name 'QueryId':U
    &ELSE
      xml-node-name 'QueryId':U
    &ENDIF
  field Order      as integer
  field QueryText  as character
  index Main is primary unique
    QuerySeq
    Order
    .

define dataset dsQueryWindowExport
  &IF proversion >= '11.2':U &THEN
    serialize-name 'QueryScenario':U
  &ELSE
    xml-node-name 'QueryScenario':U
  &ENDIF
  for ttQueryWindowExport, ttQueryBufferExport, ttQueryFieldOverlayExport,
    ttRecentQueryExport
  data-relation QueryBuffer for ttQueryWindowExport, ttQueryBufferExport
    relation-fields(QuerySeq, QuerySeq)
    nested
  data-relation FieldOverlay for ttQueryBufferExport, ttQueryFieldOverlayExport
    relation-fields(QuerySeq, QuerySeq, BufferId, BufferId)
    nested
  data-relation RecentQuery for ttQueryWindowExport, ttRecentQueryExport
    relation-fields(QuerySeq, QuerySeq)
    nested
    .

define temp-table ttPersistentProcedure no-undo
  field ProcedureName as character
    format 'x(255)':U
    column-label 'Procedure':T
  index Main is primary unique
    ProcedureName
    .

define temp-table ttPersistentTempTable no-undo
  field ProcedureName like ttPersistentProcedure.ProcedureName
  field TableHandle   as handle
  field TableName     like ttTable.TableName
  index Main is primary unique
    ProcedureName
    TableHandle
  index TableName
    ProcedureName
    TableName
    .

define temp-table ttQueryAST no-undo
  field Id           as integer
  field ParentId     as integer
  field TokenStart   as integer
  field TokenEnd     as integer
  field TokenType    as integer
  field NodeType     as integer
  field TokenText    as character
    format 'x(255)':U
  field Level        as integer
  index Main is primary unique
    Id
  index ParentId
    ParentId
    TokenStart
    TokenEnd
  index TokenType
    TokenType
    TokenStart
    TokenEnd
    TokenText
  index NodeType
    NodeType
    TokenStart
    TokenEnd
    TokenText
  index TokenStart
    TokenStart
    TokenEnd
    TokenType
    TokenText
    .

define temp-table ttQueryCondition no-undo
  field StartPos           as integer
  field EndPos             as integer
  field LeftStartPos       as integer
  field LeftEndPos         as integer
  field ComparatorStartPos as integer
  field ComparatorEndPos   as integer
  field RightStartPos      as integer
  field RightEndPos        as integer
  index Main is primary unique
    StartPos
  EndPos
  index LeftStartPos
    LeftStartPos
    LeftEndPos
  index LeftEndPos
    LeftEndPos
    LeftStartPos
  index ComparatorStartPos
    ComparatorStartPos
    ComparatorEndPos
  index ComparatorEndPos
    ComparatorEndPos
    ComparatorStartPos
  index RightStartPos
    RightStartPos
    RightEndPos
  index RightEndPos
    RightEndPos
    RightStartPos
    .

define temp-table ttQueryLine no-undo
  field LineNo          as integer
  field StartPos        as integer
  field EndPos          as integer
  field ExceedingToken  as logical
  field LineLevel       as integer
  field LineIndentation as integer
  index Main is primary unique
    LineNo.

{adecomm/oeideservice.i}


&IF {&PROCESS-ARCHITECTURE} = 64 &THEN
  procedure SetForegroundWindow external 'user32.dll':U:
    define input  parameter hwnd    as int64 no-undo.
  end procedure.
&ELSE
  procedure SetForegroundWindow external 'user32.dll':U:
    define input  parameter hwnd    as long no-undo.
  end procedure.
&ENDIF

procedure GetKeyState external 'user32.dll':U:
    define input  parameter iVirtKey as long      no-undo.
    define return parameter iResult  as short     no-undo.
end procedure.

procedure ExpandEnvironmentStringsA external "kernel32.dll":
  define input  parameter cString        as character no-undo.
  define output parameter cRetString     as character no-undo.
  define input  parameter iStringSize    as long      no-undo.
  define return parameter iRetStringSize as long      no-undo.
end procedure.

&IF {&PROCESS-ARCHITECTURE} = 64 &THEN
  procedure RegOpenKeyExA external 'advapi32':U:
    define input  parameter iKey       as long      no-undo.
    define input  parameter cSubKey    as character no-undo.
    define input  parameter iOptions   as long      no-undo.
    define input  parameter iDesired   as long      no-undo.
    define output parameter iResult    as int64     no-undo.
    define return parameter iRetResult as int64     no-undo.
  end procedure.
&ELSE
  procedure RegOpenKeyExA external 'advapi32':U:
    define input  parameter iKey       as long      no-undo.
    define input  parameter cSubKey    as character no-undo.
    define input  parameter iOptions   as long      no-undo.
    define input  parameter iDesired   as long      no-undo.
    define output parameter iResult    as long      no-undo.
    define return parameter iRetResult as long      no-undo.
  end procedure.
&ENDIF

&IF {&PROCESS-ARCHITECTURE} = 64 &THEN
  procedure RegQueryValueExA external 'advapi32':U:
    define input  parameter ikey         as long      no-undo.
    define input  parameter iPValueName  as character no-undo.
    define input  parameter iPdwReserved as long      no-undo.
    define output parameter iPdwType     as long      no-undo.
    define input  parameter iPbData      as int64     no-undo.
    define output parameter iPcbData     as long      no-undo.
    define return parameter iPResult     as long      no-undo.
  end procedure.
&ELSE
  procedure RegQueryValueExA external 'advapi32':U:
    define input  parameter ikey         as long      no-undo.
    define input  parameter iPValueName  as character no-undo.
    define input  parameter iPdwReserved as long      no-undo.
    define output parameter iPdwType     as long      no-undo.
    define input  parameter iPbData      as long      no-undo.
    define output parameter iPcbData     as long      no-undo.
    define return parameter iPResult     as long      no-undo.
  end procedure.
&ENDIF

procedure RegCloseKey external 'advapi32':U:
  define input  parameter iKey     as long      no-undo.
  define return parameter iPResult as long      no-undo.
end procedure.

&IF {&PROCESS-ARCHITECTURE} = 64 &THEN
  procedure GetParent external 'user32.dll':U:
     define input  parameter plHWND    as int64     no-undo.
     define return parameter plWinLong as long      no-undo.
  end procedure.
&ELSE
  procedure GetParent external 'user32.dll':U:
     define input  parameter plHWND    as long      no-undo.
     define return parameter plWinLong as long      no-undo.
end procedure.
&ENDIF

&IF {&PROCESS-ARCHITECTURE} = 64 &THEN
  procedure GetWindowRect external 'user32.dll':U:
    define input  parameter hWnd    as int64     no-undo.
    define output parameter lpRect  as memptr    no-undo.
    define return parameter iResult as long      no-undo.
  end procedure.
&ELSE
  procedure GetWindowRect external 'user32.dll':U:
    define input  parameter hWnd    as long      no-undo.
    define output parameter lpRect  as memptr    no-undo.
    define return parameter iResult as long      no-undo.
  end procedure.
&ENDIF

&IF {&PROCESS-ARCHITECTURE} = 64 &THEN
  procedure GetWindowLongA external 'user32.dll':U:
    define input  parameter phwnd       as int64      no-undo.
    define input  parameter cindex      as long      no-undo.
    define return parameter ReturnValue as long      no-undo.
  end procedure.
&ELSE
  procedure GetWindowLongA external 'user32.dll':U:
    define input  parameter phwnd       as long      no-undo.
    define input  parameter cindex      as long      no-undo.
    define return parameter ReturnValue as long      no-undo.
  end procedure.
&ENDIF

&IF {&PROCESS-ARCHITECTURE} = 64 &THEN
  procedure SetWindowLongA external 'user32.dll':U:
    define input  parameter hWnd         as int64         no-undo.
    define input  parameter nIndex       as long          no-undo.
    define input  parameter dwNewLong    as unsigned-long no-undo.
    define return parameter ReturnValue  as long          no-undo.
  end procedure.
&ELSE
  procedure SetWindowLongA external 'user32.dll':U:
    define input  parameter hWnd         as long          no-undo.
    define input  parameter nIndex       as long          no-undo.
    define input  parameter dwNewLong    as unsigned-long no-undo.
    define return parameter ReturnValue  as long          no-undo.
  end procedure.
&ENDIF

&IF {&PROCESS-ARCHITECTURE} = 64 &THEN
  procedure SetWindowPos external 'user32.dll':U:
    define input  parameter hWnd            as int64         no-undo.
    define input  parameter hWndInsertAfter as int64         no-undo.
    define input  parameter X               as long          no-undo.
    define input  parameter Y               as long          no-undo.
    define input  parameter cx              as long          no-undo.
    define input  parameter cy              as long          no-undo.
    define input  parameter uFlags          as long          no-undo.
    define return parameter ReturnValue     as long          no-undo.
  end procedure.
&ELSE
  procedure SetWindowPos external 'user32.dll':U:
    define input  parameter hWnd            as long          no-undo.
    define input  parameter hWndInsertAfter as long          no-undo.
    define input  parameter X               as long          no-undo.
    define input  parameter Y               as long          no-undo.
    define input  parameter cx              as long          no-undo.
    define input  parameter cy              as long          no-undo.
    define input  parameter uFlags          as long          no-undo.
    define return parameter ReturnValue     as long          no-undo.
  end procedure.
&ENDIF

&IF {&PROCESS-ARCHITECTURE} = 64 &THEN
  procedure ShellExecuteA external 'shell32.dll':U:
    define input  parameter hwnd         as int64. /* Handle to parent window */
    define input  parameter lpOperation  as char.  /* Operation to perform: open, print */
    define input  parameter lpFile       as char.  /* Document or executable name */
    define input  parameter lpParameters as char.  /* Command line parameters to executable in lpFile */
    define input  parameter lpDirectory  as char.  /* Default directory */
    define input  parameter nShowCmd     as long.  /* whether shown when opened: */
                                                   /* 0 hidden, 1 normal, minimized 2, maximized 3, etc.*/
                                                   /* 0 if lpFile is a document */
    define return parameter hInstance    as long.  /* >32 -> Success ; <=32 -> Errorcode */
  end procedure.
&ELSE
  procedure ShellExecuteA external 'shell32.dll':U:
    define input  parameter hwnd         as long. /* Handle to parent window */
    define input  parameter lpOperation  as char. /* Operation to perform: open, print */
    define input  parameter lpFile       as char. /* Document or executable name */
    define input  parameter lpParameters as char. /* Command line parameters to executable in lpFile */
    define input  parameter lpDirectory  as char. /* Default directory */
    define input  parameter nShowCmd     as long. /* whether shown when opened: */
                                                  /* 0 hidden, 1 normal, minimized 2, maximized 3, etc.*/
                                                  /* 0 if lpFile is a document */
    define return parameter hInstance    as long. /* >32 -> Success ; <=32 -> Errorcode */
  end procedure.
&ENDIF

&IF {&PROCESS-ARCHITECTURE} = 64 &THEN
  procedure FindWindowA external "user32.dll":
    define input  parameter iClassName as long.
    define input  parameter cCaption   as character.
    define return parameter iHandle    as int64.
  end procedure.
&ELSE
  procedure FindWindowA external "user32.dll":
    define input  parameter iClassName as long.
    define input  parameter cCaption   as character.
    define return parameter iHandle    as long.
  end procedure.
&ENDIF

&IF {&PROCESS-ARCHITECTURE} = 64 &THEN
  procedure SetFocus external "user32.dll":
    define input  parameter hWnd     as int64         no-undo.
    define return parameter hPrevWnd as long          no-undo.
  end procedure.
&ELSE
  procedure SetFocus external "user32.dll":
    define input  parameter hWnd as long          no-undo.
    define return parameter hPrevWnd as long          no-undo.
  end procedure.
&ENDIF

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-PREPROCESSOR-BLOCK 

/* ********************  Preprocessor Definitions  ******************** */

&Scoped-define PROCEDURE-TYPE Window
&Scoped-define DB-AWARE no

/* Name of designated FRAME-NAME and/or first browse and/or first query */
&Scoped-define FRAME-NAME fQuery
&Scoped-define BROWSE-NAME brDatabase

/* Internal Tables (found by Frame, Query & Browse Queries)             */
&Scoped-define INTERNAL-TABLES ttDatabase ttField ttIndex ~
ttTableRelationView ttTable

/* Definitions for BROWSE brDatabase                                    */
&Scoped-define FIELDS-IN-QUERY-brDatabase ttDatabase.DatabaseName ttDatabase.PhysicalName   
&Scoped-define ENABLED-FIELDS-IN-QUERY-brDatabase   
&Scoped-define SELF-NAME brDatabase
&Scoped-define QUERY-STRING-brDatabase FOR EACH ttDatabase WHERE true   NO-LOCK   BY ttDatabase.DisplayPriority BY ttDatabase.DatabaseName
&Scoped-define OPEN-QUERY-brDatabase OPEN QUERY brDatabase FOR EACH ttDatabase WHERE true   NO-LOCK   BY ttDatabase.DisplayPriority BY ttDatabase.DatabaseName.
&Scoped-define TABLES-IN-QUERY-brDatabase ttDatabase
&Scoped-define FIRST-TABLE-IN-QUERY-brDatabase ttDatabase


/* Definitions for BROWSE brField                                       */
&Scoped-define FIELDS-IN-QUERY-brField ttField.FieldName ttField.IsVirtual ttField.DataType ttField.FieldExtent ttField.FieldDecimals ttField.FieldInitialValue ttField.FieldFormat ttField.FieldLabel ttField.FieldColumnLabel ttField.IsMandatory ttField.Domain   
&Scoped-define ENABLED-FIELDS-IN-QUERY-brField   
&Scoped-define SELF-NAME brField
&Scoped-define QUERY-STRING-brField FOR EACH ttField WHERE true and ttField.DatabaseName = ttDatabase.DatabaseName and ttField.TableName = ttTable.TableName and ttField.FieldFilterMatches = yes and ( glShowVirtualFields    or ttField.IsVirtual <> yes )  NO-LOCK
&Scoped-define OPEN-QUERY-brField OPEN QUERY brField FOR EACH ttField WHERE true and ttField.DatabaseName = ttDatabase.DatabaseName and ttField.TableName = ttTable.TableName and ttField.FieldFilterMatches = yes and ( glShowVirtualFields    or ttField.IsVirtual <> yes )   NO-LOCK.
&Scoped-define TABLES-IN-QUERY-brField ttField
&Scoped-define FIRST-TABLE-IN-QUERY-brField ttField


/* Definitions for BROWSE brIndex                                       */
&Scoped-define FIELDS-IN-QUERY-brIndex ttIndex.IsPrimary ttIndex.IndexName ttIndex.IsUnique ttIndex.IsVirtual ttIndex.IndexFields   
&Scoped-define ENABLED-FIELDS-IN-QUERY-brIndex   
&Scoped-define SELF-NAME brIndex
&Scoped-define QUERY-STRING-brIndex FOR EACH ttIndex WHERE true   AND ttIndex.DatabaseName = ttDatabase.DatabaseName   and ttIndex.TableName = ttTable.TableName   AND ttIndex.IndexFilterMatches = yes   AND ttIndex.IndexFieldFilterMatches = yes  and ( glShowVirtualIndices    or ttIndex.IsVirtual <> yes )   NO-LOCK
&Scoped-define OPEN-QUERY-brIndex OPEN QUERY brIndex FOR EACH ttIndex WHERE true   AND ttIndex.DatabaseName = ttDatabase.DatabaseName   and ttIndex.TableName = ttTable.TableName   AND ttIndex.IndexFilterMatches = yes   AND ttIndex.IndexFieldFilterMatches = yes  and ( glShowVirtualIndices    or ttIndex.IsVirtual <> yes )   NO-LOCK.
&Scoped-define TABLES-IN-QUERY-brIndex ttIndex
&Scoped-define FIRST-TABLE-IN-QUERY-brIndex ttIndex


/* Definitions for BROWSE brRelation                                    */
&Scoped-define FIELDS-IN-QUERY-brRelation ttTableRelationView.RelatedTableName ttTableRelationView.RelationType ttTableRelationView.ParentRelation ttTableRelationView.RelatedFields ttTableRelationView.FieldDetails  
&Scoped-define ENABLED-FIELDS-IN-QUERY-brRelation   
&Scoped-define SELF-NAME brRelation
&Scoped-define QUERY-STRING-brRelation FOR EACH ttTableRelationView WHERE true   AND ttTableRelationView.DatabaseName = ttDatabase.DatabaseName   and ttTableRelationView.ReferenceTableName = ttTable.TableName   AND ttTableRelationView.TableFilterMatches = yes   AND ttTableRelationView.FieldFilterMatches = yes   NO-LOCK
&Scoped-define OPEN-QUERY-brRelation OPEN QUERY brRelation FOR EACH ttTableRelationView WHERE true   AND ttTableRelationView.DatabaseName = ttDatabase.DatabaseName   and ttTableRelationView.ReferenceTableName = ttTable.TableName   AND ttTableRelationView.TableFilterMatches = yes   AND ttTableRelationView.FieldFilterMatches = yes   AND ttTableRelationView.ParentRelationFilterMatches = yes   NO-LOCK.
&Scoped-define TABLES-IN-QUERY-brRelation ttTableRelationView
&Scoped-define FIRST-TABLE-IN-QUERY-brRelation ttTableRelationView


/* Definitions for BROWSE brTable                                       */
&Scoped-define FIELDS-IN-QUERY-brTable ttTable.TableName ttTable.ShortDescription  
&Scoped-define ENABLED-FIELDS-IN-QUERY-brTable   
&Scoped-define SELF-NAME brTable
&Scoped-define QUERY-STRING-brTable FOR EACH ttTable WHERE true   AND ttTable.DatabaseName = ttDatabase.DatabaseName   AND ttTable.TableFilterMatches = yes   AND ttTable.TableFieldFilterMatches = yes   AND (glShowHiddenTables     OR (  not can-do('sys*':U, ~
       ttTable.TableName)       and not can-do('_*':U, ~
       ttTable.TableName)))   NO-LOCK
&Scoped-define OPEN-QUERY-brTable OPEN QUERY brTable FOR EACH ttTable WHERE true   AND ttTable.DatabaseName = ttDatabase.DatabaseName   AND ttTable.TableFilterMatches = yes   AND ttTable.TableFieldFilterMatches = yes   AND (glShowHiddenTables     OR (  not can-do('sys*':U, ~
       ttTable.TableName)       and not can-do('_*':U, ~
       ttTable.TableName)))   NO-LOCK.
&Scoped-define TABLES-IN-QUERY-brTable ttTable
&Scoped-define FIRST-TABLE-IN-QUERY-brTable ttTable


/* Definitions for FRAME fQuery                                         */

/* Standard List Definitions                                            */
&Scoped-Define ENABLED-OBJECTS gdIndexUsage btnClearFieldLabelFilter ~
gcFieldLabelFilter gcFieldDummy brDatabase btnConnectDB btnDisconnectDB ~
btnRefresh gcTableFilter btnClearTableFilter gcTableFieldFilter ~
btnClearTableFieldFilter brTable giDisplayMode glInvertQuery gcFieldFilter ~
btnClearFieldFilter brField gcIndexFilter btnClearIndexFilter ~
gcIndexFieldFilter btnClearIndexFieldFilter brIndex gcBufferName ~
btnClearBufferPattern btnBuffer1 btnBuffer2 btnBuffer3 btnBuffer4 ~
glDefineBuffer glCompanyViaClass glExclusiveLock glNoError glIfStatement ~
glNot glDoBlock glOnError giOnErrorPhrase giQueryTypeModifier gcBlockName btnClearBlockName ~
btnBlock1 btnBlock2 btnBlock3 btnBlock4 glDefineBlock glRetryBlock ~
glFinallyBlock giQueryType btnCopyToClipboard btnExecuteQuery btnResetAll ~
btnIncreaseIndentation btnDecreaseIndentation btnResetIndentation btnOf ~
gcQueryText brRelation gcRelationFilter gcRelationFieldFilter ~
btnClearRelationFilter btnClearRelationFieldFilter glDefineVariables ~
glUseVirtualIndexIncludes
&Scoped-Define DISPLAYED-OBJECTS gdIndexUsage gcFieldLabelFilter ~
gcFieldDummy gcTableFilter gcTableFieldFilter giDisplayMode glInvertQuery gcFieldFilter ~
gcIndexFilter gcIndexFieldFilter gcBufferName glDefineBuffer ~
glCompanyViaClass glExclusiveLock glNoError glIfStatement glNot glDoBlock ~
giOnErrorPhrase glOnError giQueryTypeModifier gcBlockName glDefineBlock glRetryBlock ~
glFinallyBlock giQueryType gcQueryText gcRelationFilter ~
gcRelationFieldFilter glDefineVariables glUseVirtualIndexIncludes

/* Custom List Definitions                                              */
/* List-1,List-2,List-3,List-4,List-5,List-6                            */

/* _UIB-PREPROCESSOR-BLOCK-END */
&ANALYZE-RESUME


/* ************************  Function Prototypes ********************** */

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cBeautifyQueryText hQueryWindow 
function qg_cBeautifyQueryText returns character
  ( pcQueryText as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cBrowseColumnList hQueryWindow 
function qg_cBrowseColumnList returns character
  ( phBrowse      as handle,
    plBuffernames as logical,
    plAllColumns  as logical,
    plColumnWidth as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_clBrowseValues hQueryWindow 
function qg_clBrowseValues returns longchar
  ( phBrowse    as handle,
    plRawValues as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cBufferCompare hQueryWindow 
function qg_cBufferCompare returns character
  ( phBuffer1 as handle,
    phBuffer2 as handle ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cBufferFieldValue hQueryWindow 
function qg_cBufferFieldValue returns character
  ( phBufferField as handle,
    piValueIndex  as integer ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cColumnFieldName hQueryWindow 
function qg_cColumnFieldName returns character
  ( phColumn      as handle,
    plBuffernames as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cCreateQueryText hQueryWindow 
function qg_cCreateQueryText returns character
  ( pcFieldList as character,
    plAddTags   as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cCreateRelationValueList hQueryWindow 
function qg_cCreateRelationValueList returns character
  ( pcFieldList      as character,
    piRelationId     as integer,
    plParentRelation as logical,
    pcBufferName     as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cCreateRelatedWhereClause hQueryWindow 
function qg_cCreateRelatedWhereClause returns character
  ( buffer pbttTableRelation for ttTableRelation,
    plParent           as logical,
    pcBufferName       as character,
    pcParentBufferName as character,
    piParentQuerySeq   as integer ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cCreateWhereClause hQueryWindow 
function qg_cCreateWhereClause returns character
  ( pcDatabaseName   as character,
    pcTableNames     as character,
    pcBufferNames    as character,
    pcFieldList      as character,
    pcFieldLabelList as character,
    plStartWithWhere as logical, 
    piValueMode      as integer,
    pcValueList      as character,
    piAccessMode     as integer,
    plAddTags        as logical,
    piIndentBlanks   as integer ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cCurrentFieldList hQueryWindow 
function qg_cCurrentFieldList returns character
  (  ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cExtractFieldName hQueryWindow 
function qg_cExtractFieldName returns character
  ( pcFieldName as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cFieldAssignments hQueryWindow 
function qg_cFieldAssignments returns character
  ( plInsertMode as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cFieldAssignStatement hQueryWindow 
function qg_cFieldAssignStatement returns character
  ( plInsertMode as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cFieldValues hQueryWindow 
function qg_cFieldValues returns character
  ( phBuffer    as handle,
    phOldBuffer as handle,
    pcFieldList as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cFileName hQueryWindow
function qg_cFileName returns character 
  (pcFilename as character) forward.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME



&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cFilterEntryMatchcode hQueryWindow 
function qg_cFilterEntryMatchcode returns character
  ( pcFilterEntry as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cFixQuerySeq hQueryWindow 
function qg_cFixQuerySeq returns character
  ( pcQuerytext as character,
    piQuerySeq  as integer ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cFormattedFieldName hQueryWindow 
function qg_cFormattedFieldName returns character
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcFieldName    as character,
    piIndex        as integer ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cGetBufferBaseName hQueryWindow 
function qg_cGetBufferBaseName returns character
  ( plCustomBuffer as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cGetCompany hQueryWindow 
function qg_cGetCompany returns character
  ( pcTableName as character,
    pcCompany   as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cGetCompanyInclude hQueryWindow 
function qg_cGetCompanyInclude returns character
  ( pcTableName as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cGetDefaultValue hQueryWindow 
function qg_cGetDefaultValue returns character
  ( pcDatatype as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cGetFieldAssignmentsStatement hQueryWindow 
function qg_cGetFieldAssignmentsStatement returns character
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcBufferName   as character,
    pcFieldList    as character,
    piValueMode    as integer,
    pcValueList    as character,
    plAddTags      as logical,
    piIndentBlanks as integer ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cGetPrimaryKeyValues hQueryWindow 
function qg_cGetPrimaryKeyValues returns character
  ( phBuffer            as handle,
    pcSplitter          as character,
    plResolveObjectIds  as logical,
    plIncludeFieldNames as logical,
    plIncludeCompany    as logical,
    plQuoteValues       as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cGetPutStatement hQueryWindow 
function qg_cGetPutStatement returns character
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcBufferName   as character,
    pcFieldList    as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cGetRelationField hQueryWindow 
function qg_cGetRelationField returns character
  ( buffer pbttTableRelation      for ttTableRelation,
    buffer pbttTableRelationField for ttTableRelationField,
    pcBufferName    as character,
    plParentValue   as logical,
    plKeyAllowed    as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cGetSelectedFields hQueryWindow 
function qg_cGetSelectedFields returns character
  ( pcBufferName as character,
    pcSeparator  as character,
    plQuoted     as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cIndexFieldValues hQueryWindow 
function qg_cIndexFieldValues returns character
  ( phBuffer    as handle,
    pcIndexName as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cMaximumDataTypeFormat hQueryWindow
function qg_cMaximumDataTypeFormat returns character 
  ( pcDataType as character,
    piDecimals as integer ) forward.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cModulePathByChar hQueryWindow
function qg_cModulePathByChar returns character 
  ( pcChar as character ) forward.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME



&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cOverlayFieldValue hQueryWindow 
function qg_cOverlayFieldValue returns character
  ( buffer pbttFieldOverlay for ttFieldOverlay,
    pcFieldValue as character,
    plDeep       as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cParamListReadValue hQueryWindow 
function qg_cParamListReadValue returns character
  ( pcParamList as character,
    pcParamName as character,
    pcSplitter  as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cParamListWriteCharacter hQueryWindow 
function qg_cParamListWriteCharacter returns character
  ( pcParamList  as character,
    pcParamName  as character,
    pcParamValue as character,
    pcSplitter   as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cParamListWriteDecimal hQueryWindow 
function qg_cParamListWriteDecimal returns character
  ( pcParamList  as character,
    pcParamName  as character,
    pdParamValue as decimal,
    pcSplitter   as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cParamListWriteInteger hQueryWindow 
function qg_cParamListWriteInteger returns character
  ( pcParamList  as character,
    pcParamName  as character,
    piParamValue as integer,
    pcSplitter   as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cParamListWriteLogical hQueryWindow 
function qg_cParamListWriteLogical returns character
  ( pcParamList  as character,
    pcParamName  as character,
    plParamValue as logical,
    pcSplitter   as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cPutStatement hQueryWindow 
function qg_cPutStatement returns character
  ( plInsertMode as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cQueryIndexInfo hQueryWindow 
function qg_cQueryIndexInfo returns character
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcQueryText    as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cQueryLabel hQueryWindow 
function qg_cQueryLabel returns character
  ( pcQueryText as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cQueryLabel hQueryWindow 
function qg_cQueryWindowFieldList returns character
  ( phWindow      as handle,
    plBuffernames as logical,
    plAllFields   as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cReadRegistryValue hQueryWindow 
function qg_cReadRegistryValue returns character
  ( piSection as integer,
    pcSubKey  as character,
    pcKeyName as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cReadRegistryValue hQueryWindow 
function qg_cReplaceColumn returns character
  ( pcColumnList as character,
    pcColumn     as character,
    pcNewColumn  as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cResolveObjectId hQueryWindow 
function qg_cResolveObjectId returns character
  ( pcDatabaseName as character,
    pcFieldName    as character,
    pcObjectId     as character,
    plForceQuote   as logical,
    plDeep         as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cResolveObjectIdForBuffer hQueryWindow 
function qg_cResolveObjectIdForBuffer returns character
  ( pcObjectId   as character,
    phBuffer     as handle,
    plTable      as logical,
    plForceQuote as logical,
    plDeep       as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cSoundexCode hQueryWindow 
function qg_cSoundexCode returns character
  ( pcText as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cStacktrace hQueryWindow 
function qg_cStacktrace returns character
  (  )  FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cSubstituteChar hQueryWindow 
function qg_cSubstituteChar returns character
  ( pcString   as character,
    pcFromChar as character,
    pcToChar   as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cSubstituteLinkTokens hQueryWindow 
function qg_cSubstituteLinkTokens returns character
  ( pcText          as character,
    piTargetSeq     as integer,
    phLinkTempTable as handle ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cSubstituteQueryLinkTokens hQueryWindow 
function qg_cSubstituteQueryLinkTokens returns character
  ( phWindow as handle ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cTaggedValue hQueryWindow 
function qg_cTaggedValue returns character
  ( pcText   as character,
    plAddTag as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_cTTWidgetPool hQueryWindow 
function qg_cTTWidgetPool returns character
  (  ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_dIndexUsage hQueryWindow 
function qg_dIndexUsage returns decimal
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcIndexName    as character,
    pcFieldList    as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_dParamListReadValue hQueryWindow 
function qg_dParamListReadValue returns decimal
  ( pcParamList as character,
    pcParamName as character,
    pcSplitter  as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_hGetWidgetByName hQueryWindow 
function qg_hGetWidgetByName returns handle
  ( phContainer  as handle,
    pcWidgetName as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_hStartSessionTrigger hQueryWindow 
function qg_hStartSessionTrigger returns handle
  ( piTriggerId as integer ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_iExtractIndex hQueryWindow 
function qg_iExtractIndex returns integer
  ( pcFieldName as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_iFilterSeq hQueryWindow 
function qg_iFilterSeq returns integer
  (  ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_iGetHandlerId hQueryWindow 
function qg_iGetHandlerId returns integer
  ( pcHandlerName as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_iParamListReadValue hQueryWindow 
function qg_iParamListReadValue returns integer
  ( pcParamList as character,
    pcParamName as character,
    pcSplitter  as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_lcClipboardValue hQueryWindow 
function qg_lcClipboardValue returns longchar
  (  ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_lCheckLinkReference hQueryWindow 
function qg_lCheckLinkReference returns logical
  ( piQuerySeq     as integer,
    pcQuerySeqList as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION qg_lIsHostReachable hQueryWindow 
function qg_lIsHostReachable returns logical
  ( pcHost    as character, 
    pcService as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_lParamListReadValue hQueryWindow 
function qg_lParamListReadValue returns logical
  ( pcParamList as character,
    pcParamName as character,
    pcSplitter  as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_lQueryOpen hQueryWindow 
function qg_lQueryOpen returns logical
  ( phQuery        as handle,
    pcQueryText    as character,
    phParentWindow as handle ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_lSelectNextQueryCondition hQueryWindow 
function qg_lSelectNextQueryCondition returns logical
  ( phEditor as handle,
    plNext   as logical ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_lTestBits hQueryWindow 
function qg_lTestBits returns logical
  ( piTestValue as integer,
    piRefValue  as integer ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _FUNCTION-FORWARD qg_lUniqueQuery hQueryWindow 
function qg_lUniqueQuery returns logical
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcFieldList    as character ) FORWARD.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


/* ***********************  Control Definitions  ********************** */

/* Define the widget handle for the window                              */
DEFINE VAR hQueryWindow AS WIDGET-HANDLE NO-UNDO.

/* Menu Definitions                                                     */
DEFINE SUB-MENU m_File 
       MENU-ITEM mi_SaveQueryScenario LABEL "Save query scenario"
       MENU-ITEM mi_LoadQueryScenario LABEL "Load query scenario"
       RULE
       MENU-ITEM mi_Exit        LABEL "Exit"          .

DEFINE SUB-MENU m_Edit 
       MENU-ITEM mi_CopyQueryText LABEL "Copy query text"
       MENU-ITEM mi_InsertQueryText LABEL "Insert query text"
       RULE
       MENU-ITEM mi_CopyQueryScenario LABEL "Copy query scenario"
       MENU-ITEM mi_PasteQueryScenario LABEL "Paste query scenario".

DEFINE SUB-MENU m_Tools 
       MENU-ITEM mi_ExecuteQuery LABEL "Execute query"  ACCELERATOR "F2"
       MENU-ITEM mi_FindObjectIdRecord LABEL "Find object id record"  ACCELERATOR "SHIFT-F2"
       RULE
       MENU-ITEM mi_AddPersistentTempTable LABEL "Add persistent temp table" ACCELERATOR "F9"
       MENU-ITEM mi_AddSnapshot LABEL "Add snpapshot"  ACCELERATOR "F10"
       RULE
       MENU-ITEM mi_ImportTDF LABEL "Import TDF as Snapshot"
       MENU-ITEM mi_ImportPDS LABEL "Import PDS as Snapshot"
       RULE
       MENU-ITEM mi_ImportDatasetFile LABEL "Import Dataset File"
       MENU-ITEM mi_ImportTempTableFile LABEL "Import Temp-Table File"
       RULE
       MENU-ITEM mi_CopyQueryGeneratorSourcefilePath LABEL "Copy Query Generator Sourcefile Path"
       MENU-ITEM mi_CopyQueryGeneratorSource LABEL "Copy Query Generator Source"
       RULE
       MENU-ITEM mi_ResetAll    LABEL "Reset"          ACCELERATOR "F12".

DEFINE SUB-MENU m_Options 
       MENU-ITEM mi_InsertMode  LABEL "Insert mode"   
              TOGGLE-BOX
       RULE
       MENU-ITEM mi_ShowQueryTypeModifier  LABEL "Show Query type modifier"
              TOGGLE-BOX
       MENU-ITEM mi_AlwaysUseFindFirst  LABEL "Always use 'find first'"
              TOGGLE-BOX
       MENU-ITEM mi_AlwaysUseCanFindFirst  LABEL "Always use 'can-find first'"
              TOGGLE-BOX
       MENU-ITEM mi_UseVirtualIndexApi  LABEL "Use virtual index API"
              TOGGLE-BOX
       RULE
       MENU-ITEM mi_OpenQueryWindowPersistentTT LABEL "Open query window for persistent temp-tables"
              TOGGLE-BOX
       MENU-ITEM mi_OpenQueryWindowSnapshotTT LABEL "Open query window for snapshots"
              TOGGLE-BOX
       RULE
       MENU-ITEM mi_RepositoryLanguage LABEL "Repository Language".

DEFINE SUB-MENU m_Window 
       MENU-ITEM mi_SlimMode    LABEL "Slim mode"     
              TOGGLE-BOX
       MENU-ITEM mi_RestoreDefaultWindowSize LABEL "Restore default window size"
       RULE
       MENU-ITEM mi_OpenQueryWindowListWindow LABEL "Query windows" ACCELERATOR "CTRL-F7"
       MENU-ITEM mi_CloseAllQueryWindows LABEL "Close all query windows"
       RULE
       MENU-ITEM mi_SessionTriggers LABEL "Session triggers".

DEFINE SUB-MENU m_Help 
       MENU-ITEM mi_OpenQGWiki     LABEL "pA-Wiki (Query Generator)".
       MENU-ITEM mi_OpenPluginWiki LABEL "pA-Wiki (Query Generator Plugin)".
       RULE
       MENU-ITEM mi_About          LABEL "About Query Generator".

DEFINE MENU MENU-BAR-hQueryWindow MENUBAR
       SUB-MENU  m_File         LABEL "File"          
       SUB-MENU  m_Edit         LABEL "Edit"          
       SUB-MENU  m_Tools        LABEL "Tools"         
       SUB-MENU  m_Options      LABEL "Options"       
       SUB-MENU  m_Window       LABEL "Window"        
       SUB-MENU  m_Help         LABEL "Help"          .

DEFINE MENU POPUP-MENU-brDatabase 
       MENU-ITEM mi_CopyDatabaseName LABEL "Copy name"     
       MENU-ITEM mi_CopyPhysicalName LABEL "Copy physical name"
       RULE
       MENU-ITEM mi_ReconcileDatabaseSchema LABEL "Incremental Dump && Reconcile of Database Schema"
       MENU-ITEM mi_LoadDataDefinitions LABEL "Load data definitions (.df)"
       RULE
       MENU-ITEM mi_DataDictionary LABEL "Data Dictionary"
       MENU-ITEM mi_DataAdministration LABEL "Data Administration"
       RULE
       MENU-ITEM mi_ExportJSON LABEL "Export Dataset as JSON"
       MENU-ITEM mi_ExportXML LABEL "Export Dataset as XML".

DEFINE SUB-MENU m_SelectedFields 
       MENU-ITEM mi_CopyFieldAssignStatement LABEL "Copy assign statement"
       MENU-ITEM mi_CopyFieldAssignments LABEL "Copy field assignments"
       MENU-ITEM mi_CopyPutStatement LABEL "Copy put statement"
       RULE
       MENU-ITEM mi_CopyFieldNamesCommaSeparated LABEL "Copy names (comma separated)"
       MENU-ITEM mi_CopyFieldNamesSpaceSeparated LABEL "Copy names (space separated)"
       MENU-ITEM mi_CopyFieldNamesLineSeparated LABEL "Copy names (line separated)"
       RULE
       MENU-ITEM mi_SessionTriggerAddFieldsAssign LABEL "Add session triggers (assign)"
       MENU-ITEM mi_SessionTriggerRemoveFieldsAssign LABEL "Remove session triggers (assign)"
       RULE
       MENU-ITEM mi_FindFieldIndex LABEL "Find index for selected fields"
       MENU-ITEM mi_FindFieldTables LABEL "Find tables containing selected fields".

DEFINE MENU POPUP-MENU-brField 
       MENU-ITEM mi_CopyFieldName LABEL "Copy name"     
       MENU-ITEM mi_CopyFullFieldName LABEL "Copy name"     
       RULE
       MENU-ITEM mi_SelectAllFields LABEL "Selected all"  
       SUB-MENU  m_SelectedFields LABEL "Selected fields"
       RULE
       MENU-ITEM mi_CopyFieldInitialValue LABEL "Copy initial value"
       MENU-ITEM mi_CopyFieldFormat LABEL "Copy format"   
       MENU-ITEM mi_CopyFieldLabel LABEL "Copy label"    
       MENU-ITEM mi_CopyFieldColumnLabel LABEL "Copy column label"
       MENU-ITEM mi_CopyFieldDomain LABEL "Copy Domain"   
       RULE
       MENU-ITEM mi_SessionTriggerFieldAssign LABEL "Add session trigger (assign)"
       RULE
       MENU-ITEM mi_VirtualFields LABEL "Show Virtual Fields"
              TOGGLE-BOX
       RULE
       MENU-ITEM mi_FilterDataypes LABEL "Dataype filter".

DEFINE MENU POPUP-MENU-brIndex 
       MENU-ITEM mi_CopyIndexName LABEL "Copy name"     
       RULE
       MENU-ITEM mi_CopyIndexFields LABEL "Copy fields"   
       RULE
       MENU-ITEM mi_ModifyIndexQueryFields LABEL "Modify query fields"
       RULE
       MENU-ITEM mi_VirtualIndices LABEL "Show Virtual Indices"
              TOGGLE-BOX.

DEFINE MENU POPUP-MENU-brRelation 
       MENU-ITEM mi_CopyRelationTable LABEL "Copy table"     
       RULE
       MENU-ITEM mi_CopyRelationFields LABEL "Copy fields"   
       RULE
       MENU-ITEM mi_SwitchToRelatedTable LABEL "Swtich to related table".
       MENU-ITEM mi_ModifyRelationQueryFields LABEL "Modify query fields".
       RULE
       MENU-ITEM mi_ShowChildRelations LABEL "Show child relations"
              TOGGLE-BOX.
       MENU-ITEM mi_ShowParentRelations LABEL "Show parent relations"
              TOGGLE-BOX.

DEFINE SUB-MENU m_TableCreateTrigger 
       MENU-ITEM mi_CopyTableCreateTrigger LABEL "Copy trigger name"
       MENU-ITEM mi_OpenTableCreateTrigger LABEL "Open trigger procedure".

DEFINE SUB-MENU m_TableWriteTrigger 
       MENU-ITEM mi_CopyTableWriteTrigger LABEL "Copy trigger name"
       MENU-ITEM mi_OpenTableWriteTrigger LABEL "Open trigger procedure".

DEFINE SUB-MENU m_TableDeleteTrigger 
       MENU-ITEM mi_CopyTableDeleteTrigger LABEL "Copy trigger name"
       MENU-ITEM mi_OpenTableDeleteTrigger LABEL "Open trigger procedure".

DEFINE SUB-MENU m_TableCompanyInclude 
       MENU-ITEM mi_CopyTableCompanyInclude LABEL "Copy include name"
       MENU-ITEM mi_OpenTableCompanyInclude LABEL "Open include file"
       RULE
       MENU-ITEM mi_CopyTableCompanyIncludeReference LABEL "Copy include reference".

DEFINE SUB-MENU m_TableKeyInclude 
       MENU-ITEM mi_CopyTableKeyInclude LABEL "Copy include name"
       MENU-ITEM mi_OpenTableKeyInclude LABEL "Open include file"
       RULE
       MENU-ITEM mi_CopyTableKeyIncludeReference LABEL "Copy include reference".

DEFINE SUB-MENU m_TableFillInclude 
       MENU-ITEM mi_CopyTableFillInclude LABEL "Copy include name"
       MENU-ITEM mi_OpenTableFillInclude LABEL "Open include file"
       RULE
       MENU-ITEM mi_CopyTableFillIncludeReference LABEL "Copy include reference".

DEFINE MENU POPUP-MENU-brTable 
       MENU-ITEM mi_CopyTableName LABEL "Copy name"     
       RULE
       MENU-ITEM mi_CopyTableDefineBuffer LABEL "Copy ~"define buffer~""
       RULE
       SUB-MENU  m_TableCreateTrigger LABEL "Create trigger"
       SUB-MENU  m_TableWriteTrigger LABEL "Write trigger" 
       SUB-MENU  m_TableDeleteTrigger LABEL "Delete trigger"
       RULE
       SUB-MENU  m_TableCompanyInclude LABEL "Company include"
       SUB-MENU  m_TableKeyInclude LABEL "Key include"   
       SUB-MENU  m_TableFillInclude LABEL "Fill include"  
       RULE
       MENU-ITEM mi_SessionTriggerCreate LABEL "Add session trigger (create)"
       MENU-ITEM mi_SessionTriggerWrite LABEL "Add session trigger (write)"
       MENU-ITEM mi_SessionTriggerDelete LABEL "Add session trigger (delete)"
       MENU-ITEM mi_SessionTriggerFind LABEL "Add session trigger (find)"
       RULE
       MENU-ITEM mi_AddSnapshotBtn LABEL "Add snapshot"  
       MENU-ITEM mi_RemoveTable LABEL "Remove table"  
       RULE
       MENU-ITEM mi_LoadAllTableDetails LABEL "Load all table details"
       MENU-ITEM mi_ShowHiddenTables LABEL "Show hidden tables"
              TOGGLE-BOX.

DEFINE MENU POPUP-MENU-btnCopyToClipboard 
       MENU-ITEM mi_InsertModeBtn LABEL "Insert mode"   
              TOGGLE-BOX.


/* Definitions of the field level widgets                               */
DEFINE BUTTON btnBlock1 
     LABEL "1" 
     SIZE 7 BY 1.

DEFINE BUTTON btnBlock2 
     LABEL "2" 
     SIZE 7 BY 1.

DEFINE BUTTON btnBlock3 
     LABEL "3" 
     SIZE 7 BY 1.

DEFINE BUTTON btnBlock4 
     LABEL "4" 
     SIZE 7 BY 1.

DEFINE BUTTON btnBuffer1 
     LABEL "1" 
     SIZE 7 BY 1.

DEFINE BUTTON btnBuffer2 
     LABEL "2" 
     SIZE 7 BY 1.

DEFINE BUTTON btnBuffer3 
     LABEL "3" 
     SIZE 7 BY 1.

DEFINE BUTTON btnBuffer4 
     LABEL "4" 
     SIZE 7 BY 1.

DEFINE BUTTON btnClearBlockName 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Clear blockname".

DEFINE BUTTON btnClearBufferPattern 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Reset buffername".

DEFINE BUTTON btnClearFieldFilter 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Clear field filter".

DEFINE BUTTON btnClearFieldLabelFilter 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Clear field label filter".

DEFINE BUTTON btnClearIndexFieldFilter 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Clear index field filter".

DEFINE BUTTON btnClearIndexFilter 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Clear index filter".

DEFINE BUTTON btnClearRelationFieldFilter 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Clear relation field filter".

DEFINE BUTTON btnClearRelationFilter 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Clear relation filter".

DEFINE BUTTON btnClearTableFieldFilter 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Clear table field filter".

DEFINE BUTTON btnClearTableFilter 
     LABEL "" 
     SIZE 7 BY 1 TOOLTIP "Clear table filter".

DEFINE BUTTON btnConnectDB 
     LABEL "Connect" 
     SIZE 19 BY 1 TOOLTIP "Connect to existing database".

DEFINE BUTTON btnCopyToClipboard DEFAULT 
     LABEL "Copy" 
     SIZE 20 BY 2 TOOLTIP "Copy query text to clipboard".

DEFINE BUTTON btnDecreaseIndentation 
     LABEL "<<" 
     SIZE 7 BY 2 TOOLTIP "Decrease indentation".

DEFINE BUTTON btnDisconnectDB 
     LABEL "Disconnect" 
     SIZE 19 BY 1 TOOLTIP "Disconnect selected database".

DEFINE BUTTON btnExecuteQuery 
     LABEL "Execute" 
     SIZE 20 BY 2 TOOLTIP "Execute current query (F2)".

DEFINE BUTTON btnIncreaseIndentation 
     LABEL ">>" 
     SIZE 7 BY 2 TOOLTIP "Increase indentation".

DEFINE BUTTON btnOf 
     LABEL "..." 
     SIZE 7 BY 2 TOOLTIP "Select related table and buffer".

DEFINE BUTTON btnRefresh 
     LABEL "Refresh" 
     SIZE 19 BY 1 TOOLTIP "Reload schema information for all connected databases".

DEFINE BUTTON btnResetAll 
     LABEL "Reset" 
     SIZE 10 BY 2 TOOLTIP "Reset everything to default values (F12)".

DEFINE BUTTON btnResetIndentation 
     LABEL "|" 
     SIZE 7 BY 2 TOOLTIP "Reset indentation".

DEFINE VARIABLE gcFieldFilter AS CHARACTER 
     LABEL "Field filter" 
     VIEW-AS COMBO-BOX INNER-LINES 8
     DROP-DOWN
     SIZE 42 BY 1 TOOLTIP "Filter for fields that match given name pattern (comma separated)" NO-UNDO.

DEFINE VARIABLE gcFieldLabelFilter AS CHARACTER 
     VIEW-AS COMBO-BOX INNER-LINES 5
     DROP-DOWN
     SIZE 42 BY 1 TOOLTIP "Filter for fields that match given label pattern (comma separated)" NO-UNDO.

DEFINE VARIABLE gcIndexFieldFilter AS CHARACTER 
     VIEW-AS COMBO-BOX INNER-LINES 8
     DROP-DOWN
     SIZE 42 BY 1 TOOLTIP "Filter for indices that contain fields matching given name pattern (comma separated)" NO-UNDO.

DEFINE VARIABLE gcIndexFilter AS CHARACTER 
     LABEL "Index filter" 
     VIEW-AS COMBO-BOX INNER-LINES 8
     DROP-DOWN
     SIZE 42 BY 1 TOOLTIP "Filter for indices that match given name pattern (comma separated)" NO-UNDO.

DEFINE VARIABLE gcRelationFieldFilter AS CHARACTER 
     VIEW-AS COMBO-BOX INNER-LINES 8
     DROP-DOWN
     SIZE 42 BY .96 TOOLTIP "Filter for relations that contain fields matching given name pattern (comma sep" NO-UNDO.

DEFINE VARIABLE gcRelationFilter AS CHARACTER 
     LABEL "Relation filter" 
     VIEW-AS COMBO-BOX INNER-LINES 8
     DROP-DOWN
     SIZE 42 BY .96 TOOLTIP "Filter for relations that match given name pattern (comma separated)" NO-UNDO.

DEFINE VARIABLE gcTableFieldFilter AS CHARACTER 
     VIEW-AS COMBO-BOX INNER-LINES 8
     DROP-DOWN
     SIZE 42 BY 1 TOOLTIP "Filter for tables that contain fields matching given name pattern (comma separated)" NO-UNDO.

DEFINE VARIABLE gcTableFilter AS CHARACTER 
     LABEL "Table filter" 
     VIEW-AS COMBO-BOX INNER-LINES 8
     DROP-DOWN
     SIZE 42 BY 1 TOOLTIP "Filter for tables that match given name pattern (comma separated)" NO-UNDO.

DEFINE VARIABLE gcQueryText AS CHARACTER 
     VIEW-AS EDITOR NO-WORD-WRAP SCROLLBAR-HORIZONTAL SCROLLBAR-VERTICAL
     SIZE 93 BY 14.5
     FONT 0 NO-UNDO.

DEFINE VARIABLE gcBlockName AS CHARACTER FORMAT "X(60)":U 
     LABEL "Block" 
     VIEW-AS FILL-IN 
     SIZE 60 BY 1 NO-UNDO.

DEFINE VARIABLE gcBufferName AS CHARACTER FORMAT "X(256)":U 
     LABEL "Buffer" 
     VIEW-AS FILL-IN 
     SIZE 60 BY 1 NO-UNDO.

DEFINE VARIABLE gcDatabaseDummy AS CHARACTER FORMAT "X(1)":U 
     LABEL "Database" 
     VIEW-AS FILL-IN 
     SIZE 1 BY 1 NO-UNDO.

DEFINE VARIABLE gcFieldDummy AS CHARACTER FORMAT "X(256)":U 
     LABEL "Field" 
     VIEW-AS FILL-IN 
     SIZE 1 BY 1 NO-UNDO.

DEFINE VARIABLE gcIndexDummy AS CHARACTER FORMAT "X(1)":U 
     LABEL "Index" 
     VIEW-AS FILL-IN 
     SIZE 1 BY 1 NO-UNDO.

DEFINE VARIABLE gcRelationDummy AS CHARACTER FORMAT "X(1)":U 
     LABEL "Relation" 
     VIEW-AS FILL-IN 
     SIZE 1 BY 1 NO-UNDO.

DEFINE VARIABLE gcTableDummy AS CHARACTER FORMAT "X(1)":U 
     LABEL "Table" 
     VIEW-AS FILL-IN 
     SIZE 1 BY 1 NO-UNDO.

DEFINE VARIABLE gdIndexUsage AS DECIMAL FORMAT "zz9%":U INITIAL 0 
      VIEW-AS TEXT 
     SIZE 6 BY 1 TOOLTIP "Index Usage" NO-UNDO.

DEFINE VARIABLE giDisplayMode AS INTEGER INITIAL 2 
     VIEW-AS RADIO-SET HORIZONTAL
     RADIO-BUTTONS 
          "Fields", 1,
"Indices", 2,
"Relations", 3
     SIZE 45 BY 1 NO-UNDO.

DEFINE VARIABLE glInvertQuery AS LOGICAL INITIAL no 
     LABEL "Invert query" 
     VIEW-AS TOGGLE-BOX
     size 15 by 1 tooltip "Create Query for related table instead of selected table." no-undo.

DEFINE VARIABLE glOnError AS LOGICAL INITIAL no 
     LABEL "on error" 
     VIEW-AS TOGGLE-BOX
     SIZE 10 BY 1 NO-UNDO.

DEFINE VARIABLE giOnErrorPhrase AS INTEGER 
     VIEW-AS RADIO-SET VERTICAL
     RADIO-BUTTONS 
          "on error undo, leave", 1,
"on error undo, next", 2,
"on error undo, retry", 3,
"on error undo, throw", 4
     SIZE 28 BY 4 NO-UNDO.

DEFINE VARIABLE giQueryTypeModifier AS INTEGER 
     VIEW-AS RADIO-SET HORIZONTAL EXPAND
     RADIO-BUTTONS 
          "unique", 1,
"first", 2,
"last", 3
     SIZE 45 BY 1 NO-UNDO.

DEFINE VARIABLE giQueryType AS INTEGER 
     VIEW-AS RADIO-SET HORIZONTAL EXPAND 
     RADIO-BUTTONS 
          "find first", 1,
"for each", 2,
"can-find", 3
     SIZE 45 BY 1 NO-UNDO.

DEFINE VARIABLE glExclusiveLock AS LOGICAL 
     VIEW-AS RADIO-SET VERTICAL
     RADIO-BUTTONS 
          "no-lock", no,
"exclusive-lock", yes
     SIZE 20 BY 2 NO-UNDO.

DEFINE VARIABLE glCompanyViaClass AS LOGICAL INITIAL no 
     LABEL "" 
     VIEW-AS TOGGLE-BOX
     size 40 by 1 tooltip "Use {&K_CLASS_COMPANY_STATEMENT} instead of pa-Firma" no-undo.

DEFINE VARIABLE glDefineBlock AS LOGICAL INITIAL no 
     LABEL "define block" 
     VIEW-AS TOGGLE-BOX
     SIZE 21 BY 1 NO-UNDO.

DEFINE VARIABLE glDefineBuffer AS LOGICAL INITIAL no 
     LABEL "define buffer" 
     VIEW-AS TOGGLE-BOX
     SIZE 17 BY 1 NO-UNDO.

DEFINE VARIABLE glDoBlock AS LOGICAL INITIAL no 
     LABEL "do" 
     VIEW-AS TOGGLE-BOX
     SIZE 7 BY 1 NO-UNDO.

DEFINE VARIABLE glFinallyBlock AS LOGICAL INITIAL no 
     LABEL "finally block" 
     VIEW-AS TOGGLE-BOX
     SIZE 15 BY 1 NO-UNDO.

DEFINE VARIABLE glIfStatement AS LOGICAL INITIAL no 
     LABEL "if statement" 
     VIEW-AS TOGGLE-BOX
     SIZE 16 BY 1 NO-UNDO.

DEFINE VARIABLE glNoError AS LOGICAL INITIAL no 
     LABEL "no error" 
     VIEW-AS TOGGLE-BOX
     SIZE 11.83 BY 1 NO-UNDO.

DEFINE VARIABLE glNot AS LOGICAL INITIAL no 
     LABEL "not" 
     VIEW-AS TOGGLE-BOX
     SIZE 7 BY 1 NO-UNDO.

DEFINE VARIABLE glRetryBlock AS LOGICAL INITIAL no 
     LABEL "retry block" 
     VIEW-AS TOGGLE-BOX
     SIZE 15 BY 1 NO-UNDO.

DEFINE VARIABLE glDefineVariables AS LOGICAL INITIAL no 
     LABEL "define variables" 
     VIEW-AS TOGGLE-BOX
     SIZE 20 BY 1 NO-UNDO.

DEFINE VARIABLE glUseVirtualIndexIncludes AS LOGICAL INITIAL no 
     LABEL "Use virtual index includes" 
     VIEW-AS TOGGLE-BOX
     SIZE 30 BY 1 NO-UNDO.


/* Query definitions                                                    */
&ANALYZE-SUSPEND
DEFINE QUERY brDatabase FOR 
      ttDatabase SCROLLING.

DEFINE QUERY brField FOR 
      ttField SCROLLING.

DEFINE QUERY brIndex FOR 
      ttIndex SCROLLING.

DEFINE QUERY brRelation FOR 
      ttTableRelationView SCROLLING.

DEFINE QUERY brTable FOR 
      ttTable SCROLLING.
&ANALYZE-RESUME

/* Browse definitions                                                   */
DEFINE BROWSE brDatabase
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _DISPLAY-FIELDS brDatabase hQueryWindow _FREEFORM
  QUERY brDatabase NO-LOCK DISPLAY
      ttDatabase.DatabaseName width 12
      ttDatabase.PhysicalName
/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME
    WITH NO-ASSIGN SIZE 80 BY 5.

DEFINE BROWSE brField
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _DISPLAY-FIELDS brField hQueryWindow _FREEFORM
  QUERY brField NO-LOCK DISPLAY
      ttField.FieldName
      ttField.IsVirtual
      ttField.DataType
      ttField.FieldExtent
      ttField.FieldDecimals
      ttField.FieldInitialValue width 7
      ttField.FieldFormat
      ttField.FieldLabel
      ttField.FieldColumnLabel
      ttField.IsMandatory
      ttField.Domain
/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME
    WITH NO-ASSIGN MULTIPLE SIZE 100 BY 12.

DEFINE BROWSE brIndex
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _DISPLAY-FIELDS brIndex hQueryWindow _FREEFORM
  QUERY brIndex NO-LOCK DISPLAY
      ttIndex.IsPrimary
      ttIndex.IndexName
      ttIndex.IsUnique
      ttIndex.IsVirtual
      ttIndex.IndexFields
/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME
    WITH NO-ASSIGN SIZE 100 BY 12.

DEFINE BROWSE brRelation
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _DISPLAY-FIELDS brRelation hQueryWindow _FREEFORM
  QUERY brRelation NO-LOCK DISPLAY
      ttTableRelationView.RelatedTableName
      ttTableRelationView.RelationType width 8
      ttTableRelationView.ParentRelation
      ttTableRelationView.RelatedFields
      ttTableRelationView.FieldDetails
/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME
    WITH NO-ASSIGN SIZE 100 BY 12.

DEFINE BROWSE brTable
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _DISPLAY-FIELDS brTable hQueryWindow _FREEFORM
  QUERY brTable NO-LOCK DISPLAY
      ttTable.TableName
      ttTable.ShortDescription
/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME
    WITH NO-ASSIGN SIZE 100 BY 10 FIT-LAST-COLUMN.


/* ************************  Frame Definitions  *********************** */

DEFINE FRAME fQuery
     gdIndexUsage AT ROW 32 COL 223 COLON-ALIGNED NO-LABEL
     gcDatabaseDummy AT ROW 1.5 COL 16 COLON-ALIGNED
     gcTableDummy AT ROW 8 COL 16 COLON-ALIGNED
     gcFieldDummy AT ROW 21 COL 16 COLON-ALIGNED
     gcIndexDummy AT ROW 21 COL 16 COLON-ALIGNED
     gcRelationDummy AT ROW 21 COL 16 COLON-ALIGNED
     brDatabase AT ROW 1.5 COL 18
     btnConnectDB AT ROW 1.5 COL 99
     btnDisconnectDB AT ROW 2.5 COL 99
     btnRefresh AT ROW 5.5 COL 99
     gcTableFilter AT ROW 7 COL 16 COLON-ALIGNED
     btnClearTableFilter AT ROW 7 COL 60
     gcTableFieldFilter AT ROW 7 COL 67 COLON-ALIGNED NO-LABEL
     btnClearTableFieldFilter AT ROW 7 COL 111
     brTable AT ROW 8 COL 18
     giDisplayMode AT ROW 18.5 COL 18 NO-LABEL
     glInvertQuery AT ROW 18.5 COL 65 NO-LABEL
     gcFieldFilter AT ROW 20 COL 16 COLON-ALIGNED
     btnClearFieldFilter AT ROW 20 COL 60
     gcFieldLabelFilter AT ROW 20 COL 67 COLON-ALIGNED NO-LABEL
     btnClearFieldLabelFilter AT ROW 20 COL 111
     brField AT ROW 21 COL 18
     gcIndexFilter AT ROW 20 COL 16 COLON-ALIGNED
     btnClearIndexFilter AT ROW 20 COL 60
     gcIndexFieldFilter AT ROW 20 COL 67 COLON-ALIGNED NO-LABEL
     btnClearIndexFieldFilter AT ROW 20 COL 111
     brIndex AT ROW 21 COL 18
     gcRelationFilter AT ROW 20 COL 16 COLON-ALIGNED
     btnClearRelationFilter AT ROW 20 COL 60
     gcRelationFieldFilter AT ROW 20 COL 67 COLON-ALIGNED NO-LABEL
     btnClearRelationFieldFilter AT ROW 20 COL 111
     brRelation AT ROW 21 COL 18
     gcBufferName AT ROW 1.5 COL 128 COLON-ALIGNED
     btnClearBufferPattern AT ROW 1.5 COL 190
     btnBuffer1 AT ROW 1.5 COL 199
     btnBuffer2 AT ROW 1.5 COL 207
     btnBuffer3 AT ROW 1.5 COL 215
     btnBuffer4 AT ROW 1.5 COL 223
     glDefineBuffer AT ROW 7 COL 178
     glDefineVariables AT ROW 8.5 COL 178
     glCompanyViaClass AT ROW 5.5 COL 178
     glExclusiveLock AT ROW 3 COL 130 NO-LABEL
     glNoError AT ROW 3 COL 178
     glIfStatement AT ROW 4 COL 181
     glNot AT ROW 4 COL 199
     glDoBlock AT ROW 4 COL 207
     glUseVirtualIndexIncludes AT ROW 9.5 COL 178
     glOnError AT ROW 5.5 COL 130
     giOnErrorPhrase AT ROW 6.5 COL 133 NO-LABEL
     giQueryTypeModifier AT ROW 17 COL 130 NO-LABEL
     gcBlockName AT ROW 11.5 COL 128 COLON-ALIGNED
     btnClearBlockName AT ROW 11.5 COL 190
     btnBlock1 AT ROW 11.5 COL 199
     btnBlock2 AT ROW 11.5 COL 207
     btnBlock3 AT ROW 11.5 COL 215
     btnBlock4 AT ROW 11.5 COL 223
     glDefineBlock AT ROW 13 COL 130
     glRetryBlock AT ROW 13 COL 160
     glFinallyBlock AT ROW 13 COL 178
     giQueryType AT ROW 16 COL 130 NO-LABEL
     btnCopyToClipboard AT ROW 16 COL 178
     btnExecuteQuery AT ROW 16 COL 199
     btnResetAll AT ROW 16 COL 220
     btnIncreaseIndentation AT ROW 18.5 COL 223
     btnDecreaseIndentation AT ROW 20.5 COL 223
     btnResetIndentation AT ROW 22.5 COL 223
     btnOf AT ROW 25 COL 223
     gcQueryText AT ROW 18.5 COL 130 NO-LABEL
    WITH 1 DOWN NO-BOX KEEP-TAB-ORDER OVERLAY 
         SIDE-LABELS NO-UNDERLINE THREE-D 
         AT COL 1 ROW 1
         SIZE 232 BY 32.5
         DEFAULT-BUTTON btnCopyToClipboard DROP-TARGET.


/* *********************** Procedure Settings ************************ */

&ANALYZE-SUSPEND _PROCEDURE-SETTINGS
/* Settings for THIS-PROCEDURE
   Type: Window
   Allow: Basic,Browse,DB-Fields,Window,Query
 */
&ANALYZE-RESUME _END-PROCEDURE-SETTINGS

/* *************************  Create Window  ************************** */

&ANALYZE-SUSPEND _CREATE-WINDOW
IF SESSION:DISPLAY-TYPE = "GUI":U THEN
  CREATE WINDOW hQueryWindow ASSIGN
         HIDDEN             = YES
         TITLE              = ""
         HEIGHT             = 32.5
         WIDTH              = 231
         MAX-HEIGHT         = 320
         MAX-WIDTH          = 320
         VIRTUAL-HEIGHT     = 320
         VIRTUAL-WIDTH      = 320
         RESIZE             = yes
         SCROLL-BARS        = no
         STATUS-AREA        = no
         BGCOLOR            = ?
         FGCOLOR            = ?
         KEEP-FRAME-Z-ORDER = yes
         THREE-D            = yes
         MESSAGE-AREA       = no
         SENSITIVE          = yes.
ELSE {&WINDOW-NAME} = CURRENT-WINDOW.

ASSIGN {&WINDOW-NAME}:MENUBAR    = MENU MENU-BAR-hQueryWindow:HANDLE.
/* END WINDOW DEFINITION                                                */
&ANALYZE-RESUME



/* ***********  Runtime Attributes and AppBuilder Settings  *********** */

&ANALYZE-SUSPEND _RUN-TIME-ATTRIBUTES
/* SETTINGS FOR WINDOW hQueryWindow
  VISIBLE,,RUN-PERSISTENT                                               */
/* SETTINGS FOR FRAME fQuery
   FRAME-NAME Custom                                                    */
/* BROWSE-TAB brDatabase gcIndexDummy fQuery */
/* BROWSE-TAB brTable btnClearTableFieldFilter fQuery */
/* BROWSE-TAB brField btnClearFieldFilter fQuery */
/* BROWSE-TAB brIndex btnClearIndexFieldFilter fQuery */
/* BROWSE-TAB brRelation gcQueryText fQuery */
ASSIGN 
       FRAME fQuery:PRIVATE-DATA     = 
                "WidthFactor=1,HeightFactor=1,SlimModeWidget=yes".

ASSIGN 
       brDatabase:POPUP-MENU IN FRAME fQuery             = MENU POPUP-MENU-brDatabase:HANDLE
       brDatabase:PRIVATE-DATA IN FRAME fQuery           = 
                "WidthFactor=0.5,SlimModeWidget=yes"
       brDatabase:COLUMN-RESIZABLE IN FRAME fQuery       = TRUE
       brDatabase:COLUMN-MOVABLE IN FRAME fQuery         = TRUE.

ASSIGN 
       brField:POPUP-MENU IN FRAME fQuery             = MENU POPUP-MENU-brField:HANDLE
       brField:NUM-LOCKED-COLUMNS IN FRAME fQuery     = 1
       brField:PRIVATE-DATA IN FRAME fQuery           = 
                "WidthFactor=0.5,HeightFactor=0.5,RowFactor=0.5,SlimModeWidget=yes"
       brField:COLUMN-RESIZABLE IN FRAME fQuery       = TRUE
       brField:COLUMN-MOVABLE IN FRAME fQuery         = TRUE.

ASSIGN 
       brIndex:POPUP-MENU IN FRAME fQuery             = MENU POPUP-MENU-brIndex:HANDLE
       brIndex:PRIVATE-DATA IN FRAME fQuery           = 
                "WidthFactor=0.5,HeightFactor=0.5,RowFactor=0.5,SlimModeWidget=yes"
       brIndex:COLUMN-RESIZABLE IN FRAME fQuery       = TRUE
       brIndex:COLUMN-MOVABLE IN FRAME fQuery         = TRUE.

ASSIGN 
       brRelation:POPUP-MENU IN FRAME fQuery             = MENU POPUP-MENU-brRelation:HANDLE
       brRelation:NUM-LOCKED-COLUMNS IN FRAME fQuery     = 1
       brRelation:PRIVATE-DATA IN FRAME fQuery           = 
                "WidthFactor=0.5,HeightFactor=0.5,RowFactor=0.5,SlimModeWidget=yes"
       brRelation:COLUMN-RESIZABLE IN FRAME fQuery       = TRUE
       brRelation:COLUMN-MOVABLE IN FRAME fQuery         = TRUE.

ASSIGN 
       brTable:POPUP-MENU IN FRAME fQuery             = MENU POPUP-MENU-brTable:HANDLE
       brTable:PRIVATE-DATA IN FRAME fQuery           = 
                "WidthFactor=0.5,HeightFactor=0.5,SlimModeWidget=yes"
       brTable:COLUMN-RESIZABLE IN FRAME fQuery       = TRUE
       brTable:COLUMN-MOVABLE IN FRAME fQuery         = TRUE.

ASSIGN 
       btnBlock1:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnBlock2:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnBlock3:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnBlock4:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnBuffer1:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnBuffer2:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnBuffer3:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnBuffer4:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnClearBlockName:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnClearBufferPattern:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1".

ASSIGN 
       btnClearFieldFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.25,RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnClearFieldLabelFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnClearIndexFieldFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnClearIndexFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.25,RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnClearRelationFieldFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnClearRelationFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.25,RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnClearTableFieldFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnClearTableFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.25,SlimModeWidget=yes".

ASSIGN 
       btnConnectDB:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnCopyToClipboard:POPUP-MENU IN FRAME fQuery       = MENU POPUP-MENU-btnCopyToClipboard:HANDLE
       btnCopyToClipboard:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,WidthFactor=0.2".

ASSIGN 
       btnDecreaseIndentation:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1,HeightFactor=0.12,RowFactor=0.12,MaxHeight=2.0,MaxRow=20.5".

ASSIGN 
       btnDisconnectDB:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnExecuteQuery:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.7,WidthFactor=0.2".

ASSIGN 
       btnIncreaseIndentation:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1,HeightFactor=0.12,MaxHeight=2.0".

ASSIGN 
       btnOf:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1,HeightFactor=0.12,RowFactor=0.36,MaxHeight=2.0,MaxRow=25.0".

ASSIGN 
       btnRefresh:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       btnResetAll:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.9,WidthFactor=0.1".

ASSIGN 
       btnResetIndentation:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1,HeightFactor=0.12,RowFactor=0.24,MaxHeight=2.0,MaxRow=22.5".

ASSIGN 
       gcBlockName:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,WidthFactor=0.5".

ASSIGN 
       gcBufferName:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,WidthFactor=0.5".

/* SETTINGS FOR FILL-IN gcDatabaseDummy IN FRAME fQuery
   NO-DISPLAY NO-ENABLE                                                 */
ASSIGN 
       gcFieldDummy:PRIVATE-DATA IN FRAME fQuery     = 
                "RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       gcFieldFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "RowFactor=0.5,WidthFactor=0.25,SlimModeWidget=yes".

ASSIGN 
       gcFieldLabelFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.25,RowFactor=0.5,WidthFactor=0.25,SlimModeWidget=yes".

/* SETTINGS FOR FILL-IN gcIndexDummy IN FRAME fQuery
   NO-DISPLAY NO-ENABLE                                                 */
ASSIGN 
       gcIndexDummy:PRIVATE-DATA IN FRAME fQuery     = 
                "RowFactor=0.5,SlimModeWidget=yes".

/* SETTINGS FOR FILL-IN gcRelationDummy IN FRAME fQuery
   NO-DISPLAY NO-ENABLE                                                 */
ASSIGN 
       gcRelationDummy:PRIVATE-DATA IN FRAME fQuery     = 
                "RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       gcIndexFieldFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.25,RowFactor=0.5,WidthFactor=0.25,SlimModeWidget=yes".

ASSIGN 
       gcIndexFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "RowFactor=0.5,WidthFactor=0.25,SlimModeWidget=yes".

ASSIGN 
       gcQueryText:READ-ONLY IN FRAME fQuery        = TRUE
       gcQueryText:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5,HeightFactor=1,WidthFactor=0.5".

ASSIGN 
       gcRelationFieldFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.25,RowFactor=0.5,WidthFactor=0.25,SlimModeWidget=yes".

ASSIGN 
       gcRelationFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "RowFactor=0.5,WidthFactor=0.25,SlimModeWidget=yes".

/* SETTINGS FOR FILL-IN gcTableDummy IN FRAME fQuery
   NO-DISPLAY NO-ENABLE                                                 */
ASSIGN 
       gcTableDummy:PRIVATE-DATA IN FRAME fQuery     = 
                "SlimModeWidget=yes".

ASSIGN 
       gcTableFieldFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.25,WidthFactor=0.25,SlimModeWidget=yes".

ASSIGN 
       gcTableFilter:PRIVATE-DATA IN FRAME fQuery     = 
                "WidthFactor=0.25,SlimModeWidget=yes".

ASSIGN 
       gdIndexUsage:READ-ONLY IN FRAME fQuery        = TRUE
       gdIndexUsage:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=1,RowFactor=1".

ASSIGN 
       giDisplayMode:PRIVATE-DATA IN FRAME fQuery     = 
                "RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       glInvertQuery:PRIVATE-DATA IN FRAME fQuery     = 
                "RowFactor=0.5,SlimModeWidget=yes".

ASSIGN 
       glOnError:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       giOnErrorPhrase:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       giQueryTypeModifier:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       giQueryType:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glCompanyViaClass:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glDefineBlock:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glDefineBuffer:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glDoBlock:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glExclusiveLock:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glFinallyBlock:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glIfStatement:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glNoError:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glNot:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glDefineVariables:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glUseVirtualIndexIncludes:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

ASSIGN 
       glRetryBlock:PRIVATE-DATA IN FRAME fQuery     = 
                "ColFactor=0.5".

IF SESSION:DISPLAY-TYPE = "GUI":U AND VALID-HANDLE(hQueryWindow)
THEN hQueryWindow:HIDDEN = no.

/* _RUN-TIME-ATTRIBUTES-END */
&ANALYZE-RESUME


/* Setting information for Queries and Browse Widgets fields            */

&ANALYZE-SUSPEND _QUERY-BLOCK BROWSE brDatabase
/* Query rebuild information for BROWSE brDatabase
     _START_FREEFORM
OPEN QUERY brDatabase FOR EACH ttDatabase WHERE true
  NO-LOCK
  BY ttDatabase.DisplayPriority BY ttDatabase.DatabaseName.
     _END_FREEFORM
     _Options          = "NO-LOCK"
     _Query            is NOT OPENED
*/  /* BROWSE brDatabase */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _QUERY-BLOCK BROWSE brField
/* Query rebuild information for BROWSE brField
     _START_FREEFORM
OPEN QUERY brField FOR EACH ttField WHERE true
and ttField.DatabaseName = ttDatabase.DatabaseName
and ttField.TableName = ttTable.TableName
and ttField.FieldFilterMatches = yes
and ( glShowVirtualFields
   or ttField.IsVirtual <> yes )
  NO-LOCK.
     _END_FREEFORM
     _Options          = "NO-LOCK"
     _Query            is NOT OPENED
*/  /* BROWSE brField */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _QUERY-BLOCK BROWSE brIndex
/* Query rebuild information for BROWSE brIndex
     _START_FREEFORM
OPEN QUERY brIndex FOR EACH ttIndex WHERE true
  AND ttIndex.DatabaseName = ttDatabase.DatabaseName
  and ttIndex.TableName = ttTable.TableName
  AND ttIndex.IndexFilterMatches = yes
  AND ttIndex.IndexFieldFilterMatches = yes
  AND ( glShowVirtualIndices
     or ttIndex.IsVirtual <> yes )
  NO-LOCK.
     _END_FREEFORM
     _Options          = "NO-LOCK"
     _Query            is NOT OPENED
*/  /* BROWSE brIndex */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _QUERY-BLOCK BROWSE brRelation
/* Query rebuild information for BROWSE brRelation
     _START_FREEFORM
OPEN QUERY brTableRelationView FOR EACH ttTableRelationView WHERE true
  AND ttTableRelationView.DatabaseName = ttDatabase.DatabaseName
  AND ttTableRelationView.ReferenceTableName = ttTable.TableName
  AND ttTableRelationView.TableFilterMatches = yes
  AND ttTableRelationView.FieldFilterMatches = yes
  AND ttTableRelationView.ParentRelationFilterMatches = yes
  NO-LOCK.
     _END_FREEFORM
     _Options          = "NO-LOCK"
     _Query            is NOT OPENED
*/  /* BROWSE brRelation */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _QUERY-BLOCK BROWSE brTable
/* Query rebuild information for BROWSE brTable
     _START_FREEFORM
OPEN QUERY brTable FOR EACH ttTable WHERE true
  AND ttTable.DatabaseName = ttDatabase.DatabaseName
  AND ttTable.TableFilterMatches = yes
  AND ttTable.TableFieldFilterMatches = yes
  AND (glShowHiddenTables
    OR (  not can-do('sys*':U, ttTable.TableName)
      and not can-do('_*':U, ttTable.TableName)))
  NO-LOCK.
     _END_FREEFORM
     _Options          = "NO-LOCK"
     _Query            is NOT OPENED
*/  /* BROWSE brTable */
&ANALYZE-RESUME

/* >>> Include: incl/core.df >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> */

/**
 * @COPYRIGHT@
 * Project Proalpha
 * Name    core.df
 * Created <version> as of 04.11.2022/Thiemann_M
 * Current @PAVERSION@ as of @PADATE@/@PALASTAUTHOR@
 *
 *
 * ## HISTORY
 * @FILEHISTORY@
 */

// ********************  Preprocessor Definitions  ********************

function qg_cDataTypePrefix returns character 
  ( pcDataType as character ) forward.

function qg_cDatabaseNameForTableOrBuffer returns character 
  ( phBuffer as handle ) forward.

function qg_cDateStringFormUSFormat returns character 
  ( pcDateString as character ) forward.

function qg_cFieldValuesForObjectId returns character 
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcObjectId     as character,
    pcFieldList    as character ) forward.

function qg_cIndexFieldValuesForObjectId returns character 
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcObjectId     as character,
    pcIndexName    as character ) forward.

function qg_cObjectIdForBuffer returns character 
  ( phBuffer as handle ) forward.

function qg_lFieldExistsInDatabaseSchema returns logical 
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcFieldName    as character ) forward.

function qg_lIsPhysicalDatabase returns logical 
  ( pcDatabaseName as character ) forward.

function qg_tDateDateFromUSFormat returns date 
  ( pcDateString as character ) forward.

function qg_tzDateDateTimeTzFromUSFormat returns datetime-tz 
  ( pcDateString as character ) forward.



/* <<< Include: incl/core.df <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/* >>> Include: incl/database_schema.df >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> */

/**
 * @COPYRIGHT@
 * Project Proalpha
 * Name    database_schema.df
 * Created <version> as of 04.06.2022/Thiemann_M
 * Current @PAVERSION@ as of @PADATE@/@PALASTAUTHOR@
 *
 *
 * ## HISTORY
 * @FILEHISTORY@
 */

// ********************  Preprocessor Definitions  ********************


function qg_cCustomizedRepositoryValue returns character 
  ( pcBasisDBName as character,
    pcTableName   as character,
    pcFieldName   as character,
    pcOwning_Obj  as character ) forward.


/* <<< Include: incl/database_schema.df <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/* >>> Include: incl/query_window.df >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> */

/**
 * @COPYRIGHT@
 * Project Proalpha
 * Name    query_window.df
 * Created <version> as of 04.06.2022/Thiemann_M
 * Current @PAVERSION@ as of @PADATE@/@PALASTAUTHOR@
 *
 *
 * ## HISTORY
 * @FILEHISTORY@
 */

define variable ghQueryWindowListWindowSeq  as integer   no-undo.

define variable ghQueryWindowListWindow     as handle    no-undo.
define variable ghQueryWindowListBrowse     as handle    no-undo.
define variable ghActiveQueryWindow         as handle    no-undo.

// ********************  Preprocessor Definitions  ********************



/* <<< Include: incl/query_window.df <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/* >>> Include: incl/virtual_fields.df >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> */
/**
 * @COPYRIGHT@
 * Project Proalpha
 * Name    virtual_fields.df
 * Created <version> as of 04.05.2022/Thiemann_M
 * Current @PAVERSION@ as of @PADATE@/@PALASTAUTHOR@
 *
 *
 * ## HISTORY
 * @FILEHISTORY@
 */

// ********************  Preprocessor Definitions  ********************
&GLOBAL-DEFINE K_VIRTUAL_DB_FIELD_FGCOLOR        3

define variable glShowVirtualFields                  as logical              no-undo initial yes.

define variable gcVirtualDBFieldReposFlagFieldName   as character            no-undo initial ?.
define variable glStaticVirtualDBFieldDataApi        as logical              no-undo. 
define variable goVirtualDBFieldDataApiClass         as Progress.Lang.Class  no-undo.
define variable goVirtualDBFieldDataApiInstance      as Progress.Lang.Object no-undo.
define variable glStaticVirtualDBFieldDataFieldApi   as logical              no-undo.
define variable goVirtualDBFieldDataFieldApiClass    as Progress.Lang.Class  no-undo.
define variable goVirtualDBFieldDataFieldApiInstance as Progress.Lang.Object no-undo.

define temp-table ttVirtualFieldColumn no-undo
  field OwnerHandle         as handle
  field DatabaseName        as character
  field BufferName          as character
  field FieldName           like ttField.FieldName
  field FieldIndex          as integer
  field DataType            as character
  field FieldType           as integer
  field FieldFormat         as character
  field BufferHandle        as handle
  field ColumnHandle        as handle
  index Main is primary unique
    OwnerHandle
    BufferName
    FieldName
    FieldIndex
  index ColumnHandle
    OwnerHandle
    ColumnHandle
    .

function qg_cBufferCompareVirtualFields returns character 
  ( phBuffer1 as handle,
    phBuffer2 as handle ) forward.

function qg_cGetFieldAssignmentsStatementForVirtualFields returns character 
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcBufferName   as character,
    pcFieldList    as character,
    piValueMode    as integer,
    pcValueList    as character,
    plAddTags      as logical,
    piIndentBlanks as integer ) forward.

function qg_clVirtualDBFieldValueAsLongchar returns longchar 
  ( pcDataType      as character,
    pcFieldName     as character,
    pcObjectIdValue as character,
    pcFormat        as character ) forward.


function qg_clVirtualFieldValueAsLongchar returns longchar 
  ( piFieldType     as integer,
    pcDataType      as character,
    pcFieldName     as character,
    pcObjectIdValue as character,
    pcFormat        as character ) forward.

function qg_lBufferCompareSingleVirtualField returns logical 
  ( phBuffer1             as handle,
    plDatabase1IsPhysical as logical,
    pcObjectIdValue1      as character,
    phBuffer2             as handle,
    plDatabase2IsPhysical as logical,
    pcObjectIdValue2      as character,
    pcFieldName           as character,
    pcDataType            as character ) forward.

function qg_lVirtualDBFieldsPossible returns logical 
  ( buffer pbttDatabase for ttDatabase ) forward.

/* <<< Include: incl/virtual_fields.df <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/* >>> Include: incl/virtual_indices.df >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> */

/**
 * @COPYRIGHT@
 * Project Proalpha
 * Name    virtual_indices.df
 * Created <version> as of 06.01.2022/Thiemann_M
 * Current @PAVERSION@ as of @PADATE@/@PALASTAUTHOR@
 *
 *
 * ## HISTORY
 * @FILEHISTORY@
 */

// ********************  Preprocessor Definitions  ********************

&GLOBAL-DEFINE K_VIRTUAL_INDEX_FGCOLOR        3

define variable glShowVirtualIndices             as logical                    no-undo initial yes.

define variable goVirtualIndexApiInstance        as class Progress.Lang.Object no-undo.
define variable goVirtualIndexDataApiInstance    as class Progress.Lang.Object no-undo.

define variable gcVirtualQueryApiPackageName     as character no-undo.
define variable gcVirtualQueryApiClassName       as character no-undo.

define variable gcVirtualIndexReposFlagFieldName as character                  no-undo initial ?.
define variable gcVirtualIndexDataTableName      as character                  no-undo initial ?.

function qg_cVirtualIndexFieldVariableName returns character 
  ( pcFieldName as character,
    pcDataType  as character ) forward.

function qg_lVirtualIndexPossible returns logical 
  ( buffer pbttDatabase for ttDatabase ) forward.

function qg_oVirtualIndexApiInstance returns class progress.lang.object 
  (  ) forward.

function qg_oVirtualIndexDataApiInstance returns class progress.lang.object 
  (  ) forward.

function qg_oVirtualQueryApiInstance returns class progress.lang.object 
  (  ) forward.


/* <<< Include: incl/virtual_indices.df <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/* >>> Include: incl/core.i >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> */

/**
 * @COPYRIGHT@
 * Project Proalpha
 * Name    core.i
 * Created <version> as of 04.11.2022/Thiemann_M
 * Current @PAVERSION@ as of @PADATE@/@PALASTAUTHOR@
 *
 *
 * ## HISTORY
 * @FILEHISTORY@
 */

function qg_cDatabaseNameForTableOrBuffer returns character 
  ( phDBObject as handle ):
/**
 * 
 */

define variable cDatabaseName as character no-undo.

// Prio 1: get property from given handle.

cDatabaseName = qg_cParamListReadValue( phDBObject:private-data,
                                        'DatabaseName':U,
                                        ',':U ).

if  ( cDatabaseName > '':U ) then

  return cDatabaseName.

case phDBObject:type:

  when 'BUFFER':U then
  do:

    if valid-handle( phDBObject:table-handle ) then
    do:

      // Prio 2 for Buffers: read property from table handle
      
      cDatabaseName = qg_cParamListReadValue( phDBObject:table-handle:private-data,
                                              'DatabaseName':U,
                                              ',':U ).

      if cDatabaseName > '':U then

        return cDatabaseName.

      if phDBObject <> phDBObject:table-handle:default-buffer-handle then
      do:

        // Prio 3 for Buffers: read property form default buffer handle (but
        // only if the default buffer handle differs from given handle.

        cDatabaseName = qg_cParamListReadValue( phDBObject:table-handle:default-buffer-handle:private-data,
                                                'DatabaseName':U,
                                                ',':U ).
        if cDatabaseName > '':U then

          return cDatabaseName.

      end.

    end.

    return phDBObject:dbname.

  end.

  when 'TABLE':U then
  do:

    // Prio 2 for tables: read property from default buffer handle.
    
    cDatabaseName = qg_cParamListReadValue( phDBObject:default-buffer-handle:private-data,
                                            'DatabaseName':U,
                                            ',':U ).

    if cDatabaseName > '':U then

      return cDatabaseName.

    return phDBObject:default-buffer-handle:dbname.

  end.

end case.

return ?.

end function.

function qg_cDataTypePrefix returns character 
  ( pcDataType as character ):
/**
 * 
 */

case pcDataType:

  when 'character':U then

    return 'c':U.

  when 'integer':U
     or when 'int64':U then

    return 'i':U.

  when 'decimal':U then

    return 'd':U.

  when 'logical':U then

    return 'l':U.

  when 'date':U then

    return 't':U.

  when 'longchar':U then

    return 'cl':U.

  when 'datetime':U then

    return 'td':U.

  when 'datetime-tz':U then

    return 'tz':U.

  when 'handle':U then

    return 'h':U.

  when 'rowid':U then

    return 'r':U.

  when 'memptr':U then

    return 'm':U.

  when 'Progress.Lang.Object':U then

    return 'o':U.

  otherwise
    return '':U.

end case.

end function.

function qg_cDateStringFormUSFormat returns character 
  ( pcDateString as character ):
/**
 * Returns a date-string representing the given us date string in format of
 * the session date-format.
 */

if lookup(pcDateString,'today,now':U) > 0 then

  return pcDateString.

else if length(pcDateString) > 10 then

  return string(qg_tzDateDateTimeTzFromUSFormat(pcDateString)).

else

  return string(qg_tDateDateFromUSFormat(pcDateString)).

end function.

function qg_cFieldValuesForObjectId returns character 
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcObjectId     as character,
    pcFieldList    as character ):
/**
 * 
 */

define variable hBuffer as handle    no-undo.

create buffer hBuffer for table substitute( '&1.&2':U,
                                            pcDatabaseName,
                                            pcTableName ).

hBuffer:find-first( substitute( 'where &1.&1_Obj = &2':U,
                                hBuffer:table,
                                quoter( pcObjectId ) ) ) no-error.

return ( if hBuffer:available then
           qg_cFieldValues( hBuffer, ?, pcFieldList )
         else
           ? ).

finally:

  if valid-handle( hBuffer ) then

    delete object hBuffer.

end finally.

end function.

function qg_cIndexFieldValuesForObjectId returns character 
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcObjectId     as character,
    pcIndexName    as character ):
/**
 * 
 */

define variable hBuffer as handle    no-undo.

create buffer hBuffer for table substitute( '&1.&2':U,
                                            pcDatabaseName,
                                            pcTableName ).

hBuffer:find-first( substitute( 'where &1.&1_Obj = &2':U,
                                hBuffer:table,
                                quoter( pcObjectId ) ) ) no-error.

return ( if hBuffer:available then
           qg_cIndexFieldValues( hBuffer, pcIndexName )
         else
           ? ).

finally:

  if valid-handle( hBuffer ) then

    delete object hBuffer.

end finally.

end function.

function qg_cObjectIdForBuffer returns character 
  ( phBuffer as handle ):
define variable hObjectIdField as handle    no-undo.

hObjectIdField = phBuffer:buffer-field( substitute( '&1_Obj':U, phBuffer:table ) ).

return hObjectIdField:buffer-value.

catch oError as Progress.Lang.Error:
  return ?.
end catch.

end function.

function qg_lFieldExistsInDatabaseSchema returns logical 
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcFieldName    as character ):
/**
 * 
 */

define variable hFileBuffer  as handle    no-undo.
define variable hFieldBuffer as handle    no-undo.

create buffer hFileBuffer for table substitute( '&1.&2':U,
                                                pcDatabaseName,
                                                '_File':U ).

hFileBuffer:find-first( substitute( 'where _File._File-Name = &1':U,
                                    quoter( pcTableName ) ),
                        no-lock ) no-error.

if not hFileBuffer:available then

  return no.

create buffer hFieldBuffer for table substitute( '&1.&2':U,
                                                 pcDatabaseName,
                                                 '_Field':U ).

hFieldBuffer:find-first( substitute(            'where _Field._File-recid = &1':U
                                     + '~n':U + '  and _Field._Field-Name = &2':U,
                                     quoter( hFileBuffer:recid ),
                                     quoter( pcFieldName ) ),
                         no-lock ) no-error.

return hFieldBuffer:available.

finally:

  if valid-handle( hFileBuffer ) then

    delete object hFileBuffer.

  if valid-handle( hFieldBuffer ) then

    delete object hFieldBuffer.

end finally.

end function.

function qg_lIsPhysicalDatabase returns logical 
  ( pcDatabaseName as character ):
/**
 * 
 */

if pcDatabaseName = {&K_PROGRESS_TTNAME} then

  return no.

if can-find( first ttDatabase
               where ttDatabase.DatabaseName = pcDatabaseName
                 and ttDatabase.PhysicalDB   = yes ) then

  return yes.

return no.

end function.

function qg_tDateDateFromUSFormat returns date 
  ( pcDateString as character ):
/**
 * Returns the date for a given date string in US format
 */

return date(qg_tzDateDateTimeTzFromUSFormat(pcDateString)).

end function.

function qg_tzDateDateTimeTzFromUSFormat returns datetime-tz 
  ( pcDateString as character ):
/**
 * Returns the datetime-tz for a given date string in US format
 */

define variable cDateFormat as character     no-undo.
define variable tzInitDate  as datetime-tz   no-undo.

if    pcDateString = ?
   or pcDateString = '?':U
   or pcDateString = 'now':U then

  tzInitDate = datetime-tz(pcDateString).

else if pcDateString = 'today':U then

  tzInitDate = datetime-tz(today).

else

  assign
    cDateFormat         = session:date-format
    session:date-format = 'mdy':U
    tzInitDate          = datetime-tz(pcDateString)
    session:date-format = cDateFormat
    .

return tzInitDate.

catch oError as Progress.Lang.Error :

  return ?.

end catch.

finally:

  if cDateFormat > '':U then

    session:date-format = cDateFormat.

end finally.

end function.


/* <<< Include: incl/core.i <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/* >>> Include: incl/database_schema.i >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> */

/**
 * @COPYRIGHT@
 * Project Proalpha
 * Name    database_schema.i
 * Created <version> as of 04.06.2022/Thiemann_M
 * Current @PAVERSION@ as of @PADATE@/@PALASTAUTHOR@
 *
 *
 * ## HISTORY
 * @FILEHISTORY@
 */

// ********************  Preprocessor Definitions  ********************


PROCEDURE qg_AddDatabase :
/**
 * Add database to cache.
 *
 * @param pcDatabase = logical name of database that should be added.
 */

define input parameter pcDatabase as character no-undo.

define variable cSchemaDatabaseName as character no-undo.
define variable hTableBuffer        as handle    no-undo.

define variable cDBParams           as character no-undo.
define variable iDBParamCounter     as integer   no-undo.
define variable cDBParamEntry       as character no-undo.
define variable iPortRangeStart     as integer   no-undo.
define variable iPortRangeEnd       as integer   no-undo.


define buffer bttDatabase  for temp-table ttDatabase.
define buffer b2ttDatabase for temp-table ttDatabase.

create bttDatabase.

assign
  cSchemaDatabaseName                 = sdbname( pcDatabase )
  bttDatabase.DatabaseName            = ldbname(pcDatabase)
  bttDatabase.PhysicalName            = trim(pdbname(pcDatabase), '/\':U)

  // We assume that if the database is connected via shared mameory the
  // pyhsical name contains a path.

  bttDatabase.SharedMemory            =    index(bttDatabase.PhysicalName, '/':U) > 0
                                        or index(bttDatabase.PhysicalName, '\':U) > 0
  bttDatabase.DirectoryName           = (if r-index(bttDatabase.PhysicalName, '\':U) > r-index(bttDatabase.PhysicalName, '/':U) then
                                           substring(bttDatabase.PhysicalName, 1, r-index(bttDatabase.PhysicalName, '\':U))
                                         else
                                           substring(bttDatabase.PhysicalName, 1, r-index(bttDatabase.PhysicalName, '/':U)))
  bttDatabase.DirectoryName           = replace(bttDatabase.DirectoryName, '/':U, '\':U)
  bttDatabase.PhysicalDB              = yes
  bttDatabase.DisplayPriority         = 1000.
  .

cDBParams = dbparam( bttDatabase.DatabaseName ).

do iDBParamCounter = 1 to num-entries( cDBParams ):

  cDBParamEntry = entry( iDBParamCounter, cDBParams ).

  case entry( 1, cDBParamEntry, ' ':U ):

    when '-H':U then

      bttDatabase.HostName = entry( 2, cDBParamEntry, ' ':U ).

    when '-S':U then

      bttDatabase.ServiceName = integer( entry( 2, cDBParamEntry, ' ':U ) ) no-error.

  end case.

end.

// Check if this database contains repository information.
create buffer hTableBuffer for table substitute( '&1._File':U, cSchemaDatabaseName ).

hTableBuffer:find-first(substitute('where &1._File._File-Name = "DRC_Table"':U,
                                   bttDatabase.DatabaseName),
                        no-lock) no-error.

bttDatabase.BasisDB = hTableBuffer:available.

if bttDatabase.BasisDB then
do:

  bttDatabase.BasisDBName = bttDatabase.DatabaseName.

  if bttDatabase.DirectoryName > '':U then

    for each b2ttDatabase
      where b2ttDatabase.DirectoryName = bttDatabase.DirectoryName
        and b2ttDatabase.BasisDBName  = '':U
      on error undo, throw:

      b2ttDatabase.BasisDBName = b2ttDatabase.DatabaseName.

    end.

  else if bttDatabase.HostName > '':U then
  do:

    assign
      iPortRangeStart = truncate( bttDatabase.ServiceName / 10, 0 ) * 10
      iPortRangeEnd   = iPortRangeStart + 9
      .

    for each b2ttDatabase
      where b2ttDatabase.HostName     = bttDatabase.HostName
        and b2ttDatabase.ServiceName >= iPortRangeStart
        and b2ttDatabase.ServiceName <= iPortRangeEnd
        and b2ttDatabase.BasisDBName  = '':U
      on error undo, throw:

      b2ttDatabase.BasisDBName = b2ttDatabase.DatabaseName.

    end.

  end.

end.

else
do:

  if bttDatabase.DirectoryName > '':U then
  do:

    find first b2ttDatabase
      where b2ttDatabase.DirectoryName = bttDatabase.DirectoryName
        and b2ttDatabase.BasisDB       = yes
      no-lock no-error.

    if available b2ttDatabase then

      bttDatabase.BasisDBName = b2ttDatabase.DatabaseName.

  end.

  else if bttDatabase.HostName > '':U then
  do:

    assign
      iPortRangeStart = truncate( bttDatabase.ServiceName / 10, 0 ) * 10
      iPortRangeEnd   = iPortRangeStart + 9
      .

    find first b2ttDatabase
      where b2ttDatabase.HostName     = bttDatabase.HostName
        and b2ttDatabase.ServiceName >= iPortRangeStart
        and b2ttDatabase.ServiceName <= iPortRangeEnd
        and b2ttDatabase.BasisDB      = yes
      no-lock no-error.

    if available b2ttDatabase then

      bttDatabase.BasisDBName = b2ttDatabase.DatabaseName.

  end.

end.

if not bttDatabase.BasisDB then
do:

  if bttDatabase.DatabaseName = 'temp-db':U then
    bttDatabase.TempDB = yes.

  else
  do:

    hTableBuffer:find-first(substitute( 'where &1._File._File-Name begins "TD_"':U,
                                        cSchemaDatabaseName ),
                            no-lock) no-error.

    bttDatabase.TempDB = hTableBuffer:available.

  end.

end.

assign
  bttDatabase.VirtualDBFieldsPossible = qg_lVirtualDBFieldsPossible(buffer bttDatabase)
  bttDatabase.VirtualIndicesPossible  = qg_lVirtualIndexPossible(buffer bttDatabase)
  .

validate bttDatabase.

finally:

  delete object hTableBuffer no-error.

  hide frame fStatus.

end finally.

end procedure.

procedure qg_AddDatasetRelations :
// Description ---------s
// Adds relations from a dataset handle
// <none>

define input parameter pcDatabaseName as character no-undo.
define input parameter phDataset      as handle    no-undo.

define variable iRelationCounter       as integer   no-undo.
define variable hRelation              as handle    no-undo.
define variable iRelationFieldCounter  as integer   no-undo.
define variable cRelParentFieldDetails as character no-undo.
define variable cRelChildFieldDetails  as character no-undo.

define buffer bttTableRelation       for temp-table ttTableRelation.
define buffer bttTableRelationView-1 for temp-table ttTableRelationView.
define buffer bttTableRelationView-2 for temp-table ttTableRelationView.
define buffer bttTableRelationField  for temp-table ttTableRelationField.

do iRelationCounter = 1 to phDataset:num-relations:

  hRelation = phDataset:get-relation( iRelationCounter ).

  find bttTableRelation
    where bttTableRelation.DatabaseName     = pcDatabaseName
      and bttTableRelation.ParentTableName  = hRelation:parent-buffer:table
      and bttTableRelation.ChildTableName   = hRelation:child-buffer:table
      and bttTableRelation.SequentialNumber = iRelationCounter
    no-error.

  create bttTableRelation.

  assign
    giRelationSeq                     = giRelationSeq + 1
    bttTableRelation.RelationId       = giRelationSeq
    bttTableRelation.DatabaseName     = pcDatabaseName
    bttTableRelation.ParentTableName  = hRelation:parent-buffer:table
    bttTableRelation.ChildTableName   = hRelation:child-buffer:table
    bttTableRelation.SequentialNumber = iRelationCounter
    bttTableRelation.RelationType     = '1:cn':U
    .

  create bttTableRelationView-1.

  assign
    cRelParentFieldDetails                    = '':U
    giRelationViewSeq                         = giRelationViewSeq + 1
    bttTableRelationView-1.RelationViewId     = giRelationViewSeq
    bttTableRelationView-1.RelationId         = bttTableRelation.RelationId
    bttTableRelationView-1.DatabaseName       = bttTableRelation.DatabaseName
    bttTableRelationView-1.ReferenceTableName = bttTableRelation.ParentTableName
    bttTableRelationView-1.RelatedTableName   = bttTableRelation.ChildTableName
    bttTableRelationView-1.RelationType       = bttTableRelation.RelationType
    .

  create bttTableRelationView-2.

  assign
    cRelChildFieldDetails                     = '':U
    giRelationViewSeq                         = giRelationViewSeq + 1
    bttTableRelationView-2.RelationViewId     = giRelationViewSeq
    bttTableRelationView-2.RelationId         = bttTableRelation.RelationId
    bttTableRelationView-2.DatabaseName       = bttTableRelation.DatabaseName
    bttTableRelationView-2.ReferenceTableName = bttTableRelation.ChildTableName
    bttTableRelationView-2.RelatedTableName   = bttTableRelation.ParentTableName
    bttTableRelationView-2.RelationType       = (if num-entries(bttTableRelation.RelationType, ':':U) = 2 then
                                                  substitute('&1:&2':U,
                                                             entry(2, bttTableRelation.RelationType, ':':U),
                                                             entry(1, bttTableRelation.RelationType, ':':U))
                                                else
                                                  '?':U)
    bttTableRelationView-2.ParentRelation     = yes
    .

  do iRelationFieldCounter = 1 to num-entries( hRelation:relation-fields ) by 2:

    create bttTableRelationField.

    bttTableRelationField.RelationId = bttTableRelation.RelationId.

    assign
      bttTableRelationField.Order              = iRelationFieldCounter / 2
      bttTableRelationField.ParentConstantData = '':U
      bttTableRelationField.ChildConstantData  = '':U
      bttTableRelationField.FieldRelationType  = 'DB-Field':U
      bttTableRelationField.ParentFieldName    = entry( iRelationFieldCounter, hRelation:relation-fields )
      bttTableRelationField.ChildFieldName     = entry( iRelationFieldCounter + 1, hRelation:relation-fields )
      .

    validate bttTableRelationField.

    assign
      bttTableRelation.ParentFields         = substitute('&1, &2':U,
                                                         bttTableRelation.ParentFields,
                                                         (if bttTableRelationField.ParentFieldName > '':U then
                                                            bttTableRelationField.ParentFieldName
                                                          else
                                                            bttTableRelationField.ParentConstantData) )
      cRelParentFieldDetails                = substitute('&1   [ &2 = &3 ]':U,
                                                         cRelParentFieldDetails,
                                                         (if bttTableRelationField.ParentFieldName > '':U then
                                                            bttTableRelationField.ParentFieldName
                                                          else
                                                            bttTableRelationField.ParentConstantData),
                                                         (if bttTableRelationField.ChildFieldName > '':U then
                                                            bttTableRelationField.ChildFieldName
                                                          else
                                                            bttTableRelationField.ChildConstantData))
      bttTableRelation.ChildFields          = substitute('&1, &2':U,
                                                         bttTableRelation.ChildFields,
                                                         (if bttTableRelationField.ChildFieldName > '':U then
                                                            bttTableRelationField.ChildFieldName
                                                          else
                                                            bttTableRelationField.ChildConstantData))
      cRelChildFieldDetails                 = substitute('&1   [ &2 = &3 ]':U,
                                                         cRelChildFieldDetails,
                                                         (if bttTableRelationField.ChildFieldName > '':U then
                                                            bttTableRelationField.ChildFieldName
                                                          else
                                                            bttTableRelationField.ChildConstantData),
                                                         (if bttTableRelationField.ParentFieldName > '':U then
                                                            bttTableRelationField.ParentFieldName
                                                          else
                                                            bttTableRelationField.ParentConstantData))
      .

    if bttTableRelationField.ParentFieldName > '':U then
      bttTableRelation.ParentFieldList = substitute('&1,&2':U,
                                                    bttTableRelation.ParentFieldList,
                                                    bttTableRelationField.ParentFieldName).

    if bttTableRelationField.ChildFieldName > '':U then
      bttTableRelation.ChildFieldList = substitute('&1,&2':U,
                                                   bttTableRelation.ChildFieldList,
                                                   bttTableRelationField.ChildFieldName).

  end.

  assign
    bttTableRelationView-1.ReferenceFields    = trim(bttTableRelation.ParentFields, ' ,':U)
    bttTableRelationView-1.RelatedFields      = trim(bttTableRelation.ChildFields, ' ,':U)
    bttTableRelationView-1.FieldDetails       = trim(cRelParentFieldDetails)
    bttTableRelationView-1.ReferenceFieldList = trim(bttTableRelation.ParentFieldList, ',':U)
    bttTableRelationView-1.RelatedFieldList   = trim(bttTableRelation.ChildFieldList, ',':U)
    bttTableRelationView-2.ReferenceFields    = trim(bttTableRelation.ChildFields, ' ,':U)
    bttTableRelationView-2.RelatedFields      = trim(bttTableRelation.ParentFields, ' ,':U)
    bttTableRelationView-2.FieldDetails       = trim(cRelChildFieldDetails)
    bttTableRelationView-2.RelatedFieldList   = trim(bttTableRelation.ParentFieldList, ',':U)
    bttTableRelationView-2.ReferenceFieldList = trim(bttTableRelation.ChildFieldList, ',':U)
    .

  validate bttTableRelationView-1.
  validate bttTableRelationView-2.

  validate bttTableRelation.

end.

end procedure.


PROCEDURE qg_AddIndices :
/**
 * Add Indices of given Table to cache.
 *
 * @param pcDatabase = Database that contains the Table of the indices that should be added.
 * @param pcTable = Table that contains the indices that should be added.
 */

define input parameter pcDatabase as character no-undo.
define input parameter pcTable    as character no-undo.

define variable cSchemaDatabaseName  as character no-undo.

define variable hFileBuffer          as handle    no-undo.
define variable hFieldBuffer         as handle    no-undo.

define variable cIndexQueryText      as character no-undo.
define variable hIndexQuery          as handle    no-undo.
define variable hIndexBuffer         as handle    no-undo.

define variable cIndexFieldQueryText as character no-undo.
define variable hIndexFieldQuery     as handle    no-undo.
define variable hIndexFieldBuffer    as handle    no-undo.

define buffer bttIndex      for temp-table ttIndex.
define buffer bttIndexField for temp-table ttIndexField.

if    pcDatabase > '':U
  and pcTable    > '':U then
do:

  cSchemaDatabaseName = sdbname( pcDatabase ).

  create buffer hFileBuffer       for table substitute('&1._File':U, cSchemaDatabaseName).
  create buffer hIndexBuffer      for table substitute('&1._Index':U, cSchemaDatabaseName).
  create buffer hIndexFieldBuffer for table substitute('&1._Index-Field':U, cSchemaDatabaseName).
  create buffer hFieldBuffer      for table substitute('&1._Field':U, cSchemaDatabaseName).

  hFileBuffer:find-first(substitute('where _File._File-Name = &1':U,
                                    quoter(pcTable)),
                         no-lock) no-error.

  if not hFileBuffer:available then
    leave.

  assign
    cIndexQueryText      =            'for each _Index':U
                           + '~n':U + '  where _Index._File-recid = &1':U
                           + '~n':U + '  no-lock':U
    cIndexFieldQueryText =            'for each _Index-Field':U
                           + '~n':U + '  where _Index-Field._Index-recid = &1':U
                           + '~n':U + '  no-lock':U
    .

  create query hIndexQuery.
  create query hIndexFieldQuery.

  hIndexQuery:set-buffers(hIndexBuffer).
  hIndexFieldQuery:set-buffers(hIndexFieldBuffer).

  hIndexQuery:query-prepare(substitute(cIndexQueryText, quoter(hFileBuffer:recid))).
  hIndexQuery:query-open().

  hIndexQuery:get-first().

  do while not hIndexQuery:query-off-end:

    create bttIndex.

    assign
      bttIndex.DatabaseName = pcDatabase
      bttIndex.TableName    = pcTable
      bttIndex.IndexName    = hIndexBuffer::_Index-Name
      bttIndex.IsPrimary    = (hIndexBuffer:recid = hFileBuffer::_Prime-Index)
      bttIndex.IsUnique     = hIndexBuffer::_Unique
      .

    hIndexFieldQuery:query-prepare(substitute(cIndexFieldQueryText, quoter(hIndexBuffer:recid))).
    hIndexFieldQuery:query-open().

    hIndexFieldQuery:get-first().

    do while not hIndexFieldQuery:query-off-end:

      hFieldBuffer:find-first(substitute('where recid(_Field) = &1':U,
                                         quoter(hIndexFieldBuffer::_Field-recid)),
                              no-lock) no-error.

      if not hFieldBuffer:available then
        next.

      create bttIndexField.

      assign
        bttIndexField.DatabaseName  = pcDatabase
        bttIndexField.TableName     = pcTable
        bttIndexField.IndexName     = hIndexBuffer::_Index-Name
        bttIndexField.FieldName     = hFieldBuffer::_Field-Name
        bttIndexField.IndexSequence = hIndexFieldBuffer::_Index-Seq
        bttIndexField.DataType      = hFieldBuffer::_Data-Type
        bttIndexField.SortAscending = hIndexFieldBuffer::_Ascending
        bttIndex.IndexFieldList     = substitute('&1,&2':U,
                                                 bttIndex.IndexFieldList,
                                                 bttIndexField.FieldName)
        bttIndex.IndexFields        = substitute('&1 &2&3':U,
                                                 bttIndex.IndexFields,
                                                 string(bttIndexField.SortAscending, '+/-':U),
                                                 bttIndexField.FieldName)
        .

      hIndexFieldQuery:get-next().

    end.

    assign
      bttIndex.IndexFieldList = trim(bttIndex.IndexFieldList, ',':U)
      bttIndex.IndexFields    = trim(bttIndex.IndexFields)
      .

    hIndexQuery:get-next().

  end.

end.

finally:

  if valid-handle (hFileBuffer) then
    delete object hFileBuffer.

  if valid-handle(hIndexQuery) then
    delete object hIndexQuery.

  if valid-handle (hIndexBuffer) then
    delete object hIndexBuffer.

  if valid-handle(hIndexFieldQuery) then
    delete object hIndexFieldQuery.

  if valid-handle (hIndexFieldBuffer) then
    delete object hIndexFieldBuffer.

  if valid-handle (hFieldBuffer) then
    delete object hFieldBuffer.

end finally.

end procedure.


PROCEDURE qg_AddTableDetails :
/**
 * Load additional information for the given table.
 *
 * @param pcDatabaseName = Name of the database that contains the table.
 * @param pcTableName = Table name for which to load the additional information.
 */

define input parameter pcDatabaseName as character no-undo.
define input parameter pcTableName    as character no-undo.

define variable cBasisDBName           as character no-undo.
define variable cRepTableName          as character no-undo.

define variable cQueryText             as character no-undo.
define variable hQuery                 as handle    no-undo.

define variable hRepFieldBuffer        as handle    no-undo.
define variable hRepDomainBuffer       as handle    no-undo.
define variable cCustomized_DomainObj  as character no-undo.

define variable cRepRelQueryText       as character no-undo.
define variable hRepRelQuery           as handle    no-undo.
define variable hRepRelBuffer          as handle    no-undo.

define variable cRepRelFieldQueryText  as character no-undo.
define variable hRepRelFieldQuery      as handle    no-undo.
define variable hRepRelFieldBuffer     as handle    no-undo.
define variable hRepField1Buffer       as handle    no-undo.
define variable hRepField2Buffer       as handle    no-undo.

define variable cRelParentFieldDetails as character no-undo.
define variable cRelChildFieldDetails  as character no-undo.

define buffer bttDatabase           for temp-table ttDatabase.
define buffer bttTable              for temp-table ttTable.
define buffer bttField              for temp-table ttField.
define buffer bttTableRelation      for temp-table ttTableRelation.
define buffer bttTableRelationField for temp-table ttTableRelationField.
define buffer b1ttTableRelationView for temp-table ttTableRelationView.
define buffer b2ttTableRelationView for temp-table ttTableRelationView.

find bttDatabase
  where bttDatabase.DatabaseName = pcDatabaseName
  no-error.

if not available bttDatabase then
  leave.

find first bttTable
  where bttTable.TableName = pcTableName
  no-error.

if not available bttTable then
  leave.

// Add table repository information.
if not bttTable.DescriptionLoaded then
  run qg_AddTableRepositoryInfo(bttTable.DatabaseName, bttTable.TableName).

// Add indices if necessary.
if not can-find(first ttIndex
                  where ttIndex.DatabaseName = bttTable.DatabaseName
                    and ttIndex.TableName    = bttTable.TableName) then

  run qg_AddIndices(bttTable.DatabaseName, bttTable.TableName).

cBasisDBName = bttDatabase.BasisDBName.

if    cBasisDBName > '':U
  and connected(cBasisDBName) then
do:

  // Add proALPHA repository information.
  create query hQuery.

  create buffer hRepFieldBuffer  for table substitute('&1.DRC_Field':U, cBasisDBName) no-error.

  if not valid-handle( hRepFieldBuffer ) then
    return.

  create buffer hRepDomainBuffer for table substitute('&1.DRC_Domain':U, cBasisDBName) no-error.

  if not valid-handle( hRepDomainBuffer ) then
    return.

  hQuery:set-buffers(hRepFieldBuffer).

  cQueryText =            'for each DRC_Field':U
               + '~n':U + '  where DRC_Field.DRC_Table_Obj = &1':U
               + '~n':U + '  no-lock':U.

  hQuery:query-prepare(substitute(cQueryText,
                                  quoter(bttTable.RepObjectId))).
  hQuery:query-open().

  hQuery:get-first().

  do while not hQuery:query-off-end:

    find first bttField
      where bttField.DatabaseName = pcDatabaseName
        and bttField.TableName    = pcTableName
        and bttField.FieldName    = hRepFieldBuffer::DRC_Field_ID
      no-error.

    if available bttField then
    do:

      assign
        bttField.RepObjectId = hRepFieldBuffer::DRC_Field_Obj
        bttField.IsObjectId =  (     bttField.IsObjectId
                                  or lookup(bttField.Domain, {&K_OBJECT_ID_DOMAIN}) > 0 )
        .

      if gcCustomLevel > '':U then
        cCustomized_DomainObj = qg_cCustomizedRepositoryValue( bttField.DatabaseName,
                                                               'DRC_Field':U,
                                                               'DRC_Domain_Obj':U,
                                                               bttField.RepObjectId ).

      hRepDomainBuffer:find-first( substitute( 'where DRC_Domain.DRC_Domain_Obj = &1':U,
                                               quoter( ( if cCustomized_DomainObj > '':U then
                                                           cCustomized_DomainObj
                                                         else
                                                           hRepFieldBuffer::DRC_Domain_Obj ) ) ),
                                   no-lock ) no-error.

      bttField.Domain = ( if hRepDomainBuffer:available then
                            hRepDomainBuffer::DRC_Domain_ID
                          else
                            '':U ).

    end.

    hQuery:get-next().

  end.

  if bttDatabase.VirtualDBFieldsPossible then

    run qg_AddTableVirtualDBFields( buffer bttDatabase,
                                    buffer bttTable ).

  if bttDatabase.VirtualIndicesPossible then

    run qg_AddTableVirtualIndices( buffer bttDatabase,
                                   buffer bttTable ).

  create query hRepRelQuery.
  create query hRepRelFieldQuery.

  create buffer hRepRelBuffer for table substitute('&1.DRC_Relation':U, cBasisDBName) no-error.

  if valid-handle(hRepRelBuffer) then
    create buffer hRepRelFieldBuffer for table substitute('&1.DRC_RelationField':U, cBasisDBName) no-error.

  else
  do:

    create buffer hRepRelBuffer for table substitute('&1.D_Rel':U, cBasisDBName) no-error.

    if valid-handle(hRepRelBuffer) then
      create buffer hRepRelFieldBuffer for table substitute('&1.D_RelSpalte':U, cBasisDBName) no-error.

  end.

  if    valid-handle(hRepRelBuffer)
    and valid-handle(hRepRelFieldBuffer) then
  do:

    hRepRelQuery:set-buffers(hRepRelBuffer).

    if hRepRelBuffer:name = 'DRC_Relation':U then
    do:

      create buffer hRepField1Buffer for table 'DRC_Field':U buffer-name 'b1DRC_Field':U.
      create buffer hRepField2Buffer for table 'DRC_Field':U buffer-name 'b2DRC_Field':U.

      hRepRelFieldQuery:set-buffers(hRepRelFieldBuffer, hRepField1Buffer, hRepField2Buffer).

      assign
        cRepRelQueryText      =            'for each DRC_Relation':U
                                + '~n':U + '  where ( DRC_Relation.Parent_DRC_Table_Obj = &1':U
                                + '~n':U + '     or   DRC_Relation.Child_DRC_Table_Obj  = &1 )':U
                                + '~n':U + '  no-lock':U
        cRepRelFieldQueryText =            'for each DRC_RelationField':U
                                + '~n':U + '  where DRC_RelationField.DRC_Relation_Obj  = &1':U
                                + '~n':U + '  no-lock,':U
                                + '~n':U + 'first b1DRC_Field':U
                                + '~n':U + '  where b1DRC_Field.DRC_Field_Obj = DRC_RelationField.Parent_DRC_Field_Obj':U
                                + '~n':U + '  left outer-join':U
                                + '~n':U + '  no-lock,':U
                                + '~n':U + 'first b2DRC_Field':U
                                + '~n':U + '  where b2DRC_Field.DRC_Field_Obj = DRC_RelationField.Child_DRC_Field_Obj':U
                                + '~n':U + '  left outer-join':U
                                + '~n':U + '  no-lock':U
        .

      hRepRelQuery:query-prepare(substitute(cRepRelQueryText,
                                            quoter(bttTable.RepObjectId))).
      hRepRelQuery:query-open().

      hRepRelQuery:get-first().

      do while not hRepRelQuery:query-off-end:

        find bttTableRelation
          where bttTableRelation.DatabaseName     = pcDatabaseName
            and bttTableRelation.ParentTableName  = hRepRelBuffer::Parent_DRC_Table_ID
            and bttTableRelation.ChildTableName   = hRepRelBuffer::Child_DRC_Table_ID
            and bttTableRelation.SequentialNumber = hRepRelBuffer::DRC_Relation_ID
          no-error.

        if not available bttTableRelation then
        do:

          create bttTableRelation.

          assign
            giRelationSeq                     = giRelationSeq + 1
            bttTableRelation.RelationId       = giRelationSeq
            bttTableRelation.DatabaseName     = pcDatabaseName
            bttTableRelation.ParentTableName  = hRepRelBuffer::Parent_DRC_Table_ID
            bttTableRelation.ChildTableName   = hRepRelBuffer::Child_DRC_Table_ID
            bttTableRelation.SequentialNumber = hRepRelBuffer::DRC_Relation_ID
            bttTableRelation.RelationType     = hRepRelBuffer::RelationType
            .

          create b1ttTableRelationView.

          assign
            cRelParentFieldDetails                   = '':U
            giRelationViewSeq                        = giRelationViewSeq + 1
            b1ttTableRelationView.RelationViewId     = giRelationViewSeq
            b1ttTableRelationView.RelationId         = bttTableRelation.RelationId
            b1ttTableRelationView.DatabaseName       = bttTableRelation.DatabaseName
            b1ttTableRelationView.ReferenceTableName = bttTableRelation.ParentTableName
            b1ttTableRelationView.RelatedTableName   = bttTableRelation.ChildTableName
            b1ttTableRelationView.RelationType       = bttTableRelation.RelationType
            .

          create b2ttTableRelationView.

          assign
            cRelChildFieldDetails                    = '':U
            giRelationViewSeq                        = giRelationViewSeq + 1
            b2ttTableRelationView.RelationViewId     = giRelationViewSeq
            b2ttTableRelationView.RelationId         = bttTableRelation.RelationId
            b2ttTableRelationView.DatabaseName       = bttTableRelation.DatabaseName
            b2ttTableRelationView.ReferenceTableName = bttTableRelation.ChildTableName
            b2ttTableRelationView.RelatedTableName   = bttTableRelation.ParentTableName
            b2ttTableRelationView.RelationType       = (if num-entries(bttTableRelation.RelationType, ':':U) = 2 then
                                                          substitute('&1:&2':U,
                                                                     entry(2, bttTableRelation.RelationType, ':':U),
                                                                     entry(1, bttTableRelation.RelationType, ':':U))
                                                        else
                                                          '?':U)
            b2ttTableRelationView.ParentRelation     = yes
            .

          hRepRelFieldQuery:query-prepare(substitute(cRepRelFieldQueryText,
                                                     quoter(hRepRelBuffer::DRC_Relation_Obj))).
          hRepRelFieldQuery:query-open().

          hRepRelFieldQuery:get-first().

          do while not hRepRelFieldQuery:query-off-end:

            find bttTableRelationField
              where bttTableRelationField.RelationId = bttTableRelation.RelationId
                and bttTableRelationField.Order      = hRepRelFieldBuffer::DRC_RelationField_ID
              no-error.

            if not available bttTableRelationField then
            do:

              create bttTableRelationField.

              bttTableRelationField.RelationId = bttTableRelation.RelationId.

              assign
                bttTableRelationField.Order              = hRepRelFieldBuffer::DRC_RelationField_ID
                bttTableRelationField.ParentConstantData = hRepRelFieldBuffer::Parent_Constant_Data
                bttTableRelationField.ChildConstantData  = hRepRelFieldBuffer::Child_Constant_Data
                bttTableRelationField.FieldRelationType  = hRepRelFieldBuffer::ColumnInfoType
                .

              if hRepField1Buffer:available then
                bttTableRelationField.ParentFieldName = hRepField1Buffer::DRC_Field_ID.

              if hRepField2Buffer:available then
                bttTableRelationField.ChildFieldName = hRepField2Buffer::DRC_Field_ID.

              validate bttTableRelationField.

              assign
                bttTableRelation.ParentFields         = substitute('&1, &2':U,
                                                                   bttTableRelation.ParentFields,
                                                                   (if bttTableRelationField.ParentFieldName > '':U then
                                                                      bttTableRelationField.ParentFieldName
                                                                    else
                                                                      bttTableRelationField.ParentConstantData) )
                cRelParentFieldDetails                = substitute('&1   [ &2 = &3 ]':U,
                                                                   cRelParentFieldDetails,
                                                                   (if bttTableRelationField.ParentFieldName > '':U then
                                                                      bttTableRelationField.ParentFieldName
                                                                    else
                                                                      bttTableRelationField.ParentConstantData),
                                                                   (if bttTableRelationField.ChildFieldName > '':U then
                                                                      bttTableRelationField.ChildFieldName
                                                                    else
                                                                      bttTableRelationField.ChildConstantData))
                bttTableRelation.ChildFields          = substitute('&1, &2':U,
                                                                   bttTableRelation.ChildFields,
                                                                   (if bttTableRelationField.ChildFieldName > '':U then
                                                                      bttTableRelationField.ChildFieldName
                                                                    else
                                                                      bttTableRelationField.ChildConstantData))
                cRelChildFieldDetails                 = substitute('&1   [ &2 = &3 ]':U,
                                                                   cRelChildFieldDetails,
                                                                   (if bttTableRelationField.ChildFieldName > '':U then
                                                                      bttTableRelationField.ChildFieldName
                                                                    else
                                                                      bttTableRelationField.ChildConstantData),
                                                                   (if bttTableRelationField.ParentFieldName > '':U then
                                                                      bttTableRelationField.ParentFieldName
                                                                    else
                                                                      bttTableRelationField.ParentConstantData))
                .

              if bttTableRelationField.ParentFieldName > '':U then
                bttTableRelation.ParentFieldList = substitute('&1,&2':U,
                                                              bttTableRelation.ParentFieldList,
                                                              bttTableRelationField.ParentFieldName).

              if bttTableRelationField.ChildFieldName > '':U then
                bttTableRelation.ChildFieldList = substitute('&1,&2':U,
                                                             bttTableRelation.ChildFieldList,
                                                             bttTableRelationField.ChildFieldName).

            end.

            hRepRelFieldQuery:get-next().

          end.

          assign
            b1ttTableRelationView.ReferenceFields    = trim(bttTableRelation.ParentFields, ' ,':U)
            b1ttTableRelationView.RelatedFields      = trim(bttTableRelation.ChildFields, ' ,':U)
            b1ttTableRelationView.FieldDetails       = trim(cRelParentFieldDetails)
            b1ttTableRelationView.ReferenceFieldList = trim(bttTableRelation.ParentFieldList, ',':U)
            b1ttTableRelationView.RelatedFieldList   = trim(bttTableRelation.ChildFieldList, ',':U)
            b2ttTableRelationView.ReferenceFields    = trim(bttTableRelation.ChildFields, ' ,':U)
            b2ttTableRelationView.RelatedFields      = trim(bttTableRelation.ParentFields, ' ,':U)
            b2ttTableRelationView.FieldDetails       = trim(cRelChildFieldDetails)
            b2ttTableRelationView.RelatedFieldList   = trim(bttTableRelation.ParentFieldList, ',':U)
            b2ttTableRelationView.ReferenceFieldList = trim(bttTableRelation.ChildFieldList, ',':U)
            .

          validate b1ttTableRelationView.
          validate b2ttTableRelationView.

          validate bttTableRelation.

        end.

        hRepRelQuery:get-next().

      end.

    end.

    else
    do:

      hRepRelFieldQuery:set-buffers(hRepRelFieldBuffer).

      assign
        cRepRelQueryText      =            'for each D_Rel':U
                                + '~n':U + '  where ( D_Rel.Tabellenname_1 = &1':U
                                + '~n':U + '     or   D_Rel.Tabellenname_2 = &1 )':U
                                + '~n':U + '  no-lock':U
        cRepRelFieldQueryText =            'for each D_RelSpalte':U
                                + '~n':U + '  where D_RelSpalte.Tabellenname_1 = &1':U
                                + '~n':U + '    and D_RelSpalte.TabellenName_2 = &2':U
                                + '~n':U + '    and D_RelSpalte.lfdNr          = &3':U
                                + '~n':U + '  no-lock':U
        .

      hRepRelQuery:query-prepare(substitute(cRepRelQueryText,
                                            quoter(bttTable.RepTableId))).

      hRepRelQuery:query-open().

      hRepRelQuery:get-first().

      do while not hRepRelQuery:query-off-end:

        find bttTableRelation
          where bttTableRelation.DatabaseName     = pcDatabaseName
            and bttTableRelation.ParentTableName  = hRepRelBuffer::Tabellenname_1
            and bttTableRelation.ChildTableName   = hRepRelBuffer::Tabellenname_2
            and bttTableRelation.SequentialNumber = hRepRelBuffer::lfdNr
          no-error.

        if not available bttTableRelation then
        do:

          create bttTableRelation.

          assign
            giRelationSeq                     = giRelationSeq + 1
            bttTableRelation.RelationId       = giRelationSeq
            bttTableRelation.DatabaseName     = pcDatabaseName
            bttTableRelation.ParentTableName  = hRepRelBuffer::Tabellenname_1
            bttTableRelation.ChildTableName   = hRepRelBuffer::Tabellenname_2
            bttTableRelation.SequentialNumber = hRepRelBuffer::lfdNr
            bttTableRelation.RelationType     = hRepRelBuffer::Rel_Art
            .

          create b1ttTableRelationView.

          assign
            cRelParentFieldDetails                   = '':U
            giRelationViewSeq                        = giRelationViewSeq + 1
            b1ttTableRelationView.RelationViewId     = giRelationViewSeq
            b1ttTableRelationView.RelationId         = bttTableRelation.RelationId
            b1ttTableRelationView.DatabaseName       = bttTableRelation.DatabaseName
            b1ttTableRelationView.ReferenceTableName = bttTableRelation.ParentTableName
            b1ttTableRelationView.RelatedTableName   = bttTableRelation.ChildTableName
            b1ttTableRelationView.RelationType       = bttTableRelation.RelationType
            .

          create b2ttTableRelationView.

          assign
            cRelChildFieldDetails                    = '':U
            giRelationViewSeq                        = giRelationViewSeq + 1
            b2ttTableRelationView.RelationViewId     = giRelationViewSeq
            b2ttTableRelationView.RelationId         = bttTableRelation.RelationId
            b2ttTableRelationView.DatabaseName       = bttTableRelation.DatabaseName
            b2ttTableRelationView.ReferenceTableName = bttTableRelation.ChildTableName
            b2ttTableRelationView.RelatedTableName   = bttTableRelation.ParentTableName
            b2ttTableRelationView.RelationType       = (if num-entries(bttTableRelation.RelationType, ':':U) = 2 then
                                                          substitute('&1:&2':U,
                                                                     entry(2, bttTableRelation.RelationType, ':':U),
                                                                     entry(1, bttTableRelation.RelationType, ':':U))
                                                        else
                                                          '?':U)
            b2ttTableRelationView.ParentRelation     = yes
            .

          hRepRelFieldQuery:query-prepare(substitute(cRepRelFieldQueryText,
                                                     quoter(hRepRelBuffer::Tabellenname_1),
                                                     quoter(hRepRelBuffer::Tabellenname_2),
                                                     quoter(hRepRelBuffer::lfdNr))).
          hRepRelFieldQuery:query-open().

          hRepRelFieldQuery:get-first().

          do while not hRepRelFieldQuery:query-off-end:

            find bttTableRelationField
              where bttTableRelationField.RelationId = bttTableRelation.RelationId
                and bttTableRelationField.Order      = hRepRelFieldBuffer::Position
              no-error.

            if not available bttTableRelationField then
            do:

              create bttTableRelationField.

              assign
                bttTableRelationField.RelationId         = bttTableRelation.RelationId
                bttTableRelationField.Order              = hRepRelFieldBuffer::Position
                bttTableRelationField.FieldRelationType  = (if hRepRelFieldBuffer::SpaltenInfo > '':U then
                                                              hRepRelFieldBuffer::SpaltenInfo
                                                            else
                                                              'DB-Field':U)
                .

              if hRepRelFieldBuffer::SpaltenInfo = '':U then
                assign
                  bttTableRelationField.ParentFieldName = hRepRelFieldBuffer::SpaltenName_1
                  bttTableRelationField.ChildFieldName  = hRepRelFieldBuffer::SpaltenName_2
                  .

              else
              do:

                if can-find(ttField
                              where ttField.DatabaseName = pcDatabaseName
                                and ttField.TableName    = bttTableRelation.ParentTableName
                                and ttField.FieldName    = hRepRelFieldBuffer::SpaltenName_1) then
                  bttTableRelationField.ParentFieldName  = hRepRelFieldBuffer::SpaltenName_1.

                else
                  bttTableRelationField.ParentConstantData = hRepRelFieldBuffer::SpaltenName_1.

                if can-find(ttField
                              where ttField.DatabaseName = pcDatabaseName
                                and ttField.TableName    = bttTableRelation.ChildTableName
                                and ttField.FieldName    = hRepRelFieldBuffer::SpaltenName_2) then
                  bttTableRelationField.ChildFieldName   = hRepRelFieldBuffer::SpaltenName_2.

               else
                  bttTableRelationField.ChildConstantData = hRepRelFieldBuffer::SpaltenName_2.

              end.

              validate bttTableRelationField.

              assign
                bttTableRelation.ParentFields = substitute('&1, &2':U,
                                                           bttTableRelation.ParentFields,
                                                           (if bttTableRelationField.ParentFieldName > '':U then
                                                              bttTableRelationField.ParentFieldName
                                                            else
                                                              bttTableRelationField.ParentConstantData) )
                cRelParentFieldDetails        = substitute('&1   [&2 = &3]':U,
                                                           cRelParentFieldDetails,
                                                           (if bttTableRelationField.ParentFieldName > '':U then
                                                              bttTableRelationField.ParentFieldName
                                                            else
                                                              bttTableRelationField.ParentConstantData),
                                                           (if bttTableRelationField.ChildFieldName > '':U then
                                                              bttTableRelationField.ChildFieldName
                                                            else
                                                              bttTableRelationField.ChildConstantData))
                bttTableRelation.ChildFields  = substitute('&1, &2':U,
                                                           bttTableRelation.ChildFields,
                                                           (if bttTableRelationField.ChildFieldName > '':U then
                                                              bttTableRelationField.ChildFieldName
                                                            else
                                                              bttTableRelationField.ChildConstantData))
                cRelChildFieldDetails         = substitute('&1   [&2 = &3]':U,
                                                           cRelChildFieldDetails,
                                                           (if bttTableRelationField.ChildFieldName > '':U then
                                                              bttTableRelationField.ChildFieldName
                                                            else
                                                              bttTableRelationField.ChildConstantData),
                                                           (if bttTableRelationField.ParentFieldName > '':U then
                                                              bttTableRelationField.ParentFieldName
                                                            else
                                                              bttTableRelationField.ParentConstantData))
                .

              if bttTableRelationField.ParentFieldName > '':U then
                bttTableRelation.ParentFieldList = substitute('&1,&2':U,
                                                              bttTableRelation.ParentFieldList,
                                                              bttTableRelationField.ParentFieldName).

              if bttTableRelationField.ChildFieldName > '':U then
                bttTableRelation.ChildFieldList = substitute('&1,&2':U,
                                                             bttTableRelation.ChildFieldList,
                                                             bttTableRelationField.ChildFieldName).

            end.

            hRepRelFieldQuery:get-next().

          end.

          assign
            b1ttTableRelationView.ReferenceFields    = trim(bttTableRelation.ParentFields, ' ,':U)
            b1ttTableRelationView.RelatedFields      = trim(bttTableRelation.ChildFields, ' ,':U)
            b1ttTableRelationView.FieldDetails       = trim(cRelParentFieldDetails)
            b1ttTableRelationView.ReferenceFieldList = trim(bttTableRelation.ParentFieldList, ' ,':U)
            b1ttTableRelationView.RelatedFieldList   = trim(bttTableRelation.ChildFieldList, ' ,':U)
            b2ttTableRelationView.ReferenceFields    = trim(bttTableRelation.ChildFields, ' ,':U)
            b2ttTableRelationView.RelatedFields      = trim(bttTableRelation.ParentFields, ' ,':U)
            b2ttTableRelationView.FieldDetails       = trim(cRelChildFieldDetails)
            b2ttTableRelationView.RelatedFieldList   = trim(bttTableRelation.ParentFieldList, ' ,':U)
            b2ttTableRelationView.ReferenceFieldList = trim(bttTableRelation.ChildFieldList, ' ,':U)
            .

          validate b1ttTableRelationView.
          validate b2ttTableRelationView.

          validate bttTableRelation.

        end.

        hRepRelQuery:get-next().

      end.

    end.

  end.

end.

bttTable.DetailsLoaded = yes.

finally:

  if valid-handle(hQuery) then
    delete object hQuery.

  if valid-handle(hRepDomainBuffer) then
    delete object hRepDomainBuffer.

  if valid-handle(hRepFieldBuffer) then
    delete object hRepFieldBuffer.

  if valid-handle(hRepRelQuery) then
    delete object hRepRelQuery.

  if valid-handle(hRepRelFieldQuery) then
    delete object hRepRelFieldQuery.

  if valid-handle(hRepRelBuffer) then
    delete object hRepRelBuffer.

  if valid-handle(hRepRelFieldBuffer) then
    delete object hRepRelFieldBuffer.

  if valid-handle(hRepField1Buffer) then
    delete object hRepField1Buffer.

  if valid-handle(hRepField2Buffer) then
    delete object hRepField2Buffer.

end finally.

end procedure.


PROCEDURE qg_AddTableRepositoryInfo :
/**
 * Add table repository information.
 */

define input parameter pcDatabaseName as character no-undo.
define input parameter pcTableName    as character no-undo.

define variable cBasisDBName        as character no-undo.
define variable cRepTableName       as character no-undo.

define variable hRepTableBuffer     as handle    no-undo.
define variable hRepTableDescBuffer as handle    no-undo.

define buffer bttDatabase for temp-table ttDatabase.
define buffer bttTable    for temp-table ttTable.

find bttDatabase
  where bttDatabase.DatabaseName = pcDatabaseName
  no-error.

if not available bttDatabase then
  leave.

find first bttTable
  where bttTable.TableName = pcTableName
  no-error.

if not available bttTable then
  leave.

cBasisDBName = bttDatabase.BasisDBName.

if    cBasisDBName > '':U
  and connected(cBasisDBName) then
do:

  // Add proALPHA repository information.
  cRepTableName = pcTableName.

  if    bttDatabase.TempDB
    and cRepTableName begins 'TD_':U then
    overlay(cRepTableName, 1, 3) = 'TT_':U. 

  create buffer hRepTableBuffer for table substitute('&1.DRC_Table':U,
                                                     cBasisDBName) no-error.

  if not valid-handle(hRepTableBuffer) then
    leave.

  hRepTableBuffer:find-first(substitute('where DRC_Table.DRC_Table_ID = &1':U,
                                        quoter(cRepTableName)),
                             no-lock) no-error.

  if not hRepTableBuffer:available then
    leave.

  create buffer hRepTableDescBuffer for table substitute('&1.DBM_ShortDescription':U,
                                                         cBasisDBName).

  assign
    bttTable.InternalIdentifier = hRepTableBuffer::InternalIdentifier
    bttTable.CompanyInclude     = hRepTableBuffer::CompanyInclude
    bttTable.KeyInclude         = hRepTableBuffer::KeyInclude
    bttTable.RepTableId         = hRepTableBuffer::DRC_Table_ID
    bttTable.RepObjectId        = hRepTableBuffer::DRC_Table_Obj
    .

  if valid-handle(hRepTableDescBuffer) then
  do:

    hRepTableDescBuffer:find-first( substitute(   'where DBM_ShortDescription.Owning_Obj = &1':U
                                                + '  and DBM_ShortDescription.Sprache    = &2':U,
                                                quoter( hRepTableBuffer::DRC_Table_Obj ),
                                                quoter( gcRepositoryLanguage ) ),
                                    no-lock ) no-error.

    if hRepTableDescBuffer:available then
      assign
        bttTable.ShortDescription  = hRepTableDescBuffer::ShortDesc1
        bttTable.DescriptionLoaded = yes
        .

  end.

end.

finally:

  if valid-handle(hRepTableBuffer) then
    delete object hRepTableBuffer.

  if valid-handle(hRepTableDescBuffer) then
    delete object hRepTableDescBuffer.

end finally.

end procedure.


PROCEDURE qg_AddTables :
/**
 * Add Tables of given Database to cache.
 *
 * @param pcDatabase = Database that contains the tables that should be added.
 */

define input parameter pcDatabase as character no-undo.

define variable cSchemaDatabaseName    as character no-undo.

define variable cTableQueryText        as character no-undo.
define variable cFieldQueryText        as character no-undo.
define variable hTableQuery            as handle    no-undo.
define variable hFieldQuery            as handle    no-undo.

define variable cTableName             as character no-undo.

define variable hFileBuffer            as handle    no-undo.
define variable hFieldBuffer           as handle    no-undo.

define variable cTriggerQueryText      as character no-undo.
define variable hTriggerQuery          as handle    no-undo.
define variable cTriggerEvent          as character no-undo.

define variable hFileTrigBuffer        as handle    no-undo.


define buffer bttDatabase for temp-table ttDatabase.
define buffer bttTable    for temp-table ttTable.
define buffer bttField    for temp-table ttField.

display unless-hidden
  substitute('Loading database &1 ...':T,
             pcDatabase)
    @ gcStatusText60
  with frame fStatus
    no-labels
    overlay
    color messages
    centered
    view-as dialog-box
    width 65
    .
process events.

find bttDatabase
  where bttDatabase.DatabaseName = pcDatabase
  no-error.

if not available bttDatabase then
  leave.

cSchemaDatabaseName = sdbname( pcDatabase ).

create query hTableQuery.
create query hTriggerQuery.
create query hFieldQuery.

assign
  hTableQuery:forward-only   = yes
  hTriggerQuery:forward-only = yes
  hFieldQuery:forward-only   = yes
  .

create buffer hFileBuffer     for table substitute('&1._File':U, cSchemaDatabaseName).
create buffer hFileTrigBuffer for table substitute('&1._File-Trig':U, cSchemaDatabaseName).
create buffer hFieldBuffer    for table substitute('&1._Field':U, cSchemaDatabaseName).

hTableQuery:set-buffers(hFileBuffer).
hTriggerQuery:set-buffers(hFileTrigBuffer).
hFieldQuery:set-buffers(hFieldBuffer).

// For some odd reason the queries are much faster, when no fields option is
// present - thus the fields option has been removed. Joins somehow perform
// very bad on dynamic queries as well. For this reason a separate query is
// used for every table.

assign
  cTableQueryText   =            'for each _File':U
                      + '~n':U + '  no-lock':U
  cFieldQueryText   =            'for each _Field':U
                      + '~n':U + '  where _Field._File-recid = &1':U
                      + '~n':U + '  no-lock':U
  cTriggerQueryText =            'for each _File-Trig':U
                      + '~n':U + '  where _File-Trig._File-Recid = &1':U
                      + '~n':U + '  no-lock':U
  .

hTableQuery:query-prepare(cTableQueryText).
hTableQuery:query-open().

hTableQuery:get-first().

do while not hTableQuery:query-off-end:

  create bttTable.

  assign
    bttTable.DatabaseName  = pcDatabase
    bttTable.TableName     = hFileBuffer::_File-Name
    cTableName             = bttTable.TableName
    bttTable.FillInclude   = substitute('&1.fld':U,
                                        hFileBuffer::_Dump-name)
    bttTable.PhysicalTable = yes
    .

  hTriggerQuery:query-prepare(substitute(cTriggerQueryText, string(hFileBuffer:recid))).
  hTriggerQuery:query-open().

  hTriggerQuery:get-first().

  do while not hTriggerQuery:query-off-end:

    cTriggerEvent = hFileTrigBuffer::_Event.

    case cTriggerEvent:

      when 'CREATE':U then
        assign
          bttTable.CreateTrigger         = hFileTrigBuffer::_Proc-Name
          bttTable.CreateTriggerProcName = substring(bttTable.CreateTrigger,
                                                     max(r-index(bttTable.CreateTrigger, '/':U),
                                                         r-index(bttTable.CreateTrigger, '\':U)) + 1)
          .

      when 'WRITE':U then
        assign
          bttTable.WriteTrigger         = hFileTrigBuffer::_Proc-Name
          bttTable.WriteTriggerProcName = substring(bttTable.WriteTrigger,
                                                     max(r-index(bttTable.WriteTrigger, '/':U),
                                                         r-index(bttTable.WriteTrigger, '\':U)) + 1)
          .

      when 'DELETE':U then
        assign
          bttTable.DeleteTrigger         = hFileTrigBuffer::_Proc-Name
          bttTable.DeleteTriggerProcName = substring(bttTable.DeleteTrigger,
                                                     max(r-index(bttTable.DeleteTrigger, '/':U),
                                                         r-index(bttTable.DeleteTrigger, '\':U)) + 1)
          .

    end case.

    hTriggerQuery:get-next().

  end.

  hFieldQuery:query-prepare(substitute(cFieldQueryText, string(hFileBuffer:recid))).
  hFieldQuery:query-open().

  hFieldQuery:get-first().

  do while not hFieldQuery:query-off-end:

    create bttField.

    assign
      bttField.DatabaseName      = pcDatabase
      bttField.TableName         = hFileBuffer::_File-Name
      bttField.FieldName         = hFieldBuffer::_Field-Name
      bttField.DataType          = substitute('&1&2':U,
                                              caps(substring(hFieldBuffer::_Data-Type, 1, 1)),
                                              lc(substring(hFieldBuffer::_Data-Type, 2)))
      bttField.FieldExtent       = hFieldBuffer::_Extent
      bttField.FieldInitialValue = hFieldBuffer::_Initial
      bttField.FieldLabel        = (if hFieldBuffer::_Label = ? then
                                      '':U
                                    else
                                      hFieldBuffer::_Label)
      bttField.FieldColumnLabel  = (if hFieldBuffer::_Col-label = ? then
                                      '':U
                                    else
                                      hFieldBuffer::_Col-label)
      bttField.FieldDecimals     = hFieldBuffer::_Decimals
      bttField.FieldFormat       = hFieldBuffer::_Format
      bttField.IsMandatory       = hFieldBuffer::_Mandatory
      bttField.FieldViewAs       = hFieldBuffer::_View-As
      bttField.IsObjectId        = ( bttField.FieldName matches '*_Obj':U )
      .

    hFieldQuery:get-next().

  end.

  // Some tables have to be in the cache completely from the start.
  if    bttTable.TableName = 'DRC_Table':U
     or bttTable.TableName = 'DRC_Field':U
     or bttTable.TableName = 'DRC_Domain':U then

    run qg_AddTableDetails( bttTable.DatabaseName, bttTable.TableName ).

  hTableQuery:get-next().

end.

finally:

  if valid-handle(hTableQuery) then
    delete object hTableQuery.

  if valid-handle (hFileBuffer) then
    delete object hFileBuffer.

  if valid-handle(hTriggerQuery) then
    delete object hTriggerQuery.

  if valid-handle (hFileTrigBuffer) then
    delete object hFileTrigBuffer.

  if valid-handle(hFieldQuery) then
    delete object hFieldQuery.

  if valid-handle (hFieldBuffer) then
    delete object hFieldBuffer.

end finally.

end procedure.


procedure qg_LoadAllTableDetailsOfSingleDatabase :
define input parameter pcDatabaseName as character no-undo.

define buffer bttTable for temp-table ttTable.

display unless-hidden
  'Loading table details ...':T
    @ gcStatusText60
  with frame fStatus
    no-labels
    overlay
    color messages
    centered
    view-as dialog-box
    width 65
    in window {&WINDOW-NAME}
    .

process events.

for each bttTable
  where bttTable.DatabaseName  = pcDatabaseName
    and bttTable.DetailsLoaded = no
  on error undo, throw:

  run qg_AddTableDetails( bttTable.DatabaseName,
                          bttTable.TableName ).

end.

finally:

  hide frame fStatus.

end finally.

end procedure.


function qg_cCustomizedRepositoryValue returns character 
  ( pcBasisDBName   as character,
    pcTableName     as character,
    pcFieldName     as character,
    pcOwning_Obj    as character ):
/**
 *
 *
 * @param pcBasisDBName
 * @param pcTableName
 * @param pcFieldName
 * @param pcOwning_Obj
 */

define variable hRepCustObjBuffer as handle    no-undo.

define buffer bttField for temp-table ttField.

create buffer hRepCustObjBuffer for table substitute( '&1.DRC_CustomizedObject':U, pcBasisDBName ) no-error.

if not valid-handle( hRepCustObjBuffer ) then
  return ?.

find bttField
  where bttField.DatabaseName = pcBasisDBName
    and bttField.TableName    = pcTableName
    and bttField.FieldName    = pcFieldName
  no-error.

if not available bttField then
  return ?.

hRepCustObjBuffer:find-last( substitute(   'where DRC_CustomizedObject.Owning_Obj    = &1':U
                                         + '  and DRC_CustomizedObject.CustomLevel  <= &2':U
                                         + '  and DRC_CustomizedObject.DRC_Field_Obj = &3':U
                                         + 'use-index Own':U,
                                         quoter( pcOwning_Obj ),
                                         quoter( gcCustomLevel ),
                                         quoter( bttField.RepObjectId ) ),
                              no-lock ) no-error.

return ( if hRepCustObjBuffer:available then
           hRepCustObjBuffer::CustomFieldValueChar
         else
           ? ).

end function.


/* <<< Include: incl/database_schema.i <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/* >>> Include: incl/query_window.i >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> */

/**
 * @COPYRIGHT@
 * Project Proalpha
 * Name    query_window.i
 * Created <version> as of 04.06.2022/Thiemann_M
 * Current @PAVERSION@ as of @PADATE@/@PALASTAUTHOR@
 *
 *
 * ## HISTORY
 * @FILEHISTORY@
 */

// ********************  Preprocessor Definitions  ********************


procedure qg_AddFieldToQueryBufferFieldsTempTable :
define parameter buffer pbttQueryBuffer for temp-table ttQueryBuffer.

define input        parameter phField            as handle    no-undo.
define input        parameter pcFieldName        as character no-undo.
define input        parameter piFieldIndex       as integer   no-undo.
define input        parameter plIsVirtual        as logical   no-undo.

define input        parameter pcFieldNameToMatch as character no-undo.
define input-output parameter ioprMatch          as rowid     no-undo extent 4.

define buffer bttQueryBufferField for temp-table ttQueryBufferField.

create bttQueryBufferField.

assign
  bttQueryBufferField.FieldHandle = phField
  bttQueryBufferField.FieldName   = pcFieldName
  bttQueryBufferField.FieldIndex  = piFieldIndex
  bttQueryBufferField.DisplayName = qg_cFormattedFieldName(?,
                                                           ?,
                                                           bttQueryBufferField.FieldName,
                                                           bttQueryBufferField.FieldIndex)
  bttQueryBufferField.IsVirtual   = plIsVirtual
  .

validate bttQueryBufferField.

if pcFieldNameToMatch > '':U then
do:

  if    ioprMatch[1]                  = ?
    and bttQueryBufferField.FieldName = pcFieldNameToMatch then

    ioprMatch[1] = rowid(bttQueryBufferField).

  else if ioprMatch[2]                       = ?
    and   bttQueryBufferField.FieldName begins pcFieldNameToMatch then

    ioprMatch[2] = rowid(bttQueryBufferField).

  else if ioprMatch[3]                        = ?
    and   pcFieldNameToMatch            matches '*_Obj':U
    and   bttQueryBufferField.FieldName       = substitute('&1_Obj':U,
                                                           pbttQueryBuffer.BufferHandle:table) then
    ioprMatch[3] = rowid(bttQueryBufferField).

  else if ioprMatch[4]                        = ?
    and   pcFieldNameToMatch            matches '*_Obj':U
    and   bttQueryBufferField.FieldName matches '*_Obj':U then

    ioprMatch[4] = rowid(bttQueryBufferField).

end.

end procedure.


procedure qg_AddFieldToQueryWindowObjFieldTempTable :
define parameter buffer pbttQueryWindow for temp-table ttQueryWindow.

define input parameter pcDatabaseName as character no-undo.
define input parameter pcBufferName   as character no-undo.
define input parameter pcTableName    as character no-undo.
define input parameter pcFieldName    as character no-undo.
define input parameter piFieldIndex   as integer   no-undo.
define input parameter pcFieldValue   as character no-undo.

define buffer bttQueryWindowObjField for temp-table ttQueryWindowObjField.

define buffer bttField               for temp-table ttField.

create bttQueryWindowObjField.

assign
  bttQueryWindowObjField.WindowHandle = pbttQueryWindow.WindowHandle
  bttQueryWindowObjField.DatabaseName = pcDatabaseName
  bttQueryWindowObjField.TableName    = pcTableName
  bttQueryWindowObjField.BufferName   = pcBufferName
  bttQueryWindowObjField.FieldName    = pcFieldName
  bttQueryWindowObjField.FieldIndex   = piFieldIndex
  bttQueryWindowObjField.DisplayName  = qg_cFormattedFieldName(?,
                                                               ?,
                                                               bttQueryWindowObjField.FieldName,
                                                               bttQueryWindowObjField.FieldIndex)
  .

find bttField
  where bttField.DatabaseName = bttQueryWindowObjField.DatabaseName
    and bttField.TableName    = bttQueryWindowObjField.TableName
    and bttField.FieldName    = bttQueryWindowObjField.FieldName
  no-error.

assign
  bttQueryWindowObjField.IsObjectId = (     bttQueryWindowObjField.FieldName matches '*_Obj':U
                                         or ( available bttField
                                          and bttField.Domain = {&K_OBJECT_ID_DOMAIN}) )
  bttQueryWindowObjField.IsVirtual  = ( if available bttField then
                                          bttField.IsVirtual
                                        else
                                          no )
  bttQueryWindowObjField.FieldType  = ( if available bttField then
                                          bttField.FieldType
                                        else
                                          {&K_FIELD_TYPE_DB_FIELD} )
  .



bttQueryWindowObjField.ContainsObj  =     pcFieldValue                    <> ?
                                      and num-entries(pcFieldValue, ':':U) = 3
                                      and length(pcFieldValue)            >= 10.

if bttQueryWindowObjField.ContainsObj then

  run qg_GetObjectIdTable( pcDatabaseName,
                           pcFieldValue,
                           output bttQueryWindowObjField.TargetDatabaseName,
                           output bttQueryWindowObjField.TargetTableName ).

bttQueryWindowObjField.Priority = (if bttQueryWindowObjField.FieldName = substitute('&1_Obj':U, bttQueryWindowObjField.TableName) then
                                     3
                                   else if    bttQueryWindowObjField.IsObjectId
                                          and bttQueryWindowObjField.ContainsObj then
                                     1
                                   else if bttQueryWindowObjField.IsObjectId then
                                     2
                                   else if bttQueryWindowObjField.ContainsObj then
                                     4
                                   else
                                     5).

validate bttQueryWindowObjField.

end procedure.


procedure qg_FillQueryBufferFieldsTempTable :
define parameter buffer pbttQueryBuffer for temp-table ttQueryBuffer.

define input        parameter pcFieldNameToMatch as character no-undo.
define input        parameter plAddVirtualFields as logical   no-undo.

define input-output parameter ioprMatch          as rowid     no-undo extent 4.

define variable hBufferfield       as handle    no-undo.
define variable cDatabaseName      as character no-undo.
define variable iFieldCounter      as integer   no-undo.
define variable iFieldIndexCounter as integer   no-undo.

define buffer bttField for temp-table ttField.

empty temp-table ttQueryBufferField.

// Add physical fields.
do iFieldCounter = 1 to pbttQueryBuffer.BufferHandle:num-fields:

  hBufferField = pbttQueryBuffer.BufferHandle:buffer-field(iFieldCounter).

  do iFieldIndexCounter = integer(hBufferField:extent > 0) to hBufferField:extent:

    run qg_AddFieldToQueryBufferFieldsTempTable( buffer pbttQueryBuffer,
                                                 hBufferField,
                                                 hBufferField:name,
                                                 iFieldIndexCounter,
                                                 no,
                                                 pcFieldNameToMatch,
                                                 input-output ioprMatch ).

  end.

end.

// Add virtual fields.
if plAddVirtualFields then
do:

  cDatabaseName = qg_cDatabaseNameForTableOrBuffer( pbttQueryBuffer.BufferHandle ).

  if qg_lIsPhysicalDatabase( cDatabaseName ) then

    for each bttField
      where bttField.DatabaseName = cDatabaseName
        and bttField.TableName    = pbttQueryBuffer.BufferHandle:table
        and bttField.IsVirtual    = yes
      on error undo, throw:

      run qg_AddFieldToQueryBufferFieldsTempTable( buffer pbttQueryBuffer,
                                                   ?,
                                                   bttField.FieldName,
                                                   0,
                                                   bttField.IsVirtual,
                                                   pcFieldNameToMatch,
                                                   input-output ioprMatch ).

    end.

end.

end procedure.


procedure qg_GetOverlayColumnValue :
define parameter buffer pbttFieldOverlay for temp-table ttFieldOverlay.

define input  parameter plDeepResolve   as logical   no-undo.
define input parameter  plRawValues     as logical   no-undo.

define output parameter opcOverlayValue as character no-undo.
define output parameter oplResolved     as logical   no-undo.

define variable cFieldValue        as character no-undo.
define variable cKeyValues         as character no-undo.

define buffer bttVirtualFieldColumn for temp-table ttVirtualFieldColumn.

if valid-handle( pbttFieldOverlay.FieldHandle ) then

  cFieldValue = pbttFieldOverlay.FieldHandle:buffer-value( pbttFieldOverlay.FieldIndex ).

else
do:

  find bttVirtualFieldColumn
    where bttVirtualFieldColumn.OwnerHandle  = pbttFieldOverlay.OwnerHandle
      and bttVirtualFieldColumn.ColumnHandle = pbttFieldOverlay.ColumnHandle
    no-error.

  if not available bttVirtualFieldColumn then

    cFieldValue = ?.

  else

    cFieldValue = string( qg_clVirtualFieldValueAsLongchar( bttVirtualFieldColumn.FieldType,
                                                            bttVirtualFieldColumn.DataType,
                                                            bttVirtualFieldColumn.FieldName,
                                                            qg_cObjectIdForBuffer( bttVirtualFieldColumn.BufferHandle ),
                                                            ? ) ).

end.

opcOverlayValue = cFieldValue.

if    cFieldValue > '':U
  and num-entries( cFieldValue, ':':U ) = 3 then
do:

  cKeyValues = qg_cOverlayFieldValue( buffer pbttFieldOverlay,
                                      cFieldValue,
                                      plDeepResolve ).

  if cKeyValues <> ? then

    assign
      opcOverlayValue = cKeyValues
      oplResolved     = yes
      .

end.

end procedure.


PROCEDURE qg_QueryWindowAddSnapshot :
/**
 * Add snapshot of current query.
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow        as handle    no-undo.

define variable hBuffer as handle no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if not valid-handle(bttQueryWindow.QueryHandle) then
  leave.

hBuffer = bttQueryWindow.QueryHandle:get-buffer-handle(1).

run qg_AddTableSnapshot(hBuffer,
                        bttQueryWindow.QueryHandle:prepare-string,
                        bttQueryWindow.WindowHandle).

apply 'entry' to bttQueryWindow.WindowHandle.

end procedure.

PROCEDURE qg_QueryWindowAddSortFields :
/**
 * Add sort phrase for given field list.
 *
 * @param phWindow = Handle of the Query window.
 * @param pcSortFieldList = List of fields to insert.
 */

define input parameter phWindow        as handle    no-undo.
define input parameter pcSortFieldList as character no-undo.

define variable i              as integer   no-undo.

define variable hEditor        as handle    no-undo.
define variable cQuerytext     as character no-undo.
define variable iOffset        as integer   no-undo.
define variable iLineEndOffset as integer   no-undo.
define variable cInsertText    as character no-undo.
define variable iLine          as integer   no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.
define buffer bttQueryAST       for temp-table ttQueryAST.
define buffer bttQueryCondition for temp-table ttQueryCondition.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

// Get selection info

assign
  hEditor    = bttQueryWindow.QueryTextEditorHandle
  cQueryText = hEditor:input-value
  iOffset    = (if hEditor:selection-end = ? then
                  hEditor:cursor-offset
                else
                  hEditor:selection-end - 1)
  .

// Analyze selection and query text

run qg_ParseQueryConditions(cQueryText).

find last bttQueryCondition
  no-error.

if    available bttQueryCondition
  and bttQueryCondition.RightEndPos > iOffset then
  iOffset = bttQueryCondition.RightEndPos.

find first bttQueryAST
  where bttQueryAST.TokenType = {&K_QP_TOKEN_TYPE_KEYWORD}
    and lookup(bttQueryAST.TokenText, 'BREAK,BY':U) > 0
  no-error.

if    available bttQueryAST
  and bttQueryAST.TokenStart > iOffset then
do:

  iLineEndOffset = r-index(cQueryText, '~n':U, bttQueryAST.TokenStart).

  iOffset = (if iLineEndOffset > 0 then
               iLineEndOffset
             else
               1).

end.

find last bttQueryAST
  where bttQueryAST.TokenType = {&K_QP_TOKEN_TYPE_KEYWORD}
    and lookup(bttQueryAST.TokenText, 'BREAK,BY':U) > 0
  no-error.

if    available bttQueryAST
  and bttQueryAST.TokenEnd < iOffset then
  iOffset = bttQueryAST.TokenEnd.

iLineEndOffset = index(cQueryText, '~n':U, iOffset).

if iLineEndOffset > 0 then
  iOffset = iLineEndOffset.

// Generate line text.

do i = 1 to num-entries(pcSortFieldList):

  cInsertText = substitute('&1  by &2~n':U,
                           cInsertText,
                           entry(i, pcSortFieldList)).

end.

cInsertText = trim(cInsertText, '~n':U).

// Insert text lines.

run qg_InsertTextLines(cInsertText,
                       iOffset,
                       input-output cQueryText,
                             output iLine).

// Update editor

cQueryText = qg_cBeautifyQueryText(cQueryText).

run qg_UpdateEditor(hEditor,
                    cQueryText,
                    iLine,
                    iLine + max(0, num-entries(cInsertText, '~n':U) - 1)).

apply 'entry':U to hEditor.

end procedure.

PROCEDURE qg_QueryWindowAddSortOption :
/**
 * Add selected fields as sort phrase.
 *
 * @param phWindow = Handle of the Query window.
 * @param plDescending = Add sort option as descending sort.
 */

define input parameter phWindow     as handle    no-undo.
define input parameter plDescending as logical   no-undo.

define variable hBuffer                as handle    no-undo.
define variable cDatabaseName          as character no-undo.
define variable lPhysicalDatabase      as logical   no-undo.

define variable i                      as integer   no-undo.
define variable iFieldCount            as integer   no-undo.

define variable hFieldSelectionBuffer  as handle    no-undo.
define variable cSortFieldList         as character no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if bttQueryWindow.ObjSourceQuerySeq > 0 then
  leave.

hFieldSelectionBuffer = bttQueryWindow.QueryFieldBrowseBufferHandle.

assign
  hBuffer           = bttQueryWindow.QueryBrowseHandle:query:get-buffer-handle(1)
  cDatabaseName     = qg_cDatabaseNameForTableOrBuffer( hBuffer )
  lPhysicalDatabase = qg_lIsPhysicalDatabase( cDatabaseName )
  .


do i = 1 to bttQueryWindow.QueryFieldBrowseHandle:num-selected-rows:

  bttQueryWindow.QueryFieldBrowseHandle:fetch-selected-row (i).

  if    lPhysicalDatabase
    and hFieldSelectionBuffer::IsVirtual then

    message
      substitute( 'Virtual field &1 can not be used in the query!':T,
                  quoter( hFieldSelectionBuffer::FieldName ) ) skip
      view-as alert-box
      warning
      buttons ok
      in window bttQueryWindow.WindowHandle.

  else

    assign
      cSortFieldList = substitute('&1,&2&3':U,
                                  cSortFieldList,
                                  qg_cFormattedFieldName(?,
                                                         hFieldSelectionBuffer::BufferName,
                                                         hFieldSelectionBuffer::FieldName,
                                                         hFieldSelectionBuffer::FieldIndex),
                                  (if plDescending then
                                     ' descending':U
                                   else
                                     '':U))
      iFieldCount   = iFieldCount + 1
      .

end.

if iFieldCount = 0 then

  return.

cSortFieldList = trim(cSortFieldList, ',':U).

if num-entries(cSortFieldList, ',':U) > 0 then
  run qg_QueryWindowAddSortFields(phWindow,
                                  cSortFieldList).

end procedure.

PROCEDURE qg_QueryWindowBeautify :
/**
 * Beautify query text.
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.

define variable cQueryText as character no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if bttQueryWindow.ObjSourceQuerySeq > 0 then
  leave.

assign
  cQueryText = bttQueryWindow.QueryTextEditorHandle:input-value
  cQueryText = qg_cBeautifyQueryText(cQueryText)
  bttQueryWindow.QueryTextEditorHandle:screen-value = cQueryText
  .

return no-apply.

end procedure.

PROCEDURE qg_QueryWindowBufferComparisonStartMerge :
define input parameter plAllFields     as logical   no-undo.
define input parameter pcFieldName     as character no-undo.
define input parameter piFieldIndex    as integer   no-undo.
define input parameter plCaseSensitive as logical   no-undo.

define variable i             as integer   no-undo.

define variable cLabel        as character no-undo.
define variable iLongestLabel as integer   no-undo.

define variable clFieldValue1 as longchar  no-undo.
define variable clCompText1   as longchar  no-undo.
define variable cTitle1       as character no-undo.

define variable clFieldValue2 as longchar  no-undo.
define variable clCompText2   as longchar  no-undo.
define variable cTitle2       as character no-undo.

define buffer bttBufferComparisonField  for temp-table ttBufferComparisonField.
define buffer b2ttBufferComparisonField for temp-table ttBufferComparisonField.

for each bttBufferComparisonField
  on error undo, throw:

  if    ( pcFieldName                            > '':U
      and ( bttBufferComparisonField.FieldName  <> pcFieldName
         or bttBufferComparisonField.FieldIndex <> piFieldIndex ) )
     or bttBufferComparisonField.DataType     = 'blob':U
     or ( not plAllFields
      and bttBufferComparisonField.IsEqual    = yes ) then
    next.

  assign
    cLabel        = qg_cFormattedFieldName(?,
                                           ?,
                                           bttBufferComparisonField.FieldName,
                                           bttBufferComparisonField.FieldIndex)
    iLongestLabel = maximum(length(cLabel), iLongestLabel)
    .

end.

for each bttBufferComparisonField
  on error undo, throw:

  if    ( pcFieldName                            > '':U
      and ( bttBufferComparisonField.FieldName  <> pcFieldName
         or bttBufferComparisonField.FieldIndex <> piFieldIndex ) )
     or bttBufferComparisonField.DataType     = 'blob':U
     or ( not plAllFields
      and bttBufferComparisonField.IsEqual   <> no )
     or ( bttBufferComparisonField.BufferNo  = 2
      and can-find(ttBufferComparisonField
                     where ttBufferComparisonField.BufferNo   = 1
                       and ttBufferComparisonField.FieldName  = bttBufferComparisonField.FieldName
                       and ttBufferComparisonField.FieldIndex = bttBufferComparisonField.FieldIndex) ) then
    next.

  release b2ttBufferComparisonField.

  if bttBufferComparisonField.BufferNo = 1 then
  do:

    copy-lob bttBufferComparisonField.FieldValue to clFieldValue1.

    if clFieldValue1 = ? then
      clFieldValue1 = '?':U.

    assign
      cLabel      = qg_cFormattedFieldName(?,
                                           ?,
                                           bttBufferComparisonField.FieldName,
                                           bttBufferComparisonField.FieldIndex)
      clCompText1 =   clCompText1 + '~n':U
                    + (if pcFieldName > '':U then
                         clFieldValue1
                       else
                           cLabel
                         + fill(' ':U, iLongestLabel - length(cLabel))
                         + ': ':U
                         + quoter(string(clFieldValue1)))
      .

    if cTitle1 = '':U then
      cTitle1 = (if pcFieldName > '':U then
                   substitute('&1.&2.&3':U,
                              bttBufferComparisonField.DatabaseName,
                              bttBufferComparisonField.BufferName,
                              cLabel)
                 else
                   substitute('&1.&2':U,
                              bttBufferComparisonField.DatabaseName,
                              bttBufferComparisonField.BufferName)).

  end.

  find b2ttBufferComparisonField
    where b2ttBufferComparisonField.BufferNo   = 2
      and b2ttBufferComparisonField.FieldName  = bttBufferComparisonField.FieldName
      and b2ttBufferComparisonField.FieldIndex = bttBufferComparisonField.FieldIndex
    no-error.

  if available b2ttBufferComparisonField then
  do:

    copy-lob b2ttBufferComparisonField.FieldValue to clFieldValue2.

    if clFieldValue2 = ? then
      clFieldValue2 = '?':U.

    assign
      cLabel      = qg_cFormattedFieldName(?,
                                           ?,
                                           b2ttBufferComparisonField.FieldName,
                                           b2ttBufferComparisonField.FieldIndex)
      clCompText2 =   clCompText2 + '~n':U
                    + (if pcFieldName > '':U then
                         clFieldValue2
                       else
                           cLabel
                         + fill(' ':U, iLongestLabel - length(cLabel))
                         + ': ':U
                         + quoter(string(clFieldValue2)))
      .

    if cTitle2 = '':U then
      cTitle2 = (if pcFieldName > '':U then
                   substitute('&1.&2.&3':U,
                              b2ttBufferComparisonField.DatabaseName,
                              b2ttBufferComparisonField.BufferName,
                              cLabel)
                 else
                   substitute('&1.&2':U,
                              b2ttBufferComparisonField.DatabaseName,
                              b2ttBufferComparisonField.BufferName)).

  end.

end.

assign
  clCompText1 = trim(clCompText1, '~n':U)
  clCompText2 = trim(clCompText2, '~n':U)
  .

run qg_CompareText((if cTitle1 > '':U then
                      cTitle1
                    else
                      '<Undefined>':T),
                   clCompText1,
                   (if cTitle2 > '':U then
                      cTitle2
                    else
                      '<Undefined>':T),
                   clCompText2,
                   plCaseSensitive,
                   yes).

end procedure.

PROCEDURE qg_QueryWindowBufferComparisonSelectFirstDifference :
define input parameter plCaseSensitive as logical   no-undo.
define input parameter phField1        as handle    no-undo.
define input parameter phField2        as handle    no-undo.

define variable clFieldValue1   as longchar  no-undo.
define variable iField1Length   as integer   no-undo.
define variable cChar1          as character no-undo.

define variable clFieldValue2   as longchar  no-undo.
define variable iField2Length   as integer   no-undo.
define variable cChar2          as character no-undo.

define variable i               as integer   no-undo.
define variable iBufferNo       as integer   no-undo.
define variable iTemp           as integer   no-undo.
define variable iIndex1         as integer   no-undo.
define variable iIndex2         as integer   no-undo.
define variable iSelectionStart1 as integer   no-undo.
define variable iSelectionEnd1   as integer   no-undo.
define variable iSelectionStart2 as integer   no-undo.
define variable iSelectionEnd2   as integer   no-undo.

define buffer bttBufferComparisonField  for temp-table ttBufferComparisonField.
define buffer b2ttBufferComparisonField for temp-table ttBufferComparisonField.

assign
  clFieldValue1 = phField1:input-value
  iField1Length = length(clFieldValue1)
  clFieldValue2 = phField2:input-value
  iField2Length = length(clFieldValue2)
  .

do i = 1 to maximum(iField1Length, iField2Length):

  if    iIndex1 > 0
    and i       > iIndex1
    and iIndex2 > 0
    and i       > iIndex2 then
    leave.

  assign
    cChar1 = substring(clFieldValue1, i, 1)
    cChar2 = substring(clFieldValue2, i, 1)
    .

  if compare(cChar1,
             'NE':U,
             cChar2,
             (if plCaseSensitive then
                'CASE-SENSITIVE':U
              else
                'CASE-INSENSITIVE':U)) then
  do:

    if iSelectionStart1 = 0 then
      iSelectionStart1 = i.

    if iSelectionStart2 = 0 then
      iSelectionStart2 = i.

  end.

  if    iSelectionStart1 > 0
    and cChar1           > '':U then
  do:

    iTemp = 0.

    do while yes:

      iTemp = index(clFieldValue2,
                    cChar1,
                    maximum(iSelectionStart1, iTemp + 1)).

      if iTemp = 0 then
        leave.

      if not compare(cChar1,
                     'EQ':U,
                     substring(clFieldValue2, iTemp, 1),
                     (if plCaseSensitive then
                        'CASE-SENSITIVE':U
                      else
                        'CASE-INSENSITIVE':U)) then
        next.

      if    iIndex1 = 0
         or iTemp   < iIndex1 then
      do:

        assign
          iIndex1        = iTemp
          iSelectionEnd1 = i
          .

        leave.

      end.

    end.

  end.

  if    iSelectionStart2 > 0
    and cChar2           > '':U then
  do:

    iTemp = 0.

    do while yes:

      iTemp = index(clFieldValue1,
                    cChar2,
                    maximum(iSelectionStart2, iTemp + 1)).

      if iTemp = 0 then
        leave.

      if not compare(cChar2,
                     'EQ':U,
                     substring(clFieldValue1, iTemp, 1),
                     (if plCaseSensitive then
                        'CASE-SENSITIVE':U
                      else
                        'CASE-INSENSITIVE':U)) then
        next.

      if    iIndex2 = 0
         or iTemp   < iIndex2 then
      do:

        assign
          iIndex2        = iTemp
          iSelectionEnd2 = i
          .

        leave.

      end.

    end.

  end.

end.

if iIndex2 > 0 then
do:

  iTemp = 0.

  do while yes:

    iTemp = index(clFieldValue1,
                  substring(clFieldValue1, iIndex2, 1),
                  maximum(iSelectionStart1, iTemp + 1)).

    if    iTemp > 0
      and not compare(substring(clFieldValue1, iIndex2, 1),
                      'EQ':U,
                      substring(clFieldValue1, iTemp, 1),
                      (if plCaseSensitive then
                         'CASE-SENSITIVE':U
                       else
                         'CASE-INSENSITIVE':U)) then
      next.

    if    iSelectionEnd1 > 0
      and iTemp          < iSelectionEnd1 then
      iSelectionEnd1 = iTemp.

    leave.

  end.

end.

if iIndex1 > 0 then
do:

  iTemp = index(clFieldValue2,
                substring(clFieldValue2, iIndex1, 1),
                iSelectionStart2).

  if    iSelectionEnd2 > 0
    and iTemp          > iSelectionEnd2 then
    iSelectionEnd2 = iTemp.

end.

// Line feeds count as one character in progress but are two
// characters in the editor widget.

do i = 1 to iSelectionEnd1 - 1:

  if substring(clFieldValue1, i, 1) = '~n':U then
  do:

    if i < iSelectionStart1 then
      iSelectionStart1 = iSelectionStart1 + 1.

    iSelectionEnd1 = iSelectionEnd1 + 1.

  end.

end.

do i = 1 to iSelectionEnd2 - 1:

  if substring(clFieldValue2, i, 1) = '~n':U then
  do:

    if i < iSelectionStart2 then
      iSelectionStart2 = iSelectionStart2 + 1.

    iSelectionEnd2 = iSelectionEnd2 + 1.

  end.

end.

if iSelectionStart1 > 0 then
  phField1:set-selection(iSelectionStart1, iSelectionEnd1).

if iSelectionStart2 > 0 then
  phField2:set-selection(iSelectionStart2, iSelectionEnd2).

end procedure.

PROCEDURE qg_QueryWindowCalculateSum :
/**
 * Calculate Sum for currently selected field.
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow            as handle    no-undo.

define variable dDecimalSum           as decimal   no-undo.
define variable iIntegerSum           as int64     no-undo.

define variable hQuery                as handle    no-undo.
define variable hFieldBuffer          as handle    no-undo.
define variable hField                as handle    no-undo.
define variable cBufferName           as character no-undo.
define variable iFieldType            as integer   no-undo.
define variable cDataType             as character no-undo.
define variable cFieldName            as character no-undo.
define variable iFieldIndex           as integer   no-undo.
define variable iDecimals             as integer   no-undo.
define variable iBufferCounter        as integer   no-undo.
define variable rCurrentRecords       as rowid     no-undo extent.
define variable lRestoreQueryPosition as logical   no-undo.

define variable cFormat               as character no-undo.

define variable cFieldSumLabel as character no-undo
  format 'x(255)':U
  view-as text
  size 56 by 1
  .

define variable cFieldSum as character no-undo
  format 'x(255)':U
  view-as fill-in
  size 45 by 1
  .

define button btnCopy
  label 'Copy':T
  size 10 by 1
  .

define button btnClose
  label 'Close':T
  size 20 by 1.14
  auto-go.

define buffer bttQueryWindow        for temp-table ttQueryWindow.

define buffer bttVirtualFieldColumn for temp-table ttVirtualFieldColumn.
define buffer bttField              for temp-table ttField.

define frame fFieldSum
  cFieldSumLabel at row 1.5 col 3 no-label
  cFieldSum at row 3 col 3 no-label
  btnCopy at row 3 col 49
  btnClose at row 5 col 20
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 61 by 6.83
    title gcTitlePrefix + 'Field Sum':T
    default-button btnClose
    cancel-button btnClose.

on window-close of frame fFieldSum
  apply 'end-error' to self.

on choose of btnCopy in frame fFieldSum
  clipboard:value = cFieldSum.

if not valid-handle(phWindow) then
  return.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if    not available bttQueryWindow
   or not valid-handle( bttQueryWindow.QueryFieldBrowseHandle ) then
  return.

if not valid-handle( bttQueryWindow.QueryBrowseSelectedColumn ) then

  message
    'No field selected':T skip
    view-as alert-box
    error
    buttons ok
    in window bttQueryWindow.WindowHandle.

assign
  hQuery = bttQueryWindow.QueryHandle
  hField = bttQueryWindow.QueryBrowseSelectedColumn:buffer-field.

if valid-handle( hField ) then

  assign
    hFieldBuffer = hField:buffer-handle
    cBufferName  = hFieldBuffer:name
    iFieldType   = {&K_FIELD_TYPE_DB_FIELD}
    cDataType    = hField:data-type
    cFieldName   = hField:name
    iDecimals    = hField:decimals
    .

else
do:

  find first bttVirtualFieldColumn
    where bttVirtualFieldColumn.OwnerHandle  = hQuery
      and bttVirtualFieldColumn.ColumnHandle = bttQueryWindow.QueryBrowseSelectedColumn
    no-error.

  if not available bttVirtualFieldColumn then

    return.

  assign
    hFieldBuffer  = bttVirtualFieldColumn.BufferHandle
    cBufferName   = bttVirtualFieldColumn.BufferName
    iFieldType    = bttVirtualFieldColumn.FieldType
    cDataType     = bttVirtualFieldColumn.DataType
    cFieldName    = bttVirtualFieldColumn.FieldName
    iDecimals     = 0
    .

end.

assign
  iFieldIndex               = bttQueryWindow.QueryBrowseSelectedColumn:index
  extent( rCurrentRecords ) = hQuery:num-buffers
  .

if lookup( bttQueryWindow.QueryBrowseSelectedColumn:data-type, 'DECIMAL,INTEGER,INT64':U ) = 0 then
do:

  message
    'Sums can only be calculated for decimal, inter or int64 fields':T skip
    view-as alert-box
    error
    buttons ok
    in window bttQueryWindow.WindowHandle.

  return.

end.

lRestoreQueryPosition = (     hQuery:num-buffers > 0
                          and hQuery:get-buffer-handle( 1 ):available ).

do iBufferCounter = 1 to hQuery:num-buffers:
  rCurrentRecords[iBufferCounter] = hQuery:get-buffer-handle( iBufferCounter ):rowid.
end.

do on error undo, throw:

  hQuery:get-first().

  do while not hQuery:query-off-end:

    case string( bttQueryWindow.QueryBrowseSelectedColumn:data-type ):

      when 'DECIMAL':U then

        dDecimalSum =   dDecimalSum
                      + ( if valid-handle( hField ) then
                            decimal( hField:buffer-value( iFieldIndex ) )
                          else
                            decimal( qg_clVirtualFieldValueAsLongchar( iFieldType,
                                                                       cDataType,
                                                                       cFieldName,
                                                                       qg_cObjectIdForBuffer( hFieldBuffer ),
                                                                       ? ) ) ).

      otherwise

        iIntegerSum =   iIntegerSum
                      + ( if valid-handle( hField ) then
                            integer( hField:buffer-value( iFieldIndex ) )
                          else
                            integer( qg_clVirtualFieldValueAsLongchar( iFieldType,
                                                                       cDataType,
                                                                       cFieldName,
                                                                       qg_cObjectIdForBuffer( hFieldBuffer ),
                                                                       ? ) ) ).

    end case.

    hQuery:get-next().

  end.

  assign
    cFieldSumLabel = substitute( 'Sum of Field &1:':T,
                                  qg_cFormattedFieldName( ?,
                                                          cBufferName,
                                                          cFieldName,
                                                          iFieldIndex ) )
    cFieldSum:read-only in frame fFieldSum = yes
    .

  case string( cDataType ):

    when 'DECIMAL':U then
    do:

      cFormat = substitute( '&1zz9':U, fill( 'zzz,':U, 17 ) ).

      if iDecimals > 0 then

        cFormat = substitute( '&1.&2':U, cFormat, fill( '9':U, iDecimals ) ).

      else

        cFormat = substitute( '&1.&2':U, cFormat, fill( '9':U, 10 ) ).

      cFieldSum = trim( string( dDecimalSum, cFormat ) ).

    end.

    otherwise

      assign
        cFormat   = '-z,zzz,zzz,zzz,zzz,zzz,zz9':U
        cFieldSum = trim( string( iIntegerSum, cFormat ) )
        .

  end case.

  update unless-hidden
    cFieldSumLabel
    cFieldSum
    btnCopy
    btnClose
    with frame fFieldSum
      in window bttQueryWindow.WindowHandle.

  finally:

    if lRestoreQueryPosition then
      hQuery:reposition-to-rowid(rCurrentRecords).

  end finally.

end.

end procedure.

PROCEDURE qg_QueryWindowClose :
/**
 * Close query window (and clean up dynamically created widgets).
 *
 * @param phWindow = Handle of the Query window.
 * @param phQuery = Query of the Query window.
 */

define input parameter phWindow            as handle    no-undo.
define input parameter plCloseChildWindows as logical   no-undo.

define variable hBuffer          as handle    no-undo.
define variable rQueryWindowView as rowid     no-undo.

define buffer bttQueryWindow                  for temp-table ttQueryWindow.
define buffer bttFieldOverlay                 for temp-table ttFieldOverlay.
define buffer bttQueryWindowQueryBrowseColumn for temp-table ttQueryWindowQueryBrowseColumn.
define buffer bttQueryWindowView              for temp-table ttQueryWindowView.
define buffer bttQueryLink                    for temp-table ttQueryLink.
define buffer bttRecentQuery                  for temp-table ttRecentQuery.
define buffer bttQueryWindowField             for temp-table ttQueryWindowField.
define buffer bttQueryWindowObjField          for temp-table ttQueryWindowObjField.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if available bttQueryWindow then
do:

  if    plCloseChildWindows = ?
    and can-find(first ttQueryLink
                   where ttQueryLink.SourceSeq = bttQueryWindow.QuerySeq) then
    message
      'Do you want to close all linked child windows as well?':T
      view-as alert-box
      question
      buttons yes-no
      update plCloseChildWindows
      in window bttQueryWindow.WindowHandle.

  if plCloseChildWindows then
    run qg_QueryWindowCloseChildWindows(bttQueryWindow.QuerySeq).

  if valid-handle(bttQueryWindow.QueryBrowseHandle) then

    bttQueryWindow.QueryBrowseHandle:visible = no.

  run qg_RemoveAllVirtualFieldColums( buffer bttQueryWindow ).

  for each bttFieldOverlay
    where bttFieldOverlay.OwnerHandle = bttQueryWindow.QueryHandle
    on error undo, throw:

    run qg_DeleteFieldOverlay(bttFieldOverlay.OwnerHandle,
                              bttFieldOverlay.BufferName,
                              bttFieldOverlay.FieldName,
                              bttFieldOverlay.FieldIndex).

  end.

  for each bttQueryWindowQueryBrowseColumn
    where bttQueryWindowQueryBrowseColumn.WindowHandle = bttQueryWindow.WindowHandle:

    delete bttQueryWindowQueryBrowseColumn.

  end.

  for each bttRecentQuery
    where bttRecentQuery.WindowHandle = bttQueryWindow.WindowHandle
    on error undo, throw:

    delete bttRecentQuery.

  end.

  for each bttQueryLink
    where bttQueryLink.TargetSeq = bttQueryWindow.QuerySeq
    on error undo, throw:

    delete bttQueryLink.

  end.

  for each bttQueryWindowField
    where bttQueryWindowField.WindowHandle = bttQueryWindow.WindowHandle
    on error undo, throw:

    delete bttQueryWindowField.

  end.

  for each bttQueryWindowObjField
    where bttQueryWindowObjField.WindowHandle = bttQueryWindow.WindowHandle
    on error undo, throw:

    delete bttQueryWindowObjField.

  end.

  if valid-handle(ghQueryWindowListWindow) then
  do:

    hBuffer = ghQueryWindowListBrowse:query:get-buffer-handle(1).

    if hBuffer:available then
    do:

      if hBuffer::WindowHandle <> bttQueryWindow.WindowHandle then
        rQueryWindowView = hBuffer:rowid.

      else
      do:

        find last bttQueryWindowView
          where bttQueryWindowView.Id < hBuffer::Id
          no-error.

        if available bttQueryWindowView then
          rQueryWindowView = rowid(bttQueryWindowView).

      end.

    end.

  end.

  for each bttQueryWindowView
    where bttQueryWindowView.ParentWindowHandle = bttQueryWindow.WindowHandle
    on error undo, throw:

    bttQueryWindowView.ParentWindowHandle = ?.

  end.

  for each bttQueryWindowView
    where bttQueryWindowView.WindowHandle = bttQueryWindow.WindowHandle
    on error undo, throw:

    delete bttQueryWindowView.

  end.

  delete bttQueryWindow.

end.

// Clean up all dynamically created objects.
run qg_DeleteWidgetTree(phWindow, yes).

run qg_QueryWindowUpdateAll('':U).

run qg_QueryWindowListRefresh.

if    valid-handle(ghQueryWindowListWindow)
  and rQueryWindowView <> ? then
do:

  find bttQueryWindowView
    where rowid(bttQueryWindowView) = rQueryWindowView
    no-error.

  if available bttQueryWindowView then
    ghQueryWindowListBrowse:query:reposition-to-rowid(rowid(bttQueryWindowView)).

end.

if valid-handle(ghQueryWindowListWindow) then
  run qg_ActivateWindow(ghQueryWindowListWindow, ghQueryWindowListBrowse).

end procedure.

PROCEDURE qg_QueryWindowCloseChildWindows :
define input parameter piSourceSeq as integer   no-undo.

define buffer bttQueryWindow  for temp-table ttQueryWindow.
define buffer bttQueryLink    for temp-table ttQueryLink.

for each bttQueryLink
  where bttQueryLink.SourceSeq = piSourceSeq,
first bttQueryWindow
  where bttQueryWindow.QuerySeq = bttQueryLink.TargetSeq
  on error undo, throw:

  run qg_QueryWindowCloseChildWindows(bttQueryWindow.QuerySeq).

  if valid-handle(bttQueryWindow.WindowHandle) then
    run qg_QueryWindowClose(bttQueryWindow.WindowHandle, no).

end.

end procedure.

PROCEDURE qg_QueryWindowCompareSelectedRecords :
define input parameter phParentWindow  as handle    no-undo.

define variable lCaseSensitive   as logical   no-undo.

define variable iDifferentFields as integer   no-undo.
define variable dColOffset       as decimal   no-undo.

define variable cBufferLabel1    as character no-undo.
define variable hColLabel1       as handle    no-undo.
define variable cBufferLabel2    as character no-undo.
define variable hColLabel2       as handle    no-undo.

define variable hScrollBox       as handle    no-undo.

define variable lAllFields as logical no-undo
  format 'yes/no':U
  view-as radio-set
    radio-buttons
      'Different fields':T, no,
      'All fields':T, yes
    horizontal
  size 35 by 1.

define variable cCaseSensitive as character no-undo
  view-as text
  size 5 by 1 .

define rectangle rectCaseSensitive
  no-fill
  edge-pixels 2
  graphic-edge
  tooltip 'Switch to case sensitive mode':U
  size 7 by 1.5.

define button btnMerge
  label 'Merge':T
  tooltip 'Compare field values in Araxis Merge':T
  size 20 by 1.14.

define button btnCancel
  label 'Close':T
  size 20 by 1.14
  auto-end-key.

define buffer bttBufferComparisonField  for temp-table ttBufferComparisonField.
define buffer b2ttBufferComparisonField for temp-table ttBufferComparisonField.

define frame fBufferComparison
    lAllFields at row 2 col 1 no-label
    rectCaseSensitive at row 1.75 col 1
    cCaseSensitive at row 2 col 1 no-label
    btnMerge at row 5 col 1
    btnCancel at row 5 col 1
  with 1 down keep-tab-order overlay
    view-as dialog-box
    side-labels no-underline three-d 
    size 170 by 6.94
    title gcTitlePrefix + 'Buffer comparison':T
    cancel-button btnCancel.

on window-close of frame fBufferComparison
  apply 'end-error' to self.

on choose of btnMerge
  run qg_QueryWindowBufferComparisonStartMerge(input frame fBufferComparison lAllFields,
                                               ?,
                                               ?,
                                               lCaseSensitive).

on value-changed of lAllFields in frame fBufferComparison
do:

  define variable iX as integer   no-undo.
  define variable iY as integer   no-undo.

  // Update comparison field widgets.
  if valid-handle(hScrollBox) then
    run qg_DeleteWidgetTree(hScrollBox:handle, yes).

  lAllFields = input frame fBufferComparison lAllFields.

  run qg_QueryWindowCreateBufferComparisonFrame(input-output hScrollBox,
                                                lCaseSensitive,
                                                lAllFields,
                                                      output iDifferentFields,
                                                      output dColOffset).


  // Set dialog size.
  assign
    iX                                               = frame fBufferComparison:x
    iY                                               = frame fBufferComparison:y
    frame fBufferComparison:title                    = substitute('&1Buffer comparison (&2&3 &4)':T,
                                                                  gcTitlePrefix,
                                                                  (if lCaseSensitive then
                                                                     'case sensitive, ':L
                                                                   else
                                                                     '':U),
                                                                  string(iDifferentFields),
                                                                  (if iDifferentFields = 1 then
                                                                     'difference':T
                                                                   else
                                                                     'differences':T))
    frame fBufferComparison:width-chars              = hScrollBox:width-chars  + 5
    frame fBufferComparison:virtual-width-chars      = frame fBufferComparison:width-chars
    frame fBufferComparison:height-chars             = hScrollBox:height-chars + 8
    frame fBufferComparison:virtual-height-chars     = frame fBufferComparison:height-chars
    frame fBufferComparison:x                        = iX
    frame fBufferComparison:y                        = iY
    lAllFields:col in frame fBufferComparison        =   ( frame fBufferComparison:width-chars
                                                       - lAllFields:width-chars in frame fBufferComparison )
                                                       / 2
    rectCaseSensitive:col in frame fBufferComparison =   frame fBufferComparison:width
                                                       - rectCaseSensitive:width in frame fBufferComparison
                                                       - 5
    cCaseSensitive:col in frame fBufferComparison   =   rectCaseSensitive:col in frame fBufferComparison
                                                      + (   rectCaseSensitive:width in frame fBufferComparison
                                                          - cCaseSensitive:width in frame fBufferComparison )
                                                      / 2
    btnMerge:row in frame fBufferComparison         = frame fBufferComparison:height-chars - 1.94
    btnCancel:row in frame fBufferComparison        = frame fBufferComparison:height-chars - 1.94
      .

  // Hide merge button if araxis merge is not available.
  if valid-handle(gchMerge) then
    assign
      btnMerge:col in frame fBufferComparison  = (frame fBufferComparison:width-chars / 2)
                                                   - btnMerge:width-chars in frame fBufferComparison 
      btnCancel:col in frame fBufferComparison = (frame fBufferComparison:width-chars / 2)
      .

  else
    btnCancel:col in frame fBufferComparison =   frame fBufferComparison:width-chars / 2
                                               - btnCancel:width-chars in frame fBufferComparison / 2.

  process events.

  assign
    hScrollBox:frame                             = frame fBufferComparison:handle
    hScrollBox:hidden                            = no
    hScrollBox:visible                           = yes
    .

  // Remove horizontal scrollbar if necessary.
  if hScrollBox:virtual-height-chars > hScrollBox:height-chars then
  do:

    display unless-hidden
      with frame fBufferComparison
        in window phParentWindow.

    run qg_SetScrollbars(hScrollBox:handle, no, ?).

  end.

end.

on mouse-select-click of rectCaseSensitive in frame fBufferComparison
do:

  if lCaseSensitive then
  do:

    assign
      lCaseSensitive            = no
      rectCaseSensitive:filled  = no
      rectCaseSensitive:bgcolor = ?
      rectCaseSensitive:tooltip = 'Switch to case sensitive mode':T
      cCaseSensitive:bgcolor    = ?
      .

  end.

  else
  do:

    assign
      lCaseSensitive            = yes
      rectCaseSensitive:filled  = yes
      rectCaseSensitive:bgcolor = {&K_COLOR_YELLOW}
      rectCaseSensitive:tooltip = 'Switch to case insensitive mode':T
      cCaseSensitive:bgcolor    = {&K_COLOR_YELLOW}
      .

  end.

  process events.

  apply 'value-changed':U to lAllFields in frame fBufferComparison.

end.

run qg_QueryWindowCreateBufferComparisonFrame(input-output hScrollBox,
                                              lCaseSensitive,
                                              no,
                                                    output iDifferentFields,
                                                    output dColOffset).

if iDifferentFields = 0 then
  message
    'The Records are identical':T skip
    view-as alert-box
    information
    in window phParentWindow.


// Set dialog size.
assign
  frame fBufferComparison:title                          = substitute('&1 (&2&3 differences)':U,
                                                                      frame fBufferComparison:title,
                                                                      (if lCaseSensitive then
                                                                         'case sensitive, ':L
                                                                       else
                                                                         '':U),
                                                                      string(iDifferentFields),
                                                                      (if iDifferentFields = 1 then
                                                                         'difference':T
                                                                       else
                                                                         'differences':T))
  frame fBufferComparison:width-chars                    = hScrollBox:width-chars  + 5
  frame fBufferComparison:height-chars                   = hScrollBox:height-chars + 8
  lAllFields:col in frame fBufferComparison              =   ( frame fBufferComparison:width-chars
                                                           - lAllFields:width-chars in frame fBufferComparison )
                                                           / 2
  rectCaseSensitive:col in frame fBufferComparison       =   frame fBufferComparison:width
                                                           - rectCaseSensitive:width in frame fBufferComparison
                                                           - 5
  rectCaseSensitive:sensitive in frame fBufferComparison = yes
  cCaseSensitive                                         = 'Aa':T
  cCaseSensitive:width in frame fBufferComparison        = font-table:get-text-width-chars(cCaseSensitive,
                                                                                          cCaseSensitive:font in frame fBufferComparison)
  cCaseSensitive:height in frame fBufferComparison       = font-table:get-text-height-chars(cCaseSensitive:font in frame fBufferComparison)
  cCaseSensitive:col in frame fBufferComparison          =   rectCaseSensitive:col in frame fBufferComparison
                                                           + (   rectCaseSensitive:width in frame fBufferComparison
                                                               - cCaseSensitive:width in frame fBufferComparison )
                                                           / 2
  cCaseSensitive:row in frame fBufferComparison          =   rectCaseSensitive:row in frame fBufferComparison
                                                           + (   rectCaseSensitive:height in frame fBufferComparison
                                                               - cCaseSensitive:height in frame fBufferComparison )
                                                           / 2
  btnMerge:row in frame fBufferComparison                = frame fBufferComparison:height-chars - 1.94
  btnCancel:row in frame fBufferComparison               = frame fBufferComparison:height-chars - 1.94
  .

  if valid-handle(gchMerge) then
    assign
      btnMerge:col in frame fBufferComparison  = (frame fBufferComparison:width-chars / 2)
                                                   - btnMerge:width-chars in frame fBufferComparison 
      btnCancel:col in frame fBufferComparison = (frame fBufferComparison:width-chars / 2)
      .

  else
    assign
      btnMerge:visible in frame fBufferComparison = no
      btnCancel:col in frame fBufferComparison    =   frame fBufferComparison:width-chars / 2
                                                    - btnCancel:width-chars in frame fBufferComparison / 2
      .

  hScrollBox:frame = frame fBufferComparison:handle.

// Create column labels.
find first bttBufferComparisonField
  where bttBufferComparisonField.BufferNo  = 1
  no-error.

if available bttBufferComparisonField then
do:

  cBufferLabel1 = substitute('&1.&2':U,
                             bttBufferComparisonField.DatabaseName,
                             bttBufferComparisonField.BufferName).

  create text hColLabel1
    assign
      format        = substitute('x(&1)':U, length(cBufferLabel1))
      screen-value  = cBufferLabel1
      frame         = frame fBufferComparison:handle
      width         = font-table:get-text-width-chars(cBufferLabel1)
      row           = 3.5
      height        = 1
      col           = dColOffset + 3 + (76 - hColLabel1:width-chars) / 2
      .

end.

find first bttBufferComparisonField
  where bttBufferComparisonField.BufferNo  = 2
  no-error.

if available bttBufferComparisonField then
do:

  cBufferLabel2 = substitute('&1.&2':U,
                             bttBufferComparisonField.DatabaseName,
                             bttBufferComparisonField.BufferName).
    .

  create text hColLabel2
    assign
      format        = substitute('x(&1)':U, length(cBufferLabel2))
      screen-value  = cBufferLabel2
      frame         = frame fBufferComparison:handle
      width         = font-table:get-text-width-chars(cBufferLabel2)
      row           = 3.5
      height        = 1
      col           = dColOffset + 3 + 76 + (76 - hColLabel2:width-chars) / 2
      .

end.

// Remove horizontal scrollbar if necessary.
if hScrollBox:virtual-height-chars > hScrollBox:height-chars then
do:

  display unless-hidden
    with frame fBufferComparison
      in window phParentWindow.

  run qg_SetScrollbars(hScrollBox:handle, no, ?).

end.

// Show dialog.
update unless-hidden
  lAllFields
  rectCaseSensitive
  cCaseSensitive
  btnMerge
    when valid-handle(gchMerge)
  btnCancel
  with frame fBufferComparison
    in window phParentWindow.

finally:

  if valid-handle(hColLabel1) then
    delete object hColLabel1 no-error.

  if valid-handle(hColLabel2) then
    delete object hColLabel2 no-error.

  if valid-handle(hScrollBox) then
    run qg_DeleteWidgetTree(hScrollBox:handle, yes).

end finally.

end procedure.

PROCEDURE qg_QueryWindowCopyQueryText :
/**
 * Copy actual query text with resolved external tokens to clipboard.
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if not valid-handle(bttQueryWindow.QueryHandle) then
  leave.

clipboard:value = bttQueryWindow.QueryHandle:prepare-string.

end procedure.

PROCEDURE qg_QueryWindowCopyRecid :
/**
 * Copy recid/rowid of the current query window record.
 *
 * @param phWindow = Handle of the Query window.
 * @param plRecid = If yes then the recid will be copied. If no then the rowid will be copied.
 */

define input parameter phWindow as handle    no-undo.
define input parameter plRecid  as logical   no-undo.

define variable i       as integer   no-undo.
define variable hBuffer as handle    no-undo.
define variable cList   as character no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if not valid-handle(bttQueryWindow.QueryHandle) then
  leave.

do i = 1 to bttQueryWindow.QueryHandle:num-buffers:

  assign
    hBuffer = bttQueryWindow.QueryHandle:get-buffer-handle(i)
    cList   = substitute('&1,&2':U,
                         cList,
                         (if plRecid then
                            string(hBuffer:recid)
                          else
                            string(hBuffer:rowid)))
    .

end.

clipboard:value = trim(cList, ',':U).

end procedure.

PROCEDURE qg_QueryWindowCopyRecordValues :
/**
 * Copy record values.
 *
 * @param phWindow = Handle of the Query window.
 * @param plRawValues = Copy raw values.
 */

define input parameter phWindow as handle    no-undo.

define variable lRawValues as logical no-undo
  format 'yes/no':U
  view-as radio-set
    radio-buttons
      'Raw values':T, yes,
      'Formatted values':T, no
  size 30 by 2.

define button btnOk
  label 'Ok':T
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.


define buffer bttQueryWindow for temp-table ttQueryWindow.

define frame fCopyRecordValues
  lRawValues at row 1.5 col 10 no-label
  btnOk at row 4.5 col 5
  btnCancel at row 4.5 col 25
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 49 by 6.5
    title gcTitlePrefix + 'Copy record values':T
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fCopyRecordValues
  apply 'end-error' to self.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

lRawValues = glCopyRawValues.

update unless-hidden
  lRawValues
  btnOk
  btnCancel
  with frame fCopyRecordValues
    in window bttQueryWindow.WindowHandle. 

glCopyRawValues = lRawValues.

clipboard:value = qg_clBrowseValues(bttQueryWindow.QueryBrowseHandle,
                                    glCopyRawValues).

end procedure.

PROCEDURE qg_QueryWindowSelectForComparison :
define input parameter phWindow   as handle    no-undo.
define input parameter piBufferNo as integer   no-undo.

define variable hQuery        as handle    no-undo.
define variable hBuffer       as handle    no-undo.
define variable cDatabaseName as character no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hQuery = bttQueryWindow.QueryHandle.

if hQuery:num-buffers = 1 then
  hBuffer = hQuery:get-buffer-handle(1).

else
  run qg_SelectQueryBuffer(hQuery, output hBuffer).

if valid-handle(hBuffer) then
do:

  cDatabaseName = qg_cDatabaseNameForTableOrBuffer( hBuffer ).

  run qg_SetBufferComparisonBuffer(cDatabaseName, hBuffer, piBufferNo).

end.

end procedure.

PROCEDURE qg_QueryWindowUpdateQuery :
/**
 *
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow    as handle    no-undo.
define input parameter pcTables    as character no-undo.

define variable lRebuild      as logical   no-undo.
define variable lHidden       as logical   no-undo.
define variable hOldBuffers   as handle    no-undo extent.

define variable hBuffer       as handle    no-undo.
define variable hQuery        as handle    no-undo.

define variable i             as integer   no-undo.

define variable cTableEntry   as character no-undo.
define variable cDatabaseName as character no-undo.
define variable cTableName    as character no-undo.
define variable cBufferName   as character no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

define buffer bttTable       for temp-table ttTable.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hQuery = bttQueryWindow.QueryHandle.

// Create new (if necessary). 
if not valid-handle(hQuery) then
do:

  create query hQuery.

  bttQueryWindow.QueryHandle = hQuery.

end.

// Check if current query buffers match the tables parameter. If that is the
// case no changes have to be made. Otherwise all buffers have to be rebuilt.

if num-entries(pcTables) <> hQuery:num-buffers then
  lRebuild = yes.

else
do:

  do i = 1 to num-entries(pcTables):

    if i > hQuery:num-buffers then
    do:

      lRebuild = yes.
      leave.

    end.

    assign
      cTableEntry   = entry(i, pcTables)
      cDatabaseName = entry(1, cTableEntry, '.':U)
      cTableEntry   = entry(2, cTableEntry, '.':U)
      cTableName    = entry(1, cTableEntry, ':':U)
      cBufferName   = (if num-entries(cTableEntry, ':':U) > 1 then
                         entry(2, cTableEntry, ':':U)
                       else
                         cTableName)
      hBuffer       = hQuery:get-buffer-handle(i)
      .

    if    cTableName    <> hBuffer:table
       or cDatabaseName <> qg_cDatabaseNameForTableOrBuffer( hBuffer ) then
    do:

      lRebuild = yes.
      leave.

    end.

    if hBuffer:name <> cBufferName then
      hBuffer:name = cBufferName.

  end.

end.

if lRebuild then
do on error undo, throw:

  if valid-handle(bttQueryWindow.QueryBrowseHandle) then
    assign
      lHidden = bttQueryWindow.QueryBrowseHandle:hidden
      bttQueryWindow.QueryBrowseHandle:hidden = yes
      .

  // Delete all currently assigned buffers. Deleting one buffer will also
  // remove all other buffers from the query. Due to this we have to store
  // all buffers in an extent field prior to deletion.

  if hQuery:num-buffers > 0 then
  do:

    extent(hOldBuffers) = hQuery:num-buffers.

    do i = hQuery:num-buffers to 1 by -1:
      hOldBuffers[i] = hQuery:get-buffer-handle(i).
    end.

    do i = 1 to extent(hOldBuffers):
      delete object hOldBuffers[i].
    end.

  end.

  // Create and assign new buffers
  do i = 1 to num-entries(pcTables):

    assign
      cTableEntry   = entry(i, pcTables)
      cDatabaseName = entry(1, cTableEntry, '.':U)
      cTableEntry   = entry(2, cTableEntry, '.':U)
      cTableName    = entry(1, cTableEntry, ':':U)
      cBufferName   = (if num-entries(cTableEntry, ':':U) > 1 then
                         entry(2, cTableEntry, ':':U)
                       else
                         cTableName)
      .

    find bttTable
      where bttTable.DatabaseName = cDatabaseName
        and bttTable.TableName    = cTableName
      no-error.

    if   not available bttTable
      or (  not bttTable.PhysicalTable
        and not valid-handle(bttTable.TableHandle)) then
      next.

    if not bttTable.DetailsLoaded then
      run qg_AddTableDetails(bttTable.DatabaseName,
                             bttTable.TableName).

    if not bttTable.PhysicalTable then
      create buffer hBuffer for table bttTable.TableHandle /* code checked by mth 30.07.2015 */
        buffer-name cBufferName.

    else
      create buffer hBuffer for table substitute('&1.&2':U, /* code checked by mth 30.07.2015 */
                                                 bttTable.DatabaseName,
                                                 bttTable.TableName)
        buffer-name cBufferName.

    hBuffer:private-data = qg_cParamListWriteCharacter(hBuffer:private-data,
                                                       'DatabaseName':U,
                                                       bttTable.DatabaseName,
                                                       ',':U).

    hQuery:add-buffer(hBuffer).

  end.

  run qg_QueryWindowUpdateFieldTempTable( bttQueryWindow.QueryHandle,
                                          bttQueryWindow.WindowHandle,
                                          '':U ).

  if valid-handle(bttQueryWindow.QueryFrameHandle) then
  do:

    // For some reason deleting query buffers also removes the query from the
    // query browse handle. Due to this we have to set it again.

    bttQueryWindow.QueryBrowseHandle:query = hQuery.

    run qg_QueryWindowRefreshBrowseColumns(bttQueryWindow.WindowHandle).

    run qg_QueryWindowQueryOpenFieldQuery(bttQueryWindow.WindowHandle).

  end.

  if valid-handle(bttQueryWindow.RecordFrameHandle) then
    run qg_QueryWindowRecordOpenQuery(bttQueryWindow.WindowHandle).

  // Update window title. Since for a record window the title is updated with
  // every record data refresh this has only to be done for query windows at
  // this point.

  if bttQueryWindow.WindowMode = {&K_QUERY_WINDOW_MODE_QUERY} then
    run qg_QueryWindowQueryUpdateTitle(bttQueryWindow.WindowHandle).

  finally:

    if valid-handle(bttQueryWindow.QueryBrowseHandle) then
      bttQueryWindow.QueryBrowseHandle:hidden = lHidden.

  end finally.

end.

validate bttQueryWindow.

end procedure.

PROCEDURE qg_QueryWindowCreateBufferComparisonFrame :
/**
 *
 *
 * @param phWindow = Handle of the Query window.
 */

define input-output parameter iophFrame          as handle    no-undo.
define input        parameter plCaseSensitive    as logical   no-undo.
define input        parameter plAllFields        as logical   no-undo.
define       output parameter opiDifferentFields as integer   no-undo.
define       output parameter opdColOffset       as decimal   no-undo.

define variable i                as integer   no-undo.
define variable dHeightDelta     as decimal   no-undo.

define variable lEditor          as logical   no-undo.

define variable clFieldValue1    as longchar  no-undo.
define variable clFieldValue2    as longchar  no-undo.

define variable hColLabel1       as handle    no-undo.
define variable hColLabel2       as handle    no-undo.
define variable hField1          as handle    no-undo.
define variable hField2          as handle    no-undo.
define variable hButton          as handle    no-undo.
define variable hTemp            as handle    no-undo.
define variable cPrivateData     as character no-undo.

define variable cLabel           as character no-undo.
define variable iLongestLabel    as integer   no-undo.
define variable dLongestLabel    as decimal   no-undo.

define variable iFlags           as integer   no-undo.
define variable iDummy           as integer   no-undo.

define buffer bttBufferComparisonField  for temp-table ttBufferComparisonField.
define buffer b2ttBufferComparisonField for temp-table ttBufferComparisonField.

for each bttBufferComparisonField
  where bttBufferComparisonField.DataType <> 'blob':U
  on error undo, throw:

  if    bttBufferComparisonField.BufferNo  = 2
    and can-find(ttBufferComparisonField
                   where ttBufferComparisonField.BufferNo   = 1
                     and ttBufferComparisonField.FieldName  = bttBufferComparisonField.FieldName
                     and ttBufferComparisonField.FieldIndex = bttBufferComparisonField.FieldIndex) then
    next.

  release b2ttBufferComparisonField.

  if bttBufferComparisonField.BufferNo = 1 then
  do:

    find b2ttBufferComparisonField
      where b2ttBufferComparisonField.BufferNo   = 2
        and b2ttBufferComparisonField.FieldName  = bttBufferComparisonField.FieldName
        and b2ttBufferComparisonField.FieldIndex = bttBufferComparisonField.FieldIndex
      no-error.

    if available b2ttBufferComparisonField then
    do:

      copy-lob bttBufferComparisonField.FieldValue to clFieldValue1.
      copy-lob b2ttBufferComparisonField.FieldValue to clFieldValue2.

      assign
        bttBufferComparisonField.IsEqual  = compare(clFieldValue1,
                                                    'EQ':U,
                                                    clFieldValue2,
                                                    (if plCaseSensitive then
                                                       'CASE-SENSITIVE':U
                                                     else
                                                       'CASE-INSENSITIVE':U))
        b2ttBufferComparisonField.IsEqual = bttBufferComparisonField.IsEqual
        .

    end.

  end.


  if    plAllFields
     or bttBufferComparisonField.IsEqual = no then
    assign
      i                  = i + 1
      opiDifferentFields = opiDifferentFields + 1
          when bttBufferComparisonField.IsEqual = no
      lEditor            =    bttBufferComparisonField.DataType  = 'clob':U
                           or (  bttBufferComparisonField.BufferNo = 1
                             and available b2ttBufferComparisonField
                             and b2ttBufferComparisonField.DataType = 'clob':U )
                           or length(clFieldValue1) > 30000
                           or length(clFieldValue2) > 30000
                           or index(clFieldValue1, '~n':U) > 0
                           or index(clFieldValue2, '~n':U) > 0
      dHeightDelta       = dHeightDelta + (if lEditor then
                                             5
                                           else
                                             1)
      cLabel             = qg_cFormattedFieldName
                             (?,
                              ?,
                              bttBufferComparisonField.FieldName,
                              bttBufferComparisonField.FieldIndex)
      iLongestLabel      = maximum(iLongestLabel,
                                   length(cLabel))
      dLongestLabel      = maximum(dLongestLabel,
                                   font-table:get-text-width-chars(cLabel))
      .

end.

opdColOffset = dLongestLabel + 3.

if valid-handle(iophFrame) then
  run qg_DeleteWidgetTree(iophFrame:first-child, no).

else
  create frame iophFrame
    assign
      name                 = 'fScrollBox':U
      box                  = no
      three-d              = yes
      width-chars          = 165 + dLongestLabel
      virtual-width-chars  = 165 + dLongestLabel
      height               = 0.25 + minimum(30, dHeightDelta)
      virtual-height       = 0.25 + dHeightDelta
      row                  = 5
      col                  = 3
      sensitive            = yes
      scrollable           = yes
      careful-paint        = no
      .

assign
  dHeightDelta = 0
  i            = 0
  .

for each bttBufferComparisonField
  where bttBufferComparisonField.DataType <> 'blob':U
  on error undo, throw:

  if    ( not plAllFields
      and bttBufferComparisonField.IsEqual <> no )
     or ( bttBufferComparisonField.BufferNo  = 2
      and can-find(ttBufferComparisonField
                     where ttBufferComparisonField.BufferNo   = 1
                       and ttBufferComparisonField.FieldName  = bttBufferComparisonField.FieldName
                       and ttBufferComparisonField.FieldIndex = bttBufferComparisonField.FieldIndex) ) then
    next.

  i = i + 1.

  release b2ttBufferComparisonField.

  if bttBufferComparisonField.BufferNo = 1 then
  do:

    copy-lob bttBufferComparisonField.FieldValue to clFieldValue1.

    if clFieldValue1 = ? then
      clFieldValue1 = '?':U.

    find b2ttBufferComparisonField
      where b2ttBufferComparisonField.BufferNo   = 2
        and b2ttBufferComparisonField.FieldName  = bttBufferComparisonField.FieldName
        and b2ttBufferComparisonField.FieldIndex = bttBufferComparisonField.FieldIndex
      no-error.

    if available b2ttBufferComparisonField then
      copy-lob b2ttBufferComparisonField.FieldValue to clFieldValue2.

    else
      clFieldValue2 = '':U.

    if clFieldValue2 = ? then
      clFieldValue2 = '?':U.

  end.

  else
  do:

    copy-lob bttBufferComparisonField.FieldValue to clFieldValue2.

    clFieldValue1 = '':U.

  end.

  lEditor =    bttBufferComparisonField.DataType  = 'clob':U
            or (  bttBufferComparisonField.BufferNo = 1
              and available b2ttBufferComparisonField
              and b2ttBufferComparisonField.DataType = 'clob':U )
            or length(clFieldValue1) > 30000
            or length(clFieldValue2) > 30000
            or index(clFieldValue1, '~n':U) > 0
            or index(clFieldValue2, '~n':U) > 0.

  create editor hField1
    assign
      name                 = substitute('&1_1':U, bttBufferComparisonField.FieldName)
      frame                = iophFrame
      width                = 76
      height               = (if lEditor then
                                5
                              else
                                1)
      row                  = dHeightDelta + 1
      col                  = dLongestLabel + 5
      word-wrap            = no
      scrollbar-horizontal = (if lEditor then
                                yes
                              else
                                no)
      scrollbar-vertical   = (if lEditor then
                                yes
                              else
                                no)
      return-inserted      = (if lEditor then
                                yes
                              else
                                no)
      bgcolor              = (if    plAllFields
                                and bttBufferComparisonField.IsEqual = ?
                                and ( bttBufferComparisonField.BufferNo = 2 ) then
                                {&K_COLOR_LIGHT_GREY}
                              else if plAllFields
                                and bttBufferComparisonField.IsEqual = no then
                                {&K_COLOR_YELLOW}
                              else
                                ?)
      fgcolor              = ( if    bttBufferComparisonField.IsVirtual
                                 and bttBufferComparisonField.FieldType = {&K_FIELD_TYPE_VIRTUAL_DB_FIELD} then
                                 {&K_VIRTUAL_DB_FIELD_FGCOLOR}
                               else
                                 ? )
      sensitive            = yes
      read-only            = yes
      .

  assign
    hField1:screen-value = clFieldValue1
    cLabel               = qg_cFormattedFieldName(?,
                                                  ?,
                                                  bttBufferComparisonField.FieldName,
                                                  bttBufferComparisonField.FieldIndex)
    .

  create text hTemp
    assign
      format        = substitute('x(&1)':U, length(cLabel))
      screen-value  = cLabel
      frame         = iophFrame
      width         = font-table:get-text-width-chars(cLabel)
      row           = dHeightDelta + 1
      height        = 1
      col           = 1
      fgcolor       = ( if    ( available bttBufferComparisonField
                            and bttBufferComparisonField.IsVirtual
                            and bttBufferComparisonField.FieldType  = {&K_FIELD_TYPE_VIRTUAL_DB_FIELD} )
                          or ( available b2ttBufferComparisonField
                            and b2ttBufferComparisonField.IsVirtual
                            and b2ttBufferComparisonField.FieldType = {&K_FIELD_TYPE_VIRTUAL_DB_FIELD} ) then
                          {&K_VIRTUAL_DB_FIELD_FGCOLOR}
                        else
                          ? )
      .

  assign
    hTemp:col                 = hField1:col - hTemp:width - 1
    hField1:side-label-handle = hTemp
    .

  create editor hField2
    assign
      name                 = substitute('&1_2':U, bttBufferComparisonField.FieldName)
      frame                = iophFrame
      width                = 76
      height               = (if lEditor then
                                5
                              else
                                1)
      row                  = dHeightDelta + 1
      col                  = dLongestLabel + 5 + 76
      word-wrap            = no
      scrollbar-horizontal = (if lEditor then
                                yes
                              else
                                no)
      scrollbar-vertical   = (if lEditor then
                                yes
                              else
                                no)
      return-inserted      = (if lEditor then
                                yes
                              else
                                no)
      bgcolor              = (if    plAllFields
                                and bttBufferComparisonField.IsEqual = ?
                                and bttBufferComparisonField.BufferNo = 1
                                and not available b2ttBufferComparisonField then
                                {&K_COLOR_LIGHT_GREY}
                              else if plAllFields
                                and bttBufferComparisonField.IsEqual = no then
                                {&K_COLOR_YELLOW}
                              else
                                ?)
      fgcolor              = ( if    available b2ttBufferComparisonField
                                 and b2ttBufferComparisonField.IsVirtual
                                 and b2ttBufferComparisonField.FieldType = {&K_FIELD_TYPE_VIRTUAL_DB_FIELD} then
                                 {&K_VIRTUAL_DB_FIELD_FGCOLOR}
                               else
                                 ? )
      sensitive            = yes
      read-only            = yes
      .


  hField2:screen-value = clFieldValue2.

  if bttBufferComparisonField.IsEqual = no then
  do:

    create button hButton
      assign
        name                 = substitute('btnCompare&1':U, bttBufferComparisonField.FieldName)
        frame                = iophFrame
        width                = 5
        height               = 1
        row                  = dHeightDelta + 1
        col                  = dLongestLabel + 5 + 152
        label                = '>':T
        tooltip              = 'Show first difference':T
        sensitive            =  yes
      triggers:

        on choose
          persistent run qg_QueryWindowBufferComparisonSelectFirstDifference in target-procedure
                           (plCaseSensitive,
                            hField1,
                            hField2).

      end triggers.

    if valid-handle(gchMerge) then
    do:

      create menu hTemp
        assign
          name       = substitute('m_PopupMenu':U)
          popup-only = yes
          sensitive  = yes
          .

      hButton:popup-menu = hTemp.

      create menu-item hTemp
        assign
          name         = 'mi_MergeFields':U
          parent       = hButton:popup-menu
          label        = 'Merge field':T
          sensitive    = yes
        triggers:
          on choose
            persistent run qg_QueryWindowBufferComparisonStartMerge in target-procedure
                             (plAllFields,
                              bttBufferComparisonField.FieldName,
                              bttBufferComparisonField.FieldIndex,
                              plCaseSensitive).
        end triggers
        .

    end.

  end.

  dHeightDelta  = dHeightDelta + (if lEditor then
                                    5
                                  else
                                    1).

end.

end procedure.

PROCEDURE qg_QueryWindowCreateFieldTempTableOverlayEntries :
define input parameter phWindow    as handle    no-undo.
define input parameter pcFieldList as character no-undo.

define buffer bttQueryWindow       for temp-table ttQueryWindow.

define buffer bttFieldOverlay      for temp-table ttFieldOverlay.
define buffer bttQueryWindowField  for temp-table ttQueryWindowField.
define buffer b2ttQueryWindowField for temp-table ttQueryWindowField.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

for each bttFieldOverlay
  where bttFieldOverlay.OwnerHandle = bttQueryWindow.QueryHandle
  on error undo, throw:

  find bttQueryWindowField
    where bttQueryWindowField.WindowHandle = bttQueryWindow.WindowHandle
      and bttQueryWindowField.BufferName   = bttFieldOverlay.BufferName 
      and bttQueryWindowField.FieldName    = bttFieldOverlay.FieldName 
      and bttQueryWindowField.FieldIndex   = bttFieldOverlay.FieldIndex
    no-error. 

  if    not available bttQueryWindowField
     or can-find(ttQueryWindowField
                   where ttQueryWindowField.WindowHandle = bttQueryWindowField.WindowHandle
                     and ttQueryWindowField.BufferId     = bttQueryWindowField.BufferId
                     and ttQueryWindowField.FieldName    = bttQueryWindowField.FieldName
                     and ttQueryWindowField.FieldIndex   = bttQueryWindowField.FieldIndex
                     and ttQueryWindowField.IsOverlay    = yes) then
    next.

  create b2ttQueryWindowField.

  buffer-copy bttQueryWindowField
    to b2ttQueryWindowField
    assign
     b2ttQueryWindowField.DisplayName = substitute({&K_OBJECTID_OVERLAY_LABEL_PATTERN},
                                                   bttQueryWindowField.FieldLabel)
     b2ttQueryWindowField.IsOverlay   = yes
     b2ttQueryWindowField.Order       = (if pcFieldList > '':U then
                                           lookup(substitute({&K_OBJECTID_OVERLAY_NAME_PATTERN},
                                                             qg_cFormattedFieldName(?,
                                                                                    b2ttQueryWindowField.BufferName,
                                                                                    b2ttQueryWindowField.FieldName,
                                                                                    b2ttQueryWindowField.FieldIndex)),
                                                  pcFieldList)
                                         else
                                           1)
     .

  validate b2ttQueryWindowField.

end.

end procedure.

PROCEDURE qg_QueryWindowCreateQueryFrame :
define input parameter phWindow as handle    no-undo.

define variable hTemp                      as handle    no-undo.

define variable hFrame                     as handle    no-undo.

define variable hMenuBar                   as handle    no-undo.
define variable hMenu                      as handle    no-undo.

define variable hCopyObjectIdSubMenu       as handle    no-undo.

define variable hQueryTextEditor           as handle    no-undo.
define variable hFieldSelectionBrowse      as handle    no-undo.
define variable hFieldSelectionBuffer      as handle    no-undo.
define variable hFieldSelectionQuery       as handle    no-undo.
define variable cFieldSelectionQueryText   as character no-undo.
define variable hQueryBrowse               as handle    no-undo.

define variable i                          as integer   no-undo.
define variable hField                     as handle    no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

define buffer bttTable       for temp-table ttTable.
define buffer bttField       for temp-table ttField.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

// Create Menu

create menu hMenuBar.

// File menu
create sub-menu hMenu
  assign
    name      = 'm_File':U
    label     = 'File':T
    sensitive = yes
    parent    = hMenuBar
    .

create menu-item hTemp
  assign
    name        = 'mi_Close':U
    label       = 'Close':T
    accelerator = 'CTRL-W':U
    sensitive   = yes
    parent      = hMenu
  triggers:

    on choose
      persistent run qg_QueryWindowClose in target-procedure
                       (bttQueryWindow.WindowHandle,
                        ?).  

  end triggers.

// Edit menu
create sub-menu hMenu
  assign
    name      = 'm_Edit':U
    label     = 'Edit':T
    sensitive = yes
    parent    = hMenuBar
    .

create menu-item hTemp
  assign
    name         = 'mi_CopyQueryText':U
    parent       = hMenu
    label        = 'Copy query text':T
    sensitive    = yes
  triggers:
    on choose
      persistent run qg_QueryWindowCopyQueryText in target-procedure
                       (bttQueryWindow.WindowHandle).
  end triggers
  .

// Tools menu
create sub-menu hMenu
  assign
    name      = 'm_Tools':U
    label     = 'Tools':T
    sensitive = yes
    parent    = hMenuBar
  triggers:

    on menu-drop
      persistent run qg_QueryWindowQueryToolsMenuDrop in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers.

create menu-item hTemp
  assign
    name        = 'mi_Execute':U
    label       = 'Execute query':T
    accelerator = 'F2':U
    sensitive   = yes
    parent      = hMenu
  triggers:

    on choose
      persistent run qg_QueryWindowExecute in target-procedure
                       (bttQueryWindow.WindowHandle,
                        ?,
                        yes).

  end triggers.

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hMenu
    .

create menu-item hTemp
  assign
    name        = 'mi_OpenRelatedQuery':U
    label       = 'Open related query':T
    accelerator = 'CTRL-R':U
    sensitive   = yes
    parent      = hMenu
  triggers:

    on choose
      persistent run qg_QueryWindowOpenRelatedQuery in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers.

create menu-item hTemp
  assign
    name        = 'mi_ObjectFieldValues':U
    label       = 'Open Object field values':T
    accelerator = 'CTRL-O':U
    sensitive   = yes
    parent      = hMenu
  triggers:

    on choose
      persistent run qg_QueryWindowOpenObjectFieldValues in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers.

create menu-item hTemp
  assign
    name        = 'mi_FindMissingObjectIds':U
    label       = 'Find missing Object IDs':T
    accelerator = 'CTRL-ALT-J':U
    sensitive   = yes
    parent      = hMenu
  triggers:

    on choose
      persistent run qg_QueryWindowFindMissingObjectIds in target-procedure
                       ( bttQueryWindow.WindowHandle ).

  end triggers.

create menu-item hTemp
  assign
    name        = 'mi_FindNextMissingObjectIds':U
    label       = 'Find next missing Object ID':T
    accelerator = 'CTRL-J':U
    sensitive   = yes
    parent      = hMenu
  triggers:

    on choose
      persistent run qg_QueryWindowFindNextMissingObjectId in target-procedure
                       ( bttQueryWindow.WindowHandle ).

  end triggers.

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hMenu
    .

create menu-item hTemp
  assign
    name        = 'mi_OpenRecordWindowFixRowId':U
    label       = 'Open record window (fix / rowid)':T
    accelerator = 'SHIFT-F8':U
    sensitive   = yes
    parent      = hMenu
  triggers:

    on choose
      persistent run qg_QueryWindowOpenRecordWindow in target-procedure
                       (bttQueryWindow.WindowHandle,
                        {&K_QUERY_WINDOW_LINK_MODE_FIX_ROWID}).

  end triggers.

create menu-item hTemp
  assign
    name        = 'mi_OpenRecordWindowFixIndex':U
    label       = 'Open record window (fix / index)':T
    accelerator = 'ALT-SHIFT-F8':U
    sensitive   = yes
    parent      = hMenu
  triggers:

    on choose
      persistent run qg_QueryWindowOpenRecordWindow in target-procedure
                       (bttQueryWindow.WindowHandle,
                        {&K_QUERY_WINDOW_LINK_MODE_FIX_INDEX}).

  end triggers.

create menu-item hTemp
  assign
    name        = 'mi_OpenRecordWindowLinked':U
    label       = 'Open record window (linked)':T
    accelerator = 'CTRL-SHIFT-F8':U
    sensitive   = yes
    parent      = hMenu
  triggers:

    on choose
      persistent run qg_QueryWindowOpenRecordWindow in target-procedure
                       (bttQueryWindow.WindowHandle,
                        {&K_QUERY_WINDOW_LINK_MODE_LINKED}).

  end triggers.

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hMenu
    .

create menu-item hTemp
  assign
    name         = 'mi_ShowQueryText':U
    parent       = hMenu
    label        = 'Show query text':T
    sensitive    = yes
  triggers:

    on choose
      persistent run qg_QueryWindowShowQueryText in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers
  .

create menu-item hTemp
  assign
    name         = 'mi_ExecCurrentQueryText':U
    parent       = hMenu
    label        = 'Execute query text':T
    sensitive    = yes
  triggers:

    on choose
      persistent run qg_QueryWindowExecCurrentQuery in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers
  .

create menu-item hTemp
  assign
    name         = 'mi_ShowIndexInformation':U
    parent       = hMenu
    label        = 'Show index information':T
    sensitive    = yes
  triggers:

    on choose
      persistent run qg_QueryWindowShowIndexInformation in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers
  .

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hMenu
    .

create menu-item hTemp
  assign
    name        = 'mi_AddSnapshot':U
    label       = 'Add snapshot':T
    accelerator = 'F10':U
    sensitive   = yes
    parent      = hMenu
  triggers:

    on choose
      persistent run qg_QueryWindowAddSnapshot in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers.

// Options menu
create sub-menu hMenu
  assign
    name      = 'm_Options':U
    label     = 'Options':T
    sensitive = yes
    parent    = hMenuBar
    .

create menu-item hTemp
  assign
    name        = 'mi_SelectQueryBuffers':U
    label       = 'Query buffers':T
    accelerator = 'CTRL-B':U
    sensitive   = yes
    parent      = hMenu
  triggers:

    on choose
      persistent run qg_QueryWindowEditQueryBuffers in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers.

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hMenu
    .

create menu-item hTemp
  assign
    name       = 'mi_ObjectIdOveray':U
    label      = 'Object id overlay':T
    sensitive  = yes
    parent     = hMenu
  triggers:

    on choose
      persistent run qg_QueryWindowObjectIdOverlay in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers.

create menu-item hTemp
  assign
    name       = 'mi_DeepResolveObjectIds':U
    label      = 'Deep resolve object ids':T
    toggle-box = yes
    sensitive  = yes
    parent     = hMenu
  triggers:

    on value-changed
      persistent run qg_QueryWindowToggleDeepResolve in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers.

// View menu
create sub-menu hMenu
  assign
    name      = 'm_View':U
    label     = 'View':T
    sensitive = yes
    parent    = hMenuBar
  triggers:

    on menu-drop
      persistent run qg_QueryWindowViewMenuDrop in target-procedure
                       (bttQueryWindow.WindowHandle).


  end triggers.

create menu-item hTemp
  assign
    name       = 'mi_FieldList':U
    label      = 'Field list':T
    toggle-box = yes
    sensitive  = yes
    parent     = hMenu
  triggers:

    on value-changed
      persistent run qg_QueryWindowToggleFieldList in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers.

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hMenu
    .

create menu-item hTemp
  assign
    name       = 'mi_RawValues':U
    label      = 'Raw Values':T
    toggle-box = yes
    sensitive  = yes
    parent     = hMenu
  triggers:

    on value-changed
      persistent run qg_QueryWindowToggleRawValues in target-procedure
                       ( bttQueryWindow.WindowHandle ).

  end triggers.

create sub-menu hMenu
  assign
    name      = 'm_Window':U
    label     = 'Window':T
    sensitive = yes
    parent    = hMenuBar
  triggers:

    on menu-drop
      persistent run qg_QueryWindowWindowMenuDrop in target-procedure
                       (bttQueryWindow.WindowHandle).


  end triggers.

create menu-item hTemp
  assign
    name        = 'mi_RecordMode':U
    label       = 'Switch to record mode':T
    toggle-box  = no
    accelerator = 'F8':U
    sensitive   = yes
    parent      = hMenu
  triggers:

    on choose
      persistent run qg_QueryWindowSetWindowMode in target-procedure
                       (bttQueryWindow.WindowHandle,
                        {&K_QUERY_WINDOW_MODE_RECORD},
                        ?,
                        ?).

  end triggers.

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hMenu
    .

create menu-item hTemp
  assign
    name      = 'mi_WindowSizeDefault':U
    label     = 'Restore default window size':T
    sensitive = yes
    parent    = hMenu
  triggers:

    on choose
      persistent run qg_QueryWindowSetSize in target-procedure
                       (bttQueryWindow.WindowHandle,
                        {&K_QUERY_SIZE_MODE_DEFAULT}).

  end triggers.

run qg_AddHelpMenu(hMenuBar).

// Create Frame

create frame hFrame
  assign
    name           = 'fQuery':U
    box            = no
    three-d        = yes
    width          = 235
    virtual-width  = 235
    height         = 32
    virtual-height = 32
    sensitive      = yes
    parent         = bttQueryWindow.WindowHandle
  triggers:

    on f3 anywhere /* Show all */
      persistent run qg_QueryWindowShowAll in target-procedure
                       (bttQueryWindow.WindowHandle).

    on f4 anywhere /* Show index */
      persistent run qg_QueryWindowShowIndex in target-procedure
                       (bttQueryWindow.WindowHandle).

    on f5 anywhere /* Recent queries */
      persistent run qg_QueryWindowRecentQueries in target-procedure
                       (bttQueryWindow.WindowHandle).

    on shift-f2 anywhere /* Set focus to query text editor */
      persistent run qg_QueryWindowSetFocus in target-procedure
                       (bttQueryWindow.WindowHandle,
                        'cQueryText':U).

    on shift-f8 anywhere /* Toggle field list */
      persistent run qg_QueryWindowToggleFieldList in target-procedure
                       (bttQueryWindow.WindowHandle).

    on shift-f4 anywhere /* Set focus to query browse */
      persistent run qg_QueryWindowSetFocus in target-procedure
                       (bttQueryWindow.WindowHandle,
                        'brQuery':U).

    on ctrl-n anywhere
      persistent run qg_QueryWindowEdit in target-procedure
                       (bttQueryWindow.WindowHandle,
                        {&K_EDITACTION_CREATE}).

    on ctrl-p anywhere
      persistent run qg_QueryWindowEdit in target-procedure 
                       (bttQueryWindow.WindowHandle,
                        {&K_EDITACTION_DUPLICATE}).

    on ctrl-d anywhere
      persistent run qg_QueryWindowDelete in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers
  .

bttQueryWindow.QueryFrameHandle = hFrame.

// Create Query text Editor
create editor hQueryTextEditor
  assign
    name                 = 'cQueryText':U
    frame                = hFrame
    width                = 162
    height               = 6
    row                  = 1
    col                  = 1
    word-wrap            = no
    font                 = 0
    large                = yes
    return-inserted      = yes
    auto-indent          = yes
    scrollbar-horizontal = yes
    scrollbar-vertical   = yes
    read-only            = (bttQueryWindow.ObjSourceQuerySeq > 0)
    sensitive            = yes
  triggers:

    on ctrl-d
      persistent run qg_QueryWindowQueryTextEditorDeleteLines in target-procedure
                       (bttQueryWindow.WindowHandle).

    on alt-up
      persistent run qg_QueryWindowQueryTextEditorMoveLines in target-procedure
                       (bttQueryWindow.WindowHandle,
                        no).

    on alt-down
      persistent run qg_QueryWindowQueryTextEditorMoveLines in target-procedure
                       (bttQueryWindow.WindowHandle,
                        yes).

    on ctrl-alt-cursor-up
      persistent run qg_QueryWindowQueryTextEditorDuplicateLines in target-procedure
                       (bttQueryWindow.WindowHandle,
                        no).

    on ctrl-alt-cursor-down
      persistent run qg_QueryWindowQueryTextEditorDuplicateLines in target-procedure
                       (bttQueryWindow.WindowHandle,
                        yes).

    on ctrl-ins
      persistent run qg_QueryWindowInsertExternalReference in target-procedure
                       (bttQueryWindow.WindowHandle,
                        hQueryTextEditor,
                        yes).

    on ctrl-shift-ins
      persistent run qg_QueryWindowInsertExternalReference in target-procedure
                       (bttQueryWindow.WindowHandle,
                        hQueryTextEditor,
                        no).

    on tab
      persistent run qg_QueryWindowSelectNextCondition in target-procedure
                       (bttQueryWindow.WindowHandle,
                        yes).

    on shift-tab
      persistent run qg_QueryWindowSelectNextCondition in target-procedure
                       (bttQueryWindow.WindowHandle,
                        no).

    on ctrl-enter
      persistent run qg_QueryWindowSelectNextCondition in target-procedure
                       (bttQueryWindow.WindowHandle,
                        ?).

    on mouse-extend-click
      persistent run qg_QueryWindowSelectNextCondition in target-procedure
                       (bttQueryWindow.WindowHandle,
                        ?).

    on ctrl-tab
      persistent run qg_QueryWindowSetFocus in target-procedure
                       (bttQueryWindow.WindowHandle,
                        'brFieldSelection':U).

    // TODO: Anderer Shortcut
    //on ctrl-i
    //persistent run qg_QueryWindowBeautify in target-procedure
    //                 (bttQueryWindow.WindowHandle).
  end triggers
  .

// Create field selection browse.
create buffer hFieldSelectionBuffer for table 'ttQueryWindowField':U. /* code checked by mth 30.07.2015 */

create query hFieldSelectionQuery.
hFieldSelectionQuery:set-buffers(hFieldSelectionBuffer).

create browse hFieldSelectionBrowse
  assign
    name                   = 'brFieldSelection':U
    frame                  = hFrame
    width                  = 50
    height                 = 6
    row                    = 1
    col                    = 183
    read-only              = yes
    row-markers            = no
    allow-column-searching = no
    multiple               = yes
    fit-last-column        = yes
  triggers:

    on default-action
      persistent run qg_QueryWindowFieldSelectionBrowseDefaultAction in target-procedure
                       (bttQueryWindow.WindowHandle).

    on ctrl-ins
      persistent run qg_QueryWindowQueryTextEditorAddCondition in target-procedure
                       (bttQueryWindow.WindowHandle).

    on ctrl-home
      persistent run qg_QueryWindowMoveColumn in target-procedure
                       (bttQueryWindow.WindowHandle,
                        yes).

    on ctrl-end
      persistent run qg_QueryWindowMoveColumn in target-procedure
                       (bttQueryWindow.WindowHandle,
                        no).

    on ctrl-page-up
      persistent run qg_QueryWindowAddSortOption in target-procedure
                       (bttQueryWindow.WindowHandle,
                        no).

    on ctrl-page-down
      persistent run qg_QueryWindowAddSortOption in target-procedure
                       (bttQueryWindow.WindowHandle,
                        yes).

    on row-display
      persistent run qg_QueryWindowQueryFieldBrowseRowDisplay in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers
  .

// Create field selection browse toggle button.
create button hTemp
  assign
    name                 = 'btnToggleFieldBrowse':U
    frame                = hFrame
    width                = 3
    height               = 6
    row                  = 1
    col                  = 163
    label                = '>':T
    tooltip              = 'Hide field List':T
    flat-button          = yes
    sensitive            = yes
  triggers:

    on choose
      persistent run qg_QueryWindowToggleFieldList in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers
  .

if gcCursorHand > '':U then
  hTemp:load-mouse-pointer(gcCursorHand).

// Create Buttons.
create button hTemp
  assign
    name                 = 'btnExecute':U
    frame                = hFrame
    width                = 20
    height               = 2
    row                  = 1
    col                  = 215
    label                = 'Execute':T
    tooltip              = 'Execute current query and refresh browse (F2)':T
    sensitive            = yes
  triggers:

    on choose
      persistent run qg_QueryWindowExecute in target-procedure
                       (bttQueryWindow.WindowHandle,
                        ?,
                        yes).

  end triggers.

create button hTemp
  assign
    name      = 'btnEdit':U
    frame     = hFrame
    width     = 20
    height    = 1
    row       = 3
    col       = 215
    &IF {&K_EDITMODE_ENABLED} &THEN
      label   = 'Edit Record':T
      tooltip = 'Edit currently selected record.':T
    &ELSE
      label   = 'Record':T
      tooltip = 'Show record details for currently selected record':T
    &ENDIF
    sensitive = yes
  triggers:

    on choose
      persistent run qg_QueryWindowEdit in target-procedure
                       (bttQueryWindow.WindowHandle,
                        {&K_EDITACTION_EDIT}).

  end triggers
  .

&IF {&K_EDITMODE_ENABLED} &THEN

  create button hTemp
    assign
      name      = 'btnDelete':U
      frame     = hFrame
      width     = 20
      height    = 1
      row       = 4
      col       = 215
      label     = 'Delete Record':T
      tooltip   = 'Delete currently selected record (CTRL+D)':T
      sensitive = yes
    triggers:

      on choose
        persistent run qg_QueryWindowDelete in target-procedure
                         (bttQueryWindow.WindowHandle).

    end triggers
    .

  create button hTemp
    assign
      name      = 'btnCreate':U
      frame     = hFrame
      width     = 20
      height    = 1
      row       = 5
      col       = 215
      label     = 'Create Record':T
      tooltip   = 'Create new record (CTRL-N)':T
      sensitive = yes
    triggers:

      on choose
        persistent run qg_QueryWindowEdit in target-procedure
                         (bttQueryWindow.WindowHandle,
                          {&K_EDITACTION_CREATE}).

    end triggers
    .

  create button hTemp
    assign
      name      = 'btnDuplicate':U
      frame     = hFrame
      width     = 20
      height    = 1
      row       = 6
      col       = 215
      label     = 'Duplicate Record':T
      tooltip   = 'Create new record by duplicating currently selected record (CTRL-P)':T
      sensitive = yes
    triggers:

      on choose
        persistent run qg_QueryWindowEdit in target-procedure 
                         (bttQueryWindow.WindowHandle,
                          {&K_EDITACTION_DUPLICATE}).

    end triggers
    .

&ENDIF

// Create Splitter button.
create button hTemp
  assign
    name        = 'btnSplitter1':U
    frame       = hFrame
    width       = 10
    height      = 0.25
    row         = 7
    col         = 1
    label       = '':U
    no-focus    = yes
    flat-button = yes
    movable     = yes
    sensitive   = yes
  triggers:

    on end-move
      persistent run qg_QueryWindowResize in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers
  .

hTemp:load-mouse-pointer ('SIZE-N':U).

// Create query browse.
create browse hQueryBrowse
  assign
    name                 = 'brQuery':U
    frame                = hFrame
    width                = 10
    height               = 10
    row                  = 7.25
    col                  = 1
    read-only            = yes
    row-markers          = no
    allow-column-searching = yes
  triggers:

    on value-changed
      persistent run qg_QueryWindowUpdateAll in target-procedure
                       ('':U).

    on row-display
      persistent run qg_QueryWindowQueryBrowseRowDisplay in target-procedure
                       (bttQueryWindow.WindowHandle).

    on default-action
      persistent run qg_QueryWindowQueryBrowseDefaultAction in target-procedure
                       (bttQueryWindow.WindowHandle).

    on mouse-select-click
      persistent run qg_QueryWindowQueryBrowseSelectColumn in target-procedure
                       (bttQueryWindow.WindowHandle).

    on mouse-menu-down
      persistent run qg_QueryWindowQueryBrowseSelectColumn in target-procedure
                       (bttQueryWindow.WindowHandle).

    on start-search
      persistent run qg_QueryWindowQueryBrowseStartSearch in target-procedure
                       (bttQueryWindow.WindowHandle).

    on mouse-select-dblclick
      persistent run qg_QueryWindowQueryBrowseStartSearch in target-procedure
                       (bttQueryWindow.WindowHandle).

    on mouse-extend-dblclick
      persistent run qg_QueryWindowQueryBrowseStartSearch in target-procedure
                       (bttQueryWindow.WindowHandle).

    on ctrl-c
      persistent run qg_QueryWindowQueryBrowseCopy in target-procedure
                           (bttQueryWindow.WindowHandle).

    on ' ':U
      persistent run qg_QueryWindowEdit in target-procedure
                       (bttQueryWindow.WindowHandle,
                        {&K_EDITACTION_EDIT}).

  end triggers.

// Create query text editor popup menu.
if bttQueryWindow.ObjSourceQuerySeq = 0 then
do:

  create menu hTemp
    assign
      name       = 'm_QueryTextPopupMenu':U
      popup-only = yes
      sensitive  = yes
    triggers:

      on menu-drop
        persistent run qg_QueryWindowQueryTextEditorPopupMenuDrop in target-procedure
                         (bttQueryWindow.WindowHandle).

    end triggers.

  hQueryTextEditor:popup-menu = hTemp.

  create menu-item hTemp
    assign
      name         = 'mi_ShowAll':U
      parent       = hQueryTextEditor:popup-menu
      label        = 'Show all':T
      sensitive    = yes
    triggers:

      on choose
        persistent run qg_QueryWindowShowAll in target-procedure
                         (bttQueryWindow.WindowHandle).

    end triggers
    .

  create menu-item hTemp
    assign
      name      = 'm_ShowIndex':U
      parent    = hQueryTextEditor:popup-menu
      label     = 'Show index':T
      sensitive = yes
    triggers:

      on choose
        persistent run qg_QueryWindowShowIndex in target-procedure
                         (bttQueryWindow.WindowHandle).

    end triggers.

  create menu-item hTemp
    assign
      name      = 'm_SortByIndex':U
      parent    = hQueryTextEditor:popup-menu
      label     = 'Sort by Index':T
      sensitive = yes
    triggers:

      on choose
        persistent run qg_QueryWindowSortByIndex in target-procedure
                         (bttQueryWindow.WindowHandle).

    end triggers.

  create menu-item hTemp
    assign
      subtype = 'RULE':U
      parent  = hQueryTextEditor:popup-menu
      .

  create menu-item hTemp
    assign
      name         = 'mi_InsertExternalFieldReference':U
      parent       = hQueryTextEditor:popup-menu
      label        = 'Insert external field reference':T
      sensitive    = yes
    triggers:

      on choose
        persistent run qg_QueryWindowInsertExternalReference in target-procedure
                         (bttQueryWindow.WindowHandle,
                          hQueryTextEditor,
                          yes).

    end triggers
    .

  create menu-item hTemp
    assign
      name         = 'mi_InsertExternalTableReference':U
      parent       = hQueryTextEditor:popup-menu
      label        = 'Insert external table reference':T
      sensitive    = yes
    triggers:

      on choose
        persistent run qg_QueryWindowInsertExternalReference in target-procedure
                         (bttQueryWindow.WindowHandle,
                          hQueryTextEditor,
                          no).

    end triggers
    .

  create menu-item hTemp
    assign
      subtype = 'RULE':U
      parent  = hQueryTextEditor:popup-menu
      .

  create menu-item hTemp
    assign
      name         = 'mi_Equal':U
      parent       = hQueryTextEditor:popup-menu
      label        = '= (eqal)':T
      sensitive    = yes
    triggers:

      on choose
        persistent run qg_QueryWindowSetComparator in target-procedure
                         (bttQueryWindow.WindowHandle,
                          '=':U).

    end triggers
    .

  create menu-item hTemp
    assign
      name         = 'mi_NotEqual':U
      parent       = hQueryTextEditor:popup-menu
      label        = '<> (not equal)':T
      sensitive    = yes
    triggers:

      on choose
        persistent run qg_QueryWindowSetComparator in target-procedure
                         (bttQueryWindow.WindowHandle,
                          '<>':U).

    end triggers
    .

  create menu-item hTemp
    assign
      name         = 'mi_Greater':U
      parent       = hQueryTextEditor:popup-menu
      label        = '> (greater than)':T
      sensitive    = yes
    triggers:

      on choose
        persistent run qg_QueryWindowSetComparator in target-procedure
                         (bttQueryWindow.WindowHandle,
                          '>':U).

    end triggers
    .

  create menu-item hTemp
    assign
      name         = 'mi_GreaterEqual':U
      parent       = hQueryTextEditor:popup-menu
      label        = '>= (greater or equal)':T
      sensitive    = yes
    triggers:

      on choose
        persistent run qg_QueryWindowSetComparator in target-procedure
                         (bttQueryWindow.WindowHandle,
                          '>=':U).

    end triggers
    .

  create menu-item hTemp
    assign
      name         = 'mi_Lower':U
      parent       = hQueryTextEditor:popup-menu
      label        = '< (lower than)':T
      sensitive    = yes
    triggers:

      on choose
        persistent run qg_QueryWindowSetComparator in target-procedure
                         (bttQueryWindow.WindowHandle,
                          '<':U).

    end triggers
    .

  create menu-item hTemp
    assign
      name         = 'mi_LowerEqual':U
      parent       = hQueryTextEditor:popup-menu
      label        = '<= (lower or queal)':T
      sensitive    = yes
    triggers:

      on choose
        persistent run qg_QueryWindowSetComparator in target-procedure
                         (bttQueryWindow.WindowHandle,
                          '<=':U).

    end triggers
    .

  create menu-item hTemp
    assign
      name         = 'mi_Begins':U
      parent       = hQueryTextEditor:popup-menu
      label        = 'begins':T
      sensitive    = yes
    triggers:

      on choose
        persistent run qg_QueryWindowSetComparator in target-procedure
                         (bttQueryWindow.WindowHandle,
                          'begins':U).

    end triggers
    .

  create menu-item hTemp
    assign
      name         = 'mi_Matches':U
      parent       = hQueryTextEditor:popup-menu
      label        = 'matches':T
      sensitive    = yes
    triggers:

      on choose
        persistent run qg_QueryWindowSetComparator in target-procedure
                         (bttQueryWindow.WindowHandle,
                          'matches':U).

    end triggers
    .

  create menu-item hTemp
    assign
      name         = 'mi_Contains':U
      parent       = hQueryTextEditor:popup-menu
      label        = 'contains':T
      sensitive    = yes
    triggers:

      on choose
        persistent run qg_QueryWindowSetComparator in target-procedure
                         (bttQueryWindow.WindowHandle,
                          'contains':U).

    end triggers
    .

  create menu-item hTemp
    assign
      subtype = 'RULE':U
      parent  = hQueryTextEditor:popup-menu
      .

  create menu-item hTemp
    assign
      name        = 'mi_BeautifyQueryText':U
      parent      = hQueryTextEditor:popup-menu
      label       = 'Beautify query text':T
      sensitive   = yes
    triggers:

      on choose persistent run qg_QueryWindowBeautify in target-procedure
                                 (bttQueryWindow.WindowHandle).

    end triggers
    .

  create menu-item hTemp
    assign
      subtype = 'RULE':U
      parent  = hQueryTextEditor:popup-menu
      .

  create menu-item hTemp
    assign
      name        = 'mi_RecentQueries':U
      parent      = hQueryTextEditor:popup-menu
      label       = 'Recent queries':T
      sensitive   = yes
    triggers:

      on choose persistent run qg_QueryWindowRecentQueries in target-procedure
                                 (bttQueryWindow.WindowHandle).

    end triggers
    .

end.

// Create field selection browse popup menu.
create menu hTemp
  assign
    name       = 'm_PopupMenu':U
    popup-only = yes
    sensitive  = yes
    .

hFieldSelectionBrowse:popup-menu = hTemp.

create menu-item hTemp
  assign
    name         = 'mi_MoveToFirstColumn':U
    parent       = hFieldSelectionBrowse:popup-menu
    label        = 'Move to first column':T
    sensitive    = yes
  triggers:

    on choose
      persistent run qg_QueryWindowMoveColumn in target-procedure
                       (bttQueryWindow.WindowHandle,
                        yes).

  end triggers
  .

create menu-item hTemp
  assign
    name         = 'mi_MoveToLastColumn':U
    parent       = hFieldSelectionBrowse:popup-menu
    label        = 'Move to last column':T
    sensitive    = yes
  triggers:

    on choose
      persistent run qg_QueryWindowMoveColumn in target-procedure
                       (bttQueryWindow.WindowHandle,
                        no).

  end triggers
  .

if bttQueryWindow.ObjSourceQuerySeq = 0 then
do:

  create menu-item hTemp
    assign
      subtype = 'RULE':U
      parent  = hFieldSelectionBrowse:popup-menu
      .

  create menu-item hTemp
    assign
      name         = 'mi_AddCondition':U
      parent       = hFieldSelectionBrowse:popup-menu
      label        = 'Add condition':T
      sensitive    = yes
    triggers:

      on choose
        persistent run qg_QueryWindowQueryTextEditorAddCondition in target-procedure
                         (bttQueryWindow.WindowHandle).

    end triggers
    .

  create menu-item hTemp
    assign
      name         = 'mi_AddSortPhrase':U
      parent       = hFieldSelectionBrowse:popup-menu
      label        = 'Add sort option':T
      sensitive    = yes
    triggers:

      on choose
        persistent run qg_QueryWindowAddSortOption in target-procedure
                         (bttQueryWindow.WindowHandle,
                          no).

    end triggers
    .

  create menu-item hTemp
    assign
      name         = 'mi_AddSortPhrase':U
      parent       = hFieldSelectionBrowse:popup-menu
      label        = 'Add sort option (descending)':T
      sensitive    = yes
    triggers:

      on choose
        persistent run qg_QueryWindowAddSortOption in target-procedure
                         (bttQueryWindow.WindowHandle,
                          yes).

    end triggers
    .

end.

run qg_InitBrowse(hFieldSelectionBrowse).

// Create query browse popup menu.
create menu hTemp
  assign
    name       = 'm_PopupMenu':U
    popup-only = yes
    sensitive  = yes
  triggers:

    on menu-drop
      persistent run qg_QueryWindowQueryBrowsePopupMenuDrop in target-procedure
                      (bttQueryWindow.WindowHandle).

  end triggers.

hQueryBrowse:popup-menu = hTemp.

create menu-item hTemp
  assign
    name         = 'mi_CopySelectedColumnValueRaw':U
    parent       = hQueryBrowse:popup-menu
    label        = 'Copy raw value':T
    sensitive    = yes
  triggers:

    on choose
      persistent run qg_QueryWindowQueryBrowseCopySelectedColumnValue in target-procedure
                       ( bttQueryWindow.WindowHandle,
                         yes ).

  end triggers
  .

create menu-item hTemp
  assign
    name         = 'mi_CopySelectedColumnValueFormatted':U
    parent       = hQueryBrowse:popup-menu
    label        = 'Copy formatted value':T
    sensitive    = yes
  triggers:

    on choose
      persistent run qg_QueryWindowQueryBrowseCopySelectedColumnValue in target-procedure
                       ( bttQueryWindow.WindowHandle,
                         no ).

  end triggers
  .

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hQueryBrowse:popup-menu
    .

create menu-item hTemp
  assign
    name         = 'mi_CopyRecordValuesRaw':U
    parent       = hQueryBrowse:popup-menu
    label        = 'Copy record values':T
    sensitive    = yes
  triggers:

    on choose
      persistent run qg_QueryWindowCopyRecordValues in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers
  .

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hQueryBrowse:popup-menu
    .

create menu-item hTemp
  assign
    name         = 'mi_CopyRecid':U
    parent       = hQueryBrowse:popup-menu
    label        = 'Copy recid':T
    sensitive    = yes
  triggers:

    on choose
      persistent run qg_QueryWindowCopyRecid in target-procedure
                       (bttQueryWindow.WindowHandle,
                        yes).

  end triggers
  .

create menu-item hTemp
  assign
    name         = 'mi_CopyRowid':U
    parent       = hQueryBrowse:popup-menu
    label        = 'Copy rowid':T
    sensitive    = yes
  triggers:

    on choose
      persistent run qg_QueryWindowCopyRecid in target-procedure
                       (bttQueryWindow.WindowHandle,
                        no).

  end triggers
  .

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hQueryBrowse:popup-menu
    .

create menu-item hTemp
  assign
    name         = 'mi_CalculateSum':U
    parent       = hQueryBrowse:popup-menu
    label        = 'Calculate Sum':T
    sensitive    = yes
  triggers:

    on choose
      persistent run qg_QueryWindowCalculateSum in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers
  .

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hQueryBrowse:popup-menu
    .

create menu-item hTemp
  assign
    name         = 'mi_SelectForComparison1':U
    parent       = hQueryBrowse:popup-menu
    label        = 'Select for comparison 1':T
    sensitive    = yes
  triggers:

    on choose
      persistent run qg_QueryWindowSelectForComparison in target-procedure
                       (bttQueryWindow.WindowHandle,
                        1).

  end triggers
  .

create menu-item hTemp
  assign
    name         = 'mi_SelectForComparison2':U
    parent       = hQueryBrowse:popup-menu
    label        = 'Select for comparison 2':T
    sensitive    = yes
  triggers:

    on choose
      persistent run qg_QueryWindowSelectForComparison in target-procedure
                       (bttQueryWindow.WindowHandle,
                        2).

  end triggers
  .

create menu-item hTemp
  assign
    name         = 'mi_CompareSelectedRecords':U
    parent       = hQueryBrowse:popup-menu
    label        = 'Compare selected records':T
    sensitive    = yes
  triggers:

    on choose
      persistent run qg_QueryWindowCompareSelectedRecords in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers
  .

run qg_InitBrowse(hQueryBrowse).

hQueryBrowse:column-movable = no.

hQueryBrowse:query = bttQueryWindow.QueryHandle.

assign
  bttQueryWindow.QueryFrameHandle                      = hFrame
  bttQueryWindow.QueryMenuHandle                       = hMenuBar
  bttQueryWindow.QueryTextEditorHandle                 = hQueryTextEditor
  bttQueryWindow.QueryFieldBrowseHandle                = hFieldSelectionBrowse
  bttQueryWindow.QueryFieldBrowseBufferHandle          = hFieldSelectionBuffer
  bttQueryWindow.QueryBrowseHandle                     = hQueryBrowse
  hFieldSelectionBrowse:query                          = hFieldSelectionQuery
  bttQueryWindow.QueryFieldBrowseColHandles[1]         = hFieldSelectionBrowse:add-like-column('ttQueryWindowField.FieldName':U)
  bttQueryWindow.QueryFieldBrowseColHandles[1]:visible = no
  bttQueryWindow.QueryFieldBrowseColHandles[2]         = hFieldSelectionBrowse:add-like-column('ttQueryWindowField.DisplayName':U)
  bttQueryWindow.QueryFieldBrowseColHandles[2]:width   = 32
  bttQueryWindow.QueryFieldBrowseColHandles[3]         = hFieldSelectionBrowse:add-like-column('ttQueryWindowField.IsVirtual':U)
  bttQueryWindow.QueryFieldBrowseColHandles[4]         = hFieldSelectionBrowse:add-like-column('ttQueryWindowField.DataType':U)
  hFieldSelectionBrowse:labels                         = no
  .

validate bttQueryWindow.

end procedure.

PROCEDURE qg_QueryWindowCreateRecordFrame :
define input parameter phWindow as handle    no-undo.

define variable hMenuBar         as handle    no-undo.
define variable hMenu            as handle    no-undo.

define variable hFrame           as handle    no-undo.
define variable hBrowse          as handle    no-undo.
define variable hBuffer          as handle    no-undo.
define variable hQuery           as handle    no-undo.

define variable hTemp            as handle    no-undo.

define variable iIndex           as integer   no-undo.

define variable cIconDown        as character no-undo.
define variable cIconFirst       as character no-undo.
define variable cIconPrev        as character no-undo.
define variable cIconRefresh     as character no-undo.
define variable cIconNext        as character no-undo.
define variable cIconLast        as character no-undo.
define variable cIconPreferences as character no-undo.

define buffer bttQueryWindow      for temp-table ttQueryWindow.

define buffer bttQueryWindowField for temp-table ttQueryWindowField.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

// Create Menu

cIconDown = search('bmp/icon_down.bmp':U).

if cIconDown = ? then
  cIconDown = search('bmp/btndown.bmp':U).

cIconRefresh = search('bmp/icon_refresh.bmp':U).

if cIconRefresh = ? then
  cIconRefresh = search('bmp/btnrefru.bmp':U).

cIconFirst = search('bmp/icon_first.bmp':U).

if cIconFirst = ? then
  cIconFirst = search('bmp/btnfirsu.bmp':U).

cIconPrev = search('bmp/icon_prev.bmp':U).

if cIconPrev = ? then
  cIconPrev = search('bmp/btnprevu.bmp':U).

cIconNext = search('bmp/icon_next.bmp':U).

if cIconNext = ? then
  cIconNext = search('bmp/btnnextu.bmp':U).

cIconLast = search('bmp/icon_last.bmp':U).

if cIconLast = ? then
  cIconLast = search('bmp/btnlastu.bmp':U).

cIconPreferences = search('bmp/icon_preferences.bmp':U).

create menu hMenuBar.

create sub-menu hMenu
  assign
    name      = 'm_File':U
    label     = 'File':T
    sensitive = yes
    parent    = hMenuBar
    .

create menu-item hTemp
  assign
    name        = 'mi_Close':U
    label       = 'Close':T
    accelerator = 'CTRL-W':U
    sensitive   = yes
    parent      = hMenu
  triggers:

    on choose
      persistent run qg_QueryWindowClose in target-procedure
                       (bttQueryWindow.WindowHandle,
                        ?).  

  end triggers.

create sub-menu hMenu
  assign
    name      = 'm_Edit':U
    label     = 'Edit':T
    sensitive = yes
    parent    = hMenuBar
    .

create menu-item hTemp
  assign
    name        = 'mi_CopyValue':U
    label       = 'Copy value':T
    sensitive   = yes
    parent      = hMenu
  triggers:

    on choose
      persistent run qg_QueryWindowRecordCopyValue in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers
  .

create sub-menu hMenu
  assign
    name      = 'm_Tools':U
    label     = 'Tools':T
    sensitive = yes
    parent    = hMenuBar
    .

create menu-item hTemp
  assign
    name        = 'mi_Refresh':U
    label       = 'Refresh':T
    accelerator = 'F5':U
    sensitive   = yes
    parent      = hMenu
  triggers:

    on choose
      persistent run qg_QueryWindowRecordRefresh in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers.

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hMenu
    .

create menu-item hTemp
  assign
    name        = 'mi_OpenRelatedQuery':U
    label       = 'Open related query':T
    accelerator = 'CTRL-R':U
    sensitive   = yes
    parent      = hMenu
  triggers:

    on choose
      persistent run qg_QueryWindowOpenRelatedQuery in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers.

create menu-item hTemp
  assign
    name        = 'mi_ObjectFieldValues':U
    label       = 'Open Object field values':T
    accelerator = 'CTRL-O':U
    sensitive   = yes
    parent      = hMenu
  triggers:

    on choose
      persistent run qg_QueryWindowOpenObjectFieldValues in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers.

// Options menu
create sub-menu hMenu
  assign
    name      = 'm_Options':U
    label     = 'Options':T
    sensitive = yes
    parent    = hMenuBar
    .

create menu-item hTemp
  assign
    name       = 'mi_ObjectIdOveray':U
    label      = 'Object id overlay':T
    sensitive  = yes
    parent     = hMenu
  triggers:

    on choose
      persistent run qg_QueryWindowObjectIdOverlay in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers.

create menu-item hTemp
  assign
    name       = 'mi_DeepResolveObjectIds':U
    label      = 'Deep resolve object ids':T
    toggle-box = yes
    sensitive  = yes
    parent     = hMenu
  triggers:

    on value-changed
      persistent run qg_QueryWindowToggleDeepResolve in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers.

create sub-menu hMenu
  assign
    name      = 'm_View':U
    label     = 'View':T
    sensitive = yes
    parent    = hMenuBar
  triggers:

    on menu-drop
      persistent run qg_QueryWindowRecordViewMenuDrop in target-procedure
                      (bttQueryWindow.WindowHandle).

  end triggers
  .

create menu-item hTemp
  assign
    name       = 'mi_RawValues':U
    label      = 'Raw values':T
    toggle-box = yes
    sensitive  = yes
    parent     = hMenu
  triggers:

    on value-changed
      persistent run qg_QueryWindowToggleRawValues in target-procedure
                      ( bttQueryWindow.WindowHandle ).

  end triggers.

create sub-menu hMenu
  assign
    name      = 'm_Window':U
    label     = 'Window':T
    sensitive = yes
    parent    = hMenuBar
    .

create menu-item hTemp
  assign
    name        = 'mi_QueryMode':U
    label       = 'Switch to query mode':T
    accelerator = 'F8':U
    sensitive   = yes
    parent      = hMenu
  triggers:

    on choose
      persistent run qg_QueryWindowSetWindowMode in target-procedure
                       (bttQueryWindow.WindowHandle,
                        {&K_QUERY_WINDOW_MODE_QUERY},
                        ?,
                        ?).

  end triggers.

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hMenu
    .

create menu-item hTemp
  assign
    name      = 'mi_WindowSizeDefault':U
    label     = 'Restore default window size':T
    sensitive = yes
    parent    = hMenu
  triggers:
    on choose
      persistent run qg_QueryWindowSetSize in target-procedure
                       (bttQueryWindow.WindowHandle,
                        {&K_RECORD_SIZE_MODE_DEFAULT}).
  end triggers.


run qg_AddHelpMenu(hMenuBar).

// Create Frame

create frame hFrame
  assign
    name           = 'fQuery':U
    box            = no
    three-d        = yes
    width          = 235
    virtual-width  = 235
    height         = 32
    virtual-height = 32
    sensitive      = yes
    parent         = bttQueryWindow.WindowHandle
  triggers:

    on ctrl-f7 anywhere /* Show query window */
      persistent run qg_OpenQueryWindowListWindow in target-procedure.

  end triggers.

create browse hBrowse
  assign
    name                   = 'brRecord':U
    frame                  = hFrame
    width                  = 91
    height                 = 18.44
    row                    = 3
    col                    = 1
    read-only              = yes
    row-markers            = no
    allow-column-searching = no
    multiple               = no
  triggers:

    on row-display
      persistent run qg_QueryWindowRecordBrowseRowDisplay in target-procedure
                       (bttQueryWindow.WindowHandle).

    on default-action
      persistent run qg_QueryWindowRecordFieldDetails in target-procedure
                       (bttQueryWindow.WindowHandle).

    on ' ':U /* Value details */
      persistent run qg_QueryWindowRecordFieldDetails in target-procedure
                       (bttQueryWindow.WindowHandle).

    on ctrl-c /* Copy value */
      persistent run qg_QueryWindowRecordCopyValue in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers.

// Create browse popup menu.
create menu hTemp
  assign
    name       = 'm_RecordBrowsePopupMenu':U
    popup-only = yes
    sensitive  = yes
    .

hBrowse:popup-menu = hTemp.

create menu-item hTemp
  assign
    name         = 'mi_CopyValue':U
    parent       = hBrowse:popup-menu
    label        = 'Copy value':T
    sensitive    = yes
  triggers:

    on choose
      persistent run qg_QueryWindowRecordCopyValue in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers
  .

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hBrowse:popup-menu
    .

create menu-item hTemp
  assign
    name         = 'mi_FieldDetails':U
    parent       = hBrowse:popup-menu
    label        = 'Field details':T
    sensitive    = yes
  triggers:

    on choose
      persistent run qg_QueryWindowRecordFieldDetails in target-procedure
                       (bttQueryWindow.WindowHandle).

  end triggers
    .

create menu-item hTemp
  assign
    subtype = 'RULE':U
    parent  = hBrowse:popup-menu
    .

create menu-item hTemp
  assign
    name         = 'mi_SelectFields':U
    parent       = hBrowse:popup-menu
    label        = 'Select fields':T
    sensitive    = yes
  triggers:
    on choose
      persistent run qg_QueryWindowRecordSelectFields in target-procedure
                       (bttQueryWindow.WindowHandle).
  end triggers.

create button hTemp
  assign
    name                 = 'btnRefresh':U
    frame                = hFrame
    width                = 6
    height               = 1.5
    row                  = 1.25
    col                  = 45
    label                = '*':T
    tooltip              = 'Refresh current record values':T
    flat-button          = yes
    sensitive            = yes
  triggers:

    on choose
      persistent run qg_QueryWindowRecordRefresh in target-procedure
                      (bttQueryWindow.WindowHandle).

  end triggers.

if cIconRefresh > '':U then
  hTemp:load-image(cIconRefresh) no-error.

if bttQueryWindow.ObjSourceQuerySeq > 0 then
do:

  create text hTemp
    assign
      name      = 'cObjField':U
      frame     = hFrame
      data-type = 'character':U
      format    = 'x(255)':U
      width     = 65
      height    = 1
      row       = 1.5
      col       = 3
      sensitive = yes
      read-only = yes
      tab-stop  = no
      .

  create button hTemp
    assign
      name                 = 'btnSelectObjField':U
      frame                = hFrame
      width                = 6
      height               = 1.5
      row                  = 1.25
      col                  = 68
      label                = '...':T
      tooltip              = 'Select object id field':T
      flat-button          = yes
      sensitive            = yes
    triggers:

      on choose
        persistent run qg_QueryWindowObjSelectObjField in target-procedure
                        (bttQueryWindow.WindowHandle).

    end triggers.

  if cIconPreferences > '':U then
    hTemp:load-image(cIconPreferences) no-error.

end.

else
do:

  create radio-set hTemp
    assign
      name          = 'lRawValues':U
      frame         = hFrame
      width         = 40
      height        = 1
      row           = 1.5
      col           = 3
      sensitive     = yes
      radio-buttons = 'Formatted values,no,Raw values,yes':T
      horizontal    = yes
    triggers:

      on value-changed
        persistent run qg_QueryWindowToggleRawValues in target-procedure
                         ( bttQueryWindow.WindowHandle ).

    end triggers
    .

  create button hTemp
    assign
      name                 = 'btnFirstRecord':U
      frame                = hFrame
      width                = 6
      height               = 1.5
      row                  = 1.25
      col                  = 46
      label                = '<<':T
      tooltip              = 'Select first record':T
      flat-button          = yes
      sensitive            = yes
    triggers:

      on choose
        persistent run qg_QueryWindowRecordNavigate in target-procedure
                        (bttQueryWindow.WindowHandle,
                         {&K_NAVIGATE_FIRST}).

    end triggers.

  if cIconFirst > '':U then
    hTemp:load-image(cIconFirst) no-error.

  create button hTemp
    assign
      name                 = 'btnPrevRecord':U
      frame                = hFrame
      width                = 6
      height               = 1.5
      row                  = 1.25
      col                  = 52
      label                = '<':T
      tooltip              = 'Select previous record':T
      flat-button          = yes
      sensitive            = yes
    triggers:

      on choose
        persistent run qg_QueryWindowRecordNavigate in target-procedure
                        (bttQueryWindow.WindowHandle,
                         {&K_NAVIGATE_PREV}).

    end triggers.

  if cIconPrev > '':U then
    hTemp:load-image(cIconPrev) no-error.

  create button hTemp
    assign
      name                 = 'btnNextRecord':U
      frame                = hFrame
      width                = 6
      height               = 1.5
      row                  = 1.25
      col                  = 64
      label                = '>':T
      tooltip              = 'Select next record':T
      flat-button          = yes
      sensitive            = yes
    triggers:

      on choose
        persistent run qg_QueryWindowRecordNavigate in target-procedure
                        (bttQueryWindow.WindowHandle,
                         {&K_NAVIGATE_NEXT}).

    end triggers.

  if cIconNext > '':U then
    hTemp:load-image(cIconNext) no-error.

  create button hTemp
    assign
      name                 = 'btnLastRecord':U
      frame                = hFrame
      width                = 6
      height               = 1.5
      row                  = 1.25
      col                  = 70
      label                = '>>':T
      tooltip              = 'Select last record':T
      flat-button          = yes
      sensitive            = yes
    triggers:

      on choose
        persistent run qg_QueryWindowRecordNavigate in target-procedure
                        (bttQueryWindow.WindowHandle,
                         {&K_NAVIGATE_LAST}).

    end triggers.

  if cIconLast > '':U then
    hTemp:load-image(cIconLast) no-error.

end.

create buffer hBuffer for table 'ttQueryWindowField':U. /* code checked by mth 30.07.2015 */

create query hQuery.
hQuery:set-buffers(hBuffer).

hBrowse:query = hQuery.

assign
  bttQueryWindow.RecordFrameHandle         = hFrame
  bttQueryWindow.RecordMenuHandle          = hMenuBar
  bttQueryWindow.RecordQueryHandle         = hQuery
  bttQueryWindow.RecordBrowseHandle        = hBrowse
  bttQueryWindow.RecordBrowseColHandles[1] = hBrowse:add-like-column('ttQueryWindowField.FieldName':U)
  bttQueryWindow.RecordBrowseColHandles[2] = hBrowse:add-like-column('ttQueryWindowField.FieldIndex':U)
  bttQueryWindow.RecordBrowseColHandles[3] = hBrowse:add-like-column('ttQueryWindowField.DisplayName':U)
  bttQueryWindow.RecordBrowseColHandles[4] = hBrowse:add-like-column('ttQueryWindowField.FieldLabel':U)
  bttQueryWindow.RecordBrowseColHandles[5] = hBrowse:add-like-column('ttQueryWindowField.CurrentDisplayValue':U)
  .

// Hide field name, label and index column.
assign
  bttQueryWindow.RecordBrowseColHandles[1]:visible = no
  bttQueryWindow.RecordBrowseColHandles[2]:visible = no
  bttQueryWindow.RecordBrowseColHandles[3]:width   = 32
  bttQueryWindow.RecordBrowseColHandles[4]:visible = no
  .

run qg_InitBrowse(hBrowse).

validate bttQueryWindow.

if bttQueryWindow.ObjSourceQuerySeq > 0 then
  run qg_QueryWindowObjUpdateObjFieldText(bttQueryWindow.WindowHandle).

end procedure.

PROCEDURE qg_QueryWindowDelete :
/**
 * Delete current record.
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow    as handle    no-undo.

define variable lOk              as logical   no-undo.
define variable lDisableTriggers as logical   no-undo.

define variable hBuffer     as handle    no-undo.
define variable hLockBuffer as handle    no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

define buffer bttTable       for temp-table ttTable.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if   not valid-handle(bttQueryWindow.QueryHandle)
  or bttQueryWindow.QueryHandle:num-buffers = 0 then
  leave.

hBuffer = bttQueryWindow.QueryHandle:get-buffer-handle(1).

if not hBuffer:available then
do:

  message /* code checked by mth */
    'No record is selected!':T
    view-as alert-box
    error
    buttons ok
    in window bttQueryWindow.WindowHandle.

  leave.

end.

Main:
do transaction
  on error undo, throw:

  create buffer hLockBuffer for table hBuffer.

  find bttTable
    where bttTable.DatabaseName = hLockBuffer:dbname
      and bttTable.TableName    = hLockBuffer:table
    no-error.

  hLockBuffer:find-by-rowid(hBuffer:rowid, exclusive-lock).

  lDisableTriggers =     available bttTable
                     and bttTable.DeleteTrigger         > '':U
                     and search(bttTable.DeleteTrigger) = ?.

  run qg_ConfirmTriggerChanges(substitute('Confirm deletion of &1 record (&2)':T,
                                          hLockBuffer:table,
                                          string(hLockBuffer:rowid)),
                               'WARNING: You are about to delete the current record. Please confirm deletion of this record!':T,
                               'Delete':T,
                               (    available bttTable
                                and search(bttTable.DeleteTrigger) <> ?),
                               bttQueryWindow.WindowHandle,
                                     output lOk,
                               input-output lDisableTriggers).

  if lOk then
  do:


    if lDisableTriggers then
    do:

      run qg_DeleteVirtualFieldRecordsForRecord( hLockBuffer:dbname,
                                                 hLockBuffer,
                                                 lDisableTriggers ).

      hLockBuffer:disable-load-triggers(no).

    end.

    hLockBuffer:buffer-delete().

    qg_lQueryOpen(bttQueryWindow.QueryHandle, ?, bttQueryWindow.WindowHandle).

  end.

  finally:

    if valid-handle(hLockBuffer) then
      delete object hLockBuffer.

  end finally.

end.

end procedure.

PROCEDURE qg_QueryWindowDock :
/**
 * Dock query window to closest other query window.
 *
 * @param phWindow = Handle of the Query window.
 * @param piDirection = Direction to search for other query windows.
 */

define input parameter phWindow    as handle    no-undo.
define input parameter piDirection as integer   no-undo.

define variable hWindow       as handle    no-undo.

define variable iX1 as integer   no-undo.
define variable iY1 as integer   no-undo.
define variable iX2 as integer   no-undo.
define variable iY2 as integer   no-undo.

define variable iX1Temp as integer   no-undo.
define variable iY1Temp as integer   no-undo.
define variable iX2Temp as integer   no-undo.
define variable iY2Temp as integer   no-undo.

define variable dDistance      as decimal   no-undo.
define variable dDockDistanceX as decimal   no-undo init ?.
define variable dDockDistanceY as decimal   no-undo init ?.

define buffer bttQueryWindow  for temp-table ttQueryWindow.
define buffer b2ttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

// The size that progress returns for window:width-pixels and window:height
// pixels does not include the borders. So in order to get the true window
// size and position we need the windows api.

run qg_GetWindowRect(phWindow,
                     output iX1,
                     output iY1,
                     output iX2,
                     output iY2).

for each b2ttQueryWindow
  on error undo, throw:

  hWindow = b2ttQueryWindow.WindowHandle.

  if    not valid-handle(hWindow)
     or hWindow = bttQueryWindow.WindowHandle then
    next.

  run qg_GetWindowRect(hWindow,
                       output iX1Temp,
                       output iY1Temp,
                       output iX2Temp,
                       output iY2Temp).

  if    ( ( piDirection = {&K_DIRECTION_UP}
         or piDirection = {&K_DIRECTION_DOWN} )
      and iX1 <= iX2Temp
      and iX2 >= iX1Temp )
     or ( ( piDirection = {&K_DIRECTION_LEFT}
         or piDirection = {&K_DIRECTION_RIGHT} )
      and iY1 <= iY2Temp
      and iY2 >= iY1Temp ) then
  do:

    case piDirection:

      when {&K_DIRECTION_UP} then
      do:

        dDistance = iY1 - iY2Temp.

        if    dDistance > 0
          and ( dDockDistanceY = ?
             or dDistance      < dDockDistanceY ) then
          assign
            dDockDistanceX = iX1 - iX1Temp
            dDockDistanceY = dDistance
            .

      end.

      when {&K_DIRECTION_DOWN} then
      do:

        dDistance = iY2 - iY1Temp.

        if    dDistance < 0
          and ( dDockDistanceY = ?
             or dDistance      > dDockDistanceY ) then
          assign
            dDockDistanceX = iX1 - iX1Temp
            dDockDistanceY = dDistance
            .

      end.

      when {&K_DIRECTION_LEFT} then
      do:

        dDistance = iX1 - iX2Temp.

        if    dDistance > 0
          and ( dDockDistanceX = ?
             or dDistance      < dDockDistanceX ) then
          assign
            dDockDistanceX = dDistance
            dDockDistanceY = iY1 - iY1Temp
            .

      end.

      when {&K_DIRECTION_RIGHT} then
      do:

        dDistance = iX2 - iX1Temp.

        if    dDistance < 0
          and ( dDockDistanceX = ?
             or dDistance      > dDockDistanceX ) then
          assign
            dDockDistanceX = dDistance
            dDockDistanceY = iY1 - iY1Temp
            .

      end.

    end case.

  end.

end.

if    dDockDistanceX <> ?
  and dDockDistanceY <> ? then
  assign
    bttQueryWindow.WindowHandle:x = bttQueryWindow.WindowHandle:x - dDockDistanceX
    bttQueryWindow.WindowHandle:y = bttQueryWindow.WindowHandle:y - dDockDistanceY
    .

end procedure.

PROCEDURE qg_QueryWindowEdit :
/**
 * Edit current record.
 *
 * @param phWindow = Handle of the Query window.
 * @param piEditAction = Action that should be performed: - {&K_EDITACTION_EDIT} - {&K_EDITACTION_CREATE} - {&K_EDITACTION_DUPLICATE}
 */

define input parameter phWindow       as handle    no-undo.
define input parameter piEditAction   as integer   no-undo.

define variable hBuffer as handle    no-undo.
define variable rRowid  as rowid     no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if   not valid-handle(bttQueryWindow.QueryHandle)
  or bttQueryWindow.QueryHandle:num-buffers = 0 then
  leave.

hBuffer = bttQueryWindow.QueryHandle:get-buffer-handle(1).

if   ( piEditAction = {&K_EDITACTION_EDIT}
    or piEditAction = {&K_EDITACTION_DUPLICATE})
  and not hBuffer:available then
do:

  message /* code checked by mth */
    'No record is selected!':T
    view-as alert-box
    error
    buttons ok
    in window bttQueryWindow.WindowHandle.

  leave.

end.

run qg_EditRecord(hBuffer,
                  piEditAction,
                  {&K_EDITMODE_ENABLED},
                  bttQueryWindow.WindowHandle,
                  (if valid-handle(bttQueryWindow.QueryBrowseHandle) then
                     qg_cBrowseColumnList(bttQueryWindow.QueryBrowseHandle,
                                          yes,
                                          no,
                                          no)
                   else
                     ?),
                  output rRowid).

&IF {&K_EDITMODE_ENABLED} &THEN

  case piEditAction:

    when {&K_EDITACTION_EDIT} then
    do:

      if valid-handle(bttQueryWindow.QueryBrowseHandle) then 
        bttQueryWindow.QueryBrowseHandle:refresh().

      run qg_QueryWindowUpdateAll('':U).

    end.

    otherwise
    do:

      qg_lQueryOpen(bttQueryWindow.QueryHandle, ?, bttQueryWindow.WindowHandle).

      if rRowid <> ? then
        bttQueryWindow.QueryHandle:reposition-to-rowid(rRowid) no-error.

//      bttQueryWindow.QueryBrowseHandle:scroll-to-current-row().
    end.

  end case.

&ENDIF

end procedure.

PROCEDURE qg_queryWindowEntry :
define input parameter phWindow as handle    no-undo.

define variable hBuffer as handle    no-undo.

define buffer bttQueryWindow     for temp-table ttQueryWindow.
define buffer bttQueryWindowView for temp-table ttQueryWindowView.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

ghActiveQueryWindow = bttQueryWindow.WindowHandle.

run qg_QueryWindowListSelectQueryWindow(ghActiveQueryWindow).

end procedure.

PROCEDURE qg_QueryWindowExecCurrentQuery :
/**
 * Executes the current query text in a new query window.
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow       as handle    no-undo.

define variable i             as integer   no-undo.
define variable hBuffer       as handle    no-undo.
define variable cDatabaseName as character no-undo.
define variable cTables       as character no-undo.
define variable iQuerySeq     as integer   no-undo init ?.

define buffer bttQueryWindow     for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if   not valid-handle(bttQueryWindow.QueryHandle)
  or bttQueryWindow.QueryHandle:num-buffers = 0 then
  leave.

do i = 1 to bttQueryWindow.QueryHandle:num-buffers:

  assign
    hBuffer       = bttQueryWindow.QueryHandle:get-buffer-handle(i)
    cDatabaseName = qg_cDatabaseNameForTableOrBuffer( hBuffer )
    cTables       = substitute('&1.&2:&3':U,
                               cDatabaseName,
                               hBuffer:table,
                               hBuffer:name)
    .

end.

if bttQueryWindow.QueryHandle:prepare-string > '':U then
  run qg_ExecQuery({&K_QUERY_WINDOW_MODE_QUERY},
                   {&K_QUERY_SIZE_MODE_DEFAULT},
                   cTables,
                   bttQueryWindow.QueryHandle:prepare-string,
                   no,  /* Init mode */
                   '':U,
                   input-output iQuerySeq).

end procedure.

PROCEDURE qg_QueryWindowExecute :
/**
 * Execute query of given query window.
 *
 * @param phWindow = Handle of the Query window.
 * @param pcQueryText = Query text that should be executed. If empty or "?" then the query text will be be determined by the window mode.
 * @param plFocusBrowse = Focus browse if the browse contains hits.
 */

define input parameter phWindow      as handle    no-undo.
define input parameter pcQueryText   as character no-undo.
define input parameter plFocusBrowse as logical   no-undo.

define variable cQueryText as character no-undo.
define variable i          as integer   no-undo.
define variable cButtons   as character no-undo init 'btnExecute,btnEdit,btnDelete,btnCreate,btnDuplicate':U.
define variable hTemp      as handle    no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

// Additional do block to ensure that bttQueryWindow will be available in
// finally block.

do on error undo, throw:

  phWindow:title = substitute('&1 (executing ...)':U, bttQueryWindow.WindowTitle).

  if   not valid-handle(bttQueryWindow.QueryHandle)
    or bttQueryWindow.QueryHandle:num-buffers = 0 then
    leave.

  case bttQueryWindow.WindowMode:

    when {&K_QUERY_WINDOW_MODE_QUERY} then
    do:

      do i = 1 to num-entries(cButtons):

        hTemp = qg_hGetWidgetByName(bttQueryWindow.WindowHandle,
                                    entry(i, cButtons)).

        if valid-handle(hTemp) then
          hTemp:sensitive = no. /* code checked by mth 30.07.2015 */

      end.

      cQueryText = (if pcQueryText > '':U then
                      pcQueryText
                    else
                      bttQueryWindow.QueryTextEditorHandle:input-value).

    end.

    when {&K_QUERY_WINDOW_MODE_RECORD} then
      cQueryText = (if pcQueryText > '':U then
                      pcQueryText
                    else
                      bttQueryWindow.QueryText).

  end case.

  process events.

  if cQueryText <> bttQueryWindow.QueryText then
    run qg_QueryWindowSetQueryText(bttQueryWindow.WindowHandle, cQueryText).

  run qg_QueryWindowUpdateAll(string(bttQueryWindow.WindowHandle)).

  case bttQueryWindow.WindowMode:

    when {&K_QUERY_WINDOW_MODE_QUERY} then
      if    plFocusBrowse
        and bttQueryWindow.QueryHandle:num-results > 0 then
        apply 'entry':U to bttQueryWindow.QueryBrowseHandle.

    when {&K_QUERY_WINDOW_MODE_RECORD} then
      if    plFocusBrowse
        and bttQueryWindow.RecordQueryHandle:num-results > 0 then
        apply 'entry':U to bttQueryWindow.RecordBrowseHandle.

  end case.

  finally:

    if valid-handle(phWindow) then
      phWindow:title = bttQueryWindow.WindowTitle.

    if bttQueryWindow.WindowMode = {&K_QUERY_WINDOW_MODE_QUERY} then
    do:

      do i = 1 to num-entries(cButtons):

        hTemp = qg_hGetWidgetByName(bttQueryWindow.WindowHandle,
                                    entry(i, cButtons)).

        if valid-handle(hTemp) then
          hTemp:sensitive = yes. /* code checked by mth 30.07.2015 */

      end.

    end.

  end finally.

end.

end procedure.

PROCEDURE qg_QueryWindowFieldSelectionBrowseDefaultAction :
/**
 * Default action trigger of field selection browse.
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.

define variable iKeyState             as integer   no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

bttQueryWindow.QueryFieldBrowseHandle:deselect-rows().
bttQueryWindow.QueryFieldBrowseHandle:select-focused-row().

run GetKeyState({&K_WIN_CONST_VK_ALT}, output iKeyState).

if iKeyState < 0 then
do:

  run GetKeyState({&K_WIN_CONST_VK_SHIFT}, output iKeyState).

  run qg_QueryWindowAddSortOption(bttQueryWindow.WindowHandle,
                                  (iKeyState < 0)).

end.

else
do:

  run GetKeyState({&K_WIN_CONST_VK_CTRL}, output iKeyState).

  if iKeyState < 0 then
    run qg_QueryWindowMoveColumn(bttQueryWindow.WindowHandle, yes).

  else
    run qg_QueryWindowQueryTextEditorAddCondition(bttQueryWindow.WindowHandle).

end.

end procedure.

PROCEDURE qg_QueryWindowFindMissingObjectIds :
/**
 * Default action trigger of field selection browse.
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.

define variable lSelected               as logical   no-undo.
define variable cField_Key              as character no-undo.
define variable cField_Label            as character no-undo.
define variable cAvailableColumn_Keys   as character no-undo.
define variable cAvailableColumn_Labels as character no-undo.
define variable cSelectedColumn_Keys    as character no-undo.
define variable lOk                     as logical   no-undo.

define variable i                       as integer   no-undo.
define variable hQuery                  as handle    no-undo.
define variable hBuffer                 as handle    no-undo.
define variable cDatabaseNames          as character no-undo extent.
define variable cBufferNames            as character no-undo extent.
define variable cFieldNames             as character no-undo extent.
define variable iFieldIndices           as integer   no-undo extent.
define variable hBufferFields           as handle    no-undo extent.
define variable cObjectId               as character no-undo.

define buffer bttQueryWindow      for temp-table ttQueryWindow.

define buffer bttQueryWindowField for temp-table ttQueryWindowField.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

for each bttQueryWindowField
  where bttQueryWindowField.WindowHandle = bttQueryWindow.WindowHandle
    and bttQueryWindowField.IsOverlay    = no
  on error undo, throw:

  if lookup(bttQueryWindowField.DataType, 'CHARACTER,LONGCHAR':U) = 0 then
    next.

  assign
    lSelected               =   (     bttQueryWindowField.FieldName matches '*_Obj':U
                                   or bttQueryWindowField.isObjectId )
                              and not bttQueryWindowField.FieldName matches substitute('&1_Obj':U, bttQueryWindowField.TableName)
    cField_Key              = qg_cFormattedFieldName(?,
                                                     bttQueryWindowField.BufferName,
                                                     bttQueryWindowField.FieldName,
                                                     bttQueryWindowField.FieldIndex)
    cAvailableColumn_Keys   = substitute('&1,&2':U, cAvailableColumn_Keys, cField_Key)
    cField_Label            = qg_cFormattedFieldName(?,
                                                     (if    valid-handle(bttQueryWindow.QueryBrowseHandle)
                                                        and bttQueryWindow.QueryHandle:num-buffers > 1 then
                                                        bttQueryWindowField.BufferName
                                                      else
                                                        ?),
                                                     bttQueryWindowField.FieldName,
                                                     bttQueryWindowField.FieldIndex)
    cAvailableColumn_Labels = substitute('&1,&2':U,
                                         cAvailableColumn_Labels,
                                          cField_Label)
    .

  if lSelected then
    cSelectedColumn_Keys = substitute('&1,&2':U, cSelectedColumn_Keys, cField_Key).

end.

assign
  cAvailableColumn_Keys   = trim(cAvailableColumn_Keys, ',':U)
  cAvailableColumn_Labels = trim(cAvailableColumn_Labels, ',':U)
  cSelectedColumn_Keys    = ( if bttQueryWindow.MissingObjectIdFields > '':U then
                                bttQueryWindow.MissingObjectIdFields
                              else
                                trim( cSelectedColumn_Keys, ',':U ) )
  .

do while yes
  on error undo, throw:

  run qg_SelectionDialog( cAvailableColumn_Keys,
                          cAvailableColumn_Labels,
                          input-output cSelectedColumn_Keys,
                          'Select Fields to check':T,
                          bttQueryWindow.WindowHandle,
                          no,
                          output lOk ).

  if not lOk then
    return.

  if num-entries( cSelectedColumn_Keys ) > 0 then
  do:

    if cSelectedColumn_Keys <> bttQueryWindow.MissingObjectIdFields then
      assign
        bttQueryWindow.MissingObjectIdFields      = cSelectedColumn_Keys
        bttQueryWindow.LastMissingObjectIdRecords = '':U
        .

    if    valid-handle( bttQueryWindow.QueryHandle )
      and bttQueryWindow.QueryHandle:is-open
      and bttQueryWindow.QueryHandle:num-results > 0 then
      run qg_QueryWindowFindNextMissingObjectId( bttQueryWindow.WindowHandle ).

    leave.

  end.

  message
    'At least one field has to be selected':T skip
    view-as alert-box
    error
    buttons ok.

end.

end procedure.

PROCEDURE qg_QueryWindowFindNextMissingObjectId :
/**
 * Default action trigger of field selection browse.
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.

define variable i                  as integer   no-undo.
define variable rCurrentRecords    as rowid     no-undo extent.
define variable hQuery             as handle    no-undo.
define variable hBuffers           as handle    no-undo extent.
define variable cDatabaseNames     as character no-undo extent.
define variable cBufferNames       as character no-undo extent.
define variable cFieldNames        as character no-undo extent.
define variable iFieldIndices      as integer   no-undo extent.
define variable hBufferFields      as handle    no-undo extent.
define variable cFieldDataTypes    as character no-undo extent.
define variable lIsVirtual         as logical   no-undo extent.
define variable iFieldTypes        as integer   no-undo extent.
define variable cObjectId          as character no-undo.

define variable lOmitCurrentRecord as logical   no-undo initial yes.

define variable iRecordCount       as integer   no-undo.

define buffer bttQueryWindow      for temp-table ttQueryWindow.

define buffer bttField            for temp-table ttField.

define buffer bttQueryWindowField for temp-table ttQueryWindowField.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if bttQueryWindow.MissingObjectIdFields = '':U then
do:

  run qg_QueryWindowFindMissingObjectIds( bttQueryWindow.WindowHandle ).
  return.

end.

assign
  hQuery = bttQueryWindow.QueryHandle
  extent( rCurrentRecords ) = hQuery:num-buffers.
  .

assign
  extent( hBuffers )        = num-entries( bttQueryWindow.MissingObjectIdFields )
  extent( cDatabaseNames )  = num-entries( bttQueryWindow.MissingObjectIdFields )
  extent( cBufferNames )    = num-entries( bttQueryWindow.MissingObjectIdFields )
  extent( cFieldNames )     = num-entries( bttQueryWindow.MissingObjectIdFields )
  extent( iFieldIndices )   = num-entries( bttQueryWindow.MissingObjectIdFields )
  extent( hBufferFields )   = num-entries( bttQueryWindow.MissingObjectIdFields )
  extent( cFieldDataTypes ) = num-entries( bttQueryWindow.MissingObjectIdFields )
  extent( lIsVirtual )      = num-entries( bttQueryWindow.MissingObjectIdFields )
  extent( iFieldTypes )     = num-entries( bttQueryWindow.MissingObjectIdFields )
  .

do i = 1 to num-entries( bttQueryWindow.MissingObjectIdFields ):

  run qg_SplitFieldName( entry( i, bttQueryWindow.MissingObjectIdFields ),
                         output cDatabaseNames[i],
                         output cBufferNames[i],
                         output cFieldNames[i],
                         output iFieldIndices[i] ).

  assign
    hBuffers[i]       = hQuery:get-buffer-handle( cBufferNames[i] )
    cDatabaseNames[i] = qg_cDatabaseNameForTableOrBuffer( hBuffers[i] )
    .

  hBufferFields[i]  = hBuffers[i]:buffer-field( cFieldNames[i] ) no-error.

  if   ( error-status:error
       or not valid-handle( hBufferFields[i] ) )
     and qg_lIsPhysicalDatabase( hBuffers[i]:dbname ) then
  do:

    find bttField
      where bttField.DatabaseName = cDatabaseNames[i]
        and bttField.TableName    = hBuffers[i]:table
        and bttField.FieldName    = cFieldNames[i]
      no-error.

    if available bttField then

      assign
        cFieldDataTypes[i] = bttField.DataType
        lIsVirtual[i]      = bttField.IsVirtual
        iFieldTypes[i]     = bttField.FieldType
        .

  end.

end.

do i = 1 to hQuery:num-buffers:

  rCurrentRecords[i] = hQuery:get-buffer-handle(i):rowid.

  if    num-entries( bttQueryWindow.LastMissingObjectIdRecords ) < i
     or to-rowid( entry( i, bttQueryWindow.LastMissingObjectIdRecords ) ) <> rCurrentRecords[i] then
    lOmitCurrentRecord = no.

end.

if lOmitCurrentRecord then
  hQuery:get-next().

do on error undo, throw:

  do while not hQuery:query-off-end:

    iRecordCount = iRecordCount + 1.

    if   iRecordCount = 50
      or iRecordCount mod 500 = 0 then
    do:

      display unless-hidden
        substitute( 'Searching for missing object ids (&1 records checked) ...':T,
                    trim(string( iRecordCount, {&K_MAX_INT64_FORMAT} ) ) )
          @ gcStatusText60
        with frame fStatus
          no-labels
          overlay
          color messages
          centered
          view-as dialog-box
          width 65
          in window bttQueryWindow.WindowHandle
          .

      process events.

    end.

    do i = 1 to num-entries( bttQueryWindow.MissingObjectIdFields ):

      cObjectId = ( if lIsVirtual[i] then
                      string( qg_clVirtualFieldValueAsLongchar( iFieldTypes[i],
                                                                cFieldDataTypes[i],
                                                                cFieldNames[i],
                                                                qg_cObjectIdForBuffer( hBuffers[i] ),
                                                                ? ) )
                    else if valid-handle( hBufferFields[i] ) then
                      hBufferFields[i]:buffer-value( iFieldIndices[i] )
                    else
                      '':U ).

      if cObjectId > '':U then
      do:

        if qg_cResolveObjectId( cDatabaseNames[i],
                                cFieldNames[i],
                                cObjectId,
                                no,
                                no ) = ? then
        do:

          bttQueryWindow.LastMissingObjectIdRecords = '':U.

          do i = 1 to hQuery:num-buffers:

            rCurrentRecords[i] = hQuery:get-buffer-handle(i):rowid.

            if bttQueryWindow.LastMissingObjectIdRecords > '':U then
              bttQueryWindow.LastMissingObjectIdRecords
                  = bttQueryWindow.LastMissingObjectIdRecords + ',':U.

            bttQueryWindow.LastMissingObjectIdRecords
                = bttQueryWindow.LastMissingObjectIdRecords + string( rCurrentRecords[i] ).

          end.

          return.

        end.

      end.

    end.

    hQuery:get-next().

  end.

  finally:

    hQuery:reposition-to-rowid(rCurrentRecords).

  end finally.

end.

hide frame fStatus.

message
  'No more missing Object IDs have been found!':T skip
  view-as alert-box
  information
  buttons ok
    in window bttQueryWindow.WindowHandle.

finally:

  hide frame fStatus.

end finally.

end procedure.

PROCEDURE qg_QueryWindowInsertExternalReference :
/**
 * Insert external value token into query text.
 *
 * @param phWindow = Handle of the Query window.
 * @param phEditor = Handle of editor into which the external reference should be inserted.
 * @param plFieldReference = Flag to indicate wether a field reference or a table reference should be inserted.
 */

define input parameter phWindow         as handle    no-undo.
define input parameter phEditor         as handle    no-undo.
define input parameter plFieldReference as logical   no-undo.

define variable i                    as integer   no-undo.
define variable j                    as integer   no-undo.

define variable iStartPos            as integer   no-undo.
define variable iFieldRefPos         as integer   no-undo.
define variable iMaxFieldPos         as integer   no-undo.
define variable hQuery               as handle    no-undo.
define variable hBuffer              as handle    no-undo.
define variable hField               as handle    no-undo.
define variable cReferenceText       as character no-undo init ?.
define variable cEditorText          as character no-undo.
define variable iSelectionStart      as integer   no-undo.
define variable iSelectionEnd        as integer   no-undo.

define variable cTableName           as character no-undo init ?.
define variable cFieldName           as character no-undo init ?.

define buffer bttQueryWindow      for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if    bttQueryWindow.ObjSourceQuerySeq > 0
   or not valid-handle(bttQueryWindow.QueryHandle) then
  leave.

if plFieldReference then
do:

  assign
    hQuery      = bttQueryWindow.QueryHandle
    cEditorText = phEditor:input-value
    iStartPos   = max(r-index(cEditorText,
                              '=':U,
                              phEditor:cursor-offset),
                      r-index(cEditorText,
                              '<':U,
                              phEditor:cursor-offset),
                      r-index(cEditorText,
                              '>':U,
                              phEditor:cursor-offset))
    iStartPos   = (if iStartPos = 0 then
                     phEditor:cursor-offset
                   else
                     iStartPos)
    .

  // Try to guess the field name for wich an external reference should be
  // inserted.

  do i = 1 to hQuery:num-buffers:

    hBuffer = hQuery:get-buffer-handle(i).

    do j = 1 to hBuffer:num-fields:

      hField = hBuffer:buffer-field(j).

      iFieldRefPos = r-index(cEditorText,
                             substitute('&1.&2':U, hBuffer:name, hField:name),
                             iStartPos).

      if    iFieldRefPos > 0
        and iFieldRefPos > iMaxFieldPos then
        assign
          cTableName   = hBuffer:table
          cFieldName   = hField:name
          iMaxFieldPos = iFieldRefPos
          .

    end.

  end.

end.

run qg_GetExternalReference(cTableName,
                            cFieldName,
                            plFieldReference,
                            substitute('!&1,*':U, bttQueryWindow.WindowHandle),
                            bttQueryWindow.WindowHandle,
                            output cReferenceText).

if cReferenceText > '':U then
do:

  assign
    iSelectionStart = (if phEditor:selection-start <> ? then
                         phEditor:selection-start
                       else
                         phEditor:cursor-offset)
    iSelectionEnd   = (if phEditor:selection-end <> ? then
                         phEditor:selection-end
                       else
                         phEditor:cursor-offset)
    .

  if cEditorText > '':U then
  do:

    if    iSelectionStart > 1
      and index('~'"':U, substring(cEditorText, iSelectionStart - 1, 1)) > 0 then
      iSelectionStart = iSelectionStart - 1.

    if index('~'"':U, substring(cEditorText, iSelectionEnd, 1)) > 0 then
      iSelectionEnd = iSelectionEnd + 1.

    if    iSelectionStart > 0
      and iSelectionEnd  >= iSelectionStart then
      phEditor:set-selection(iSelectionStart, iSelectionEnd).

  end.

  if phEditor:selection-text > '':U then
    phEditor:replace-selection-text(cReferenceText).
  else
    phEditor:insert-string(cReferenceText).

end.

end procedure.

PROCEDURE qg_QueryWindowListActivateQueryWindow :
define variable hBuffer as handle    no-undo.
define variable hWindow as handle    no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(ghQueryWindowListWindow) then
  leave.

hBuffer = ghQueryWindowListBrowse:query:get-buffer-handle(1).

if    hBuffer:available
  and hBuffer::WindowHandle:visible then
do:

  find bttQueryWindow
    where bttQueryWindow.WindowHandle = hBuffer::WindowHandle
    no-lock no-error.

  run qg_QueryWindowShowChildWindows(bttQueryWindow.QuerySeq).

  run qg_ActivateWindow(bttQueryWindow.WindowHandle, bttQueryWindow.QueryBrowseHandle).

end.

end procedure.

PROCEDURE qg_QueryWindowListBrowseOnRowDisplay :
define input parameter phColumn as handle    no-undo.
define input parameter phBuffer as handle    no-undo.

define variable hBuffer as handle    no-undo.

if not valid-handle(ghQueryWindowListWindow) then
  leave.

phColumn:fgcolor = (if not phBuffer:available then
                      ?
                    else if not phBuffer::WindowHandle:visible then
                      {&K_COLOR_LIGHT_GREY}
                    else
                      ?).

end procedure.

PROCEDURE qg_QueryWindowListBrowsePopupMenuDrop :
define variable hBuffer                        as handle    no-undo.

define variable hMenu                          as handle    no-undo.

define variable hActivateMenuItem              as handle    no-undo.
define variable hMinimizeMenuItem              as handle    no-undo.
define variable hHideMenuItem                  as handle    no-undo.
define variable hCloseMenuItem                 as handle    no-undo.
define variable hMinimizeBranchMenuItem        as handle    no-undo.
define variable hHideBranchMenuItem            as handle    no-undo.
define variable hCloseBranchMenuItem           as handle    no-undo.
define variable hCloseAllMenuItem              as handle    no-undo.
define variable hOpenRelatedQueryMenuItem      as handle    no-undo.
define variable hAlwaysOnTopMenuItem           as handle    no-undo.

define variable lQueryWindowsExist             as logical   no-undo.
define variable lHasChildren                   as logical   no-undo.
define variable lIsVisible                     as logical   no-undo.

if not valid-handle(ghQueryWindowListWindow) then
  leave.

assign
  lQueryWindowsExist = temp-table ttQueryWindow:has-records
  hBuffer            = ghQueryWindowListBrowse:query:get-buffer-handle(1)
  lHasChildren
      = (if hBuffer:available then
           can-find(first ttQueryWindowView
                      where ttQueryWindowView.ParentWindowHandle = hBuffer::WindowHandle)
         else
           no)
  lIsVisible
      = (if hBuffer:available then
           hBuffer::WindowHandle:visible
         else
           no)
  hMenu   = ghQueryWindowListBrowse:popup-menu
  hActivateMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_Activate':U)
  hActivateMenuItem:sensitive
      = lIsVisible
  hMinimizeMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_Minimize':U)
  hHideMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_Hide':U)
  hCloseMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_Close':U)
  hMinimizeBranchMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_MinimizeBranch':U)
  hHideBranchMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_HideBranch':U)
  hCloseBranchMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_CloseBranch':U)
  hCloseAllMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_CloseAll':U)
  hCloseAllMenuItem:sensitive
      = lQueryWindowsExist
  hOpenRelatedQueryMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_OpenRelatedQuery':U)
  hOpenRelatedQueryMenuItem:sensitive
      = hBuffer:available
  hAlwaysOnTopMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_AlwaysOnTop':U)
  hAlwaysOnTopMenuItem:sensitive
      = hBuffer:available
  .

if hBuffer:available then
  assign
    hMinimizeMenuItem:sensitive
        = lIsVisible
    hMinimizeMenuItem:label
        = (if hBuffer::WindowHandle:window-state = {&K_WINDOW_MINIMIZED} then
             'Restore':T
           else
             'Minimize':T)
    hHideMenuItem:sensitive
        = yes
    hHideMenuItem:label
        = (if hBuffer::WindowHandle:visible then
             'Hide':T
           else
             'Show':T)
    hCloseMenuItem:sensitive
        = yes
    hMinimizeBranchMenuItem:sensitive
        = lHasChildren
    hMinimizeBranchMenuItem:label
        = (if hBuffer::WindowHandle:window-state = {&K_WINDOW_MINIMIZED} then
             'Restore branch':T
           else
             'Minimize branch':T)
    hHideBranchMenuItem:sensitive
        = lHasChildren
    hHideBranchMenuItem:label
        = (if hBuffer::WindowHandle:visible then
             'Hide branch':T
           else
             'Show branch':T)
    hCloseBranchMenuItem:sensitive
        = lHasChildren
    hAlwaysOnTopMenuItem:checked
        = hBuffer::WindowHandle:always-on-top
    .

else
  assign
    hMinimizeMenuItem:sensitive
        = no
    hMinimizeMenuItem:label
        = 'Minimize':T
    hHideMenuItem:sensitive
        = no
    hHideMenuItem:label
        = 'Hide':T
    hCloseMenuItem:sensitive
        = no
    hMinimizeBranchMenuItem:sensitive
        = no
    hMinimizeBranchMenuItem:label
        = 'Minimize branch':U
    hHideBranchMenuItem:sensitive
        = no
    hHideBranchMenuItem:label
        = 'Hide branch':T
    hCloseBranchMenuItem:sensitive
        = no
    hAlwaysOnTopMenuItem:checked
        = no
    .

end procedure.

PROCEDURE qg_QueryWindowListCloseAllQueryWindows :
define buffer bttQueryWindow for temp-table ttQueryWindow.

for each bttQueryWindow
  on error undo, throw:

  if valid-handle(bttQueryWindow.WindowHandle) then
    run qg_QueryWindowClose(bttQueryWindow.WindowHandle, no).

  else
    delete bttQueryWindow.

end.

end procedure.

PROCEDURE qg_QueryWindowListCloseQueryWindow :
define input parameter plCloseChildWindows as logical   no-undo.

define variable hBuffer as handle    no-undo.
define variable hWindow as handle    no-undo.

if not valid-handle(ghQueryWindowListWindow) then
  leave.

hBuffer = ghQueryWindowListBrowse:query:get-buffer-handle(1).

if hBuffer:available then
  run qg_QueryWindowClose(hBuffer::WindowHandle, plCloseChildWindows).

end procedure.

PROCEDURE qg_QueryWindowListCopyQueryScenario :
apply 'choose':U to menu-item mi_CopyQueryScenario in menu m_Edit.

end procedure.

PROCEDURE qg_QueryWindowListDropFileNotify :
define variable hFrame    as handle    no-undo.
define variable i         as integer   no-undo.
define variable cFileName as character no-undo.

if not valid-handle(ghQueryWindowListWindow) then
  leave.

hFrame = qg_hGetWidgetByName(ghQueryWindowListWindow, 'fQueryWindows':U).

do i = 1 to hFrame:num-dropped-files:

  cFileName = hFrame:get-dropped-file(i).

  if cFileName matches '*.qsc':U then
    run qg_LoadQueryScenario(cFileName, (i = 1)).

end.

finally:

  if valid-handle(hFrame) then
    hFrame:end-file-drop().

end finally.

end procedure.

PROCEDURE qg_QueryWindowListEditMenuDrop :
/**
 * Trigger procedure for window close event of query window list window.
 */

define variable hMenu                       as handle    no-undo.
define variable hCopyQueryScenarioMenuItem  as handle    no-undo.
define variable hPasetQueryScenarioMenuItem as handle    no-undo.

if not valid-handle(ghQueryWindowListWindow) then
  leave.

assign
  hMenu                 = ghQueryWindowListWindow:menu-bar
  hCopyQueryScenarioMenuItem
      = qg_hGetWidgetByName(hMenu, 'mi_CopyQueryScenario':U)
  hCopyQueryScenarioMenuItem:sensitive
      = can-find(first ttQueryWindow)
  hPasetQueryScenarioMenuItem
      = qg_hGetWidgetByName(hMenu, 'mi_PasteQueryScenario':U)
  hPasetQueryScenarioMenuItem:sensitive
      = lookup('PRO_TEXT':U, clipboard:available-formats) > 0
  .

end procedure.

PROCEDURE qg_QueryWindowListFileMenuDrop :
define variable hMenu                      as handle    no-undo.
define variable hSaveQueryScenarioMenuItem as handle    no-undo.

if not valid-handle(ghQueryWindowListWindow) then
  leave.

assign
  hMenu                 = ghQueryWindowListWindow:menu-bar
  hSaveQueryScenarioMenuItem
      = qg_hGetWidgetByName(hMenu, 'mi_SaveQueryScenario':U)
  hSaveQueryScenarioMenuItem:sensitive
      = can-find(first ttQueryWindow)
  .

end procedure.

PROCEDURE qg_QueryWindowListHideQueryWindow :
define input parameter plUpdateChildren as logical   no-undo.

define variable hBuffer as handle    no-undo.
define variable hWindow as handle    no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(ghQueryWindowListWindow) then
  leave.

hBuffer = ghQueryWindowListBrowse:query:get-buffer-handle(1).

if hBuffer:available then
do:

  find bttQueryWindow
    where bttQueryWindow.WindowHandle = hBuffer::WindowHandle
    no-error.

  if available bttQueryWindow then
  do:

    run qg_QueryWindowSetVisibleState(bttQueryWindow.QuerySeq,
                                      not bttQueryWindow.WindowHandle:visible,
                                      plUpdateChildren).

    run qg_UpdateQueryWindowView.

    if ghQueryWindowListBrowse:query:num-results > 0 then
      ghQueryWindowListBrowse:refresh().

  end.

end.

end procedure.

PROCEDURE qg_QueryWindowListLoadQueryScenario :
apply 'choose':U to menu-item mi_LoadQueryScenario in menu m_File.

end procedure.

PROCEDURE qg_QueryWindowListSetVisibleStates :
define input parameter plVisible as logical   no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

for each bttQueryWindow
  on error undo, throw:

  if bttQueryWindow.WindowHandle:visible <> plVisible then
    run qg_QueryWindowSetVisibleState(bttQueryWindow.QuerySeq,
                                      plVisible,
                                      no).

end.

run qg_UpdateQueryWindowView.

if    valid-handle(ghQueryWindowListWindow)
  and ghQueryWindowListBrowse:query:num-results > 0 then
  ghQueryWindowListBrowse:refresh().

end procedure.

PROCEDURE qg_QueryWindowListSetWindowStates :
define input parameter piWindowState as integer   no-undo.

define variable hBuffer as handle    no-undo.
define variable hWindow as handle    no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

for each bttQueryWindow
  on error undo, throw:

  if    ( piWindowState = {&K_WINDOW_MINIMIZED}
      and bttQueryWindow.WindowHandle:window-state <> {&K_WINDOW_MINIMIZED} )
     or
        ( piWindowState <> {&K_WINDOW_MINIMIZED}
      and bttQueryWindow.WindowHandle:window-state = {&K_WINDOW_MINIMIZED} ) then
  run qg_QueryWindowSetWindowState(bttQueryWindow.QuerySeq,
                                   piWindowState,
                                   no).

end.

end procedure.

PROCEDURE qg_QueryWindowListMinimizeQueryWindow :
define input parameter plUpdateChildren as logical   no-undo.

define variable hBuffer as handle    no-undo.
define variable hWindow as handle    no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(ghQueryWindowListWindow) then
  leave.

hBuffer = ghQueryWindowListBrowse:query:get-buffer-handle(1).

if hBuffer:available then
do:

  find bttQueryWindow
    where bttQueryWindow.WindowHandle = hBuffer::WindowHandle
    no-error.

  if available bttQueryWindow then
    run qg_QueryWindowSetWindowState(bttQueryWindow.QuerySeq,
                                     (if bttQueryWindow.WindowHandle:window-state = {&K_WINDOW_MINIMIZED} then
                                        {&K_WINDOW_NORMAL}
                                      else
                                        {&K_WINDOW_MINIMIZED}),
                                     plUpdateChildren).

end.

end procedure.

PROCEDURE qg_QueryWindowListOpenRelatedQuery :
define variable hBuffer as handle    no-undo.

if not valid-handle(ghQueryWindowListWindow) then
  leave.

hBuffer = ghQueryWindowListBrowse:query:get-buffer-handle(1).

if hBuffer:available then
  run qg_QueryWindowOpenRelatedQuery(hBuffer::WindowHandle).

end procedure.

PROCEDURE qg_QueryWindowListPasteQueryScenario :
apply 'choose':U to menu-item mi_PasteQueryScenario in menu m_Edit.

end procedure.

PROCEDURE qg_QueryWindowListQueryWindowAlwaysOnTop :
define variable hBuffer as handle    no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(ghQueryWindowListWindow) then
  leave.

hBuffer = ghQueryWindowListBrowse:query:get-buffer-handle(1).

if hBuffer:available then
do:

  find bttQueryWindow
    where bttQueryWindow.WindowHandle = hBuffer::WindowHandle
    no-lock no-error.

  bttQueryWindow.WindowHandle:always-on-top = not bttQueryWindow.WindowHandle:always-on-top.

end.

end procedure.

PROCEDURE qg_QueryWindowListRefresh :
define variable hQuery        as handle    no-undo.
define variable hBuffer       as handle    no-undo.

define variable rLine         as rowid     no-undo.
define variable hWindow       as handle    no-undo.
define variable hParentWindow as handle    no-undo.


define buffer bttQueryWindow     for temp-table ttQueryWindow.
define buffer bttQueryWindowView for temp-table ttQueryWindowView.

run qg_UpdateQueryWindowView.

if valid-handle(ghQueryWindowListWindow) then
do:

  assign
    hQuery      = ghQueryWindowListBrowse:query
    hBuffer     = hQuery:get-buffer-handle(1)
    .

  if hBuffer:available then
    assign
      rLine         = hBuffer:rowid
      hWindow       = hBuffer::windowHandle
      hParentWindow = hBuffer::ParentWindowHandle
      .

  qg_lQueryOpen(hQuery, 'for each ttQueryWindowView by Id':U, ghQueryWindowListWindow).

  if hWindow <> ? then
  do:

    find bttQueryWindowView
      where rowid(bttQueryWindowView) = rLine
      no-error.

    if not available bttQueryWindowView then
    do:

      find first bttQueryWindowView
        where bttQueryWindowView.ParentWindowHandle = hParentWindow
          and bttQueryWindowView.WindowHandle       = hWindow
        no-error.

      if not available bttQueryWindowView then
        find first bttQueryWindowView
          where bttQueryWindowView.WindowHandle = hWindow
          no-error.

    end.

    if available bttQueryWindowView then
      hQuery:reposition-to-rowid(rowid(bttQueryWindowView)) no-error.

  end.

end.

end procedure.

PROCEDURE qg_QueryWindowListSaveQueryScenario :
apply 'choose':U to menu-item mi_SaveQueryScenario in menu m_File.

end procedure.

PROCEDURE qg_QueryWindowListSelectQueryWindow :
define input parameter phWindow as handle    no-undo.

define variable hBuffer as handle    no-undo.

define buffer bttQueryWindowView for temp-table ttQueryWindowView.

if    valid-handle(ghQueryWindowListWindow)
  and valid-handle(phWindow) then
do:

  hBuffer = ghQueryWindowListBrowse:query:get-buffer-handle(1).

  if   not hBuffer:available
    or hBuffer::WindowHandle <> phWindow then
  do:

    find first bttQueryWindowView
      where bttQueryWindowView.WindowHandle = phWindow
      no-error.

    if available bttQueryWindowView then
      ghQueryWindowListBrowse:query:reposition-to-rowid(rowid(bttQueryWindowView)) no-error.

  end.

end.

end procedure.

PROCEDURE qg_QueryWindowListToggleAlwaysOnTop :
if not valid-handle(ghQueryWindowListWindow) then
  leave.

ghQueryWindowListWindow:always-on-top = not ghQueryWindowListWindow:always-on-top.

end procedure.

PROCEDURE qg_QueryWindowListToolsMenuDrop :
define variable hBuffer                        as handle    no-undo.

define variable hMenu                          as handle    no-undo.

define variable hMinimizeAllMenuItem           as handle    no-undo.
define variable hRestoreAllMenuItem            as handle    no-undo.
define variable hHideAllMenuItem               as handle    no-undo.
define variable hShowAllMenuItem               as handle    no-undo.
define variable hCloseAllMenuItem              as handle    no-undo.

define variable lQueryWindowsExist             as logical   no-undo.

if not valid-handle(ghQueryWindowListWindow) then
  leave.

assign
  lQueryWindowsExist = temp-table ttQueryWindow:has-records
  hBuffer            = ghQueryWindowListBrowse:query:get-buffer-handle(1)
  hMenu              = ghQueryWindowListWindow:menu-bar
  hMinimizeAllMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_MinimizeAll':U)
  hMinimizeAllMenuItem:sensitive
      = lQueryWindowsExist
  hRestoreAllMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_RestoreAll':U)
  hRestoreAllMenuItem:sensitive
      = lQueryWindowsExist
  hHideAllMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_HideAll':U)
  hHideAllMenuItem:sensitive
      = lQueryWindowsExist
  hShowAllMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_ShowAll':U)
  hShowAllMenuItem:sensitive
      = lQueryWindowsExist
  hCloseAllMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_CloseAll':U)
  hCloseAllMenuItem:sensitive
      = lQueryWindowsExist
  .

end procedure.

PROCEDURE qg_QueryWindowListWindowClose :
/**
 * Trigger procedure for window close event of query window list window.
 */

if valid-handle(ghQueryWindowListWindow) then
  run qg_DeleteWidgetTree(ghQueryWindowListWindow, yes).

end procedure.

PROCEDURE qg_QueryWindowListWindowMenuDrop :
/**
 * Trigger procedure for window close event of query window list window.
 */

define variable hMenu                as handle    no-undo.
define variable hAlwaysOnTopMenuItem as handle    no-undo.

if not valid-handle(ghQueryWindowListWindow) then
  leave.

assign
  hMenu                 = ghQueryWindowListWindow:menu-bar
  hAlwaysOnTopMenuItem
      = qg_hGetWidgetByName(hMenu,
                            'mi_AlwaysOnTop':U)
  hAlwaysOnTopMenuItem:checked
      = ghQueryWindowListWindow:always-on-top
  .

end procedure.

PROCEDURE qg_QueryWindowListWindowResize :
/**
 * Trigger procedure for window resize event of query window list window.
 */

define variable hFrame as handle    no-undo.

if not valid-handle(ghQueryWindowListWindow) then
  leave.

assign
  ghQueryWindowListWindow:width     = max(20, ghQueryWindowListWindow:width)
  ghQueryWindowListWindow:height    = max(3, ghQueryWindowListWindow:height)
  hFrame                            = qg_hGetWidgetByName(ghQueryWindowListWindow,
                                                          'fQueryWindows':U)
  hFrame:width                      = ghQueryWindowListWindow:width
  hFrame:virtual-width              = ghQueryWindowListWindow:width
  hFrame:height                     = ghQueryWindowListWindow:height
  hFrame:virtual-height             = ghQueryWindowListWindow:height
  ghQueryWindowListBrowse:width     = hFrame:width
  ghQueryWindowListBrowse:height    = hFrame:height
  .

end procedure.

PROCEDURE qg_QueryWindowMoveColumn :
/**
 * Move field column to first column.
 *
 * @param phWindow = Handle of the Query window.
 * @param plFirst = If yes the field will be moved to the first column. Otherwise it will be moved to the last column.
 */

define input parameter phWindow as handle    no-undo.
define input parameter plFirst  as logical   no-undo.

define variable hFieldSelectionBuffer as handle    no-undo.
define variable hColumn               as handle    no-undo.
define variable iSelection            as integer   no-undo.
define variable iColumn               as integer   no-undo.

define variable cFieldName            as character no-undo.
define variable cColumnName           as character no-undo.

define buffer bttQueryWindow  for temp-table ttQueryWindow.

define buffer bttFieldOverlay for temp-table ttFieldOverlay.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hFieldSelectionBuffer = bttQueryWindow.QueryFieldBrowseBufferHandle.

if plFirst then
do:

  do iSelection = bttQueryWindow.QueryFieldBrowseHandle:num-selected-rows to 1 by -1:

    bttQueryWindow.QueryFieldBrowseHandle:fetch-selected-row(iSelection).

    cFieldName = qg_cFormattedFieldName(?,
                                        hFieldSelectionBuffer::BufferName,
                                        hFieldSelectionBuffer::FieldName,
                                        hFieldSelectionBuffer::FieldIndex).

    do iColumn = 1 to bttQueryWindow.QueryBrowseHandle:num-columns:

      hColumn = bttQueryWindow.QueryBrowseHandle:get-browse-column(iColumn).

      find first bttFieldOverlay
        where bttFieldOverlay.OwnerHandle         = bttQueryWindow.QueryHandle
          and bttFieldOverlay.OverlayColumnHandle = hColumn
        no-error.

      if    available bttFieldOverlay
        and valid-handle(bttFieldOverlay.ColumnHandle)
        and not bttFieldOverlay.ColumnHandle:visible then
        hColumn = bttFieldOverlay.ColumnHandle.

      cColumnName = qg_cColumnFieldName(hColumn, yes).

      if cColumnName = cFieldName then
      do:

        bttQueryWindow.QueryBrowseHandle:move-column(iColumn, 1).
        leave.

      end.

    end.

  end.

end.

else
do:

  do iSelection = 1 to bttQueryWindow.QueryFieldBrowseHandle:num-selected-rows:

    bttQueryWindow.QueryFieldBrowseHandle:fetch-selected-row(iSelection).

    cFieldName = qg_cFormattedFieldName(?,
                                        hFieldSelectionBuffer::BufferName,
                                        hFieldSelectionBuffer::FieldName,
                                        hFieldSelectionBuffer::FieldIndex).

    do iColumn = 1 to bttQueryWindow.QueryBrowseHandle:num-columns:

      hColumn = bttQueryWindow.QueryBrowseHandle:get-browse-column(iColumn).

      find first bttFieldOverlay
        where bttFieldOverlay.OwnerHandle         = bttQueryWindow.QueryHandle
          and bttFieldOverlay.OverlayColumnHandle = hColumn
        no-error.

      if    available bttFieldOverlay
        and valid-handle(bttFieldOverlay.ColumnHandle)
        and not bttFieldOverlay.ColumnHandle:visible then
        hColumn = bttFieldOverlay.ColumnHandle.

      cColumnName = qg_cColumnFieldName(hColumn, yes).

      if cColumnName = cFieldName then
      do:

        bttQueryWindow.QueryBrowseHandle:move-column(iColumn, bttQueryWindow.QueryBrowseHandle:num-columns).
        leave.

      end.

    end.

  end.

end.

end procedure.

PROCEDURE qg_QueryWindowObjectIdOverlay :
define input parameter phWindow as handle    no-undo.

define variable lHidden                 as logical   no-undo.
define variable lSuggestions            as logical   no-undo.
define variable lSelected               as logical   no-undo.

define variable cField_Key              as character no-undo.
define variable cField_Label            as character no-undo.
define variable cAvailableColumn_Keys   as character no-undo.
define variable cAvailableColumn_Labels as character no-undo.
define variable cSelectedColumn_Keys    as character no-undo.
define variable lOk                     as logical   no-undo.

define variable i                       as integer   no-undo.

define variable cDatabaseName           as character no-undo.
define variable cBufferName             as character no-undo.
define variable cFieldName              as character no-undo.
define variable iFieldIndex             as integer   no-undo.
define variable cNewOverlayFields       as character no-undo.

define variable cOverlayFieldName       as character no-undo.
define variable cFieldOrder             as character no-undo.
define variable cColumns                as character no-undo.

define buffer bttQueryWindow      for temp-table ttQueryWindow.

define buffer bttField            for temp-table ttField.

define buffer bttQueryWindowField for temp-table ttQueryWindowField.
define buffer bttFieldOverlay     for temp-table ttFieldOverlay.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if    not available bttQueryWindow
   or not valid-handle(bttQueryWindow.QueryHandle) then
  leave.

// Show field overlay selection dialog.
lSuggestions = not can-find(first ttFieldOverlay
                              where ttFieldOverlay.OwnerHandle = bttQueryWindow.QueryHandle).

for each bttQueryWindowField
  where bttQueryWindowField.WindowHandle = bttQueryWindow.WindowHandle
    and bttQueryWindowField.IsOverlay    = no
  on error undo, throw:

  if lookup(bttQueryWindowField.DataType, 'CHARACTER,LONGCHAR':U) = 0 then
    next.

  assign
    lSelected               = (if not lSuggestions then
                                 can-find(ttFieldOverlay
                                            where ttFieldOverlay.OwnerHandle  = bttQueryWindow.QueryHandle
                                              and ttFieldOverlay.BufferName   = bttQueryWindowField.BufferName
                                              and ttFieldOverlay.FieldName    = bttQueryWindowField.FieldName
                                              and ttFieldOverlay.FieldIndex   = bttQueryWindowField.FieldIndex)
                               else
                                       ( bttQueryWindowField.FieldName matches '*_Obj':U
                                      or bttQueryWindowField.isObjectId )
                                   and not bttQueryWindowField.FieldName matches substitute('&1_Obj':U, bttQueryWindowField.TableName))
    cField_Key              = qg_cFormattedFieldName(?,
                                                     bttQueryWindowField.BufferName,
                                                     bttQueryWindowField.FieldName,
                                                     bttQueryWindowField.FieldIndex)
    cAvailableColumn_Keys   = substitute('&1,&2':U, cAvailableColumn_Keys, cField_Key)
    cField_Label            = qg_cFormattedFieldName(?,
                                                     (if    valid-handle(bttQueryWindow.QueryBrowseHandle)
                                                        and bttQueryWindow.QueryHandle:num-buffers > 1 then
                                                        bttQueryWindowField.BufferName
                                                      else
                                                        ?),
                                                     bttQueryWindowField.FieldName,
                                                     bttQueryWindowField.FieldIndex)
    cAvailableColumn_Labels = substitute('&1,&2':U,
                                         cAvailableColumn_Labels,
                                         (if   lSuggestions
                                            and lSelected then
                                            substitute('&1 *':U, cField_Label)
                                          else
                                            cField_Label))
    .

  if lSelected then
    cSelectedColumn_Keys = substitute('&1,&2':U, cSelectedColumn_Keys, cField_Key).

end.

assign
  cAvailableColumn_Keys   = trim(cAvailableColumn_Keys, ',':U)
  cAvailableColumn_Labels = trim(cAvailableColumn_Labels, ',':U)
  cSelectedColumn_Keys    = trim(cSelectedColumn_Keys, ',':U)
  .

run qg_SelectionDialog(cAvailableColumn_Keys,
                       cAvailableColumn_Labels,
                       input-output cSelectedColumn_Keys,
                       'Select overlay columns':T,
                       bttQueryWindow.WindowHandle,
                       no,
                       output lOk).

if lOk then
do on error undo, throw:

  cFieldOrder = qg_cQueryWindowFieldList(bttQueryWindow.WindowHandle,
                                         yes,
                                         no).

  if valid-handle(bttQueryWindow.QueryFrameHandle) then
    assign
      lHidden                                 = bttQueryWindow.QueryBrowseHandle:hidden
      bttQueryWindow.QueryBrowseHandle:hidden = yes
      cColumns                                = qg_cBrowseColumnList( bttQueryWindow.QueryBrowseHandle,
                                                                      yes,
                                                                      no,
                                                                      yes )
      .

  // Remove field overlay entries that are no longer selected.
  for each bttFieldOverlay
    where bttFieldOverlay.OwnerHandle = bttQueryWindow.QueryHandle
    no-lock
    on error undo, throw:

    if lookup(qg_cFormattedFieldName(?,
                                     bttFieldOverlay.BufferName,
                                     bttFieldOverlay.FieldName,
                                     bttFieldOverlay.FieldIndex),
              cSelectedColumn_Keys) > 0 then
      next.

    assign
      cFieldName        = qg_cFormattedFieldName(?,
                                                 bttFieldOverlay.BufferName,
                                                 bttFieldOverlay.FieldName,
                                                 bttFieldOverlay.FieldIndex)
      cOverlayFieldName = substitute({&K_OBJECTID_OVERLAY_NAME_PATTERN},
                                     cFieldName)
      cFieldOrder       = qg_cReplaceColumn(cFieldOrder,
                                            cOverlayFieldName,
                                            cFieldName)
      .

    if    valid-handle(bttQueryWindow.QueryFrameHandle)
      and valid-handle(bttFieldOverlay.ColumnHandle)
      and valid-handle(bttFieldOverlay.OverlayColumnhandle)
      and not bttFieldOverlay.ColumnHandle:visible then

      cColumns = qg_cReplaceColumn(cColumns,
                                   cFieldName,
                                   cOverlayFieldName).

    run qg_DeleteFieldOverlay(bttFieldOverlay.OwnerHandle,
                              bttFieldOverlay.BufferName,
                              bttFieldOverlay.FieldName,
                              bttFieldOverlay.FieldIndex).

  end.

  // Create field overlay entries for all selected fields.
  do i = 1 to num-entries(cSelectedColumn_Keys):

    run qg_SplitFieldName(entry(i, cSelectedColumn_Keys),
                          output cDatabaseName,
                          output cBufferName,
                          output cFieldName,
                          output iFieldIndex).

    find bttQueryWindowField
      where bttQueryWindowField.WindowHandle = bttQueryWindow.WindowHandle
        and bttQueryWindowField.BufferName   = cBufferName
        and bttQueryWindowField.FieldName    = cFieldName
        and bttQueryWindowField.FieldIndex   = iFieldIndex
      no-error.

    if not available bttQueryWindowField then
      next.

    find bttFieldOverlay
      where bttFieldOverlay.OwnerHandle = bttQueryWindow.QueryHandle
        and bttFieldOverlay.BufferName  = bttQueryWindowField.BufferName
        and bttFieldOverlay.FieldName   = bttQueryWindowField.FieldName
        and bttFieldOverlay.FieldIndex  = bttQueryWindowField.FieldIndex
      no-error.

    if not available bttFieldOverlay then
    do:

      create bttFieldOverlay.

      assign
        bttFieldOverlay.OwnerHandle  = bttQueryWindow.QueryHandle
        bttFieldOverlay.DatabaseName = bttQueryWindowField.DatabaseName
        bttFieldOverlay.BufferName   = bttQueryWindowField.BufferName
        bttFieldOverlay.FieldName    = bttQueryWindowField.FieldName
        bttFieldOverlay.FieldIndex   = bttQueryWindowField.FieldIndex
        .

      validate bttFieldOverlay.

      cNewOverlayFields = substitute('&1,&2':U,
                                     cNewOverlayFields,
                                     string(rowid(bttFieldOverlay))).

    end.

  end.

  cNewOverlayFields = trim(cNewOverlayFields, ',':U).

  // Update window field temp-table.
  do i = 1 to num-entries(cNewOverlayFields):

    find bttFieldOverlay
      where rowid(bttFieldOverlay) = to-rowid(entry(i, cNewOverlayFields))
      no-error.

    if not available bttFieldOverlay then
      next.

    assign
      cFieldName        = qg_cFormattedFieldName(?,
                                                 bttFieldOverlay.BufferName,
                                                 bttFieldOverlay.FieldName,
                                                 bttFieldOverlay.FieldIndex)
      cOverlayFieldName = substitute({&K_OBJECTID_OVERLAY_NAME_PATTERN},
                                     cFieldName)
      cFieldOrder       = qg_cReplaceColumn(cFieldOrder,
                                            cFieldName,
                                            cOverlayFieldName)
      .

    if valid-handle(bttQueryWindow.QueryFrameHandle) then
      cColumns = qg_cReplaceColumn(cColumns,
                                   cFieldName,
                                   cOverlayFieldName).

  end.

  run qg_QueryWindowUpdateFieldTempTable(bttQueryWindow.QueryHandle,
                                         bttQueryWindow.WindowHandle,
                                         cFieldOrder).

  // Update browse columns (if necessary).
  if valid-handle(bttQueryWindow.QueryFrameHandle) then
  do:

    // For some reason deleting query buffers also removes the query from the
    // query browse handle. Due to this we have to set it again.

    bttQueryWindow.QueryBrowseHandle:query = bttQueryWindow.QueryHandle.

    run qg_QueryWindowQueryOpenFieldQuery(bttQueryWindow.WindowHandle).

    run qg_QueryWindowRefreshBrowseColumns(bttQueryWindow.WindowHandle).
    run qg_SetBrowseColumns(bttQueryWindow.QueryBrowseHandle, cColumns).

  end.

  if valid-handle(bttQueryWindow.RecordFrameHandle) then
  do:

    run qg_QueryWindowRecordOpenQuery(bttQueryWindow.WindowHandle).
    run qg_QueryWindowRecordRefresh(bttQueryWindow.WindowHandle).

  end.

  finally:

    if valid-handle(bttQueryWindow.QueryFrameHandle) then
      bttQueryWindow.QueryBrowseHandle:hidden = lHidden.

  end finally.

end.

end procedure.

PROCEDURE qg_QueryWindowObjSelectionBrowseClick :
define input parameter phWindow as handle    no-undo.

define variable hCurrentWindow as handle    no-undo.

define variable hBrowse        as handle    no-undo.
define variable hBuffer        as handle    no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow:parent
  no-error.

if not available bttQueryWindow then
  leave.

assign
  hCurrentWindow = current-window
  current-window = bttQueryWindow.WindowHandle
  hBrowse        = qg_hGetWidgetByName(phWindow, 'brObjField':U)
  .

if not valid-handle(hBrowse) then
  leave.

hBuffer = hBrowse:query:get-buffer-handle(1).

if    valid-handle(hBuffer)
  and hBuffer:available then
do:

  assign
    bttQueryWindow.ObjSourceBufferName = hBuffer::BufferName
    bttQueryWindow.ObjSourceFieldName  = hBuffer::FieldName
    bttQueryWindow.ObjSourceFieldIndex = hBuffer::FieldIndex
    .

  run qg_QueryWindowObjUpdateObjFieldText(bttQueryWindow.WindowHandle).

  run qg_QueryWindowObjUpdateQuery(bttQueryWindow.WindowHandle).

  run qg_QueryWindowUpdateAll('':U).

end.

apply 'window-close':U to phWindow.

finally:

  if valid-handle(hCurrentWindow) then
    current-window = hCurrentWindow.

end finally.

end procedure.

PROCEDURE qg_QueryWindowObjSelectionBrowseRowDisplay :
define input parameter phWindow as handle    no-undo.

define variable hBrowse  as handle    no-undo.
define variable hBuffer  as handle    no-undo.

define variable i        as integer   no-undo.
define variable cColList as character no-undo.
define variable hColumn  as handle    no-undo.
define variable iColor   as integer   no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow:parent
  no-error.

if not available bttQueryWindow then
  leave.

hBrowse = qg_hGetWidgetByName(phWindow, 'brObjField':U).

if not valid-handle(hBrowse) then
  leave.

assign
  cColList = qg_cParamListReadValue(hBrowse:private-data,
                                    'ColList':U,
                                    ',':U)
  hBuffer  = handle(qg_cParamListReadValue(hBrowse:private-data,
                                           'Buffer':U,
                                           ',':U))
  .

iColor = (if    not valid-handle(hBuffer)
             or not hBuffer:available then
            {&K_COLOR_LIGHT_GREY}
          //else if hBuffer::IsVirtual then
          //{&K_VIRTUAL_DB_FIELD_FGCOLOR}
          else if hBuffer::ContainsObj then
            ?
          else if hBuffer::IsObjectId then
            {&K_COLOR_DARK_GREY}
          else
            {&K_COLOR_LIGHT_GREY}).

do i = 1 to num-entries(cColList, '|':U):

  assign
    hColumn         = handle(entry(i, cColList, '|':U))
    hColumn:fgcolor = iColor
    .

end.

end procedure.

PROCEDURE qg_QueryWindowObjSelectionWindowClose :
define input parameter phWindow as handle    no-undo.

define variable hParentWindow as handle    no-undo.
define variable hButton       as handle    no-undo.

assign
  hParentWindow = phWindow:parent
  hButton       = qg_hGetWidgetByName(hParentWindow,
                                      'btnSelectObjField':U)
  .

run qg_DeleteWidgetTree(phWindow, yes).

if valid-handle(hButton) then
  hButton:sensitive = yes.

apply 'entry':U to hParentWindow.

end procedure.

PROCEDURE qg_QueryWindowObjSelectObjField :
/**
 *
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.

define variable hTemp      as handle    no-undo.
define variable hButton    as handle    no-undo.

define variable hWindow    as handle    no-undo.
define variable hFrame     as handle    no-undo.
define variable hBrowse    as handle    no-undo.

define variable hQuery     as handle    no-undo.
define variable hBuffer    as handle    no-undo.

define variable cQueryText as character no-undo.

define variable i          as integer   no-undo.
define variable cColList   as character no-undo.

define buffer bttQueryWindow         for temp-table ttQueryWindow.

define buffer bttQueryWindowObjField for temp-table ttQueryWindowObjField.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hButton = qg_hGetWidgetByName(bttQueryWindow.RecordFrameHandle,
                              'btnSelectObjField':U).

if not valid-handle(hButton) then
  leave.

create window hWindow
  assign
    hidden          = yes
    width           = 64
    max-width       = 1024
    height          = 15
    max-height      = 1024
    scroll-bars     = no
    status-area     = no
    three-d         = yes
    message-area    = no
    control-box     = no
    small-title     = yes
    show-in-taskbar = no
    top-only        = yes
    sensitive       = yes
    resize          = no
    parent          = bttQueryWindow.WindowHandle
    title           = substitute('&1Select object id field':U, gcTitlePrefix)
  triggers:

    on leave
      persistent run qg_QueryWindowObjSelectionWindowClose in target-procedure
                       (hWindow).

    on window-close
      persistent run qg_QueryWindowObjSelectionWindowClose in target-procedure
                       (hWindow).

  end triggers
  .

create frame hFrame
  assign
    name           = 'fObjField':U
    box            = no
    three-d        = yes
    width          = hWindow:width
    virtual-width  = hWindow:width
    height         = hWindow:height
    virtual-height = hWindow:height
    sensitive      = yes
    parent         = hWindow
    .

create browse hBrowse
  assign
    name                   = 'brObjField':U
    frame                  = hFrame
    width                  = hFrame:width - 2
    height                 = hFrame:height - 0.5
    row                    = 1.25
    col                    = 2
    read-only              = yes
    row-markers            = no
    allow-column-searching = no
  triggers:

    on mouse-select-click
      persistent run qg_QueryWindowObjSelectionBrowseClick in target-procedure
                       (hWindow).

    on row-display
      persistent run qg_QueryWindowObjSelectionBrowseRowDisplay in target-procedure
                       (hWindow).


  end triggers
  .

run qg_InitBrowse(hBrowse).

run qg_DropDownWindow(hWindow, hButton, {&K_DIRECTION_RIGHT}).

create query hQuery.

create buffer hBuffer for table 'ttQueryWindowObjField':U.

hQuery:set-buffers(hBuffer).

run qg_QueryWindowObjUpdateFieldList(bttQueryWindow.WindowHandle).

assign
  cQueryText =            'for each ttQueryWindowObjField':U
               + '~n':U + '  where ttQueryWindowObjField.WindowHandle = &1':U
               + '~n':U + '  use-index priority':U
  cQueryText = substitute(cQuerytext, quoter(bttQueryWindow.WindowHandle))
  .

assign
  hButton:sensitive = no
  hWindow:hidden    = no
  hFrame:hidden     = no
  .

hBrowse:query = hQuery.

assign
  hTemp       = hBrowse:add-like-column('ttQueryWindowObjField.BufferName':U)
  hTemp:width = 25
  cColList    = string(hTemp) 
  hTemp       = hBrowse:add-like-column('ttQueryWindowObjField.DisplayName':U)
  hTemp:width = 32
  cColList    = substitute('&1|&2':U, cColList, string(hTemp))
  hTemp       = hBrowse:add-like-column('ttQueryWindowObjField.TargetTableName':U)
  hTemp:width = 25
  cColList    = substitute('&1|&2':U, cColList, string(hTemp))
  .

assign
  hBrowse:labels          = no
  hBrowse:fit-last-column = yes
  hBrowse:private-data    = qg_cParamListWriteCharacter(hBrowse:private-data,
                                                        'ColList':U,
                                                        cColList,
                                                        ',':U)
  hBrowse:private-data    = qg_cParamListWriteCharacter(hBrowse:private-data,
                                                        'Buffer':U,
                                                        string(hBuffer),
                                                        ',':U)
  .

qg_lQueryOpen(hQuery, cQueryText, hWindow).

find bttQueryWindowObjField
  where bttQueryWindowObjField.WindowHandle = bttQueryWindow.WindowHandle
    and bttQueryWindowObjField.BufferName   = bttQueryWindow.ObjSourceBufferName
    and bttQueryWindowObjField.FieldName    = bttQueryWindow.ObjSourceFieldName
    and bttQueryWindowObjField.FieldIndex   = bttQueryWindow.ObjSourceFieldIndex
  no-error.

if available bttQueryWindowObjField then
  hQuery:reposition-to-rowid(rowid(bttQueryWindowObjField)).

apply 'value-changed':U to hBrowse.
apply 'entry':U to hBrowse.

end procedure.

PROCEDURE qg_QueryWindowObjUpdateObjFieldText :
/**
 *
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.

define variable cObjFieldLabel as character no-undo.

define variable hObjFieldText  as handle    no-undo.
define variable hRefreshButton as handle    no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

assign
  hRefreshButton             = qg_hGetWidgetByName(bttQueryWindow.RecordFrameHandle,
                                                   'btnRefresh':U)
  hObjFieldText              = qg_hGetWidgetByName(bttQueryWindow.RecordFrameHandle,
                                                   'cObjField':U)
  cObjFieldLabel             = qg_cFormattedFieldName(?,
                                                      bttQueryWindow.ObjSourceBufferName,
                                                      bttQueryWindow.ObjSourceFieldName,
                                                      bttQueryWindow.ObjSourceFieldIndex)
  hObjFieldText:screen-value = cObjFieldLabel
  hObjFieldText:width        = max(10, font-table:get-text-width-chars(cObjFieldLabel))
  hRefreshButton:col         = hObjFieldText:col + hObjFieldText:width + 5
  no-error.

end procedure.

PROCEDURE qg_QueryWindowObjUpdateQuery :
/**
 *
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.

define variable hBuffer            as handle    no-undo.
define variable hField             as handle    no-undo.
define variable cDatabaseName      as character no-undo.
define variable cTableName         as character no-undo.
define variable lObjectId          as logical   no-undo.
define variable cFieldValue        as character no-undo.
define variable cTableRef          as character no-undo.
define variable cTables            as character no-undo.

define variable hObFieldText       as handle    no-undo.

define buffer bttQueryWindow         for temp-table ttQueryWindow.
define buffer bttQueryWindowObjField for temp-table ttQueryWindowObjField.

define buffer b2ttQueryWindow        for temp-table ttQueryWindow.
define buffer bttDatabase            for temp-table ttDatabase.
define buffer bttTable               for temp-table ttTable.
define buffer bttField               for temp-table ttField.

define buffer bttQueryLink           for temp-table ttQueryLink.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

find b2ttQueryWindow
  where b2ttQueryWindow.QuerySeq = bttQueryWindow.ObjSourceQuerySeq
  no-error.

if   not available b2ttQueryWindow
  or not valid-handle(b2ttQueryWindow.QueryHandle) then
  leave.

hBuffer = b2ttQueryWindow.QueryHandle:get-buffer-handle(bttQueryWindow.ObjSourceBufferName) no-error.

if valid-handle(hBuffer) then
  cDatabaseName = qg_cDatabaseNameForTableOrBuffer( hBuffer ).

else
do:

  run qg_QueryWindowObjUpdateFieldList(bttQueryWindow.WindowHandle).

  find first bttQueryWindowObjField
    where bttQueryWindowObjField.WindowHandle = bttQueryWindow.WindowHandle
    use-index Priority
    no-error.

  if not available bttQueryWindowObjField then
    leave.

  hBuffer = b2ttQueryWindow.QueryHandle:get-buffer-handle(bttQueryWindowObjField.BufferName) no-error.

  if not valid-handle(hBuffer) then

    leave.

  assign
    cDatabaseName                      = bttQueryWindowObjField.DatabaseName
    bttQueryWindow.ObjSourceBufferName = bttQueryWindowObjField.BufferName
    bttQueryWindow.ObjSourceFieldName  = bttQueryWindowObjField.FieldName
    bttQueryWindow.ObjSourceFieldIndex = bttQueryWindowObjField.FieldIndex
    bttQueryWindow.ObjTargetTableId    = '':U
    bttQueryWindow.ObjTargetTableName  = '':U
    .

  if valid-handle(bttQueryWindow.RecordFrameHandle) then

    run qg_QueryWindowObjUpdateObjFieldText(bttQueryWindow.WindowHandle).

end.

find bttDatabase
  where bttDatabase.DatabaseName = cDatabaseName
  no-error.

if not available bttDatabase then
  find bttDatabase
    where bttDatabase.DatabaseName = hBuffer:dbname
    no-error.

if not available bttDatabase then
  leave.

if hBuffer:available then
do:

  hField = hBuffer:buffer-field( bttQueryWindow.ObjSourceFieldName ) no-error.

  if valid-handle( hField ) then

    cFieldValue = hField:buffer-value( bttQueryWindow.ObjSourceFieldIndex ) no-error.

  else

    if qg_lIsPhysicalDatabase( hBuffer:dbname ) then
    do:

      find bttField
        where bttField.DatabaseName = cDatabaseName
          and bttField.TableName    = hBuffer:table
          and bttField.FieldName    = bttQueryWindow.ObjSourceFieldName
        no-error.

      if    available bttField
        and bttField.IsVirtual then

        cFieldValue = qg_clVirtualFieldValueAsLongchar( bttField.FieldType,
                                                        bttField.DataType,
                                                        bttField.FieldName,
                                                        qg_cObjectIdForBuffer( hBuffer ),
                                                        ? ).

    end.

end.

assign
  lObjectId =     length(cFieldValue)            <= 50
              and num-entries(cFieldValue, ':':U) = 3
  cTableRef = (if lObjectId then
                 entry(1, cFieldValue, ':':U)
               else if bttQueryWindow.ObjSourceFieldName matches '*_Obj':U then
                 substring(bttQueryWindow.ObjSourceFieldName,
                           1,
                           length(bttQueryWindow.ObjSourceFieldName) - 4)
               else
                 '':U)
  .

if    (     lObjectId
        and cTableRef <> bttQueryWindow.ObjTargetTableId )
   or (     not lObjectId
        and cTableRef <> bttQueryWindow.ObjTargetTableName )
   or not valid-handle(bttQueryWindow.QueryHandle) then
do:

  run qg_GetObjectIdTable(bttDatabase.DatabaseName,
                          (if lObjectId then
                             cFieldValue
                           else
                             bttQueryWindow.ObjSourceFieldName),
                          output cDatabaseName,
                          output cTableName).

  find bttTable
    where bttTable.DatabaseName = cDatabaseName
      and bttTable.TableName    = cTableName
    no-error.

  if not available bttTable then
    assign
      bttQuerywindow.ObjTargetTableId   = '':U
      bttQuerywindow.ObjTargetTableName = '':U
      bttQueryWindow.QueryText          = '':U
      cTables                           = '':U
      .

  else
    assign
      bttQuerywindow.ObjTargetTableId   = bttTable.InternalIdentifier
      bttQuerywindow.ObjTargetTableName = bttTable.TableName
      bttQueryWindow.QueryText          = substitute('for each &1~n  where &1.&1_Obj = &2':U,
                                                     bttTable.TableName,
                                                     substitute('$~{&1:&2~}':U,
                                                               string(bttQueryWindow.ObjSourceQuerySeq),
                                                               qg_cFormattedFieldName(?,
                                                                                      bttQueryWindow.ObjSourceBufferName,
                                                                                      bttQueryWindow.ObjSourceFieldName,
                                                                                      bttQueryWindow.ObjSourceFieldIndex)))
      cTables = substitute('&1.&2':U,
                           bttTable.DatabaseName,
                           bttTable.TableName)
      .

  validate bttQuerywindow.

  if valid-handle(bttQueryWindow.QueryFrameHandle) then
    bttQueryWindow.QueryTextEditorHandle:screen-value = bttQueryWindow.QueryText.

  run qg_QueryWindowUpdateQuery(bttQueryWindow.WindowHandle, cTables).

  run qg_ParseQueryLinks(bttQueryWindow.QueryText,
                         bttQueryWindow.QuerySeq,
                         temp-table ttQueryLink:handle).

  if not can-find(first ttQueryLink
                    where ttQueryLink.TargetSeq = bttQueryWindow.QuerySeq
                      and ttQueryLink.SourceSeq = b2ttQueryWindow.QuerySeq) then
  do:

    create bttQueryLink.

    assign
      bttQueryLink.TargetSeq = bttQueryWindow.QuerySeq
      bttQueryLink.SourceSeq = b2ttQueryWindow.QuerySeq
      .

    validate bttQueryLink.

  end.

  run qg_QueryWindowListRefresh.

end.

end procedure.

PROCEDURE qg_QueryWindowObjUpdateFieldList :
/**
 *
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.

define variable iQueryBufferCounter as integer   no-undo.
define variable iFieldCounter       as integer   no-undo.
define variable iFieldIndexCounter  as integer   no-undo.
define variable hBuffer             as handle    no-undo.
define variable hField              as handle    no-undo.

define variable cDatabaseName       as character no-undo.
define variable clFieldValue        as longchar  no-undo.

define buffer bttQueryWindow         for temp-table ttQueryWindow.

define buffer b2ttQueryWindow        for temp-table ttQueryWindow.
define buffer bttQueryWindowObjField for temp-table ttQueryWindowObjField.
define buffer bttField               for temp-table ttField.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

for each bttQueryWindowObjField
  where bttQueryWindowObjField.WindowHandle = bttQueryWindow.WindowHandle
  on error undo, throw:

  delete bttQueryWindowObjField.

end.

find b2ttQueryWindow
  where b2ttQueryWindow.QuerySeq = bttQueryWindow.ObjSourceQuerySeq
  no-error.

if   not available b2ttQueryWindow
  or not valid-handle(b2ttQueryWindow.QueryHandle) then
  leave.

do iQueryBufferCounter = 1 to b2ttQueryWindow.QueryHandle:num-buffers:

  assign
    hBuffer       = b2ttQueryWindow.QueryHandle:get-buffer-handle(iQueryBufferCounter)
    cDatabaseName = qg_cDatabaseNameForTableOrBuffer( hBuffer ).
    .

  do iFieldCounter = 1 to hBuffer:num-fields:

    hField = hBuffer:buffer-field( iFieldCounter ).

    if not hField:data-type = 'CHARACTER':U then

      next.

    do iFieldIndexCounter = integer(hField:extent > 0) to hField:extent:

      run qg_AddFieldToQueryWindowObjFieldTempTable( buffer bttQueryWindow,
                                                     cDatabaseName,
                                                     hBuffer:name,
                                                     hBuffer:table,
                                                     hField:name,
                                                     iFieldIndexCounter,
                                                     ( if hBuffer:available then
                                                         hField:string-value( iFieldIndexCounter )
                                                       else
                                                         ? ) ).

      validate bttQueryWindowObjField.

    end.

  end.

  if qg_lIsPhysicalDatabase( hBuffer:dbname ) then

    for each bttField
      where bttField.DatabaseName = cDatabaseName
        and bttField.TableName    = hBuffer:table
        and bttField.IsVirtual    = yes
      on error undo, throw:

      clFieldValue = qg_clVirtualFieldValueAsLongchar( bttField.FieldType,
                                                       bttField.DataType,
                                                       bttField.FieldName,
                                                       qg_cObjectIdForBuffer( hBuffer ),
                                                       ? ).

      run qg_AddFieldToQueryWindowObjFieldTempTable( buffer bttQueryWindow,
                                                     bttField.DatabaseName,
                                                     hBuffer:name,
                                                     bttField.TableName,
                                                     bttField.FieldName,
                                                     0,
                                                     string( clFieldValue ) ).

    end.

end.

end procedure.

PROCEDURE qg_QueryWindowOpenObjectFieldValues :
/**
 *
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow   as handle    no-undo.

define variable cParamList as character no-undo.
define variable iQuerySeq  as integer   no-undo init ?.

define buffer bttQueryWindow  for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

cParamList = qg_cParamListWriteInteger(cParamList,
                                       'ObjSourceQuerySeq':U,
                                       bttQueryWindow.QuerySeq,
                                       {&K_PARAM_SPLITTER}).

run qg_ExecQuery({&K_QUERY_WINDOW_MODE_RECORD},
                 {&K_RECORD_SIZE_MODE_DEFAULT},
                 ?,
                 ?,
                 no,  /* Init mode */
                 cParamList,
                 input-output iQuerySeq).

end procedure.

PROCEDURE qg_QueryWindowOpenRelatedQuery :
/**
 *
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.

define variable hBuffer       as handle    no-undo.
define variable cDatabaseName as character no-undo.

define variable iFilterId     as integer   no-undo.

define buffer bttQueryWindow       for temp-table ttQueryWindow.

define buffer bttTableRelationView for temp-table ttTableRelationView.
define buffer bttFilterMatch       for temp-table ttFilterMatch.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if not valid-handle(bttQueryWindow.QueryHandle) then
  leave.

define query brTableRelation
  for bttTableRelationView,bttFilterMatch
  scrolling.

define browse brTableRelation
  query brTableRelation no-lock
    display
      bttTableRelationView.RelatedTableName
      bttTableRelationView.RelationType width 8
      bttTableRelationView.ReferenceFields
      with no-assign fit-last-column size 96 by 16.

define variable cFilter as character no-undo
  format 'x(1024)':U
  view-as fill-in
  tooltip "Filter for related tables that match given name pattern (comma separated)"
  size 89 by 1.

define button btnClearFilter
  label '':T
  tooltip "Clear filter"
  size 7 by 1.

define variable cRelationFields as character no-undo
  format 'x(1024)':U
  view-as fill-in
  size 96 by 1.

define button btnOk
  label 'Ok':T2
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.

// Define frame.
define frame fTableRelation
  cFilter at row 1.5 col 3 no-label
  btnClearFilter at row 1.5 col 92
  brTableRelation at row 2.5 col 3
  cRelationFields at row 19 col 3 no-label no-tab-stop
  btnOk at row 21 col 31
  btnCancel at row 21 col 51
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    title gcTitlePrefix + 'Select table relation':U
    side-labels no-underline three-d 
    size 101 by 22.94
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fTableRelation
  apply 'end-error' to self.

on off-home of brTableRelation in frame fTableRelation
do:
  apply 'entry':U to cFilter in frame fTableRelation.
  return no-apply.
end.

on cursor-down of cFilter in frame fTableRelation
do:
  apply 'entry':U to brTableRelation in frame fTableRelation.
  browse brTableRelation:select-focused-row().
  return no-apply.
end.

on cursor-down of btnClearFilter in frame fTableRelation
do:
  apply 'entry':U to brTableRelation in frame fTableRelation.
  browse brTableRelation:select-focused-row().
  return no-apply.
end.

on value-changed of cFilter in frame fTableRelation
do:

  define variable cFilterEntry as character no-undo.
  define variable cPrepFilter  as character no-undo.

  define variable i            as integer       no-undo.

  cFilter = input frame fTableRelation cFilter.

  do i = 1 to num-entries(cFilter):

    assign
      cFilterEntry = entry(i, cFilter).
      cPrepFilter  = substitute('&1,&2':U,
                                cPrepFilter,
                                qg_cFilterEntryMatchcode(cFilterEntry))
      .

  end.

  cPrepFilter = (if cPrepFilter = '':U then
                   '*':U
                 else
                   trim(cPrepFilter, ',':U)).

  for each bttTableRelationView
    where bttTableRelationView.DatabaseName       = cDatabaseName
      and bttTableRelationView.ReferenceTableName = hBuffer:table,
  first bttFilterMatch
    where bttFilterMatch.FilterId    = iFilterId
      and bttFilterMatch.RecordRowId = rowid(bttTableRelationView)
    on error undo, throw:

    bttFilterMatch.RecordMatches = can-do(cPrepFilter, bttTableRelationView.RelatedTableName).

  end.

  open query brTableRelation
    for each bttTableRelationView
      where bttTableRelationView.DatabaseName       = cDatabaseName
        and bttTableRelationView.ReferenceTableName = hBuffer:table,
    first bttFilterMatch
      where bttFilterMatch.FilterId      = iFilterId
        and bttFilterMatch.RecordRowId   = rowid(bttTableRelationView)
        and bttFilterMatch.RecordMatches = yes
      by bttTableRelationView.RelatedTableName
      by bttTableRelationView.RelationId
      .

  apply 'value-changed':U to browse brTableRelation.

end.

on choose of btnClearFilter in frame fTableRelation
do:

  display unless-hidden
    '':U @ cFilter
    with frame fTableRelation.

  apply 'value-changed':U to cFilter in frame fTableRelation.

end.

on default-action of browse brTableRelation
  apply 'go':U to frame fTableRelation.

on value-changed of browse brTableRelation
do:

  cRelationFields = (if available bttTableRelationView then
                       bttTableRelationView.FieldDetails
                     else
                       '':U).

  display unless-hidden
    cRelationFields
    with frame fTableRelation.

end.

run qg_InitBrowse(browse brTableRelation:handle).

assign
  hBuffer       = bttQueryWindow.QueryHandle:get-buffer-handle(1)
  cDatabaseName = qg_cDatabaseNameForTableOrBuffer( hBuffer )
  iFilterId     = qg_iFilterSeq()
  .

for each bttTableRelationView
  where bttTableRelationView.DatabaseName       = cDatabaseName
    and bttTableRelationView.ReferenceTableName = hBuffer:table
  on error undo, throw:

  create bttFilterMatch.

  assign
    bttFilterMatch.FilterId      = iFilterId
    bttFilterMatch.RecordRowId   = rowid(bttTableRelationView)
    bttFilterMatch.RecordMatches = yes
    .

  validate bttFilterMatch.

end.

open query brTableRelation
  for each bttTableRelationView
    where bttTableRelationView.DatabaseName       = cDatabaseName
      and bttTableRelationView.ReferenceTableName = hBuffer:table,
  first bttFilterMatch
    where bttFilterMatch.FilterId      = iFilterId
      and bttFilterMatch.RecordRowId   = rowid(bttTableRelationView)
      and bttFilterMatch.RecordMatches = yes
    by bttTableRelationView.RelatedTableName
    by bttTableRelationView.RelationId
    .

cRelationFields:read-only in frame fTableRelation = yes.

update unless-hidden
  cFilter
  btnClearFilter
  brTableRelation
  cRelationFields
  btnOk
  btnCancel
  with frame fTableRelation
    in window bttQueryWindow.WindowHandle. 

if available bttTableRelationView then
  run qg_OpenRelatedQueryWindow(bttQueryWindow.WindowHandle,
                                bttTableRelationView.RelationId,
                                bttTableRelationView.ParentRelation).

finally:

  if iFilterId > 0 then
  do:

    for each bttFilterMatch
      where bttFilterMatch.FilterId = iFilterId
      on error undo, throw:

      delete bttFilterMatch.

    end.

  end.

end finally.

end procedure.

PROCEDURE qg_QueryWindowOpenRecordWindow :
/**
 *
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow   as handle    no-undo.
define input parameter piLinkMode as integer   no-undo.

define variable i                  as integer   no-undo.
define variable hBuffer            as handle    no-undo.
define variable hField             as handle    no-undo.
define variable cDatabaseName      as character no-undo.
define variable cTargetTableName   as character no-undo.
define variable cFieldList         as character no-undo.
define variable cValueList         as character no-undo.
define variable cExternalReference as character no-undo.
define variable cQueryText         as character no-undo.
define variable iQuerySeq          as integer   no-undo init ?.

define buffer bttQueryWindow for temp-table ttQueryWindow.
define buffer bttIndex       for temp-table ttIndex.
define buffer bttIndexField  for temp-table ttIndexField.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if not valid-handle(bttQueryWindow.QueryHandle) then
  leave.

case piLinkMode:

  when {&K_QUERY_WINDOW_LINK_MODE_FIX_ROWID} then
  do:

    do i = 1 to bttQueryWindow.QueryHandle:num-buffers:

      hBuffer = bttQueryWindow.QueryHandle:get-buffer-handle(i).

      if not hBuffer:available then
        return.

      assign
        cDatabaseName    = qg_cDatabaseNameForTableOrBuffer( hBuffer )
        cTargetTableName = hBuffer:table
        cQueryText       = substitute('&1&2~nfor each &3~n  where rowid(&3) = to-rowid(&4)':U,
                                      cQueryText,
                                      (if i > 1 then
                                         ',':U
                                       else
                                         '':U),
                                      hBuffer:table,
                                      quoter(hBuffer:rowid))
        .

    end.

  end.

  when {&K_QUERY_WINDOW_LINK_MODE_FIX_INDEX} then
  do:

    do i = 1 to bttQueryWindow.QueryHandle:num-buffers:

      hBuffer = bttQueryWindow.QueryHandle:get-buffer-handle(i).

      if not hBuffer:available then
        return.

      assign
        cDatabaseName    = qg_cDatabaseNameForTableOrBuffer( hBuffer )
        cTargetTableName = hBuffer:table
        cQueryText       = substitute('&1&2~n&3each &4':U,
                                      cQueryText,
                                      (if i > 1 then
                                         ',':U
                                       else
                                         '':U),
                                      (if i = 1 then
                                         'for ':U
                                       else
                                         '':U),
                                      hBuffer:table)
        .

      find first bttIndex
        where bttIndex.DatabaseName = cDatabaseName
          and bttIndex.TableName    = hBuffer:table
          and bttIndex.IsPrimary    = true
          and bttIndex.IsUnique     = true
        no-error.

      if not available bttIndex then
        find first bttIndex
          where bttIndex.DatabaseName = cDatabaseName
            and bttIndex.TableName    = hBuffer:table
            and bttIndex.IsUnique     = true
          no-error.

      if available bttIndex then
      do:

        assign
          cFieldList = '':U
          cValueList = '':U
          .

        for each bttIndexField
          where bttIndexField.DatabaseName = bttIndex.DatabaseName
            and bttIndexField.TableName    = bttIndex.TableName
            and bttIndexField.IndexName    = bttIndex.IndexName
          by bttIndexField.IndexSequence
          on error undo, throw:

          assign
            cFieldList = substitute('&1,&2':U,
                                    cFieldList,
                                    bttIndexField.FieldName)
            hField     = hBuffer:buffer-field(bttIndexField.FieldName)
            cValueList = substitute('&1&2&3':U,
                                    cValueList,
                                    {&K_PARAM_SPLITTER},
                                    (if hField:data-type = 'CHARACTER':U then
                                       quoter(hField:buffer-value)
                                     else
                                       hField:buffer-value))
            .

        end.

        assign
          cFieldList = trim(cFieldList, ',':U)
          cValueList = trim(cValueList, {&K_PARAM_SPLITTER})
          cQueryText = substitute( '&1~n&2~n':U,
                                   cQueryText,
                                   qg_cCreateWhereClause( /* pcDatabaseName   */ bttIndex.DatabaseName,
                                                          /* pcTableNames     */ bttIndex.TableName,
                                                          /* pcBufferNames    */ bttIndex.TableName,
                                                          /* pcFieldList      */ cFieldList,
                                                          /* pcFieldLabelList */ ?,
                                                          /* plStartWithWhere */ yes,
                                                          /* piValueMode      */ {&K_VALUE_MODE_PARAMETER},
                                                          /* pcValueList      */ cValueList,
                                                          /* piAccessMode     */ {&K_ACCESS_MODE_PHYSICAL},
                                                          /* plAddTags        */ no,
                                                          /* piIndentBlanks   */ 2 ) )
          .


      end.

    end.

  end.

  when {&K_QUERY_WINDOW_LINK_MODE_LINKED} then
  do:

    do i = 1 to bttQueryWindow.QueryHandle:num-buffers:

      assign
        hBuffer          = bttQueryWindow.QueryHandle:get-buffer-handle(i)
        cDatabaseName    = qg_cDatabaseNameForTableOrBuffer( hBuffer )
        cTargetTableName = hBuffer:table
        cQueryText       = substitute('&1&2~nfor each &3~n  where rowid(&3) = &4':U,
                                      cQueryText,
                                      (if i > 1 then
                                         ',':U
                                       else
                                         '':U),
                                      hBuffer:table,
                                      substitute('$~{&1:rowid(&2)~}':U,
                                                 bttQueryWindow.QuerySeq,
                                                 hBuffer:name))
        .

    end.

  end.

end case.

run qg_ExecQuery({&K_QUERY_WINDOW_MODE_RECORD},
                 {&K_RECORD_SIZE_MODE_DEFAULT},
                 substitute('&1.&2':U, cDatabaseName, cTargetTableName),
                 trim(cQueryText),
                 no,  /* Init mode */
                 '':U,
                 input-output iQuerySeq).

end procedure.

PROCEDURE qg_QueryWindowQueryBrowseCopy :
/**
 *
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.

define variable iKeyState as integer   no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

run GetKeyState( {&K_WIN_CONST_VK_SHIFT}, output iKeyState ).

if    iKeyState < 0
   or not valid-handle( bttQueryWindow.QueryBrowseSelectedColumn ) then

  run qg_QueryWindowCopyRecordValues( phWindow ).

else

  run qg_QueryWindowQueryBrowseCopySelectedColumnValue( phWindow, yes ).

end procedure.

PROCEDURE qg_QueryWindowQueryBrowseCopySelectedColumnValue :
/**
 *
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.
define input parameter plRaw    as logical   no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if not valid-handle( bttQueryWindow.QueryBrowseSelectedColumn ) then
  leave.

clipboard:value = ( if plRaw then
                      bttQueryWindow.QueryBrowseSelectedColumn:input-value
                    else
                      bttQueryWindow.QueryBrowseSelectedColumn:screen-value ).

end procedure.

PROCEDURE qg_QueryWindowQueryBrowseDefaultAction :
/**
 * Default action trigger of query browse.
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.

define variable hBuffer   as handle    no-undo.
define variable iKeyState as integer   no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if not valid-handle(bttQueryWindow.QueryHandle) then
  leave.

hBuffer = bttQueryWindow.QueryHandle:get-buffer-handle(1).

if not valid-handle(hBuffer) then
  leave.

run qg_QueryWindowEdit(bttQueryWindow.WindowHandle,
                       {&K_EDITACTION_EDIT}).

end procedure.

PROCEDURE qg_QueryWindowQueryBrowsePopupMenuDrop :
/**
 * Menu drop event trigger for context menu of the query text editor widget.
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.

define variable hBrowse               as handle    no-undo.
define variable hTemp                 as handle    no-undo.

define buffer bttQueryWindow            for temp-table ttQueryWindow.

define buffer bttBufferComparisonField  for temp-table ttBufferComparisonField.
define buffer b2ttBufferComparisonField for temp-table ttBufferComparisonField.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hBrowse = bttQueryWindow.QueryBrowseHandle.

find first bttBufferComparisonField
  where bttBufferComparisonField.BufferNo = 1
  no-error.

find first b2ttBufferComparisonField
  where b2ttBufferComparisonField.BufferNo = 2
  no-error.

assign
  hTemp           = qg_hGetWidgetByName( hBrowse:popup-menu, 'mi_CopySelectedColumnValueRaw':U )
  hTemp:label     = ( if valid-handle( bttQueryWindow.QueryBrowseSelectedColumn ) then
                        substitute( 'Copy raw value (&1)':T,
                                    ( if valid-handle( bttQueryWindow.QueryBrowseSelectedColumn:buffer-field ) then
                                        qg_cFormattedFieldName( '':U,
                                                                bttQueryWindow.QueryBrowseSelectedColumn:buffer-field:buffer-handle:name,
                                                                bttQueryWindow.QueryBrowseSelectedColumn:buffer-field:name,
                                                                bttQueryWindow.QueryBrowseSelectedColumn:index )
                                      else
                                        bttQueryWindow.QueryBrowseSelectedColumn:name ) )
                      else
                        'Copy raw value':T )
  hTemp:sensitive = valid-handle( bttQueryWindow.QueryBrowseSelectedColumn )
  hTemp           = qg_hGetWidgetByName( hBrowse:popup-menu, 'mi_CopySelectedColumnValueFormatted':U )
  hTemp:label     = ( if valid-handle( bttQueryWindow.QueryBrowseSelectedColumn ) then
                        substitute( 'Copy formatted value (&1)':T,
                                    ( if valid-handle( bttQueryWindow.QueryBrowseSelectedColumn:buffer-field ) then
                                        qg_cFormattedFieldName( '':U,
                                                                bttQueryWindow.QueryBrowseSelectedColumn:buffer-field:buffer-handle:name,
                                                                bttQueryWindow.QueryBrowseSelectedColumn:buffer-field:name,
                                                                bttQueryWindow.QueryBrowseSelectedColumn:index )
                                      else
                                        bttQueryWindow.QueryBrowseSelectedColumn:name ) )
                      else
                        'Copy formatted value':T )
  hTemp:sensitive = valid-handle( bttQueryWindow.QueryBrowseSelectedColumn )
  hTemp           = qg_hGetWidgetByName(hBrowse:popup-menu, 'mi_SelectForComparison1':U)
  hTemp:label     = substitute('Select for comparison 1&1':T,
                               (if available bttBufferComparisonField then
                                  substitute(' (&1.&2)':U,
                                             bttBufferComparisonField.DatabaseName,
                                             bttBufferComparisonField.BufferName)
                                else
                                  '':U))
  hTemp           = qg_hGetWidgetByName(hBrowse:popup-menu, 'mi_SelectForComparison2':U)
  hTemp:label     = substitute('Select for comparison 2&1':T,
                               (if available b2ttBufferComparisonField then
                                  substitute(' (&1.&2)':U,
                                             b2ttBufferComparisonField.DatabaseName,
                                             b2ttBufferComparisonField.BufferName)
                                else
                                  '':U))
  hTemp           = qg_hGetWidgetByName(hBrowse:popup-menu, 'mi_CompareSelectedRecords':U)
  hTemp:sensitive =     available bttBufferComparisonField
                    and available b2ttBufferComparisonField
  hTemp           = qg_hGetWidgetByName( hBrowse:popup-menu, 'mi_CalculateSum':U )
  hTemp:label     = ( if valid-handle( bttQueryWindow.QueryBrowseSelectedColumn ) then
                        substitute( 'Calculate Sum for &1':T,
                                    ( if valid-handle( bttQueryWindow.QueryBrowseSelectedColumn:buffer-field ) then
                                        qg_cFormattedFieldName( '':U,
                                                                bttQueryWindow.QueryBrowseSelectedColumn:buffer-field:buffer-handle:name,
                                                                bttQueryWindow.QueryBrowseSelectedColumn:buffer-field:name,
                                                                bttQueryWindow.QueryBrowseSelectedColumn:index )
                                      else
                                        bttQueryWindow.QueryBrowseSelectedColumn:name ) )
                      else
                        'Calculate Sum':T )
  hTemp:sensitive = ( if    valid-handle( bttQueryWindow.QueryBrowseSelectedColumn ) then
                        lookup( bttQueryWindow.QueryBrowseSelectedColumn:data-type, 'DECIMAL,INTEGER,INT64':U ) > 0
                      else
                        no )
  .

end procedure.

PROCEDURE qg_QueryWindowQueryBrowseRowDisplay :
/**
 *
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.

define variable cDatabaseName        as character no-undo.
define variable cTableId             as character no-undo.
define variable cOverlayDatabaseName as character no-undo.
define variable cOverlayTableName    as character no-undo.
define variable cObjectIdFieldName   as character no-undo.

define variable lIncludeTablename    as logical   no-undo.
define variable cKeyValues           as character no-undo.
define variable cOverlayValue        as character no-undo.
define variable iFieldColor          as integer   no-undo.

define variable cObjectIdValue       as character no-undo.
define variable cFieldValue          as character no-undo.
define variable lResolved            as logical   no-undo.

define buffer bttQueryWindow                  for temp-table ttQueryWindow.

define buffer bttQueryWindowField             for temp-table ttQueryWindowField.
define buffer bttVirtualFieldColumn           for temp-table ttVirtualFieldColumn.
define buffer bttFieldOverlay                 for temp-table ttFieldOverlay.
define buffer bttQueryWindowQueryBrowseColumn for temp-table ttQueryWindowQueryBrowseColumn.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

// Applay column formats.
if    bttQueryWindow.DisplayRawValues
   or bttQueryWindow.ApplyColumnFormats then

  for each bttQueryWindowQueryBrowseColumn
    where bttQueryWindowQueryBrowseColumn.WindowHandle = bttQueryWindow.WindowHandle:

    if not valid-handle( bttQueryWindowQueryBrowseColumn.ColumnHandle ) then
      next.

    bttQueryWindowQueryBrowseColumn.ColumnHandle:format = ( if bttQueryWindow.DisplayRawValues then
                                                              bttQueryWindowQueryBrowseColumn.RawFormat
                                                            else
                                                              bttQueryWindowQueryBrowseColumn.OriginalFormat ).

  end.

// Display virtual fields.
for each bttVirtualFieldColumn
  where bttVirtualFieldColumn.OwnerHandle = bttQueryWindow.QueryHandle
  break by bttVirtualFieldColumn.BufferName
  on error undo, throw:

  if not valid-handle( bttVirtualFieldColumn.ColumnHandle ) then
    next.

  if first-of( bttVirtualFieldColumn.BufferName ) then
    cObjectIdValue = qg_cObjectIdForBuffer(bttVirtualFieldColumn.BufferHandle).

  assign
    bttVirtualFieldColumn.ColumnHandle:screen-value = string(qg_clVirtualFieldValueAsLongchar( bttVirtualFieldColumn.FieldType,
                                                                                               bttVirtualFieldColumn.DataType,
                                                                                               bttVirtualFieldColumn.FieldName,
                                                                                               cObjectIdValue,
                                                                                               (if bttQueryWindow.DisplayRawValues then
                                                                                                  ?
                                                                                                else
                                                                                                  bttVirtualFieldColumn.FieldFormat)))
    bttVirtualFieldColumn.ColumnHandle:fgcolor      = {&K_VIRTUAL_DB_FIELD_FGCOLOR}
    .

end.

// Display overlay fields.
for each bttFieldOverlay
  where bttFieldOverlay.OwnerHandle = bttQueryWindow.QueryHandle
  on error undo, throw:

  if    not valid-handle( bttFieldOverlay.ColumnHandle )
     or not valid-handle( bttFieldOverlay.OverlayColumnHandle ) then

    next.

  run qg_GetOverlayColumnValue( buffer bttFieldOverlay,
                                bttQueryWindow.DeepResolveObjectIds,
                                bttQueryWindow.DisplayRawValues,
                                output cFieldValue,
                                output lResolved ).

  assign
    iFieldColor = ( if lResolved then
                      {&K_OBJECTID_OVERLAY_FGCOLOR}
                    else
                      {&K_COLOR_RED} )
    bttFieldOverlay.OverlayColumnHandle:screen-value = cFieldValue
    bttFieldOverlay.OverlayColumnHandle:fgcolor      = iFieldColor
    .

end.

end procedure.

PROCEDURE qg_QueryWindowQueryBrowseStartSearch :
/**
 *
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.

define variable iKeyState as integer   no-undo.

define variable hColumn       as handle    no-undo.
define variable hBuffer       as handle    no-undo.
define variable hBufferField  as handle    no-undo.

define variable cDatabaseName as character no-undo.
define variable cBufferName   as character no-undo.
define variable cFieldName    as character no-undo.
define variable iFieldIndex   as integer   no-undo.

define buffer bttQueryWindow        for temp-table ttQueryWindow.

define buffer bttQueryWindowField   for temp-table ttQueryWindowField.
define buffer bttVirtualFieldColumn for temp-table ttVirtualFieldColumn.
define buffer bttFieldOverlay       for temp-table ttFieldOverlay.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

case last-event:function:

  when 'START-SEARCH':U then
  do:

    hColumn = bttQueryWindow.QueryBrowseHandle:current-column.

    find bttFieldOverlay
      where bttFieldOverlay.OwnerHandle         = bttQueryWindow.QueryHandle
        and bttFieldOverlay.OverlayColumnHandle = hColumn
      no-error.

    if available bttFieldOverlay then

      hColumn = bttFieldOverlay.ColumnHandle.

    if valid-handle( hColumn:buffer-field ) then

      assign
        hBufferField  = hColumn:buffer-field
        hBuffer       = hBufferField:buffer-handle
        cBufferName   = hBuffer:name
        cFieldName    = hBufferField:name
        iFieldIndex   = hColumn:index
        .

    else
    do:

      find bttVirtualFieldColumn
        where bttVirtualFieldColumn.OwnerHandle  = bttQueryWindow.QueryHandle
          and bttVirtualFieldColumn.ColumnHandle = hColumn
        no-error.

      if available bttVirtualFieldColumn then

        assign
          cBufferName = bttVirtualFieldColumn.BufferName
          cFieldName  = bttVirtualFieldColumn.FieldName
          iFieldIndex = bttVirtualFieldColumn.FieldIndex
          .

    end.

    apply 'end-search':U to bttQueryWindow.QueryBrowseHandle.

    find bttQueryWindowField
      where bttQueryWindowField.WindowHandle = bttQueryWindow.WindowHandle
        and bttQueryWindowField.BufferName   = cBufferName
        and bttQueryWindowField.FieldName    = cFieldName
        and bttQueryWindowField.FieldIndex   = iFieldIndex
        and bttQueryWindowField.IsOverlay    = no
      no-lock no-error.

    if available bttQueryWindowField then
    do:

      run GetKeyState({&K_WIN_CONST_VK_SHIFT}, output iKeyState).

      if iKeyState >= 0 then

        bttQueryWindow.QueryFieldBrowseHandle:deselect-rows().

      bttQueryWindow.QueryFieldBrowseHandle:query:reposition-to-rowid(rowid(bttQueryWindowField)) no-error.

      if not error-status:error then
      do:

        bttQueryWindow.QueryFieldBrowseHandle:select-focused-row().
        apply 'entry':U to bttQueryWindow.QueryFieldBrowseHandle.
      end.

    end.

  end.

  otherwise
  do:

    run GetKeyState({&K_WIN_CONST_VK_ALT}, output iKeyState).

    if iKeyState < 0 then
    do:

      run GetKeyState({&K_WIN_CONST_VK_SHIFT}, output iKeyState).

      run qg_QueryWindowAddSortOption(bttQueryWindow.WindowHandle,
                                      (iKeyState < 0)).

    end.

    else
    do:

      run GetKeyState({&K_WIN_CONST_VK_CTRL}, output iKeyState).

      if iKeyState < 0 then
        run qg_QueryWindowMoveColumn(bttQueryWindow.WindowHandle, yes).

      else
        run qg_QueryWindowQueryTextEditorAddCondition(bttQueryWindow.WindowHandle).

    end.

  end.

end case.

end procedure.

PROCEDURE qg_QueryWindowQueryBrowseSelectColumn :
/**
 *
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.

define variable hColumn         as handle    no-undo.
define variable hSelectedColumn as handle    no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hColumn = bttQueryWindow.QueryBrowseHandle:first-column.

do while valid-handle(hColumn):

  if    last-event:x > hColumn:x
    and last-event:x < ( hColumn:x + hColumn:width-pixels ) then

    hSelectedColumn = hColumn.

  hColumn = hColumn:next-column.

end.

if hSelectedColumn <> bttQueryWindow.QueryBrowseSelectedColumn then
do:

  bttQueryWindow.QueryBrowseSelectedColumn = hSelectedColumn.
  validate bttQueryWindow.

end.

end procedure.

PROCEDURE qg_QueryWindowQueryFieldBrowseRowDisplay :
/**
 *
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.

define variable hFieldBrowseBufferHandle as handle    no-undo.
define variable iColor                   as integer   no-undo init ?.

define buffer bttQueryWindow for temp-table ttQueryWindow.

define buffer bttField       for temp-table ttField.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hFieldBrowseBufferHandle = bttQueryWindow.QueryFieldBrowseBufferHandle.

if    valid-handle( hFieldBrowseBufferHandle )
  and hFieldBrowseBufferHandle:available then
do:

  case integer( hFieldBrowseBufferHandle::FieldType ):

    when {&K_FIELD_TYPE_VIRTUAL_DB_FIELD} then

      iColor = {&K_VIRTUAL_DB_FIELD_FGCOLOR}.

  end case.

  if iColor <> ? then

    assign
      bttQueryWindow.QueryFieldBrowseColHandles[1]:fgcolor = iColor
      bttQueryWindow.QueryFieldBrowseColHandles[2]:fgcolor = iColor
      .

end.

assign
  bttQueryWindow.QueryFieldBrowseColHandles[3]:fgcolor = {&K_COLOR_LIGHT_GREY}
  bttQueryWindow.QueryFieldBrowseColHandles[4]:fgcolor = {&K_COLOR_LIGHT_GREY}
  .

end procedure.

PROCEDURE qg_QueryWindowQueryOpenFieldQuery :
/**
 *
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.

define variable cQueryText as character no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

assign
  cQueryText =            'for each ttQueryWindowField':U
               + '~n':U + '  where ttQueryWindowField.WindowHandle = &1':U
               + '~n':U + '    and ttQueryWindowField.IsOverlay    = no':U
               + '~n':U + '  use-index BufferName':U
  cQueryText = substitute(cQueryText, quoter(bttQueryWindow.WindowHandle))
  .

qg_lQueryOpen(bttQueryWindow.QueryFieldBrowseHandle:query,
              cQueryText,
              bttQueryWindow.WindowHandle).

end procedure.

PROCEDURE qg_QueryWindowRefreshBrowseColumns :
/**
 *
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.

define variable i                 as integer   no-undo.
define variable iBufferCounter    as integer   no-undo.
define variable j                 as integer   no-undo.
define variable hBuffer           as handle    no-undo.

define variable hColumn           as handle    no-undo.
define variable hField            as handle    no-undo.
define variable cDatabaseName     as character no-undo.
define variable cBufferName       as character no-undo.
define variable cFieldName        as character no-undo.
define variable iFieldIndex       as integer   no-undo.
define variable cColExceptList    as character no-undo.

define variable lInitialize       as logical   no-undo.
define variable cColumns          as character no-undo.
define variable cColumn           as character no-undo.
define variable cOverlayFieldName as character no-undo.
define variable hOverlayColumn    as handle    no-undo.

define buffer bttQueryWindow                  for temp-table ttQueryWindow.

define buffer bttField                        for temp-table ttField.
define buffer bttFieldOverlay                 for temp-table ttFieldOverlay.
define buffer bttQueryWindowQueryBrowseColumn for temp-table ttQueryWindowQueryBrowseColumn.
define buffer bttVirtualFieldColumn           for temp-table ttVirtualFieldColumn.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

// Clear browse columns.

lInitialize = (bttQueryWindow.QueryBrowseHandle:num-columns = 0).

run qg_RemoveInvalidVirtualFieldColumns( buffer bttQueryWindow ).

run qg_RemoveInvalidOverlayColumns( buffer bttQueryWindow ).

// Remove all browse columns.
for each bttQueryWindowQueryBrowseColumn
  where bttQueryWindowQueryBrowseColumn.WindowHandle = bttQueryWindow.WindowHandle:

  delete bttQueryWindowQueryBrowseColumn.

end.

do i = bttQueryWindow.QueryBrowseHandle:num-columns to 1 by -1:

  hColumn = bttQueryWindow.QueryBrowseHandle:get-browse-column(i).
  delete object hColumn.

end.

// Create browse columns.

// Create buffer field columns.

do iBufferCounter = 1 to bttQueryWindow.QueryHandle:num-buffers:

  assign
    hBuffer       = bttQueryWindow.QueryHandle:get-buffer-handle( iBufferCounter )
    cDatabaseName = qg_cDatabaseNameForTableOrBuffer( hBuffer )
    .

  // If a field has format = ? then the entire progress session will crash on
  // "add-columns-from". To avoid this we add all fields with format = ? to
  // the the blacklist.

  for each bttField
    where bttField.DatabaseName = cDatabaseName
      and bttField.TableName    = hBuffer:table
      and bttField.FieldFormat  = ?
    on error undo, throw:

    cColExceptList = substitute( '&1,&2':U,
                                 cColExceptList,
                                 bttField.FieldName ).

  end.

  cColExceptList = trim( cColExceptList, ',':U ).

  bttQueryWindow.QueryBrowseHandle:add-columns-from( hBuffer, cColExceptList ).

  run qg_CreateVirtualFieldColumnsForBuffer( buffer bttQueryWindow,
                                             iBufferCounter ).

end.

if lInitialize then

  cColumns = qg_cBrowseColumnList( bttQueryWindow.QueryBrowseHandle,
                                   yes,
                                   no,
                                   yes ).

// Create field overlay columns.
do i = 1 to bttQueryWindow.QueryBrowseHandle:num-columns:

  assign
    hColumn = bttQueryWindow.QueryBrowseHandle:get-browse-column(i)
    hField  = hColumn:buffer-field
    .

  if valid-handle( hField ) then

    assign
      cBufferName  = hField:buffer-name
      cFieldName   = hField:name
      iFieldIndex  = hColumn:index
      .

  else
  do:

    find bttVirtualFieldColumn
      where bttVirtualFieldColumn.OwnerHandle  = bttQueryWindow.QueryHandle
        and bttVirtualFieldColumn.ColumnHandle = hColumn
      no-error.

    if not available bttVirtualFieldColumn then

      next.

    assign
      cBufferName = bttVirtualFieldColumn.BufferName
      cFieldName  = bttVirtualFieldColumn.FieldName
      iFieldIndex = bttVirtualFieldColumn.FieldIndex
      .

  end.

  find bttFieldOverlay
    where bttFieldOverlay.OwnerHandle = bttQueryWindow.QueryHandle
      and bttFieldOverlay.BufferName  = cBufferName
      and bttFieldOverlay.FieldName   = cFieldName
      and bttFieldOverlay.FieldIndex  = iFieldIndex
    no-error.

  if not available bttFieldOverlay then
    next.

  assign
    hOverlayColumn                      = bttQueryWindow.QueryBrowseHandle:add-calc-column
                                            ('CHARACTER':U,
                                             {&K_OBJECTID_OVERLAY_FORMAT},
                                             '':U,
                                             substitute({&K_OBJECTID_OVERLAY_LABEL_PATTERN},
                                                        hColumn:label))
    hOverlayColumn:name                 = substitute({&K_OBJECTID_OVERLAY_NAME_PATTERN},
                                                     qg_cFormattedFieldName(?,
                                                                            bttFieldOverlay.BufferName,
                                                                            bttFieldOverlay.FieldName,
                                                                            bttFieldOverlay.FieldIndex))
    hOverlayColumn:width                = {&K_OBJECTID_OVERLAY_DEFAULT_WIDTH}
    hOverlayColumn:label-fgcolor        = {&K_OBJECTID_OVERLAY_FGCOLOR}
    bttFieldOverlay.ColumnHandle        = hColumn
    bttFieldOverlay.FieldHandle         = hField
    bttFieldOverlay.OverlayColumnHandle = hOverlayColumn
    .

  validate bttFieldOverlay.

  if lInitialize then
    assign
      cFieldName        = qg_cFormattedFieldName(?,
                                                 bttFieldOverlay.BufferName,
                                                 bttFieldOverlay.FieldName,
                                                 bttFieldOverlay.FieldIndex)
      cOverlayFieldName = substitute({&K_OBJECTID_OVERLAY_NAME_PATTERN},
                                              cFieldName)
      cColumns          = qg_cReplaceColumn(cColumns,
                                            cFieldName,
                                            cOverlayFieldName).

end.

do i = 1 to bttQueryWindow.QueryBrowseHandle:num-columns:

  hColumn = bttQueryWindow.QueryBrowseHandle:get-browse-column(i).

  create bttQueryWindowQueryBrowseColumn.

  assign
    bttQueryWindowQueryBrowseColumn.WindowHandle   = bttQueryWindow.WindowHandle
    bttQueryWindowQueryBrowseColumn.ColumnHandle   = hColumn
    bttQueryWindowQueryBrowseColumn.OriginalFormat = hColumn:format
    bttQueryWindowQueryBrowseColumn.RawFormat      = ( if valid-handle( hColumn:buffer-field ) then
                                                         qg_cMaximumDataTypeFormat( hColumn:buffer-field:data-type,
                                                                                    hColumn:buffer-field:decimals )
                                                       else
                                                         qg_cMaximumDataTypeFormat( hColumn:data-type,
                                                                                    10 ) )
    .

  validate bttQueryWindowQueryBrowseColumn.

end.

if    lInitialize
  and cColumns > '':U
  and can-find( first ttFieldOverlay
                  where ttFieldOverlay.OwnerHandle = bttQueryWindow.QueryHandle ) then

  run qg_SetBrowseColumns( bttQueryWindow.QueryBrowseHandle, cColumns ).

end procedure.

PROCEDURE qg_QueryWindowQueryTextEditorAddCondition :
/**
 * Add selected field(s) as condition(s) to the current query text.
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.

define variable hEditor               as handle    no-undo.
define variable cQueryText            as character no-undo.
define variable iOffset               as integer   no-undo.
define variable iLineEndOffset        as integer   no-undo.

define variable hBuffer               as handle    no-undo.
define variable hFieldSelectionBrowse as handle    no-undo.
define variable hFieldSelectionBuffer as handle    no-undo.
define variable hField                as handle    no-undo.
define variable i                     as integer   no-undo.
define variable iFieldCount           as integer   no-undo.
define variable cDatabaseName         as character no-undo.
define variable lPhysicalDatabase     as logical   no-undo.
define variable cFieldList            as character no-undo.
define variable lWhere                as logical   no-undo.
define variable cInsertText           as character no-undo.

define variable iLine                 as integer   no-undo.

define buffer bttQueryWindow    for temp-table ttQueryWindow.
define buffer bttQueryAST       for temp-table ttQueryAST.
define buffer bttQueryCondition for temp-table ttQueryCondition.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if bttQueryWindow.ObjSourceQuerySeq > 0 then
  leave.

// Get selection info

assign
  hEditor    = bttQueryWindow.QueryTextEditorHandle
  cQueryText = hEditor:input-value
  iOffset    = (if hEditor:selection-end = ? then
                  hEditor:cursor-offset
                else
                  hEditor:selection-end - 1)
  .

// Analyze selection and query text

iLineEndOffset = index(cQueryText, '~n':U, iOffset).

if iLineEndOffset > 0 then
  iOffset = iLineEndOffset.

run qg_ParseQueryConditions(cQueryText).

// Don't insert after certain progress keywords.
find first bttQueryAST
  where bttQueryAST.TokenType   = {&K_QP_TOKEN_TYPE_KEYWORD}
    and bttQueryAST.TokenStart <= iOffset
    and lookup(bttQueryAST.TokenText, 'BREAK,BY,NO-LOCK,SHARE-LOCK,EXCLUSIVE-LOCK,USE-INDEX':U) > 0
  no-error.

if available bttQueryAST then
do:

  iLineEndOffset = r-index(cQueryText, '~n':U, bttQueryAST.TokenStart).

  if iLineEndOffset > 0 then
    iOffset = iLineEndOffset.

end.

// Switch where to end if necessary.
find last bttQueryCondition
  where bttQueryCondition.RightStartPos <= iOffset
    and bttQueryCondition.RightEndPos   >= iOffset
  no-error.

if available bttQueryCondition then
  iOffset = bttQueryCondition.RightEndPos.

lWhere = not can-find(first ttQueryAST
                        where ttQueryAST.TokenType  = {&K_QP_TOKEN_TYPE_KEYWORD}
                          and ttQueryAST.TokenText  = 'WHERE':U
                          and ttQueryAST.TokenStart < iOffset).

if lWhere then
do:

  find first bttQueryAST
    where bttQueryAST.TokenType   = {&K_QP_TOKEN_TYPE_KEYWORD}
      and bttQueryAST.TokenText   = 'WHERE':U
      and bttQueryAST.TokenStart >= iOffset
    no-error.

  if available bttQueryAST then
    overlay(cQueryText,
            bttQueryAST.TokenStart,
            bttQueryAST.TokenEnd - bttQueryAST.TokenStart) = 'and':U.

end.

// Generate line text.

assign
  hBuffer               = bttQueryWindow.QueryBrowseHandle:query:get-buffer-handle(1)
  hFieldSelectionBrowse = bttQueryWindow.QueryFieldBrowseHandle
  hFieldSelectionBuffer = bttQueryWindow.QueryFieldBrowseBufferHandle
  cDatabaseName         = qg_cDatabaseNameForTableOrBuffer( hBuffer ).
  lPhysicalDatabase     = qg_lIsPhysicalDatabase( cDatabaseName )
  .

do i = 1 to hFieldSelectionBrowse:num-selected-rows:

  hFieldSelectionBrowse:fetch-selected-row (i).

  if    lPhysicalDatabase
    and hFieldSelectionBuffer::IsVirtual then

    message
      substitute( 'Virtual field &1 can not be used in the query!':T,
                  quoter( hFieldSelectionBuffer::FieldName ) ) skip
      view-as alert-box
      warning
      buttons ok
      in window bttQueryWindow.WindowHandle.

  else

    assign
      cFieldList  = substitute('&1,&2':U,
                               cFieldList,
                               qg_cFormattedFieldName(?,
                                                      ?,
                                                      hFieldSelectionBuffer::FieldName,
                                                      hFieldSelectionBuffer::FieldIndex))
      iFieldCount = iFieldCount + 1
      .

end.

if iFieldCount = 0 then

  return.

assign
  cFieldList  = trim(cFieldList, ',':U)
  cInsertText = qg_cCreateWhereClause( /* pcDatabaseName   */ cDatabaseName,
                                       /* pcTableNames     */ hBuffer:table,
                                       /* pcBufferNames    */ hBuffer:name,
                                       /* pcFieldList      */ cFieldList,
                                       /* pcFieldLabelList */ ?,
                                       /* plStartWithWhere */ lWhere,
                                       /* piValueMode      */ {&K_VALUE_MODE_DEFAULT_VALUE},
                                       /* pcValueList      */ ?,
                                       /* piAccessMode     */ {&K_ACCESS_MODE_PHYSICAL},
                                       /* plAddTags        */ no,
                                       /* piIndentBlanks   */ 0 )
  .

// Insert text lines.

run qg_InsertTextLines(cInsertText,
                       iOffset,
                       input-output cQueryText,
                             output iLine).

// Update editor

cQueryText = qg_cBeautifyQueryText(cQueryText).

run qg_UpdateEditor(hEditor,
                    cQueryText,
                    iLine,
                    iLine + max(0, num-entries(cInsertText, '~n':U) - 1)).

apply 'entry':U to hEditor.

end procedure.

PROCEDURE qg_QueryWindowQueryTextEditorDeleteLines :
/**
 * Delete selected lines.
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.

define variable hEditor                   as handle    no-undo.
define variable cQueryText                as character no-undo.

define variable iSelectionStart           as integer   no-undo.
define variable iSelectionEnd             as integer   no-undo.

define variable iLine                     as integer   no-undo.

define variable iSelectionStartLine       as integer   no-undo.
define variable iSelectionEndLine         as integer   no-undo.
define variable iSelectionStartLineOffset as integer   no-undo.
define variable iSelectionEndLineOffset   as integer   no-undo.

define buffer bttQueryWindow    for temp-table ttQueryWindow.
define buffer bttQueryAST       for temp-table ttQueryAST.
define buffer bttQueryCondition for temp-table ttQueryCondition.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if bttQueryWindow.ObjSourceQuerySeq > 0 then
  leave.

assign
  hEditor     = bttQueryWindow.QueryTextEditorHandle
  cQueryText  = hEditor:input-value
  .

// Fix connective operator

run qg_ParseQueryConditions(cQueryText).

run qg_GetEditorSelectionInfo(hEditor,
                              output iSelectionStart,
                              output iSelectionEnd,
                              output iSelectionStartLine,
                              output iSelectionEndLine).

if    iSelectionStartLine > 0
  and iSelectionEndLine   > 0 then
do:

  assign
    iSelectionStartLineOffset = hEditor:convert-to-offset(iSelectionStartLine,
                                                          1)
    iSelectionEndLineOffset   = hEditor:convert-to-offset(iSelectionEndLine,
                                                          length(entry(iSelectionEndLine,
                                                                       cQueryText,
                                                                       '~n':U)))
    .

  find first bttQueryAST
    where bttQueryAST.TokenType = {&K_QP_TOKEN_TYPE_KEYWORD}
      and bttQueryAST.TokenText = 'WHERE':U
    no-error.

  if    available bttQueryAST
    and bttQueryAST.TokenStart >= iSelectionStartLineOffset
    and bttQueryAST.TokenEnd   <= iSelectionEndLineOffset then
  do:

    find first bttQueryAST
      where bttQueryAST.TokenType  = {&K_QP_TOKEN_TYPE_OPERATOR}
        and bttQueryAST.TokenStart > iSelectionEndLineOffset
        and lookup(bttQueryAST.TokenText, 'AND,OR':U) > 0
        and not can-find(first bttQueryCondition
                           where bttQueryCondition.RightStartPos <= bttQueryAST.TokenStart
                             and bttQueryCondition.RightEndPos   >= bttQueryAST.TokenEnd)

      no-error.

    if available bttQueryAST then
      cQueryText = substitute('&1where&2':U,
                              substring(cQueryText,
                                        1,
                                        bttQueryAST.TokenStart - 1),
                              substring(cQueryText,
                                        bttQueryAST.TokenEnd)).

  end.

  // Delete line

  run qg_DeleteTextLines(iSelectionStart,
                         iSelectionEnd,
                         input-output cQueryText,
                               output iLine).

  // Beautify query text

  cQueryText = qg_cBeautifyQueryText(cQueryText).

  assign
    hEditor:screen-value = cQueryText
    hEditor:cursor-line  = iLine
    .

end.

end procedure.

PROCEDURE qg_QueryWindowQueryTextEditorDuplicateLines :
/**
 * Add selected field(s) as condition(s) to the current query text.
 *
 * @param phWindow = Handle of the Query window.
 * @param phBuffer = Buffer that contains the field.
 */

define input parameter phWindow as handle    no-undo.
define input parameter plDown   as logical   no-undo.

define variable hEditor                   as handle    no-undo.
define variable cQueryText                as character no-undo.

define variable iLine                     as integer   no-undo.
define variable iSelectionStart           as integer   no-undo.
define variable iSelectionEnd             as integer   no-undo.
define variable iSelectionStartLine       as integer   no-undo.
define variable iSelectionEndLine         as integer   no-undo.
define variable iSelectedLines            as integer   no-undo.

define variable iSelectionStartLineOffset as integer   no-undo.
define variable iSelectionEndLineOffset   as integer   no-undo.

define variable i                         as integer   no-undo.
define variable iOffset                   as integer   no-undo init 1.
define variable iLineEndOffset            as integer   no-undo.

define variable iRelativeOffset           as integer   no-undo.

define buffer bttQueryWindow    for temp-table ttQueryWindow.
define buffer bttQueryAST       for temp-table ttQueryAST.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if bttQueryWindow.ObjSourceQuerySeq > 0 then
  leave.

// Get selection info

assign
  hEditor    = bttQueryWindow.QueryTextEditorHandle
  cQueryText = hEditor:input-value
  .

run qg_GetEditorSelectionInfo(hEditor,
                              output iSelectionStart,
                              output iSelectionEnd,
                              output iSelectionStartLine,
                              output iSelectionEndLine).

// Analyze selection and query text

assign
  iSelectionStartLineOffset = hEditor:convert-to-offset(iSelectionStartLine,
                                                        1)
  iSelectionEndLineOffset   = hEditor:convert-to-offset(iSelectionEndLine,
                                                        length(entry(iSelectionStartLine,
                                                                     cQueryText,
                                                                     '~n':U))) + 1
  .

run qg_ParseQueryConditions(cQueryText).

find first bttQueryAST
  where bttQueryAST.TokenType   = {&K_QP_TOKEN_TYPE_KEYWORD}
    and bttQueryAST.TokenStart >= iSelectionStartLineOffset
    and bttQueryAST.TokenEnd   <= iSelectionEndLineOffset
    and bttQueryAST.TokenText   = 'WHERE':U
  use-index TokenType
  no-error.

if available bttQueryAST then
  iRelativeOffset = bttQueryAST.TokenStart - iSelectionStartLineOffset.

// Move text lines

run qg_DuplicateTextLines(iSelectionStart,
                          iSelectionEnd,
                          plDown,
                          input-output cQueryText,
                                output iLine).

// Fix duplicted lines

if available bttQueryAST then
do:

  // Get line offset.
  assign
    iSelectionStartLineOffset = 0
    iSelectionEndLineOffset   = 0
    .

  do i = 1 to num-entries(cQueryText, '~n':U):

    iLineEndOffset = iOffset + length(entry(i, cQueryText, '~n':U)).

    if i = iLine then
      iSelectionStartLineOffset = iOffset.

    if i = iLine + iSelectionEndLine - iSelectionStartLine then
    do:

      iSelectionEndLineOffset = iLineEndOffset.
      leave.

    end.

    iOffset = iLineEndOffset + length('~n':U).

  end.

  iOffset = (if plDown then
               iSelectionStartLineOffset
             else
               iSelectionEndLineOffset + length('~n':U)).

  // Replace "where" by "and".
  if iOffset > 0 then
    overlay(cQueryText,
            iOffset + iRelativeOffset,
            length(bttQueryAST.TokenText)) = 'and':U.

end.

// Update editor

cQueryText = qg_cBeautifyQueryText(cQueryText).

run qg_UpdateEditor(hEditor,
                    cQueryText,
                    iLine,
                    iLine + iSelectionEndLine - iSelectionStartLine).

apply 'entry':U to hEditor.

end procedure.

PROCEDURE qg_QueryWindowQueryTextEditorMoveLines :
/**
 * Add selected field(s) as condition(s) to the current query text.
 *
 * @param phWindow = Handle of the Query window.
 * @param plDown = If yes the lines will be moved down. Otherwise the lines will be moved up.
 */

define input parameter phWindow as handle    no-undo.
define input parameter plDown   as logical   no-undo.

define variable hEditor                   as handle    no-undo.
define variable cQueryText                as character no-undo.

define variable iLine                     as integer   no-undo.
define variable iSelectionStart           as integer   no-undo.
define variable iSelectionEnd             as integer   no-undo.
define variable iSelectionStartLine       as integer   no-undo.
define variable iSelectionEndLine         as integer   no-undo.

define variable iSelectionStartLineOffset as integer   no-undo.
define variable iSelectionEndLineOffset   as integer   no-undo.
define variable iNextLineOffset           as integer   no-undo.

define buffer bttQueryWindow    for temp-table ttQueryWindow.
define buffer b1ttQueryAST      for temp-table ttQueryAST.
define buffer b2ttQueryAST      for temp-table ttQueryAST.
define buffer bttQueryCondition for temp-table ttQueryCondition.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if bttQueryWindow.ObjSourceQuerySeq > 0 then
  leave.

// Get selection info

assign
  hEditor    = bttQueryWindow.QueryTextEditorHandle
  cQueryText = hEditor:input-value
  .

run qg_GetEditorSelectionInfo(hEditor,
                              output iSelectionStart,
                              output iSelectionEnd,
                              output iSelectionStartLine,
                              output iSelectionEndLine).

// Analyze selection and query text

assign
  iSelectionStartLineOffset = hEditor:convert-to-offset(iSelectionStartLine,
                                                        1)
  iSelectionEndLineOffset   = hEditor:convert-to-offset(iSelectionEndLine,
                                                        length(entry(iSelectionStartLine,
                                                                     cQueryText,
                                                                     '~n':U))) + 1
  .

run qg_ParseQueryConditions(cQueryText).

if plDown then
do:

  find first b1ttQueryAST
    where b1ttQueryAST.TokenType   = {&K_QP_TOKEN_TYPE_KEYWORD}
      and b1ttQueryAST.TokenStart >= iSelectionStartLineOffset
      and b1ttQueryAST.TokenEnd   <= iSelectionEndLineOffset
      and b1ttQueryAST.TokenText   = 'WHERE':U
    no-error.

  if available b1ttQueryAST then
  do:

    iNextLineOffset = index(cQueryText,
                            '~n':U,
                            iSelectionEndLineOffset + length('~n':U)).

    if iNextLineOffset = 0 then
      iNextLineOffset = length(cQueryText) + 1.

    find first b2ttQueryAST
      where b2ttQueryAST.TokenType   = {&K_QP_TOKEN_TYPE_OPERATOR}
        and b2ttQueryAST.TokenStart >= iSelectionEndLineOffset
        and b2ttQueryAST.TokenEnd   <= iNextLineOffset
        and lookup(b2ttQueryAST.TokenText, 'AND,OR':U) > 0
        and not can-find(first bttQueryCondition
                           where bttQueryCondition.RightStartPos <= b2ttQueryAST.TokenStart
                             and bttQueryCondition.RightEndPos   >= b2ttQueryAST.TokenEnd)
      no-error.

  end.

end.

else
do:

  iNextLineOffset = r-index(cQueryText,
                            '~n':U,
                            maximum(1, iSelectionStartLineOffset - length('~n':U) - 1)).

  if iNextLineOffset = 0 then
    iNextLineOffset = 1.

  find first b1ttQueryAST
    where b1ttQueryAST.TokenType   = {&K_QP_TOKEN_TYPE_KEYWORD}
      and b1ttQueryAST.TokenStart >= iNextLineOffset
      and b1ttQueryAST.TokenEnd   <= iSelectionStartLineOffset
      and b1ttQueryAST.TokenText   = 'WHERE':U
    no-error.

  if available b1ttQueryAST then
    find first b2ttQueryAST
      where b2ttQueryAST.TokenType   = {&K_QP_TOKEN_TYPE_OPERATOR}
        and b2ttQueryAST.TokenStart >= iSelectionStartLineOffset
        and b2ttQueryAST.TokenEnd   <= iSelectionEndLineOffset
        and lookup(b2ttQueryAST.TokenText, 'AND,OR':U) > 0
        and not can-find(first bttQueryCondition
                           where bttQueryCondition.RightStartPos <= b2ttQueryAST.TokenStart
                             and bttQueryCondition.RightEndPos   >= b2ttQueryAST.TokenEnd)
      no-error.

end.

if    available b1ttQueryAST
  and available b2ttQueryAST then
  assign
    cQueryText =   substring(cQueryText,
                             1,
                             b1ttQueryAST.TokenStart - 1)
                 + lc(b2ttQueryAST.TokenText)
                 + substring(cQueryText,
                             b1ttQueryAST.TokenEnd,
                             b2ttQueryAST.TokenStart - b1ttQueryAST.TokenEnd)
                 + lc(b1ttQueryAST.TokenText)
                 + substring(cQueryText, b2ttQueryAST.TokenEnd)
    iSelectionStart = iSelectionStart - 5 + length(b2ttQueryAST.TokenText)
        when iSelectionStart > b1ttQueryAST.TokenEnd
    iSelectionStart = iSelectionStart - 5 + length(b1ttQueryAST.TokenText)
        when iSelectionStart > b2ttQueryAST.TokenEnd
    iSelectionEnd = iSelectionEnd - 5 + length(b2ttQueryAST.TokenText)
        when iSelectionEnd > b1ttQueryAST.TokenEnd
    iSelectionEnd = iSelectionEnd - 5 + length(b1ttQueryAST.TokenText)
        when iSelectionEnd > b2ttQueryAST.TokenEnd
    .

// Move text lines

run qg_MoveTextLines(iSelectionStart,
                     iSelectionEnd,
                     plDown,
                     input-output cQueryText,
                           output iLine).

// Update editor

cQueryText = qg_cBeautifyQueryText(cQueryText).

run qg_UpdateEditor(hEditor,
                    cQueryText,
                    iLine,
                    iLine + iSelectionEndLine - iSelectionStartLine).

apply 'entry':U to hEditor.

end procedure.

PROCEDURE qg_QueryWindowQueryTextEditorPopupMenuDrop :
/**
 * Menu drop event trigger for context menu of the query text editor widget.
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.

define variable hInsertExternalFieldReference as handle    no-undo.
define variable hInsertExternalTableReference as handle    no-undo.

define variable hTemp                         as handle    no-undo.

define variable iOffset                       as integer   no-undo.
define variable cQuerytext                    as character no-undo.
define variable cComparator                   as character no-undo.

define buffer bttQueryWindow    for temp-table ttQueryWindow.

define buffer bttQueryCondition for temp-table ttQueryCondition.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

cQueryText = bttQueryWindow.QueryTextEditorHandle:input-value.

run qg_ParseQueryConditions(cQueryText).

iOffset = bttQueryWindow.QueryTextEditorHandle:cursor-offset.

find first bttQueryCondition
  where bttQueryCondition.StartPos <= iOffset
    and bttQueryCondition.EndPos   >= iOffset
  no-error.

if available bttQueryCondition then
  cComparator = substring(cQuerytext,
                          bttQueryCondition.ComparatorStartPos,
                          bttQueryCondition.ComparatorEndPos - bttQueryCondition.ComparatorStartPos).

if bttQueryWindow.ObjSourceQuerySeq = 0 then
  assign
    hInsertExternalFieldReference           = qg_hGetWidgetByName(bttQueryWindow.QueryTextEditorHandle:popup-menu,
                                                                  'mi_InsertExternalFieldReference':U)
    hInsertExternalFieldReference:sensitive /* code checked by mth */
        = can-find(first ttQueryWindow
                     where ttQueryWindow.QuerySeq <> bttQueryWindow.QuerySeq)
    hInsertExternalTableReference           = qg_hGetWidgetByName(bttQueryWindow.QueryTextEditorHandle:popup-menu,
                                                                  'mi_InsertExternalTableReference':U)
    hInsertExternalTableReference:sensitive /* code checked by mth */
        = hInsertExternalFieldReference:sensitive
    hTemp           = qg_hGetWidgetByName(bttQueryWindow.QueryTextEditorHandle:popup-menu,
                                         'mi_Equal':U)
    hTemp:sensitive =     cComparator  > '':U
                      and cComparator <> '=':U
    hTemp           = qg_hGetWidgetByName(bttQueryWindow.QueryTextEditorHandle:popup-menu,
                                         'mi_NotEqual':U)
    hTemp:sensitive =     cComparator  > '':U
                      and cComparator <> '<>':U
    hTemp           = qg_hGetWidgetByName(bttQueryWindow.QueryTextEditorHandle:popup-menu,
                                         'mi_Greater':U)
    hTemp:sensitive =     cComparator  > '':U
                      and cComparator <> '>':U
    hTemp           = qg_hGetWidgetByName(bttQueryWindow.QueryTextEditorHandle:popup-menu,
                                         'mi_GreaterEqual':U)
    hTemp:sensitive =     cComparator  > '':U
                      and cComparator <> '>=':U
    hTemp           = qg_hGetWidgetByName(bttQueryWindow.QueryTextEditorHandle:popup-menu,
                                         'mi_Lower':U)
    hTemp:sensitive =     cComparator  > '':U
                      and cComparator <> '<':U
    hTemp           = qg_hGetWidgetByName(bttQueryWindow.QueryTextEditorHandle:popup-menu,
                                         'mi_LowerEqual':U)
    hTemp:sensitive =     cComparator  > '':U
                      and cComparator <> '<=':U
    hTemp           = qg_hGetWidgetByName(bttQueryWindow.QueryTextEditorHandle:popup-menu,
                                         'mi_Begins':U)
    hTemp:sensitive =     cComparator  > '':U
                      and cComparator <> 'begins':U
    hTemp           = qg_hGetWidgetByName(bttQueryWindow.QueryTextEditorHandle:popup-menu,
                                         'mi_Matches':U)
    hTemp:sensitive =     cComparator  > '':U
                      and cComparator <> 'matches':U
    hTemp           = qg_hGetWidgetByName(bttQueryWindow.QueryTextEditorHandle:popup-menu,
                                         'mi_Contains':U)
    hTemp:sensitive =     cComparator  > '':U
                      and cComparator <> 'contains':U
    .

end procedure.

PROCEDURE qg_QueryWindowQueryToolsMenuDrop :
/**
 * Menu drop event trigger for the query window tools menu.
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.

define variable lBufferAvailable          as logical   no-undo.
define variable hOpenRecordWindowFixRowId as handle    no-undo.
define variable hOpenRecordWindowFixIndex as handle    no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

assign
  lBufferAvailable          =     valid-handle(bttQueryWindow.QueryHandle)
                              and bttQueryWindow.QueryHandle:get-buffer-handle(1):available
  hOpenRecordWindowFixRowId = qg_hGetWidgetByName(bttQueryWindow.WindowHandle:menu-bar,
                                                  'mi_OpenRecordWindowFixRowId':U)
  hOpenRecordWindowFixRowId:sensitive /* code checked by mth */
      = lBufferAvailable
  hOpenRecordWindowFixIndex = qg_hGetWidgetByName(bttQueryWindow.WindowHandle:menu-bar,
                                                  'mi_OpenRecordWindowFixIndex':U)
  hOpenRecordWindowFixIndex:sensitive /* code checked by mth */
      = lBufferAvailable
  .

end procedure.

PROCEDURE qg_QueryWindowQueryUpdateTitle :
/**
 *
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.

define variable hQuery        as handle    no-undo.
define variable hBuffer       as handle    no-undo.

define variable cDatabaseName as character no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hQuery = bttQueryWindow.QueryHandle.

if    valid-handle(hQuery)
  and hQuery:num-buffers > 0 then
  hBuffer = hQuery:get-buffer-handle(1).

if not valid-handle(hBuffer) then
    bttQueryWindow.WindowTitle = substitute('&1[&2] Query - unknown':U,
                                            gcTitlePrefix,
                                            bttQueryWindow.QuerySeq).

else
  assign
    cDatabaseName              = qg_cDatabaseNameForTableOrBuffer( hBuffer )
    bttQueryWindow.WindowTitle = substitute('&1[&2] Query - &3.&4':T,
                                            gcTitlePrefix,
                                            bttQueryWindow.QuerySeq,
                                            cDatabaseName,
                                            hBuffer:table)
    .

bttQueryWindow.WindowHandle:title = bttQueryWindow.WindowTitle.

end procedure.

PROCEDURE qg_QueryWindowRecentQueries :
/**
 * Show dialog with recently executed queries.
 *
 * @param phWindow = Window that contains the widgets.
 */

define input parameter phWindow as handle    no-undo.

define variable iOrderLabel as integer   no-undo.

define query brRecentQueriesBrowse
  for ttRecentQuery
  scrolling.

define browse brRecentQueriesBrowse
  query brRecentQueriesBrowse no-lock
    display
      ttRecentQuery.OrderLabel format 'zzzzz9  ':U label 'Ord':U
      ttRecentQuery.QueryLabel format 'x(255)':U label 'Query':U
      with no-assign size 146 by 10.5.

define variable cQueryText as character no-undo
  view-as editor
  no-word-wrap
  scrollbar-horizontal
  scrollbar-vertical
  size 146 by 10
  font 0.

define button btnOk
  label 'Ok':T2
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.


define buffer bttQueryWindow for temp-table ttQueryWindow.
define buffer bttRecentQuery for temp-table ttRecentQuery.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if bttQueryWindow.ObjSourceQuerySeq > 0 then
  leave.

define frame fSelectRecentQuery
  brRecentQueriesBrowse at row 1.5 col 3
  cQueryText at row 12.5 col 3 no-label
  btnOk at row 23.5 col 56
  btnCancel at row 23.5 col 76
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    title gcTitlePrefix + 'Select recent query':U
    side-labels no-underline three-d 
    size 151 by 25.44
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fSelectRecentQuery
  apply 'end-error' to self.

on value-changed of brRecentQueriesBrowse in frame fSelectRecentQuery
do:

  if available ttRecentQuery then
    cQueryText = ttRecentQuery.QueryText.

  else
    cQueryText = '':U.

  display unless-hidden
    cQueryText
    with frame fSelectRecentQuery.

end.

on default-action of brRecentQueriesBrowse in frame fSelectRecentQuery
  apply 'go':U to frame fSelectRecentQuery.

// Refresh display order numbers.
for each bttRecentQuery
  where bttRecentQuery.WindowHandle = bttQueryWindow.WindowHandle
  by Order
  on error undo, throw:

  assign
    iOrderLabel               = iOrderLabel + 1
    bttRecentQuery.OrderLabel = iOrderLabel
    .

end.

open query brRecentQueriesBrowse
  for each ttRecentQuery
    where ttRecentQuery.WindowHandle = bttQueryWindow.WindowHandle
    by Order descending.

run qg_InitBrowse(browse brRecentQueriesBrowse:handle).

cQueryText:read-only in frame fSelectRecentQuery = yes.

if query brRecentQueriesBrowse:num-results > 0 then
do:

  display unless-hidden
    brRecentQueriesBrowse
    with frame fSelectRecentQuery
      in window bttQueryWindow.WindowHandle. 

  brRecentQueriesBrowse:select-row(1) in frame fSelectRecentQuery.
  apply 'value-changed':U to brRecentQueriesBrowse in frame fSelectRecentQuery.

end.

update unless-hidden
  brRecentQueriesBrowse
  cQueryText
  btnOk
  btnCancel
  with frame fSelectRecentQuery
    in window bttQueryWindow.WindowHandle. 

if available ttRecentQuery then
do:

  run qg_ExecRecentQuery in target-procedure
        (bttQueryWindow.WindowHandle,
         ttRecentQuery.QueryText).

  apply 'entry':U to bttQueryWindow.QueryTextEditorHandle.

end.

end procedure.

PROCEDURE qg_QueryWindowRecordBrowseRowDisplay :
/**
 * Copy selected record field value.
 *
 * @param phWindow = Handle of the record window.
 */

define input parameter phWindow as handle    no-undo.

define variable hBuffer        as handle    no-undo.
define variable iColor         as integer   no-undo init ?.
define variable iColumnCounter as integer   no-undo.
define variable iLastColumn    as integer   no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hBuffer = bttQueryWindow.RecordQueryHandle:get-buffer-handle(1).

if hBuffer:available then
do:

  if hBuffer::IsOverlay then

    iColor = {&K_OBJECTID_OVERLAY_FGCOLOR}.

  else

    case integer( hBuffer::FieldType ):

      when {&K_FIELD_TYPE_VIRTUAL_DB_FIELD} then

        iColor = {&K_VIRTUAL_DB_FIELD_FGCOLOR}.

    end case.

  if iColor <> ? then

    do iColumnCounter = 1 to extent(bttQueryWindow.RecordBrowseColHandles):
      bttQueryWindow.RecordBrowseColHandles[iColumnCounter]:fgcolor = iColor.
    end.

  if hBuffer::IsOverlay then
  do:

    iLastColumn = extent(bttQueryWindow.RecordBrowseColHandles).

    bttQueryWindow.RecordBrowseColHandles[iLastColumn]:fgcolor = ( if hBuffer::IsOverlayResolved then
                                                                     {&K_OBJECTID_OVERLAY_FGCOLOR}
                                                                   else
                                                                     {&K_COLOR_RED} ).

  end.

end.

end procedure.

PROCEDURE qg_QueryWindowRecordCopyValue :
/**
 * Copy selected record field value.
 *
 * @param phWindow = Handle of the record window.
 */

define input parameter phWindow as handle    no-undo.

define variable hBuffer    as handle    no-undo.
define variable clValue    as longchar  no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hBuffer = bttQueryWindow.RecordQueryHandle:get-buffer-handle(1).

if not hBuffer:available then
  message /* code checked by mth */
    'No field is selected':T skip
    view-as alert-box
    error
    buttons ok.

else
do:

  if bttQueryWindow.DisplayRawValues then
    copy-lob hBuffer::CurrentUnformattedValue to clValue.

  else
    copy-lob hBuffer::CurrentFormattedValue to clValue.

  clipboard:value = clValue.

end.

end procedure.

PROCEDURE qg_QueryWindowRecordFieldDetails :
/**
 * Show field details dialog for selected field.
 *
 * @param phWindow = Handle of the record window.
 */

define input parameter phWindow as handle    no-undo.

define variable hRecordBrowseBuffer as handle    no-undo.
define variable hRecordBuffer       as handle    no-undo.
define variable clValue             as longchar  no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hRecordBrowseBuffer = bttQueryWindow.RecordQueryHandle:get-buffer-handle(1).

if not hRecordBrowseBuffer:available then
  message /* code checked by mth */
    'No field is selected':T skip
    view-as alert-box
    error
    buttons ok
    in window bttQueryWindow.WindowHandle.

else
do:

  hRecordBuffer = bttQueryWindow.QueryHandle:get-buffer-handle(string(hRecordBrowseBuffer::BufferName)).

  if valid-handle(hRecordBuffer) then
  do:

    if not hRecordBuffer:available then
      message /* code checked by mth */
        '&1 record is not available':T skip
        view-as alert-box
        error
        buttons ok
        in window bttQueryWindow.WindowHandle.

    else
    do:

      if bttQueryWindow.DisplayRawValues then
        copy-lob from hRecordBrowseBuffer::CurrentUnformattedValue to clValue.

      else
        copy-lob from hRecordBrowseBuffer::CurrentFormattedValue to clValue.

      run qg_EditFieldValue(hRecordBrowseBuffer::FieldName,
                            hRecordBrowseBuffer::DataType,
                            hRecordBrowseBuffer::FieldFormat,
                            hRecordBrowseBuffer::FieldViewAs,
                            bttQueryWindow.DisplayRawValues,
                            no,
                            input-output clValue,
                            bttQueryWindow.WindowHandle).

    end.

  end.

end.

apply 'entry':U to bttQueryWindow.RecordBrowseHandle.

end procedure.

PROCEDURE qg_QueryWindowRecordNavigate :
define input parameter phWindow         as handle    no-undo.
define input parameter piNavigationType as integer   no-undo.

define variable rCurrentRecord as rowid     no-undo.
define variable hBuffer        as handle    no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if not valid-handle(bttQueryWindow.QueryHandle) then
  leave.

assign
  hBuffer        = bttQueryWindow.QueryHandle:get-buffer-handle(1)
  rCurrentRecord = hBuffer:rowid
  .

case piNavigationType:

  when {&K_NAVIGATE_FIRST} then
    bttQueryWindow.QueryHandle:get-first().

  when {&K_NAVIGATE_PREV} then
  do:

    bttQueryWindow.QueryHandle:get-prev().

    if    rCurrentRecord <> ?
      and not hBuffer:available then
    do:

      message
        'This already is the first record':T
        view-as alert-box
        information
        buttons ok
        in window bttQueryWindow.WindowHandle.

      bttQueryWindow.QueryHandle:get-next().

    end.

  end.

  when {&K_NAVIGATE_NEXT} then
  do:

    bttQueryWindow.QueryHandle:get-next().

    if    rCurrentRecord <> ?
      and not hBuffer:available then
    do:

      message
        'This already is the last record':T
        view-as alert-box
        information
        buttons ok
        in window bttQueryWindow.WindowHandle.

      bttQueryWindow.QueryHandle:get-prev().

    end.

  end.

  when {&K_NAVIGATE_LAST} then
    bttQueryWindow.QueryHandle:get-last().

end case.

run qg_QueryWindowRecordRefresh(bttQueryWindow.WindowHandle).

run qg_QueryWindowUpdateAll('':U).

end procedure.

PROCEDURE qg_QueryWindowRecordOpenQuery :
/**
 * Open query for record field browse.
 *
 * @param phWindow = Handle of the query window.
 */

define input parameter phWindow as handle    no-undo.

define variable cQueryText as character no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

assign
  cQueryText =   'for each ttQueryWindowField':U
               + '  where ttQueryWindowField.WindowHandle = ~'&1~'':U
               + '    and ttQueryWindowField.Order        > 0':U
               + '  use-index &2':U
  cQueryText = substitute(cQueryText,
                          string(bttQueryWindow.WindowHandle),
                          (if can-find(first ttQueryWindowField
                                         where ttQueryWindowField.WindowHandle = bttQueryWindow.WindowHandle
                                           and ttQueryWindowField.Order        > 1) then
                             'Order':U
                           else
                             'Main':U))
  .

qg_lQueryOpen(bttQueryWindow.RecordQueryHandle,
              cQueryText,
              bttQueryWindow.WindowHandle).

end procedure.

PROCEDURE qg_QueryWindowRecordRefresh :
/**
 * Refresh record field browse with current database values.
 *
 * @param phWindow = Handle of the record window.
 */

define input parameter phWindow as handle    no-undo.

define variable hBuffer as handle    no-undo.
define variable hField  as handle    no-undo.

define buffer bttQueryWindow      for temp-table ttQueryWindow.

define buffer bttQueryWindowField for temp-table ttQueryWindowField.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

for each bttQueryWindowField
  where bttQueryWindowField.WindowHandle = bttQueryWindow.WindowHandle
  on error undo, throw:

  run qg_UpdateRecordField( bttQueryWindowField.FieldHandle,
                            bttQueryWindowField.FieldIndex,
                            ( buffer bttQueryWindowField:handle ),
                            bttQueryWindow.DeepResolveObjectIds ).

end.

run qg_QueryWindowRecordUpdateValues(bttQueryWindow.WindowHandle).
run qg_QueryWindowRecordUpdateTitle(bttQueryWindow.WindowHandle).

end procedure.

PROCEDURE qg_QueryWindowRecordSelectFields :
/**
 * Select displayed fields.
 *
 * @param phWindow = Handle of the record window.
 */

define input parameter phWindow as handle    no-undo.

define variable cAvailableField_Keys   as character no-undo.
define variable cAvailableField_Labels as character no-undo.
define variable cSelectedField_Keys    as character no-undo.

define variable lOk                    as logical   no-undo.

define buffer bttQueryWindow      for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

assign
  cAvailableField_Keys   = qg_cQueryWindowFieldList(bttQueryWindow.WindowHandle,
                                                    yes,
                                                    yes)
  cAvailableField_Labels = qg_cQueryWindowFieldList(bttQueryWindow.WindowHandle,
                                                    no,
                                                    yes)
  cSelectedField_Keys    = qg_cQueryWindowFieldList(bttQueryWindow.WindowHandle,
                                                    yes,
                                                    no)
  .

run qg_SelectionDialog(cAvailableField_Keys,
                       cAvailableField_Labels,
                       input-output cSelectedField_Keys,
                       'Select fields':U,
                       bttQueryWindow.WindowHandle,
                       yes,
                       output lOk).

if lOk then
  run qg_QueryWindowRecordSetFields(bttQueryWindow.WindowHandle,
                                    cSelectedField_Keys).

end procedure.

PROCEDURE qg_QueryWindowRecordSetFields :
/**
 * Set displayed fields.
 *
 * @param phWindow = Handle of the record window.
 * @param pcSelectedFields = Selected fields that should be set.
 */

define input parameter phWindow         as handle    no-undo.
define input parameter pcSelectedFields as character no-undo.

define variable cFieldName as character no-undo.

define buffer bttQueryWindow      for temp-table ttQueryWindow.

define buffer bttQueryWindowField for temp-table ttQueryWindowField.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

for each bttQueryWindowField
  where bttQueryWindowField.WindowHandle = bttQueryWindow.WindowHandle
  on error undo, throw:

  assign
    cFieldName                = qg_cFormattedFieldName( ?,
                                                        bttQueryWindowField.BufferName,
                                                        bttQueryWindowField.FieldName,
                                                        bttQueryWindowField.FieldIndex )
    bttQueryWindowField.Order = ( if pcSelectedFields > '':U then
                                    lookup( (if bttQueryWindowField.IsOverlay then
                                               substitute( {&K_OBJECTID_OVERLAY_NAME_PATTERN},
                                                           cFieldName )
                                             else
                                               cFieldName ),
                                           pcSelectedFields )
                                  else
                                    1 )
    .

end.

run qg_QueryWindowRecordOpenQuery( bttQueryWindow.WindowHandle ).
run qg_QueryWindowRecordUpdateValues( bttQueryWindow.WindowHandle ).

end procedure.

PROCEDURE qg_QueryWindowRecordUpdateTitle :
/**
 * Update record window title.
 *
 * @param phWindow = Handle of the record window.
 */

define input parameter phWindow as handle    no-undo.

define variable hQuery        as handle    no-undo.
define variable hBuffer       as handle    no-undo.

define variable cDatabaseName as character no-undo.

define variable cTitle        as character no-undo.
define variable cFieldValue   as character no-undo.
define variable clFieldValue  as longchar  no-undo.

define buffer bttQueryWindow      for temp-table ttQueryWindow.

define buffer bttField            for temp-table ttField.
define buffer bttQueryWindowField for temp-table ttQueryWindowField.
define buffer bttIndex            for temp-table ttIndex.
define buffer bttIndexField       for temp-table ttIndexField.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hQuery = bttQueryWindow.QueryHandle.

if    valid-handle(hQuery)
  and hQuery:num-buffers > 0 then
  hBuffer = hQuery:get-buffer-handle(1).

if not valid-handle(hBuffer) then
  assign
    bttQueryWindow.WindowTitle = substitute('&1[&2] Record - unknown':U,
                                            gcTitlePrefix,
                                            bttQueryWindow.QuerySeq).

else
do:

  cDatabaseName = qg_cDatabaseNameForTableOrBuffer( hBuffer ).

  if not hBuffer:available then
    cTitle = 'not available':T.

  else
  do:

    find first bttIndex
      where bttIndex.DatabaseName = cDatabaseName
        and bttIndex.TableName    = hBuffer:table
        and bttIndex.IsPrimary    = yes
      no-error.

    if not available bttIndex then
      cTitle = substitute('Rowid: &1':T, hBuffer:rowid).

    else
    do:

      for each bttIndexField
        where bttIndexField.DatabaseName = bttIndex.DatabaseName
          and bttIndexField.TableName    = bttIndex.TableName
          and bttIndexField.IndexName    = bttIndex.IndexName,
      first bttField
        where bttField.DatabaseName = bttIndexField.DatabaseName
          and bttField.TableName    = bttIndexField.TableName
          and bttField.FieldName    = bttIndexField.FieldName,
      first bttQueryWindowField
        where bttQueryWindowField.WindowHandle = bttQueryWindow.WindowHandle
          and bttQueryWindowField.BufferName   = hBuffer:name
          and bttQueryWindowField.FieldName    = bttIndexField.FieldName 
          and bttQueryWindowField.FieldIndex   = 0
        by bttIndexField.IndexSequence
        on error undo, throw:

        copy-lob bttQueryWindowField.CurrentUnformattedValue to clFieldValue.

        // If the quoter function is used directly the result ist an odd
        // character sequence. To avoid this we have to do it in two steps

        assign
          cFieldValue = substring(clFieldValue, 1, 30)
          cTitle      = substitute('&1, &2':U,
                                   cTitle,
                                   (if bttField.DataType = 'character':U then
                                      quoter(cFieldValue)
                                    else
                                      cFieldValue))
          .

      end.

      cTitle = trim(cTitle, ',':U).

    end.

  end.

  bttQueryWindow.WindowTitle = substitute('&1[&2] Record - &3.&4 (&5)':U,
                                          gcTitlePrefix,
                                          bttQueryWindow.QuerySeq,
                                          cDatabaseName,
                                          hBuffer:table,
                                          cTitle).

end.

bttQueryWindow.WindowHandle:title = bttQueryWindow.WindowTitle.

end procedure.

PROCEDURE qg_QueryWindowRecordUpdateValues :
/**
 * Refresh displayed values of record field browse.
 *
 * @param phWindow = Handle of the record window.
 */

define input parameter phWindow as handle    no-undo.

define buffer bttQueryWindow      for temp-table ttQueryWindow.

define buffer bttQueryWindowField for temp-table ttQueryWindowField.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

for each bttQueryWindowField
  where bttQueryWindowField.WindowHandle = bttQueryWindow.WindowHandle
  on error undo, throw:

  run qg_UpdateRecordFieldDisplayValue((buffer bttQueryWindowField:handle),
                                        bttQueryWindow.DisplayRawValues,
                                        255). 

end.

if bttQueryWindow.RecordQueryHandle:num-results > 0 then
  bttQueryWindow.RecordBrowseHandle:refresh().

end procedure.

PROCEDURE qg_QueryWindowRecordViewMenuDrop :
/**
 *
 *
 * @param phWindow = Handle of the record window.
 */

define input parameter phWindow as handle    no-undo.

define variable hRawValues as handle    no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

assign
  hRawValues         = qg_hGetWidgetByName(bttQueryWindow.RecordMenuHandle,
                                           'mi_RawValues':U)
  hRawValues:checked = bttQueryWindow.DisplayRawValues
  .

end procedure.

PROCEDURE qg_QueryWindowResize :
/**
 * Resize widgets to match the current window size.
 *
 * @param phWindow = Window that contains the widgets.
 */

define input parameter phWindow as handle    no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

case bttQueryWindow.WindowMode:

  when {&K_QUERY_WINDOW_MODE_QUERY} then
    run qg_QueryWindowResizeQueryFrame(bttQueryWindow.WindowHandle).

  when {&K_QUERY_WINDOW_MODE_RECORD} then
    run qg_QueryWindowResizeRecordFrame(bttQueryWindow.WindowHandle).

end case.

end procedure.

PROCEDURE qg_QueryWindowResizeQueryFrame :
/**
 * Resize widgets to match the current window size.
 *
 * @param phFrame = Frame that contains the widgets.
 */

define input parameter phWindow as handle    no-undo.

define variable hFrame       as handle    no-undo.
define variable hFieldGroup  as handle    no-undo.
define variable hWidget      as handle    no-undo.

define variable hSplitter1   as handle    no-undo.
define variable hFieldBrowse as handle    no-undo.

define variable dNewRow      as decimal   no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hFrame = bttQueryWindow.QueryFrameHandle.

assign
  hSplitter1            = qg_hGetWidgetByName(phWindow, 'btnSplitter1':U)
  hFieldBrowse          = qg_hGetWidgetByName(phWindow, 'brFieldSelection':U)
  hSplitter1:row        = (if hFieldBrowse:hidden then
                             hSplitter1:row
                           else
                             max(3, hSplitter1:row))
  phWindow:height       = max(hSplitter1:row + hSplitter1:height + 3, phWindow:height)
  phWindow:width        = (if hFieldBrowse:hidden then
                             max(50, phWindow:width)
                           else
                             max(100, phWindow:width))
  hFrame:width          = max(1, phWindow:width)
  hFrame:virtual-width  = max(1, phWindow:width)
  hFrame:height         = max(1, phWindow:height)
  hFrame:virtual-height = max(1, phWindow:height)
  hSplitter1:width      = phWindow:width
  hSplitter1:row        = min(phWindow:height - 2,
                              max((if hFieldBrowse:hidden then
                                     3
                                   else
                                     3),
                                   hSplitter1:row))
  no-error.

hFieldGroup = hFrame:first-child.

do while valid-handle(hFieldGroup):

  hWidget = hFieldGroup:first-child.

  do while valid-handle(hWidget):

    case hWidget:name:

      when 'brQuery':U then
        assign
          hWidget:width  = max(1, phWindow:width)
          dNewRow        = hSplitter1:row + hSplitter1:height
          hWidget:height = max(1, phWindow:height - dNewRow + 1)
          hWidget:row    = dNewRow
          no-error.

      when 'cQueryText':U then
        assign
          hWidget:width  = (if hFieldBrowse:hidden then
                              max(1, phWindow:width - 23)
                            else
                              max(1, phWindow:width - 73))
          hWidget:height = hSplitter1:row - 1
          .

      when 'btnToggleFieldBrowse':U then
        assign
          hWidget:col    = (if hFieldBrowse:hidden then
                              max(1, phWindow:width - 22)
                            else
                              max(1, phWindow:width - 72))
          hWidget:height = hSplitter1:row - 1
          .

      when 'brFieldSelection':U then
        if not hWidget:hidden then
          assign
            hWidget:height = hSplitter1:row - 1
            hWidget:col    = max(1, phWindow:width - 69)
            no-error.

      when 'btnExecute':U then
        assign
          hWidget:col = max(1, phWindow:width - 19)
          no-error.

      when 'btnColumns':U then
        assign
          hWidget:col = max(1, phWindow:width - 19)
          no-error.

      when 'btnEdit':U then
        assign
          hWidget:col = max(1, phWindow:width - 19)
          no-error.

      when 'btnDelete':U then
        assign
          hWidget:col = max(1, phWindow:width - 19)
          no-error.

      when 'btnCreate':U then
        assign
          hWidget:col = max(1, phWindow:width - 19)
          no-error.

      when 'btnDuplicate':U then
        assign
          hWidget:col = max(1, phWindow:width - 19)
          no-error.

    end.

    hWidget = hWidget:next-sibling.

  end.

  hFieldGroup = hFieldGroup:next-sibling.

end.

// Since widgets might be moved after the frame has been resized there will
// somtimes be unnessesary scrollbars. As a workaround this can be avoided
// by setting the width attribute a second time.

hFrame:width = hFrame:width no-error.

end procedure.

PROCEDURE qg_QueryWindowResizeRecordFrame :
/**
 * Adjust all widgets size and position according to current window size.
 *
 * @param phWindow = Handle of the record window.
 */

define input parameter phWindow as handle    no-undo.

define variable hFrame      as handle    no-undo.
define variable hFieldGroup as handle    no-undo.
define variable hWidget     as handle    no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hFrame = bttQueryWindow.RecordFrameHandle.

assign
  phWindow:height       = max(6, phWindow:height)
  phWindow:width        = max(75, phWindow:width)
  hFrame:width          = max(1, phWindow:width)
  hFrame:virtual-width  = max(1, phWindow:width)
  hFrame:height         = max(1, phWindow:height)
  hFrame:virtual-height = max(1, phWindow:height)
  no-error.

hFieldGroup = hFrame:first-child.

do while valid-handle(hFieldGroup):

  hWidget = hFieldGroup:first-child.

  do while valid-handle(hWidget):

    case hWidget:name:

      when 'brRecord':U then
        assign
          hWidget:width  = max(1, phWindow:width)
          hWidget:height = max(1, phWindow:height - hWidget:row + 1)
          no-error.

      when 'btnSelectObjField':U then
        assign
          hWidget:col = max(1, phWindow:width - 7)
          no-error.

      when 'btnFirstRecord':U then
        assign
          hWidget:col = max(1, phWindow:width - 25)
          no-error.

      when 'btnPrevRecord':U then
        assign
          hWidget:col = max(1, phWindow:width - 19)
          no-error.

      when 'btnNextRecord':U then
        assign
          hWidget:col = max(1, phWindow:width - 13)
          no-error.

      when 'btnLastRecord':U then
        assign
          hWidget:col = max(1, phWindow:width - 7)
          no-error.

    end.

    hWidget = hWidget:next-sibling.

  end.

  hFieldGroup = hFieldGroup:next-sibling.

end.

end procedure.

PROCEDURE qg_QueryWindowSelectNextCondition :
/**
 * Select next condition in query text editor.
 *
 * @param phWindow = Handle of the Query window.
 * @param plNext = If yes the next condition will be selected otherwise the previous condition will be selected.
 */

define input parameter phWindow as handle    no-undo.
define input parameter plNext   as logical   no-undo.

define buffer bttQueryWindow  for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if not qg_lSelectNextQueryCondition(bttQueryWindow.QueryTextEditorHandle, plNext) then
do:

  if plNext = yes then
    bttQueryWindow.QueryTextEditorHandle:cursor-offset = 1.

  else if plNext = no then
    bttQueryWindow.QueryTextEditorHandle:move-to-eof().

  qg_lSelectNextQueryCondition(bttQueryWindow.QueryTextEditorHandle, plNext).

end.

return no-apply.

end procedure.

PROCEDURE qg_QueryWindowEditQueryBuffers :
/**
 * Select next condition in query text editor.
 *
 * @param phWindow = Handle of the Query window.
 * @param plNext = If yes the next condition will be selected otherwise the previous condition will be selected.
 */

define input parameter phWindow as handle    no-undo.

define variable iFilterId         as integer   no-undo.
define variable lShowHiddenTables as logical   no-undo.

define variable i                 as integer   no-undo.
define variable hBuffer           as handle    no-undo.

define variable cQueryText        as character no-undo.
define variable cWhereClause      as character no-undo.
define variable cBufferList       as character no-undo.

define variable lMatch            as logical   no-undo.
define variable lContinuous       as logical   no-undo.
define variable iIndexScore       as integer   no-undo extent 2.
define variable iTempIndexScore   as integer   no-undo extent 2.
define variable cFieldList        as character no-undo.
define variable cTempFieldList    as character no-undo.
define variable cValueList        as character no-undo.
define variable cTempValueList    as character no-undo.

define buffer bttQueryWindow       for temp-table ttQueryWindow.

define buffer bttDatabase          for temp-table ttDatabase.
define buffer bttTable             for temp-table ttTable.
define buffer bttField             for temp-table ttField.
define buffer bttIndex             for temp-table ttIndex.
define buffer bttIndexField        for temp-table ttIndexField.
define buffer bttFilterMatch       for temp-table ttFilterMatch.
define buffer bttQueryBuffer       for temp-table ttQueryBuffer.
define buffer b2ttQueryBuffer      for temp-table ttQueryBuffer.
define buffer bttTableRelation     for temp-table ttTableRelation.
define buffer bttTableRelationView for temp-table ttTableRelationView.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

define query brBufferDatabase
  for bttDatabase
  scrolling.

define browse brBufferDatabase
  query brBufferDatabase no-lock
    display
      bttDatabase.DatabaseName width 12
      bttDatabase.PhysicalName
      with no-assign size 70 by 5.

define variable lRelatedTables as logical no-undo init yes
  format 'yes/no':U
  view-as radio-set
    radio-buttons
      'Related tables':T, yes,
      'All tables':T, no
    horizontal
  size 35 by 1.

define variable cTableFilter as character no-undo
  format 'x(32000)':U
  view-as combo-box inner-lines 8
     drop-down
  tooltip "Filter for tables that match given name pattern (comma separated)"
  size 63 by 1.

define button btnClearTableFilter
  label '':T2
  tooltip "Clear table filter"
  size 7 by 1.

define query brBufferTable
  for bttTable,bttFilterMatch
  scrolling.

define browse brBufferTable
  query brBufferTable no-lock
    display
      bttTable.TableName
      bttTable.ShortDescription
      with no-assign size 70 by 10.

define button btnAddTableBuffer
  label 'Add':T
  size 10 by 1.5.

define button btnRemoveTableBuffer
  label 'Remove':T
  size 10 by 1.5.

define button btnEditTableBuffer
  label 'Edit':T
  size 10 by 1.5.

define button btnClearTableBuffers
  label 'Clear':T
  size 10 by 1.5.

define button btnTop
  label 'Top':T
  size 10 by 1.5.

define button btnUp
  label 'Up':T
  size 10 by 1.5.

define button btnDown
  label 'Down':T
  size 10 by 1.5.

define button btnBottom
  label 'Bottom':T
  size 10 by 1.5.

define query brQueryBuffer
  for bttQueryBuffer
  scrolling.

define browse brQueryBuffer
  query brQueryBuffer no-lock
    display
      bttQueryBuffer.BufferName width 32
      bttQueryBuffer.TableDisplayName
      with no-assign size 70 by 18.

define button btnOk
  label 'Ok':T
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.

define frame fBufferSelection
  brBufferDatabase at row 1.5 col 3
  lRelatedTables at row 7 col 3 no-label
  cTableFilter at row 8.5 col 3 no-label
  btnClearTableFilter at row 8.5 col 66
  brBufferTable at row 9.5 col 3
  brQueryBuffer at row 1.5 col 91
  btnAddTableBuffer at row 1.5 col 77
  btnRemoveTableBuffer at row 3 col 77
  btnEditTableBuffer at row 5 col 77
  btnClearTableBuffers at row 8.75 col 77
  btnTop at row 12.5 col 77
  btnUp at row 14.5 col 77
  btnDown at row 16 col 77
  btnBottom at row 18 col 77
  btnOk at row 20.5 col 62
  btnCancel at row 20.5 col 82
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 163 by 22.33
    title gcTitlePrefix + 'Select query buffers':T
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fBufferSelection
  apply 'end-error' to self.

on F3 of frame fBufferSelection anywhere
do:

  lRelatedTables = not input frame fBufferSelection lRelatedTables.

  display unless-hidden
    lRelatedTables
    with frame fBufferSelection.

  apply 'value-changed':U to lRelatedTables in frame fBufferSelection.

end.

on ins of frame fBufferSelection anywhere
do:

  define variable hFocusWidget as handle    no-undo.

  hFocusWidget = focus.

  if valid-handle(hFocusWidget) then
  do:

    // Fire leave trigger but keep focus in active widget.
    apply 'leave':U to hFocusWidget.
    apply 'entry':U to hFocusWidget.

  end.

  apply 'choose':U to btnAddTableBuffer in frame fBufferSelection.

end.

on del of frame fBufferSelection anywhere
  apply 'choose':U to btnRemoveTableBuffer in frame fBufferSelection.

on value-changed of brBufferDatabase in frame fBufferSelection
do:

  define buffer bttTable       for temp-table ttTable.
  define buffer bttFilterMatch for temp-table ttFilterMatch.

  if    available(bttDatabase)
    and bttDatabase.PhysicalDB
    and not can-find(first ttTable
                       where ttTable.DatabaseName = bttDatabase.DatabaseName) then
  do:

    run qg_AddTables(bttDatabase.DatabaseName).

    for each bttTable
      where bttTable.DatabaseName = bttDatabase.DatabaseName
      on error undo, throw:

      create bttFilterMatch.

      assign
        bttFilterMatch.FilterId      = iFilterId
        bttFilterMatch.RecordRowId   = rowid(bttTable)
        bttFilterMatch.RecordMatches = yes
        .

      validate bttFilterMatch.

    end.

  end.

  apply 'U1':U to brBufferTable in frame fBufferSelection.

end.

on value-changed of lRelatedTables in frame fBufferSelection
  apply 'U1':U to brBufferTable in frame fBufferSelection.

on value-changed of cTableFilter in frame fBufferSelection
  apply 'U1':U to brBufferTable in frame fBufferSelection.

on choose of btnClearTableFilter in frame fBufferSelection
do:

  cTableFilter = '':U.

  display unless-hidden
    cTableFilter
    with frame fBufferSelection.

  apply 'value-changed':U to cTableFilter in frame fBufferSelection.

end.

on U1 of brBufferTable in frame fBufferSelection
do:

  define variable cDatabaseName       as character no-undo.
  define variable cFilterEntry        as character no-undo.
  define variable cPrepFilter         as character no-undo.

  define variable i                   as integer       no-undo.

  define variable cBufferDatabaseName as character no-undo.
  define variable cBufferTableName    as character no-undo.

  assign
    cDatabaseName  = (if available bttDatabase then
                        bttDatabase.DatabaseName
                      else
                        ?)
    cTableFilter   = input frame fBufferSelection cTableFilter
    lRelatedTables = input frame fBufferSelection lRelatedTables
    .

  if not available bttQueryBuffer then
    cBufferDatabaseName = cDatabaseName.

  else
    assign
      cBufferDatabaseName = bttQueryBuffer.DatabaseName
      cBufferTableName    = bttQueryBuffer.TableName
      .

  do i = 1 to num-entries(cTableFilter):

    assign
      cFilterEntry = entry(i, cTableFilter).
      cPrepFilter  = substitute('&1,&2':U,
                                cPrepFilter,
                                qg_cFilterEntryMatchcode(cFilterEntry))
      .

  end.

  cPrepFilter = (if cPrepFilter = '':U then
                   '*':U
                 else
                   trim(cPrepFilter, ',':U)).

  for each bttTable
    where bttTable.DatabaseName = cDatabaseName,
  first bttFilterMatch
    where bttFilterMatch.FilterId    = iFilterId
      and bttFilterMatch.RecordRowId = rowid(bttTable)
    on error undo, throw:

    bttFilterMatch.RecordMatches =     can-do(cPrepFilter, bttTable.TableName)
                                   and ( lShowHiddenTables
                                      or ( not can-do('sys*':U, bttTable.TableName)
                                       and not can-do('_*':U, bttTable.TableName) ) )
                                   and ( not lRelatedTables
                                      or cBufferTableName = '':U 
                                      or can-find(first ttTableRelationView
                                                    where ttTableRelationView.DatabaseName       = cBufferDatabaseName
                                                      and ttTableRelationView.ReferenceTableName = cBufferTableName
                                                      and ttTableRelationView.RelatedTableName   = bttTable.TableName ) ).

    validate bttFilterMatch.

  end.

  open query brBufferTable
    for each bttTable
      where bttTable.DatabaseName = cDatabaseName,
    first bttFilterMatch
      where bttFilterMatch.FilterId      = iFilterId
        and bttFilterMatch.RecordRowId   = rowid(bttTable)
        and bttFilterMatch.RecordMatches = yes
      .

  apply 'value-changed':U to browse brBufferTable.

end.

on leave of cTableFilter in frame fBufferSelection
do:

  if available bttDatabase then
    run qg_FixCase(cTableFilter:handle in frame fBufferSelection,
                   bttDatabase.DatabaseName,
                   ?,
                   {&K_CASEMODE_TABLE}).

  if brBufferTable:query:num-results > 0 then
    run qg_AddFieldHistoryEntry(cTableFilter:handle in frame fBufferSelection).

end.

on end-error of cTableFilter in frame fBufferSelection
do:

  apply 'choose':U to btnClearTableFilter in frame fBufferSelection.
  return no-apply.

end.

on default-action of brBufferTable in frame fBufferSelection
  apply 'choose':U to btnAddTableBuffer in frame fBufferSelection.

on row-display of brBufferTable in frame fBufferSelection
do:

  if    not bttTable.DescriptionLoaded

    // For performance reasons we only do this when the database is connected
    // in shared memory mode.

    and ( available bttDatabase
      and ( bttDatabase.SharedMemory
         or not bttDatabase.PhysicalDB ) ) then

    run qg_AddTableRepositoryInfo(bttTable.DatabaseName, bttTable.TableName).

  bttTable.ShortDescription:fgcolor in browse brBufferTable = {&K_COLOR_LIGHT_GREY}.

end.

on U1 of brQueryBuffer in frame fBufferSelection
do:

  open query brQueryBuffer
    for each bttQueryBuffer
    use-index Order.

  apply 'value-changed':U to brQueryBuffer in frame fBufferSelection.

end.

on value-changed of brQueryBuffer in frame fBufferSelection
do:

  if input frame fBufferSelection lRelatedTables then
    apply 'U1':U to brBufferTable in frame fBufferSelection.

end.

on choose of btnAddTableBuffer in frame fBufferSelection
do:

  define variable iOrder      as integer   no-undo.

  define variable iBuffer     as integer   no-undo.
  define variable cBufferName as character no-undo.

  define buffer bttQueryBuffer for temp-table ttQueryBuffer.

  find last bttQueryBuffer
    where bttQueryBuffer.QuerySeq = bttQueryWindow.QuerySeq
    use-index Order
    no-error.

  iOrder = (if available bttQueryBuffer then
              bttQueryBuffer.Order + 1
            else
              1).

  if available bttTable then
  do:

    do while yes:

      case iBuffer:

        when 0 then
          cBufferName = bttTable.TableName.

        when 1 then
          cBufferName = substitute('b&1':U,
                                   bttTable.TableName).

        otherwise
          cBufferName = substitute('b&1&2':U,
                                   string(iBuffer),
                                   bttTable.TableName).

      end case.

      find bttQueryBuffer
        where bttQueryBuffer.QuerySeq   = bttQueryWindow.QuerySeq
          and bttQueryBuffer.BufferName = cBufferName
        no-error.

      if not available bttQueryBuffer then
        leave.

      iBuffer = iBuffer + 1.

    end.

    create bttQueryBuffer.

    assign
      bttQueryBuffer.QuerySeq         = bttQueryWindow.QuerySeq
      bttQueryBuffer.BufferName       = cBufferName
      bttQueryBuffer.DatabaseName     = bttTable.DatabaseName
      bttQueryBuffer.TableName        = bttTable.TableName
      bttQueryBuffer.TableDisplayName = substitute('&1.&2':U,
                                                   bttQueryBuffer.DatabaseName,
                                                   bttQueryBuffer.TableName)
      bttQueryBuffer.Order            = iOrder
      .

    validate bttQueryBuffer.

    if not bttTable.DetailsLoaded then
      run qg_AddTableDetails(bttTable.DatabaseName,
                             bttTable.TableName).

    apply 'U1':U to brQueryBuffer in frame fBufferSelection.

    if    query brQueryBuffer:num-results > 0
      and can-find(first ttFilterMatch
                     where ttFilterMatch.FilterId    = iFilterId
                       and ttFilterMatch.RecordRowId = rowid(bttTable)) then
    do:
      reposition brQueryBuffer to rowid rowid(bttQueryBuffer) no-error.
      apply 'value-changed':U to brQueryBuffer in frame fBufferSelection.
    end.

  end.

end.

on choose of btnRemoveTableBuffer in frame fBufferSelection
do:

  define variable iOrder    as integer   no-undo.
  define variable iNewOrder as integer   no-undo.

  define buffer b2ttQueryBuffer for temp-table ttQueryBuffer.

  if available bttQueryBuffer then
  do:

    assign
      iOrder    = bttQueryBuffer.Order
      iNewOrder = iOrder
      .

    delete bttQueryBuffer.

    for each b2ttQueryBuffer
      where b2ttQueryBuffer.QuerySeq = bttQueryWindow.QuerySeq
        and b2ttQueryBuffer.Order    > iOrder
      use-index Order
      on error undo, throw:

      b2ttQueryBuffer.Order = iNewOrder.

      validate bttQueryBuffer.

      iNewOrder = iNewOrder + 1.

    end.

    apply 'U1':U to brQueryBuffer in frame fBufferSelection.

    find first b2ttQueryBuffer
      where b2ttQueryBuffer.QuerySeq = bttQuerywindow.QuerySeq
        and b2ttQueryBuffer.Order   >= iOrder
      use-index Order
      no-error.

    if not available b2ttQueryBuffer then
      find last b2ttQueryBuffer
        where b2ttQueryBuffer.QuerySeq = bttQueryWindow.QuerySeq
        use-index Order
        no-error.

    if    available b2ttQueryBuffer
      and query brQueryBuffer:num-results > 0 then
    do:
      reposition brQueryBuffer to rowid rowid(b2ttQueryBuffer) no-error.
      apply 'value-changed':U to brQueryBuffer in frame fBufferSelection.
    end.

  end.

end.

on choose of btnClearTableBuffers in frame fBufferSelection
do:

  define buffer bttQueryBuffer for temp-table ttQueryBuffer.

  for each bttQueryBuffer
    where bttQueryBuffer.QuerySeq = bttQueryWindow.QuerySeq
    on error undo, throw:

    delete bttQueryBuffer.

  end.

  apply 'U1':U to brQueryBuffer in frame fBufferSelection.

end.

on choose of btnTop in frame fBufferSelection
do:

  define variable iOrder as integer   no-undo.
  define variable rRowId as rowid     no-undo.

  define buffer b2ttQueryBuffer for temp-table ttQueryBuffer.

  if    available bttQueryBuffer
    and bttQueryBuffer.Order > 1 then
  do:

    for each b2ttQueryBuffer
      where b2ttQueryBuffer.QuerySeq = bttQueryWindow.QuerySeq
        and b2ttQueryBuffer.Order    < bttQueryBuffer.Order
      use-index Order
      on error undo, throw:

      b2ttQueryBuffer.Order = b2ttQueryBuffer.Order + 1.

    end.

    bttQueryBuffer.Order = 1.

    rRowId = rowid(bttQueryBuffer).

    apply 'U1':U to brQueryBuffer in frame fBufferSelection.

    reposition brQueryBuffer to rowid rRowId no-error.

  end.

end.

on choose of btnUp in frame fBufferSelection
do:

  define variable iOrder as integer   no-undo.
  define variable rRowId as rowid     no-undo.

  define buffer b2ttQueryBuffer for temp-table ttQueryBuffer.

  if    available bttQueryBuffer
    and bttQueryBuffer.Order > 1 then
  do:

    find last b2ttQueryBuffer
      where b2ttQueryBuffer.QuerySeq = bttQueryWindow.QuerySeq
        and b2ttQueryBuffer.Order    < bttQueryBuffer.Order
      use-index Order
      no-error.

    if available b2ttQueryBuffer then
    do:

      assign
        iOrder                 = bttQueryBuffer.Order
        bttQueryBuffer.Order   = b2ttQueryBuffer.Order
        b2ttQueryBuffer.Order  = iOrder
        .

      validate bttQueryBuffer.
      validate b2ttQueryBuffer.

      rRowId = rowid(bttQueryBuffer).

      apply 'U1':U to brQueryBuffer in frame fBufferSelection.

      reposition brQueryBuffer to rowid rRowId no-error.

    end.

  end.

end.

on choose of btnDown in frame fBufferSelection
do:

  define variable iOrder as integer   no-undo.
  define variable rRowId as rowid     no-undo.

  define buffer b2ttQueryBuffer for temp-table ttQueryBuffer.

  if available bttQueryBuffer then
  do:

    find first b2ttQueryBuffer
      where b2ttQueryBuffer.QuerySeq = bttQueryWindow.QuerySeq
        and b2ttQueryBuffer.Order    > bttQueryBuffer.Order
      use-index Order
      no-error.

    if available b2ttQueryBuffer then
    do:

      assign
        iOrder                 = bttQueryBuffer.Order
        bttQueryBuffer.Order   = b2ttQueryBuffer.Order
        b2ttQueryBuffer.Order  = iOrder
        .

      validate bttQueryBuffer.
      validate b2ttQueryBuffer.

      rRowId = rowid(bttQueryBuffer).

      apply 'U1':U to brQueryBuffer in frame fBufferSelection.

      reposition brQueryBuffer to rowid rRowId.

    end.

  end.

end.

on choose of btnBottom in frame fBufferSelection
do:

  define variable iOrder as integer   no-undo.
  define variable rRowId as rowid     no-undo.

  define buffer b2ttQueryBuffer for temp-table ttQueryBuffer.

  if available bttQueryBuffer then
  do:

    find last b2ttQueryBuffer
      where b2ttQueryBuffer.QuerySeq = bttQueryWindow.QuerySeq
      use-index Order
      no-error.

    if    available b2ttQueryBuffer
      and b2ttQueryBuffer.Order > bttQueryBuffer.Order then
    do:

      iOrder = b2ttQueryBuffer.Order.

      for each b2ttQueryBuffer
        where b2ttQueryBuffer.QuerySeq = bttQueryWindow.QuerySeq
          and b2ttQueryBuffer.Order    > bttQueryBuffer.Order
        use-index Order
        on error undo, throw:

        b2ttQueryBuffer.Order = b2ttQueryBuffer.Order - 1.

      end.

      bttQueryBuffer.Order = iOrder.

      rRowId = rowid(bttQueryBuffer).

      apply 'U1':U to brQueryBuffer in frame fBufferSelection.

      reposition brQueryBuffer to rowid rRowId.

    end.

  end.

end.

iFilterId = qg_iFilterSeq().

for each bttTable
  on error undo, throw:

  create bttFilterMatch.

  assign
    bttFilterMatch.FilterId      = iFilterId
    bttFilterMatch.RecordRowId   = rowid(bttTable)
    bttFilterMatch.RecordMatches = yes
    .

  validate bttFilterMatch.

end.

empty temp-table ttQueryBuffer.

do i = 1 to bttQueryWindow.QueryHandle:num-buffers:

  hBuffer = bttQueryWindow.QueryHandle:get-buffer-handle(i).

  create bttQueryBuffer.

  assign
    bttQueryBuffer.QuerySeq         = bttQueryWindow.QuerySeq
    bttQueryBuffer.BufferName       = hBuffer:name
    bttQueryBuffer.DatabaseName     = qg_cDatabaseNameForTableOrBuffer( hBuffer )
    bttQueryBuffer.TableName        = hBuffer:table
    bttQueryBuffer.TableDisplayName = substitute('&1.&2':U,
                                                 bttQueryBuffer.DatabaseName,
                                                 bttQueryBuffer.TableName)
    bttQueryBuffer.Order            = i
    .

end.

display unless-hidden
  brBufferDatabase
  lRelatedTables
  cTableFilter
  brBufferTable
  brQueryBuffer
  with frame fBufferSelection
    in window bttQueryWindow.WindowHandle.

assign
  cTableFilter:delimiter in frame fBufferSelection
      = chr(1)
  cTableFilter:list-items in frame fBufferSelection
      = gcTableFilter:list-items in frame {&FRAME-NAME}
  .

run qg_InitBrowse(browse brBufferDatabase:handle).
run qg_InitBrowse(browse brBufferTable:handle).
run qg_InitBrowse(browse brQueryBuffer:handle).

apply 'U1':U to brQueryBuffer in frame fBufferSelection.

open query brBufferDatabase
  for each bttDatabase
    no-lock.

apply 'value-changed':U to brBufferDatabase in frame fBufferSelection.

update unless-hidden
  cTableFilter
  btnClearTableFilter
  brBufferTable
  btnAddTableBuffer
  btnRemoveTableBuffer
  btnEditTableBuffer
  btnClearTableBuffers
  btnTop
  btnUp
  btnDown
  btnBottom
  brQueryBuffer
  btnOk
  btnCancel
  brBufferDatabase
  lRelatedTables
  with frame fBufferSelection
    in window bttQueryWindow.WindowHandle.

for each bttQueryBuffer
  where bttQueryBuffer.QuerySeq = bttQueryWindow.QuerySeq
  by bttQueryBuffer.Order
  on error undo, throw:

  assign
    cQueryText   = (if cQueryText > '':U then
                      substitute('&1,~neach &2':U,
                                 cQueryText,
                                 bttQueryBuffer.BufferName)
                    else
                      substitute('for each &1':U,
                                 bttQueryBuffer.BufferName))
    cWhereClause = '':U
    cBufferList  = substitute('&1,&2.&3:&4',
                              cBufferList,
                              bttQueryBuffer.DatabaseName,
                              bttQueryBuffer.TableName,
                              bttQueryBuffer.BufferName)
    .

  find bttTable
    where bttTable.DatabaseName = bttQueryBuffer.DatabaseName
      and bttTable.TableName    = bttQueryBuffer.TableName
    no-error.

  if    available bttTable
    and not bttTable.DetailsLoaded then
    run qg_AddTableDetails(bttTable.DatabaseName,
                           bttTable.TableName).

  for each b2ttQueryBuffer
    where b2ttQueryBuffer.QuerySeq = bttQueryBuffer.QuerySeq
      and b2ttQueryBuffer.Order    < bttQueryBuffer.Order,
  first bttTableRelationView
    where bttTableRelationView.DatabaseName       = bttQueryBuffer.DatabaseName
      and bttTableRelationView.ReferenceTableName = bttQueryBuffer.TableName
      and bttTableRelationView.RelatedTableName   = b2ttQueryBuffer.TableName,
  first bttTableRelation
    where bttTableRelation.RelationId = bttTableRelationView.RelationId
    by b2ttQueryBuffer.Order descending
    on error undo, throw:

    cWhereClause = qg_cCreateRelatedWhereClause(buffer bttTableRelation,
                                                (bttTableRelation.ParentTableName = b2ttQueryBuffer.TableName),
                                                bttQueryBuffer.BufferName,
                                                b2ttQueryBuffer.BufferName,
                                                ?).

    if cWhereClause > '':U then
      leave.

  end.

  if   cWhereClause = ?
    or cWhereClause = '':U then
  do:

    assign
      iIndexScore     = 0
      cFieldList      = '':U
      cValueList      = '':U
      .

    for each bttIndex
      where ( bttIndex.DatabaseName = bttQueryBuffer.DatabaseName
          and bttIndex.TableName    = bttQueryBuffer.TableName
          and bttIndex.IsPrimary    = yes )
         or ( bttIndex.DatabaseName = bttQueryBuffer.DatabaseName
          and bttIndex.TableName    = bttQueryBuffer.TableName
          and bttIndex.IsPrimary    = no )
      on error undo, throw:

      assign
        lContinuous     = yes
        iTempIndexScore = 0
        cTempFieldList  = '':U
        cTempValueList  = '':U
        .

      for each bttIndexField
        where bttIndexField.DatabaseName = bttIndex.DatabaseName
          and bttIndexField.TableName    = bttIndex.Tablename
          and bttIndexField.IndexName    = bttIndex.IndexName
        by bttIndexField.IndexSequence
        on error undo, throw:

        lMatch = no.

        for each b2ttQueryBuffer
          where b2ttQueryBuffer.QuerySeq = bttQueryBuffer.QuerySeq
            and b2ttQueryBuffer.Order    < bttQueryBuffer.Order,
        each bttField
          where bttField.DatabaseName = b2ttQueryBuffer.DatabaseName
            and bttField.TableName    = b2ttQueryBuffer.TableName
            and bttField.FieldName    = bttIndexField.FieldName
          by b2ttQueryBuffer.Order descending
          on error undo, throw:

          assign
            cTempFieldList = substitute('&1,&2':U,
                                        cTempFieldList,
                                        bttIndexField.FieldName)
            cTempValueList = substitute('&1&2&3':U,
                                        cTempValueList,
                                        {&K_PARAM_SPLITTER},
                                        (if can-do({&K_COMPANY_FIELDS}, bttIndexField.FieldName) then
                                           substitute('~'&1~'',
                                                      qg_cGetCompany(bttField.TableName, ?))
                                         else
                                           qg_cFormattedFieldName(?,
                                                                  b2ttQueryBuffer.BufferName,
                                                                  bttField.FieldName,
                                                                  0)))
            lMatch         = yes
            .

        end.

        if not lMatch then
          lContinuous = no.

        else
          iTempIndexScore[2 - integer(lContinuous)] = iTempIndexScore[2 - integer(lContinuous)] + 1.

      end.

      if    iTempIndexScore[1] > iIndexScore[1]
         or ( iTempIndexScore[1] = iIndexScore[1]
          and iTempIndexScore[2] > iIndexScore[2] ) then
        assign
          cFieldList = trim(cTempFieldList, ',':U)
          cValueList = trim(cTempValueList, {&K_PARAM_SPLITTER})
          .

    end.

    if cFieldList > '':U then
      cWhereClause = qg_cCreateWhereClause( /* pcDatabaseName   */ bttQueryBuffer.DatabaseName,
                                            /* pcTableNames     */ bttQueryBuffer.TableName,
                                            /* pcBufferNames    */ bttQueryBuffer.BufferName,
                                            /* pcFieldList      */ cFieldList,
                                            /* pcFieldLabelList */ ?,
                                            /* plStartWithWhere */ yes,
                                            /* piValueMode      */ {&K_VALUE_MODE_PARAMETER},
                                            /* pcValueList      */ cValueList,
                                            /* piAccessMode     */ {&K_ACCESS_MODE_PHYSICAL},
                                            /* plAddTags        */ no,
                                            /* piIndentBlanks   */ 2 ).

  end.

  if cWhereClause > '':U then
    cQueryText = substitute('&1~n&2':U, cQuerytext, cWhereClause).

//  assign
//    cPrevDatabaseName = bttQueryBuffer.DatabaseName
//    cPrevTableName    = bttQueryBuffer.TableName
//    cPrevBufferName   = bttQueryBuffer.BufferName
//    .

end.

assign
  cBufferList              = trim(cBufferList, ',':U).
  bttQueryWindow.QueryText = cQueryText
  .

validate bttQuerywindow.

if valid-handle(bttQueryWindow.QueryFrameHandle) then
  bttQueryWindow.QueryTextEditorHandle:screen-value = bttQueryWindow.QueryText.

run qg_QueryWindowUpdateQuery(bttQueryWindow.WindowHandle, cBufferList).

//run qg_QueryWindowListRefresh.

//message
//  cQueryText skip
//  view-as alert-box
//  title program-name(1).

finally:

//  if cTableFilter:list-items in frame fBufferSelection > '':U then
//    assign
//      cTableFilter = input frame {&FRAME-NAME} gcTableFilter
//      gcTableFilter:list-items in frame {&FRAME-NAME}
//          = cTableFilter:list-items in frame fBufferSelection
//      gcTableFilter:screen-value in frame {&FRAME-NAME}
//          = cTableFilter
//      .

  if iFilterId > 0 then

    for each bttFilterMatch
      where bttFilterMatch.FilterId = iFilterId
      on error undo, next:

      delete bttFilterMatch.

    end.

  if available bttQueryWindow then

    for each bttQueryBuffer
      where bttQueryBuffer.QuerySeq = bttQueryWindow.QuerySeq
      on error undo, next:

      delete bttQueryBuffer.

    end.

end finally.

end procedure.

PROCEDURE qg_QueryWindowSetComparator :
define input parameter phWindow     as handle    no-undo.
define input parameter pcComparator as character no-undo.

define variable cQueryText   as character no-undo.
define variable iOffset      as integer   no-undo.

define variable i            as integer   no-undo.
define variable iConditionNo as integer   no-undo.

define buffer bttQueryWindow    for temp-table ttQueryWindow.
define buffer bttQueryCondition for temp-table ttQueryCondition.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if    bttQueryWindow.ObjSourceQuerySeq > 0
   or not valid-handle(bttQueryWindow.QueryFrameHandle) then
  leave.

assign
  iOffset    = bttQueryWindow.QueryTextEditorHandle:cursor-offset
  cQueryText = bttQueryWindow.QueryTextEditorHandle:input-value
  .

run qg_ParseQueryConditions(cQueryText).

for each bttQueryCondition
  on error undo, throw:

  i = i + 1.

  if    bttQueryCondition.StartPos <= iOffset
    and bttQueryCondition.EndPos   >= iOffset then
  do:

    iConditionNo = i.
    leave.

  end.

end.

if available bttQueryCondition then
  assign
    cQueryText = substitute('&1 &2 &3':U,
                            right-trim(substring(cQueryText,
                                                 1,
                                                 bttQueryCondition.ComparatorStartPos - 1)),
                            pcComparator,
                            left-trim(substring(cQueryText,
                                                bttQueryCondition.ComparatorEndPos)))
    cQueryText = qg_cBeautifyQueryText(cQuerytext)
    bttQueryWindow.QueryTextEditorHandle:screen-value  = cQueryText
    .

if iConditionNo > 0 then
do:

  run qg_ParseQueryConditions(cQueryText).

  i = 0.

  for each bttQueryCondition
    on error undo, throw:

    i = i + 1.

    if i = iConditionNo then
    do:

      bttQueryWindow.QueryTextEditorHandle:cursor-offset = bttQueryCondition.StartPos.
      run qg_QueryWindowSelectNextCondition(bttQueryWindow.WindowHandle, yes).

      leave.

    end.

  end.

  apply 'entry':U to bttQueryWindow.QueryTextEditorHandle.

end.

end procedure.

PROCEDURE qg_QueryWindowSetFocus :
/**
 * Set focus to given widget.
 *
 * @param phWindow = Handle of the Query window.
 * @param pcWidgetName = Name of the Widget to set focus to.
 */

define input parameter phWindow     as handle    no-undo.
define input parameter pcWidgetName as character no-undo.

define variable hWidget as handle    no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hWidget = qg_hGetWidgetByName(bttQueryWindow.WindowHandle, pcWidgetName).

if hWidget:name = 'cQueryText':U then
do:

  hWidget:cursor-offset = 1.
  qg_lSelectNextQueryCondition(hWidget, yes).

end.

apply 'entry':U to hWidget.

end procedure.

PROCEDURE qg_QueryWindowSetQueryText :
/**
 *
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow    as handle    no-undo.
define input parameter pcQueryText as character no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

bttQueryWindow.QueryText = pcQueryText.

run qg_ParseQueryLinks(bttQueryWindow.QueryText,
                       bttQueryWindow.QuerySeq,
                       temp-table ttQueryLink:handle).

run qg_QueryWindowListRefresh.

end procedure.

PROCEDURE qg_QueryWindowQuerySetQueryText :
/**
 * Set query text to given editor and place cursor to the first value.
 *
 * @param phEditor = Editor widget.
 * @param pcQueryText = Query text.
 */

define input parameter phWindow               as handle    no-undo.
define input parameter pcQueryText            as character no-undo.
define input parameter plSelectFirstCondition as logical   no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

assign
  bttQueryWindow.QueryTextEditorHandle:screen-value  = pcQueryText
  bttQueryWindow.QueryTextEditorHandle:cursor-offset = 1
  .

if plSelectFirstCondition then
  qg_lSelectNextQueryCondition(bttQueryWindow.QueryTextEditorHandle, yes).

end procedure.

PROCEDURE qg_QueryWindowSetSize :
/**
 * Set Query window to a predefined size.
 *
 * @param phWindow = Handle of the Query window.
 * @param piSize = Size code to use.
 */

define input parameter phWindow as handle    no-undo.
define input parameter piSize   as integer   no-undo.

define variable hSplitter1      as handle    no-undo.
define variable hFieldBrowse    as handle    no-undo.

define variable dSplitterMinRow as decimal   no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if bttQueryWindow.WindowMode = {&K_QUERY_WINDOW_MODE_QUERY} then
  assign
    hSplitter1      = qg_hGetWidgetByName(bttQueryWindow.QueryFrameHandle, 'btnSplitter1':U)
    hFieldBrowse    = qg_hGetWidgetByName(bttQueryWindow.QueryFrameHandle, 'brFieldSelection':U)
    dSplitterMinRow = (if hFieldBrowse:hidden then
                         3
                       else
                         4)
    .

case piSize:

  when {&K_QUERY_SIZE_MODE_DEFAULT} then
  do:

    if bttQueryWindow.WindowMode = {&K_QUERY_WINDOW_MODE_QUERY} then
      hSplitter1:row = 7 no-error.

    assign
      bttQueryWindow.WindowHandle:width  = 150
      bttQueryWindow.WindowHandle:height = 18
      no-error.

  end.

  when {&K_QUERY_SIZE_MODE_DEFAULT_SPLITTER} then
  do:

    if bttQueryWindow.WindowMode = {&K_QUERY_WINDOW_MODE_QUERY} then
    do:

      if    bttQueryWindow.WindowHandle:width  = 150
        and bttQueryWindow.WindowHandle:height = 18 then
      do:

        if hSplitter1:row < 7 then
          hSplitter1:row = truncate(hSplitter1:row, 0) + 1.

        else
          hSplitter1:row = dSplitterMinRow.

      end.

      hSplitter1:row = (if hSplitter1:row > 7 then
                          7
                        else
                          hSplitter1:row).

    end.

    assign
      bttQueryWindow.WindowHandle:width  = 150
      bttQueryWindow.WindowHandle:height = 18
      no-error.

  end.

  when {&K_QUERY_SIZE_MODE_SMALL} then
  do:

    if bttQueryWindow.WindowMode = {&K_QUERY_WINDOW_MODE_QUERY} then
      hSplitter1:row = dSplitterMinRow no-error.

    assign
      bttQueryWindow.WindowHandle:width  = 150
      bttQueryWindow.WindowHandle:height = hSplitter1:row + hSplitter1:height + 3
      no-error.

  end.

  when {&K_QUERY_SIZE_MODE_MINIMUM} then
  do:

    if bttQueryWindow.WindowMode = {&K_QUERY_WINDOW_MODE_QUERY} then
      hSplitter1:row = dSplitterMinRow no-error.

    assign
      bttQueryWindow.WindowHandle:width  = (if hFieldBrowse:hidden then
                                              50
                                            else
                                              100)
      bttQueryWindow.WindowHandle:height = hSplitter1:row + hSplitter1:height + 3
      no-error.

  end.

  when {&K_QUERY_SIZE_MODE_BIG} then
  do:

    if bttQueryWindow.WindowMode = {&K_QUERY_WINDOW_MODE_QUERY} then
      hSplitter1:row = 7 no-error.

    assign
      bttQueryWindow.WindowHandle:width  = 235
      bttQueryWindow.WindowHandle:height = 32
      no-error.

  end.

  when {&K_RECORD_SIZE_MODE_DEFAULT} then
    assign
      bttQueryWindow.WindowHandle:width  = 80
      bttQueryWindow.WindowHandle:height = 18
      no-error.

  otherwise
    leave.

end case.

run qg_QueryWindowResize(bttQueryWindow.WindowHandle).

end procedure.

PROCEDURE qg_QueryWindowSetVisibleState :
/**
 * Set query window visible state.
 *
 * @param piSourceSeq = QuerySeq of the query window.
 * @param plVisible = Visible state that should be set.
 * @param plChildren = If yes the visible state is set for linked child windows as well.
 */

define input parameter piQuerySeq as integer   no-undo.
define input parameter plVisible  as logical   no-undo.
define input parameter plChildren as logical   no-undo.

define buffer bttQueryWindow  for temp-table ttQueryWindow.
define buffer bttQueryLink    for temp-table ttQueryLink.

find bttQueryWindow
  where bttQueryWindow.QuerySeq = piQuerySeq
  no-error.

if not available bttQueryWindow then
  leave.

bttQueryWindow.WindowHandle:visible = plVisible.

if plChildren then
do:

  for each bttQueryLink
    where bttQueryLink.SourceSeq = piQuerySeq,
  first bttQueryWindow
    where bttQueryWindow.QuerySeq = bttQueryLink.TargetSeq
    on error undo, throw:

    run qg_QueryWindowSetVisibleState(bttQueryWindow.QuerySeq, plVisible, yes).

  end.

end.

end procedure.

PROCEDURE qg_QueryWindowSetWindowMode :
define input parameter phWindow         as handle    no-undo.
define input parameter piWindowMode     as integer   no-undo.
define input parameter pcQueryText      as character no-undo.
define input parameter plFocusQueryText as logical   no-undo.

define variable i                       as integer   no-undo.

define variable hBuffer                 as handle    no-undo extent.
define variable rCurrentRecord          as rowid     no-undo extent.
define variable cDatabaseName           as character no-undo.
define variable cTableName              as character no-undo.

define variable cWindowTitle            as character no-undo.
define variable cIconFilename           as character no-undo.
define variable cSmallIconFilename      as character no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

bttQueryWindow.WindowMode = piWindowMode.

validate bttQueryWindow.

if    valid-handle(bttQueryWindow.QueryHandle)
  and bttQueryWindow.QueryHandle:num-buffers > 0 then
do:

  assign
    extent(hBuffer)        = bttQueryWindow.QueryHandle:num-buffers
    extent(rCurrentRecord) = bttQueryWindow.QueryHandle:num-buffers
      .

  do i = 1 to bttQueryWindow.QueryHandle:num-buffers:

    assign
      hBuffer[i]        = bttQueryWindow.QueryHandle:get-buffer-handle(i)
      rCurrentRecord[i] = hBuffer[i]:rowid
      .

  end.

  assign
    cDatabaseName = qg_cDatabaseNameForTableOrBuffer( hBuffer[1] )
    cTableName    = hBuffer[1]:table
    .

end.

case piWindowMode:

  when {&K_QUERY_WINDOW_MODE_QUERY} then
  do:

    assign
      cIconFilename      = (if gcIconDir > '':U then
                              substitute('&1/32/table_go.ico':U,
                                         gcIconDir)
                            else
                              search('adeicon/startdbs.ico':U))
      cSmallIconFilename = (if gcIconDir > '':U then
                              substitute('&1/16/table_go.ico':U,
                                         gcIconDir)
                            else
                              '':U)
      .

    if not valid-handle(bttQueryWindow.QueryFrameHandle) then
    do:

      run qg_QueryWindowCreateQueryFrame(bttQueryWindow.WindowHandle).

      run qg_QueryWindowQuerySetQueryText(bttQueryWindow.WindowHandle,
                                          (if pcQueryText > '':U then
                                             pcQueryText
                                           else
                                             bttQueryWindow.QueryText),
                                          plFocusQueryText).

      run qg_QueryWindowRefreshBrowseColumns(bttQueryWindow.WindowHandle).

      run qg_QueryWindowQueryOpenFieldQuery(bttQueryWindow.WindowHandle).

    end.

    bttQueryWindow.WindowHandle:menu-bar = bttQueryWindow.QueryMenuHandle.

    if valid-handle(bttQueryWindow.RecordFrameHandle) then
      bttQueryWindow.RecordFrameHandle:visible = no.

    bttQueryWindow.QueryFrameHandle:visible = yes.

    run qg_QueryWindowQueryUpdateTitle(bttQueryWindow.WindowHandle).

    // Only reposition browse if necessary.
    RepositionBrowse:
    do i = 1 to bttQueryWindow.QueryHandle:num-buffers:

      if    i > extent(rCurrentRecord)
         or bttQueryWindow.QueryHandle:get-buffer-handle(i):rowid <> rCurrentRecord[i] then
      do:

        bttQueryWindow.QueryHandle:reposition-to-rowid(rCurrentRecord) no-error.
        leave RepositionBrowse.

      end.

    end.

    if plFocusQueryText then
      apply 'entry':U to bttQueryWindow.QueryTextEditorHandle.

    else
      apply 'entry':U to bttQueryWindow.QueryBrowseHandle.

  end.

  when {&K_QUERY_WINDOW_MODE_RECORD} then
  do:

    assign
      cIconFilename      = (if gcIconDir > '':U then
                              substitute('&1/32/table_analysis.ico':U,
                                         gcIconDir)
                            else
                              search('adeicon/dict%.ico':U))
      cSmallIconFilename = (if gcIconDir > '':U then
                              substitute('&1/16/table_analysis.ico':U,
                                         gcIconDir)
                            else
                              '':U)
      .

    if not valid-handle(bttQueryWindow.RecordFrameHandle) then
    do:

      run qg_QueryWindowCreateRecordFrame(bttQueryWindow.WindowHandle).

      run qg_QueryWindowRecordOpenQuery(bttQueryWindow.WindowHandle).

    end.

    bttQueryWindow.WindowHandle:menu-bar = bttQueryWindow.RecordMenuHandle.

    if valid-handle(bttQueryWindow.QueryFrameHandle) then
      bttQueryWindow.QueryFrameHandle:visible = no.

    bttQueryWindow.RecordFrameHandle:visible = yes.

    run qg_QueryWindowRecordRefresh(bttQueryWindow.WindowHandle).

  end.

end case.

run qg_QueryWindowUpdateRawValuesMode( bttQueryWindow.WindowHandle ).

if cIconFilename > '':U then
  bttQueryWindow.WindowHandle:load-icon(cIconFilename).

if cSmallIconFilename > '':U then
  bttQueryWindow.WindowHandle:load-small-icon(cSmallIconFilename) no-error.

run qg_QueryWindowResize(bttQueryWindow.WindowHandle).

end procedure.

PROCEDURE qg_QueryWindowSetWindowState :
/**
 * Set query window state.
 *
 * @param piSourceSeq = QuerySeq of the query window.
 * @param piWindowState = Window state that should be set.
 * @param plChildren = If yes the window state is set for linked child windows as well.
 */

define input parameter piQuerySeq    as integer   no-undo.
define input parameter piWindowState as integer   no-undo.
define input parameter plChildren    as logical   no-undo.

define buffer bttQueryWindow  for temp-table ttQueryWindow.
define buffer bttQueryLink    for temp-table ttQueryLink.

find bttQueryWindow
  where bttQueryWindow.QuerySeq = piQuerySeq
  no-error.

if not available bttQueryWindow then
  leave.

bttQueryWindow.WindowHandle:window-state = piWindowState.

if plChildren then
do:

  for each bttQueryLink
    where bttQueryLink.SourceSeq = piQuerySeq,
  first bttQueryWindow
    where bttQueryWindow.QuerySeq = bttQueryLink.TargetSeq
    on error undo, throw:

    run qg_QueryWindowSetWindowState(bttQueryWindow.QuerySeq,
                                     piWindowState,
                                     yes).

  end.

end.

end procedure.

PROCEDURE qg_QueryWindowShowAll :
/**
 * Show all query records (remove where clause).
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow    as handle    no-undo.

define variable i          as integer   no-undo.
define variable hBuffer    as handle    no-undo.
define variable cQueryText as character no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if   bttQueryWindow.ObjSourceQuerySeq       > 0
  or not valid-handle(bttQueryWindow.QueryHandle)
  or bttQueryWindow.QueryHandle:num-buffers = 0 then
  leave.

do i = 1 to bttQueryWindow.QueryHandle:num-buffers:

  assign
    hBuffer = bttQueryWindow.QueryHandle:get-buffer-handle(1)
    cQueryText = (if i = 1 then
                    substitute('for each &1':U, hBuffer:name)
                  else
                    substitute(',~nfirst &1':U, hBuffer:name))
    .

end.

bttQueryWindow.QueryTextEditorHandle:screen-value = cQueryText.

run qg_QueryWindowExecute(bttQueryWindow.WindowHandle, ?, yes).

end procedure.

PROCEDURE qg_QueryWindowShowChildWindows :
/**
 * Show all query windows that are linked to this query window.
 *
 * @param piSourceSeq = QuerySeq of the query window.
 */

define input parameter piSourceSeq as integer   no-undo.

define buffer bttQueryWindow  for temp-table ttQueryWindow.
define buffer bttQueryLink    for temp-table ttQueryLink.

for each bttQueryLink
  where bttQueryLink.SourceSeq = piSourceSeq,
first bttQueryWindow
  where bttQueryWindow.QuerySeq = bttQueryLink.TargetSeq
  on error undo, throw:

  run qg_QueryWindowShowChildWindows(bttQueryWindow.QuerySeq).

  run qg_ActivateWindow(bttQueryWindow.WindowHandle, ?).

end.

end procedure.

PROCEDURE qg_QueryWindowShowIndex :
/**
 * Creates a dummy query for the given index and executes it.
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow       as handle    no-undo.

define variable hBuffer       as handle    no-undo.
define variable cDatabaseName as character no-undo.
define variable cIndexName    as character no-undo.
define variable lOk           as logical   no-undo.
define variable cQueryText    as character no-undo.

define buffer bttIndex       for temp-table ttIndex.
define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if    bttQueryWindow.ObjSourceQuerySeq        > 0
   or not valid-handle(bttQueryWindow.QueryHandle)
   or bttQueryWindow.QueryHandle:num-buffers <> 1 then
  leave.

assign
  hBuffer       = bttQueryWindow.QueryHandle:get-buffer-handle(1)
  cDatabaseName = qg_cDatabaseNameForTableOrBuffer( hBuffer )
  .

run qg_SelectIndex(cDatabaseName,
                   hBuffer:table,
                   input-output cIndexName,
                         output lOk,
                   bttQueryWindow.WindowHandle).

if lOk then
do:

  find bttIndex
    where bttIndex.DatabaseName = cDatabaseName
      and bttIndex.TableName    = hBuffer:table
      and bttIndex.IndexName    = cIndexName
    no-error.

  if available bttIndex then
  do:

    assign
      cQueryText = substitute( 'for each &1':U,
                               bttIndex.TableName )
      cQueryText = substitute( '&1~n&2~n':U,
                               cQueryText,
                               qg_cCreateWhereClause( /* pcDatabaseName   */ bttIndex.DatabaseName,
                                                      /* pcTableNames     */ bttIndex.TableName,
                                                      /* pcBufferNames    */ bttIndex.TableName,
                                                      /* pcFieldList      */ bttIndex.IndexFieldList,
                                                      /* pcFieldLabelList */ ?,
                                                      /* plStartWithWhere */ yes,
                                                      /* piValueMode      */ {&K_VALUE_MODE_DEFAULT_VALUE},
                                                      /* pcValueList      */ ?,
                                                      /* piAccessMode     */ {&K_ACCESS_MODE_PHYSICAL},
                                                      /* plAddTags        */ no,
                                                      /* piIndentBlanks   */ 2 ) )
      .

    run qg_QueryWindowQuerySetQueryText(bttQueryWindow.WindowHandle,
                                        cQueryText,
                                        yes).

    run qg_QueryWindowExecute(bttQueryWindow.WindowHandle, ?, no).

    apply 'entry':U to bttQueryWindow.QueryTextEditorHandle.

  end.

end.

end procedure.

PROCEDURE qg_QueryWindowShowIndexInformation :
/**
 * Creates a dummy query for the given index and executes it.
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow       as handle    no-undo.

define variable i              as integer   no-undo.
define variable j              as integer   no-undo.
define variable hQuery         as handle    no-undo.
define variable hBuffer        as handle    no-undo.

define variable cDatabaseName  as character no-undo.
define variable cIndexInfo     as character no-undo.
define variable cIndexName     as character no-undo.
define variable cIndexInfoText as character no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.
define buffer bttIndex       for temp-table ttIndex.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

hQuery = bttQueryWindow.QueryHandle.

if not valid-handle(hQuery) then
  leave.

do i = 1 to hQuery:num-buffers:

  assign
    hBuffer       = hQuery:get-buffer-handle(i)
    cDatabaseName = qg_cDatabaseNameForTableOrBuffer( hBuffer )
    cIndexInfo    = hQuery:index-information(i)
    .

  cIndexInfoText = substitute('&1~n~n&2 &3':U,
                              cIndexInfoText,
                              gcBulletChar2,
                              hBuffer:name).

  do j = 1 to num-entries(cIndexInfo):

    cIndexName = entry(j, cIndexInfo).

    if cIndexName = 'WHOLE-INDEX':U then
      cIndexInfoText = substitute('&1   !!! &2 !!!':U,
                                  cIndexInfoText,
                                  cIndexName).

    else
    do:

      find bttIndex
        where bttIndex.DatabaseName = cDatabaseName
          and bttIndex.TableName    = hBuffer:table
          and bttIndex.IndexName = cIndexName
        no-error.

      if available bttIndex then
        cIndexInfoText = substitute('&1~n&2&3 Index &4: &5':U,
                                    cIndexInfoText,
                                    gcLineUpAndRight,
                                    gcBulletChar1,
                                    bttIndex.IndexName,
                                    bttIndex.IndexFields).

      else
        cIndexInfoText = substitute('&1~n    -> Index &2':U,
                                    cIndexInfoText,
                                    bttIndex.IndexName).

    end.

  end.

end.

message
  trim(cIndexInfoText, '~n':U) skip
  view-as alert-box
  information
  buttons ok
  in window bttQueryWindow.WindowHandle.

end procedure.

PROCEDURE qg_QueryWindowShowQueryText :
/**
 * Show actual query text with resolved external tokens.
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.

define variable cQueryText as character no-undo
  view-as editor
  no-word-wrap
  scrollbar-horizontal
  scrollbar-vertical
  size 146 by 14.5
  font 0.

define button btnClose
  label 'Close':T
  size 20 by 1.14
  auto-end-key.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if not valid-handle(bttQueryWindow.QueryHandle) then
  leave.

define frame fQueryText
  cQueryText at row 1.5 col 3 no-labels
  btnClose at row 16.5 col 66
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 151 by 18.44
    title gcTitlePrefix + 'Query text of query browse':T
    default-button btnClose
    cancel-button btnClose.

on window-close of frame fQueryText
  apply 'end-error' to self.

assign
  cQueryText                               = bttQueryWindow.QueryHandle:prepare-string
  cQueryText:read-only in frame fQueryText = yes
  .

update unless-hidden
  cQueryText
  btnClose
  with frame fQueryText
    in window bttQueryWindow.WindowHandle.

end procedure.

PROCEDURE qg_QueryWindowSortByIndex :
/**
 * Add Sort options for a given index.
 *
 * @param phWindow = Handle of the Query window.
 * @param pcDatabaseName = Database name.
 * @param pcTableName = Table name.
 * @param pcIndexName = Index name.
 */

define input parameter phWindow as handle    no-undo.

define variable hBuffer        as handle    no-undo.
define variable cDatabaseName  as character no-undo.
define variable cIndexName     as character no-undo.
define variable lOk            as logical   no-undo.
define variable cSortFieldList as character no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

define buffer bttIndexField  for temp-table ttIndexField.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

if    bttQueryWindow.ObjSourceQuerySeq        > 0
   or not valid-handle(bttQueryWindow.QueryHandle)
   or bttQueryWindow.QueryHandle:num-buffers <> 1 then
  leave.

assign
  hBuffer       = bttQueryWindow.QueryHandle:get-buffer-handle(1)
  cDatabaseName = qg_cDatabaseNameForTableOrBuffer( hBuffer )
  .

run qg_SelectIndex(cDatabaseName,
                   hBuffer:table,
                   input-output cIndexName,
                         output lOk,
                   phWindow).

if lOk then
do:

  for each bttIndexField
    where bttIndexField.DatabaseName = cDatabasename
      and bttIndexField.TableName    = hBuffer:table 
      and bttIndexField.IndexName    = cIndexName
    by DatabaseName by TableName by IndexName by IndexSequence
    on error undo, throw:

    cSortFieldList = substitute('&1,&2.&3&4':U,
                                cSortFieldList,
                                bttIndexField.TableName,
                                bttIndexField.FieldName,
                                (if bttIndexField.SortAscending then
                                   '':U
                                 else
                                   ' descending':U)).

  end.

  cSortFieldList = trim(cSortFieldList, ',':U).

  if num-entries(cSortFieldList) > 0 then
    run qg_QueryWindowAddSortFields(phWindow,
                                    cSortFieldList).

end.

end procedure.

PROCEDURE qg_QueryWindowToggleDeepResolve :
/**
 *
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow   as handle    no-undo.

define variable hFrame                     as handle    no-undo.
define variable hToggleDeepResolveMenuItem as handle    no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

assign
  hToggleDeepResolveMenuItem          = qg_hGetWidgetByName(phWindow:menu-bar,
                                                            'mi_DeepResolveObjectIds':U)
  bttQueryWindow.DeepResolveObjectIds = hToggleDeepResolveMenuItem:checked
  .

if    valid-handle(bttQueryWindow.QueryHandle)
  and bttQueryWindow.QueryHandle:num-results > 0
  and valid-handle(bttQueryWindow.QueryBrowseHandle) then
  bttQueryWindow.QueryBrowseHandle:refresh().

end procedure.

PROCEDURE qg_QueryWindowToggleRawValues :
/**
 *
 *
 * @param phWindow = Handle of the record window.
 */

define input parameter phWindow         as handle    no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

bttQueryWindow.DisplayRawValues = not bttQueryWindow.DisplayRawValues.

if bttQueryWindow.DisplayRawValues then

  // This flag will be set the first time "raw values" is set to true. Once
  // we have been applying formats to columns we have to keep doing it,
  // otherwise the display will not be correct.

  bttQueryWindow.ApplyColumnFormats = yes.

run qg_QueryWindowUpdateRawValuesMode( bttQueryWindow.WindowHandle ).

end procedure.

PROCEDURE qg_QueryWindowToggleFieldList :
/**
 * Toggle field list visibility.
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow   as handle    no-undo.

define variable hFrame                   as handle    no-undo.
define variable hToggleFieldBrowseButton as handle    no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

// If the field selection browse should be displayed we first have to make
// sure that it will fit into the frame to avoid errors.

if bttQueryWindow.QueryFieldBrowseHandle:hidden then
  assign
    hFrame                            = qg_hGetWidgetByName(phWindow, 'fQuery':U)
    bttQueryWindow.WindowHandle:width = max(100, bttQueryWindow.WindowHandle:width)
    hFrame:width                      = bttQueryWindow.WindowHandle:width
    bttQueryWindow.QueryFieldBrowseHandle:height = 3
    bttQueryWindow.QueryFieldBrowseHandle:col    = max(1, bttQueryWindow.WindowHandle:width - 72)
    no-error.

// Now we can toggle the hidden state.
assign
  bttQueryWindow.QueryFieldBrowseHandle:hidden = not bttQueryWindow.QueryFieldBrowseHandle:hidden
  hToggleFieldBrowseButton         = qg_hGetWidgetByName(phWindow, 'btnToggleFieldBrowse':U)
  hToggleFieldBrowseButton:label   = (if bttQueryWindow.QueryFieldBrowseHandle:hidden then
                                        '<':T
                                      else
                                        '>':T)
  hToggleFieldBrowseButton:tooltip                 = (if bttQueryWindow.QueryFieldBrowseHandle:hidden then
                                        'Show field list':T
                                      else
                                        'Hide field List':T)
  .

run qg_QueryWindowResize(bttQueryWindow.WindowHandle).

end procedure.

PROCEDURE qg_QueryWindowUpdate :
/**
 * Execute current query text of given query window.
 *
 * @param phWindow = Window handle of the query window that should be updated.
 * @param pcForceUpdateWindowList = List of window handles that should be up- dated even if the query text is un- changed.
 */

define input parameter phWindow                as handle    no-undo.
define input parameter pcForceUpdateWindowList as character no-undo.

define variable cQueryText as character no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

// Additional do block to ensure that bttQueryWindow will be available in
// finally block.

do on error undo, throw:

  phWindow:title = substitute('&1 (updating ...)':U, bttQueryWindow.WindowTitle).

  if bttQueryWindow.ObjSourceQuerySeq > 0 then
    run qg_QueryWindowObjUpdateQuery(bttQueryWindow.WindowHandle).

  if not valid-handle(bttQueryWindow.QueryHandle) then
    leave.

  cQueryText = qg_cSubstituteQueryLinkTokens(bttQueryWindow.WindowHandle).

  if   can-do(pcForceUpdateWindowList, string(bttQueryWindow.WindowHandle))
    or cQueryText <> bttQueryWindow.QueryHandle:prepare-string
    or not bttQueryWindow.QueryHandle:is-open then
  do:

    if    cQueryText > '':U
      and bttQueryWindow.QueryHandle:num-buffers > 0 then
    do:

      qg_lQueryOpen(bttQueryWindow.QueryHandle,
                    cQueryText,
                    bttQueryWindow.WindowHandle).

      run qg_AddRecentQuery(bttQueryWindow.WindowHandle).

    end.

    if bttQueryWindow.WindowMode = {&K_QUERY_WINDOW_MODE_RECORD} then
    do:

      if    bttQueryWindow.QueryHandle:is-open
        and bttQueryWindow.QueryHandle:num-results = 0 then
        bttQueryWindow.QueryHandle:get-first().

      run qg_QueryWindowRecordRefresh(bttQueryWindow.WindowHandle).

    end.

  end.

  finally:

    if    valid-handle(phWindow)
      and bttQueryWindow.WindowTitle > '':U then
      phWindow:title = bttQueryWindow.WindowTitle.

  end finally.

end.

end procedure.

PROCEDURE qg_QueryWindowUpdateAll :
/**
 * Refresh all Query windows.
 */

define input parameter pcForceUpdateWindowList as character no-undo.

define buffer bttQueryWindow            for temp-table ttQueryWindow.

// Check for circular references and reset update flags.

for each bttQueryWindow
  on error undo, throw:

  if not qg_lCheckLinkReference(bttQueryWindow.QuerySeq, '':U) then
  do:

    message /* code checked by mth */
      substitute('Circular reference detected in Query window &1':T,
                 string(bttQueryWindow.QuerySeq)) skip
      view-as alert-box
      error
      buttons ok
      in window bttQueryWindow.WindowHandle.

    return error.

  end.

  bttQueryWindow.Updated = no.

end.

// Refresh query windows.
for each bttQueryWindow
  where not can-find(first ttQueryLink
                       where ttQueryLink.SourceSeq = bttQueryWindow.QuerySeq)
  on error undo, throw:

  if valid-handle(bttQueryWindow.WindowHandle) then
    run qg_QueryWindowUpdateRecursive(bttQueryWindow.WindowHandle,
                                      pcForceUpdateWindowList).

end.

end procedure.

PROCEDURE qg_QueryWindowUpdateRawValuesMode :
/**
 * Update all query windows that are linked to given query window.
 *
 * @param phWindow = Handle of the Query window.
 * @param pcForceUpdateWindowList = List of window handles that should be up- dated even if the query text is un- changed.
 */

define input parameter phWindow as handle    no-undo.

define variable hRawValues as handle    no-undo.

define buffer bttQueryWindow  for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave. 

validate bttQueryWindow.

case bttQueryWindow.WindowMode:

  when {&K_QUERY_WINDOW_MODE_QUERY} then
  do:

    hRawValues = qg_hGetWidgetByName( phWindow:menu-bar,
                                      'mi_RawValues':U ).

    if valid-handle( hRawValues ) then

      hRawValues:checked = bttQueryWindow.DisplayRawValues.

    if bttQueryWindow.QueryHandle:num-results > 0 then

      bttQueryWindow.QueryBrowseHandle:refresh().

  end.

  when {&K_QUERY_WINDOW_MODE_RECORD} then
  do:

    hRawValues = qg_hGetWidgetByName( bttQueryWindow.RecordFrameHandle,
                                      'lRawValues':U ).

    if valid-handle(hRawValues) then

      hRawValues:screen-value = string(bttQueryWindow.DisplayRawValues).

    run qg_QueryWindowRecordUpdateValues( bttQueryWindow.WindowHandle ).

  end.

end case.

end procedure.

PROCEDURE qg_QueryWindowUpdateRecursive :
/**
 * Update all query windows that are linked to given query window.
 *
 * @param phWindow = Handle of the Query window.
 * @param pcForceUpdateWindowList = List of window handles that should be up- dated even if the query text is un- changed.
 */

define input parameter phWindow                as handle    no-undo.
define input parameter pcForceUpdateWindowList as character no-undo.

define buffer bttQueryWindow  for temp-table ttQueryWindow.
define buffer b2ttQueryWindow for temp-table ttQueryWindow.
define buffer bttQueryLink    for temp-table ttQueryLink.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave. 

if bttQueryWindow.Updated then
  leave.

for each bttQueryLink
  where bttQueryLink.TargetSeq = bttQueryWindow.QuerySeq,
first b2ttQueryWindow
  where b2ttQueryWindow.QuerySeq = bttQueryLink.SourceSeq
  break by bttQueryLink.SourceSeq
  on error undo, throw:

  if first-of(bttQueryLink.SourceSeq) then
    run qg_QueryWindowUpdateRecursive(b2ttQueryWindow.WindowHandle,
                                      pcForceUpdateWindowList).

end.

run qg_QueryWindowUpdate(bttQueryWindow.WindowHandle,
                         pcForceUpdateWindowList).

bttQueryWindow.Updated = yes.

end procedure.

PROCEDURE qg_QueryWindowViewMenuDrop :
/**
 *
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow                as handle    no-undo.

define variable hFieldSelectionBrowse as handle    no-undo.

define variable hMenu                 as handle    no-undo.
define variable hFieldListMenuItem    as handle    no-undo.

define buffer bttQueryWindow  for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave. 

assign
  hMenu = bttQueryWindow.WindowHandle:menu-bar
  hFieldSelectionBrowse
      = qg_hGetWidgetByName(bttQueryWindow.WindowHandle,
                          'brFieldSelection':U)
  hFieldListMenuItem
      = qg_hGetWidgetByName(hMenu, 'mi_FieldList':U)
  hFieldListMenuItem:checked
      = hFieldSelectionBrowse:visible
  .

end procedure.

PROCEDURE qg_QueryWindowWindowMenuDrop :
/**
 *
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow                as handle    no-undo.

define buffer bttQueryWindow  for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave. 

// Nothing to do here right now. Maybe this can be deleted.
end procedure.

procedure qg_RemoveInvalidOverlayColumns :
define parameter buffer pbttQueryWindow for temp-table ttQueryWindow.

define variable hBuffer as handle    no-undo.

define buffer bttFieldOverlay for temp-table ttFieldOverlay.

for each bttFieldOverlay
  where bttFieldOverlay.OwnerHandle = pbttQueryWindow.QueryHandle
  break by bttFieldOverlay.BufferName
  on error undo, throw:

  if first-of( bttFieldOverlay.BufferName ) then

    hBuffer = pbttQueryWindow.QueryHandle:get-buffer-handle( bttFieldOverlay.BufferName ) no-error.

  if    not valid-handle( hBuffer )
     or not can-find( first ttQueryWindowField
                        where ttQueryWindowField.WindowHandle = pbttQueryWindow.WindowHandle
                          and ttQueryWindowField.BufferName   = bttFieldOverlay.BufferName
                          and ttQueryWindowField.FieldName    = bttFieldOverlay.FieldName
                          and ttQueryWindowField.FieldIndex   = bttFieldOverlay.FieldIndex
                          and ttQueryWindowField.IsOverlay    = no ) then

    run qg_DeleteFieldOverlay( bttFieldOverlay.OwnerHandle,
                               bttFieldOverlay.BufferName,
                               bttFieldOverlay.FieldName,
                               bttFieldOverlay.FieldIndex ).

  if last-of( bttFieldOverlay.BufferName ) then

    hBuffer = ?.

end.

end procedure.



/* <<< Include: incl/query_window.i <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/* >>> Include: incl/virtual_fields.i >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> */
/**
 * @COPYRIGHT@
 * Project Proalpha
 * Name    virtual_fields.i
 * Created <version> as of 04.05.2022/Thiemann_M
 * Current @PAVERSION@ as of @PADATE@/@PALASTAUTHOR@
 *
 *
 * ## HISTORY
 * @FILEHISTORY@
 */

procedure qg_AddTableVirtualDBFields :
/**
 *
 */

define parameter buffer pbttDatabase for temp-table ttDatabase.
define parameter buffer pbttTable    for temp-table ttTable. 

define variable hRepVirtualFieldBuffer as handle    no-undo.
define variable hRepDomainBuffer       as handle    no-undo.
define variable hRepVirtualFieldQuery  as handle    no-undo.

define variable cQueryText             as character no-undo.

define variable cDataType              as character no-undo.

define buffer bttField for temp-table ttField.

create buffer hRepVirtualFieldBuffer for table substitute( '&1.DRC_VirtualField':U, pbttDatabase.BasisDBName ).
create buffer hRepDomainBuffer for table substitute( '&1.DRC_Domain':U, pbttDatabase.BasisDBName ).

create query hRepVirtualFieldQuery.

hRepVirtualFieldQuery:set-buffers( hRepVirtualFieldBuffer, hRepDomainBuffer ).

cQueryText =            'for each DRC_VirtualField':U
             + '~n':U + '  where DRC_VirtualField.DRC_Table_Obj = &1':U
             + '~n':U + '    and DRC_VirtualField.&2            = yes':U
             + '~n':U + '  no-lock,':U
             + '~n':U + 'first DRC_Domain left outer-join':U
             + '~n':U + '  where DRC_Domain.DRC_Domain_Obj = DRC_VirtualField.DRC_Domain_Obj':U
             + '~n':U + '  no-lock':U.
             .

hRepVirtualFieldQuery:query-prepare( substitute( cQueryText,
                                                 quoter( pbttTable.RepObjectId ),
                                                 gcVirtualDBFieldReposFlagFieldName ) ).

hRepVirtualFieldQuery:query-open().

hRepVirtualFieldQuery:get-first().

do while not hRepVirtualFieldQuery:query-off-end:

  create bttField.

  assign
    bttField.DatabaseName      = pbttDatabase.DatabaseName
    bttField.TableName         = pbttTable.TableName
    bttField.FieldName         = hRepVirtualFieldBuffer::DRC_VirtualField_ID
    bttField.RepObjectId       = hRepVirtualFieldBuffer::DRC_VirtualField_Obj
    cDataType                  = dynamic-function( 'pa_cReposDomainInformationByObj':U,
                                                   hRepDomainBuffer::DRC_Domain_Obj,
                                                   'DATA-TYPE':U )
    bttField.DataType          = substitute( '&1&2':U,
                                             caps( substring( cDataType, 1, 1 ) ),
                                             lc( substring( cDataType, 2 ) ) )
    bttField.FieldExtent       = dynamic-function( 'pa_cReposDomainInformationByObj':U,
                                                   hRepDomainBuffer::DRC_Domain_Obj,
                                                   'EXTENT':U )
    bttField.FieldInitialValue = dynamic-function( 'pa_cReposDomainInformationByObj':U,
                                                   hRepDomainBuffer::DRC_Domain_Obj,
                                                   'INITIAL':U )
    bttField.FieldLabel        = dynamic-function( 'pa_cReposDomainInformationByObj':U,
                                                   hRepDomainBuffer::DRC_Domain_Obj,
                                                   'LABEL':U )
    bttField.FieldColumnLabel  = dynamic-function( 'pa_cReposDomainInformationByObj':U,
                                                   hRepDomainBuffer::DRC_Domain_Obj,
                                                   'COLUMN-LABEL':U )
    bttField.FieldDecimals     = dynamic-function( 'pa_cReposDomainInformationByObj':U,
                                                   hRepDomainBuffer::DRC_Domain_Obj,
                                                   'DECIMALS':U )
    bttField.FieldFormat       = dynamic-function( 'pa_cReposDomainInformationByObj':U,
                                                   hRepDomainBuffer::DRC_Domain_Obj,
                                                   'FORMAT':U )
    bttField.IsMandatory       = dynamic-function( 'pa_cReposDomainInformationByObj':U,
                                                   hRepDomainBuffer::DRC_Domain_Obj,
                                                   'MANDATORY':U )
    bttField.Domain            = (if hRepDomainBuffer:available then
                                    hRepDomainBuffer::DRC_Domain_ID
                                  else
                                    '':U)
    bttField.IsObjectId        = (     bttField.FieldName matches '*_Obj':U
                                    or lookup(bttField.Domain, {&K_OBJECT_ID_DOMAIN}) > 0 )
    bttField.FieldType         = {&K_FIELD_TYPE_VIRTUAL_DB_FIELD}
    bttField.IsVirtual         = yes
    .

  // Attribute "VIEW-AS" is only available in development mode. To avoid
  // errors when running in production mode we use "no-error" to assign this
  // specific attribute.

  bttField.FieldViewAs = dynamic-function( 'pa_cReposDomainInformationByObj':U,
                                           hRepDomainBuffer::DRC_Domain_Obj,
                                           'VIEW-AS':U ) no-error.

  // An empty initial value for logical fields is interpreted as "no"
  // by the database. Therefore we simulate this behaviour for virtual
  // fields.

  if    bttField.DataType          = 'logical':U
    and bttField.FieldInitialValue = '':U then

    bttField.FieldInitialValue = 'no':U.

  // The "initial" attribute for date fields allways has to have the US
  // format "mm/dd/yyyy" (or "today/now" or ?)

  else if    cDataType                  begins  'date':U
         and bttField.FieldInitialValue matches '*/*/*':U then

    bttField.FieldInitialValue = qg_cDateStringFormUSFormat( bttField.FieldInitialValue ).

  if    bttField.FieldLabel = ?
     or bttField.FieldLabel = '':U then

    bttField.FieldLabel = bttField.FieldName.

  if    bttField.FieldColumnLabel = ?
     or bttField.FieldColumnLabel = '':U then

    bttField.FieldColumnLabel = bttField.FieldLabel.

  hRepVirtualFieldQuery:get-next().

end.

catch oError as Progress.Lang.Error:
  return.
end catch.

finally:

  if valid-handle( hRepVirtualFieldQuery ) then

    delete object hRepVirtualFieldQuery no-error.

  if valid-handle( hRepDomainBuffer ) then

    delete object hRepDomainBuffer no-error.

  if valid-handle( hRepVirtualFieldBuffer ) then

    delete object hRepVirtualFieldBuffer no-error.

end finally.

end procedure.


procedure qg_AddVirtualFieldsToBufferComparisonBuffer :
/**
 *
 */

define input parameter pcDatabaseName as character no-undo.
define input parameter phBuffer       as handle    no-undo.
define input parameter piBufferNo     as integer   no-undo.

define variable cObjectIdValue     as character no-undo.

define buffer bttField                 for temp-table ttField.

define buffer bttBufferComparisonField for temp-table ttBufferComparisonField.

if not phBuffer:available then

  return.

if not qg_lIsPhysicalDatabase( phBuffer:dbname ) then

  return.

cObjectIdValue = qg_cObjectIdForBuffer( phBuffer ).

for each bttField
  where bttField.DatabaseName = pcDatabaseName
    and bttField.TableName    = phBuffer:table
    and bttField.IsVirtual    = yes
  on error undo, throw:

  find bttBufferComparisonField
    where bttBufferComparisonField.BufferNo   = piBufferNo
      and bttBufferComparisonField.FieldName  = bttField.FieldName
      and bttBufferComparisonField.FieldIndex = 0
    no-error.

  if not available bttBufferComparisonField then
  do:

    create bttBufferComparisonField.

    assign
      bttBufferComparisonField.BufferNo   = piBufferNo
      bttBufferComparisonField.FieldName  = bttField.FieldName
      bttBufferComparisonField.FieldIndex = 0
      .

  end.

  assign
    bttBufferComparisonField.DatabaseName = pcDatabaseName
    bttBufferComparisonField.TableName    = phBuffer:table
    bttBufferComparisonField.BufferName   = phBuffer:name
    bttBufferComparisonField.DataType     = bttField.DataType
    bttBufferComparisonField.FieldFormat  = bttField.FieldFormat
    bttBufferComparisonField.IsVirtual    = bttField.IsVirtual
    bttBufferComparisonField.FieldType    = bttField.FieldType
    bttBufferComparisonField.FieldValue   = qg_clVirtualFieldValueAsLongchar( bttField.FieldType,
                                                                              bttField.DataType,
                                                                              bttField.FieldName,
                                                                              cObjectIdValue,
                                                                              ? ).
    .


  validate bttBufferComparisonField.

end.

end procedure.



procedure qg_AddVirtualFieldsToTempTable :
/**
 *
 */

define input parameter pcDatabaseName as character no-undo.
define input parameter pcTableName    as character no-undo.
define input parameter phTempTable    as handle    no-undo.

define buffer bttField for temp-table ttField.

for each bttField
  where bttField.DatabaseName = pcDatabaseName
    and bttField.TableName    = pcTableName
    and bttField.IsVirtual    = yes
  on error undo, throw:

  case bttField.FieldType:

    when {&K_FIELD_TYPE_VIRTUAL_DB_FIELD} then

      phTempTable:add-new-field( bttField.FieldName,
                                 bttField.DataType,
                                 bttField.FieldExtent,
                                 bttField.FieldFormat,
                                 bttField.FieldInitialValue,
                                 bttField.FieldLabel,
                                 bttField.FieldColumnLabel ).

  end case.

end.

end procedure.


procedure qg_BufferCopyVirtualFieldsFromPhysicalBufferToTempTableBuffer :
/**
 *
 */

define input parameter pcDatabaseName    as character no-undo.
define input parameter phPhysicalBuffer  as handle    no-undo.
define input parameter phTempTableBuffer as handle    no-undo.

define variable cObjectIdValue  as character no-undo.
define variable cMethodName     as character no-undo.
define variable hTempTableField as handle    no-undo.

define variable clFieldValue as longchar  no-undo.

define buffer bttField for temp-table ttField.

cObjectIdValue = qg_cObjectIdForBuffer(phPhysicalBuffer).

if error-status:error then

  return.

for each bttField
  where bttField.DatabaseName = pcDatabaseName
    and bttField.TableName    = phPhysicalBuffer:table
    and bttField.IsVirtual    = yes
  on error undo, throw:

  hTempTableField = phTempTableBuffer:buffer-field(bttField.FieldName) no-error.

  if not valid-handle(hTempTableField) then
    next.

  case bttField.FieldType:

    when {&K_FIELD_TYPE_VIRTUAL_DB_FIELD} then
      if glStaticVirtualDBFieldDataApi then
        assign
          cMethodName                  = dynamic-invoke(goVirtualDBFieldDataApiClass:TypeName,
                                                        'cMethodNameByDataType':U,
                                                        bttField.DataType)
          hTempTableField:buffer-value = dynamic-invoke(goVirtualDBFieldDataApiClass:TypeName,
                                                        cMethodName,
                                                        cObjectIdValue,
                                                        bttField.FieldName)
          .
      
      else
        assign
          cMethodName                  = dynamic-invoke(goVirtualDBFieldDataApiInstance,
                                                        'cMethodNameByDataType':U,
                                                        bttField.DataType)
          hTempTableField:buffer-value = dynamic-invoke(goVirtualDBFieldDataApiInstance,
                                                        cMethodName,
                                                        cObjectIdValue,
                                                        bttField.FieldName)
          .
     
  end case.

end.

end procedure.


procedure qg_BufferCopyVirtualFieldsFromTempTableBufferToPhysicalBuffer :
/**
 *
 */

define input parameter pcDatabaseName    as character no-undo.
define input parameter phTempTableBuffer as handle    no-undo.
define input parameter phPhysicalBuffer  as handle    no-undo.
define input parameter plDisabelTriggers as logical   no-undo.

define variable cObjectIdValue           as character no-undo.
define variable hTempTableField          as handle    no-undo.
define variable cVirtualFieldTableName as character no-undo.
define variable hVirtualFieldTableBuffer as handle    no-undo.

define variable clFieldValue             as longchar  no-undo.

define buffer bttField for temp-table ttField.

cObjectIdValue = qg_cObjectIdForBuffer( phPhysicalBuffer ).

if error-status:error then

  return.

for each bttField
  where bttField.DatabaseName = pcDatabaseName
    and bttField.TableName    = phPhysicalBuffer:table
    and bttField.IsVirtual    = yes
    and bttField.FieldType    = {&K_FIELD_TYPE_VIRTUAL_DB_FIELD}
  break by bttField.DataType
  on error undo, throw:

  if    first-of( bttField.DataType )
    and plDisabelTriggers then
  do:

    cVirtualFieldTableName = (if glStaticVirtualDBFieldDataFieldApi then
                                dynamic-invoke(goVirtualDBFieldDataFieldApiClass:TypeName,
                                               'cTableNameByDataType':U,
                                               bttField.DataType)
                              else
                                dynamic-invoke(goVirtualDBFieldDataFieldApiInstance,
                                               'cTableNameByDataType':U,
                                               bttField.DataType)).
                                
    create buffer hVirtualFieldTableBuffer for table cVirtualFieldTableName.

    hVirtualFieldTableBuffer:disable-load-triggers( no ).

  end.

  hTempTableField = phTempTableBuffer:buffer-field( bttField.FieldName ) no-error.

  if not valid-handle( hTempTableField ) then

    next.

  case bttField.DataType:

    when 'clob':U then
    do:

      copy-lob from hTempTableField:buffer-field(bttField.FieldName):buffer-value
        to clFieldValue
        .
      
      if glStaticVirtualDBFieldDataApi then
        dynamic-invoke(goVirtualDBFieldDataApiClass:TypeName,
                       'setValue':U,
                       cObjectIdValue,
                       bttField.FieldName,
                       clFieldValue).
      else
        dynamic-invoke(goVirtualDBFieldDataApiInstance,
                       'setValue':U,
                       cObjectIdValue,
                       bttField.FieldName,
                       clFieldValue).

    end.

    otherwise

      if glStaticVirtualDBFieldDataApi then
        dynamic-invoke(goVirtualDBFieldDataApiClass:TypeName,
                       'setValue':U,
                       cObjectIdValue,
                       bttField.FieldName,
                       hTempTableField:buffer-value).
      else
        dynamic-invoke(goVirtualDBFieldDataApiInstance,
                       'setValue':U,
                       cObjectIdValue,
                       bttField.FieldName,
                       hTempTableField:buffer-value).

  end case.

  if    last-of(bttField.DataType)
    and plDisabelTriggers
    and valid-handle(hVirtualFieldTableBuffer) then

    delete object hVirtualFieldTableBuffer.

end.

end procedure.


procedure qg_CreateVirtualFieldColumn :
/**
 *
 */

define parameter buffer pbttQueryWindow      for temp-table ttQueryWindow.
define parameter buffer pbttQueryWindowField for temp-table ttQueryWindowField.

define variable hVirtualFieldColumn as handle    no-undo.

define buffer bttField              for temp-table ttField.
define buffer bttVirtualFieldColumn for temp-table ttVirtualFieldColumn.

if not valid-handle( pbttQueryWindowField.BufferHandle ) then

  return.

find first bttField
  where bttField.DatabaseName = pbttQueryWindowField.DatabaseName
    and bttField.TableName    = pbttQueryWindowField.BufferHandle:table
    and bttField.FieldName    = pbttQueryWindowField.FieldName
  no-error.

if not available bttField then

  return.

find bttVirtualFieldColumn
  where bttVirtualFieldColumn.OwnerHandle = pbttQueryWindow.QueryHandle
    and bttVirtualFieldColumn.BufferName  = pbttQueryWindowField.BufferName
    and bttVirtualFieldColumn.FieldName   = pbttQueryWindowField.FieldName
    and bttVirtualFieldColumn.FieldIndex  = pbttQueryWindowField.FieldIndex
  no-error.

if not available bttVirtualFieldColumn then
do:

  create bttVirtualFieldColumn.

  assign
    bttVirtualFieldColumn.OwnerHandle  = pbttQueryWindow.QueryHandle
    bttVirtualFieldColumn.BufferName   = pbttQueryWindowField.BufferName
    bttVirtualFieldColumn.FieldName    = pbttQueryWindowField.FieldName
    bttVirtualFieldColumn.FieldIndex   = pbttQueryWindowField.FieldIndex
    bttVirtualFieldColumn.DataType     = pbttQueryWindowField.DataType
    bttVirtualFieldColumn.FieldType    = pbttQueryWindowField.FieldType
    bttVirtualFieldColumn.FieldFormat  = pbttQueryWindowField.FieldFormat
    .

end.

assign
  bttVirtualFieldColumn.BufferHandle = pbttQueryWindowField.BufferHandle
  hVirtualFieldColumn                = pbttQueryWindow.QueryBrowseHandle:add-calc-column
                                         ( bttField.DataType,
                                           bttField.FieldFormat,
                                           bttField.FieldInitialValue,
                                           bttField.FieldColumnLabel )
  hVirtualFieldColumn:name           = qg_cFormattedFieldName( /* pcDatabaseName */ ?,
                                                               /* pcTableName    */ pbttQueryWindowField.BufferName,
                                                               /* pcFieldName    */ pbttQueryWindowField.FieldName,
                                                               /* piIndex        */ pbttQueryWindowField.FieldIndex )
  hVirtualFieldColumn:label-fgcolor  = {&K_VIRTUAL_DB_FIELD_FGCOLOR}
  bttVirtualFieldColumn.ColumnHandle = hVirtualFieldColumn
  .

validate bttVirtualFieldColumn.

end procedure.


procedure qg_CreateVirtualFieldColumnsForBuffer:
/**
 *
 */

define parameter buffer pbttQueryWindow for temp-table ttQueryWindow.

define input parameter piBufferId as integer   no-undo.

define variable hVirtualFieldColumn as handle    no-undo.

define buffer bttQueryWindowField for temp-table ttQueryWindowField.

for each bttQueryWindowField
  where bttQueryWindowField.WindowHandle = pbttQueryWindow.WindowHandle
    and bttQueryWindowField.BufferId     = piBufferId
    and bttQueryWindowField.IsOverlay    = no
    and bttQueryWindowField.IsVirtual    = yes
  on error undo, throw:

  run qg_CreateVirtualFieldColumn( buffer pbttQueryWindow,
                                   buffer bttQueryWindowField ).

end.

end procedure.


procedure qg_DeleteVirtualFieldRecordsForRecord :
/**
 *
 */

define input parameter pcDatabaseName    as character no-undo.
define input parameter phPhysicalBuffer  as handle    no-undo.
define input parameter plDisableTriggers as logical   no-undo.

define variable cVirtualFieldTableName   as character no-undo.
define variable hVirtualFieldTableBuffer as handle    no-undo.

define buffer bttField for temp-table ttField.

if not can-find( first ttField
                   where ttField.DatabaseName = pcDatabaseName
                     and ttField.TableName    = phPhysicalBuffer:table
                     and ttField.IsVirtual    = yes ) then

  return.

if plDisableTriggers then

  for each bttField
    where bttField.DatabaseName = pcDatabaseName
      and bttField.TableName    = phPhysicalBuffer:table
      and bttField.IsVirtual    = yes
    break by bttField.DataType:

    if first-of( bttField.DataType ) then
    do on error undo, throw:

      cVirtualFieldTableName = (if glStaticVirtualDBFieldDataFieldApi then
                                  dynamic-invoke(goVirtualDBFieldDataFieldApiClass:TypeName,
                                                 'cTableNameByDataType':U,
                                                 bttField.DataType)
                                else
                                  dynamic-invoke(goVirtualDBFieldDataFieldApiInstance,
                                                 'cTableNameByDataType':U,
                                                 bttField.DataType)).

      create buffer hVirtualFieldTableBuffer for table cVirtualFieldTableName.

      hVirtualFieldTableBuffer:disable-load-triggers( no ).

      finally:

        if valid-handle( hVirtualFieldTableBuffer ) then

          delete object hVirtualFieldTableBuffer.

      end finally.

    end.

  end.

if glStaticVirtualDBFieldDataApi then
  dynamic-invoke(goVirtualDBFieldDataApiClass:TypeName,
                 'deleteAllForOID':U,
                 qg_cObjectIdForBuffer(phPhysicalBuffer)).

else
  dynamic-invoke(goVirtualDBFieldDataApiInstance,
                 'deleteAllForOID':U,
                 qg_cObjectIdForBuffer(phPhysicalBuffer)).


end procedure.


procedure qg_InitializeVirtualDBFieldFramework :
/**
 *
 */

  run qg_InitializeVirtualDBFieldDataApi.
  run qg_InitializeVirtualDBFieldDataFieldApi.

end.


procedure qg_InitializeVirtualDBFieldDataApi :
/**
 * Initializes the virtual db field data api
 */

goVirtualDBFieldDataApiClass = Progress.Lang.Class:GetClass('basis.base.cls.BMCAddDataSvc':U) no-error.

if valid-object(goVirtualDBFieldDataApiClass) then
do:
  
  assign
    gcVirtualDBFieldReposFlagFieldName = 'AdditionalDBField':U
    glStaticVirtualDBFieldDataApi      = not valid-object(goVirtualDBFieldDataApiClass:GetProperty('prpoInstance':U,
                                                                                                   Progress.Reflect.Flags:Static or Progress.Reflect.Flags:Public))
    .
  
end.

else
do:
  
  goVirtualDBFieldDataApiClass = Progress.Lang.Class:GetClass('x.adm.cls.XDCAddDataSvc':U) no-error.
  
  if valid-object(goVirtualDBFieldDataApiClass) then
    gcVirtualDBFieldReposFlagFieldName = 'xDB-Field':U.
  
end.

if not glStaticVirtualDBFieldDataApi then
  goVirtualDBFieldDataApiInstance = goVirtualDBFieldDataApiClass:GetPropertyValue('prpoInstance':U).

end procedure.


procedure qg_InitializeVirtualDBFieldDataFieldApi :
/**
 * Initializes the virtual db field data field api
 */

goVirtualDBFieldDataFieldApiClass = Progress.Lang.Class:GetClass('adm.repos.cls.DRCAddDataFieldSvc':U) no-error.

if valid-object(goVirtualDBFieldDataFieldApiClass) then
  glStaticVirtualDBFieldDataFieldApi = not valid-object(goVirtualDBFieldDataApiClass:GetProperty('prpoInstance':U,
                                                                                                 Progress.Reflect.Flags:Static or Progress.Reflect.Flags:Public)).
  
else
  goVirtualDBFieldDataFieldApiClass = Progress.Lang.Class:GetClass('x.adm.cls.XDCAddDataSvc':U) no-error.

if not glStaticVirtualDBFieldDataFieldApi then
  goVirtualDBFieldDataFieldApiInstance = goVirtualDBFieldDataFieldApiClass:GetPropertyValue('prpoInstance':U).

end procedure.


procedure qg_RemoveInvalidVirtualFieldColumns :
/**
 *
 */

define parameter buffer pbttQueryWindow for temp-table ttQueryWindow.

define variable hBuffer as handle    no-undo.

define buffer bttVirtualFieldColumn for temp-table ttVirtualFieldColumn.

for each bttVirtualFieldColumn
  where bttVirtualFieldColumn.OwnerHandle = pbttQueryWindow.QueryHandle
  break by bttVirtualFieldColumn.BufferName
  on error undo, throw:

  if first-of( bttVirtualFieldColumn.BufferName ) then

    hBuffer = pbttQueryWindow.QueryHandle:get-buffer-handle( bttVirtualFieldColumn.BufferName ) no-error.

  if    not valid-handle( hBuffer )
     or not can-find( first ttQueryWindowField
                        where ttQueryWindowField.WindowHandle = pbttQueryWindow.WindowHandle
                          and ttQueryWindowField.BufferName   = bttVirtualFieldColumn.BufferName
                          and ttQueryWindowField.FieldName    = bttVirtualFieldColumn.FieldName
                          and ttQueryWindowField.FieldIndex   = bttVirtualFieldColumn.FieldIndex
                          and ttQueryWindowField.IsOverlay    = no ) then

    run qg_RemoveVirtualFieldColumn( bttVirtualFieldColumn.OwnerHandle,
                                     bttVirtualFieldColumn.BufferName,
                                     bttVirtualFieldColumn.FieldName,
                                     bttVirtualFieldColumn.FieldIndex ).

  if last-of( bttVirtualFieldColumn.BufferName ) then

    hBuffer = ?.

end.

end procedure.


procedure qg_RemoveVirtualFieldColum :
/**
 *
 */

define parameter buffer pbttVirtualFieldColumn for temp-table ttVirtualFieldColumn.

if valid-handle( pbttVirtualFieldColumn.ColumnHandle ) then

  delete object pbttVirtualFieldColumn.ColumnHandle no-error.

delete pbttVirtualFieldColumn.

end procedure.


procedure qg_RemoveAllVirtualFieldColums :
/**
 *
 */

define parameter buffer pbttQueryWindow for temp-table ttQueryWindow.

define buffer bttVirtualFieldColumn for temp-table ttVirtualFieldColumn.

for each bttVirtualFieldColumn
where bttVirtualFieldColumn.OwnerHandle = pbttQueryWindow.QueryHandle
  on error undo, throw:

  run qg_RemoveVirtualFieldColum( buffer bttVirtualFieldColumn ).

end.

end procedure.


function qg_cBufferCompareVirtualFields returns character 
  ( phBuffer1 as handle,
    phBuffer2 as handle ):
/**
 *
 */

define variable cDatabaseName1       as character no-undo.
define variable lDatabase1IsPhysical as logical   no-undo.
define variable cObjectIdValue1      as character no-undo.

define variable cDatabaseName2       as character no-undo.
define variable lDatabase2IsPhysical as logical   no-undo.
define variable cObjectIdValue2      as character no-undo.

define variable cFieldList           as character no-undo.

define buffer bttField for temp-table ttField.

assign
  cDatabaseName1       = qg_cDatabaseNameForTableOrBuffer( phBuffer1 )
  lDatabase1IsPhysical = qg_lIsPhysicalDatabase( phBuffer1:dbname )
  cDatabaseName2       = qg_cDatabaseNameForTableOrBuffer( phBuffer2 )
  lDatabase2IsPhysical = qg_lIsPhysicalDatabase( phBuffer2:dbname )
  .

// Non-physical tables can't have virtual fields.
if    not lDatabase1IsPhysical
  and not lDatabase2IsPhysical then

  return '':U.

if lDatabase1IsPhysical then

  cObjectIdValue1 = qg_cObjectIdForBuffer( phBuffer1 ).

if lDatabase2IsPhysical then

  cObjectIdValue2 = qg_cObjectIdForBuffer( phBuffer1 ).

if lDatabase1IsPhysical then

  for each bttField
    where bttField.DatabaseName = cDatabaseName1
      and bttField.TableName    = phBuffer1:table
      and bttField.IsVirtual    = yes
      and bttField.FieldType    = {&K_FIELD_TYPE_VIRTUAL_DB_FIELD}
    on error undo, throw:

    if not qg_lBufferCompareSingleVirtualField( phBuffer1,
                                                lDatabase1IsPhysical,
                                                cObjectIdValue1,
                                                phBuffer2,
                                                lDatabase2IsPhysical,
                                                cObjectIdValue2,
                                                bttField.FieldName,
                                                bttField.DataType ) then

      cFieldList = cFieldList + ',':U + bttField.FieldName.

  end.

if    lDatabase2IsPhysical
  and phBuffer2:table <> phBuffer1:table then

  for each bttField
    where bttField.DatabaseName = cDatabaseName1
      and bttField.TableName    = phBuffer2:table
      and bttField.IsVirtual    = yes
      and bttField.FieldType    = {&K_FIELD_TYPE_VIRTUAL_DB_FIELD}
    on error undo, throw:

    if not qg_lBufferCompareSingleVirtualField( phBuffer1,
                                                lDatabase1IsPhysical,
                                                cObjectIdValue1,
                                                phBuffer2,
                                                lDatabase2IsPhysical,
                                                cObjectIdValue2,
                                                bttField.FieldName,
                                                bttField.DataType ) then

      cFieldList = cFieldList + ',':U + bttField.FieldName.

  end.

return trim( cFieldList, ',':U ).

end function.


function qg_cGetFieldAssignmentsStatementForVirtualFields returns character 
  ( pcDatabaseName as character,
    pcTableName    as character,
    pcBufferName   as character,
    pcFieldList    as character,
    piValueMode    as integer,
    pcValueList    as character,
    plAddTags      as logical,
    piIndentBlanks as integer ):
/**
 *
 */

define variable lRelevantFieldsExist           as logical   no-undo.
define variable iFieldCounter                  as integer   no-undo.
define variable cAssingStatement               as character no-undo.

define variable cCompanyInclude                as character no-undo.
define variable cCompany                       as character no-undo.

define variable iFieldNameLength               as integer   no-undo.
define variable iLongestFieldname              as integer   no-undo.

define variable cValue                         as character no-undo.

define buffer bttField for temp-table ttField.

do iFieldCounter = 1 to num-entries(pcFieldList):

  find first bttField
    where bttField.DatabaseName = pcDatabaseName
      and bttField.TableName    = pcTableName
      and bttField.FieldName    = entry(iFieldCounter, pcFieldList)
      and bttField.FieldType    = {&K_FIELD_TYPE_VIRTUAL_DB_FIELD}
    no-error.

  if available(bttField) then
  do:

    assign
      lRelevantFieldsExist = yes
      iFieldNameLength     = length(bttField.FieldName).

    if iFieldNameLength > iLongestFieldname then
      iLongestFieldname = iFieldNameLength.

  end.

end.

if not lRelevantFieldsExist then

  return '':U.

if not valid-object(goVirtualDBFieldDataApiClass) then
  return '':U.

do iFieldCounter = 1 to num-entries(pcFieldList):

  find first bttField
    where bttField.DatabaseName = pcDatabaseName
      and bttField.TableName    = pcTableName
      and bttField.FieldName    = entry(iFieldCounter, pcFieldList)
      and bttField.FieldType    = {&K_FIELD_TYPE_VIRTUAL_DB_FIELD}
    no-error.

  if available(bttField) then
  do:

    if piValueMode = {&K_VALUE_MODE_PARAMETER} then
      cValue = entry(iFieldCounter, pcValueList, {&K_PARAM_SPLITTER}).

    assign
      iFieldNameLength = length(bttField.FieldName)
      cAssingStatement = substitute('&1~n&2&3:prpoInstance:setValue( &5.&4_Obj, ~'&6~':U, &7&8 ).':U,
                                    cAssingStatement,
                                    fill(' ':U, piIndentBlanks),
                                    goVirtualDBFieldDataApiClass:TypeName,
                                    pcTableName,
                                    pcBufferName,
                                    bttField.FieldName,
                                    fill(' ':U, max(0, iLongestFieldname - iFieldNameLength)),
                                    (if piValueMode = {&K_VALUE_MODE_PARAMETER} then
                                       (if cValue = '%DATATYPE%':U then
                                          qg_cTaggedValue(substitute('<&1>':U, caps(bttField.DataType)),
                                                          plAddTags)
                                        else if cValue = '%COMPANY%':U then
                                          (if cCompanyInclude > '':U then
                                             substitute('~{firma/&1 &2~}':U,
                                                        cCompanyInclude,
                                                        qg_cTaggedValue(cCompany,
                                                                        plAddTags))
                                           else
                                             qg_cTaggedValue(cCompany,
                                                             plAddTags))
                                        else
                                          qg_cTaggedValue(cValue,
                                                          plAddTags))
                                     else
                                       (if can-do({&K_COMPANY_FIELDS}, bttField.FieldName) then
                                          (if cCompanyInclude > '':U then
                                             substitute('~{firma/&1 &2~}':U,
                                                        cCompanyInclude,
                                                        qg_cTaggedValue(cCompany,
                                                                        plAddTags))
                                           else
                                             qg_cTaggedValue(cCompany,
                                                             plAddTags))
                                        else
                                          qg_cTaggedValue(substitute('<&1>':U,
                                                                  caps(bttField.DataType)),
                                                          plAddTags)))
                                     ).

  end.

end.

return cAssingStatement.

end function. 


function qg_clVirtualDBFieldValueAsLongchar returns longchar 
  ( pcDataType      as character,
    pcFieldName     as character,
    pcObjectIdValue as character,
    pcFormat        as character ):
/**
 *
 */

define variable cMethodName  as character no-undo.
define variable cFieldValue  as character   no-undo.
define variable iFieldValue  as integer     no-undo.
define variable dFieldValue  as decimal     no-undo.
define variable lFieldValue  as logical     no-undo.
define variable tFieldValue  as date        no-undo.
define variable tzFieldValue as datetime-tz no-undo.
define variable clFieldValue as longchar    no-undo.

cMethodName = (if glStaticVirtualDBFieldDataApi then
                 dynamic-invoke(goVirtualDBFieldDataApiClass:TypeName,
                                'cMethodNameByDataType':U,
                                pcDataType)
               else
                 dynamic-invoke(goVirtualDBFieldDataApiInstance,
                                'cMethodNameByDataType':U,
                                pcDataType)).

if cMethodName > '':U then

  case pcDataType:

    when 'character':U then
    do:

      cFieldValue = (if glStaticVirtualDBFieldDataApi then
                       dynamic-invoke(goVirtualDBFieldDataApiClass:TypeName,
                                      cMethodName,
                                      pcObjectIdValue,
                                      pcFieldName)
                     else
                       dynamic-invoke(goVirtualDBFieldDataApiInstance,
                                      cMethodName,
                                      pcObjectIdValue,
                                      pcFieldName)).

      return ( if pcFormat <> ? then
                 string( cFieldValue, pcFormat )
               else
                 cFieldValue ).

    end.

    when 'integer':U then
    do:

      iFieldValue = (if glStaticVirtualDBFieldDataApi then
                       dynamic-invoke(goVirtualDBFieldDataApiClass:TypeName,
                                      cMethodName,
                                      pcObjectIdValue,
                                      pcFieldName)
                     else
                       dynamic-invoke(goVirtualDBFieldDataApiInstance,
                                      cMethodName,
                                      pcObjectIdValue,
                                      pcFieldName)).

      return ( if pcFormat <> ? then
                 trim( string( iFieldValue, pcFormat ) )
               else
                 trim( string( iFieldValue ) ) ).

    end.

    when 'decimal':U then
    do:

      dFieldValue = (if glStaticVirtualDBFieldDataApi then
                       dynamic-invoke(goVirtualDBFieldDataApiClass:TypeName,
                                      cMethodName,
                                      pcObjectIdValue,
                                      pcFieldName)
                     else
                       dynamic-invoke(goVirtualDBFieldDataApiInstance,
                                      cMethodName,
                                      pcObjectIdValue,
                                      pcFieldName)).

      return (if pcFormat <> ? then
                trim(string(dFieldValue, pcFormat))
              else
                trim(string(dFieldValue))).

    end.

    when 'logical':U then
    do:

      lFieldValue = (if glStaticVirtualDBFieldDataApi then
                       dynamic-invoke(goVirtualDBFieldDataApiClass:TypeName,
                                      cMethodName,
                                      pcObjectIdValue,
                                      pcFieldName)
                     else
                       dynamic-invoke(goVirtualDBFieldDataApiInstance,
                                      cMethodName,
                                      pcObjectIdValue,
                                      pcFieldName)).

      return ( if pcFormat <> ? then
                 trim( string( lFieldValue, pcFormat ) )
               else
                 trim( string( lFieldValue ) ) ).

    end.

    when 'date':U then
    do:

      tFieldValue = (if glStaticVirtualDBFieldDataApi then
                       dynamic-invoke(goVirtualDBFieldDataApiClass:TypeName,
                                      cMethodName,
                                      pcObjectIdValue,
                                      pcFieldName)
                     else
                       dynamic-invoke(goVirtualDBFieldDataApiInstance,
                                      cMethodName,
                                      pcObjectIdValue,
                                      pcFieldName)).

      return ( if pcFormat <> ? then
                 trim( string( tFieldValue, pcFormat ) )
               else
                 trim( string( tFieldValue ) ) ).

    end.

    when 'datetime-tz':U then
    do:

      tzFieldValue = (if glStaticVirtualDBFieldDataApi then
                        dynamic-invoke(goVirtualDBFieldDataApiClass:TypeName,
                                       cMethodName,
                                       pcObjectIdValue,
                                       pcFieldName)
                      else
                        dynamic-invoke(goVirtualDBFieldDataApiInstance,
                                       cMethodName,
                                       pcObjectIdValue,
                                       pcFieldName)).

      return ( if pcFormat <> ? then
                 trim( string( tzFieldValue, pcFormat ) )
               else
                 trim( string( tzFieldValue ) ) ).

    end.

    when 'clob':U then
    do:

      clFieldValue = (if glStaticVirtualDBFieldDataApi then
                        dynamic-invoke(goVirtualDBFieldDataApiClass:TypeName,
                                       cMethodName,
                                       pcObjectIdValue,
                                       pcFieldName)
                      else
                        dynamic-invoke(goVirtualDBFieldDataApiInstance,
                                       cMethodName,
                                       pcObjectIdValue,
                                       pcFieldName)).

      // Never apply format to clob fields.
      return clFieldValue.

    end.

    otherwise
      return ?.

  end case.

catch oError as Progress.Lang.Error:
  return ?.
end catch.

end function.


function qg_clVirtualFieldValueAsLongchar returns longchar 
  ( piFieldType     as integer,
    pcDataType      as character,
    pcFieldName     as character,
    pcObjectIdValue as character,
    pcFormat        as character ):
/**
 *
 */

case piFieldType:

  when {&K_FIELD_TYPE_VIRTUAL_DB_FIELD} then

    return qg_clVirtualDBFieldValueAsLongchar( pcDataType,
                                               pcFieldName,
                                               pcObjectIdValue,
                                               pcFormat ).

  otherwise
    return ?.

end case.

end function.


function qg_lBufferCompareSingleVirtualField returns logical 
  ( phBuffer1             as handle,
    plDatabase1IsPhysical as logical,
    pcObjectIdValue1      as character,
    phBuffer2             as handle,
    plDatabase2IsPhysical as logical,
    pcObjectIdValue2      as character,
    pcFieldName           as character,
    pcDataType            as character ):
/**
 *
 */

define variable hField1       as handle    no-undo.
define variable hField2       as handle    no-undo.

define variable cMethodName   as character no-undo.
define variable clFieldValue1 as longchar  no-undo.
define variable clFieldValue2 as longchar  no-undo.

hField1 = phBuffer1:buffer-field( pcFieldName ) no-error.
hField2 = phBuffer2:buffer-field( pcFieldName ) no-error.

// Case 1: Field does exist physically in both tables.
if    valid-handle(hField1)
  and valid-handle(hField2) then
do:

  if    hField1:data-type <> hField2:data-type
     or hField1:extent     > 0
     or hField2:extent     > 0 then

    return yes.

  if lookup( hField1:data-type, 'CLOB,BLOB':U) = 0 then

    return (if lookup( hField1:data-type, 'character,longchar':U) = 0 then
              (hField1:buffer-value = hField2:buffer-value)
            else
              compare(hField1:buffer-value,
                      'EQ':U,
                      hField1:buffer-value,
                      'RAW':U)).

  else
  do:

    copy-lob
      from hField1:buffer-value
      to clFieldValue1
      .

    copy-lob
      from hField1:buffer-value
      to clFieldValue2
      .

    return compare( clFieldValue1,
                    'EQ':U,
                    clFieldValue2,
                    'RAW':U ).

  end.

end.

// Case 2: Field does not exist physically in both tables.
else

  if    not valid-handle( hField1 )
    and not valid-handle( hField2 ) then
  do:

    if    not plDatabase1IsPhysical
       or not plDatabase2IsPhysical then

      return yes.

    cMethodName = (if glStaticVirtualDBFieldDataApi then
                     dynamic-invoke(goVirtualDBFieldDataApiClass:TypeName,
                                    'cMethodNameByDataType':U,
                                    pcDataType)
                   else
                     dynamic-invoke(goVirtualDBFieldDataApiInstance,
                                    'cMethodNameByDataType':U,
                                    pcDataType)).

    return (if lookup( pcDataType, 'character,longchar':U ) = 0 then
                (if glStaticVirtualDBFieldDataApi then
                   dynamic-invoke(goVirtualDBFieldDataApiClass:TypeName,
                                  cMethodName,
                                  pcObjectIdValue1,
                                  pcFieldName)
                 else
                   dynamic-invoke(goVirtualDBFieldDataApiInstance,
                                  cMethodName,
                                  pcObjectIdValue1,
                                  pcFieldName))
              = (if glStaticVirtualDBFieldDataApi then
                   dynamic-invoke(goVirtualDBFieldDataApiClass:TypeName,
                                  cMethodName,
                                  pcObjectIdValue2,
                                  pcFieldName)
                 else
                   dynamic-invoke(goVirtualDBFieldDataApiInstance,
                                  cMethodName,
                                  pcObjectIdValue2,
                                  pcFieldName))
            else
              compare((if glStaticVirtualDBFieldDataApi then
                         dynamic-invoke(goVirtualDBFieldDataApiClass:TypeName,
                                        cMethodName,
                                        pcObjectIdValue1,
                                        pcFieldName)
                       else
                         dynamic-invoke(goVirtualDBFieldDataApiInstance,
                                        cMethodName,
                                        pcObjectIdValue1,
                                        pcFieldName)),
                      'EQ':U,
                      (if glStaticVirtualDBFieldDataApi then
                         dynamic-invoke(goVirtualDBFieldDataApiClass:TypeName,
                                        cMethodName,
                                        pcObjectIdValue2,
                                        pcFieldName)
                       else
                         dynamic-invoke(goVirtualDBFieldDataApiInstance,
                                        cMethodName,
                                        pcObjectIdValue2,
                                        pcFieldName)),
                      'RAW':U)).

  end.

// Case 3: Field does exist physically in table 1 but not in table 2.
else

  if    valid-handle( hField1 )
    and not valid-handle( hField2 ) then
  do:

    if not plDatabase2IsPhysical then

      return yes.

    if    hField1:data-type <> pcDataType
       or hField1:extent     > 0 then

      return yes.

    cMethodName = (if glStaticVirtualDBFieldDataApi then
                     dynamic-invoke(goVirtualDBFieldDataApiClass:TypeName,
                                    'cMethodNameByDataType':U,
                                    pcDataType)
                   else
                     dynamic-invoke(goVirtualDBFieldDataApiInstance,
                                    'cMethodNameByDataType':U,
                                    pcDataType)).

    if lookup( pcDataType, 'CLOB,BLOB':U ) = 0 then

      return (if lookup( pcDataType, 'character,longchar':U ) = 0 then
                  hField1:buffer-value
                = (if glStaticVirtualDBFieldDataApi then
                     dynamic-invoke(goVirtualDBFieldDataApiClass:TypeName,
                                    cMethodName,
                                    pcObjectIdValue2,
                                    pcFieldName)
                   else
                     dynamic-invoke(goVirtualDBFieldDataApiInstance,
                                    cMethodName,
                                    pcObjectIdValue2,
                                    pcFieldName))
              else
                compare(hField1:buffer-value,
                       'EQ':U,
                       (if glStaticVirtualDBFieldDataApi then
                          dynamic-invoke(goVirtualDBFieldDataApiClass:TypeName,
                                         cMethodName,
                                         pcObjectIdValue2,
                                         pcFieldName)
                        else
                          dynamic-invoke(goVirtualDBFieldDataApiInstance,
                                         cMethodName,
                                         pcObjectIdValue2,
                                         pcFieldName)),
                       'RAW':U)).

    else
    do:

      copy-lob
        from hField1:buffer-value
        to clFieldValue1
        .

      return compare( clFieldValue1,
                      'EQ':U,
                      (if glStaticVirtualDBFieldDataApi then
                         dynamic-invoke(goVirtualDBFieldDataApiClass:TypeName,
                                        cMethodName,
                                        pcObjectIdValue2,
                                        pcFieldName)
                       else
                         dynamic-invoke(goVirtualDBFieldDataApiInstance,
                                        cMethodName,
                                        pcObjectIdValue2,
                                        pcFieldName)),
                      'RAW':U ).

    end.

  end.

// Case 4: Field does exist physically in table 2 but not in table 1.
else

  if    not valid-handle( hField1 )
    and valid-handle( hField2 ) then
  do:

    if not plDatabase1IsPhysical then

      return yes.

    if    hField2:data-type <> pcDataType
       or hField2:extent     > 0 then

      return yes.

    cMethodName = (if glStaticVirtualDBFieldDataApi then
                     dynamic-invoke(goVirtualDBFieldDataApiClass:TypeName,
                                    'cMethodNameByDataType':U,
                                    pcDataType)
                   else
                     dynamic-invoke(goVirtualDBFieldDataApiInstance,
                                    'cMethodNameByDataType':U,
                                    pcDataType)).

    if lookup( pcDataType, 'CLOB,BLOB':U ) = 0 then

      return (if lookup( pcDataType, 'character,longchar':U ) = 0 then
                  (if glStaticVirtualDBFieldDataApi then
                     dynamic-invoke(goVirtualDBFieldDataApiClass:TypeName,
                                    cMethodName,
                                    pcObjectIdValue1,
                                    pcFieldName)
                   else
                     dynamic-invoke(goVirtualDBFieldDataApiInstance,
                                    cMethodName,
                                    pcObjectIdValue1,
                                    pcFieldName))
                = hField2:buffer-value
              else
                compare((if glStaticVirtualDBFieldDataApi then
                           dynamic-invoke(goVirtualDBFieldDataApiClass:TypeName,
                                          cMethodName,
                                          pcObjectIdValue1,
                                          pcFieldName)
                         else
                           dynamic-invoke(goVirtualDBFieldDataApiInstance,
                                          cMethodName,
                                          pcObjectIdValue1,
                                          pcFieldName)),
                         'EQ':U,
                         hField2:buffer-value,
                         'RAW':U ) ).

    else
    do:

      copy-lob
        from hField2:buffer-value
        to clFieldValue2
        .

      return compare((if glStaticVirtualDBFieldDataApi then
                        dynamic-invoke(goVirtualDBFieldDataApiClass:TypeName,
                                       cMethodName,
                                       pcObjectIdValue2,
                                       pcFieldName)
                      else
                        dynamic-invoke(goVirtualDBFieldDataApiInstance,
                                       cMethodName,
                                       pcObjectIdValue2,
                                       pcFieldName)),
                      'EQ':U,
                      clFieldValue2,
                      'RAW':U ).

    end.

  end.

  return ?.

end function.


function qg_lVirtualDBFieldsPossible returns logical 
  ( buffer pbttDatabase for ttDatabase ):
/**
 *
 */

define buffer bttField for temp-table ttField.

if pbttDatabase.BasisDBName <> {&K_BASE_DB_NAME} then
  return no.

// We are not really interested in the fields object id. We make this call to
// deterimine if (1) the field exists and (2) we are in an environment that
// has the repository manager up and runnung.

if    qg_lFieldExistsInDatabaseSchema( pbttDatabase.BasisDBName,
                                       'DRC_VirtualField':U,
                                       gcVirtualDBFieldReposFlagFieldName )
  and dynamic-function( 'pa_cReposFieldInformationByName':U,
                        /* pcDRC_Table_ID */ 'DRC_VirtualField':U,
                        /* pcDRC_Field_ID */ gcVirtualDBFieldReposFlagFieldName,
                        /* pcRequest      */ 'DRC_Field_Obj':U ) > '':U then
    return yes.

  return no.

  catch oError as Progress.Lang.Error:
    return no.
  end catch.

end function.

/* <<< Include: incl/virtual_fields.i <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/* >>> Include: incl/virtual_indices.i >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> */

/**
 * @COPYRIGHT@
 * Project Proalpha
 * Name    virtual_indices.i
 * Created <version> as of 06.01.2022/Thiemann_M
 * Current @PAVERSION@ as of @PADATE@/@PALASTAUTHOR@
 *
 *
 * ## HISTORY
 * @FILEHISTORY@
 */

// ********************  Preprocessor Definitions  ********************


procedure qg_AddTableVirtualIndices :
/**
 *
 *
 * @param pbttDatabase
 * @param pbttTable
 */

define parameter buffer pbttDatabase for temp-table ttDatabase.
define parameter buffer pbttTable    for temp-table ttTable.

define variable hRepVirtualIndexBuffer      as handle    no-undo.
define variable hRepVirtualIndexFieldBuffer as handle    no-undo.

define variable hRepVirtualIndexQuery       as handle    no-undo.
define variable hRepVirtualIndexFieldQuery  as handle    no-undo.
define variable cIndexQueryText             as character no-undo.
define variable cIndexFieldQueryText        as character no-undo.

define variable iVirtIdxFieldNo             as integer   no-undo.
define variable cVirtIdxFieldDataType       as character no-undo.
define variable cLastVirtIdxFieldDataType   as character no-undo init 'Dec':U.

define variable cMappedFields               as character no-undo.
define variable iMappedFieldIndex           as integer   no-undo.
define variable cSkippedFields              as character no-undo.
define variable iSkippedFieldIndex          as integer   no-undo.

define variable cFieldName                  as character no-undo.
define variable cFieldDataType              as character no-undo.
define variable cFieldValue                 as character no-undo.

define buffer bttIndex              for temp-table ttIndex.
define buffer bttIndexField         for temp-table ttIndexField.
define buffer bttTable              for temp-table ttTable.
define buffer bttField              for temp-table ttField.
define buffer bttTable-Virtual      for temp-table ttTable.
define buffer bttIndex-Virtual      for temp-table ttIndex.
define buffer bttIndexField-Virtual for temp-table ttIndexField.

find bttTable-Virtual
  where bttTable-Virtual.DatabaseName = pbttDatabase.BasisDBName
    and bttTable-Virtual.TableName    = gcVirtualIndexDataTableName
  no-error.

if    available bttTable-Virtual
  and not bttTable-Virtual.DetailsLoaded
  and bttTable-Virtual.TableName <> pbttTable.TableName then

  run qg_AddTableDetails( bttTable-Virtual.DatabaseName,
                          bttTable-Virtual.TableName ).

create buffer hRepVirtualIndexBuffer for table substitute( '&1.DRC_Index':U,
                                                           pbttDatabase.BasisDBName ).
create buffer hRepVirtualIndexFieldBuffer for table substitute( '&1.DRC_IndexField':U,
                                                                 pbttDatabase.BasisDBName ).

create query hRepVirtualIndexQuery.
create query hRepVirtualIndexFieldQuery.

hRepVirtualIndexQuery:set-buffers( hRepVirtualIndexBuffer ).
hRepVirtualIndexFieldQuery:set-buffers( hRepVirtualIndexFieldBuffer ).

assign
  cIndexQueryText      =            'for each DRC_Index':U
                         + '~n':U + '  where DRC_Index.DRC_Table_Obj = &1':U
                         + '~n':U + '    and DRC_Index.&2            = yes':U
                         + '~n':U + '  no-lock':U
  cIndexFieldQueryText =            'for each DRC_IndexField':U
                         + '~n':U + '  where DRC_IndexField.DRC_Index_Obj = &1':U
                         + '~n':U + '  no-lock':U
                         .

hRepVirtualIndexQuery:query-prepare( substitute( cIndexQueryText,
                                                 quoter( pbttTable.RepObjectId ),
                                                 gcVirtualIndexReposFlagFieldName ) ).

hRepVirtualIndexQuery:query-open().

do while hRepVirtualIndexQuery:get-next():

  create bttIndex.

  assign
    bttIndex.DatabaseName = pbttDatabase.DatabaseName
    bttIndex.TableName    = pbttTable.TableName
    bttIndex.IndexName    = hRepVirtualIndexBuffer::DRC_Index_ID
    bttIndex.IsPrimary    = hRepVirtualIndexBuffer::IndexIsPrimary
    bttIndex.IsUnique     = hRepVirtualIndexBuffer::IndexIsUnique
    bttIndex.IsVirtual    = yes
    .

  validate bttIndex.

  assign
    iVirtIdxFieldNo           = 0
    cMappedFields             = '':U
    cSkippedFields            = '':U
    cLastVirtIdxFieldDataType = '':U
    .

  hRepVirtualIndexFieldQuery:query-prepare( substitute( cIndexFieldQueryText, quoter( hRepVirtualIndexBuffer::DRC_Index_Obj ) ) ).

  hRepVirtualIndexFieldQuery:query-open().

  do while hRepVirtualIndexFieldQuery:get-next()
    on error undo, throw:

    find bttField
      where bttField.RepObjectId = hRepVirtualIndexFieldBuffer::DRC_Field_Obj
      no-error.

    if not available bttField then
      next.

    create bttIndexField.

    assign
      bttIndexField.DatabaseName     = bttIndex.DatabaseName
      bttIndexField.TableName        = bttIndex.TableName
      bttIndexField.IndexName        = bttIndex.IndexName
      bttIndexField.FieldName        = bttField.FieldName
      bttIndexField.IndexSequence    = hRepVirtualIndexFieldBuffer::DRC_IndexField_ID
      bttIndexField.DataType         = bttField.DataType
      bttIndexField.SortAscending    = hRepVirtualIndexFieldBuffer::IndexFieldAscending
      bttIndex.IndexFieldList        =   bttIndex.IndexFieldList
                                       + ',':U
                                       + bttIndexField.FieldName
      bttIndex.IndexFields           =   bttIndex.IndexFields
                                       + ' '
                                       + string( bttIndexField.SortAscending, '+/-':U )
                                       + bttIndexField.FieldName
      bttIndex.VirtualFieldList      =   bttIndex.VirtualFieldList
                                       + ',':U
                                       + bttIndexField.FieldName
      bttIndex.VirtualFieldDataTypes =   bttIndex.VirtualFieldDataTypes
                                       + ',':U
                                       + bttIndexField.DataType
      cVirtIdxFieldDataType          = ( if bttIndexField.DataType = 'character':U then
                                           'Char':U
                                         else
                                           'Dec':U )
      .

    validate bttIndexField.

    if cVirtIdxFieldDataType = cLastVirtIdxFieldDataType then

      assign
        iVirtIdxFieldNo = iVirtIdxFieldNo + 1
        cSkippedFields  =   cSkippedFields
                          + ',Field':U
                          + string( iVirtIdxFieldNo, '99':U )
                          + ( if cLastVirtIdxFieldDataType = 'Char':U then
                                'Dec':U
                              else
                                'Char':U )
        .

    assign
      iVirtIdxFieldNo = iVirtIdxFieldNo + 1
      cMappedFields   =   cMappedFields
                        + ',Field':U
                        + string( iVirtIdxFieldNo, '99':U )
                        + cVirtIdxFieldDataType
      cLastVirtIdxFieldDataType = cVirtIdxFieldDataType
      .

  end.

  assign
    bttIndex.IndexFieldList                 = trim( bttIndex.IndexFieldList, ',':U )
    bttIndex.IndexFields                    = trim( bttIndex.IndexFields )
    bttIndex.VirtualFieldList               = trim( bttIndex.VirtualFieldList, ',':U )
    bttIndex.VirtualFieldDataTypes          = trim( bttIndex.VirtualFieldDataTypes, ',':U )
    cSkippedFields                          = trim( cSkippedFields, ',':U )
    cMappedFields                           = trim( cMappedFields, ',':U )
    bttIndex.VirtualIndexDataFieldList      = 'DRC_Table_ID,DRC_Index_ID':U
    bttIndex.VirtualIndexDataFieldLabels    = ',':U
    bttIndex.VirtualIndexDataUntaggedValues = '~'':U + bttIndex.TableName + '~':U':U + {&K_PARAM_SPLITTER} + '~'':U + bttIndex.IndexName + '~':U':U
    bttIndex.VirtualIndexDataTaggedValues   = '~'':U + bttIndex.TableName + '~':U':U + {&K_PARAM_SPLITTER} + '~'':U + bttIndex.IndexName + '~':U':U
    .

  find first bttIndex-Virtual
    where bttIndex-Virtual.DatabaseName = bttTable-Virtual.DatabaseName
      and bttIndex-Virtual.TableName    = bttTable-Virtual.TableName
    no-error.

  if available bttIndex-Virtual then

    for each bttIndexField-Virtual
      where bttIndexField-Virtual.DatabaseName = bttIndex-Virtual.DatabaseName
        and bttIndexField-Virtual.TableName    = bttIndex-Virtual.TableName
      on error undo, throw:

      if lookup( bttIndexField-Virtual.FieldName, 'DRC_Table_ID,DRC_Index_ID':U ) > 0 then
        next.

      assign
        iMappedFieldIndex  = lookup( bttIndexField-Virtual.FieldName, cMappedFields )
        iSkippedFieldIndex = ( if iMappedFieldIndex > 0 then
                                 0
                               else
                                 lookup( bttIndexField-Virtual.FieldName, cSkippedFields ) )
        .

      if    iMappedFieldIndex  = 0
        and iSkippedFieldIndex = 0 then

        leave.

      assign
        bttIndex.VirtualIndexDataFieldList      =   bttIndex.VirtualIndexDataFieldList
                                                  + ',':U
                                                  + bttIndexField-Virtual.FieldName
        bttIndex.VirtualIndexDataFieldLabels    =   bttIndex.VirtualIndexDataFieldLabels
                                                  + ',':U
                                                  + ( if iMappedFieldIndex > 0 then
                                                        entry( iMappedFieldIndex, bttIndex.IndexFieldList )
                                                      else
                                                        '':U )
        cFieldName                              = ( if iMappedFieldIndex > 0 then
                                                      entry( iMappedFieldIndex, bttIndex.VirtualFieldList )
                                                    else
                                                      '':U )
        cFieldDataType                          = ( if iMappedFieldIndex > 0 then
                                                      entry( iMappedFieldIndex, bttIndex.VirtualFieldDataTypes )
                                                    else
                                                      bttIndexField-Virtual.DataType )
        cFieldValue                             = ( if iMappedFieldIndex > 0 then
                                                      ( if can-do( {&K_COMPANY_FIELDS}, cFieldName ) then
                                                          substitute( '~{firma/&1 %COMPANY%}':U,
                                                                      qg_cGetCompanyInclude( bttIndex.TableName ) )
                                                        else if not cFieldDataType begins 'datetime':U then
                                                          substitute( '<&1>':U, caps( cFieldDataType ) )
                                                        else
                                                          qg_cVirtualIndexFieldVariableName( cFieldName, 'decimal':U ) )
                                                    else
                                                      ( if bttIndexField-Virtual.DataType = 'character':U then
                                                          '~'~':U':U
                                                        else
                                                          '0':U ) )
        bttIndex.VirtualIndexDataUntaggedValues =   bttIndex.VirtualIndexDataUntaggedValues
                                                  + {&K_PARAM_SPLITTER}
                                                  + cFieldValue
        bttIndex.VirtualIndexDataTaggedValues   = bttIndex.VirtualIndexDataTaggedValues
                                                  + {&K_PARAM_SPLITTER}
                                                  + ( if can-do( {&K_COMPANY_FIELDS}, cFieldName ) then
                                                        cFieldValue
                                                      else if lookup( cFieldDataType, 'character,decimal':U ) > 0 then
                                                        qg_cTaggedValue( cFieldValue,
                                                                         (     iMappedFieldIndex > 0
                                                                           and cFieldValue > '':U ) )
                                                      else if not cFieldDataType begins 'datetime':U then
                                                        substitute( 'decimal( &1 )':U,
                                                                    qg_cTaggedValue( cFieldValue,
                                                                                     (     iMappedFieldIndex > 0
                                                                                       and cFieldValue > '':U ) ) )
                                                      else
                                                        cFieldValue )
        .

    end.

  validate bttIndex.

end.

end procedure.

procedure qg_InitializeVirtualIndexFramework :
define variable oVirtualQueryApiClass as Progress.Lang.Class no-undo.

oVirtualQueryApiClass = Progress.Lang.Class:GetClass( 'basis.base.cls.BMCVirtIndexQuerySvo':U ) no-error.

if valid-object( oVirtualQueryApiClass ) then

  assign
    gcVirtualQueryApiPackageName     = 'basis.base.cls':U
    gcVirtualQueryApiClassName       = 'BMCVirtIndexQuerySvo':U
    gcVirtualIndexDataTableName      = 'DBT_VirtualIndex':U
    gcVirtualIndexReposFlagFieldName = 'IndexIsVirtual':U
    .

else
do:

  oVirtualQueryApiClass = Progress.Lang.Class:GetClass( 'x.adm.cls.XDCVirtQuerySvo':U ) no-error.

  if valid-object( oVirtualQueryApiClass ) then

    assign
      gcVirtualQueryApiPackageName      = 'x.adm.cls':U
      gcVirtualQueryApiClassName        = 'XDCVirtQuerySvo':U
      gcVirtualIndexDataTableName       = 'XDM_VirtualIndex':U
      gcVirtualIndexReposFlagFieldName  = 'xVirtualIndex':U
      .

end.

end procedure.


function qg_cVirtualIndexFieldVariableName returns character 
  ( pcFieldName as character,
    pcDataType  as character ):
/**
 *
 *
 * @param pcFieldName
 * @param pcDataType
 */

define variable cFieldName as character no-undo.

cFieldName = ( if pcFieldName = 'Firma':U then
                 'Company':U
               else
                 pcFieldName ).

return    qg_cDataTypePrefix( pcDataType )
        + ( if    cFieldName begins 'x':U
               or cFieldName begins 'y':U then
              substring( cFieldName, 1, 1 )
            else
              caps( substring( cFieldName, 1, 1 ) ) )
        + substring( cFieldName, 2 )
        .

end function.


function qg_lVirtualIndexPossible returns logical 
  ( buffer pbttDatabase for ttDatabase ):
/**
 *
 *
 * @param pbttDatabase
 */

define buffer bttField for temp-table ttField.

if pbttDatabase.BasisDBName <> {&K_BASE_DB_NAME} then

  return no.

// We are not really interested in the fields object id. We make this call to
// deterimine if (1) the field exists and (2) we are in an environment that
// has the repository manager up and runnung.

if    qg_lFieldExistsInDatabaseSchema( pbttDatabase.BasisDBName,
                                       'DRC_VirtualField':U,
                                       gcVirtualDBFieldReposFlagFieldName )
  and dynamic-function( 'pa_cReposFieldInformationByName':U,
                        /* pcDRC_Table_ID */ 'DRC_Index':U,
                        /* pcDRC_Field_ID */ gcVirtualIndexReposFlagFieldName,
                        /* pcRequest      */ 'DRC_Field_Obj':U ) > '':U then

  return yes.

return no.

catch oError as Progress.Lang.Error:
  return no.
end catch.

end function.


function qg_oVirtualIndexApiInstance returns Progress.Lang.Object 
  (  ):
define variable oVirtualIndexClass as Progress.Lang.Class no-undo.

&IF keyword-all('dynamic-property':U) <> ? &THEN

  if not valid-object( goVirtualIndexApiInstance ) then
  do:

    oVirtualIndexClass = Progress.Lang.Class:GetClass( 'adm.repos.cls.DRCVirtualIndexSvc':U ) no-error.

    if not valid-object( oVirtualIndexClass ) then
      oVirtualIndexClass = Progress.Lang.Class:GetClass( 'x.adm.cls.XDCVirtualIndexSvc':U ) no-error.

    if valid-object( oVirtualIndexClass ) then
      goVirtualIndexApiInstance = oVirtualIndexClass:GetPropertyValue( 'prpoInstance':U ).

  end.

&ENDIF

return goVirtualIndexApiInstance.

catch oError as Progress.Lang.Error:
  return ?.
end catch.

end function.


function qg_oVirtualIndexDataApiInstance returns Progress.Lang.Object 
  (  ):
define variable oVirtualIndexClass as Progress.Lang.Class no-undo.

&IF keyword-all('dynamic-property':U) <> ? &THEN

  if not valid-object( goVirtualIndexDataApiInstance ) then
  do:

    oVirtualIndexClass = Progress.Lang.Class:GetClass( 'basis.base.cls.BMCVirtualIndexSvc':U ) no-error.

    if not valid-object( oVirtualIndexClass ) then
      oVirtualIndexClass = Progress.Lang.Class:GetClass( 'x.adm.cls.XDCVirtualIndexSvc':U ) no-error.

    if valid-object( oVirtualIndexClass ) then
      goVirtualIndexDataApiInstance = oVirtualIndexClass:GetPropertyValue( 'prpoInstance':U ).

  end.

&ENDIF

return goVirtualIndexDataApiInstance.

catch oError as Progress.Lang.Error:
  return ?.
end catch.

end function.


/* <<< Include: incl/virtual_indices.i <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/* ************************  Control Triggers  ************************ */

&Scoped-define SELF-NAME hQueryWindow
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL hQueryWindow hQueryWindow
ON end-error OF hQueryWindow
or endkey of {&WINDOW-NAME} anywhere do:
  /* This case occurs when the user presses the "Esc" key.
     In a persistently run window, just ignore this.  If we did not, the
     application would exit. */
  if this-procedure:persistent then return no-apply.
end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL hQueryWindow hQueryWindow
ON window-close OF hQueryWindow
do:

  define buffer bttQueryWindow  for temp-table ttQueryWindow.
  define buffer bttTable        for temp-table ttTable.

  for each bttQueryWindow
    on error undo, next:

    if valid-handle(bttQueryWindow.WindowHandle) then
      run qg_QueryWindowClose(bttQueryWindow.WindowHandle, no).

    else
      delete bttQueryWindow.

  end.

  if    OEIDEIsRunning
    and glIDECanSaveSetting then
  do:

    /* gcTableFilter history */
    if gcTableFilter:list-items in frame {&FRAME-NAME} <> ? then
      run qg_SaveIDESetting('FieldHistory_gcTableFilter':U,
                            gcTableFilter:list-items in frame {&FRAME-NAME}) no-error.

    /* gcTableFieldFilter history */
    if gcTableFieldFilter:list-items in frame {&FRAME-NAME} <> ? then
      run qg_SaveIDESetting('FieldHistory_gcTableFieldFilter':U,
                            gcTableFieldFilter:list-items in frame {&FRAME-NAME}) no-error.

    /* gcIndexFilter history */
    if gcIndexFilter:list-items in frame {&FRAME-NAME} <> ? then
      run qg_SaveIDESetting('FieldHistory_gcIndexFilter':U,
                            gcIndexFilter:list-items in frame {&FRAME-NAME}) no-error.

    /* gcIndexFieldFilter history */
    if gcIndexFieldFilter:list-items in frame {&FRAME-NAME} <> ? then
      run qg_SaveIDESetting('FieldHistory_gcIndexFieldFilter':U,
                            gcIndexFieldFilter:list-items in frame {&FRAME-NAME}) no-error.

    /* gcRelationFilter history */
    if gcRelationFilter:list-items in frame {&FRAME-NAME} <> ? then
      run qg_SaveIDESetting('FieldHistory_gcRelationFilter':U,
                            gcRelationFilter:list-items in frame {&FRAME-NAME}) no-error.

    /* gcRelationFieldFilter history */
    if gcRelationFieldFilter:list-items in frame {&FRAME-NAME} <> ? then
      run qg_SaveIDESetting('FieldHistory_gcRelationFieldFilter':U,
                            gcRelationFieldFilter:list-items in frame {&FRAME-NAME}) no-error.

    /* gcFieldFilter history */
    if gcFieldFilter:list-items in frame {&FRAME-NAME} <> ? then
      run qg_SaveIDESetting('FieldHistory_gcFieldFilter':U,
                            gcFieldFilter:list-items in frame {&FRAME-NAME}) no-error.

    /* gcFieldLabelFilter history */
    if gcFieldLabelFilter:list-items in frame {&FRAME-NAME} <> ? then
      run qg_SaveIDESetting('FieldHistory_gcFieldLabelFilter':U,
                            gcFieldLabelFilter:list-items in frame {&FRAME-NAME}) no-error.

    /* Initial gcBufferName */
    run qg_SaveIDESetting('FieldInitial_gcBufferName':U,
                          gcBufferPattern) no-error.

    /* Initial glDefineBuffer */
    run qg_SaveIDESetting('FieldInitial_glDefineBuffer':U,
                          string(input frame {&FRAME-NAME} glDefineBuffer, 'true/false':U)) no-error.

    /* Initial glCompanyViaClass */
    run qg_SaveIDESetting('FieldInitial_glCompanyViaClass':U,
                          string(input frame {&FRAME-NAME} glCompanyViaClass, 'true/false':U)) no-error.

    /* Initial glExclusiveLock */
    run qg_SaveIDESetting('FieldInitial_glExclusiveLock':U,
                          string(input frame {&FRAME-NAME} glExclusiveLock, 'true/false':U)) no-error.

    /* Initial glNoError */
    run qg_SaveIDESetting('FieldInitial_glNoError':U,
                          string(input frame {&FRAME-NAME} glNoError, 'true/false':U)) no-error.

    /* Initial glIfStatement */
    run qg_SaveIDESetting('FieldInitial_glIfStatement':U,
                          string(input frame {&FRAME-NAME} glIfStatement, 'true/false':U)) no-error.

    /* Initial glNot */
    run qg_SaveIDESetting('FieldInitial_glNot':U,
                          string(input frame {&FRAME-NAME} glNot, 'true/false':U)) no-error.

    /* Initial glDoBlock */
    run qg_SaveIDESetting('FieldInitial_glDoBlock':U,
                          string(input frame {&FRAME-NAME} glDoBlock, 'true/false':U)) no-error.

    /* Initial glDefineVariables */
    run qg_SaveIDESetting('FieldInitial_glDefineVariables':U,
                          string(input frame {&FRAME-NAME} glDefineVariables, 'true/false':U)) no-error.

    /* Initial glUseVirtualIndexIncludes */
    run qg_SaveIDESetting('FieldInitial_glUseVirtualIndexIncludes':U,
                          string(input frame {&FRAME-NAME} glUseVirtualIndexIncludes, 'true/false':U)) no-error.

    /* Initial glOnError */
    run qg_SaveIDESetting('FieldInitial_glOnError':U,
                          string(input frame {&FRAME-NAME} glOnError)) no-error.

    /* Initial giOnErrorPhrase */
    run qg_SaveIDESetting('FieldInitial_giOnErrorPhrase':U,
                          string(input frame {&FRAME-NAME} giOnErrorPhrase)) no-error.

    /* Initial gcBlockName */
    run qg_SaveIDESetting('FieldInitial_gcBlockName':U,
                          gcBlockPattern) no-error.

    /* Initial glDefineBlock */
    run qg_SaveIDESetting('FieldInitial_glDefineBlock':U,
                          string(input frame {&FRAME-NAME} glDefineBlock, 'true/false':U)) no-error.

    /* Initial glRetryBlock */
    run qg_SaveIDESetting('FieldInitial_glRetryBlock':U,
                          string(input frame {&FRAME-NAME} glRetryBlock, 'true/false':U)) no-error.

    /* Initial glFinallyBlock */
    run qg_SaveIDESetting('FieldInitial_glFinallyBlock':U,
                          string(input frame {&FRAME-NAME} glFinallyBlock, 'true/false':U)) no-error.

    /* Initial giQueryType */
    run qg_SaveIDESetting('FieldInitial_giQueryType':U,
                          string(input frame {&FRAME-NAME} giQueryType)) no-error.

    /*------------------------------------------------------------------------*/
    /* Options                                                                */
    /*------------------------------------------------------------------------*/

    /* Show query type modifier */

    run qg_SaveIDESetting('Options_ShowQueryTypeModifier':U,
                          string(menu-item mi_ShowQueryTypeModifier:checked in menu m_Options, 'true/false':U)) no-error.

    /* Always use 'find first' */

    run qg_SaveIDESetting('Options_AlwaysUseFindFirst':U,
                          string(menu-item mi_AlwaysUseFindFirst:checked in menu m_Options, 'true/false':U)) no-error.

    /* Always use 'can-find first' */

    run qg_SaveIDESetting('Options_AlwaysUseCanFindFirst':U,
                          string(menu-item mi_AlwaysUseCanFindFirst:checked in menu m_Options, 'true/false':U)) no-error.

    /* Use virtual index api */

    run qg_SaveIDESetting('Options_glUseVirtualIndexApi':U,
                          string(menu-item mi_UseVirtualIndexApi:checked in menu m_Options, 'true/false':U)) no-error.

    /* Open query window for persistent temp-tables */

    run qg_SaveIDESetting('Options_OpenQueryWindowForPersistentTT':U,
                          string(menu-item mi_OpenQueryWindowPersistentTT:checked in menu m_Options, 'true/false':U)) no-error.

    /* Open query window for snapshot temp-tables */

    run qg_SaveIDESetting('Options_OpenQueryWindowForSnapshotTT':U,
                          string(menu-item mi_OpenQueryWindowSnapshotTT:checked in menu m_Options, 'true/false':U)) no-error.

    /*--------------------------------------------------------------------------*/
    /* Session-Trigger settings                                                 */
    /*--------------------------------------------------------------------------*/

    run qg_SaveIDESetting('Options_SessionTriggerShowMessage':U,
                          string(glSessionTriggerShowMessage, 'true/false':U)) no-error.

    run qg_SaveIDESetting('Options_SessionTriggerWriteLog':U,
                          string(glSessionTriggerWriteLog, 'true/false':U)) no-error.

    run qg_SaveIDESetting('Options_SessionTriggerLogFileName':U,
                          gcSessionTriggerLogFileName) no-error.

    run qg_SaveIDESetting('Options_SessionTriggerIndexValues':U,
                          string(glSessionTriggerIndexValues, 'true/false':U)) no-error.

    run qg_SaveIDESetting('Options_SessionTriggerStackTrace':U,
                          string(glSessionTriggerStackTrace, 'true/false':U)) no-error.

    /*--------------------------------------------------------------------------*/
    /* Session-Trigger settings                                                 */
    /*--------------------------------------------------------------------------*/

    run qg_SaveIDESetting('Options_ShowVirtualFields':U,
                          string(glShowVirtualFields, 'true/false':U)) no-error.

    run qg_SaveIDESetting('Options_ShowVirtualIndices':U,
                          string(glShowVirtualIndices, 'true/false':U)) no-error.

  end.

  for each bttTable
    where bttTable.PhysicalTable = no
    on error undo, next:

    if    bttTable.Snapshot
      and valid-handle(bttTable.TableHandle) then
      delete object bttTable.TableHandle.

  end.

  if gcTTWidgetPool > '':U then
    delete widget-pool gcTTWidgetPool no-error.

  if valid-handle(ghQueryWindowListWindow) then
    apply 'window-close':U to ghQueryWindowListWindow.

  if valid-handle(ghSessionTriggersWindow) then
    apply 'window-close':U to ghSessionTriggersWindow.

  run qg_RemoveAllSessionTriggers.

  if valid-handle(gchMerge) then
  do:

    release object gchMerge.
    gchMerge = ?.

  end.

  /* This event will close the window and terminate the procedure.  */
  apply "CLOSE":U to this-procedure.
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL hQueryWindow hQueryWindow
ON window-resized OF hQueryWindow
do:

  assign
    hQueryWindow:width-chars  = max(gdMinWidth, hQueryWindow:width-chars)
    hQueryWindow:height-chars = max(gdMinHeight, hQueryWindow:height-chars)
    .

  run qg_AdjustWidgetsSizeAndPos(frame {&FRAME-NAME}:handle,
                                 hQueryWindow:width-chars - gdOriginalWidth,
                                 hQueryWindow:height-chars - gdOriginalHeight).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME fQuery
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on CTRL-INS of frame fQuery anywhere
do:

  apply 'choose' to btnCopyToClipboard in frame {&FRAME-NAME}.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&Scoped-define SELF-NAME fQuery
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on off-home of brTable in frame fQuery anywhere
do:

  apply 'entry' to gcTableFilter in frame {&FRAME-NAME}.
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&Scoped-define SELF-NAME fQuery
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on cursor-down of gcTableFilter in frame fQuery anywhere
do:

  apply 'entry' to brTable in frame {&FRAME-NAME}.
  browse brTable:select-focused-row().
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on cursor-down of btnClearTableFilter in frame fQuery anywhere
do:

  apply 'entry' to brTable in frame {&FRAME-NAME}.
  browse brTable:select-focused-row().
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on cursor-down of gcTableFieldFilter in frame fQuery anywhere
do:

  apply 'entry' to brTable in frame {&FRAME-NAME}.
  browse brTable:select-focused-row().
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on cursor-down of btnClearTableFieldFilter in frame fQuery anywhere
do:

  apply 'entry' to brTable in frame {&FRAME-NAME}.
  browse brTable:select-focused-row().
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&Scoped-define SELF-NAME fQuery
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on off-home of brField in frame fQuery anywhere
do:

  apply 'entry' to gcFieldFilter in frame {&FRAME-NAME}.
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on cursor-down of gcFieldFilter in frame fQuery anywhere
do:

  apply 'entry' to brField in frame {&FRAME-NAME}.
  browse brField:select-focused-row().
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on cursor-down of btnClearFieldFilter in frame fQuery anywhere
do:

  apply 'entry' to brField in frame {&FRAME-NAME}.
  browse brField:select-focused-row().
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on cursor-down of gcFieldLabelFilter in frame fQuery anywhere
do:

  apply 'entry' to brField in frame {&FRAME-NAME}.
  browse brField:select-focused-row().
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on cursor-down of btnClearFieldLabelFilter in frame fQuery anywhere
do:

  apply 'entry' to brField in frame {&FRAME-NAME}.
  browse brField:select-focused-row().
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&Scoped-define SELF-NAME fQuery
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on off-home of brIndex in frame fQuery anywhere
do:

  apply 'entry' to gcIndexFilter in frame {&FRAME-NAME}.
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on cursor-down of gcIndexFilter in frame fQuery anywhere
do:

  apply 'entry' to brIndex in frame {&FRAME-NAME}.
  browse brIndex:select-focused-row().
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on cursor-down of btnClearIndexFilter in frame fQuery anywhere
do:

  apply 'entry' to brIndex in frame {&FRAME-NAME}.
  browse brIndex:select-focused-row().
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on cursor-down of gcIndexFieldFilter in frame fQuery anywhere
do:

  apply 'entry' to brIndex in frame {&FRAME-NAME}.
  browse brIndex:select-focused-row().
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on cursor-down of btnClearIndexFieldFilter in frame fQuery anywhere
do:

  apply 'entry' to brIndex in frame {&FRAME-NAME}.
  browse brIndex:select-focused-row().
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&Scoped-define SELF-NAME fQuery
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on off-home of brRelation in frame fQuery anywhere
do:

  apply 'entry' to gcRelationFilter in frame {&FRAME-NAME}.
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on cursor-down of gcRelationFilter in frame fQuery anywhere
do:

  apply 'entry' to brRelation in frame {&FRAME-NAME}.
  browse brRelation:select-focused-row().
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on cursor-down of btnClearRelationFilter in frame fQuery anywhere
do:

  apply 'entry' to brRelation in frame {&FRAME-NAME}.
  browse brRelation:select-focused-row().
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on cursor-down of gcRelationFieldFilter in frame fQuery anywhere
do:

  apply 'entry' to brRelation in frame {&FRAME-NAME}.
  browse brRelation:select-focused-row().
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on cursor-down of btnClearRelationFieldFilter in frame fQuery anywhere
do:

  apply 'entry' to brRelation in frame {&FRAME-NAME}.
  browse brRelation:select-focused-row().
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
ON drop-file-notify OF FRAME fQuery
do:

  define variable i         as integer   no-undo.
  define variable cFileName as character no-undo.

  do i = 1 to frame fQuery:num-dropped-files:

    cFileName = frame fQuery:get-dropped-file(i).

    if cFileName matches '*.qsc':U then
      run qg_LoadQueryScenario(cFileName, (i = 1)).

  end.

  finally:

    frame fQuery:end-file-drop().

  end finally.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK
on SHIFT-ALT-Q anywhere
do:

  run qg_OpenExternalRecord in target-procedure.

  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on SHIFT-F10 of frame fQuery anywhere
do:

  run qg_SetQueryType({&K_QUERYTYPE_CANFIND}).
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on SHIFT-F11 of frame fQuery anywhere
do:

  run qg_SetSlimMode(yes).

  assign
    hQueryWindow:width-chars  = {&K_WINDOW_MIN_WIDTH_SLIM}
    hQueryWindow:height-chars = {&K_WINDOW_MIN_HEIGHT_SLIM}
    .

  apply 'window-resized':U to hQueryWindow.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on SHIFT-F12 of frame fQuery anywhere
do:

  apply 'choose':U to menu-item mi_RestoreDefaultWindowSize in menu m_Window.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on SHIFT-F3 of frame fQuery anywhere
do:

  apply 'entry':U to brDatabase in frame {&FRAME-NAME}.
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on SHIFT-F4 of frame fQuery anywhere
do:

  if    valid-handle(focus)
    and focus:name = 'gcTableFilter':U then
    apply 'entry':U to brTable in frame {&FRAME-NAME}.

  else  
    apply 'entry':U to gcTableFilter in frame {&FRAME-NAME}.

  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on SHIFT-F5 of frame fQuery anywhere
do:

  if    valid-handle(focus)
    and focus:name = 'gcFieldFilter':U then
    apply 'entry':U to brField in frame {&FRAME-NAME}.

  else
  do:
    run qg_SetDisplayMode({&K_DISPLAYMODE_FIELD}).
    apply 'entry':U to gcFieldFilter in frame {&FRAME-NAME}.
  end.

  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on SHIFT-F6 of frame fQuery anywhere
do:

  if    valid-handle(focus)
    and focus:name = 'gcIndexFilter':U then
    apply 'entry':U to brIndex in frame {&FRAME-NAME}.

  else
  do:
    run qg_SetDisplayMode({&K_DISPLAYMODE_INDEX}).
    apply 'entry':U to gcIndexFilter in frame {&FRAME-NAME}.
  end.

  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on SHIFT-F7 of frame fQuery anywhere
do:

  apply 'entry':U to gcBufferName in frame {&FRAME-NAME}.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on SHIFT-F8 of frame fQuery anywhere
do:

  run qg_SetQueryType({&K_QUERYTYPE_FINDFIRST}).
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL fQuery hQueryWindow
on SHIFT-F9 of frame fQuery anywhere
do:

  run qg_SetQueryType({&K_QUERYTYPE_FOREACH}).
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define BROWSE-NAME brDatabase
&Scoped-define SELF-NAME brDatabase
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brDatabase hQueryWindow
ON CTRL-C OF brDatabase IN FRAME fQuery
do:

  apply 'choose':U to menu-item mi_CopyDatabaseName in menu POPUP-MENU-brDatabase.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brDatabase hQueryWindow
ON value-changed OF brDatabase IN FRAME fQuery
do:

  run qg_RefreshTableBrowse.

  run qg_WidgetState('*':U).

  run qg_SetWorkingDatabase.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define BROWSE-NAME brField
&Scoped-define SELF-NAME brField
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brField hQueryWindow
ON CTRL-A OF brField IN FRAME fQuery
do:

  apply 'choose':U to menu-item mi_SelectAllFields in menu POPUP-MENU-brField.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brField hQueryWindow
ON CTRL-C OF brField IN FRAME fQuery
do:

  apply 'choose':U to menu-item mi_CopyFieldName in menu POPUP-MENU-brField.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brField hQueryWindow
ON default-action OF brField IN FRAME fQuery
do:

  define variable iKeyState  as integer   no-undo.
  define variable cFieldName as character no-undo.

  run GetKeyState({&K_WIN_CONST_VK_CTRL}, output iKeyState).

  if iKeyState >= 0 then
    apply 'choose':U to menu-item mi_FindFieldIndex in sub-menu m_SelectedFields.

  else
    if available ttField then
    do:

      run GetKeyState({&K_WIN_CONST_VK_SHIFT}, output iKeyState).

      assign
        gcBufferName    = (if glSlimMode then
                             substitute({&K_DEFAULT_BUFFER_PATTERN},
                                        qg_cGetBufferBaseName(no))
                           else
                             input frame {&FRAME-NAME} gcBufferName)
        cFieldName      = (if iKeyState < 0 then
                             substitute('&1.&2':U,
                                        gcBufferName,
                                        ttField.FieldName)
                           else
                             ttField.FieldName)
        .

      if glInsertMode then
        run qg_IDE_InsertText(qg_cTaggedValue(cFieldName, glInsertMode)).

      else
        clipboard:value = cFieldName.

    end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brField hQueryWindow
ON value-changed OF brField IN FRAME fQuery
do:

  run qg_FillQueryRange.
  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define BROWSE-NAME brIndex
&Scoped-define SELF-NAME brIndex
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brIndex hQueryWindow
ON CTRL-C OF brIndex IN FRAME fQuery
do:

  apply 'choose':U to menu-item mi_CopyIndexName in menu POPUP-MENU-brIndex.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brIndex hQueryWindow
ON default-action OF brIndex IN FRAME fQuery
do:

  apply 'choose':U to menu-item mi_ModifyIndexQueryFields in menu POPUP-MENU-brIndex.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brIndex hQueryWindow
ON value-changed OF brIndex IN FRAME fQuery
do:

  if giDisplayMode = {&K_DISPLAYMODE_INDEX} then
  do:

    if    available ttIndex
      and ttIndex.IsVirtual
      and not glUseVirtualIndexApi then

      assign
        giRelationId         = 0
        glParentRelation     = no
        gcRelationBufferName = gcVirtualIndexDataTableName
        .

    else

      assign
        giRelationId         = 0
        glParentRelation     = no
        gcRelationBufferName = '':U
        .

    run qg_FillQueryRange.
    run qg_WidgetState('*':U).
    run qg_UpdateQueryText.

  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define BROWSE-NAME brRelation
&Scoped-define SELF-NAME brRelation
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brRelation hQueryWindow
ON CTRL-C OF brRelation IN FRAME fQuery /* ? */
do:

  apply 'choose':U to menu-item mi_CopyRelationTable in menu POPUP-MENU-brRelation.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brRelation hQueryWindow
ON default-action OF brRelation IN FRAME fQuery /* ? */
do:

  apply 'choose':U to menu-item mi_SwitchToRelatedTable in menu POPUP-MENU-brRelation.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brRelation hQueryWindow
ON value-changed OF brRelation IN FRAME fQuery /* ? */
do:

  if giDisplayMode = {&K_DISPLAYMODE_RELATION} then
  do:

    if available ttTableRelationView then
      assign
        giRelationId         = ttTableRelationView.RelationId
        glParentRelation     = ttTableRelationView.ParentRelation
        gcRelationBufferName = ttTableRelationView.RelatedTableName
        .

    else
      assign
        giRelationId         = 0
        glParentRelation     = no
        gcRelationBufferName = '':U
        .

    run qg_FillQueryRange.
    run qg_UpdateQueryText.

  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define BROWSE-NAME brTable
&Scoped-define SELF-NAME brTable
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brTable hQueryWindow
ON CTRL-C OF brTable IN FRAME fQuery
do:

  apply 'choose':U to menu-item mi_CopyTableName in menu POPUP-MENU-brTable.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brTable hQueryWindow
ON default-action OF brTable IN FRAME fQuery
do:

  if available ttTable then
  do:

    gcTableFilter = ttTable.TableName.
    gcTableFilter:delete(gcTableFilter) in frame {&FRAME-NAME}.

    display unless-hidden
      gcTableFilter
      with frame {&FRAME-NAME}.

    apply 'value-changed':U to gcTableFilter in frame {&FRAME-NAME}.
    run qg_AddFieldHistoryEntry(gcTableFilter:handle in frame {&FRAME-NAME}).

  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brTable hQueryWindow
ON value-changed OF brTable IN FRAME fQuery
do:

  if    available ttTable
    and not ttTable.DetailsLoaded then
  do:

    run qg_AddTableDetails(ttDatabase.DatabaseName,
                           ttTable.TableName).

    display unless-hidden
      ttTable.ShortDescription
      with browse brTable.

  end.

  assign
    gcFieldDatatypeFilter   = '*':U
    giRelationId            = 0
    glParentRelation        = no
    gcRelationBuffername    = '':U
    glRefreshFieldBrowse    = yes
    glRefreshIndexBrowse    = yes
    glRefreshRelationBrowse = yes
    .

  run qg_RefreshFieldBrowse.
  run qg_RefreshIndexBrowse.
  run qg_RefreshRelationBrowse.

  run qg_UpdateBufferName.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnBlock1
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnBlock1 hQueryWindow
ON choose OF btnBlock1 IN FRAME fQuery /* 1 */
do:

  run qg_SetBlockPattern({&K_BLOCK_PATTERN_1}).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnBlock2
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnBlock2 hQueryWindow
ON choose OF btnBlock2 IN FRAME fQuery /* 2 */
do:

  run qg_SetBlockPattern({&K_BLOCK_PATTERN_2}).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnBlock3
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnBlock3 hQueryWindow
ON choose OF btnBlock3 IN FRAME fQuery /* 3 */
do:

  run qg_SetBlockPattern({&K_BLOCK_PATTERN_3}).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnBlock4
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnBlock4 hQueryWindow
ON choose OF btnBlock4 IN FRAME fQuery /* 4 */
do:

  run qg_SetBlockPattern({&K_BLOCK_PATTERN_4}).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnBuffer1
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnBuffer1 hQueryWindow
ON choose OF btnBuffer1 IN FRAME fQuery /* 1 */
do:

  run qg_SetBufferPattern({&K_BUFFER_PATTERN_1}, 0).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnBuffer2
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnBuffer2 hQueryWindow
ON choose OF btnBuffer2 IN FRAME fQuery /* 2 */
do:

  run qg_SetBufferPattern({&K_BUFFER_PATTERN_2}, 0).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnBuffer3
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnBuffer3 hQueryWindow
ON choose OF btnBuffer3 IN FRAME fQuery /* 3 */
do:

  run qg_SetBufferPattern({&K_BUFFER_PATTERN_3}, 0).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnBuffer4
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnBuffer4 hQueryWindow
ON choose OF btnBuffer4 IN FRAME fQuery /* 4 */
do:

  run qg_SetBufferPattern({&K_BUFFER_PATTERN_4}, 0).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnClearBlockName
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnClearBlockName hQueryWindow
ON choose OF btnClearBlockName IN FRAME fQuery
do:

  run qg_SetBlockPattern('':U).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnClearBufferPattern
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnClearBufferPattern hQueryWindow
ON choose OF btnClearBufferPattern IN FRAME fQuery
do:

  run qg_SetBufferPattern('':U, 0).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnClearFieldFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnClearFieldFilter hQueryWindow
ON choose OF btnClearFieldFilter IN FRAME fQuery
do:

  gcFieldFilter = '':U.

  display unless-hidden
    gcFieldFilter
    with frame {&FRAME-NAME}.

  apply 'value-changed':U to gcFieldFilter in frame {&FRAME-NAME}.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnClearFieldLabelFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnClearFieldLabelFilter hQueryWindow
ON choose OF btnClearFieldLabelFilter IN FRAME fQuery
do:

  gcFieldLabelFilter = '':U.

  display unless-hidden
    gcFieldLabelFilter
    with frame {&FRAME-NAME}.

  apply 'value-changed':U to gcFieldLabelFilter in frame {&FRAME-NAME}.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnClearIndexFieldFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnClearIndexFieldFilter hQueryWindow
ON choose OF btnClearIndexFieldFilter IN FRAME fQuery
do:

  gcIndexFieldFilter = '':U.

  display unless-hidden
    gcIndexFieldFilter
    with frame {&FRAME-NAME}.

  apply 'value-changed':U to gcIndexFieldFilter in frame {&FRAME-NAME}.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnClearIndexFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnClearIndexFilter hQueryWindow
ON choose OF btnClearIndexFilter IN FRAME fQuery
do:

  gcIndexFilter = '':U.

  display unless-hidden
    gcIndexFilter
    with frame {&FRAME-NAME}.

  apply 'value-changed':U to gcIndexFilter in frame {&FRAME-NAME}.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnClearRelationFieldFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnClearRelationFieldFilter hQueryWindow
ON choose OF btnClearRelationFieldFilter IN FRAME fQuery
do:

  gcRelationFieldFilter = '':U.

  display unless-hidden
    gcRelationFieldFilter
    with frame {&FRAME-NAME}.

  apply 'value-changed':U to gcRelationFieldFilter in frame {&FRAME-NAME}.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnClearRelationFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnClearRelationFilter hQueryWindow
ON choose OF btnClearRelationFilter IN FRAME fQuery
do:

  gcRelationFilter = '':U.

  display unless-hidden
    gcRelationFilter
    with frame {&FRAME-NAME}.

  apply 'value-changed':U to gcRelationFilter in frame {&FRAME-NAME}.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnClearTableFieldFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnClearTableFieldFilter hQueryWindow
ON choose OF btnClearTableFieldFilter IN FRAME fQuery
do:

  gcTableFieldFilter = '':U.

  display unless-hidden
    gcTableFieldFilter
    with frame {&FRAME-NAME}.

  apply 'value-changed':U to gcTableFieldFilter in frame {&FRAME-NAME}.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnClearTableFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnClearTableFilter hQueryWindow
ON choose OF btnClearTableFilter IN FRAME fQuery
do:

  gcTableFilter = '':U.

  display unless-hidden
    gcTableFilter
    with frame {&FRAME-NAME}.

  apply 'value-changed':U to gcTableFilter in frame {&FRAME-NAME}.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnConnectDB
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnConnectDB hQueryWindow
ON choose OF btnConnectDB IN FRAME fQuery /* Connect */
do:

define variable lPar01    as logical   no-undo.
define variable cPar02    as character no-undo. /* physical name */
define variable cPar03    as character no-undo. /* logical name */
define variable cPar04    as character no-undo. /* db type */
define variable lPar05    as logical   no-undo.
define variable cPar06    as character no-undo. 
define variable cPar07    as character no-undo. 
define variable cPar08    as character no-undo. 
define variable cPar09    as character no-undo. 
define variable cPar10    as character no-undo. 
define variable cPar11    as character no-undo. 
define variable cPar12    as character no-undo. 
define variable cPar13    as character no-undo. 
define variable cPar14    as character no-undo. 

define buffer bttDatabase for temp-table ttDatabase.

assign
  lPar01 = yes
  cPar04 = 'PROGRESS':U
  lPar05 = no.
  .

run adecomm/_dbconnx.p(lPar01,
                       input-output cPar02,
                       input-output cPar03,
                       input-output cPar04,
                       input-output lPar05,
                       input-output cPar06,
                       input-output cPar07,
                       input-output cPar08,
                       input-output cPar09,
                       input-output cPar10,
                       input-output cPar11,
                       input-output cPar12,
                       input-output cPar13,
                             output cPar14).

if    cPar02 <> ?
  and cPar03 <> ? then
do:

  run qg_AddDatabase(cPar03).
  {&OPEN-QUERY-brDatabase}

  find bttDatabase
    where bttDatabase.DatabaseName = cPar03
    no-error.

  reposition brDatabase to rowid rowid(bttDatabase).

  apply 'value-changed':U to brDatabase in frame {&FRAME-NAME}.

end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnCopyToClipboard
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnCopyToClipboard hQueryWindow
ON choose OF btnCopyToClipboard IN FRAME fQuery /* Copy */
do:

  if glInsertMode then
    run qg_InsertQueryText.

  else
    clipboard:value = gcQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnDecreaseIndentation
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnDecreaseIndentation hQueryWindow
ON choose OF btnDecreaseIndentation IN FRAME fQuery /* << */
do:

  giIndentation = max(0, giIndentation - 2).

  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnDisconnectDB
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnDisconnectDB hQueryWindow
ON choose OF btnDisconnectDB IN FRAME fQuery /* Disconnect */
do:

  define variable cDatabase as character no-undo.

  define variable lOk       as logical   no-undo.

  cDatabase = (if available ttDatabase then
                 ttDatabase.DatabaseName
               else
                 '':U).

  if connected(cDatabase) then
  do:

    message /* code checked by mth */
      substitute('Are you sure you want to disconnect database &1':T,
                 cDatabase) skip
      view-as alert-box
      question
      buttons ok-cancel
      update lOk.

    if not lOk then
      leave.

    disconnect value(cDatabase).

  end.

  run qg_RemoveDatabase(cDatabase).
  {&OPEN-QUERY-brDatabase}

  process events.

  run qg_CloseInvalidQueryWindows.

  apply 'value-changed':U to brDatabase in frame {&FRAME-NAME}.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnExecuteQuery
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnExecuteQuery hQueryWindow
ON choose OF btnExecuteQuery IN FRAME fQuery /* Execute */
do:

  define variable cDatabaseName  as character no-undo.
  define variable cTableName     as character no-undo.
  define variable cBufferName    as character no-undo.
  define variable cQueryText     as character no-undo.
  define variable cParamList     as character no-undo.

  define variable iQuerySeq      as integer   no-undo initial ?.

  if    available ttDatabase
    and available ttTable then
  do:

    assign
      cDatabaseName = ttDatabase.DatabaseName
      cTableName    = ttTable.TableName
      cBufferName   = (if glSlimMode then
                         substitute({&K_DEFAULT_BUFFER_PATTERN},
                                    qg_cGetBufferBaseName(no))
                       else
                         input frame {&FRAME-NAME} gcBufferName)
      cQueryText    = substitute('for each &1~n&2~n':U,
                                 cTableName,
                                 qg_cCreateWhereClause( /* pcDatabaseName   */ cDatabaseName,
                                                        /* pcTableNames     */ cTableName,
                                                        /* pcBufferNames    */ cTableName,
                                                        /* pcFieldList      */ qg_cCurrentFieldList(),
                                                        /* pcFieldLabelList */ ?,
                                                        /* plStartWithWhere */ yes,
                                                        /* piValueMode      */ {&K_VALUE_MODE_DEFAULT_VALUE},
                                                        /* pcValueList      */ ?,
                                                        /* piAccessMode     */ {&K_ACCESS_MODE_PHYSICAL},
                                                        /* plAddTags        */ no,
                                                        /* piIndentBlanks   */ 2 ) )
      cParamList    = qg_cParamListWriteLogical(cParamList,
                                                'FocusQueryText':U,
                                                yes,
                                                {&K_PARAM_SPLITTER})
      .

    run qg_ExecQuery({&K_QUERY_WINDOW_MODE_QUERY},
                     {&K_QUERY_SIZE_MODE_DEFAULT},
                     substitute('&1.&2:&3':U,
                                cDatabaseName,
                                cTableName,
                                cTableName),
                     cQueryText,
                     no,  /* Init mode */
                     cParamList,
                     input-output iQuerySeq).

  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnIncreaseIndentation
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnIncreaseIndentation hQueryWindow
ON choose OF btnIncreaseIndentation IN FRAME fQuery /* >> */
do:

  giIndentation = giIndentation + 2.

  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnOf
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnOf hQueryWindow
ON CHOOSE OF btnOf IN FRAME fQuery /* ... */
DO:

run qg_SelectRelation.

END.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnRefresh
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnRefresh hQueryWindow
ON choose OF btnRefresh IN FRAME fQuery /* Refresh */
do:

  run qg_LoadCache(?).
  run qg_CloseInvalidQueryWindows.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnResetAll
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnResetAll hQueryWindow
ON choose OF btnResetAll IN FRAME fQuery /* Reset */
do:

  run qg_SetDefaultValues.

  apply 'value-changed':U to brDatabase in frame {&FRAME-NAME}.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME btnResetIndentation
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL btnResetIndentation hQueryWindow
ON choose OF btnResetIndentation IN FRAME fQuery /* | */
do:

  giIndentation = {&K_DEFAULT_INDENTATION}.

  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME gcBlockName
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcBlockName hQueryWindow
ON end-error OF gcBlockName IN FRAME fQuery /* Block */
do:

  apply 'choose':U to btnClearBlockName in frame {&FRAME-NAME}.
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcBlockName hQueryWindow
ON value-changed OF gcBlockName IN FRAME fQuery /* Block */
do:

  run qg_ProcessBlockNameChange.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME gcBufferName
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcBufferName hQueryWindow
ON end-error OF gcBufferName IN FRAME fQuery /* Buffer */
do:

  apply 'choose':U to btnClearBufferPattern in frame {&FRAME-NAME}.
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcBufferName hQueryWindow
ON value-changed OF gcBufferName IN FRAME fQuery /* Buffer */
do:

  run qg_ProcessBufferNameChange.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME gcFieldFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcFieldFilter hQueryWindow
ON end-error OF gcFieldFilter IN FRAME fQuery /* Field filter */
do:

  apply 'choose':U to btnClearFieldFilter in frame {&FRAME-NAME}.
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcFieldFilter hQueryWindow
ON leave OF gcFieldFilter IN FRAME fQuery /* Field filter */
do:

  if available ttTable then
    run qg_FixCase(gcFieldFilter:handle in frame {&FRAME-NAME},
                   ttTable.DatabaseName,
                   ttTable.TableName,
                   {&K_CASEMODE_TABLE_FIELD}).

  if brField:query:num-results > 0 then
    run qg_AddFieldHistoryEntry(gcFieldFilter:handle in frame {&FRAME-NAME}).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcFieldFilter hQueryWindow
ON return OF gcFieldFilter IN FRAME fQuery /* Field filter */
do:

  if available ttField then
  do:

    gcFieldFilter = ttField.FieldName.

    display unless-hidden
      gcFieldFilter
      with frame {&FRAME-NAME}.

    apply 'value-changed':U to gcFieldFilter in frame {&FRAME-NAME}.
    run qg_AddFieldHistoryEntry(gcFieldFilter:handle in frame {&FRAME-NAME}).

  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcFieldFilter hQueryWindow
ON value-changed OF gcFieldFilter IN FRAME fQuery /* Field filter */
do:

  glRefreshFieldBrowse = yes.
  run qg_RefreshFieldBrowse.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME gcFieldLabelFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcFieldLabelFilter hQueryWindow
ON end-error OF gcFieldLabelFilter IN FRAME fQuery
do:

  apply 'choose':U to btnClearFieldLabelFilter in frame {&FRAME-NAME}.
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcFieldLabelFilter hQueryWindow
ON leave OF gcFieldLabelFilter IN FRAME fQuery
do:

  if available ttTable then
    run qg_FixCase(gcFieldLabelFilter:handle in frame {&FRAME-NAME},
                   ttTable.DatabaseName,
                   ttTable.TableName,
                   {&K_CASEMODE_TABLE_FIELD_LABEL}).

  if brField:query:num-results > 0 then
    run qg_AddFieldHistoryEntry(gcFieldLabelFilter:handle in frame {&FRAME-NAME}).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcFieldLabelFilter hQueryWindow
ON value-changed OF gcFieldLabelFilter IN FRAME fQuery
do:

  glRefreshFieldBrowse = yes.
  run qg_RefreshFieldBrowse.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME gcIndexFieldFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcIndexFieldFilter hQueryWindow
ON end-error OF gcIndexFieldFilter IN FRAME fQuery
do:

  apply 'choose':U to btnClearIndexFieldFilter in frame {&FRAME-NAME}.
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcIndexFieldFilter hQueryWindow
ON leave OF gcIndexFieldFilter IN FRAME fQuery
do:

  if available ttTable then
    run qg_FixCase(gcIndexFieldFilter:handle in frame {&FRAME-NAME},
                   ttTable.DatabaseName,
                   ttTable.TableName,
                   {&K_CASEMODE_TABLE_FIELD}).

  if brIndex:query:num-results > 0 then
    run qg_AddFieldHistoryEntry(gcIndexFieldFilter:handle in frame {&FRAME-NAME}).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcIndexFieldFilter hQueryWindow
ON value-changed OF gcIndexFieldFilter IN FRAME fQuery
do:

  glRefreshIndexBrowse = yes.
  run qg_RefreshIndexBrowse.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME gcIndexFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcIndexFilter hQueryWindow
ON end-error OF gcIndexFilter IN FRAME fQuery /* Index filter */
do:

  apply 'choose':U to btnClearIndexFilter in frame {&FRAME-NAME}.
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcIndexFilter hQueryWindow
ON leave OF gcIndexFilter IN FRAME fQuery /* Index filter */
do:

  if available ttTable then
    run qg_FixCase(gcIndexFilter:handle in frame {&FRAME-NAME},
                   ttTable.DatabaseName,
                   ttTable.TableName,
                   {&K_CASEMODE_TABLE_INDEX}).

  if brIndex:query:num-results > 0 then
    run qg_AddFieldHistoryEntry(gcIndexFilter:handle in frame {&FRAME-NAME}).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcIndexFilter hQueryWindow
ON return OF gcIndexFilter IN FRAME fQuery /* Index filter */
do:

  if available ttIndex then
  do:

    gcIndexFilter = ttIndex.IndexName.

    display unless-hidden
      gcIndexFilter
      with frame {&FRAME-NAME}.

    apply 'value-changed':U to gcIndexFilter in frame {&FRAME-NAME}.
    run qg_AddFieldHistoryEntry(gcIndexFilter:handle in frame {&FRAME-NAME}).

  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcIndexFilter hQueryWindow
ON value-changed OF gcIndexFilter IN FRAME fQuery /* Index filter */
do:

  glRefreshIndexBrowse = yes.
  run qg_RefreshIndexBrowse.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME gcRelationFieldFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcRelationFieldFilter hQueryWindow
ON end-error OF gcRelationFieldFilter IN FRAME fQuery
do:

  apply 'choose':U to btnClearRelationFieldFilter in frame {&FRAME-NAME}.
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcRelationFieldFilter hQueryWindow
ON leave OF gcRelationFieldFilter IN FRAME fQuery
do:

  if available ttTableRelationView then
    run qg_FixCase(gcRelationFieldFilter:handle in frame {&FRAME-NAME},
                   ttTableRelationView.DatabaseName,
                   ttTableRelationView.RelatedTableName,
                   {&K_CASEMODE_TABLE_FIELD}).

  if brRelation:query:num-results > 0 then
    run qg_AddFieldHistoryEntry(gcRelationFieldFilter:handle in frame {&FRAME-NAME}).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcRelationFieldFilter hQueryWindow
ON value-changed OF gcRelationFieldFilter IN FRAME fQuery
do:

  glRefreshRelationBrowse = yes.
  run qg_RefreshRelationBrowse.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME gcRelationFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcRelationFilter hQueryWindow
ON end-error OF gcRelationFilter IN FRAME fQuery /* Relation filter */
do:

  apply 'choose':U to btnClearRelationFilter in frame {&FRAME-NAME}.
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcRelationFilter hQueryWindow
ON leave OF gcRelationFilter IN FRAME fQuery /* Relation filter */
do:

  if available ttTable then
    run qg_FixCase(gcRelationFilter:handle in frame {&FRAME-NAME},
                   ttTable.DatabaseName,
                   ttTable.TableName,
                   {&K_CASEMODE_TABLE_RELATION}).

  if brRelation:query:num-results > 0 then
    run qg_AddFieldHistoryEntry(gcRelationFilter:handle in frame {&FRAME-NAME}).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcRelationFilter hQueryWindow
ON return OF gcRelationFilter IN FRAME fQuery /* Relation filter */
do:

  if available ttTableRelationView then
  do:

    gcRelationFilter = ttTableRelationView.RelatedTableName.

    display unless-hidden
      gcRelationFilter
      with frame {&FRAME-NAME}.

    apply 'value-changed':U to gcRelationFilter in frame {&FRAME-NAME}.
    run qg_AddFieldHistoryEntry(gcRelationFilter:handle in frame {&FRAME-NAME}).

  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcRelationFilter hQueryWindow
ON value-changed OF gcRelationFilter IN FRAME fQuery /* Relation filter */
do:

  glRefreshRelationBrowse = yes.
  run qg_RefreshRelationBrowse.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME gcTableFieldFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcTableFieldFilter hQueryWindow
ON end-error OF gcTableFieldFilter IN FRAME fQuery
do:

  apply 'choose':U to btnClearTableFieldFilter in frame {&FRAME-NAME}.
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcTableFieldFilter hQueryWindow
ON leave OF gcTableFieldFilter IN FRAME fQuery
do:

  if available ttDatabase then
    run qg_FixCase(gcTableFieldFilter:handle in frame {&FRAME-NAME},
                   ttDatabase.DatabaseName,
                   ?,
                   {&K_CASEMODE_FIELD}).

  if brTable:query:num-results > 0 then
    run qg_AddFieldHistoryEntry(gcTableFieldFilter:handle in frame {&FRAME-NAME}).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcTableFieldFilter hQueryWindow
ON value-changed OF gcTableFieldFilter IN FRAME fQuery
do:

  run qg_RefreshTableBrowse.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME gcTableFilter
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcTableFilter hQueryWindow
ON end-error OF gcTableFilter IN FRAME fQuery /* Table filter */
do:

  apply 'choose':U to btnClearTableFilter in frame {&FRAME-NAME}.
  return no-apply.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcTableFilter hQueryWindow
ON leave OF gcTableFilter IN FRAME fQuery /* Table filter */
do:

  if available ttDatabase then
    run qg_FixCase(gcTableFilter:handle in frame {&FRAME-NAME},
                   ttDatabase.DatabaseName,
                   ?,
                   {&K_CASEMODE_TABLE}).

  if brTable:query:num-results > 0 then
    run qg_AddFieldHistoryEntry(gcTableFilter:handle in frame {&FRAME-NAME}).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcTableFilter hQueryWindow
ON return OF gcTableFilter IN FRAME fQuery /* Table filter */
do:

  if available ttTable then
  do:

    gcTableFilter = ttTable.TableName.

    display unless-hidden
      gcTableFilter
      with frame {&FRAME-NAME}.

    apply 'value-changed':U to gcTableFilter in frame {&FRAME-NAME}.
    run qg_AddFieldHistoryEntry(gcTableFilter:handle in frame {&FRAME-NAME}).

  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brTable hQueryWindow
ON ROW-DISPLAY OF brTable IN FRAME fQuery /* Table filter */
do:

  if not ttTable.DescriptionLoaded

    /* For performance reasons we only do this when the database is connected */
    /* in shared memory mode.                                                 */

    and ( available ttDatabase
      and ( ttDatabase.SharedMemory
         or not ttDatabase.PhysicalDB ) ) then

    run qg_AddTableRepositoryInfo(ttTable.DatabaseName, ttTable.TableName).

  ttTable.ShortDescription:fgcolor in browse brTable = {&K_COLOR_LIGHT_GREY}.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brField hQueryWindow
ON ROW-DISPLAY OF brField IN FRAME fQuery /* Table filter */
do:

  define variable iColor as integer   no-undo initial ?.

  if available ttField then
  do:

    case ttField.FieldType:

      when {&K_FIELD_TYPE_VIRTUAL_DB_FIELD} then

        iColor = {&K_VIRTUAL_DB_FIELD_FGCOLOR}.

    end case.

    if iColor <> ? then

      assign
        ttField.FieldName:fgcolor in browse brField          = iColor
        ttField.IsVirtual:fgcolor in browse brField          = iColor
        ttField.DataType:fgcolor in browse brField           = iColor
        ttField.FieldExtent:fgcolor in browse brField        = iColor
        ttField.FieldDecimals:fgcolor in browse brField      = iColor
        ttField.FieldInitialValue :fgcolor in browse brField = iColor
        ttField.FieldFormat:fgcolor in browse brField        = iColor
        ttField.FieldLabel:fgcolor in browse brField         = iColor
        ttField.FieldColumnLabel:fgcolor in browse brField   = iColor
        ttField.IsMandatory:fgcolor in browse brField        = iColor
        ttField.Domain:fgcolor in browse brField             = iColor
        .

  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL brIndex hQueryWindow
ON ROW-DISPLAY OF brIndex IN FRAME fQuery /* Index */
do:

  define variable iColor as integer   no-undo initial ?.

  if    available ttIndex
    and ttIndex.IsVirtual then

    iColor = {&K_VIRTUAL_INDEX_FGCOLOR}.

  if iColor <> ? then

    assign
      ttIndex.IsPrimary:fgcolor in browse brIndex   = iColor
      ttIndex.IndexName:fgcolor in browse brIndex   = iColor
      ttIndex.IsUnique:fgcolor in browse brIndex    = iColor
      ttIndex.IsVirtual:fgcolor in browse brIndex   = iColor
      ttIndex.IndexFields:fgcolor in browse brIndex = iColor
      .

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL gcTableFilter hQueryWindow
ON value-changed OF gcTableFilter IN FRAME fQuery /* Table filter */
do:

  run qg_RefreshTableBrowse.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME giDisplayMode
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL giDisplayMode hQueryWindow
ON value-changed OF giDisplayMode IN FRAME fQuery
do:

  giDisplayMode = input frame {&FRAME-NAME} giDisplayMode.

  run qg_SetDisplayMode(giDisplayMode).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&Scoped-define SELF-NAME glInvertQuery
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL glInvertQuery hQueryWindow
ON value-changed OF glInvertQuery IN FRAME fQuery
do:

  glInvertQuery = input frame {&FRAME-NAME} glInvertQuery.

  run qg_FillQueryRange.
  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME glOnError
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL glOnError hQueryWindow
ON value-changed OF glOnError IN FRAME fQuery
do:

  run qg_WidgetState('*':U).
  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME giOnErrorPhrase
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL giOnErrorPhrase hQueryWindow
ON value-changed OF giOnErrorPhrase IN FRAME fQuery
do:

  run qg_WidgetState('*':U).
  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME giQueryTypeModifier
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL giQueryTypeModifier hQueryWindow
ON value-changed OF giQueryTypeModifier IN FRAME fQuery
do:

  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME giQueryType
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL giQueryType hQueryWindow
ON value-changed OF giQueryType IN FRAME fQuery
do:

  run qg_FillQueryRange.
  run qg_WidgetState('*':U).
  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME glCompanyViaClass
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL glCompanyViaClass hQueryWindow
ON value-changed OF glCompanyViaClass IN FRAME fQuery
do:

  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME glDefineBlock
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL glDefineBlock hQueryWindow
ON value-changed OF glDefineBlock IN FRAME fQuery /* define block */
do:

  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME glDefineBuffer
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL glDefineBuffer hQueryWindow
ON value-changed OF glDefineBuffer IN FRAME fQuery /* define buffer */
do:

  assign
    glDefineBuffer   = (if glSlimMode then
                          {&K_DEFAULT_DEFINE_BUFFER}
                        else
                          input frame {&FRAME-NAME} glDefineBuffer).
    gcBufferBaseName = qg_cGetBufferBaseName(   glDefineBuffer
                                             or (  gcBufferPattern > '':U
                                               and gcBufferPattern <> '&1':U)).

  run qg_UpdateBufferName.

  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME glDoBlock
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL glDoBlock hQueryWindow
ON value-changed OF glDoBlock IN FRAME fQuery /* do */
do:

  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME glExclusiveLock
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL glExclusiveLock hQueryWindow
ON value-changed OF glExclusiveLock IN FRAME fQuery
do:

  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME glFinallyBlock
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL glFinallyBlock hQueryWindow
ON value-changed OF glFinallyBlock IN FRAME fQuery /* finally block */
do:

  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME glIfStatement
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL glIfStatement hQueryWindow
ON value-changed OF glIfStatement IN FRAME fQuery /* if statement */
do:

  run qg_WidgetState('*':U).
  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME glNoError
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL glNoError hQueryWindow
ON value-changed OF glNoError IN FRAME fQuery /* no error */
do:

  run qg_WidgetState('*':U).
  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME glNot
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL glNot hQueryWindow
ON value-changed OF glNot IN FRAME fQuery /* not */
do:

  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&Scoped-define SELF-NAME glDefineVariables
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL glDefineVariables hQueryWindow
ON value-changed OF glDefineVariables IN FRAME fQuery /* define variables */
do:

  run qg_WidgetState('*':U).
  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME glUseVirtualIndexIncludes
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL glUseVirtualIndexIncludes hQueryWindow
ON value-changed OF glUseVirtualIndexIncludes IN FRAME fQuery /* via includes */
do:

  run qg_WidgetState('*':U).
  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME glRetryBlock
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL glRetryBlock hQueryWindow
ON value-changed OF glRetryBlock IN FRAME fQuery /* retry block */
do:

  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_About
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_About hQueryWindow
ON choose OF MENU-ITEM mi_About /* About Query Generator */
do:

  run qg_About(hQueryWindow).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_AddPersistentTempTable
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_AddPersistentTempTable hQueryWindow
ON choose OF MENU-ITEM mi_AddPersistentTempTable /* Add persistent temp table */
do:

  run qg_AddPersistentTempTable.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_AddSnapshot
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_AddSnapshot hQueryWindow
ON choose OF MENU-ITEM mi_AddSnapshot /* Add snpapshot */
do:

  define variable hBuffer as handle no-undo.

  if available ttTable then
  do on error undo, throw:

    if ttTable.PhysicalTable then
      create buffer hBuffer for table substitute('&1.&2':U,
                                                 ttTable.DatabaseName,
                                                 ttTable.TableName).

    else if valid-handle(ttTable.TableHandle) then
      create buffer hBuffer for table ttTable.TableHandle.

    if valid-handle(hBuffer) then
      run qg_AddTableSnapshot(hBuffer, '':U, {&WINDOW-NAME}).

    finally:

      if valid-handle(hBuffer) then
        delete object hBuffer.

    end finally.

  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_AddSnapshotBtn
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_AddSnapshotBtn hQueryWindow
ON choose OF MENU-ITEM mi_AddSnapshotBtn /* Add snapshot */
do:

  apply 'choose':U to menu-item mi_AddSnapshot in menu m_Tools.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CloseAllQueryWindows
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CloseAllQueryWindows hQueryWindow
ON choose OF MENU-ITEM mi_CloseAllQueryWindows /* Close all query windows */
do:

  define buffer bttQueryWindow for temp-table ttQueryWindow.

  for each bttQueryWindow
    on error undo, throw:

    if valid-handle(bttQueryWindow.WindowHandle) then
      run qg_QueryWindowClose(bttQueryWindow.WindowHandle, no).

    else
      delete bttQueryWindow.

  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyDatabaseName
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyDatabaseName hQueryWindow
ON choose OF MENU-ITEM mi_CopyDatabaseName /* Copy name */
do:

  if available ttDatabase then
    clipboard:value = ttDatabase.DatabaseName.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyFieldAssignments
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyFieldAssignments hQueryWindow
ON choose OF MENU-ITEM mi_CopyFieldAssignments /* Copy field assignments */
do:

  if glInsertMode then
    run qg_InsertFieldAssigments.

  else
    clipboard:value = qg_cFieldAssignments(no).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyFieldAssignStatement
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyFieldAssignStatement hQueryWindow
ON choose OF MENU-ITEM mi_CopyFieldAssignStatement /* Copy assign statement */
do:

  if glInsertMode then
    run qg_InsertFieldAssignStatement.

  else
    clipboard:value = qg_cFieldAssignStatement(no).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyFieldColumnLabel
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyFieldColumnLabel hQueryWindow
ON choose OF MENU-ITEM mi_CopyFieldColumnLabel /* Copy column label */
do:

  if available ttField then
    clipboard:value = ttField.FieldColumnLabel.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyFieldDomain
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyFieldDomain hQueryWindow
ON choose OF MENU-ITEM mi_CopyFieldDomain /* Copy Domain */
do:

  if available(ttField) then
    clipboard:value = ttField.Domain.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyFieldFormat
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyFieldFormat hQueryWindow
ON choose OF MENU-ITEM mi_CopyFieldFormat /* Copy format */
do:

  if available(ttField) then
    clipboard:value = ttField.FieldFormat.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyFieldInitialValue
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyFieldInitialValue hQueryWindow
ON choose OF MENU-ITEM mi_CopyFieldInitialValue /* Copy initial value */
do:
  if available ttField then
    clipboard:value = ttField.FieldInitialValue.
end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyFieldLabel
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyFieldLabel hQueryWindow
ON choose OF MENU-ITEM mi_CopyFieldLabel /* Copy label */
do:

  if available ttField then
    clipboard:value = ttField.FieldLabel.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyFieldName
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyFieldName hQueryWindow
ON choose OF MENU-ITEM mi_CopyFieldName /* Copy name */
do:

  if available(ttField) then
    clipboard:value = ttField.FieldName.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyFieldNamesCommaSeparated
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyFieldNamesCommaSeparated hQueryWindow
ON choose OF MENU-ITEM mi_CopyFieldNamesCommaSeparated /* Copy names (comma separated) */
do:

  define variable lOk as logical   no-undo.

  gcBufferName = (if glSlimMode then
                    substitute({&K_DEFAULT_BUFFER_PATTERN},
                               qg_cGetBufferBaseName(no))
                  else
                    input frame {&FRAME-NAME} gcBufferName).

  message /* code checked by mth */
    'Do you want to include the buffer name?':T skip
    view-as alert-box
      question
      buttons yes-no
      update lOk.

  clipboard:value = qg_cGetSelectedFields((if lOk then
                                             gcBufferName
                                           else
                                             ?),
                                          ',':U,
                                          no).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyFieldNamesLineSeparated
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyFieldNamesLineSeparated hQueryWindow
ON choose OF MENU-ITEM mi_CopyFieldNamesLineSeparated /* Copy names (line separated) */
do:

  define variable lOk as logical   no-undo.

  gcBufferName = (if glSlimMode then
                    substitute({&K_DEFAULT_BUFFER_PATTERN},
                               qg_cGetBufferBaseName(no))
                  else
                    input frame {&FRAME-NAME} gcBufferName).

  message /* code checked by mth */
    'Do you want to include the buffer name?':T skip
    view-as alert-box
      question
      buttons yes-no
      update lOk.

  clipboard:value = qg_cGetSelectedFields((if lOk then
                                             gcBufferName
                                           else
                                             ?),
                                          '~n':U,
                                          no).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyFieldNamesSpaceSeparated
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyFieldNamesSpaceSeparated hQueryWindow
ON choose OF MENU-ITEM mi_CopyFieldNamesSpaceSeparated /* Copy names (space separated) */
do:

  define variable lOk as logical   no-undo.

  gcBufferName = (if glSlimMode then
                    substitute({&K_DEFAULT_BUFFER_PATTERN},
                               qg_cGetBufferBaseName(no))
                  else
                    input frame {&FRAME-NAME} gcBufferName).

  message /* code checked by mth */
    'Do you want to include the buffer name?':T skip
    view-as alert-box
      question
      buttons yes-no
      update lOk.

  clipboard:value = qg_cGetSelectedFields((if lOk then
                                             gcBufferName
                                           else
                                             ?),
                                          ' ':U,
                                          no).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyFullFieldName
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyFullFieldName hQueryWindow
ON choose OF MENU-ITEM mi_CopyFullFieldName /* Copy name */
do:

  if available(ttField) then
    assign
      gcBufferName    = (if glSlimMode then
                           substitute({&K_DEFAULT_BUFFER_PATTERN},
                                      qg_cGetBufferBaseName(no))
                         else
                           input frame {&FRAME-NAME} gcBufferName)
      clipboard:value = substitute('&1.&2':U,
                                   gcBufferName,
                                   ttField.FieldName)
      .

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyIndexFields
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyIndexFields hQueryWindow
ON choose OF MENU-ITEM mi_CopyIndexFields /* Copy fields */
do:

  if available ttIndex then
    clipboard:value = ttIndex.IndexFields.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyRelationFields
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyRelationFields hQueryWindow
ON choose OF MENU-ITEM mi_CopyRelationFields /* Copy fields */
do:

  if available ttTableRelationView then
    clipboard:value = ttTableRelationView.RelatedFields.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyIndexName
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyIndexName hQueryWindow
ON choose OF MENU-ITEM mi_CopyIndexName /* Copy name */
do:

  if available ttIndex then
    clipboard:value = ttIndex.IndexName.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyRelationTable
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyRelationTable hQueryWindow
ON choose OF MENU-ITEM mi_CopyRelationTable /* Copy table */
do:

  if available ttTableRelationView then
    clipboard:value = ttTableRelationView.RelatedTableName.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyPhysicalName
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyPhysicalName hQueryWindow
ON choose OF MENU-ITEM mi_CopyPhysicalName /* Copy physical name */
do:

  if available ttDatabase then
    clipboard:value = ttDatabase.PhysicalName.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyPutStatement
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyPutStatement hQueryWindow
ON choose OF MENU-ITEM mi_CopyPutStatement /* Copy put statement */
do:

  if glInsertMode then
    run qg_InsertPutStatement.

  else
    clipboard:value = qg_cPutStatement(no).


end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyQueryGeneratorSource
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyQueryGeneratorSource hQueryWindow
ON choose OF MENU-ITEM mi_CopyQueryGeneratorSource /* Copy Query Generator Source */
do:

  run qg_CopyQueryGeneratorSource.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&Scoped-define SELF-NAME mi_CopyQueryGeneratorSourcefilePath
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyQueryGeneratorSource hQueryWindow
ON choose OF MENU-ITEM mi_CopyQueryGeneratorSourcefilePath /* Copy Query Generator Sourcefile Path */
do:

  run qg_CopyQueryGeneratorSourcefilePath.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&Scoped-define SELF-NAME mi_CopyQueryScenario
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyQueryScenario hQueryWindow
ON choose OF MENU-ITEM mi_CopyQueryScenario /* Copy query scenario */
do:

  run qg_SaveQueryScenario(?).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyQueryText
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyQueryText hQueryWindow
ON choose OF MENU-ITEM mi_CopyQueryText /* Copy query text */
do:

  clipboard:value = gcQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyTableCompanyInclude
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyTableCompanyInclude hQueryWindow
ON choose OF MENU-ITEM mi_CopyTableCompanyInclude /* Copy include name */
do:

  clipboard:value = (if    available ttTable
                       and ttTable.CompanyInclude > '':U then
                       ttTable.CompanyInclude
                     else
                       '':U).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyTableCompanyIncludeReference
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyTableCompanyIncludeReference hQueryWindow
ON choose OF MENU-ITEM mi_CopyTableCompanyIncludeReference /* Copy include reference */
do:

  define variable cIncludeReferenceText as character no-undo.

  if    available ttTable
    and ttTable.CompanyInclude > '':U then
    cIncludeReferenceText = substitute('~{firma/&1 &2~}&3':U,
                                       ttTable.CompanyInclude,
                                       qg_cTaggedValue((if glCompanyViaClass then
                                                          '{&K_CLASS_COMPANY_STATEMENT}':U
                                                        else
                                                          'pa-Firma':U),
                                                        glInsertMode),
                                           (if glInsertMode then
                                             '$~{cursor~}':U
                                            else
                                              '':U)).

  if glInsertMode then
    run qg_IDE_InsertText(cIncludeReferenceText).

  else
    clipboard:value = cIncludeReferenceText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyTableCreateTrigger
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyTableCreateTrigger hQueryWindow
ON choose OF MENU-ITEM mi_CopyTableCreateTrigger /* Copy trigger name */
do:

  if    available ttTable
    and ttTable.CreateTriggerProcName > '':U then
    clipboard:value = ttTable.CreateTriggerProcName.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyTableDefineBuffer
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyTableDefineBuffer hQueryWindow
ON choose OF MENU-ITEM mi_CopyTableDefineBuffer /* Copy "define buffer" */
do:

  if available ttTable then
  do:

    if glInsertMode then
      run qg_InsertBufferDefinition.

    else
      assign
        gcBufferName    = (if glSlimMode then
                             substitute({&K_DEFAULT_BUFFER_PATTERN},
                                        qg_cGetBufferBaseName(no))
                           else
                             input frame {&FRAME-NAME} gcBufferName)
        clipboard:value = substitute('define buffer &1 for &2.':U,
                                     gcBufferName,
                                     ttTable.TableName)
        .

  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyTableDeleteTrigger
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyTableDeleteTrigger hQueryWindow
ON choose OF MENU-ITEM mi_CopyTableDeleteTrigger /* Copy trigger name */
do:

  if    available ttTable
    and ttTable.DeleteTriggerProcName > '':U then
    clipboard:value = ttTable.DeleteTriggerProcName.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyTableFillInclude
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyTableFillInclude hQueryWindow
ON choose OF MENU-ITEM mi_CopyTableFillInclude /* Copy include name */
do:

  clipboard:value = (if    available ttTable
                       and ttTable.FillInclude > '':U then
                       ttTable.FillInclude
                     else
                       '':U).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyTableFillIncludeReference
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyTableFillIncludeReference hQueryWindow
ON choose OF MENU-ITEM mi_CopyTableFillIncludeReference /* Copy include reference */
do:

  define variable cFillInclude          as character no-undo.
  define variable cIncludeReferenceText as character no-undo.

  if    available ttTable
    and ttTable.FillInclude > '':U then
  do:

    cFillInclude = dynamic-function('pa_cDevelObjectRelativePath':U in target-procedure,
                                    ttTable.FillInclude) no-error.

    if cFillInclude > '':U then
      assign
        gcBufferName          = (if glSlimMode then
                                   substitute({&K_DEFAULT_BUFFER_PATTERN},
                                              qg_cGetBufferBaseName(no))
                                 else
                                   input frame {&FRAME-NAME} gcBufferName)
        cIncludeReferenceText = substitute('~{&1~n  &&Buffer = "&2"~n~}&3':U,
                                           cFillInclude,
                                           qg_cTaggedValue(gcBufferName, glInsertMode),
                                           (if glInsertMode then
                                             '$~{cursor~}':U
                                            else
                                              '':U))
        .

  end.

  if glInsertMode then
    run qg_IDE_InsertText(cIncludeReferenceText).

  else
    clipboard:value = cIncludeReferenceText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyTableKeyInclude
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyTableKeyInclude hQueryWindow
ON choose OF MENU-ITEM mi_CopyTableKeyInclude /* Copy include name */
do:

  clipboard:value = (if    available ttTable
                       and ttTable.KeyInclude > '':U then
                       ttTable.KeyInclude
                     else
                       '':U).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyTableKeyIncludeReference
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyTableKeyIncludeReference hQueryWindow
ON choose OF MENU-ITEM mi_CopyTableKeyIncludeReference /* Copy include reference */
do:

  define variable cKeyInclude           as character no-undo.
  define variable cIncludeReferenceText as character no-undo.


  if    available ttTable
    and ttTable.KeyInclude > '':U then
  do:

    cKeyInclude = dynamic-function('pa_cDevelObjectRelativePath':U in target-procedure,
                                   ttTable.KeyInclude) no-error.

    if cKeyInclude > '':U then
      assign
        gcBufferName          = (if glSlimMode then
                                   substitute({&K_DEFAULT_BUFFER_PATTERN},
                                              qg_cGetBufferBaseName(no))
                                 else
                                   input frame {&FRAME-NAME} gcBufferName)
        cIncludeReferenceText = substitute('~{&1 &&Tabelle = "&2"~}&3':U,
                                           cKeyInclude,
                                           qg_cTaggedValue(gcBufferName, glInsertMode),
                                           (if glInsertMode then
                                             '$~{cursor~}':U
                                            else
                                              '':U))
        .

  end.

  if glInsertMode then
    run qg_IDE_InsertText(cIncludeReferenceText).

  else
    clipboard:value = cIncludeReferenceText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyTableName
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyTableName hQueryWindow
ON choose OF MENU-ITEM mi_CopyTableName /* Copy name */
do:

  if available ttTable then
      clipboard:value = (if glSlimMode then
                           substitute({&K_DEFAULT_BUFFER_PATTERN},
                                      qg_cGetBufferBaseName(no))
                         else
                           input frame {&FRAME-NAME} gcBufferName).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_CopyTableWriteTrigger
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_CopyTableWriteTrigger hQueryWindow
ON choose OF MENU-ITEM mi_CopyTableWriteTrigger /* Copy trigger name */
do:

  if    available ttTable
    and ttTable.WriteTriggerProcName > '':U then
    clipboard:value = ttTable.WriteTriggerProcName.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_DataAdministration
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_DataAdministration hQueryWindow
ON choose OF MENU-ITEM mi_DataAdministration /* Data Administration */
do:

  run qg_SetWorkingDatabase.
  run _admin.p.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_DataDictionary
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_DataDictionary hQueryWindow
ON choose OF MENU-ITEM mi_DataDictionary /* Data Dictionary */
do:

  run qg_SetWorkingDatabase.
  run adedict/_dictg.p.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_ExecuteQuery
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_ExecuteQuery hQueryWindow
ON choose OF MENU-ITEM mi_ExecuteQuery /* Execute query */
do:

  define variable hFocusWidget as handle    no-undo.

  hFocusWidget = focus.

  if valid-handle(hFocusWidget) then
  do:

    /* Fire leave trigger but keep focus in active widget. */
    apply 'leave':U to hFocusWidget.
    apply 'entry':U to hFocusWidget.

  end.

  apply 'choose':U to btnExecuteQuery in frame {&FRAME-NAME}.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_Exit
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_Exit hQueryWindow
ON choose OF MENU-ITEM mi_Exit /* Exit */
do:

  apply 'window-close':U to hQueryWindow.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&Scoped-define SELF-NAME mi_ExportJSON
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_ExportJSON hQueryWindow
ON choose OF MENU-ITEM mi_ExportJSON /* Exit */
do:

  /* TODO: mi_ExportJSON */

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&Scoped-define SELF-NAME mi_ExportXML
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_ExportXML hQueryWindow
ON choose OF MENU-ITEM mi_ExportXML /* Exit */
do:

  /* TODO: mi_ExportXML */

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_FilterDataypes
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_FilterDataypes hQueryWindow
ON choose OF MENU-ITEM mi_FilterDataypes /* Dataype filter */
do:

  run qg_UpdateFieldDataypeFilter.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_FindFieldIndex
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_FindFieldIndex hQueryWindow
ON choose OF MENU-ITEM mi_FindFieldIndex /* Find index for selected fields */
do:

  if available ttField then
  do:

    gcIndexfieldFilter = qg_cGetSelectedFields(?, ',':U, yes).

    display unless-hidden
      gcIndexFieldFilter
      with frame {&FRAME-NAME}.

    run qg_SetDisplayMode({&K_DISPLAYMODE_INDEX}).

    apply 'value-changed':U to gcIndexFieldFilter in frame {&FRAME-NAME}.

  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_FindFieldTables
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_FindFieldTables hQueryWindow
ON choose OF MENU-ITEM mi_FindFieldTables /* Find tables containing selected fields */
do:

  if available ttField then
  do:

    gcTableFieldFilter = qg_cGetSelectedFields(?, ',':U, yes).

    display unless-hidden
      gcTableFieldFilter
      with frame {&FRAME-NAME}.

    apply 'value-changed':U to gcTableFieldFilter in frame {&FRAME-NAME}.

  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_FindObjectIdRecord
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_FindObjectIdRecord hQueryWindow
ON choose OF MENU-ITEM mi_FindObjectIdRecord /* Find object id record */
do:

  run qg_FindObjectIdRecord(hQueryWindow).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_AlwaysUseFindFirst
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_AlwaysUseFindFirst hQueryWindow
ON value-changed OF MENU-ITEM mi_AlwaysUseFindFirst /* Always use 'find first' */
do:

  glAlwaysUseFindFirst = menu-item mi_AlwaysUseFindFirst:checked in menu M_Options.

  run qg_FillQueryRange.
  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_AlwaysUseCanFindFirst
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_AlwaysUseCanFindFirst hQueryWindow
ON value-changed OF MENU-ITEM mi_AlwaysUseCanFindFirst /* Always use 'can-find first' */
do:

  glAlwaysUseCanFindFirst = menu-item mi_AlwaysUseCanFindFirst:checked in menu M_Options.

  run qg_FillQueryRange.
  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&Scoped-define SELF-NAME mi_AlwaysUseCanFindFirst
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_AlwaysUseCanFindFirst hQueryWindow
ON value-changed OF MENU-ITEM mi_UseVirtualIndexApi /* Use virtual index API' */
do:

  glUseVirtualIndexApi = menu-item mi_UseVirtualIndexApi:checked in menu M_Options.

  if    available ttIndex
    and ttIndex.IsVirtual
    and not glUseVirtualIndexApi then

    assign
      giRelationId         = 0
      glParentRelation     = no
      gcRelationBufferName = gcVirtualIndexDataTableName
      .

  run qg_WidgetState('*':U).
  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_InsertMode
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_InsertMode hQueryWindow
ON value-changed OF MENU-ITEM mi_InsertMode /* Insert mode */
do:

  glInsertMode = menu-item mi_InsertMode:checked in menu m_Options.
  run qg_WidgetState('*':U).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_InsertModeBtn
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_InsertModeBtn hQueryWindow
ON value-changed OF MENU-ITEM mi_InsertModeBtn /* Insert mode */
do:

  glInsertMode = menu-item mi_InsertModeBtn:checked in menu POPUP-MENU-btnCopyToClipboard.
  run qg_WidgetState('*':U).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_ShowQueryTypeModifier
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_ShowQueryTypeModifier hQueryWindow
ON value-changed OF MENU-ITEM mi_ShowQueryTypeModifier /* Show query type modifier */
do:

  run qg_SetShowQueryTypeModifier(menu-item mi_ShowQueryTypeModifier:checked in menu M_Options).

  run qg_FillQueryRange.
  run qg_UpdateQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_ShowChildRelations
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_ShowChildRelations hQueryWindow
ON value-changed OF MENU-ITEM mi_ShowChildRelations /* Show query type modifier */
do:

  assign
    glShowChildRelations    = menu-item mi_ShowChildRelations:checked in menu POPUP-MENU-brRelation
    glRefreshRelationBrowse = yes
    .
  run qg_RefreshRelationBrowse.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_ShowParentRelations
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_ShowParentRelations hQueryWindow
ON value-changed OF MENU-ITEM mi_ShowParentRelations /* Show query type modifier */
do:

  assign
    glShowParentRelations   = menu-item mi_ShowParentRelations:checked in menu POPUP-MENU-brRelation.
    glRefreshRelationBrowse = yes
    .
  run qg_RefreshRelationBrowse.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_ImportDatasetFile
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_ImportDatasetFile hQueryWindow
ON choose OF MENU-ITEM mi_ImportDatasetFile /* Import Dataset File */
do:

  run qg_ImportFile( {&K_IMPORT_TYPE_DATASET} ).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&Scoped-define SELF-NAME mi_ImportPDS
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_ImportPDS hQueryWindow
ON choose OF MENU-ITEM mi_ImportPDS /* Import PDS as Snapshot*/
do:

  run qg_ImportDefinitionFile( {&K_IMPORT_TYPE_DATASET} ).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&Scoped-define SELF-NAME mi_ImportTDF
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_ImportTDF hQueryWindow
ON choose OF MENU-ITEM mi_ImportTDF /* Import TDF as Snapshot*/
do:

  run qg_ImportDefinitionFile( {&K_IMPORT_TYPE_TEMP_TABLE} ).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&Scoped-define SELF-NAME mi_ImportTempTableFile
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_ImportTempTableFile hQueryWindow
ON choose OF MENU-ITEM mi_ImportTempTableFile /* Import Temp-Table File */
do:

  run qg_ImportFile( {&K_IMPORT_TYPE_TEMP_TABLE} ).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&Scoped-define SELF-NAME mi_InsertQueryText
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_InsertQueryText hQueryWindow
ON choose OF MENU-ITEM mi_InsertQueryText /* Insert query text */
do:

  run qg_InsertQueryText.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_ReconcileDatabaseSchema
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_ReconcileDatabaseSchema hQueryWindow
ON choose OF MENU-ITEM mi_ReconcileDatabaseSchema /* Incremental Dump & Reconcile of Database Schema */
do:

  run adm/entw/proc/detdum00.w ( '':U ).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_LoadDataDefinitions
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_LoadDataDefinitions hQueryWindow
ON choose OF MENU-ITEM mi_LoadAllTableDetails /* Load all table details */
do:

  if not available ttDatabase then

    return.

  run qg_LoadAllTableDetailsOfSingleDatabase( ttDatabase.DatabaseName ).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_LoadDataDefinitions
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_LoadDataDefinitions hQueryWindow
ON choose OF MENU-ITEM mi_LoadDataDefinitions /* Load data definitions (.df) */
do:

  run qg_LoadDataDefinitions(hQueryWindow).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_LoadQueryScenario
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_LoadQueryScenario hQueryWindow
ON choose OF MENU-ITEM mi_LoadQueryScenario /* Load query scenario */
do:

  define variable lOk as logical   no-undo.

  system-dialog get-file gcQRScenarioFileName
    title             gcTitlePrefix + 'Load query scenario ...':T
    filters           'Query scenario (*.qsc)':T '*.qsc':U
    default-extension '.qsc':U
    ask-overwrite
    use-filename
    update lOk
    in window hQueryWindow
    .

  if not lOk then
    return.

  run qg_LoadQueryScenario(gcQRScenarioFileName, ?).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_ModifyIndexQueryFields
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_ModifyIndexQueryFields hQueryWindow
ON choose OF MENU-ITEM mi_ModifyIndexQueryFields /* Modify query fields */
do:

  if available ttIndex then
  do:

    run qg_SetDisplayMode({&K_DISPLAYMODE_FIELD}).
    run qg_SelectFieldList(ttIndex.IndexFieldList).

    apply 'value-changed':U to brField in frame {&FRAME-NAME}.

  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_ModifyRelationQueryFields
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_ModifyRelationQueryFields hQueryWindow
ON choose OF MENU-ITEM mi_ModifyRelationQueryFields /* Modify query fields */
do:

  if available ttTableRelationView then
  do:

    run qg_SetDisplayMode({&K_DISPLAYMODE_FIELD}).
    run qg_SelectFieldList(ttTableRelationView.ReferenceFieldList).

    apply 'value-changed':U to brField in frame {&FRAME-NAME}.

  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_OpenTableCompanyInclude
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_OpenTableCompanyInclude hQueryWindow
ON choose OF MENU-ITEM mi_OpenTableCompanyInclude /* Open include file */
do:

  define variable cFilename    as character no-undo.

  if    available ttTable
    and ttTable.CompanyInclude > '':U then
  do:

    cFilename = search(substitute('firma/&1':U,
                                  ttTable.CompanyInclude)).

    if cFilename > '':U then
      run qg_OpenEditor(cFilename).

  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&Scoped-define SELF-NAME mi_OpenPluginWiki
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_OpenPluginWiki hQueryWindow
ON choose OF MENU-ITEM mi_OpenPluginWiki /* Open pA-Wiki for Query Generator Plugin */
do:

  define variable iResult as integer   no-undo.

  display unless-hidden
    'Connection to host pawiki ...':T
      @ gcStatusText60
    with frame fStatus
      no-labels
      overlay
      color messages
      centered
      view-as dialog-box
      width 65
      in window {&WINDOW-NAME}
      .
  process events.

  if qg_lIsHostReachable('pawiki':U, 'http':U) then
  do:

    hide frame fStatus.

    run ShellExecuteA(0,
                      'Open':U,
                      {&K_PLUGIN_WIKI_URL},
                      '':U,
                      '':U,
                      0,
                      output iResult).

  end.

  else
  do:

    hide frame fStatus.

    run ShellExecuteA(0,
                      'Open':U,
                      {&K_PLUGIN_CUSTOMER_WIKI_URL},
                      '':U,
                      '':U,
                      0,
                      output iResult).

  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&Scoped-define SELF-NAME mi_OpenQGWiki
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_OpenQGWiki hQueryWindow
ON choose OF MENU-ITEM mi_OpenQGWiki /* Open pA-Wiki for Query Generator */
do:

  define variable iResult as integer   no-undo.

  display unless-hidden
    'Connection to host pawiki ...':T
      @ gcStatusText60
    with frame fStatus
      no-labels
      overlay
      color messages
      centered
      view-as dialog-box
      width 65
      in window {&WINDOW-NAME}
      .
  process events.

  if qg_lIsHostReachable('pawiki':U, 'http':U) then
  do:

    hide frame fStatus.

    run ShellExecuteA(0,
                      'Open':U,
                      {&K_QG_WIKI_URL},
                      '':U,
                      '':U,
                      0,
                      output iResult).

  end.

  else
  do:

    hide frame fStatus.

    run ShellExecuteA(0,
                      'Open':U,
                      {&K_QG_CUSTOMER_WIKI_URL},
                      '':U,
                      '':U,
                      0,
                      output iResult).

  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&Scoped-define SELF-NAME mi_OpenQueryWindowListWindow
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_OpenQueryWindowListWindow hQueryWindow
ON choose OF MENU-ITEM mi_OpenQueryWindowListWindow /* Query window */
do:

  run qg_OpenQueryWindowListWindow.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_OpenTableCreateTrigger
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_OpenTableCreateTrigger hQueryWindow
ON choose OF MENU-ITEM mi_OpenTableCreateTrigger /* Open trigger procedure */
do:

  define variable cFilename as character no-undo.

  if    available ttTable
    and ttTable.CreateTrigger > '':U then
  do:

    cFilename = search(ttTable.CreateTrigger).

    if cFilename > '':U then
      run qg_OpenEditor(cFilename).

  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_OpenTableDeleteTrigger
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_OpenTableDeleteTrigger hQueryWindow
ON choose OF MENU-ITEM mi_OpenTableDeleteTrigger /* Open trigger procedure */
do:

  define variable cFilename as character no-undo.

  if    available ttTable
    and ttTable.DeleteTrigger > '':U then
  do:

    cFilename = search(ttTable.DeleteTrigger).

    if cFilename > '':U then
      run qg_OpenEditor(cFilename).

  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_OpenTableFillInclude
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_OpenTableFillInclude hQueryWindow
ON choose OF MENU-ITEM mi_OpenTableFillInclude /* Open include file */
do:

  define variable cIncludeName as character no-undo.
  define variable cFilename    as character no-undo.

  if    available ttTable
    and ttTable.CompanyInclude > '':U then
  do:

    cIncludeName = dynamic-function('pa_cDevelObjectRelativePath':U in target-procedure,
                                    ttTable.FillInclude) no-error.

    cFilename = search(cIncludeName).

    if cFilename > '':U then
      run qg_OpenEditor(cFilename).

  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_OpenTableKeyInclude
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_OpenTableKeyInclude hQueryWindow
ON choose OF MENU-ITEM mi_OpenTableKeyInclude /* Open include file */
do:

  define variable cIncludeName as character no-undo.
  define variable cFilename    as character no-undo.

  if    available ttTable
    and ttTable.KeyInclude > '':U then
  do:

    cIncludeName = dynamic-function('pa_cDevelObjectRelativePath':U in target-procedure,
                                    ttTable.KeyInclude) no-error.

    cFilename = search(cIncludeName).

    if cFilename > '':U then
      run qg_OpenEditor(cFilename).

  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_OpenTableWriteTrigger
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_OpenTableWriteTrigger hQueryWindow
ON choose OF MENU-ITEM mi_OpenTableWriteTrigger /* Open trigger procedure */
do:

  define variable cFilename as character no-undo.

  if    available ttTable
    and ttTable.WriteTrigger > '':U then
  do:

    cFilename = search(ttTable.WriteTrigger).

    if cFilename > '':U then
      run qg_OpenEditor(cFilename).

  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_PasteQueryScenario
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_PasteQueryScenario hQueryWindow
ON choose OF MENU-ITEM mi_PasteQueryScenario /* Paste query scenario */
do:

  run qg_LoadQueryScenario(?, ?).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_RemoveTable
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_RemoveTable hQueryWindow
ON choose OF MENU-ITEM mi_RemoveTable /* Remove table */
do:

  if    available ttDatabase
    and available ttTable
    and not ttTable.PhysicalTable then
  do:

    run qg_RemoveTable(ttTable.DatabaseName, ttTable.TableName).

    if can-find(first ttTable
                  where ttTable.DatabaseName = ttDatabase.DatabaseName) then
    do:

      {&OPEN-QUERY-brTable}

      process events.

      apply 'value-changed':U to brTable in frame {&FRAME-NAME}.

    end.

    else
    do:

      run qg_RemoveDatabase(ttDatabase.DatabaseName).
      {&OPEN-QUERY-brDatabase}

      process events.

      apply 'value-changed':U to brDatabase in frame {&FRAME-NAME}.

    end.

  end.

  run qg_CloseInvalidQueryWindows.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_RepositoryLanguage
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_RepositoryLanguage hQueryWindow
ON choose OF MENU-ITEM mi_RepositoryLanguage /* Repository Langauge */
do:

  run qg_SelectRepositoryLanguage.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_ResetAll
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_ResetAll hQueryWindow
ON choose OF MENU-ITEM mi_ResetAll /* Reset */
do:

  apply 'choose':U to btnResetAll in frame {&FRAME-NAME}.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_RestoreDefaultWindowSize
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_RestoreDefaultWindowSize hQueryWindow
ON choose OF MENU-ITEM mi_RestoreDefaultWindowSize /* Restore default window size */
do:

  assign
    hQueryWindow:window-state = {&K_WINDOW_NORMAL}
    hQueryWindow:width-chars  = gdOriginalWidth
    hQueryWindow:height-chars = gdOriginalHeight
    .

  apply 'window-resized':U to hQueryWindow.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_SaveQueryScenario
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_SaveQueryScenario hQueryWindow
ON choose OF MENU-ITEM mi_SaveQueryScenario /* Save query scenario */
do:

  define variable lOk as logical   no-undo.

  system-dialog get-file gcQRScenarioFileName
    title             gcTitlePrefix + 'Save query scenario as ...':U
    filters           'Query scenario (*.qsc)':U '*.qsc':U
    default-extension '.qsc':U
    ask-overwrite
    save-as
    use-filename
    update lOk
    in window hQueryWindow
    .

  if not lOk then
    return.

  run qg_SaveQueryScenario(gcQRScenarioFileName).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_SelectAllFields
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_SelectAllFields hQueryWindow
ON choose OF MENU-ITEM mi_SelectAllFields /* Selected all */
do:

  if query brField:num-results > 0 then
  do:

    browse brField:select-all().
    browse brField:scroll-to-selected-row(1).

    apply 'value-changed':U to browse brField.

  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_SessionTriggerAddFieldsAssign
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_SessionTriggerAddFieldsAssign hQueryWindow
ON CHOOSE OF MENU-ITEM mi_SessionTriggerAddFieldsAssign /* Add session triggers (assign) */
DO:

  define variable i               as integer   no-undo.
  define variable cSelectedFields as character no-undo.

  define buffer bttField for temp-table ttField.

  if available ttField then
  do:

    cSelectedFields = qg_cGetSelectedFields(?,
                                            ',':U,
                                            no).

    do i = 1 to num-entries(cSelectedFields):

      find bttField
        where bttField.DatabaseName = ttField.DatabaseName
          and bttField.TableName    = ttField.TableName
          and bttField.FieldName    = entry(i, cSelectedFields)
        no-error.

      if    available bttField
        and bttField.FieldExtent = 0 then
        run qg_AddSessionTrigger('assign':U,
                                 bttField.DatabaseName,
                                 bttField.TableName,
                                 bttField.FieldName,
                                 yes).

    end.

  end.

END.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_SessionTriggerCreate
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_SessionTriggerCreate hQueryWindow
ON CHOOSE OF MENU-ITEM mi_SessionTriggerCreate /* Add session trigger (create) */
DO:

  if available ttTable then
  do:

    if can-find(first ttSessionTrigger
                  where ttSessionTrigger.TriggerEvent = 'create':U
                    and ttSessionTrigger.DatabaseName = ttTable.DatabaseName
                    and ttSessionTrigger.TableName    = ttTable.TableName
                    and ttSessionTrigger.FieldName    = '':U) then
      run qg_RemoveSessionTrigger('create':U,
                                  ttTable.DatabaseName,
                                  ttTable.TableName,
                                  '':U).

    else
      run qg_AddSessionTrigger('create':U,
                               ttTable.DatabaseName,
                               ttTable.TableName,
                               '':U,
                               yes).

  end.

END.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_SessionTriggerDelete
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_SessionTriggerDelete hQueryWindow
ON CHOOSE OF MENU-ITEM mi_SessionTriggerDelete /* Add session trigger (delete) */
DO:

  if available ttTable then
  do:

    if can-find(first ttSessionTrigger
                  where ttSessionTrigger.TriggerEvent = 'delete':U
                    and ttSessionTrigger.DatabaseName = ttTable.DatabaseName
                    and ttSessionTrigger.TableName    = ttTable.TableName
                    and ttSessionTrigger.FieldName    = '':U) then
      run qg_RemoveSessionTrigger('delete':U,
                                  ttTable.DatabaseName,
                                  ttTable.TableName,
                                  '':U).

    else
      run qg_AddSessionTrigger('delete':U,
                               ttTable.DatabaseName,
                               ttTable.TableName,
                               '':U,
                               yes).

  end.

END.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_SessionTriggerFieldAssign
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_SessionTriggerFieldAssign hQueryWindow
ON CHOOSE OF MENU-ITEM mi_SessionTriggerFieldAssign /* Add session trigger (assign) */
DO:

  if    available ttField
    and ttField.FieldExtent = 0 then
  do:

    if can-find(first ttSessionTrigger
                  where ttSessionTrigger.TriggerEvent = 'assign':U
                    and ttSessionTrigger.DatabaseName = ttField.DatabaseName
                    and ttSessionTrigger.TableName    = ttField.TableName
                    and ttSessionTrigger.FieldName    = ttField.FieldName) then
      run qg_RemoveSessionTrigger('assign':U,
                                  ttField.DatabaseName,
                                  ttField.TableName,
                                  ttField.FieldName).

    else
      run qg_AddSessionTrigger('assign':U,
                               ttField.DatabaseName,
                               ttField.TableName,
                               ttField.FieldName,
                               yes).

  end.

END.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&Scoped-define SELF-NAME mi_SessionTriggerFind
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_SessionTriggerFind hQueryWindow
ON CHOOSE OF MENU-ITEM mi_SessionTriggerFind /* Add session trigger (find) */
DO:

  if available ttTable then
  do:

    if can-find(first ttSessionTrigger
                  where ttSessionTrigger.TriggerEvent = 'find':U
                    and ttSessionTrigger.DatabaseName = ttTable.DatabaseName
                    and ttSessionTrigger.TableName    = ttTable.TableName
                    and ttSessionTrigger.FieldName    = '':U) then

      run qg_RemoveSessionTrigger( 'find':U,
                                   ttTable.DatabaseName,
                                   ttTable.TableName,
                                   '':U ).

    else

      run qg_AddSessionTrigger( 'find':U,
                                ttTable.DatabaseName,
                                ttTable.TableName,
                                '':U,
                                yes ).

  end.

END.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_SessionTriggerRemoveFieldsAssign
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_SessionTriggerRemoveFieldsAssign hQueryWindow
ON CHOOSE OF MENU-ITEM mi_SessionTriggerRemoveFieldsAssign /* Remove session triggers (assign) */
DO:

  define variable i               as integer   no-undo.
  define variable cSelectedFields as character no-undo.

  if available ttField then
  do:

    cSelectedFields = qg_cGetSelectedFields(?,
                                            ',':U,
                                            no).

    do i = 1 to num-entries(cSelectedFields):

      run qg_RemoveSessionTrigger('assign':U,
                                  ttField.DatabaseName,
                                  ttField.TableName,
                                  entry(i, cSelectedFields)).

    end.

  end.

END.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_SessionTriggers
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_SessionTriggers hQueryWindow
ON choose OF MENU-ITEM mi_SessionTriggers /* Session triggers */
do:

  run qg_OpenSessionTriggerWindow.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_SessionTriggerWrite
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_SessionTriggerWrite hQueryWindow
ON CHOOSE OF MENU-ITEM mi_SessionTriggerWrite /* Add session trigger (write) */
DO:

  if available ttTable then
  do:

    if can-find(first ttSessionTrigger
                  where ttSessionTrigger.TriggerEvent = 'write':U
                    and ttSessionTrigger.DatabaseName = ttTable.DatabaseName
                    and ttSessionTrigger.TableName    = ttTable.TableName
                    and ttSessionTrigger.FieldName    = '':U) then
      run qg_RemoveSessionTrigger('write':U,
                                  ttTable.DatabaseName,
                                  ttTable.TableName,
                                  '':U).

    else
      run qg_AddSessionTrigger('write':U,
                               ttTable.DatabaseName,
                               ttTable.TableName,
                               '':U,
                               yes).

  end.

END.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_ShowHiddenTables
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_ShowHiddenTables hQueryWindow
ON value-changed OF MENU-ITEM mi_ShowHiddenTables /* Show hidden tables */
do:

  glShowHiddenTables = menu-item mi_ShowHiddenTables:checked in menu POPUP-MENU-brTable.

  run qg_RefreshTableBrowse.
  run qg_WidgetState('*':U).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&Scoped-define SELF-NAME mi_SwitchToRelatedTable
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_SwitchToRelatedTable hQueryWindow
ON choose OF MENU-ITEM mi_SwitchToRelatedTable /* Swtich to related table */
do:

  define variable iRelationId   as integer   no-undo.
  define variable cDatabaseName as character no-undo.
  define variable cTableName    as character no-undo.

  define buffer bttTableRelationView for temp-table ttTableRelationView.

  if available ttTableRelationView then
  do:

    assign
      iRelationId           = ttTableRelationView.RelationId
      cDatabaseName         = ttTableRelationView.DatabaseName
      cTableName            = ttTableRelationView.ReferenceTableName
      gcRelationFilter      = '':U
      gcRelationFieldFilter = '':U
      .

    display unless-hidden
      gcRelationFilter
      gcRelationFieldFilter
      with frame {&FRAME-NAME}.

    run qg_SelectTable(ttTableRelationView.RelatedTableName, no).

    find first bttTableRelationView
      where bttTableRelationView.RelationId         = iRelationId
        and bttTableRelationView.DatabaseName       = cDatabaseName
        and bttTableRelationView.RelatedTableName   = cTableName
        and bttTableRelationView.TableFilterMatches = yes
        and bttTableRelationView.FieldFilterMatches = yes
      no-error.

    if available bttTableRelationView then
    do:

      reposition brRelation to rowid rowid(bttTableRelationView) no-error.

      apply 'value-changed':U to brRelation in frame {&FRAME-NAME}.

    end.

    apply 'entry':U to brRelation in frame {&FRAME-NAME}.

  end.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME mi_SlimMode
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_SlimMode hQueryWindow
ON value-changed OF MENU-ITEM mi_SlimMode /* Slim mode */
do:

  run qg_SetSlimMode(not glSlimMode).

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&Scoped-define SELF-NAME mi_VirtualFields
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_VirtualFields hQueryWindow
ON value-changed OF MENU-ITEM mi_VirtualFields /* Show Virtual Fields */
do:

  assign
    glShowVirtualFields  = menu-item mi_VirtualFields:checked in menu POPUP-MENU-brField
    glRefreshFieldBrowse = yes
    .

  run qg_RefreshFieldBrowse.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&Scoped-define SELF-NAME mi_VirtualIndices
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL mi_VirtualIndices hQueryWindow
ON value-changed OF MENU-ITEM mi_VirtualIndices /* Show Virtual Indices */
do:

  assign
    glShowVirtualIndices  = menu-item mi_VirtualIndices:checked in menu POPUP-MENU-brIndex
    glRefreshIndexBrowse = yes
    .

  run qg_RefreshIndexBrowse.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME m_Edit
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL m_Edit hQueryWindow
ON menu-drop OF MENU m_Edit /* Edit */
do:

  define variable lQueryWindows as logical   no-undo.

  assign
    lQueryWindows = can-find(first ttQueryWindow)
    menu-item mi_InsertQueryText:sensitive in menu m_Edit /* code checked by mth */
        =     OEIDEIsRunning
          and glIDECanInsert
    menu-item mi_CopyQueryScenario:sensitive in menu m_Edit /* code checked by mth */
        = lQueryWindows
    menu-item mi_PasteQueryScenario:sensitive in menu m_Edit /* code checked by mth */
        = lookup('PRO_TEXT':U, clipboard:available-formats) > 0
    .

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME m_File
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL m_File hQueryWindow
ON menu-drop OF MENU m_File /* File */
do:

  define variable lQueryWindows as logical   no-undo.

  assign
    lQueryWindows = can-find(first ttQueryWindow)
    menu-item mi_SaveQueryScenario:sensitive in menu m_File /* code checked by mth */
        = lQueryWindows
    .

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME m_Options
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL m_Options hQueryWindow
ON menu-drop OF MENU m_Options /* Options */
do:

  assign
    menu-item mi_InsertMode:checked in menu m_Options
        = glInsertMode
    menu-item mi_InsertMode:sensitive in menu m_Options /* code checked by mth */
        =     OEIDEIsRunning
          and glIDECanInsert
    .

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME m_Tools
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL m_Tools hQueryWindow
ON menu-drop OF MENU m_Tools /* Tools */
do:

  assign
    menu-item mi_AddSnapshot:sensitive in menu m_Tools /* code checked by mth 20.01.2015 */
      =     available(ttTable)
        and not ttTable.Snapshot
    menu-item mi_AddPersistentTempTable:sensitive in menu m_Tools /* code checked by mth 20.01.2015 */
      = (proversion >= '11.2':U)
    .

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME m_Window
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL m_Window hQueryWindow
ON menu-drop OF MENU m_Window /* Window */
do:

  define variable lQueryWindow  as logical   no-undo.

  assign
    lQueryWindow  = can-find(first ttQueryWindow)
    menu-item mi_CloseAllQueryWindows:sensitive in menu m_Window /* code checked by mth */
        = lQueryWindow
    menu-item mi_SlimMode:checked in menu m_Window
        = glSlimMode
    .

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME POPUP-MENU-brDatabase
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL POPUP-MENU-brDatabase hQueryWindow
ON menu-drop OF MENU POPUP-MENU-brDatabase
do:

  run qg_UpdateDatabasePopupMenu.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME POPUP-MENU-brField
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL POPUP-MENU-brField hQueryWindow
ON menu-drop OF MENU POPUP-MENU-brField
do:

  run qg_UpdateFieldPopupMenu.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME POPUP-MENU-brIndex
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL POPUP-MENU-brIndex hQueryWindow
ON menu-drop OF MENU POPUP-MENU-brIndex
do:

  run qg_UpdateIndexPopupMenu.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME POPUP-MENU-brRelation
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL POPUP-MENU-brRelation hQueryWindow
ON menu-drop OF MENU POPUP-MENU-brRelation
do:

  run qg_UpdateRelationPopupMenu.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME POPUP-MENU-brTable
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL POPUP-MENU-brTable hQueryWindow
ON menu-drop OF MENU POPUP-MENU-brTable
do:

  run qg_UpdateTablePopupMenu.

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define SELF-NAME POPUP-MENU-btnCopyToClipboard
&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CONTROL POPUP-MENU-btnCopyToClipboard hQueryWindow
ON menu-drop OF MENU POPUP-MENU-btnCopyToClipboard
do:

  assign
    menu-item mi_InsertModeBtn:checked in menu POPUP-MENU-btnCopyToClipboard
        = glInsertMode
    menu-item mi_InsertModeBtn:sensitive in menu POPUP-MENU-btnCopyToClipboard /* code checked by mth */
        =     OEIDEIsRunning
          and glIDECanInsert
    .

end.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


&Scoped-define BROWSE-NAME brDatabase
&UNDEFINE SELF-NAME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CUSTOM _MAIN-BLOCK hQueryWindow 


/* ***************************  Main Block  *************************** */

// Set CURRENT-WINDOW: this will parent dialog-boxes and frames.
assign CURRENT-WINDOW                = {&WINDOW-NAME} 
       THIS-PROCEDURE:CURRENT-WINDOW = {&WINDOW-NAME}.

// The CLOSE event can be used from inside or outside the procedure to
// terminate it.

on close of this-procedure
do:

  apply 'window-close':U to hQueryWindow.

  run disable_UI.

end.

// Best default for GUI applications is...
pause 0 before-hide.

MAIN-BLOCK:
do on error   undo MAIN-BLOCK, leave MAIN-BLOCK
   on endkey undo MAIN-BLOCK, retry MAIN-BLOCK
   on stop   undo MAIN-BLOCK, leave MAIN-BLOCK
   on quit   undo MAIN-BLOCK, leave MAIN-BLOCK:

  if not retry then
  do:

    run enable_UI.

    run qg_Initialize.

  end.

  if not this-procedure:persistent then
    wait-for close of this-procedure.

end.

// If this procedure was used as the startup procedure for this session then
// source-procedure is not set. In this case we can quit the session to avoid
// to be dropped to the procedure editor window.

if not valid-handle(source-procedure) then
  quit.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME


/* **********************  Internal Procedures  *********************** */

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE disable_UI hQueryWindow  _DEFAULT-DISABLE
PROCEDURE disable_UI :

  // Delete the WINDOW we created
  IF SESSION:DISPLAY-TYPE = "GUI":U AND VALID-HANDLE(hQueryWindow)
  THEN DELETE WIDGET hQueryWindow.
  IF THIS-PROCEDURE:PERSISTENT THEN DELETE PROCEDURE THIS-PROCEDURE.
end procedure.
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE enable_UI hQueryWindow  _DEFAULT-ENABLE
PROCEDURE enable_UI :

  DISPLAY gdIndexUsage gcFieldLabelFilter gcFieldDummy gcTableFilter 
          gcTableFieldFilter giDisplayMode glInvertQuery gcFieldFilter gcIndexFilter 
          gcIndexFieldFilter gcBufferName glDefineBuffer glCompanyViaClass 
          glExclusiveLock glNoError glIfStatement glNot glDoBlock 
          glOnError giOnErrorPhrase giQueryTypeModifier gcBlockName glDefineBlock glRetryBlock 
          glFinallyBlock giQueryType gcQueryText gcRelationFilter 
          gcRelationFieldFilter glDefineVariables glUseVirtualIndexIncludes
      WITH FRAME fQuery IN WINDOW hQueryWindow.
  ENABLE gdIndexUsage btnClearFieldLabelFilter gcFieldLabelFilter gcFieldDummy 
         brDatabase btnConnectDB btnDisconnectDB btnRefresh gcTableFilter 
         btnClearTableFilter gcTableFieldFilter btnClearTableFieldFilter 
         brTable giDisplayMode glInvertQuery gcFieldFilter btnClearFieldFilter brField 
         gcIndexFilter btnClearIndexFilter gcIndexFieldFilter 
         btnClearIndexFieldFilter brIndex gcBufferName btnClearBufferPattern 
         btnBuffer1 btnBuffer2 btnBuffer3 btnBuffer4 glDefineBuffer 
         glCompanyViaClass glExclusiveLock glNoError glIfStatement glNot 
         glDoBlock glOnError giOnErrorPhrase giQueryTypeModifier gcBlockName btnClearBlockName 
         btnBlock1 btnBlock2 btnBlock3 btnBlock4 glDefineBlock glRetryBlock 
         glFinallyBlock giQueryType btnCopyToClipboard btnExecuteQuery 
         btnResetAll btnIncreaseIndentation btnDecreaseIndentation 
         btnResetIndentation btnOf gcQueryText brRelation gcRelationFilter 
         gcRelationFieldFilter btnClearRelationFilter 
         btnClearRelationFieldFilter glDefineVariables
         glUseVirtualIndexIncludes
      WITH FRAME fQuery IN WINDOW hQueryWindow.
  {&OPEN-BROWSERS-IN-QUERY-fQuery}
  VIEW hQueryWindow.
end procedure.
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_About hQueryWindow 
PROCEDURE qg_About :
/**
 * Show about dialog.
 */

define input parameter phMenuBar as handle    no-undo.

define variable iHwnd        as int64     no-undo.
define variable iDummy       as integer   no-undo.

define variable iX1          as integer   no-undo.
define variable iY1          as integer   no-undo.
define variable iX2          as integer   no-undo.
define variable iY2          as integer   no-undo.

define variable cVersionText as character no-undo.
define variable cInfoText    as character no-undo.

define variable hWindow      as handle    no-undo.
define variable hFrame       as handle    no-undo.
define variable hImage       as handle    no-undo.
define variable hVersionText as handle    no-undo.
define variable hInfoText    as handle    no-undo.

create window hWindow
  assign
    hidden          = yes
    width           = 80
    max-width       = 1024
    height          = 12
    max-height      = 1024
    scroll-bars     = no
    status-area     = no
    three-d         = yes
    message-area    = no
    control-box     = no
    small-title     = yes
    show-in-taskbar = no
    top-only        = yes
    sensitive       = yes
    resize          = no
    parent          = phMenuBar:window
    title           = substitute('&1&2':U, gcTitlePrefix, 'About Query Generator':T)
  triggers:

    on leave
      persistent run qg_CloseWindow in target-procedure
                       (hWindow).

    on end-error anywhere
      persistent run qg_CloseWindow in target-procedure
                       (hWindow).

    on window-close
      persistent run qg_DeleteWidgetTree  in target-procedure
                       (hWindow, yes).

  end triggers.


create frame hFrame
  assign
    name           = 'fAbout':U
    box            = no
    three-d        = yes
    width          = hWindow:width
    virtual-width  = hWindow:width
    height         = hWindow:height
    virtual-height = hWindow:height
    sensitive      = yes
    parent         = hWindow
  triggers:

    on mouse-select-click
      persistent run qg_CloseWindow in target-procedure
                       (hWindow).

  end triggers.

create image hImage
  assign
    name      = 'imgQueryGenerator':U
    frame     = hFrame
    width     = 1
    height    = 1
    row       = 2
    col       = 6
    sensitive = yes
  triggers:

    on mouse-select-click
      persistent run qg_CloseWindow in target-procedure
                       (hWindow).

  end triggers.
    .

create text hVersionText
  assign
    name      = 'cVersionText':U
    frame     = hFrame
    data-type = 'character':U
    format    = 'x(255)':U
    width     = 30
    height    = 1
    row       = 2
    col       = 6
    sensitive = yes
  triggers:

    on mouse-select-click
      persistent run qg_CloseWindow in target-procedure
                       (hWindow).

  end triggers.
    .

create editor hInfoText
  assign
    name                 = 'cInfoText':U
    frame                = hFrame
    data-type            = 'character':U
    width                = 69
    height               = 7
    read-only            = yes
    box                  = no
    word-wrap            = yes
    scrollbar-horizontal = no
    scrollbar-vertical   = no
    row                  = 2.5
    col                  = 6
    sensitive            = yes
    .

assign
  hImage:height-pixels = 32
  hImage:width-pixels  = 32
  .

if gcIconDir = '':U then
  hImage:load-image('adeicon/sqlexp.ico':U) no-error.

else
  hImage:load-image(substitute('&1/32/query_wizard.ico':U,
                               gcIconDir)) no-error.

assign
  cVersionText  = substitute('Query Generator Version &1':U,
                         {&K_Version})
  cInfoText =            'The Query Generator is a tool for lazy developeres. It ...':T
              + '~n':U
              + '~n':U + '... provides fast and easy access to database schema information':T
              + '~n':U + '... helps to integrate database queries into your code with little typing effort':T
              + '~n':U + '... displays table contents in a convenient and supporting manner':T
              + '~n':U
              + '~n':U + 'This Program is provided with absolutely no warranty. Use it at your own risk.':T
              + '~n':U
              + '~n':U + 'If you want to report a bug or provide feedback please contact manuel.thiemann@proalpha.de.':T
  .

if gcIconDir > '':U then
  assign
  cInfoText =   cInfoText
              + '~n':U
              + '~n':U + 'The icons are part of the "Free FatCow-Farm Fresh Icons" (http://www.fatcow.com/free-icons). These icon sets are licensed under a Creative Commons Attribution 3.0 License (http://creativecommons.org/licenses/by/3.0/us).':T
    hWindow:height = hWindow:height + 3.5
    hFrame:height  = hFrame:height + 3.5

              .

assign
  hVersionText:x             = hImage:x + hImage:width-pixels + 20
  hVersionText:height-pixels = hImage:height-pixels
  hVersionText:screen-value  = cVersionText
  hInfoText:y                = hImage:y + hImage:height-pixels + 30
  hInfoText:height-pixels    = hFrame:height-pixels - hInfoText:y
  hInfoText:screen-value     = cInfoText
  .

run GetParent(hWindow:hwnd,
              output iHwnd).

run SetWindowLongA(iHwnd,
                   {&K_WIN_CONST_GWL_STYLE},
                   {&K_WIN_CONST_WS_BORDER},
                   output iDummy).

run qg_GetWindowRect(phMenuBar:window,
                     output iX1,
                     output iY1,
                     output iX2,
                     output iY2).

run SetWindowPos(iHwnd,
                 0,
                 max(0, integer(iX1 + ((iX2 - iX1) / 2) - (hFrame:width-pixels / 2))),
                 max(0, integer(iY1 + ((iY2 - iY1) / 2) - (hFrame:height-pixels / 2))),
                 hWindow:width-pixels,
                 hWindow:height-pixels,
                 {&K_WIN_CONST_SWP_FRAMECHANGED},
                 output iDummy).

assign
  hWindow:hidden  = no
  hWindow:bgcolor = 15
  hFrame:hidden   = no
  hFrame:bgcolor  = 15
  .

apply 'entry':U to hWindow.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddFieldHistoryEntry hQueryWindow 
PROCEDURE qg_AddFieldHistoryEntry :
/**
 * Adds current value of given combo-box to it's value list.
 *
 * @param phWidget = Combo-box widget.
 */

define input parameter phWidget as handle    no-undo.

define variable cValue as character no-undo.
define variable i      as integer   no-undo.

cValue = phWidget:input-value no-error.
phWidget:delete(cValue) no-error.

if length(cValue) > 3 then
do:
  phWidget:add-first(cValue).
  phWidget:screen-value = cValue.
end.

do i = phWidget:num-items to {&K_MAX_FIELD_HISTORY_ENTRIES} + 1 by -1:
  phWidget:delete(i).
end.

// This causes flickering
//if    OEIDEIsRunning
//and glIDECanSaveSetting
//and phWidget:list-items <> ? then
//run qg_SaveIDESetting(substitute('FieldHistory_&1':U, phWidget:name),
//                      phWidget:list-items) no-error.
end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddHelpMenu Method-Library
procedure qg_AddHelpMenu :
define input parameter phMenuBar as handle    no-undo.

define variable hSubMenu as handle    no-undo.
define variable hTemp    as handle    no-undo.

create sub-menu hSubMenu
  assign
    name      = 'm_Help':U
    label     = 'Help':T
    sensitive = yes
    parent    = phMenuBar
    .

create menu-item hTemp
  assign
    name        = 'mi_About':U
    label       = 'About Query Generator':T
    sensitive   = yes
    parent      = hSubMenu
  triggers:
    on choose
      persistent run qg_About in target-procedure
                       (phMenuBar).  
  end triggers.

end procedure.


/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddPersistentTempTable hQueryWindow 
PROCEDURE qg_AddPersistentTempTable :
/**
 * Add persistent temp-table entry.
 */

define variable i              as integer   no-undo.

define variable hTempTable     as handle    no-undo.
define variable cProcedureName as character no-undo.

define variable cParamList     as character no-undo.

define variable iQuerySeq      as integer   no-undo initial ?.
define variable iFilterId      as integer   no-undo.

define variable cProcedureFilter    as character no-undo
  format 'x(1024)':U
  view-as fill-in
  tooltip "Filter for procedures and classes that match given name pattern (comma separated)"
  size 63 by 1.

define button btnClearProcedureFilter
  label '':T2
  size 7 by 1.

define variable cTableFilter as character no-undo
  format 'x(1024)':U
  view-as fill-in
  tooltip "Filter for procedures and classes containing tables that match given name pattern (comma separated)"
  size 63 by 1.

define button btnClearTableFilter
  label '':T2
  size 7 by 1.

define button btnOk
  label 'Ok':T2
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.

define buffer bttPersistentProcedure for temp-table ttPersistentProcedure.
define buffer bttPersistentTempTable for temp-table ttPersistentTempTable.
define buffer bttFilterMatch         for temp-table ttFilterMatch.

&IF proversion >= '11.2':U &THEN

  define query brPersistentProcedureBrowse
    for bttPersistentProcedure,bttFilterMatch
    scrolling.

  define browse brPersistentProcedureBrowse
    query brPersistentProcedureBrowse no-lock
      display
        bttPersistentProcedure.ProcedureName
        with no-assign size 70 by 18.5.

  define query brPersistentTempTableBrowse
    for bttPersistentTempTable
    scrolling.

  define browse brPersistentTempTableBrowse
    query brPersistentTempTableBrowse no-lock
      display
        bttPersistentTempTable.TableName
        with no-assign size 70 by 18.5 fit-last-column.

  define frame fSelectPersistentTempTable
    cProcedureFilter at row 1.5 col 3 no-label
    btnClearProcedureFilter at row 1.5 col 66
    cTableFilter at row 1.5 col 75 no-label
    btnClearTableFilter at row 1.5 col 138
    brPersistentProcedureBrowse at row 2.5 col 3
    brPersistentTempTableBrowse at row 2.5 col 75
    btnOk at row 22 col 54
    btnCancel at row 22 col 74
    with 1 down keep-tab-order overlay
      view-as dialog-box 
      side-labels no-underline three-d 
      size 147 by 23.83
      title gcTitlePrefix + 'Select persistent temp-table':T
      default-button btnOk
      cancel-button btnCancel.

  on window-close of frame fSelectPersistentTempTable
    apply 'end-error' to self.

  on off-home of brPersistentProcedureBrowse in frame fSelectPersistentTempTable
  do:
    apply 'entry':U to cProcedureFilter in frame fSelectPersistentTempTable.
    return no-apply.
  end.

  on cursor-down of cProcedureFilter in frame fSelectPersistentTempTable
  do:
    apply 'entry':U to brPersistentProcedureBrowse in frame fSelectPersistentTempTable.
    browse brPersistentProcedureBrowse:select-focused-row().
    return no-apply.
  end.

  on cursor-down of btnClearProcedureFilter in frame fSelectPersistentTempTable
  do:
    apply 'entry':U to brPersistentProcedureBrowse in frame fSelectPersistentTempTable.
    browse brPersistentProcedureBrowse:select-focused-row().
    return no-apply.
  end.

  on off-home of brPersistentTempTableBrowse in frame fSelectPersistentTempTable
  do:
    apply 'entry':U to cTableFilter in frame fSelectPersistentTempTable.
    return no-apply.
  end.

  on cursor-down of cTableFilter in frame fSelectPersistentTempTable
  do:
    apply 'entry':U to brPersistentTempTableBrowse in frame fSelectPersistentTempTable.
    browse brPersistentTempTableBrowse:select-focused-row().
    return no-apply.
  end.

  on cursor-down of btnClearTableFilter in frame fSelectPersistentTempTable
  do:
    apply 'entry':U to brPersistentTempTableBrowse in frame fSelectPersistentTempTable.
    browse brPersistentTempTableBrowse:select-focused-row().
    return no-apply.
  end.

  on u1 of brPersistentProcedureBrowse in frame fSelectPersistentTempTable
  do:

    define variable i                    as integer   no-undo.
    define variable cFilterEntry         as character no-undo.
    define variable cPrepProcedureFilter as character no-undo.
    define variable cPrepTableFilter     as character no-undo.

    assign
      cProcedureFilter = input frame fSelectPersistentTempTable cProcedureFilter
      cTableFilter     = input frame fSelectPersistentTempTable cTableFilter
      .

    do i = 1 to num-entries(cProcedureFilter):

      assign
        cFilterEntry          = entry(i, cProcedureFilter).
        cPrepProcedureFilter  = substitute('&1,&2':U,
                                           cPrepProcedureFilter,
                                           qg_cFilterEntryMatchcode(cFilterEntry))
        .

    end.

    cPrepProcedureFilter = (if cPrepProcedureFilter = '':U then
                              '*':U
                            else
                              trim(cPrepProcedureFilter, ',':U)).

    do i = 1 to num-entries(cTableFilter):

      assign
        cFilterEntry      = entry(i, cTableFilter).
        cPrepTableFilter  = substitute('&1,&2':U,
                                       cPrepTableFilter,
                                       qg_cFilterEntryMatchcode(cFilterEntry))
        .

    end.

    cPrepTableFilter = (if cPrepTableFilter = '':U then
                          '*':U
                        else
                          trim(cPrepTableFilter, ',':U)).

    for each bttPersistentProcedure,
    first bttFilterMatch
      where bttFilterMatch.FilterId    = iFilterId
        and bttFilterMatch.RecordRowId = rowid(bttPersistentProcedure)
      on error undo, throw:

      bttFilterMatch.RecordMatches = can-do(cPrepProcedureFilter, bttPersistentProcedure.ProcedureName).

      if bttFilterMatch.RecordMatches then
      do:

        do i = 1 to num-entries(cPrepTableFilter):

          assign
            cFilterEntry                 = entry(i, cPrepTableFilter)
            bttFilterMatch.RecordMatches = can-find(first ttPersistentTempTable
                                                      where ttPersistentTempTable.ProcedureName   = bttPersistentProcedure.ProcedureName
                                                        and ttPersistentTempTable.TableName matches cFilterEntry)
            .

          if bttFilterMatch.RecordMatches then
            leave.

        end.

      end.

    end.

    open query brPersistentProcedureBrowse
      for each bttPersistentProcedure,
      first bttFilterMatch
        where bttFilterMatch.FilterId      = iFilterId
          and bttFilterMatch.RecordRowId   = rowid(bttPersistentProcedure)
          and bttFilterMatch.RecordMatches = yes
          no-lock.

    apply 'value-changed':U to brPersistentProcedureBrowse in frame fSelectPersistentTempTable.

  end.

  on value-changed of cProcedureFilter in frame fSelectPersistentTempTable
    apply 'u1':U to brPersistentProcedureBrowse in frame fSelectPersistentTempTable.

  on choose of btnClearProcedureFilter in frame fSelectPersistentTempTable
  do:

    display unless-hidden
      '':U @ cProcedureFilter
      with frame fSelectPersistentTempTable.

    apply 'value-changed':U to cProcedureFilter in frame fSelectPersistentTempTable.

  end.

  on value-changed of cTableFilter in frame fSelectPersistentTempTable
    apply 'u1':U to brPersistentProcedureBrowse in frame fSelectPersistentTempTable.

  on choose of btnClearTableFilter in frame fSelectPersistentTempTable
  do:

    display unless-hidden
      '':U @ cTableFilter
      with frame fSelectPersistentTempTable.

    apply 'value-changed':U to cTableFilter in frame fSelectPersistentTempTable.

  end.

  on value-changed of brPersistentProcedureBrowse in frame fSelectPersistentTempTable
  do:

    define variable i                as integer   no-undo.
    define variable cFilterEntry     as character no-undo.
    define variable cPrepTableFilter as character no-undo.

    define buffer b2ttPersistentTempTable for temp-table ttPersistentTempTable.

    open query brPersistentTempTableBrowse
      for each bttPersistentTempTable
        where bttPersistentTempTable.ProcedureName = bttPersistentProcedure.ProcedureName
        no-lock
        use-index TableName.

    if available bttPersistentProcedure then
    do:

      cTableFilter = input frame fSelectPersistentTempTable cTableFilter.

      do i = 1 to num-entries(cTableFilter):

        assign
          cFilterEntry      = entry(i, cTableFilter).
          cPrepTableFilter  = substitute('&1,&2':U,
                                         cPrepTableFilter,
                                         qg_cFilterEntryMatchcode(cFilterEntry))
          .

      end.

      cPrepTableFilter = (if cPrepTableFilter = '':U then
                            '*':U
                          else
                            trim(cPrepTableFilter, ',':U)).

      for each b2ttPersistentTempTable
        where b2ttPersistentTempTable.ProcedureName = bttPersistentProcedure.ProcedureName
        use-index TableName
        on error undo, throw:

        if can-do(cPrepTableFilter, b2ttPersistentTempTable.TableName) then
        do:

          reposition brPersistentTempTableBrowse to rowid rowid(b2ttPersistentTempTable) no-error.
          leave.

        end.

      end.

    end.

  end.

  on default-action of brPersistentTempTableBrowse in frame fSelectPersistentTempTable
    apply 'go':U to frame fSelectPersistentTempTable.

  // Create list of all available temp-tables.
  empty temp-table ttPersistentProcedure.
  empty temp-table ttPersistentTempTable.

  iFilterId = qg_iFilterSeq().

  &IF proversion >= '11.2':U &THEN

    do i = 1 to Progress.Database.TempTableInfo:TempTableCount:

      // Sometimes this invocation fails with an progress runtime error
      // "Invalid value specified for Progress.Database.TempTableInfo:
      // GetTableInfoByPosition (15246)" even though we queried TempTableCount
      // just one line above. To avoid that we call GetTableInfoByPosition with
      // no-error and continue with the next entry in case of an error.

      Progress.Database.TempTableInfo:GetTableInfoByPosition
        (i, output hTempTable, output cProcedureName) no-error.

      if error-status:error then
        next.

      // Ignore before tables.
      if valid-handle(hTempTable:after-table) then
        next.

      // Add procedure entry if needed.
      if not can-find(first ttPersistentProcedure
                        where ttPersistentProcedure.ProcedureName = cProcedureName) then
      do:

        create bttPersistentProcedure.

        bttPersistentProcedure.ProcedureName = cProcedureName.

        validate bttPersistentProcedure.

        create bttFilterMatch.

        assign
          bttFilterMatch.FilterId      = iFilterId
          bttFilterMatch.RecordRowId   = rowid(bttPersistentProcedure)
          bttFilterMatch.RecordMatches = yes
          .

        validate bttFilterMatch.

      end.

      // Add table entry.
      if not can-find(first bttPersistentTempTable
                        where bttPersistentTempTable.ProcedureName = cProcedureName
                          and bttPersistentTempTable.TableHandle   = hTempTable) then
      do:

        create bttPersistentTempTable.

        assign
          bttPersistentTempTable.ProcedureName = cProcedureName
          bttPersistentTempTable.TableHandle   = hTempTable
          bttPersistentTempTable.TableName     = hTempTable:name
          .

      end.

    end.

  &ENDIF

  run qg_InitBrowse(browse brPersistentProcedureBrowse:handle).
  run qg_InitBrowse(browse brPersistentTempTableBrowse:handle).

  display unless-hidden
    brPersistentProcedureBrowse
    with frame fSelectPersistentTempTable
      in window {&WINDOW-NAME}. 

  apply 'u1':U to brPersistentProcedureBrowse in frame fSelectPersistentTempTable.

  if gcPersitentTTProcedure > '':U then
  do:

    find bttPersistentProcedure
      where bttPersistentProcedure.ProcedureName = gcPersitentTTProcedure
      no-error.

    if available bttPersistentProcedure then
      reposition brPersistentProcedureBrowse to rowid rowid(bttPersistentProcedure) no-error.

  end.

  apply 'value-changed':U to brPersistentProcedureBrowse in frame fSelectPersistentTempTable.

  update unless-hidden
    cProcedureFilter
    btnClearProcedureFilter
    cTableFilter
    btnClearTableFilter
    brPersistentProcedureBrowse
    brPersistentTempTableBrowse
    btnOk
    btnCancel
    with frame fSelectPersistentTempTable
      in window {&WINDOW-NAME}. 

  if available bttPersistentTempTable then
  do:

    gcPersitentTTProcedure = bttPersistentTempTable.ProcedureName.

    run qg_AddTableHandle(bttPersistentTempTable.TableHandle,
                          bttPersistentTempTable.TableHandle,
                          no,
                          {&K_PERSISTENT_TT_DBNAME},
                          {&K_PERSISTENT_TT_PHYSICALNAME}).

    if menu-item mi_OpenQueryWindowPersistentTT:checked in menu m_Options then
    do:

      cParamList = qg_cParamListWriteLogical(cParamList,
                                             'FocusQueryText':U,
                                             yes,
                                             {&K_PARAM_SPLITTER}).

      run qg_ExecQuery({&K_QUERY_WINDOW_MODE_QUERY},
                       {&K_QUERY_SIZE_MODE_DEFAULT},
                       substitute('&1.&2':U,
                                  {&K_PERSISTENT_TT_DBNAME},
                                  bttPersistentTempTable.TableHandle:name),
                       substitute('for each &1':U,
                                  bttPersistentTempTable.TableHandle:name),
                       no,  /* Init mode */
                       cParamList,
                       input-output iQuerySeq).

    end.

  end.

  finally:

    if iFilterId > 0 then
    do:

      for each bttFilterMatch
        where bttFilterMatch.FilterId = iFilterId
        on error undo, throw:

        delete bttFilterMatch.

      end.

    end.

  end finally.

&ENDIF

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddQueryWindowViewLine hQueryWindow 
PROCEDURE qg_AddQueryWindowViewLine :
define parameter buffer pbttQueryWindow for temp-table ttQueryWindow.

define input parameter piRoot         as integer   no-undo.
define input parameter phParentWindow as handle    no-undo.
define input parameter piDepth        as integer   no-undo.

define variable hBuffer       as handle    no-undo.
define variable cDatabaseName as character no-undo.

define buffer bttQueryWindow     for temp-table ttQueryWindow.
define buffer bttQueryLink       for temp-table ttQueryLink.
define buffer bttQueryWindowView for temp-table ttQueryWindowView.

if valid-handle(pbttQueryWindow.QueryHandle) then
do:

  hBuffer = pbttQueryWindow.QueryHandle:get-buffer-handle(1) no-error.

  if valid-handle(hBuffer) then
    cDatabaseName = qg_cDatabaseNameForTableOrBuffer( hBuffer ).

end.

find first bttQueryWindowView
  where bttQueryWindowView.ParentWindowHandle = phParentWindow
    and bttQueryWindowView.WindowHandle       = pbttQueryWindow.WindowHandle
  no-error.

if not available bttQueryWindowView then
do:

  create bttQueryWindowView.

  assign
    bttQueryWindowView.WindowHandle       = pbttQueryWindow.WindowHandle
    bttQueryWindowView.ParentWindowHandle = phParentWindow
    .

end.

assign
  ghQueryWindowListWindowSeq    = ghQueryWindowListWindowSeq + 1
  bttQueryWindowView.Id         = ghQueryWindowListWindowSeq
  bttQueryWindowView.Root       = (if piRoot = ? then
                                     bttQueryWindowView.Id
                                   else
                                     piRoot)
  bttQueryWindowView.WindowMode = pbttQueryWindow.WindowMode
  bttQueryWindowView.Depth      = piDepth
  bttQueryWindowView.LineText   = substitute('[&1] &2':U,
                                             string(pbttQueryWindow.QuerySeq),
                                             (if valid-handle(hBuffer) then
                                                substitute('&1.&2':U,
                                                           cDatabaseName,
                                                           hBuffer:name)
                                              else
                                                'unknown':U))
  .

validate bttQueryWindowView.

for each bttQueryLink
  where bttQueryLink.SourceSeq = pbttQueryWindow.QuerySeq,
first bttQueryWindow
  where bttQueryWindow.QuerySeq = bttQueryLink.TargetSeq
  break by bttQueryLink.TargetSeq
  on error undo, throw:

  if first-of(bttQueryLink.TargetSeq) then
    run qg_AddQueryWindowViewLine(buffer bttQueryWindow,
                                  bttQueryWindowView.Root,
                                  pbttQueryWindow.WindowHandle,
                                  piDepth + 1).

end.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddRecentQuery hQueryWindow 
PROCEDURE qg_AddRecentQuery :
/**
 * Creeate a new menu item for the current query to the recent queries sub-
 * menu.
 *
 * @param phWindow = Handle of the Query window.
 */

define input parameter phWindow as handle    no-undo.

define variable cQueryText as character no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.
define buffer bttRecentQuery for temp-table ttRecentQuery.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

assign
  cQueryText         = bttQueryWindow.QueryText
  giRecentQueriesSeq = giRecentQueriesSeq + 1
  .

find first bttRecentQuery
  where bttRecentQuery.WindowHandle = bttQueryWindow.WindowHandle
    and bttRecentQuery.QueryText    = cQueryText
  no-error.

if available bttRecentQuery then
  bttRecentQuery.Order = giRecentQueriesSeq.

else
do:

  create bttRecentQuery.

  assign
    bttRecentQuery.WindowHandle = bttQueryWindow.WindowHandle
    bttRecentQuery.QueryText    = cQueryText
    bttRecentQuery.Order        = giRecentQueriesSeq
    bttRecentQuery.QueryLabel   = qg_cQueryLabel(cQueryText)
    .

end.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddSessionTrigger hQueryWindow 
PROCEDURE qg_AddSessionTrigger :
/**
 * Add session trigger for given event and table/field.
 *
 * @param pcTriggerEvent = Trigger event that should be added.
 * @param pcDatabaseName = Database of table for trigger event.
 * @param pcTableName = Table for trigger event.
 * @param pcFieldName = Field for trigger event.
 * @param plActivate = Activate session trigger.
 */

define input parameter pcTriggerEvent as character no-undo.
define input parameter pcDatabaseName as character no-undo.
define input parameter pcTableName    as character no-undo.
define input parameter pcFieldName    as character no-undo.
define input parameter plActivate     as logical   no-undo.

define variable cTriggerFileName as character no-undo.

define buffer bttSessionTrigger for temp-table ttSessionTrigger.

if pcFieldName = ? then
  pcFieldName = '':U.

// Every session trigger may be defined only once.
if can-find(first ttSessionTrigger
              where ttSessionTrigger.TriggerEvent = pcTriggerEvent
                and ttSessionTrigger.DatabaseName = pcDatabaseName
                and ttSessionTrigger.TableName    = pcTableName
                and ttSessionTrigger.FieldName    = pcFieldName) then
  leave.

// Get next free filename.
do while yes:

  assign
    giSessionTriggerSeq = giSessionTriggerSeq + 1.
    cTriggerFileName    = substitute(qg_cFileName('%Temp%/qg_SessionTrigger_&1.p':U),
                                     string(giSessionTriggerSeq)).
    file-info:file-name = cTriggerFileName
    .

  if file-info:full-pathname = ? then
    leave.

end.

create bttSessionTrigger.

assign
  bttSessionTrigger.Id              = giSessionTriggerSeq
  bttSessionTrigger.TriggerEvent    = pcTriggerEvent
  bttSessionTrigger.DatabaseName    = pcDatabaseName
  bttSessionTrigger.TableName       = pcTableName
  bttSessionTrigger.FieldName       = pcFieldName
  bttSessionTrigger.TriggerFileName = cTriggerFileName
  bttSessionTrigger.LogfileName     = '<default>':U
  .

validate bttSessionTrigger.

if not plActivate then

  run qg_WriteSessionTriggerProc(bttSessionTrigger.Id).

else
do:

assign
  bttSessionTrigger.ProcedureHandle = qg_hStartSessionTrigger(bttSessionTrigger.Id)
  bttSessionTrigger.TriggerActive   = valid-handle(bttSessionTrigger.ProcedureHandle)
  .

validate bttSessionTrigger.

end.

if valid-handle(ghSessionTriggersWindow) then
do:

  run qg_SessionTriggersOpenQuery.

  ghSessionTriggersBrowse:query:reposition-to-rowid(rowid(bttSessionTrigger)).

end.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddSnapshot hQueryWindow 
PROCEDURE qg_AddSnapshot :
/**
 * Add snapshot for given database object (table, temp-table or dataset).
 *
 * @param phDBObject = Database object for that the snapshot should be added.
 * @param pcSnapshotName = Name for the snapshot. For tables or temp-tables this will be the name of the temp-table clone. For datasets this will the database name.
 * @param pcWhere = Where condition for the records that should be copied (not used for datasets).
 */

define input parameter phDBObject     as handle    no-undo.
define input parameter pcSnapshotName as character no-undo.
define input parameter pcWhere        as character no-undo.

define variable cTimestamp            as character no-undo.
define variable cSnapshotName         as character no-undo.
define variable iNumReplacements      as integer   no-undo.
define variable cStatusText           as character no-undo.

define variable i                     as integer   no-undo.
define variable hDBObject             as handle    no-undo.
define variable hTable                as handle    no-undo.

define variable cParamList            as character no-undo.

define variable iQuerySeq             as integer   no-undo initial ?.

if not valid-handle(phDBObject) then
  leave.

cTimestamp = replace(string(time, 'HH:MM:SS':U),
                     ':':U,
                     '':U).

run qg_SubstituteChar(pcSnapshotName,
                      '#':U,
                      cTimestamp,
                      output cSnapshotName,
                      output iNumReplacements).

if phDBObject:type = 'DATASET':U then
do:

  if iNumReplacements > 0 then
  do:

    i = 0.

    do while can-find(first ttDatabase
                        where ttDatabase.DatabaseName = cSnapshotName):

      i = i + 1.

      run qg_SubstituteChar(pcSnapshotName,
                            '#':U,
                            substitute('&1-&2':U, cTimestamp, string(i)),
                            output cSnapshotName,
                            output iNumReplacements).

    end.

  end.

  do i = 1 to phDBObject:num-buffers:

    hDBObject = phDBObject:get-buffer-handle(i).

    cStatusText = substitute('Adding snapshot &2 / &3':T,
                             cSnapshotName,
                             hDBObject:name).

    // Create temp-table like parameter table.
    run qg_CreateTableClone(hDBObject,
                            hDBObject:name,
                            ?,
                            cStatusText,
                            output hTable).

    // Add snapshot.
    run qg_AddTableHandle(hTable,
                          hDBObject,
                          yes,
                          cSnapshotName,
                          {&K_SNAPSHOT_PHYSICALNAME}).


  end.

  run qg_AddDatasetRelations( cSnapshotName, phDBObject ).

end.

else
do:

  if iNumReplacements > 0 then
  do:

    i = 0.

    do while can-find(first ttTable
                        where ttTable.DatabaseName = {&K_SNAPSHOT_DBNAME}
                          and ttTable.TableName    = cSnapshotName):

        i = i + 1.

        run qg_SubstituteChar(pcSnapshotName,
                              '#':U,
                              substitute('&1-&2':U, cTimestamp, string(i)),
                              output cSnapshotName,
                              output iNumReplacements).

    end.

  end.

  cStatusText = substitute('Adding snapshot &1':T, cSnapshotName).

  // Create temp-table like parameter table.
  run qg_CreateTableClone(phDBObject,
                          cSnapshotName,
                          pcWhere,
                          cStatusText,
                          output hTable).

  // Add snapshot.
  run qg_AddTableHandle(hTable,
                        phDBObject,
                        yes,
                        {&K_SNAPSHOT_DBNAME},
                        {&K_SNAPSHOT_PHYSICALNAME}).

  if menu-item mi_OpenQueryWindowSnapshotTT:checked in menu m_Options then
  do:

    cParamList = qg_cParamListWriteLogical(cParamList,
                                           'FocusQueryText':U,
                                           yes,
                                           {&K_PARAM_SPLITTER}).

    run qg_ExecQuery({&K_QUERY_WINDOW_MODE_QUERY},
                     {&K_QUERY_SIZE_MODE_DEFAULT},
                     substitute('&1.&2':U, {&K_SNAPSHOT_DBNAME}, cSnapshotName),
                     substitute('for each &1':U, cSnapshotName),
                     no,  /* Init mode */
                     cParamList,
                     input-output iQuerySeq).

  end.

end.

finally:

  hide frame fStatus.

end finally.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddSnapshotLine hQueryWindow 
PROCEDURE qg_AddSnapshotLine :
/**
 * Add snapshot line for given buffer to given snapshot.
 *
 * @param phBuffer = Buffer handle of the record that should be added.
 * @param pcSnapshotName = Name of the snapshot to which the record should be added.
 * @param plUpdate = If yes then an existing snapshot record will be updated. Otherwise if a record is already present it will not be added or updated.
 */

define input parameter phBuffer       as handle    no-undo.
define input parameter pcSnapshotName as character no-undo.
define input parameter plUpdate       as logical   no-undo.

define variable i                as integer   no-undo.
define variable cTimestamp       as character no-undo.
define variable cSnapshotName    as character no-undo.
define variable iNumReplacements as integer   no-undo.

define variable hTable        as handle    no-undo.
define variable hTargetBuffer as handle    no-undo.

define variable cQueryText    as character no-undo.

define buffer bttTable      for temp-table ttTable.
define buffer bttIndex      for temp-table ttIndex.
define buffer bttIndexField for temp-table ttIndexField.

if   not valid-handle(phBuffer)
  or not can-query(phBuffer, 'type':U)
  or phBuffer:type <> 'BUFFER':U then
do:

  message
    'Invalid handle in qgEvt_SnapshotLine event':T
    view-as alert-box
    error
    buttons ok
    in window hQueryWindow.

  leave.

end.

if not phBuffer:available then
  leave.

cTimestamp = replace(string(time, 'HH:MM:SS':U),
                     ':':U,
                     '':U).

run qg_SubstituteChar(pcSnapshotName,
                      '#':U,
                      cTimestamp,
                      output cSnapshotName,
                      output iNumReplacements).

if iNumReplacements > 0 then
do:

  i = 0.

  do while can-find(first ttTable
                      where ttTable.DatabaseName = {&K_SNAPSHOT_DBNAME}
                        and ttTable.TableName    = cSnapshotName):

      i = i + 1.

      run qg_SubstituteChar(pcSnapshotName,
                            '#':U,
                            substitute('&1-&2':U, cTimestamp, string(i)),
                            output cSnapshotName,
                            output iNumReplacements).

  end.

end.

find bttTable
  where bttTable.DatabaseName = {&K_SNAPSHOT_DBNAME}
    and bttTable.TableName    = cSnapshotName
  no-error.

if available bttTable then
do:

  if not bttTable.Snapshot then
  do:

    message
      substitute('Table ~'&1~' is not a Snapshot':T) skip
      view-as alert-box
      error
      buttons ok
      in window hQueryWindow.

    leave.

  end.

  if valid-handle(bttTable.TableHandle) then
    hTable = bttTable.TableHandle.

  else
    run qg_RemoveTable(bttTable.DatabaseName,
                       bttTable.TableName).

end.

if not valid-handle(hTable) then
do:

  // Create temp-table like parameter table.
  create temp-table hTable in widget-pool qg_cTTWidgetPool().
  hTable:create-like(phBuffer).
  hTable:temp-table-prepare(cSnapshotName).

  run qg_AddTableHandle(hTable,
                        phBuffer,
                        yes,
                        {&K_SNAPSHOT_DBNAME},
                        {&K_SNAPSHOT_PHYSICALNAME}).

end.

create buffer hTargetBuffer for table hTable.

// Check if the record already exists
if plUpdate then
  for each bttIndex
    where bttIndex.DatabaseName = {&K_SNAPSHOT_DBNAME}
      and bttIndex.TableName    = hTable:name
      and bttIndex.IsUnique     = yes
    no-lock
    on error undo, throw:

    cQueryText = '':U.

    for each bttIndexField
      where bttIndexField.DatabaseName = bttIndex.DatabaseName
        and bttIndexField.TableName    = bttIndex.TableName
        and bttIndexField.IndexName    = bttIndex.IndexName
      no-lock
      on error undo, throw:

      cQueryText = substitute('&1~n&2 &3.&4 = &5':U,
                              cQueryText,
                              (if cQueryText = '':U then
                                 'where':U
                               else
                                 'and':U),
                              hTargetBuffer:name,
                              bttIndexField.FieldName,
                              quoter(phBuffer:buffer-field(bttIndexField.FieldName):buffer-value)).

    end.

    hTargetBuffer:find-first(cQueryText, no-lock) no-error.

    if hTargetBuffer:available then
      leave.

  end.

if not hTargetBuffer:available then
  hTargetBuffer:buffer-create().

do on error undo, throw:

  hTargetBuffer:buffer-copy(phBuffer).
  hTargetBuffer:buffer-validate().

  catch oError as Progress.Lang.Error:

    // If the buffer-copy failed (most likely because the record already
    // exists) then the newly created record has to bedeleted.

    if    valid-handle(hTargetBuffer)
      and hTargetBuffer:available
      and hTargetBuffer:new then
      hTargetBuffer:buffer-delete().

  end catch.

end.

finally:

  if valid-handle(hTargetBuffer) then
    delete object hTargetBuffer.

end finally.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddTableHandle hQueryWindow 
PROCEDURE qg_AddTableHandle :
/**
 * Create a temp-table like given table/buffer handle, copy all its contents
 * and add its schema information to the cache.
 *
 * @param phTable = Table for wich a snapshot should be cre- ated.
 * @param pcDatabaseName = Database name for the table.
 * @param pcPhysicalName = Physical name for the table.
 */

define input parameter phTable         as handle    no-undo.
define input parameter phOriginalTable as handle    no-undo.
define input parameter plSnapshot      as logical   no-undo.
define input parameter pcDatabaseName  as character no-undo.
define input parameter pcPhysicalName  as character no-undo.

define variable hBuffer    as handle    no-undo.
define variable hField     as handle    no-undo.

define variable i          as integer   no-undo.
define variable j          as integer   no-undo.

define variable cIndexInfo as character no-undo.

define variable lNewDB     as logical   no-undo.
define variable rCurrentDB as rowid     no-undo.

define buffer bttDatabase   for temp-table ttDatabase.
define buffer bttTable      for temp-table ttTable.
define buffer bttField      for temp-table ttField.
define buffer bttIndex      for temp-table ttIndex.
define buffer bttIndexField for temp-table ttIndexField.

if not valid-handle(phTable) then
  leave.

// Add database.
find bttDatabase
  where bttDatabase.DatabaseName = pcDatabaseName
  no-error.

if not available bttDatabase then
do:

  lNewDB = yes.

  create bttDatabase.

  assign
    bttDatabase.DatabaseName    = pcDatabaseName
    bttDatabase.PhysicalName    = pcPhysicalName
    bttDatabase.DirectoryName   = '':U
    bttDatabase.TempDB          = yes
    bttDatabase.BasisDB         = no
    bttDatabase.BasisDBName     = '':U
    bttDatabase.PhysicalDB      = no
    .

  case bttDatabase.DatabaseName:

    when {&K_PERSISTENT_TT_DBNAME} then
      bttDatabase.DisplayPriority = 2000.

    when {&K_SNAPSHOT_DBNAME} then
      bttDatabase.DisplayPriority = 3000.

    otherwise 
      bttDatabase.DisplayPriority = 4000.

  end case.

  validate bttDatabase.

end.

phTable:private-data = qg_cParamListWriteCharacter(phTable:private-data,
                                                   'DatabaseName':U,
                                                   pcDatabaseName,
                                                   ',':U).

// Add table.
find bttTable
  where bttTable.DatabaseName = bttDatabase.DatabaseName
    and bttTable.TableName    = phTable:name
  no-error.

if available bttTable then
  run qg_RemoveTable(bttTable.DatabaseName,
                     bttTable.TableName).

create bttTable.

assign
  bttTable.DatabaseName        = bttDatabase.DatabaseName
  bttTable.TableName           = phTable:name
  bttTable.DetailsLoaded       = yes
  bttTable.PhysicalTable       = no
  bttTable.TableHandle         = phTable
  bttTable.OriginalTableHandle = phOriginalTable
  bttTable.Snapshot            = plSnapshot
  .

validate bttTable.

hBuffer = phTable:default-buffer-handle.

// Add fields.
do i = 1 to hBuffer:num-fields:

  hField = hBuffer:buffer-field(i).

  create bttField.

  assign
    bttField.DatabaseName      = bttTable.DatabaseName
    bttField.TableName         = bttTable.TableName
    bttField.FieldName         = hField:name
    bttField.DataType          = substitute('&1&2':U,
                                            caps(substring(hField:data-type, 1, 1)),
                                            lc(substring(hField:data-type, 2)))
    bttField.FieldFormat       = hField:format
    bttField.FieldExtent       = hField:extent
    bttField.FieldDecimals     = (if bttField.DataType = 'DECIMAL':U then
                                    hField:decimals
                                  else
                                    ?)
    bttField.FieldInitialValue = trim(hField:initial)
    bttField.FieldLabel        = hField:label
    bttField.FieldColumnLabel  = hField:column-label
    bttField.IsMandatory       = hField:mandatory
    bttField.FieldViewAs       = hField:view-as
    bttField.IsObjectId        = (bttField.FieldName matches '*_Obj':U)
    .

  validate bttField.

end.

// Add Indices.
i = 1.

do while hBuffer:index-information(i) <> ?:

  cIndexInfo = hBuffer:index-information(i).

  create bttIndex.

  assign
    bttIndex.DatabaseName = bttTable.DatabaseName
    bttIndex.TableName    = bttTable.TableName
    bttIndex.IndexName    = entry(1, cIndexInfo)
    bttIndex.IsUnique     = logical(entry(2, cIndexInfo), '1/0':U)
    bttIndex.IsPrimary    = logical(entry(3, cIndexInfo), '1/0':U)
    .

  validate bttIndex.

  // Add index fields.
  do j = 5 to num-entries(cIndexInfo) by 2:

    if entry(j, cIndexInfo) = '':U then
      next.

    create bttIndexField.

    assign
      bttIndexField.DatabaseName  = bttIndex.DatabaseName
      bttIndexField.TableName     = bttIndex.TableName
      bttIndexField.IndexName     = bttIndex.IndexName
      bttIndexField.IndexSequence = j - 5
      bttIndexField.FieldName     = entry(j, cIndexInfo)
      bttIndexField.SortAscending = logical(entry(j + 1, cIndexInfo), '0/1':U)
      .  

    validate bttIndexField.

    assign
      bttIndex.IndexFieldList = substitute( '&1,&2':U,
                                            bttIndex.IndexFieldList,
                                            bttIndexField.FieldName )
      bttIndex.IndexFields    = substitute( '&1 &2&3':U,
                                            bttIndex.IndexFields,
                                            string( bttIndexField.SortAscending, '+/-':U ),
                                            bttIndexField.FieldName )
      .

    validate bttIndex.

  end.

  assign
    bttIndex.IndexFieldList = trim(bttIndex.IndexFieldList, ',':U)
    bttIndex.IndexFields    = trim(bttIndex.IndexFields)
    .

  validate bttIndex.

  i = i + 1.

end.

// Refresh and reposition database and table browse.
if lNewDB then
do:

  rCurrentDB = rowid(ttDatabase).

  {&OPEN-QUERY-brDatabase}

  if rCurrentDB <> ? then
    reposition brDatabase to rowid rCurrentDB no-error.

end.

if    available ttDatabase
  and ttDatabase.DatabaseName = pcDatabaseName then
  apply 'value-changed':U to browse brDatabase.

process events.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddTableSnapshot hQueryWindow 
PROCEDURE qg_AddTableSnapshot :
/**
 * Shows a snapshot name dialog and creates the snapshot.
 *
 * @param phBuffer = Buffer handle of the table for which a Snapshot should be created.
 * @param pcWhere = Where condition for the records that should be copied.
 * @param phParentWindow = Parent window for the dialog.
 */

define input parameter phBuffer       as handle    no-undo.
define input parameter pcWhere        as character no-undo.
define input parameter phParentWindow as handle    no-undo.

define variable cSnapshotName as character no-undo
  format 'x(32)':U
  view-as fill-in
  size 65 by 1.

define button btnOk
  label 'Ok':T2
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.

define frame fSnapshot
    'Please enter snapshot name:':T view-as text size 45 by 1 at col 3 row 1.5
    cSnapshotName at row 2.5 col 3 no-label
    btnOk at row 4.5 col 16
    btnCancel at row 4.5 col 36
  with 1 down keep-tab-order overlay
    view-as dialog-box
    side-labels no-underline three-d 
    size 71 by 6.44
    title gcTitlePrefix + 'Add snapshot':T
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fSnapshot
  apply 'end-error' to self.

cSnapshotName = substitute('&1_&2':U,
                           phBuffer:table,
                           replace(string(time, 'HH:MM:SS':U),
                                   ':':U,
                                   '':U)).

update unless-hidden
  cSnapshotName
  btnOk
  btnCancel
  with frame fSnapshot
    in window phParentWindow.

run qg_AddSnapshot(phBuffer,
                   cSnapshotName,
                   pcWhere).

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AddTableSnapshot hQueryWindow 
PROCEDURE qg_AdoptLinkValues :
define input parameter phTargetBuffer as handle    no-undo.
define input parameter piTargetSeq    as integer   no-undo.

define variable cDatabaseName as character no-undo.
define variable hSourceBuffer as handle    no-undo.

define variable iField        as integer   no-undo.
define variable hSourceField  as handle    no-undo.
define variable hTargetField  as handle    no-undo.
define variable iIndex        as integer   no-undo.

define buffer bttQueryLink          for temp-table ttQueryLink.
define buffer bttQueryWindow        for temp-table ttQueryWindow.
define buffer bttTableRelationField for temp-table ttTableRelationField.
define buffer bttTableRelationView  for temp-table ttTableRelationView.


cDatabaseName = qg_cDatabaseNameForTableOrBuffer( phTargetBuffer ).

for each bttQueryLink
  where bttQueryLink.TargetSeq = piTargetSeq
  break by bttQueryLink.SourceSeq descending
  on error undo, throw:

  if first-of( bttQueryLink.SourceSeq ) then
  do:

    find bttQueryWindow
      where bttQueryWindow.QuerySeq = bttQueryLink.SourceSeq
      no-error.

    if available bttQueryWindow then
    do:

      hSourceBuffer = bttQueryWindow.QueryHandle:get-buffer-handle( string( bttQueryLink.BufferName ) ).

      if    not valid-handle( hSourceBuffer )
         or not hSourceBuffer:available then
        next.

      // Step one: copy fields that match by name.
      do iField = 1 to phTargetBuffer:num-fields:

        assign
          hTargetField = phTargetBuffer:buffer-field( iField )
          hSourceField = hSourceBuffer:buffer-field( hTargetField:name )
          no-error.

        if    error-status:error
           or not valid-handle( hSourceField )
           or hSourceField:data-type <> hTargetField:data-type
           or hSourceField:extent    <> hTargetField:extent then
          next.

        if hTargetField:name = substitute( '&1_Obj':U, phTargetBuffer:table ) then
          next.

        if    can-do( {&K_COMPANY_FIELDS}, hTargetField:name )
          and hTargetField:extent    = 0
          and hTargetField:data-type = 'character':U then
          hTargetField:buffer-value = qg_cGetCompany( phTargetBuffer:table,
                                                      hSourceField:buffer-value ).

        else
        do iIndex = hSourceField:extent to integer( hSourceField:extent > 0 ):

          hTargetField:buffer-value( iIndex ) = hSourceField:buffer-value( iIndex ).

        end.

      end.

      // Step two: copy fields that match by relation.
      for each bttTableRelationView
        where bttTableRelationView.DatabaseName       = cDatabaseName
          and bttTableRelationView.ReferenceTableName = phTargetBuffer:table
          and bttTableRelationView.RelatedTableName   = hSourceBuffer:table,
      each bttTableRelationField
        where bttTableRelationField.RelationId      = bttTableRelationView.RelationId
          and bttTableRelationField.ParentFieldName > '':U
          and bttTableRelationField.ChildFieldName  > '':U
        on error undo, throw:

        if bttTableRelationView.ReferenceTableName = hSourceBuffer:table then
          assign
            hSourceField = hSourceBuffer:buffer-field( bttTableRelationField.ChildFieldName )
            hTargetField = phTargetBuffer:buffer-field( bttTableRelationField.ParentFieldName )
            no-error.

        else
          assign
            hSourceField = hSourceBuffer:buffer-field( bttTableRelationField.ParentFieldName )
            hTargetField = phTargetBuffer:buffer-field( bttTableRelationField.ChildFieldName )
            no-error.

        if    valid-handle( hSourceField )
          and valid-handle( hTargetField ) then
        do iIndex = hSourceField:extent to integer( hSourceField:extent > 0 ):

          hTargetField:buffer-value( iIndex ) = hSourceField:buffer-value( iIndex ).

        end.

      end.

    end.

  end.

end.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_AdjustWidgetsSizeAndPos hQueryWindow 
PROCEDURE qg_AdjustWidgetsSizeAndPos :
/**
 * Adjust widget size and position.
 *
 * @param phWidget = Widget handle.
 * @param pdWidthDelta = Width delta.
 * @param pdHeightDelta = Height delta.
 */

define input parameter phWidget      as handle    no-undo.
define input parameter pdWidthDelta  as decimal   no-undo.
define input parameter pdHeightDelta as decimal   no-undo.

define variable hChild            as handle    no-undo.

define variable dOriginalCol      as decimal   no-undo.
define variable dOriginalRow      as decimal   no-undo.
define variable dOriginalWidth    as decimal   no-undo.
define variable dOriginalHeight   as decimal   no-undo.

define variable dColFactor        as decimal   no-undo.
define variable dRowFactor        as decimal   no-undo.
define variable dWidthFactor      as decimal   no-undo.
define variable dHeightFactor     as decimal   no-undo.
define variable dMaxHeight        as decimal   no-undo.
define variable dMaxRow           as decimal   no-undo.

define variable lSlimModeWidget   as logical   no-undo.

if can-query(phWidget, 'private-data':U) then
do:

  assign
    dOriginalCol    = qg_dParamListReadValue(phWidget:private-data, 'OriginalCol':U, ',':U)
    dOriginalRow    = qg_dParamListReadValue(phWidget:private-data, 'OriginalRow':U, ',':U)
    dOriginalWidth  = qg_dParamListReadValue(phWidget:private-data, 'OriginalWidth':U, ',':U)
    dOriginalHeight = qg_dParamListReadValue(phWidget:private-data, 'OriginalHeight':U, ',':U)
    dColFactor      = qg_dParamListReadValue(phWidget:private-data, 'ColFactor':U, ',':U)
    dRowFactor      = qg_dParamListReadValue(phWidget:private-data, 'RowFactor':U, ',':U)
    dWidthFactor    = qg_dParamListReadValue(phWidget:private-data, 'WidthFactor':U, ',':U)
    dHeightFactor   = qg_dParamListReadValue(phWidget:private-data, 'HeightFactor':U, ',':U)
    dMaxHeight      = qg_dParamListReadValue(phWidget:private-data, 'MaxHeight':U, ',':U)
    dMaxRow         = qg_dParamListReadValue(phWidget:private-data, 'MaxRow':U, ',':U)
    .

  if glSlimMode then
  do:

    lSlimModeWidget = qg_lParamListReadValue(phWidget:private-data, 'SlimModeWidget':U, ',':U).

    if lSlimModeWidget then
      assign
        dColFactor   = dColFactor * 2
        dWidthFactor = dWidthFactor * 2
        .

    else
      if not phWidget:name = ? then
        assign
          dOriginalCol = 1
          dOriginalRow = 1
          dColFactor   = 0
          dRowFactor   = 0
          .

  end.

  // Adjust widget size and position.
  assign
    phWidget:col          = dOriginalCol + (pdWidthDelta * dColFactor)
        when can-set(phWidget, 'col':U)
    phWidget:row          = dOriginalRow + (pdHeightDelta * dRowFactor)
        when can-set(phWidget, 'row':U)
    phWidget:width-chars  = dOriginalWidth + (pdWidthDelta * dWidthFactor)
        when can-set(phWidget, 'width-chars':U)
    phWidget:height-chars = dOriginalHeight + (pdHeightDelta * dHeightFactor)
        when can-set(phWidget, 'height-chars':U)
    .

  if dMaxRow > 0 then
    phWidget:row = minimum(dMaxRow, phWidget:row).

  if dMaxHeight > 0 then
    phWidget:height-chars = minimum(dMaxHeight, phWidget:height-chars).

  // Adjust side label position.
  if    can-query(phWidget, 'side-label-handle':U)
    and valid-handle(phWidget:side-label-handle)
    and can-query(phWidget:side-label-handle, 'private-data':U) then
  do:

    assign
      dRowFactor                     = (if pdHeightDelta <> 0 then
                                          (phWidget:row - dOriginalRow) / pdHeightDelta
                                        else
                                          dRowFactor)
      dOriginalCol                   = qg_dParamListReadValue(phWidget:side-label-handle:private-data, 'OriginalCol':U, ',':U)
      dOriginalRow                   = qg_dParamListReadValue(phWidget:side-label-handle:private-data, 'OriginalRow':U, ',':U)
      phWidget:side-label-handle:col = dOriginalCol + (pdWidthDelta * dColFactor)
          when can-set(phWidget:side-label-handle, 'col':U)
      phWidget:side-label-handle:row = dOriginalRow + (pdHeightDelta * dRowFactor)
          when can-set(phWidget:side-label-handle, 'row':U)
      .

    end.

end.

// Adjust children size and position recursively.
if    can-query(phWidget, 'first-child':U)
  and can-query(phWidget, 'next-sibling':U) then
do:

  hChild = phWidget:first-child.

  do while valid-handle(hChild):

    run qg_AdjustWidgetsSizeAndPos(hChild,
                                   pdWidthDelta,
                                   pdHeightDelta).

    hChild = hChild:next-sibling.

  end.

end.

assign
  phWidget:virtual-width-chars  = phWidget:width-chars
    when can-set(phWidget, 'virtual-width-chars':U)
  phWidget:virtual-height-chars = phWidget:height-chars
      when can-set(phWidget, 'virtual-height-chars':U)
  .

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_CloseInvalidQueryWindows hQueryWindow 
PROCEDURE qg_CloseInvalidQueryWindows :
/**
 * Close all query windows without buffers (because its db has been dis-
 * connected or the temp-table has been deletetd).
 */

define variable i       as integer   no-undo.
define variable hQuery  as handle    no-undo.
define variable hBuffer as handle    no-undo.

define buffer bttDatabase    for temp-table ttDatabase.
define buffer bttQueryWindow for temp-table ttQueryWindow.

for each bttQueryWindow
  on error undo, throw:

  hQuery = bttQueryWindow.QueryHandle.

  if   not valid-handle(hQuery)
    or hQuery:num-buffers = 0 then
    next.

  do i = 1 to hQuery:num-buffers:

    hBuffer = hQuery:get-buffer-handle(i).

    find bttDatabase
      where bttDatabase.DatabaseName = hBuffer:dbname
      no-error.

    if    available(bttDatabase)
      and bttDatabase.PhysicalDB
      and not can-find(first ttTable
                         where ttTable.DatabaseName = bttDatabase.DatabaseName) then
      run qg_AddTables(bttDatabase.DatabaseName).

    if    not can-find(first ttTable
                         where ttTable.DatabaseName = hBuffer:dbname
                           and ttTable.TableName    = hBuffer:table)
      and not can-find(first ttTable
                         where ttTable.TableHandle = hBuffer:table-handle) then
    do:

      run qg_QueryWindowClose(bttQueryWindow.WindowHandle, no).
      leave.

    end.

  end.

end.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_CloseWindow hQueryWindow 
PROCEDURE qg_CloseWindow :
/**
 * Close given window.
 *
 * This procedure is inteded to be used as a persistent trigger procedure
 * for dynamically created windows.
 *
 * @param phWindow = Window that should be closed.
 */

define input parameter phWindow as handle    no-undo.

if valid-handle(phWindow) then
  apply 'window-close':U to phWindow.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_CompareText hQueryWindow 
PROCEDURE qg_CompareText :
define input parameter pcTitle1        as character no-undo.
define input parameter pclText1        as longchar  no-undo.

define input parameter pcTitle2        as character no-undo.
define input parameter pclText2        as longchar  no-undo.

define input parameter plCaseSensitive as logical   no-undo.
define input parameter plReadOnly      as logical   no-undo.

define variable i                as integer   no-undo.

define variable cCompFile1       as character no-undo.
define variable cCompFile2       as character no-undo.

define variable chTextComparison as com-handle no-undo.
define variable iMergeIgnoreCase as integer   no-undo.

if not valid-handle(gchMerge) then
  leave.

do while yes:

  assign
    i          = i + 1
    cCompFile1 = qg_cFileName(substitute('%Temp%\qg_comp&1.1.txt':U, string(i)))
    cCompFile2 = qg_cFileName(substitute('%Temp%\qg_comp&1.2.txt':U, string(i)))
    .

  file-info:file-name = cCompFile1.

  if file-info:full-pathname <> ? then
    next.

  file-info:file-name = cCompFile2.

  if file-info:full-pathname <> ? then
    next.

  leave.

end.

copy-lob pclText1 to file cCompFile1.
copy-lob pclText2 to file cCompFile2.

assign
  iMergeIgnoreCase = gchMerge:Preferences:longs:item('clIgnoreCase':U)
  gchMerge:Preferences:longs:item('clIgnoreCase':U) = integer(not plCaseSensitive)
  .

chTextComparison = gchMerge:TextComparison.

chTextComparison:compare(cCompFile1, cCompFile2).

assign
  chTextComparison:ReadOnly(0) = plReadOnly
  chTextComparison:ReadOnly(1) = plReadOnly
  .

if    pcTitle1 <> ?
  and pcTitle2 <> ? then
  chTextComparison:SetPanelTitles(pcTitle1, pcTitle2).

gchMerge:Preferences:longs:item('clIgnoreCase':U) = iMergeIgnoreCase.

chTextComparison:GiveUserControl().

gchMerge:visible = yes.
gchMerge:active = yes.

gchMerge:GiveUserControl().

finally:

  if valid-handle(chTextComparison) then
  do:

    release object chTextComparison.
    chTextComparison = ?.

  end.

  if cCompFile1 > '':U then
    os-delete value(cCompFile1).

  if cCompFile2 > '':U then
    os-delete value(cCompFile2).

end finally.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_ConfirmRecordChanges hQueryWindow 
PROCEDURE qg_ConfirmRecordChanges :
/**
 * Show a confirmation dialog to confirm any changes to a record.
 *
 * @param pcTitle = Title string for the dialog.
 * @param pcText = Text to display on the dialog.
 * @param phOldBuffer = Buffer handle of the buffer before any changes.
 * @param phNewBuffer = Buffer handle of the buffer that contains the changes.
 * @param phParentWindow = Parent window to show the dialog.
 * @param oplOk = Output flag. True if the user clicked the ok button - otherwise false.
 * @param oplDisableTriggers = Output flag. True if the user chose to disable the triggers - otherwise false.
 */

define input        parameter pcTitle             as character no-undo.
define input        parameter pcText              as character no-undo.
define input        parameter phOldBuffer         as handle    no-undo.
define input        parameter phNewBuffer         as handle    no-undo.
define input        parameter plCanEnableTriggers as logical   no-undo.
define input        parameter plRawValues         as logical   no-undo.
define input        parameter phParentWindow      as handle    no-undo.

define       output parameter oplOk               as logical   no-undo.
define input-output parameter ioplDisableTriggers as logical   no-undo.

define variable i                 as integer   no-undo.

define variable hOldField         as handle    no-undo.
define variable clOldFieldValue   as longchar  no-undo.
define variable hNewField         as handle    no-undo.
define variable clNewFieldValue   as longchar  no-undo.
define variable cFieldList        as character no-undo.
define variable cFieldName        as character no-undo.
define variable iIndex            as integer   no-undo.

define variable cText as character no-undo
  format 'x(150)':U
  view-as text
  size 156 by 1.

define query brRecordBrowse
  for ttQueryWindowFieldChanges
  scrolling.

define browse brRecordBrowse
  query brRecordBrowse no-lock
    display
      ttQueryWindowFieldChanges.DisplayName
      ttQueryWindowFieldChanges.OldDisplayValue
      ttQueryWindowFieldChanges.CurrentDisplayValue
      with no-assign size 156 by 18.

define variable lDisableTriggers as logical no-undo
  format 'yes/no':U
  label 'disable triggers':T
  view-as toggle-box
  size 50 by 1.

define rectangle reDisableTriggers
  no-fill
  edge-pixels 2
  graphic-edge
  size 156 by 2
  .

define button btnOk
  label 'Save':T4
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T6
  size 20 by 1.14
  auto-end-key.

define buffer bttQueryWindowFieldChanges for temp-table ttQueryWindowFieldChanges.

define frame fConfirmRecordChanges
  cText at row 1.5 col 3 no-label
  brRecordBrowse at row 3 col 3
  reDisableTriggers at row 21.5 col 3
  lDisableTriggers at row 22 col 5
  btnOk at row 24.5 col 61
  btnCancel at row 24.5 col 81
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 161 by 26.44
    title '':T
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fConfirmRecordChanges
  apply 'end-error' to self.

on t of frame fConfirmRecordChanges anywhere
do:

  if lDisableTriggers:sensitive then
    lDisableTriggers:checked = not lDisableTriggers:checked.

end.

cFieldList = qg_cBufferCompare(phOldBuffer, phNewBuffer).

if num-entries(cFieldList) = 0 then
  leave.

empty temp-table ttQueryWindowFieldChanges.

do i = 1 to num-entries(cFieldList):

  assign
    cFieldName = qg_cExtractFieldName(entry(i, cFieldList))
    iIndex     = qg_iExtractIndex(entry(i, cFieldList))
    hOldField  = phOldBuffer:buffer-field(cFieldName)
    hNewField  = phNewBuffer:buffer-field(cFieldName)
    .

  create bttQueryWindowFieldChanges.

  assign
    bttQueryWindowFieldChanges.FieldName   = cFieldName
    bttQueryWindowFieldChanges.FieldIndex  = iIndex
    bttQueryWindowFieldChanges.DisplayName = qg_cFormattedFieldName(?,
                                                                    ?,
                                                                    cFieldName,
                                                                    iIndex)
    .

  if lookup(hNewField:data-type, 'CLOB,BLOB':U) = 0 then
  do:

    if plRawValues  then
      assign
        bttQueryWindowFieldChanges.OldDisplayValue     = hOldField:buffer-value(iIndex)
        bttQueryWindowFieldChanges.CurrentDisplayValue = hNewField:buffer-value(iIndex)
        .

    else
      assign
        bttQueryWindowFieldChanges.OldDisplayValue     = hOldField:string-value(iIndex)
        bttQueryWindowFieldChanges.CurrentDisplayValue = hNewField:string-value(iIndex)
        .

  end.

  else
  do:

    copy-lob hOldField:buffer-value(iIndex) to clOldFieldValue.
    copy-lob hNewField:buffer-value(iIndex) to clNewFieldValue.

    assign
      bttQueryWindowFieldChanges.OldDisplayValue     = substring(clOldFieldValue, 1, 255)
      bttQueryWindowFieldChanges.CurrentDisplayValue = substring(clnewFieldValue, 1, 255)
      .

  end.

  validate bttQueryWindowFieldChanges.

end.

run qg_InitBrowse(browse brRecordBrowse:handle).

assign
  cText                             = pcText
  frame fConfirmRecordChanges:title = gcTitlePrefix + pcTitle
  lDisableTriggers                  = ioplDisableTriggers
  brRecordBrowse:num-locked-columns in frame fConfirmRecordChanges             = 1
  ttQueryWindowFieldChanges.DisplayName:width in browse brRecordBrowse         = 39
  ttQueryWindowFieldChanges.OldDisplayValue:width in browse brRecordBrowse     = 56
  ttQueryWindowFieldChanges.CurrentDisplayValue:width in browse brRecordBrowse = 56
  .

if    lDisableTriggers
  and not plCanEnableTriggers then
  assign
    lDisableTriggers:bgcolor  in frame fConfirmRecordChanges = 12
    reDisableTriggers:filled  in frame fConfirmRecordChanges = yes
    reDisableTriggers:bgcolor in frame fConfirmRecordChanges = 12
    .

open query brRecordBrowse
  for each ttQueryWindowFieldChanges
    no-lock.

display unless-hidden
  lDisableTriggers
  with frame fConfirmRecordChanges
    in window phParentWindow. 

update unless-hidden
  cText
  brRecordBrowse
  lDisableTriggers when plCanEnableTriggers
  btnOk
  btnCancel
  with frame fConfirmRecordChanges
    in window phParentWindow. 

assign
  oplOk               = yes
  ioplDisableTriggers = input frame fConfirmRecordChanges lDisableTriggers
  .

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_ConfirmTriggerChanges hQueryWindow 
PROCEDURE qg_ConfirmTriggerChanges :
/**
 * Show a confirmation dialog to confirm deletion to a record.
 *
 * @param pcTitle = Title string for the dialog.
 * @param pcText = Text to display on the dialog.
 * @param plCanEnableTriggers = If false the "disable triggers" toggle box is disabled.
 * @param phParentWindow = Parent window to show the dialog.
 * @param oplOk = Output flag. True if the user clicked the ok button - otherwise false.
 * @param ioplDisableTriggers = Output flag. True if the user chose to disable the triggers - otherwise false.
 */

define input        parameter pcTitle             as character no-undo.
define input        parameter pcText              as character no-undo.
define input        parameter pcButtonLabel       as character no-undo.
define input        parameter plCanEnableTriggers as logical   no-undo.
define input        parameter phParentWindow      as handle    no-undo.

define       output parameter oplOk               as logical   no-undo.
define input-output parameter ioplDisableTriggers as logical   no-undo.

define variable cText as character no-undo
  format 'x(100)':U
  view-as text
  size 100 by 1.

define variable lDisableTriggers as logical no-undo
  format 'yes/no':U
  label 'disable triggers':T
  view-as toggle-box
  size 20 by 1.

define rectangle reDisableTriggers
  no-fill
  edge-pixels 2
  graphic-edge
  size 105 by 2
  .

define button btnOk
  label 'Ok':T6
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T6
  size 20 by 1.14
  auto-end-key.

define frame fConfirmTriggerChanges
  cText at row 1.5 col 3 no-label
  reDisableTriggers at row 3 col 3
  lDisableTriggers at row 3.5 col 5
  btnOk at row 6 col 36
  btnCancel at row 6 col 56
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 110 by 7.94
    title '':T
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fConfirmTriggerChanges
  apply 'end-error' to self.

on t of frame fConfirmTriggerChanges anywhere
do:

  if lDisableTriggers:sensitive then
    lDisableTriggers:checked = not lDisableTriggers:checked.

end.

assign
  frame fConfirmTriggerChanges:title          = gcTitlePrefix + pcTitle
  lDisableTriggers                            = ioplDisableTriggers
  btnOk:label in frame fConfirmTriggerChanges = pcButtonLabel
  cText                                       = pcText
  .

if    lDisableTriggers
  and not plCanEnableTriggers then
  assign
    lDisableTriggers:bgcolor  in frame fConfirmTriggerChanges = 12
    reDisableTriggers:filled  in frame fConfirmTriggerChanges = yes
    reDisableTriggers:bgcolor in frame fConfirmTriggerChanges = 12
    .

display unless-hidden
  lDisableTriggers
  with frame fConfirmTriggerChanges
    in window phParentWindow. 

update unless-hidden
  cText
  lDisableTriggers when plCanEnableTriggers
  btnOk
  btnCancel
  with frame fConfirmTriggerChanges
    in window phParentWindow. 

assign
  oplOk               = yes
  ioplDisableTriggers = input frame fConfirmTriggerChanges lDisableTriggers
  .

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_CopyQueryGeneratorSource Method-Library
procedure qg_CopyQueryGeneratorSource :
define variable clSourceContent as longchar  no-undo.

fix-codepage ( clSourceContent ) = 'UTF-8':U.

copy-lob
  from file this-procedure:file-name
  to clSourceContent
  .

run qg_WriteLongcharToClipboard( clSourceContent ).

end procedure.


/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_CopyQueryGeneratorSourcefilePath Method-Library
procedure qg_CopyQueryGeneratorSourcefilePath :
clipboard:value = search( this-procedure:file-name ).

end procedure.


/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_CreateBuffer hQueryWindow 
PROCEDURE qg_CreateBuffer :
/**
 * Create a record for given buffer.
 *
 * @param phBuffer = Buffer for the new record.
 * @param plDisableTriggers = Flag to indicate if create triggers should be disabled.
 */

define input parameter phBuffer          as handle    no-undo.
define input parameter plDisableTriggers as logical   no-undo.

if plDisableTriggers then
  phBuffer:disable-load-triggers(no).

phBuffer:buffer-create().

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_CreateBufferButtonMenu hQueryWindow 
PROCEDURE qg_CreateBufferButtonMenu :
/**
 * Create popup menu for buffer name buttons.
 *
 * @param phButton = Button handle.
 * @param pcBufferPattern = Buffer pattern for this button.
 * @param pcLabelPattern = Buffer label pattern for this button.
 */

define input parameter phButton        as handle    no-undo.

define input parameter pcBufferPattern as character no-undo.
define input parameter pcLabelPattern  as character no-undo.

define variable i     as integer   no-undo.
define variable hTemp as handle    no-undo.

create menu hTemp
  assign
    name       = substitute('m_&1PopupMenu':U, phButton:name)
    popup-only = yes
    sensitive  = yes
    .

phButton:popup-menu = hTemp.

do i = 1 to {&K_NUM_BUFFER_PATTERN_INDICES}:

  create menu-item hTemp
    assign
      name         = substitute('mi_&1_&2':U, phButton:name, string(i))
      parent       = phButton:popup-menu
      label        = qg_cSubstituteChar(pcLabelPattern, '#':U, string(i))
      sensitive    = yes
    triggers:
      on choose
        persistent run qg_SetBufferPattern in target-procedure
                         (pcBufferPattern, i).
    end triggers
    .

end.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_CreateTableClone hQueryWindow 
PROCEDURE qg_CreateTableClone :
/**
 * Create a temp table like given table and copy over all records.
 *
 * Can not be a function due to use of "process events" which might not be
 * allowed in a user defined function (Progrerss error 5622).
 *
 * @param phTable = Table handle or buffer handle of table that should be cloned.
 * @param pcTableName = New table name that should be used for the clone.
 * @param pcWhere = Where condition of records that should be copied (or blank for all records).
 * @param pcStatusText = Status text that should be used for the progress status dialog.
 * @param ophTable = Handle of the new temp-table clone.
 */

define input  parameter phTable      as handle    no-undo.
define input  parameter pcTableName  as character no-undo.
define input  parameter pcWhere      as character no-undo.
define input  parameter pcStatusText as character no-undo.
define output parameter ophTable     as handle    no-undo.

define variable cDatabaseName     as character no-undo.
define variable lPhysicalDatabase as logical   no-undo.
define variable hQuery            as handle    no-undo.
define variable hSourceBuffer     as handle    no-undo.
define variable hTargetBuffer     as handle    no-undo.

define variable cQueryText        as character no-undo.

define variable i                 as integer   no-undo.

if    pcStatusText > '':U then
do:

  display unless-hidden
    substitute('&1 ...':T, pcStatusText)
      @ gcStatusText120
    with frame fStatus
      no-labels
      overlay
      color messages
      centered
      view-as dialog-box
      width 125
      .
  process events.

end.

// Create temp-table like parameter table.
assign
  cDatabaseName     = qg_cDatabaseNameForTableOrBuffer( phTable )
  lPhysicalDatabase = qg_lIsPhysicalDatabase( cDatabaseName ).
  .

create temp-table ophTable in widget-pool qg_cTTWidgetPool().

ophTable:create-like(phTable).

if lPhysicalDatabase then

  run qg_AddVirtualFieldsToTempTable( cDatabaseName,
                                      phTable:name,
                                      ophTable ).

ophTable:temp-table-prepare(pcTableName).

// Copy parameter table to new temp-table.
create query hQuery.

create buffer hSourceBuffer for table phTable buffer-name phTable:name.
create buffer hTargetBuffer for table ophTable.

hQuery:add-buffer(hSourceBuffer).

assign
  pcWhere    = trim(pcWhere)
  cQueryText = (if pcWhere begins 'for':U then
                  pcWhere
                else if pcWhere begins 'where':U then
                  substitute('for each &1 &2':U,
                             hSourceBuffer:name,
                             pcWhere)
                else if pcWhere > '':U then
                  substitute('for each &1 where &2':U,
                             hSourceBuffer:name,
                             pcWhere)
                else
                  substitute('for each &1':U,
                             hSourceBuffer:name))
  .

hQuery:query-prepare(cQueryText).
hQuery:query-open().

hQuery:get-first().

do while not hQuery:query-off-end:

  i = i + 1.

  if    pcStatusText > '':U
    and i mod 5000   = 0 then
  do:

    display unless-hidden
      substitute('&1 (&2 records) ...':T,
                 pcStatusText,
                 trim(string(i, {&K_MAX_INT64_FORMAT})))
        @ gcStatusText120
      with frame fStatus
        no-labels
        overlay
        color messages
        centered
        view-as dialog-box
        width 125
        .
    process events.

  end.

  hTargetBuffer:buffer-create().

  hTargetBuffer:buffer-copy(hSourceBuffer).

  if lPhysicalDatabase then

    run qg_BufferCopyVirtualFieldsFromPhysicalBufferToTempTableBuffer
          ( cDatabaseName,
            hSourceBuffer,
            hTargetBuffer ).

  hTargetBuffer:buffer-validate().

  hQuery:get-next().

end.

finally:

  if valid-handle(hQuery) then
    delete object hQuery.

  if valid-handle(hSourceBuffer) then
    delete object hSourceBuffer.

  if valid-handle(hTargetBuffer) then
    delete object hTargetBuffer.

end finally.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_DeleteFile Method-Library
procedure qg_DeleteFile :
define input parameter pcFilename as character no-undo.

define variable cFilename as character no-undo.
define variable lOk       as logical   no-undo.

assign
  pcFilename          = qg_cFileName(pcFilename)
  file-info:file-name = pcFilename
  .

if file-info:full-pathname = ? then
  message
    substitute('File ~'&1~' does not exist.':T, pcFilename)
    view-as alert-box
    warning
    buttons ok.

else
do:

  message
    substitute('Do you really want to irrevocably delete File ~'&1~'?':T,
               pcFilename)
    view-as alert-box
    question
    buttons yes-no
    update lOk.

  if not lOk then
    leave.

  os-delete value(pcFilename).

  if    os-error <> 0
    and os-error <> 2 then
    message
      substitute('File ~'&1~' could not be deleted!':T, pcFilename)
      view-as alert-box
      error
      buttons ok.

  else
    message
      substitute('File ~'&1~' has been deleted!':T, pcFilename)
      view-as alert-box
      information
      buttons ok.

end.

end procedure.


/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_DeleteFieldOverlay Method-Library
procedure qg_DeleteFieldOverlay :
define input parameter phOwner      as handle    no-undo.
define input parameter pcBufferName as character no-undo.
define input parameter pcFieldName  as character no-undo.
define input parameter piFieldIndex as integer   no-undo.

define buffer bttFieldOverlay                 for temp-table ttFieldOverlay.

define buffer bttQueryWindowQueryBrowseColumn for temp-table ttQueryWindowQueryBrowseColumn.

find bttFieldOverlay
  where bttFieldOverlay.OwnerHandle = phOwner
    and bttFieldOverlay.BufferName  = pcBufferName
    and bttFieldOverlay.FieldName   = pcFieldName
    and bttFieldOverlay.FieldIndex  = piFieldIndex
  no-error.

if not available bttFieldOverlay then
  leave.

if valid-handle(bttFieldOverlay.OverlayBufferHandle) then
  delete object bttFieldOverlay.OverlayBufferHandle no-error.

if valid-handle(bttFieldOverlay.OverlayColumnHandle) then
  delete object bttFieldOverlay.OverlayColumnHandle no-error.

for each bttQueryWindowQueryBrowseColumn
  where bttQueryWindowQueryBrowseColumn.ColumnHandle = bttFieldOverlay.OverlayColumnHandle:

  delete bttQueryWindowQueryBrowseColumn.

end.

delete bttFieldOverlay.

end procedure.


/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_DeleteTextLines hQueryWindow 
PROCEDURE qg_DeleteTextLines :
/**
 * Inserts given Text after line of given offset index.
 *
 * @param pcLine = Text that should be inserted.
 * @param piOffset = offset of the line after that the text should be inserted.
 * @param pcText = Text in which the line should be inser- ted.
 * @param opiLine = Line number of the inserted line.
 */

define input        parameter piOffsetStart as integer   no-undo.
define input        parameter piOffsetEnd   as integer   no-undo.
define input-output parameter pcText        as character no-undo.
define       output parameter opiLine       as integer   no-undo.

define variable i               as integer   no-undo.
define variable iOffset         as integer   no-undo initial 1.
define variable iLineEndOffset  as integer   no-undo.

define variable iStartOffset    as integer   no-undo.
define variable iEndOffset      as integer   no-undo.

define variable iLineCount      as integer   no-undo.

if length(pcText) = 0 then
  opiLine = 1.

else
do:

  do i = 1 to num-entries(pcText, '~n':U):

    iLineEndOffset = iOffset + length(entry(i, pcText, '~n':U)).

    if    iOffset        <= piOffsetStart
      and iLineEndOffset >= piOffsetStart then
      assign
        iStartOffset = iOffset
        opiLine      = i
        .

    if    iOffset        <= piOffsetEnd
      and iLineEndOffset >= piOffsetEnd then
    do:

      iEndOffset = iLineEndOffset + length('~n':U).
      leave.

    end.

    iOffset = iLineEndOffset + length('~n':U). 

  end.

  if    iStartOffset > 0
    and iEndOffset  >= iStartOffset then
  do:

    assign
      pcText     = substitute('&1&2':U,
                              substring(pcText, 1, iStartOffset - 1),
                              substring(pcText, iEndOffset))
      iLineCount = max(1, num-entries(pcText, '~n':U))
      .

    if opiLine > iLineCount then
      opiLine = iLineCount.

    if    opiLine = iLineCount
      and opiLine > 1
      and length(entry(opiLine, pcText, '~n':U)) = 0 then
      opiLine = opiLine - 1.

  end.

end.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_DeleteWidgetTree hQueryWindow 
PROCEDURE qg_DeleteWidgetTree :
/**
 * Delete a tree of widgets with a parent child relation recursively.
 *
 * @param phParent = Handle of the Widget that should be deleted.
 * @param plDeleteParent = Delete given parent as well.
 */

define input parameter phParent       as handle    no-undo.
define input parameter plDeleteParent as logical   no-undo.

define variable i          as integer   no-undo.
define variable hChild     as handle    no-undo.
define variable hNextChild as handle    no-undo.

if valid-handle(phParent) then
do:

  if can-query(phParent, 'first-child':U) then
  do:

    hChild = phParent:first-child.

    do while valid-handle(hChild):

      hNextChild = hChild:next-sibling.

      run qg_DeleteWidgetTree(hChild, yes).

      hChild = hNextChild.

    end.

  end.

  if phParent:type = 'QUERY' then
  do i = 1 to phParent:num-buffers:
    run qg_DeleteWidgetTree(phParent:get-buffer-handle(i), yes).
  end.

  if phParent:type = 'BROWSE' then
    run qg_DeleteWidgetTree(phParent:query, yes).

  if can-query(phParent, 'menu-bar':U) then
    run qg_DeleteWidgetTree(phParent:menu-bar, yes).

  if can-query(phParent, 'popup-menu':U) then
    run qg_DeleteWidgetTree(phParent:popup-menu, yes).

  if    plDeleteParent
    and ( not can-query(phParent, 'dynamic':U)
       or phParent:dynamic ) then
    delete object phParent no-error.

end.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_DropDownWindow hQueryWindow 
PROCEDURE qg_DropDownWindow :
define input parameter phWindow             as handle    no-undo.
define input parameter phButton             as handle    no-undo.
define input parameter piPreferredDirection as integer   no-undo.

define variable iHwnd     as int64   no-undo.
define variable iDummy    as integer   no-undo.

define variable iButtonX1 as integer   no-undo.
define variable iButtonY1 as integer   no-undo.
define variable iButtonX2 as integer   no-undo.
define variable iButtonY2 as integer   no-undo.

define variable iWindowX1 as integer   no-undo.
define variable iWindowY1 as integer   no-undo.
define variable iWindowX2 as integer   no-undo.
define variable iWindowY2 as integer   no-undo.

define variable iRelWinX  as integer   no-undo.
define variable iRelWiny  as integer   no-undo.


// Sometimes the hwnd attribute is only set after the window was schown. So
// as a workaround we have no other choice but to show it for a short moment
// because we need the hwnd before the window is actually displayed.

if phWindow:hwnd = ? then
  assign
    phWindow:hidden = no
    phWindow:hidden = yes
    .

// Get correct window handle.
if phWindow:type = 'WINDOW':U then
  run GetParent(phWindow:hwnd, output iHwnd).

// Set window style.
run SetWindowLongA(iHwnd,
                   {&K_WIN_CONST_GWL_STYLE},
                   {&K_WIN_CONST_WS_POPUP} + {&K_WIN_CONST_WS_BORDER},
                   output iDummy).

// Position window exactly next to the button.
run qg_GetWindowRect(phButton,
                     output iButtonX1,
                     output iButtonY1,
                     output iButtonX2,
                     output iButtonY2).

assign
  iRelWinX = (if    piPreferredDirection = {&K_DIRECTION_RIGHT}
                and iButtonX1 + phWindow:width-pixels <= session:width-pixels then
                iButtonX1
              else if    piPreferredDirection = {&K_DIRECTION_LEFT}
                     and iButtonX2 - phWindow:width-pixels > 0 then
                iButtonX2 - phWindow:width-pixels
              else if iButtonX1 + phWindow:width-pixels <= session:width-pixels then
                iButtonX1
              else
                iButtonX2 - phWindow:width-pixels)
  iRelWiny = (if iButtonY2 + phWindow:height-pixels <= session:height-pixels then
                iButtonY2
              else
                iButtonY1 - phWindow:height-pixels)
  .

run SetWindowPos(iHwnd,
                 0,
                 iRelWinX,
                 iRelWiny,
                 phWindow:width-pixels,
                 phWindow:height-pixels,
                 {&K_WIN_CONST_SWP_FRAMECHANGED},
                 output iDummy).

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_DuplicateTextLines hQueryWindow 
PROCEDURE qg_DuplicateTextLines :
/**
 * Duplicate text lines.
 *
 * @param piOffsetStart = Selection Start.
 * @param piOffsetEnd = Selection end.
 * @param plDown = If yes then duplicate downwards. Otherwise duplicate upwards.
 * @param pcText = Text in which the line should be duplicated.
 * @param opiLine = Line number of the duplicated lines.
 */

define input        parameter piOffsetStart as integer   no-undo.
define input        parameter piOffsetEnd   as integer   no-undo.
define input        parameter plDown        as logical   no-undo.
define input-output parameter pcText        as character no-undo.
define       output parameter opiLine       as integer   no-undo.

define variable i               as integer   no-undo.
define variable iOffset         as integer   no-undo initial 1.
define variable iLineEndOffset  as integer   no-undo.

define variable iStartOffset    as integer   no-undo.
define variable iEndOffset      as integer   no-undo.

define variable cLines          as character no-undo.

do i = 1 to num-entries(pcText, '~n':U):

  iLineEndOffset = iOffset + length(entry(i, pcText, '~n':U)).

  if    iOffset        <= piOffsetStart
    and iLineEndOffset >= piOffsetStart then
  do:

    iStartOffset = iOffset.

    if not plDown then
      opiLine = i.

  end.

  if    iOffset        <= piOffsetEnd
    and iLineEndOffset >= piOffsetEnd then
  do:

    iEndOffset = iLineEndOffset + length('~n':U).

    if plDown then
      opiLine = i.

    leave.

  end.

  iOffset = iLineEndOffset + length('~n':U). 

end.

if    iStartOffset > 0
  and iEndOffset  >= iStartOffset then
do:

  assign
    cLines     = substring(pcText, iStartOffset, iEndOffset - iStartOffset).
    pcText     =   substring(pcText, 1, iEndOffset - 1)
                 + (if iEndOffset > length(pcText)
                      and not pcText matches '*~n':U then
                      '~n':U
                    else
                      '':U)
                 + cLines
                 + substring(pcText, iEndOffset)
                 .

  if plDown then
    opiLine = opiLine + 1.

end.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_EditFieldValue hQueryWindow 
PROCEDURE qg_EditFieldValue :
/**
 * Shows a dialog to edit the value of a single table field.
 *
 * @param phField = Field handle of the field that should be edited.
 * @param piIndex = Extent index of the field value that should be edited.
 * @param plEditMode = If yes then editmode is enabled.
 * @param plRawValue = Indicates whether format should be applied. If no format should be applied then an editor widget will be used regardless of the field datatype.
 * @param phParentWindow = Parent window handle for the dialog.
 */

define input        parameter pcFieldName as character no-undo.
define input        parameter pcDataType     as character no-undo.
define input        parameter pcFormat       as character no-undo.
define input        parameter pcViewAs       as character no-undo.
define input        parameter plEditor       as logical   no-undo.
define input        parameter plEditMode     as logical   no-undo.
define input-output parameter ioplcValue     as longchar  no-undo.
define input        parameter phParentWindow as handle    no-undo.

define variable lEditor      as logical   no-undo.
define variable hFieldWidget as handle    no-undo.

define button btnOk
  label 'Ok':T2
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.

define frame fEditFieldValue
    btnOk at row 3.5 col 21
    btnCancel at row 3.5 col 41
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 81 by 5.44
    title '':T
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fEditFieldValue
  apply 'end-error' to self.

lEditor = (   plEditor
           or pcDataType       = 'CLOB':U
           or ( pcDataType     = 'character':U
            and pcViewAs matches '*editor*':U)).

if not lEditor then
do:

  create fill-in hFieldWidget
    assign
      name            = 'xFieldWidget':U
      frame           = frame fEditFieldValue:handle
      data-type       = pcDataType
      format          = pcFormat
      width           = 76
      height          = 1
      row             = 1.5
      col             = 3
      sensitive       = yes
      .

end.

else
do:

  create editor hFieldWidget
    assign
      name                 = 'xFieldWidget':U
      frame                = frame fEditFieldValue:handle
      width                = 126
      height               = 15
      row                  = 1.5
      col                  = 3
      word-wrap            = no
      scrollbar-horizontal = yes
      scrollbar-vertical   = yes
      sensitive            = yes
      return-inserted      = yes
      .

  assign
    frame fEditFieldValue:height             = frame fEditFieldValue:height + 14
    frame fEditFieldValue:width              = frame fEditFieldValue:width + 50
    btnOk:row     in frame fEditFieldValue   = btnOk:row in frame fEditFieldValue + 14
    btnOk:col     in frame fEditFieldValue   = btnOk:col in frame fEditFieldValue + 25
    btnCancel:row in frame fEditFieldValue   = btnCancel:row in frame fEditFieldValue + 14
    btnCancel:col in frame fEditFieldValue   = btnCancel:col in frame fEditFieldValue + 25
    .

end.

hFieldWidget:screen-value = (if lEditor then
                               ioplcValue
                             else
                              string(ioplcValue)).

if plEditMode then
  frame fEditFieldValue:title = substitute('&1Edit Value (&2)':T,
                                           gcTitlePrefix,
                                           pcFieldName).

else
  assign
    btnCancel:label in frame fEditFieldValue = 'Close':T
    btnCancel:col   in frame fEditFieldValue = btnCancel:col - 10
    btnOk:hidden    in frame fEditFieldValue = yes
    frame fEditFieldValue:title              = substitute('&1Value details (&2)':T,
                                                          gcTitlePrefix,
                                                          pcFieldName)
    hFieldWidget:read-only                   = yes
    .

// We do not use the update statement because we would not be able to set the
// focus to the input widget. Instead we use display and wait-for.
assign
  btnOk:sensitive     in frame fEditFieldValue = yes /* code checked by mth */
  btnCancel:sensitive in frame fEditFieldValue = yes /* code checked by mth */
  .

display unless-hidden
  btnOk
  btnCancel
  with frame fEditFieldValue
    in window phParentWindow. 

if plEditMode then
  apply 'entry':U to hFieldWidget.

wait-for go of frame fEditFieldValue.

if plEditMode then
  ioplcValue = (if pcDataType = 'CLOB':U then
                  hFieldWidget:input-value
                else
                  string(hFieldWidget:input-value)).


finally:
  if valid-handle(hFieldWidget) then
    delete object hFieldWidget.
end finally.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_EditRecord hQueryWindow 
PROCEDURE qg_EditRecord :
/**
 * Shows a dialog that contains all fields and values of the given record and
 * offers the option to edit field values.
 *
 * @param phBuffer = Buffer handle of the record that should be edited.
 * @param piEditAction = Action that should be performed: - {&K_EDITACTION_EDIT} - {&K_EDITACTION_CREATE} - {&K_EDITACTION_DUPLICATE}
 * @param plEditMode = If yes then editmode is enabled.
 * @param phParentWindow = Parent window for the dialog.
 * @param pcFieldList = List/order of browse fields
 * @param oprRowid = Rowid of the edited or created record.
 */

define input  parameter phBuffer       as handle    no-undo.
define input  parameter piEditAction   as integer   no-undo.
define input  parameter plEditMode     as logical   no-undo.
define input  parameter phParentWindow as handle    no-undo.
define input  parameter pcFieldList    as character no-undo.
define output parameter oprRowid       as rowid     no-undo.

define variable hLockBuffer            as handle    no-undo.
define variable hDataset               as handle    no-undo.
define variable hTempTable             as handle    no-undo.
define variable hTempTableBuffer       as handle    no-undo.
define variable hTempTableBeforeBuffer as handle    no-undo.
define variable iField                 as integer   no-undo.
define variable hField                 as handle    no-undo.

define variable cDatabaseName          as character no-undo.

define variable lOk                    as logical   no-undo.
define variable lDisableTriggers       as logical   no-undo.

define variable lBrowseFields as logical no-undo
  format 'yes/no':U
  view-as radio-set
    radio-buttons
      'Browse fields':T, yes,
      'All fields':T, no
    horizontal
  size 35 by 1.

define variable lRawValues as logical no-undo
  format 'yes/no':U
  view-as radio-set
    radio-buttons
      'Formatted values':T, no,
      'Raw values':T, yes
    horizontal
  size 40 by 1.

define query brRecordBrowse
  for ttQueryWindowField
  scrolling.

define browse brRecordBrowse
  query brRecordBrowse no-lock
    display
      ttQueryWindowField.DisplayName
      ttQueryWindowField.FieldLabel
      ttQueryWindowField.CurrentDisplayValue label 'Value':T
      with no-assign size 156 by 19.5.

if plEditMode then
  define button btnOk
    label 'Ok':T2
    size 20 by 1.14
    auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.

define menu m_PopupMenu
  menu-item mi_CopyFieldValue
    label "Copy Value"
  rule
  menu-item mi_EditFieldValue
    label 'Edit Value':T
  menu-item mi_AdoptExternalValue
    label 'Adopt External Value':T
    .

define buffer bttTable            for temp-table ttTable.
define buffer bttField            for temp-table ttField.

define buffer bttQueryWindow      for temp-table ttQueryWindow.
define buffer bttQueryWindowField for temp-table ttQueryWindowField.

define frame fEditRecord
  lBrowseFields at row 1.5 col 3 no-label
  lRawValues at row 1.5 col 3 no-label
  brRecordBrowse at row 3 col 3
  btnOk at row 23.5 col 61
  btnCancel at row 23.5 col 81
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 161 by 25.44
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fEditRecord
  apply 'end-error' to self.

on off-home of brRecordBrowse in frame fEditRecord
do:
  apply 'entry':U to lBrowseFields in frame fEditRecord.
  return no-apply.
end.

on cursor-down of lBrowseFields in frame fEditRecord
do:
  apply 'entry':U to brRecordBrowse in frame fEditRecord.
  return no-apply.
end.

on cursor-down of lRawValues in frame fEditRecord
do:
  apply 'entry':U to brRecordBrowse in frame fEditRecord.
  return no-apply.
end.

on value-changed of lBrowseFields in frame fEditRecord
do:

  if lBrowseFields:hidden in frame fEditRecord then
    lBrowseFields = no.

  else
    assign
      lBrowseFields  = input frame fEditRecord lBrowseFields
      glBrowseFields = lBrowseFields.

  if lBrowseFields then
    open query brRecordBrowse
      for each ttQueryWindowField
        where ttQueryWindowField.WindowHandle = ?
          and ttQueryWindowField.Order > 0
        no-lock
        by Order.

  else
    open query brRecordBrowse
      for each ttQueryWindowField
        where ttQueryWindowField.WindowHandle = ?
        no-lock
        by FieldName.

end.

on value-changed of lRawValues in frame fEditRecord
do:

  define variable clValue as longchar  no-undo.

  define buffer bttQueryWindowField for temp-table ttQueryWindowField.

  assign
    lRawValues  = input frame fEditRecord lRawValues
    glRawValues = lRawValues
    .

  for each bttQueryWindowField
    where bttQueryWindowField.WindowHandle = ?
    on error undo, throw:

    run qg_UpdateRecordFieldDisplayValue((buffer bttQueryWindowField:handle),
                                          lRawValues,
                                          255). 

  end.

  if query brRecordBrowse:num-results > 0 then
    browse brRecordBrowse:refresh().

end.

on value-changed of brRecordBrowse in frame fEditRecord
do:

  if available ttQueryWindowField then
    menu-item mi_CopyFieldValue:label in menu m_PopupMenu = substitute('Copy value (&1)':T,
                                                                       (if length(ttQueryWindowField.CurrentDisplayValue) < 100 then
                                                                          ttQueryWindowField.CurrentDisplayValue
                                                                        else
                                                                          substitute('&1 ...':U,
                                                                                     substring(ttQueryWindowField.CurrentDisplayValue, 1, 96)))).

  else
    menu-item mi_CopyFieldValue:label in menu m_PopupMenu = 'Copy value':T.

end.

on row-display of brRecordBrowse in frame fEditRecord
do:

  define variable iColor as integer   no-undo initial ?.

  if available ttQueryWindowField then

    case ttQueryWindowField.FieldType:

    when {&K_FIELD_TYPE_VIRTUAL_DB_FIELD} then

      iColor = {&K_VIRTUAL_DB_FIELD_FGCOLOR}.

  end case.

  if iColor <> ? then

    assign
      ttQueryWindowField.DisplayName:fgcolor in browse brRecordBrowse         = iColor
      ttQueryWindowField.FieldLabel:fgcolor in browse brRecordBrowse          = iColor
      ttQueryWindowField.CurrentDisplayValue:fgcolor in browse brRecordBrowse = iColor
      .

end.

on choose of menu-item mi_CopyFieldValue in menu m_PopupMenu
do:

  define variable clValue as longchar  no-undo.

  if not available ttQueryWindowField then
    message /* code checked by mth */
      'No field is selected':T skip
      view-as alert-box
      error
      buttons ok.

  else
  do:

    lRawValues = input frame fEditRecord lRawValues.

    if lRawValues then
      copy-lob ttQueryWindowField.CurrentUnformattedValue to clValue.

    else
      copy-lob ttQueryWindowField.CurrentFormattedValue to clValue.

    clipboard:value = clValue.

  end.

end.

on choose of menu-item mi_EditFieldValue in menu m_PopupMenu
do:

  define variable hField  as handle    no-undo.
  define variable clValue as longchar  no-undo.

  if not available ttQueryWindowField then
    message /* code checked by mth */
      'No field is selected!':T
      view-as alert-box
      error
      buttons ok
      in window phParentWindow.

  else
  do:

    hField = hTempTableBuffer:buffer-field(ttQueryWindowField.FieldName).

    if hField:data-type = 'BLOB':U then
      message /* code checked by mth */
        'BLOB fields may not be edited!':T skip
        view-as alert-box
        error
        buttons ok.

    else
    do:

      if hField:data-type = 'CLOB':U then
        copy-lob hField:buffer-value(ttQueryWindowField.FieldIndex) to clValue.

      else
        clValue = string(hField:buffer-value(ttQueryWindowField.FieldIndex)).

      run qg_EditFieldValue(hField:name,
                            hField:data-type,
                            hField:format,
                            hField:view-as,
                            input frame fEditRecord lRawValues,
                            plEditMode,
                            input-output clValue,
                            phParentWindow).

      if plEditMode then
      do:

        if hField:data-type = 'CLOB':U then
          copy-lob clValue to hField:buffer-value(ttQueryWindowField.FieldIndex).

        else
          hField:Buffer-value(ttQueryWindowField.FieldIndex) = string(clValue).

      end.

      // Update values in ttQueryWindowField
      run qg_UpdateRecordField( hField,
                                ttQueryWindowField.FieldIndex,
                                ( buffer ttQueryWindowField:handle ),
                                no ).

      run qg_UpdateRecordFieldDisplayValue((buffer ttQueryWindowField:handle),
                                           input frame fEditRecord lRawValues,
                                           255). 

      if query brRecordBrowse:num-results > 0 then
        browse brRecordBrowse:refresh().

    end.

  end.

end.

on choose of menu-item mi_AdoptExternalValue in menu m_PopupMenu
do:

  define variable lOk                as logical   no-undo.
  define variable lRecidReference    as logical   no-undo.
  define variable iQuerySeq          as integer   no-undo.
  define variable cBufferName        as character no-undo.
  define variable cFieldName         as character no-undo.
  define variable iFieldIndex        as integer   no-undo.

  define variable hTargetField       as handle    no-undo.
  define variable hSourceBuffer      as handle    no-undo.
  define variable hSourceField       as handle    no-undo.
  define variable clValue            as longchar  no-undo.

  define buffer bttQueryWindow-Parent for temp-table ttQueryWindow.

  if not available ttQueryWindowField then
    message /* code checked by mth */
      'No field is selected!':T
      view-as alert-box
      error
      buttons ok
      in window phParentWindow.

  else
  do:

    run qg_SelectExternalReference( ttQueryWindowField.TableName,
                                    ttQueryWindowField.FieldName,
                                    yes,
                                    substitute('!&1,*':U, phParentWindow),
                                    phParentWindow,
                                    output lOk,
                                    output lRecidReference,
                                    output iQuerySeq,
                                    output cBufferName,
                                    output cFieldName,
                                    output iFieldIndex ).

    if lOk then
    do:

      hTargetField = hTempTableBuffer:buffer-field(ttQueryWindowField.FieldName).

      find bttQueryWindow-Parent
        where bttQueryWindow-Parent.QuerySeq = iQuerySeq
        .

      hSourceBuffer = bttQueryWindow-Parent.QueryHandle:get-buffer-handle( cBufferName ).

      hSourceField = hSourceBuffer:buffer-field( cFieldName ) no-error.

      if    not error-status:error
        and valid-handle( hSourceField ) then
      do:

        if hTargetField:data-type = 'CLOB':U then
          copy-lob hSourceField:buffer-value( iFieldIndex ) to hTargetField:buffer-value(ttQueryWindowField.FieldIndex).

        else
          hTargetField:Buffer-value( ttQueryWindowField.FieldIndex ) = hSourceField:buffer-value( iFieldIndex ).

      end.

      else

        if ttQueryWindowField.IsVirtual then
        do:

          clValue = qg_clVirtualFieldValueAsLongchar( ttQueryWindowField.FieldType,
                                                      ttQueryWindowField.DataType,
                                                      ttQueryWindowField.FieldName,
                                                      qg_cObjectIdForBuffer( hSourceBuffer ),
                                                      ? ).

          if hTargetField:data-type = 'CLOB':U then

            copy-lob clValue to hTargetField:buffer-value( ttQueryWindowField.FieldIndex ).

          else

            hTargetField:buffer-value( ttQueryWindowField.FieldIndex ) = string( clValue ).

        end.

      // Update values in ttQueryWindowField
      run qg_UpdateRecordField( hTargetField,
                                ttQueryWindowField.FieldIndex,
                                ( buffer ttQueryWindowField:handle ),
                                no ).

      run qg_UpdateRecordFieldDisplayValue((buffer ttQueryWindowField:handle),
                                           input frame fEditRecord lRawValues,
                                           255). 

      if query brRecordBrowse:num-results > 0 then
        browse brRecordBrowse:refresh().

    end.

  end.

end.

on default-action of brRecordBrowse in frame fEditRecord
  apply 'choose':U to menu-item mi_EditFieldValue in menu m_PopupMenu.

on ' ':U of brRecordBrowse in frame fEditRecord
  apply 'choose':U to menu-item mi_EditFieldValue in menu m_PopupMenu.

on ctrl-c of brRecordBrowse in frame fEditRecord
  apply 'choose':U to menu-item mi_CopyFieldValue in menu m_PopupMenu.

Main:
do
  transaction
  on error  undo, throw
  on endkey undo, leave:

  find bttQueryWindow
    where bttQueryWindow.WindowHandle = phParentWindow
    no-error.

  if not plEditMode then
    assign
      btnOk:hidden in frame fEditRecord                     = yes
      btnCancel:label in frame fEditRecord                  = 'Close':T5
      btnCancel:col in frame fEditRecord                    = 71
      menu-item mi_EditFieldValue:label in menu m_PopupMenu = 'Value details':T
      .

  create buffer hLockBuffer for table phBuffer.

  assign
    hLockBuffer:private-data = phBuffer:private-data
    cDatabaseName            = qg_cDatabaseNameForTableOrBuffer( hLockBuffer )
    hLockBuffer:private-data = qg_cParamListWriteCharacter( hLockBuffer:private-data,
                                                            'DatabaseName':U,
                                                            cDatabaseName,
                                                            ',':U )
    .

  find bttTable
    where bttTable.DatabaseName = cDatabaseName
      and bttTable.TableName    = hLockBuffer:table
    no-error.

  if   piEditAction = {&K_EDITACTION_CREATE}
    or piEditAction = {&K_EDITACTION_DUPLICATE} then
  do:

    lDisableTriggers =     available bttTable
                       and bttTable.CreateTrigger         > '':U
                       and search(bttTable.CreateTrigger) = ?.

    run qg_ConfirmTriggerChanges(substitute('Confirm creation of &1 record':T,
                                            hLockBuffer:table),
                                 substitute('Please confirm creation of &1 record':T,
                                            hLockBuffer:table),
                                 'Create':T,
                                 (    available bttTable
                                  and search(bttTable.CreateTrigger) <> ?),
                                 phParentWindow,
                                       output lOk,
                                 input-output lDisableTriggers).

    if not lOk then
      undo Main, leave Main.

    run qg_CreateBuffer(hLockBuffer,
                        lDisableTriggers).

  end.

  else if piEditAction = {&K_EDITACTION_EDIT}
    and   plEditMode then
    hLockBuffer:find-by-rowid(phBuffer:rowid, exclusive-lock).

  else
    hLockBuffer:find-by-rowid(phBuffer:rowid, no-lock).

  // Set dialog title.
  case piEditAction:

    when {&K_EDITACTION_CREATE} then
      frame fEditRecord:title = substitute('&1Create &2 record (&3)':T,
                                           gcTitlePrefix,
                                           hLockBuffer:table,
                                           hLockBuffer:rowid).

    when {&K_EDITACTION_DUPLICATE} then
      frame fEditRecord:title = substitute('&1Duplicate &2 record (&3)':T,
                                           gcTitlePrefix,
                                           hLockBuffer:table,
                                           hLockBuffer:rowid).

    otherwise
    do:

      if plEditMode then
        frame fEditRecord:title = substitute('&1Edit &2 record (&3)':T,
                                             gcTitlePrefix,
                                             hLockBuffer:table,
                                             hLockBuffer:rowid).

      else
        frame fEditRecord:title = substitute('&1&2 record details (&3)':T,
                                             gcTitlePrefix,
                                             hLockBuffer:table,
                                             hLockBuffer:rowid).

    end.

  end case.

  // Create temp-table and copy buffer-values.
  create temp-table hTempTable.

  hTempTable:create-like-sequential(hLockBuffer).

  run qg_AddVirtualFieldsToTempTable( cDatabaseName,
                                      hLockBuffer:table,
                                      hTempTable ).

  &IF proversion >= '11.7':U &THEN
    hTempTable:temp-table-prepare( hLockBuffer:table, yes ).
  &ELSE
    hTempTable:temp-table-prepare( hLockBuffer:table ).
  &ENDIF

  assign
    hTempTableBuffer              = hTempTable:default-buffer-handle
    hTempTableBuffer:private-data = hLockBuffer:private-data
    hTempTableBeforeBuffer        = hTempTableBuffer:before-buffer
    .

  // We dont really need a dataset. However progress requires a dataset for
  // tracking changes to be used.

  create dataset hDataset.

  hDataset:set-buffers( hTempTableBuffer ).

  hTempTableBuffer:buffer-create().

  hTempTableBuffer:buffer-copy(hLockBuffer).

  if qg_lIsPhysicalDatabase( cDatabaseName ) then

    run qg_BufferCopyVirtualFieldsFromPhysicalBufferToTempTableBuffer
          ( cDatabaseName,
            hLockBuffer,
            hTempTableBuffer ).

  hTempTable:tracking-changes = yes.

  if    piEditAction = {&K_EDITACTION_CREATE}
    and available bttQueryWindow then
  do:

    do iField = 1 to hTempTableBuffer:num-fields:

      hField = hTempTableBuffer:buffer-field( iField ).

      if    can-do( {&K_COMPANY_FIELDS}, hField:name )
        and hField:extent    = 0
        and hField:data-type = 'character':U then
        hField:buffer-value = qg_cGetCompany( hTempTableBuffer:table, ? ).

    end.

    run qg_AdoptLinkValues( hTempTableBuffer,
                            bttQueryWindow.QuerySeq ).

  end.

  if piEditAction = {&K_EDITACTION_DUPLICATE} then
  do:

    hTempTableBuffer:buffer-copy(phBuffer,
                                 substitute('&1_Obj':U,
                                            phBuffer:table)).

    if qg_lIsPhysicalDatabase( cDatabaseName ) then

      run qg_BufferCopyVirtualFieldsFromPhysicalBufferToTempTableBuffer
            ( cDatabaseName,
              phBuffer,
              hTempTableBuffer ).


  end.

  if pcFieldList = ? then
    assign
      lBrowseFields                             = no
      lBrowseFields:hidden in frame fEditRecord = yes
      .

  else
    assign
      lBrowseFields                       = glBrowseFields
      lRawValues:col in frame fEditRecord = lRawValues:col in frame fEditRecord + 45
      .

  lRawValues = glRawValues.

  // Create field temp-table entries.
  run qg_QueryWindowUpdateFieldTempTable( hTempTableBuffer, ?, pcFieldList).

  // Set field temp-table display values.
  for each bttQueryWindowField
    where bttQueryWindowField.WindowHandle = ?
    on error undo, throw:

    run qg_UpdateRecordField( bttQueryWindowField.FieldHandle,
                              bttQueryWindowField.FieldIndex,
                              ( buffer bttQueryWindowField:handle ),
                              no ).

  end.

  // Display has to happen before we apply 'value-changed' to avoid an error
  // message due to an invalid screen-value.

  display unless-hidden
    lBrowseFields
    lRawValues
    with frame fEditRecord
      in window phParentWindow. 

  apply 'value-changed' to lRawValues in frame fEditRecord.
  apply 'value-changed' to lBrowseFields in frame fEditRecord.

  assign
    brRecordBrowse:popup-menu in frame fEditRecord                = menu m_PopupMenu:handle
    brRecordBrowse:num-locked-columns in frame fEditRecord        = 2
    ttQueryWindowField.DisplayName:width in browse brRecordBrowse = 39
    .

  run qg_InitBrowse(browse brRecordBrowse:handle).

  menu-item mi_AdoptExternalValue:sensitive in menu m_PopupMenu
      = (     plEditMode
          and can-find( first ttQueryWindow
                          where ttQueryWindow.WindowHandle <> phParentWindow
                            and valid-handle( bttQueryWindow.WindowHandle )
                            and valid-handle( bttQueryWindow.QueryHandle ) ) ).

  update unless-hidden
    lBrowseFields
    lRawValues
    brRecordBrowse
    btnOk
    btnCancel
    with frame fEditRecord
      in window phParentWindow. 

  hTempTable:tracking-changes = no.

  if plEditMode then
  do:

    //if not hLockBuffer:buffer-compare(hTempTableBuffer,
    //                                'binary':U) then
    if qg_cBufferCompare(hTempTableBuffer, hTempTableBuffer:before-buffer) > '':U then 
    do:

      lDisableTriggers =     available bttTable
                         and bttTable.WriteTrigger         > '':U
                         and search(bttTable.WriteTrigger) = ?.  

      run qg_ConfirmRecordChanges(substitute('Confirm changes to &1 record &2':T,
                                             hLockBuffer:table,
                                             string(hLockBuffer:rowid)),
                                  'WARNING: The current record has been changed. Below you will find a list of all changes you made. Please carefully review and confirm your changes!':T,
                                  hTempTableBeforeBuffer,
                                  hTempTableBuffer,
                                  (    available bttTable
                                   and search(bttTable.WriteTrigger) <> ?),
                                  lRawValues,
                                  phParentWindow,
                                        output lOk,
                                  input-output lDisableTriggers).

      if lOk then
      do:

        if lDisableTriggers then

          hLockBuffer:disable-load-triggers(no).

        hLockBuffer:buffer-copy(hTempTableBuffer).

        run qg_BufferCopyVirtualFieldsFromTempTableBufferToPhysicalBuffer
              ( cDatabaseName,
                hTempTableBuffer,
                hLockBuffer,
                lDisableTriggers ).

        hLockBuffer:buffer-validate().

      end.

    end.

    oprRowid = hLockBuffer:rowid.

  end.

  finally:

    if valid-handle(hLockBuffer) then
    do:

      hLockBuffer:buffer-release().

      delete object hLockBuffer.

    end.

    if valid-handle( hDataset ) then

      delete object hDataset.

    if valid-handle(hTempTable) then
      delete object hTempTable no-error.

  end finally.

end.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_ExecQuery hQueryWindow 
PROCEDURE qg_ExecQuery :
/**
 * Open a new query window and execute the current query.
 *
 * @param pcTables = Commaseparated list of tables that are required for this query.
 * @param pcQueryText = Initial query text for this query window.
 * @param piQuerySeq = Query sequence to use for this window. If empty then a new id will be generated.
 */

define input        parameter piWindowMode     as integer   no-undo.
define input        parameter piWindowSize     as integer   no-undo.
define input        parameter pcTables         as character no-undo.
define input        parameter pcQueryText      as character no-undo.
define input        parameter plInitMode       as logical   no-undo.
define input        parameter pcParamList      as character no-undo.
define input-output parameter iopiQuerySeq     as integer   no-undo.

define variable iObjSourceQuerySeq         as integer   no-undo.
define variable lFocusQueryText            as logical   no-undo.
define variable iXPos                      as integer   no-undo.
define variable iYPos                      as integer   no-undo.

define variable cWindowTitle               as character no-undo.

define variable hWindow                    as handle    no-undo.

define buffer bttTable       for temp-table ttTable.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if iopiQuerySeq = ? then
  assign
    giQuerySeq   = giQuerySeq + 1
    iopiQuerySeq = giQuerySeq
    .

else
do:

  if can-find(ttQueryWindow
                where ttQueryWindow.QuerySeq = iopiQuerySeq) then
  do:

    message /* code checked by mth */
      substitute('The query id &1 is already in use. Query window could not be opened!':T,
                 iopiQuerySeq) skip
      view-as alert-box error
      buttons ok.

    return error.

  end.

  giQuerySeq = max(iopiQuerySeq, giQuerySeq). 

end.

// Create dynamic widgets.
create window hWindow
  assign
    name           = substitute( 'fQuery&1':U, string( giQuerySeq ) )
    hidden         = yes
    width          = 150
    max-width      = 1024
    height         = 18
    max-height     = 1024
    scroll-bars    = no
    status-area    = no
    three-d        = yes
    message-area   = no
    sensitive      = yes
    title          = gcTitlePrefix
  triggers:

    on end-error anywhere
      persistent run qg_MoveToTop in target-procedure.

    on window-close
      persistent run qg_QueryWindowClose in target-procedure
                       (hWindow,
                        ?).

    on window-resized
      persistent run qg_QueryWindowResize in target-procedure
                       (hWindow).

    on entry
      persistent run qg_QueryWindowEntry in target-procedure
                       (hWindow).

    on shift-alt-cursor-up anywhere /* Dock up */
      persistent run qg_QueryWindowDock in target-procedure
                       (hWindow,
                        {&K_DIRECTION_UP}).

    on shift-alt-cursor-down anywhere /* Dock down */
      persistent run qg_QueryWindowDock in target-procedure
                       (hWindow,
                        {&K_DIRECTION_DOWN}).

    on shift-alt-cursor-left anywhere /* Dock left */
      persistent run qg_QueryWindowDock in target-procedure
                       (hWindow,
                        {&K_DIRECTION_LEFT}).

    on shift-alt-cursor-right anywhere /* Dock right */
      persistent run qg_QueryWindowDock in target-procedure
                       (hWindow,
                        {&K_DIRECTION_RIGHT}).

    on shift-f9 anywhere /* Set size small */
      persistent run qg_QueryWindowSetSize in target-procedure
                       (hWindow,
                        {&K_QUERY_SIZE_MODE_DEFAULT_SPLITTER}).

    on shift-f10 anywhere /* Set size smaller */
      persistent run qg_QueryWindowSetSize in target-procedure
                       (hWindow,
                        {&K_QUERY_SIZE_MODE_SMALL}).

    on shift-f11 anywhere /* Set size minimum */
      persistent run qg_QueryWindowSetSize in target-procedure
                       (hWindow,
                        {&K_QUERY_SIZE_MODE_MINIMUM}).

    on shift-f12 anywhere /* Set size default */
      persistent run qg_QueryWindowSetSize in target-procedure
                       (hWindow,
                        {&K_QUERY_SIZE_MODE_BIG}).

    on ctrl-f7 anywhere /* Show query window */
      persistent run qg_OpenQueryWindowListWindow in target-procedure.

  end triggers.

assign
  iXPos = qg_dParamListReadValue(pcParamList,
                                 'XPos':U,
                                 {&K_PARAM_SPLITTER})
  iYPos = qg_dParamListReadValue(pcParamList,
                                 'YPos':U,
                                 {&K_PARAM_SPLITTER})
  .

if    iXPos > 0
  and iYPos > 0 then
  run qg_SetWindowPos(hWindow, iXPos, iYPos).

create bttQueryWindow.

assign
  bttQueryWindow.WindowHandle = hWindow
  bttQueryWindow.QuerySeq     = iopiQuerySeq
  bttQueryWindow.WindowMode   = piWindowMode
  iObjSourceQuerySeq          = qg_iParamListReadValue(pcParamList,
                                                       'ObjSourceQuerySeq':U,
                                                       {&K_PARAM_SPLITTER}).
  .

if iObjSourceQuerySeq > 0 then
do:

  assign
    bttQueryWindow.ObjSourceQuerySeq   = iObjSourceQuerySeq
    bttQueryWindow.ObjSourceBufferName = qg_cParamListReadValue(pcParamList,
                                                                'ObjSourceBufferName':U,
                                                                {&K_PARAM_SPLITTER})
    bttQueryWindow.ObjSourceFieldName  = qg_cParamListReadValue(pcParamList,
                                                                'ObjSourceFieldName':U,
                                                                {&K_PARAM_SPLITTER})
    bttQueryWindow.ObjSourceFieldIndex = qg_iParamListReadValue(pcParamList,
                                                                'ObjSourceFieldIndex':U,
                                                                {&K_PARAM_SPLITTER})
    .

end.

validate bttQueryWindow.

if bttQueryWindow.ObjSourceQuerySeq > 0 then
  run qg_QueryWindowObjUpdateQuery(bttQueryWindow.WindowHandle).

else
  run qg_QueryWindowUpdateQuery(bttQueryWindow.WindowHandle, pcTables).

lFocusQueryText = qg_lParamListReadValue(pcParamList,
                                         'FocusQueryText':U,
                                         {&K_PARAM_SPLITTER}).

run qg_QueryWindowSetWindowMode(hWindow,
                                piWindowMode,
                                pcQueryText,
                                lFocusQueryText).

if piWindowSize <> ? then
  run qg_QueryWindowSetSize(hWindow, piWindowSize).

if plInitMode then
  run qg_QueryWindowSetQueryText(bttQueryWindow.WindowHandle, pcQueryText).

else
do:

  hWindow:hidden = no.

  run qg_QueryWindowExecute(bttQueryWindow.WindowHandle, pcQueryText, no).

end.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_ExecRecentQuery hQueryWindow 
PROCEDURE qg_ExecRecentQuery :
/**
 * Execute a recent query.
 *
 * @param phWindow = Handle of the Query window.
 * @param pcQueryText = Query text that should be executed.
 */

define input parameter phWindow    as handle    no-undo.
define input parameter pcQueryText as character no-undo.

define buffer bttQueryWindow for temp-table ttQueryWindow.

if not valid-handle(phWindow) then
  leave.

find bttQueryWindow
  where bttQueryWindow.WindowHandle = phWindow
  no-error.

if not available bttQueryWindow then
  leave.

run qg_AddRecentQuery(bttQueryWindow.WindowHandle).

run qg_QueryWindowQuerySetQueryText(bttQueryWindow.WindowHandle,
                                    pcQueryText,
                                    no).

run qg_QueryWindowExecute(bttQueryWindow.WindowHandle, ?, no).

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_ExecuteCommand hQueryWindow 
PROCEDURE qg_ExecuteCommand :
/**
 * Execute command (used for Developer Studio interaction).
 *
 * @param pcParamList PKS
 */

define input parameter pcParamList as character no-undo.

define variable cCommand as character no-undo.
define variable cTableName as character no-undo.

define buffer bttDatabase for temp-table ttDatabase.

cCommand = qg_cParamListReadValue(pcParamList,
                                  'command':U,
                                  {&K_PARAM_SPLITTER}).

case cCommand:

  when 'insert_query':U then
    run qg_InsertQueryText.

  when 'insert_buffer_definition':U then
    run qg_InsertBufferDefinition.

  when 'insert_assign_statement':U then
    run qg_InsertFieldAssignStatement.

  when 'insert_field_assignment':U then
    run qg_InsertFieldAssigments.

  when 'select_table':U then
  do:

    cTableName = qg_cParamListReadValue(pcParamList,
                                        'table_name':U,
                                        {&K_PARAM_SPLITTER}).

    if cTableName > '':U then
      run qg_SelectTable(cTableName, yes).

  end.

end case.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_ExportBrowse hQueryWindow 
PROCEDURE qg_ExportBrowse :
/**
 * Export all records of the given browse query.
 *
 * @param phBrowse = browse that should be exported.
 */

define input parameter phBrowse as handle    no-undo.

define variable i                  as integer   no-undo.
define variable iRecordCount       as int64     no-undo.

define variable hQuery             as handle    no-undo.

define variable cColumnName        as character no-undo.
define variable hColumn            as handle    no-undo.
define variable hColumns           as handle    no-undo extent.
define variable cValue             as character no-undo.
define variable cKeyValues         as character no-undo.
define variable clLine             as longchar  no-undo.
define variable lFirstLine         as logical   no-undo initial yes.
define variable lBuffername        as logical   no-undo.
define variable lOverlayColumns    as logical   no-undo.
define variable lDeep              as logical   no-undo.
define variable lResolved          as decimal   no-undo.

define variable cAvailableColumns  as character no-undo.

define variable rCurrentRecord     as rowid     no-undo extent.

define variable lExportToClipboard as logical   no-undo
  label '':U
  view-as radio-set
    radio-buttons 
      'Export to clipboard':T, yes,
      'Export to file':T, no
  size 40 by 2
  .

define variable cExportFilename as character no-undo
  label 'Export file':T
  format 'x(1024)':U
  view-as fill-in
  size 80 by 1.

define button btnFileDialog
  label '...':T
  size 7 by 1.

define variable cSelectedColumns as character no-undo
  label 'Columns':T
  format 'x(30000)':U
  view-as fill-in
  size 80 by 1
  .

define button btnColumns
  label '...':T
  size 7 by 1.

define variable cSeparator as character no-undo initial ';':U
  label 'Separator':T
  format 'x(1)':U
  view-as fill-in
  size 5 by 1.

define variable lQuoteValues as logical   no-undo initial yes
  label 'Quote values':T
  view-as toggle-box
  size 16 by 1
  .

define variable lExportHeader as logical   no-undo initial yes
  label 'Header':T
  view-as toggle-box
  size 12 by 1.

define variable lLabelHeader as logical   no-undo
  label 'Header':T
  view-as radio-set horizontal expand
    radio-buttons
      'Labels':T, yes,
      'Fieldnames':T, no

    size 28 by 1
  .

define variable lIncludeBuffername as logical   no-undo
  label 'Include buffername':T
  view-as toggle-box
  size 25 by 1.

define button btnOk
  label 'Export':T
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.

define buffer bttQueryWindow        for temp-table ttQueryWindow.
define buffer bttQueryWindowField   for temp-table ttQueryWindowField.
define buffer bttVirtualFieldColumn for temp-table ttVirtualFieldColumn.
define buffer bttFieldOverlay       for temp-table ttFieldOverlay.

define frame fExport
  lExportToClipboard at row 1.5 col 12 colon-aligned no-label
  cExportFilename at row 4 col 12 colon-aligned
  btnFileDialog at row 4 col 92 colon-aligned
  cSelectedColumns at row 5.5 col 12 colon-aligned
  btnColumns at row 5.5 col 92 colon-aligned
  lExportHeader at row 7 col 12 colon-aligned
  lLabelHeader at row 7 col 30 colon-aligned no-label
  lIncludeBuffername at row 7 col 66 colon-aligned
  cSeparator at row 8.5 col 12 colon-aligned
  lQuoteValues at row 8.5 col 30 colon-aligned
  btnOk at row 10.5 col 31
  btnCancel at row 10.5 col 51
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 103 by 12.44
    title '':T
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fExport
  apply 'end-error' to self.

on value-changed of lExportToClipboard in frame fExport
do:

  assign
    lExportToClipboard                         = input frame fExport lExportToClipboard
    cExportFilename:sensitive in frame fExport = not lExportToClipboard /* code checked by mth 30.07.2015 */
    btnFileDialog:sensitive in frame fExport   = not lExportToClipboard /* code checked by mth 30.07.2015 */
    .

end.

on choose of btnFileDialog in frame fExport
do:

  define variable lOk       as logical   no-undo.
  define variable cFilename as character no-undo.

  cFilename = input frame fExport cExportFilename.

  system-dialog get-file cFilename
    title             gcTitlePrefix + 'Save file as ...':U
    filters           'Comma-separated values (*.csv)':U '*.csv':U
    default-extension '.csv':U
    ask-overwrite
    save-as
    use-filename
    update lOk
    in window phBrowse:window
    .

  if lOk then
  do:

    cExportFilename = cFilename.

    display unless-hidden
      cExportFilename
      with frame fExport
        in window phBrowse:window.

  end.

end.

on choose of btnColumns in frame fExport
do:

  define variable lOk as logical   no-undo.

  run qg_SelectionDialog(cAvailableColumns,
                         cAvailableColumns,
                         input-output cSelectedColumns,
                         'Select columns':T,
                         phBrowse:window,
                         yes,
                         output lOk).

  if lOk then
    display unless-hidden
      cSelectedColumns
      with frame fExport.

end.

on 'value-changed':U of lExportHeader in frame fExport
do:

  lLabelHeader:sensitive in frame fExport /* code checked by mth */
      = input frame fExport lExportHeader.

  apply 'value-changed':U to lLabelHeader in frame fExport.

end.

on 'value-changed':U of lLabelHeader in frame fExport
  lIncludeBuffername:sensitive in frame fExport /* code checked by mth */
      =     input frame fExport lExportHeader
        and not input frame fExport lLabelHeader.

assign
  lBuffername        = (phBrowse:query:num-buffers > 1)
  cAvailableColumns  = qg_cBrowseColumnList(phBrowse,
                                            lBuffername,
                                            yes,
                                            no)
  cSelectedColumns   = qg_cBrowseColumnList(phBrowse,
                                            lBuffername,
                                            no,
                                            no)
  cExportFilename    = (if gcExportFilename > '':U then
                          gcExportFilename
                        else
                          substitute(qg_cFileName('%Temp%\&1.csv':U),
                                     phBrowse:query:get-buffer-handle(1):name))
  .

assign
  frame fExport:title                         = gcTitlePrefix + 'Export records':U
  cSelectedColumns:read-only in frame fExport = yes
  .

update unless-hidden
  lExportToClipboard
  cExportFilename
  btnFileDialog
  cSelectedColumns
  btnColumns
  lExportHeader
  lLabelHeader
  lIncludeBuffername
  cSeparator
  lQuoteValues
  btnOk
  btnCancel
  with frame fExport
    in window phBrowse:window.

display unless-hidden
  'Exporting Browse lines ...':T
    @ gcStatusText60
  with frame fStatus
    no-labels
    overlay
    color messages
    centered
    view-as dialog-box
    width 65
    in window phBrowse:window
    .

process events.

// Get all export columns
extent( hColumns ) = num-entries( cSelectedColumns ).

do i = 1 to phBrowse:num-columns:

  assign
    hColumn     = phBrowse:get-browse-column(i)
    cColumnName = qg_cColumnFieldName(hColumn,
                                      lBuffername)
    .

  if lookup(cColumnName, cSelectedColumns) > 0 then
    hColumns[lookup(cColumnName, cSelectedColumns)] = hColumn.

end.

if lExportToClipboard then
  output stream strExport to 'clipboard':U.

else
  output stream strExport to value(cExportFilename).

clLine = '':U.

// Expport header.
if lExportHeader then
do:

  do i = 1 to extent(hColumns):

    assign
      cValue  = (if lLabelHeader then
                   hColumns[i]:label
                 else
                   qg_cColumnFieldName(hColumns[i],
                                       lIncludeBuffername))
      clLine  = substitute('&1&2&3':U,
                           clLine,
                           (if i = 1 then
                              '':U
                            else
                              cSeparator),
                           (if lQuoteValues then
                              quoter(cValue)
                            else
                              cValue))
      .

  end.

  clLine = substitute('&1~n':U,
                      clLine).

  run qg_WriteExportLine(clLine).

end.

// Export browser content.
assign
  hQuery          = phBrowse:query
  lOverlayColumns = can-find( first ttFieldOverlay
                                where ttFieldOverlay.OwnerHandle = hQuery )
  .

if lOverlayColumns then
do:

  find bttQueryWindow
    where bttQueryWindow.WindowHandle = phBrowse:window
    no-error.

  if available bttQueryWindow then
    lDeep = bttQueryWindow.DeepResolveObjectIds.

end.

extent(rCurrentRecord) = hQuery:num-buffers.

do i = 1 to hQuery:num-buffers:
  rCurrentRecord[i] = hQuery:get-buffer-handle(i):rowid.
end. 

hQuery:get-first().

do while not hQuery:query-off-end:

  assign
    iRecordCount = iRecordCount + 1
    clLine       = '':U
    .

  if iRecordCount mod 5000 = 0 then
  do:

    display unless-hidden
      substitute('Exporting Browse lines &1 ...':T,
                 trim(string(iRecordCount, {&K_MAX_INT64_FORMAT})))
        @ gcStatusText60
      with frame fStatus
        no-labels
        overlay
        color messages
        centered
        view-as dialog-box
        width 65
        in window phBrowse:window
        .

    process events.

  end.

  BrowseColumn:
  do i = 1 to extent( hColumns )
    on error undo, next:

    cValue = '':U.

    if valid-handle( hColumns[i]:buffer-field ) then

      cValue = hColumns[i]:buffer-field:buffer-value(hColumns[i]:index).

    else
    do:

      find bttVirtualFieldColumn
        where bttVirtualFieldColumn.OwnerHandle  = hQuery
          and bttVirtualFieldColumn.ColumnHandle = hColumns[i]
        no-error.

      if available bttVirtualFieldColumn then

        cValue = string( qg_clVirtualFieldValueAsLongchar( bttVirtualFieldColumn.FieldType,
                                                           bttVirtualFieldColumn.DataType,
                                                           bttVirtualFieldColumn.FieldName,
                                                           qg_cObjectIdForBuffer( bttVirtualFieldColumn.BufferHandle ),
                                                           ? ) ).

      else

        if lOverlayColumns then
        do:

          find first bttFieldOverlay
            where bttFieldOverlay.OwnerHandle         = hQuery
              and bttFieldOverlay.OverlayColumnHandle = hColumns[i]
            no-error.

          if available bttFieldOverlay then

            run qg_GetOverlayColumnValue( buffer bttFieldOverlay,
                                          lDeep,
                                          yes,
                                          output cValue,
                                          output lResolved ).

        end.

    end.

    finally:

      clLine  = substitute('&1&2&3':U,
                           clLine,
                           (if i = 1 then
                              '':U
                            else
                              cSeparator),
                           (if lQuoteValues then
                              quoter(cValue)
                            else
                              cValue)).

    end finally.

  end.

  if not lFirstLine then
    clLine = substitute('~n&1':U,
                        clLine).

  else
    lFirstLine = no.

  run qg_WriteExportLine(clLine).

  hQuery:get-next().

end.

hide frame fStatus.

message /* code checked by mth */
  substitute('&1 records have been exported':T,
             iRecordCount) skip
  view-as alert-box
  information
  buttons ok
  in window phBrowse:window.

gcExportFilename = cExportFilename.

hQuery:reposition-to-rowid(rCurrentRecord).

finally:
  output stream strExport close.
end finally.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_FillQueryRange hQueryWindow 
PROCEDURE qg_FillQueryRange :
/**
 * Set radio buttons for queryrange radio-set according to selected query
 * type.
 */

define variable cDatabase     as character no-undo.
define variable cTable        as character no-undo.
define variable cIndex        as character no-undo.

define variable cFieldList    as character no-undo.

define variable i             as integer   no-undo.
define variable cRadioButtons as character no-undo.

assign
  cDatabase     = (if available ttDatabase then
                     ttDatabase.DatabaseName
                   else
                     '':U)
  cTable        = (if available ttTable then
                     ttTable.TableName
                   else
                     '':U)
  cIndex        = (if available(ttIndex) then
                     ttIndex.IndexName
                   else
                     '':U)
  giQueryType   = (if glSlimMode then
                     {&K_DEFAULT_QUERY_TYPE}
                   else
                     input frame {&FRAME-NAME} giQueryType)
  giDisplayMode = input frame {&FRAME-NAME} giDisplayMode
  cRadioButtons = giQueryTypeModifier:radio-buttons in frame {&FRAME-NAME}
  .

do i = giQueryTypeModifier:num-buttons in frame {&FRAME-NAME} to 1 by -1:
  giQueryTypeModifier:delete(entry(i * 2 - 1, cRadioButtons)) in frame {&FRAME-NAME}.
end.

case giQueryType:

  when {&K_QUERYTYPE_FINDFIRST} then
  do:

    giQueryTypeModifier:add-last('unique':T, {&K_QUERYRANGE_DEFAULT}) in frame {&FRAME-NAME}.
    giQueryTypeModifier:add-last('first':T, {&K_QUERYRANGE_FIRST}) in frame {&FRAME-NAME}.
    giQueryTypeModifier:add-last('last':T, {&K_QUERYRANGE_LAST}) in frame {&FRAME-NAME}.

  end.

  when {&K_QUERYTYPE_FOREACH} then
  do:

    giQueryTypeModifier:add-last('each':T, {&K_QUERYRANGE_DEFAULT}) in frame {&FRAME-NAME}.
    giQueryTypeModifier:add-last('first':T, {&K_QUERYRANGE_FIRST}) in frame {&FRAME-NAME}.
    giQueryTypeModifier:add-last('last':T, {&K_QUERYRANGE_LAST}) in frame {&FRAME-NAME}.

  end.

  when {&K_QUERYTYPE_CANFIND} then
  do:

    giQueryTypeModifier:add-last('unique':T, {&K_QUERYRANGE_DEFAULT}) in frame {&FRAME-NAME}.
    giQueryTypeModifier:add-last('first':T, {&K_QUERYRANGE_FIRST}) in frame {&FRAME-NAME}.
    giQueryTypeModifier:add-last('last':T, {&K_QUERYRANGE_LAST}) in frame {&FRAME-NAME}.

  end.

end case.

if   giDisplayMode <> {&K_DISPLAYMODE_INDEX} then
  cFieldList = qg_cCurrentFieldList().

giQueryTypeModifier = ( if giQueryType = {&K_QUERYTYPE_FOREACH} then
                          {&K_QUERYRANGE_DEFAULT}
                        else
                          if    ( giQueryType = {&K_QUERYTYPE_FINDFIRST}
                              and glAlwaysUseFindFirst )
                             or ( giQueryType = {&K_QUERYTYPE_CANFIND}
                              and glAlwaysUseCanFindFirst ) then
                            {&K_QUERYRANGE_FIRST}
                        else
                          if    giDisplayMode = {&K_DISPLAYMODE_RELATION}
                            and glInvertQuery then
                            ( if    not available ttTableRelationView
                                 or num-entries(ttTableRelationView.RelatedFieldList) = 0
                                 or not qg_lUniqueQuery(ttTableRelationView.DatabaseName,
                                                        ttTableRelationView.RelatedTableName,
                                                        ttTableRelationView.RelatedFieldList) then
                                {&K_QUERYRANGE_FIRST}
                              else
                                {&K_QUERYRANGE_DEFAULT} )
                          else
                            ( if    ( giDisplayMode <> {&K_DISPLAYMODE_INDEX}
                                  and ( num-entries(cFieldList) = 0
                                     or not qg_lUniqueQuery(cDatabase,
                                                            cTable,
                                                            cFieldList) )
                                 or  ( giDisplayMode = {&K_DISPLAYMODE_INDEX}
                                   and ( not available ttIndex
                                      or not ttIndex.IsUnique ) ) ) then
                                {&K_QUERYRANGE_FIRST}
                              else
                                {&K_QUERYRANGE_DEFAULT} ) ).

// The display statement causes unexpected focus behaviour so just set
// screen-value instead.

giQueryTypeModifier:screen-value in frame {&FRAME-NAME} = string(giQueryTypeModifier).

//display unless-hidden
//giQueryTypeModifier
//with frame {&FRAME-NAME}.
end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_FindObjectIdRecord hQueryWindow 
PROCEDURE qg_FindObjectIdRecord :
define input parameter phParentWindow as handle    no-undo.

define variable cObjectIdDatabaseName as character no-undo.
define variable cObjectIdTableName    as character no-undo.

define variable cQueryText            as character no-undo.
define variable cParamList            as character no-undo.

define variable iQuerySeq             as integer   no-undo initial ?.

define variable cObjectId as character no-undo
  format 'x(1024)':U
  view-as fill-in
  size 65 by 1.

define button btnOk
  label 'Ok':T2
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.

define frame fObjectId
    'Please enter object id:':T view-as text size 45 by 1 at col 3 row 1.5
    cObjectId at row 2.5 col 3 no-label
    btnOk at row 4.5 col 16
    btnCancel at row 4.5 col 36
  with 1 down keep-tab-order overlay
    view-as dialog-box
    side-labels no-underline three-d 
    size 71 by 6.44
    title gcTitlePrefix + 'Find object id':T
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fObjectId
  apply 'end-error' to self.

if not available ttDatabase then
do:

  message
    'No database selected!':U skip
    view-as alert-box
    error
    buttons ok.

  leave.

end.

update unless-hidden
  cObjectId
  btnOk
  btnCancel
  with frame fObjectId
    in window phParentWindow.

run qg_GetObjectIdTable(ttDatabase.DatabaseName,
                        cObjectId,
                        output cObjectIdDatabaseName,
                        output cObjectIdTableName).

assign
  cQueryText =   'for each &1'
               + '~n':U + '  where &1.&1_Obj = ~'&2~'':U
  cQueryText = substitute(cQueryText, cObjectIdTableName, cObjectId)
  .

run qg_ExecQuery({&K_QUERY_WINDOW_MODE_Record},
                 {&K_RECORD_SIZE_MODE_DEFAULT},
                 substitute('&1.&2':U,
                            cObjectIdDatabaseName,
                            cObjectIdTableName),
                 cQueryText,
                 no,
                 cParamList,
                 input-output iQuerySeq).


end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_FixCase hQueryWindow 
PROCEDURE qg_FixCase :
/**
 * Fix case of content in given widget.
 *
 * @param phWidget = Widget whose content should be fixed.
 */

define input parameter phWidget       as handle    no-undo.

define input parameter pcDatabaseName as character no-undo.
define input parameter pcTableName    as character no-undo.

define input parameter piCaseMode     as integer   no-undo.

define variable i                as integer   no-undo.
define variable j                as integer   no-undo.
define variable cWidgetValue     as character no-undo.
define variable cEntry           as character no-undo.
define variable lTempDB          as logical   no-undo.
define variable cChar            as character no-undo.
define variable cEntryPrefix     as character no-undo.
define variable cEntrySuffix     as character no-undo.
define variable cReferenceString as character no-undo.
define variable cNewEntry        as character no-undo.
define variable lQuotes          as logical   no-undo.

define buffer bttDatabase          for temp-table ttDatabase.
define buffer bttTable             for temp-table ttTable.
define buffer bttField             for temp-table ttField.
define buffer bttIndex             for temp-table ttIndex.
define buffer bttTableRelationView for temp-table ttTableRelationView.

cWidgetValue  = phWidget:input-value.

find bttDatabase
  where bttDatabase.DatabaseName = pcDatabaseName
  no-error.

lTempDB = (    available bttDatabase
           and bttDatabase.TempDB).

do i = 1 to num-entries(cWidgetValue):

  assign
    cEntry       = trim(entry(i, cWidgetValue))
    lQuotes      = (cWidgetValue matches '"*"':U)
    cEntryPrefix = '':U
    cEntrySuffix = '':U
    .

  if lQuotes then
    cEntry = trim(cEntry, '"':U).

  else
  do:

    // Extract prefix.
    j = 1.

    do while j <= length(cEntry):

      cChar = substring(cEntry, j, 1).

      if   cChar = '*':U
        or cChar = '.':U
        or cChar = '!':U then
        cEntryPrefix = cEntryPrefix + cChar.

      else
        leave.

      j = j + 1.

    end.

    cEntry = substring(cEntry, length(cEntryPrefix) + 1).

    // Extract suffix.
    j = length(cEntry).

    do while j >= 1:

      cChar = substring(cEntry, j, 1).

      if   cChar = '*':U
        or cChar = '.':U
        or cChar = '!':U then
        cEntrySuffix = cEntrySuffix + cChar.

      else
        leave.

      j = j - 1.

    end.

    cEntry = substring(cEntry, 1, length(cEntry) - length(cEntrySuffix)).

  end.

  // If entry contains wildcards do nothing.
  if   length(cEntry)       = 0
    or index(cEntry, '*':U) > 0
    or index(cEntry, '.':U) > 0
    or index(cEntry, '!':U) > 0 then
    next.

  cReferenceString = '':U.

  case piCaseMode:

    when {&K_CASEMODE_TABLE} then
    do:

      do j = 0 to integer(lTempDB):

        if    j = 1
          and cEntry begins 'tt':U then
          cEntry = substitute('td&1':U, substring(cEntry, 3)).

        find first bttTable
          where bttTable.DatabaseName = pcDatabaseName
            and bttTable.TableName    = cEntry
          no-error.

        if not lQuotes then
        do:

          if not available bttTable then
            find first bttTable
              where bttTable.DatabaseName   = pcDatabaseName
                and bttTable.TableName begins cEntry
              no-error.

          if not available bttTable then
            find first bttTable
              where bttTable.DatabaseName    = pcDatabaseName
                and bttTable.TableName matches substitute('*&1*':U, cEntry)
                no-error.

        end.

        if available bttTable then
          leave.

      end.

      if available bttTable then
        cReferenceString = bttTable.TableName.


    end.

    when {&K_CASEMODE_FIELD} then
    do:

      find first bttField
        where bttField.DatabaseName = pcDatabaseName
          and bttField.FieldName    = cEntry
        no-error.

      if not lQuotes then
      do:

        if not available bttField then
          find first bttField
            where bttField.DatabaseName   = pcDatabaseName
              and bttField.FieldName begins cEntry
            no-error.

        if not available bttField then
          find first bttField
            where bttField.DatabaseName    = pcDatabaseName
              and bttField.FieldName matches substitute('*&1*':U, cEntry)
              no-error.

      end.

      if available bttField then
        cReferenceString = bttField.FieldName.

    end.

    when {&K_CASEMODE_TABLE_FIELD} then
    do:

      find first bttField
        where bttField.DatabaseName = pcDatabaseName
          and bttField.TableName    = pcTableName
          and bttField.FieldName    = cEntry
        no-error.

      if not lQuotes then
      do:

        if not available bttField then
          find first bttField
            where bttField.DatabaseName   = pcDatabaseName
              and bttField.TableName      = pcTableName
              and bttField.FieldName begins cEntry
            no-error.

        if not available bttField then
          find first bttField
            where bttField.DatabaseName    = pcDatabaseName
              and bttField.TableName       = pcTableName
              and bttField.FieldName matches substitute('*&1*':U, cEntry)
              no-error.

      end.

      if available bttField then
        cReferenceString = bttField.FieldName.

    end.

    when {&K_CASEMODE_TABLE_FIELD_LABEL} then
    do:

      find first bttField
        where bttField.DatabaseName = pcDatabaseName
          and bttField.TableName    = pcTableName
          and bttField.FieldLabel   = cEntry
        no-error.

      if not lQuotes then
      do:

        if not available bttField then
          find first bttField
            where bttField.DatabaseName    = pcDatabaseName
              and bttField.TableName       = pcTableName
              and bttField.FieldLabel begins cEntry
            no-error.

        if not available bttField then
          find first bttField
            where bttField.DatabaseName     = pcDatabaseName
              and bttField.TableName        = pcTableName
              and bttField.FieldLabel matches substitute('*&1*':U, cEntry)
              no-error.

      end.

      if available bttField then
        cReferenceString = bttField.FieldLabel.

    end.

    when {&K_CASEMODE_TABLE_INDEX} then
    do:

      find first bttIndex
        where bttIndex.DatabaseName = pcDatabaseName
          and bttIndex.TableName    = pcTableName
          and bttIndex.IndexName    = cEntry
        no-error.

      if not lQuotes then
      do:

        if not available bttIndex then
          find first bttIndex
            where bttIndex.DatabaseName   = pcDatabaseName
              and bttIndex.TableName      = pcTableName
              and bttIndex.IndexName begins cEntry
            no-error.

        if not available bttIndex then
          find first bttIndex
            where bttIndex.DatabaseName    = pcDatabaseName
              and bttIndex.TableName       = pcTableName
              and bttIndex.IndexName matches substitute('*&1*':U, cEntry)
            no-error.

      end.

    end.

    when {&K_CASEMODE_TABLE_RELATION} then
    do:

      find first bttTableRelationView
        where bttTableRelationView.DatabaseName       = pcDatabaseName
          and bttTableRelationView.ReferenceTableName = pcTableName
          and bttTableRelationView.RelatedTableName   = cEntry
        no-error.

      if not lQuotes then
      do:

        if not available bttTableRelationView then
          find first bttTableRelationView
            where bttTableRelationView.DatabaseName          = pcDatabaseName
              and bttTableRelationView.ReferenceTableName    = pcTableName
              and bttTableRelationView.RelatedTableName begins cEntry
            no-error.

        if not available bttTableRelationView then
          find first bttTableRelationView
            where bttTableRelationView.DatabaseName           = pcDatabaseName
              and bttTableRelationView.ReferenceTableName     = pcTableName
              and bttTableRelationView.RelatedTableName matches substitute('*&1*':U, cEntry)
            no-error.

      end.

      if available bttTableRelationView then
        cReferenceString = bttTableRelationView.RelatedTableName.

    end.

  end case.

  if cReferenceString > '':U then
    assign
      cNewEntry              = substring(cReferenceString,
                                         index(cReferenceString, cEntry),
                                         length(cEntry))
      entry(i, cWidgetValue) = (if lQuotes then
                                  quoter(cNewEntry)
                                else
                                  substitute('&1&2&3':U,
                                             cEntryPrefix,
                                             cNewEntry,
                                             cEntrySuffix))
        .

end.

phWidget:screen-value = cWidgetValue.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_GetEditorSelectionInfo hQueryWindow 
PROCEDURE qg_GetEditorSelectionInfo :
/**
 * Write given string to the export file.
 *
 * Stream strExport must be open before you call this procedure.
 *
 * @param pclLine = Text line that should be written.
 * @param opiSelectionStart = Selection Start.
 * @param opiSelectionEnd = Selection End.
 * @param opiSelectionStartLine = Line number of selection start.
 * @param opiSelectionEndLine = Line number of selection end.
 */

define input  parameter phEditor              as handle    no-undo.

define output parameter opiSelectionStart     as integer   no-undo.
define output parameter opiSelectionEnd       as integer   no-undo.
define output parameter opiSelectionStartLine as integer   no-undo.
define output parameter opiSelectionEndLine   as integer   no-undo.


define variable cEditorText         as character no-undo.
define variable cLine               as character no-undo.

define variable i                   as integer   no-undo.
define variable iOffset             as integer   no-undo.
define variable iLength             as integer   no-undo.

assign
  cEditorText           = phEditor:input-value
  opiSelectionStart     = (if phEditor:selection-start = ? then
                             phEditor:cursor-offset
                           else
                             phEditor:selection-start)
  opiSelectionEnd       = (if phEditor:selection-end = ? then
                             phEditor:cursor-offset
                           else
                             phEditor:selection-end - 1)
  .

do i = 1 to num-entries(cEditorText, '~n':U):

  assign
    cLine   = entry(i, cEditorText, '~n':U)
    iLength = length(cLine)
    iOffset = phEditor:convert-to-offset(i, 1)
    .

  if    iOffset           <= opiSelectionStart
    and iOffset + iLength >= opiSelectionStart then
    opiSelectionStartLine = i.

  if    iOffset           <= opiSelectionEnd
    and iOffset + iLength >= opiSelectionEnd then
    opiSelectionEndLine = i.

end.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_GetExternalReference hQueryWindow 
PROCEDURE qg_GetExternalReference :
/**
 * Show selection dialog for external reference.
 *
 * pcTableName                    = Table name for reference suggestion.
 * pcFieldName                    = Field name for reference suggestion.
 * plFieldReference               = Flag to indicate wether a field reference
 *                                  or a table refenece should be entered.
 * pcQueryWindowList              = List of query windows that may be used as
 *                                  Reference source.
 * phParentWindow                 = Parent window for the dialog.
 * opcReferenceText               = contains the selected external reference.
 */

define input  parameter pcTableName       as character no-undo.
define input  parameter pcFieldName       as character no-undo.
define input  parameter plFieldReference  as logical   no-undo.
define input  parameter pcQueryWindowList as character no-undo.
define input  parameter phParentWindow    as handle    no-undo.
define output parameter opcReferenceText  as character no-undo initial ?.

define variable lOk             as logical   no-undo.
define variable lRecidReference as logical   no-undo.
define variable iQuerySeq       as integer   no-undo.
define variable cBufferName     as character no-undo.
define variable cFieldName      as character no-undo.
define variable iFieldIndex     as integer   no-undo.

run qg_SelectExternalReference( pcTableName,
                                pcFieldName,
                                plFieldReference,
                                pcQueryWindowList,
                                phParentWindow,
                                output lOk,
                                output lRecidReference,
                                output iQuerySeq,
                                output cBufferName,
                                output cFieldName,
                                output iFieldIndex ).

if lOk then
  opcReferenceText = ( if plFieldReference then
                         substitute('$~{&1:&2~}':U,
                                    string( iQuerySeq ),
                                    qg_cFormattedFieldName( ?,
                                                            cBufferName,
                                                            cFieldName,
                                                            iFieldIndex ) )
                       else
                         if lRecidReference then
                                     substitute('$~{&1:recid(&2)~}':U,
                                                string( iQuerySeq ),
                                                cBufferName )
                       else
                         substitute( '$~{&1:rowid(&2)~}':U,
                                     string( iQuerySeq ),
                                     cBufferName ) ).

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_GetObjectIdTable hQueryWindow 
PROCEDURE qg_GetObjectIdTable :
define input  parameter pcDatabaseName  as character no-undo.
define input  parameter pcObjectId      as character no-undo.
define output parameter opcDatabaseName as character no-undo.
define output parameter opcTableName    as character no-undo.

define variable cTableName      as character no-undo.
define variable cTableId        as character no-undo.

define variable hRepTableBuffer as handle    no-undo.
define variable hRepFieldBuffer as handle    no-undo.

define buffer bttDatabase  for temp-table ttDatabase.
define buffer b2ttDatabase for temp-table ttDatabase.
define buffer bttTable     for temp-table ttTable.
define buffer bttField     for temp-table ttField.

if    num-entries(pcObjectId, ':':U) = 1
  and length(pcObjectId) <= 32
  and pcObjectId matches '*_Obj':U then
do:

  //  Find table by table name
  cTableName = substring(pcObjectId, 1, length(pcObjectId) - 4).

  find bttDatabase
    where bttDatabase.DatabaseName = pcDatabaseName
    no-error.

  if not available bttDatabase then
    leave.

  TABLE_SEARCH:
  for each b2ttDatabase
    where b2ttDatabase.DatabaseName = bttDatabase.DatabaseName
       or b2ttDatabase.DatabaseName = bttDatabase.BasisDBName
       or b2ttDatabase.BasisDB      = yes
       or yes
    on error undo, throw:

    if not can-find(first ttTable
                      where ttTable.DatabaseName = bttDatabase.DatabaseName) then
      run qg_AddTables(bttDatabase.DatabaseName).

    for each bttTable
      where bttTable.DatabaseName = b2ttDatabase.DatabaseName
        and bttTable.TableName    = cTableName,
    first bttField
      where bttField.DatabaseName = bttTable.DatabaseName
        and bttField.TableName    = bttTable.TableName
        and bttField.FieldName    = substitute('&1_Obj':U, bttTable.TableName)
      on error undo, throw:

      leave TABLE_SEARCH.

    end.

  end.

end.

else if num-entries(pcObjectId, ':':U) = 3 then
do:

  cTableId = entry(1, pcObjectId, ':':U).

  if   cTableId = ?
    or cTableId = '':U then
    leave.

  find bttDatabase
    where bttDatabase.DatabaseName = pcDatabaseName
    no-error.

  if not available bttDatabase then
    leave.

  // Step 1: try to find the table in the local cache.
  TABLE_SEARCH:
  for each b2ttDatabase
    where b2ttDatabase.DatabaseName = bttDatabase.DatabaseName
       or b2ttDatabase.DatabaseName = bttDatabase.BasisDBName
       or b2ttDatabase.BasisDB      = yes
       or yes
    on error undo, throw:

    if not can-find(first ttTable
                      where ttTable.DatabaseName = bttDatabase.DatabaseName) then
      run qg_AddTables(bttDatabase.DatabaseName).

    for each bttTable
      where bttTable.DatabaseName       = b2ttDatabase.DatabaseName
        and bttTable.InternalIdentifier = cTableId,
    first bttField
      where bttField.DatabaseName = bttTable.DatabaseName
        and bttField.TableName    = bttTable.TableName
        and bttField.FieldName    = substitute('&1_Obj':U, bttTable.TableName)
      on error undo, throw:

      leave TABLE_SEARCH.

    end.

  end.

  // Step 2: try to find the table in the pA repository tables and load it into
  //         the cache

  if not available bttTable then
  do:

    TABLE_SEARCH:
    for each b2ttDatabase
      where b2ttDatabase.DatabaseName = bttDatabase.DatabaseName
         or b2ttDatabase.DatabaseName = bttDatabase.BasisDBName
         or b2ttDatabase.BasisDB      = yes
         or yes
      on error undo, throw:

      create buffer hRepTableBuffer for table substitute('&1.&2':U,
                                                         b2ttDatabase.DatabaseName,
                                                         'DRC_Table':U) no-error.

      if not valid-handle(hRepTableBuffer) then
        next.

      hRepTableBuffer:find-first(substitute('where DRC_Table.InternalIdentifier = &1':U,
                                            quoter(cTableId)),
                                 no-lock) no-error.

      if hRepTableBuffer:available then
      do:

        run qg_AddTableDetails(b2ttDatabase.DatabaseName,
                               hRepTableBuffer::DRC_Table_ID).

        for each bttTable
          where bttTable.DatabaseName       = b2ttDatabase.DatabaseName
            and bttTable.InternalIdentifier = cTableId,
        first bttField
          where bttField.DatabaseName = bttTable.DatabaseName
            and bttField.TableName    = bttTable.TableName
            and bttField.FieldName    = substitute('&1_Obj':U, bttTable.TableName)
          on error undo, throw:

          leave TABLE_SEARCH.

        end.

      end.

      finally:

        if valid-handle(hRepTableBuffer) then
          delete object hRepTableBuffer.

      end finally.

    end.

  end.

end.

if available bttTable then
  assign
    opcDatabaseName = bttTable.DatabaseName
    opcTableName    = bttTable.TableName
    .

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_GetOffsetLine hQueryWindow 
PROCEDURE qg_GetOffsetLine :
/**
 * Get line number for given offset.
 *
 * @param pcText = Text that contains the line.
 * @param piOffset = Offset for which the line number should be determined.
 * @param opiLine = Line number of offset.
 */

define input  parameter pcText   as character no-undo.
define input  parameter piOffset as integer   no-undo extent.
define output parameter opiLine  as integer   no-undo extent.

define variable i           as integer   no-undo.
define variable j           as integer   no-undo.

define variable iLineLength as integer   no-undo.
define variable iOffset     as integer   no-undo initial 1.

extent(opiLine) = extent(piOffset).

do i = 1 to num-entries(pcText, '~n':U):

  iLineLength = length(entry(i, pcText, '~n':U)).

  do j = 1 to extent(piOffset):

    if    piOffset[j] >= iOffset
      and piOffset[j]  < iOffset + iLineLength + length('~n':U) then
      opiLine[j] = i.

  end.

  iOffset = iOffset + iLineLength + length('~n':U).

end.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_GetWindowRect hQueryWindow 
PROCEDURE qg_GetWindowRect :
/**
 * Get screen rectangle of window.
 *
 * @param phWindow = Window handle.
 * @param opiWindowX1 = X1 coordinate of window.
 * @param opiWindowY1 = Y1 coordinate of window.
 * @param opiWindowX2 = X2 coordinate of window.
 * @param opiWindowY2 = Y2 coordinate of window.
 */

define input  parameter phWindow       as handle    no-undo.

define output parameter opiWindowX1 as integer   no-undo.
define output parameter opiWindowY1 as integer   no-undo.
define output parameter opiWindowX2 as integer   no-undo.
define output parameter opiWindowY2 as integer   no-undo.

define variable iHwnd                 as int64   no-undo.
define variable mRect                 as memptr  no-undo.
define variable iResult               as integer no-undo.

if phWindow:type = 'WINDOW':U then
  run GetParent(phWindow:hwnd,
                output iHwnd).

else
  iHwnd = phWindow:hwnd.

if iHwnd <> 0 then
do:

  set-size(mRect) = 16.

  run GetWindowRect(iHwnd,
                    output mRect,
                    output iResult).

  assign
    opiWindowX1 = get-long(mRect, 1)
    opiWindowY1 = get-long(mRect, 5)
    opiWindowX2 = get-long(mRect, 9)
    opiWindowY2 = get-long(mRect, 13)
    .

end.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_IDE_InsertText hQueryWindow 
PROCEDURE qg_IDE_InsertText :
/**
 * Insert given text into ide editor.
 *
 * @param pcText = Text that should be inserted.
 */

define input parameter pcText as character no-undo.

define variable cReturnValue     as character no-undo.

define variable iIDEWindowHandle as int64     no-undo.

if (    OEIDEIsRunning
    and glIDECanInsert
    and glInsertMode) then
do:

  run qg_IDE_SendRequest({&K_EDITOR_INSERT_REQUEST_HANDLER},
                         pcText,
                         yes /* plWaitForResult */,
                         output cReturnValue).

  if cReturnValue <> ? then
  do:

    iIDEWindowHandle = qg_iParamListReadValue(cReturnValue,
                                              'IDEWindowHandle':U,
                                              {&K_PARAM_SPLITTER}).

    if iIDEWindowHandle > 0 then
      run SetForegroundWindow(iIDEWindowHandle).

  end.

end.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_IDE_SendRequest hQueryWindow 
PROCEDURE qg_IDE_SendRequest :
/**
 * Send given Reqest to ide.
 *
 * This has to be a procedure (may not be a function) due to progress error
 * 2780.
 *
 * @param pcHandlerName = Name of the request handler for the re- quest that should be sent.
 * @param pcParmeter = String parameter value for the request.
 * @param plWaitForResult = If false, no result will be returned which will avoid the risk of getting stuck while waiting for the request result
 * @param opcReturnValue = Output return value.
 */

define input  parameter pcHandlerName   as character no-undo.
define input  parameter pcParameter     as character no-undo.
define input  parameter plWaitForResult as logical   no-undo.
define output parameter opcReturnValue  as character no-undo.

define variable hSocketClient as handle    no-undo.

if   not OEIDEIsRunning
  or not valid-handle(hOEIDEService) then
  return ?.

hSocketClient = dynamic-function ('getSocketClient':U in hOEIDEService).

if valid-handle(hSocketClient) then
  if plWaitForResult then

    run SendWaitRequest in hSocketClient ( qg_iGetHandlerId(pcHandlerName),
                                           pcParameter,
                                           output opcReturnValue).

  else

    run SendRequest in hSocketClient ( qg_iGetHandlerId(pcHandlerName),
                                       pcParameter ).

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_ImportDefinitionFile hQueryWindow 
PROCEDURE qg_ImportDefinitionFile :
/**
 * Import File as Snapshot.
 */

define input parameter piImportType as integer   no-undo.

define variable cTempFileName       as character no-undo.
define variable clImportFileContent as longchar  no-undo.

define variable iMessageCounter     as integer   no-undo.

define variable cImportFilename as character no-undo
  label 'Import file':T
  format 'x(1024)':U
  view-as fill-in
  size 73 by 1.

define button btnSearch
  label '->':T
  tooltip 'Determine full path':T
  size 7 by 1.

define button btnFileDialog
  label '...':T
  size 7 by 1.

define button btnOk
  label 'Import':T
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.

define frame fImport
  cImportFilename at row 1.5 col 12 colon-aligned
  btnSearch at row 1.5 col 85 colon-aligned
  btnFileDialog at row 1.5 col 92 colon-aligned
  btnOk at row 3.5 col 31
  btnCancel at row 3.5 col 51
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 103 by 5.33
    title 'Import File as Snapshot':T
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fImport
  apply 'end-error' to self.

on choose of btnSearch in frame fImport
do:

  define variable cFilename      as character no-undo.
  define variable cPath          as character no-undo.
  define variable cFilePath      as character no-undo.

  cFilename = input frame fImport cImportFilename.

  if length( cFilename ) < 2 then
    return.

  assign
    cPath     = qg_cModulePathByChar( cFilename )
    cPath     =   cPath
                + ( if cPath > '':U then
                      '/incl':U
                    else
                      'incl':U )
    cFilePath = search( substitute( '&1/&2':U, cPath, cFilename ) )
    .

  if cFilePath <> ? then

    display unless-hidden
      cFilePath @ cImportFilename
      with frame fImport.

end.

on choose of btnFileDialog in frame fImport
do:

  define variable lOk       as logical   no-undo.
  define variable cFilename as character no-undo.

  cFilename = input frame fImport cImportFilename.

  if piImportType = {&K_IMPORT_TYPE_TEMP_TABLE} then

    system-dialog get-file cFilename
      title             'Select TDF ...':U
      filters           'TDF-Files (*.tdf)':U '*.tdf':U,
                        'Any File (*.*)':U  '*.*':U
      default-extension '.tdf':U
      use-filename
      update lOk
      in window {&WINDOW-NAME}
      .

  else

    system-dialog get-file cFilename
      title             'Select PDS ...':U
      filters           'TDF-Files (*.pds)':U '*.pds':U,
                        'Any File (*.*)':U  '*.*':U
      default-extension '.pds':U
      use-filename
      update lOk
      in window {&WINDOW-NAME}
      .

  if lOk then
  do:

    cImportFilename = cFilename.

    display unless-hidden
      cImportFilename
      with frame fImport
        in window {&WINDOW-NAME}.

  end.

end.

on choose of btnOk in frame fImport
do:

  if index( input frame fImport cImportFilename, '/\':U ) = 0 then
    apply 'choose':U to btnSearch in frame fImport.

end.

frame fImport:title = substitute( '&1 Import &2 as Snapshot':U,
                                  gcTitlePrefix,
                                  ( if piImportType = {&K_IMPORT_TYPE_TEMP_TABLE} then
                                      'TDF':U
                                    else
                                      'PDS':U ) ).

DialogLoop:
do while yes
  on error undo, next
  on endkey undo, leave:

  update unless-hidden
    cImportFilename
    btnSearch
    btnFileDialog
    btnOk
    btnCancel
    with frame fImport
      in window {&WINDOW-NAME}.

  // Check if file exists.
  file-info:file-name = cImportFilename.

  if file-info:full-pathname = ? then
  do:

    message
      substitute( 'File &1 does not exist':T, quoter( cImportFilename ) ) skip
      view-as alert-box
      error
      buttons ok.

    apply 'error':U.

  end.

  if not file-info:file-type begins 'F':U then
  do:

    message
      substitute( '&1 is not a File':T, quoter( cImportFilename ) ) skip
      view-as alert-box
      error
      buttons ok.

    apply 'error':U.

  end.

  do on error undo, throw:

    // Create temp file for import.
    cTempFileName = substitute( qg_cFileName( '%Temp%\qg_Snapshot_&1.p':U ),
                                string( guid( generate-uuid ) ) ).

    do on error undo, throw.

      // os-copy did not work for whatever reason.
      output stream strTemp to value( cTempFileName ).

      put stream strTemp unformatted
        '&GLOBAL-DEFINE pa-XInclBasisName         DUMMY':U skip
        '&GLOBAL-DEFINE ippNoReferenceOnlySwitch  yes':U skip
        '~{adm/template/incl/dt_pa_00.df}':U skip
        .

      output stream strTemp close.

      copy-lob from file cImportFilename to clImportFileContent.
      copy-lob from clImportFileContent to file cTempFileName append.

      output stream strTemp to value( cTempFileName ) append.

      if piImportType = {&K_IMPORT_TYPE_TEMP_TABLE} then

        put stream strTemp unformatted
          '&IF defined( ppTempTableName ) &THEN':U skip
          '  publish ~'qgEvt_Snapshot~':U ( ( temp-table ~{&ppTempTableName}:handle ), ~'~{&ppTempTableName}~':U, ? ).':U skip
          '&ELSE':U skip
          '  message':U skip
          substitute( '    ~'Preprocessor "ppTempTableName" is not defined in file &1.~':U skip':U,
                      quoter( cImportFilename ) ) skip
          '    ~' ~':U skip':U skip
          '    ~'The include can not be imported.~':U skip':U skip
          '    view-as alert-box':U skip
          '    error':U skip
          '    buttons ok.':U skip
          '  apply ~'error~'.':U skip
          '&ENDIF':U skip
          .

      else

        put stream strTemp unformatted
          '&IF defined( ppDatasetName ) &THEN':U skip
          '  publish ~'qgEvt_Snapshot~':U ( ( dataset ~{&ppDatasetName}:handle ), ~'~{&ppDatasetName}~':U, ? ).':U skip
          '&ELSE':U skip
          '  message':U skip
          substitute( '    ~'Preprocessor "ppDatasetName" is not defined in file &1.~':U skip':U,
                      quoter( cImportFilename ) ) skip
          '    ~' ~':U skip':U skip
          '    view-as alert-box':U skip
          '    error':U skip
          '    buttons ok.':U skip
          '  apply ~'error~'.':U skip
          '&ENDIF':U skip
          .

      finally:

        output stream strTemp close.

      end finally.

    end.

    // Check if temp file has actually been created.
    file-info:file-name = cTempFileName.

    if file-info:full-pathname = ? then
    do:

      message
        substitute( 'File &1 could not be created':T, quoter( cTempFileName ) ) skip
        view-as alert-box
        error
        buttons ok.

      apply 'error':U.

    end.

    // Check syntax.
    do on error undo, throw:

      compile value( cTempFileName ).

      catch oError as Progress.Lang.Error:

        do iMessageCounter = 1 to oError:NumMessages:

          message
            oError:GetMessage( iMessageCounter ) skip
            view-as alert-box
            error
            buttons ok.

        end.

        message
          substitute( 'File &1 contains compile errors.':U,
                      quoter( cImportFilename ) ) skip
          ' ':U skip
           'The include can not be imported':T skip
          view-as alert-box
          error
          buttons ok.

        apply 'error':U.

      end catch. /* Progress.Lang.Error */

    end.

    // Run temp file to create the snapshot.
    run value( cTempFileName ).

    leave DialogLoop.

    finally:

      os-delete value( cTempFileName ).

    end finally.

  end.

end.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_ImportFile hQueryWindow 
PROCEDURE qg_ImportFile :
/**
 * Import File as Snapshot.
 */

define input parameter piImportType as integer   no-undo.

define variable cFileExt      as character no-undo.
define variable hDataObject   as handle    no-undo.
define variable cSnapshotName as character no-undo.

define variable cImportFilename as character no-undo
  label 'Import file':T
  format 'x(1024)':U
  view-as fill-in
  size 80 by 1.

define button btnFileDialog
  label '...':T
  size 7 by 1.

define button btnOk
  label 'Import':T
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T
  size 20 by 1.14
  auto-end-key.

define frame fImport
  cImportFilename at row 1.5 col 12 colon-aligned
  btnFileDialog at row 1.5 col 92 colon-aligned
  btnOk at row 3.5 col 31
  btnCancel at row 3.5 col 51
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 103 by 5.33
    title '':T
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fImport
  apply 'end-error' to self.

on choose of btnFileDialog in frame fImport
do:

  define variable lOk       as logical   no-undo.
  define variable cFilename as character no-undo.

  cFilename = input frame fImport cImportFilename.

  system-dialog get-file cFilename
    title             'Open File ...':U
    filters           'XML-Files (*.xml)':U '*.xml':U,
                      'JSON-Files (*.json)':U  '*.json':U,
                      'Any File (*.*)':U  '*.*':U
    default-extension '.xml':U
    ask-overwrite
    use-filename
    update lOk
    in window {&WINDOW-NAME}
    .

  if lOk then
  do:

    cImportFilename = cFilename.

    display unless-hidden
      cImportFilename
      with frame fImport
        in window {&WINDOW-NAME}.

  end.

end.

frame fImport:title = substitute( '&1 Import &2 from File':U,
                                  gcTitlePrefix,
                                  ( if piImportType = {&K_IMPORT_TYPE_TEMP_TABLE} then
                                      'Temp-Table':U
                                    else
                                      'Dataset':U ) ).

update unless-hidden
  cImportFilename
  btnFileDialog
  btnOk
  btnCancel
  with frame fImport
    in window {&WINDOW-NAME}.

do on error undo, throw:

  if piImportType = {&K_IMPORT_TYPE_TEMP_TABLE} then
    create temp-table hDataObject.

  else
    create dataset hDataObject.

  if cImportFilename matches '*.json':U then
    hDataObject:read-json( 'file':U,
                           cImportFilename,
                           'empty':U ).

  else
    hDataObject:read-xml( 'file':U,
                          cImportFilename,
                          'empty':U,
                          '':U,
                          false ).

  cSnapshotName = substitute('&1_&2':U,
                             hDataObject:name,
                             replace(string(time, 'HH:MM:SS':U),
                                     ':':U,
                                     '':U)).                          

  run qg_AddSnapshot( hDataObject, cSnapshotName, ? ).

  finally:

    if valid-handle( hDataObject ) then
      delete object hDataObject.

  end finally.

end.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_InitBrowse hQueryWindow 
PROCEDURE qg_InitBrowse :
/**
 * Init given Browse (set properties, add popup menu items ...)
 *
 * @param phBrowse = Browse that should be initialized.
 */

define input parameter phBrowse as handle    no-undo.

define variable hPopupMenu as handle    no-undo.
define variable hDummy     as handle    no-undo.
define variable lPrevMenu  as logical   no-undo.

assign
  phBrowse:sensitive        = yes /* code checked by mth */
  phBrowse:column-resizable = yes
  phBrowse:column-movable   = yes
  phBrowse:separators       = {&K_SHOW_GRID_ON_BROWSE}
  .

phBrowse:set-repositioned-row(3, 'CONDITIONAL':U).

hPopupMenu = phBrowse:popup-menu.

if not valid-handle(hPopupMenu) then
  create menu hPopupMenu
    assign
      name       = 'm_PopupMenu':U
      popup-only = yes
      sensitive  = yes
      .

else
  lPrevMenu = yes.

if   phBrowse:name = 'brQuery':U 
  or {&K_SELECT_COLUMN_ON_BROWSE}
  or {&K_EXPORT_ON_BROWSE}
  or {&K_RECORD_COUNT_ON_BROWSE} then
do:

  if lPrevMenu then
    create menu-item hDummy
      assign
        subtype = 'RULE':U
        parent  = hPopupMenu
        .

  if   phBrowse:name = 'brQuery':U
    or {&K_SELECT_COLUMN_ON_BROWSE} then
    create menu-item hDummy
      assign
        name         = 'mi_SelectColumnsMenuItem':U
        parent       = hPopupMenu
        label        = 'Select columns':T
        sensitive    = yes
      triggers:
        on choose
          persistent run qg_SelectBrowseColumns in target-procedure
                           (phBrowse).
      end triggers
      .

  if   phBrowse:name = 'brQuery':U
    or {&K_EXPORT_ON_BROWSE} then
    create menu-item hDummy
      assign
        name         = 'mi_Export':U
        parent       = hPopupMenu
        label        = 'Export records':T
        sensitive    = yes
      triggers:
        on choose
          persistent run qg_ExportBrowse in target-procedure
                           (phBrowse).
      end triggers
      .

  if   phBrowse:name = 'brQuery':U
    or {&K_RECORD_COUNT_ON_BROWSE} then
    create menu-item hDummy
      assign
        name         = 'mi_RecordCount':U
        parent       = hPopupMenu
        label        = 'Record count':T
        sensitive    = yes
      triggers:
        on choose
          persistent run qg_ShowBrowseRecordCount in target-procedure
                           (phBrowse).
      end triggers
      .

  lPrevMenu = yes.

end.

if   {&K_TOGGLE_GRID_ON_BROWSE}
  or phBrowse:name = 'brQuery':U then
do:

  if lPrevMenu then
    create menu-item hDummy
      assign
        subtype = 'RULE':U
        parent  = hPopupMenu
        .

  create menu-item hDummy
    assign
      name        = 'mi_ShowGrid':U
      label       = 'Show grid':T
      toggle-box  = yes
      checked     = {&K_SHOW_GRID_ON_BROWSE}
      sensitive   = yes
      parent      = hPopupMenu
    triggers:
      on value-changed
        persistent run qg_ShowBrowseGrid in target-procedure
                         (phBrowse, hDummy).
    end triggers
    .

  lPrevMenu = yes.

end.

phBrowse:popup-menu = hPopupMenu.

on ctrl-l of phBrowse
  persistent run qg_SelectBrowseColumns in target-procedure
                   (phBrowse).

on ctrl-e of phBrowse
  persistent run qg_ExportBrowse in target-procedure
                   (phBrowse).

on ctrl-u of phBrowse
  persistent run qg_ShowBrowseRecordCount in target-procedure
                   (phBrowse).

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_Initialize hQueryWindow 
PROCEDURE qg_Initialize :
/**
 * Initialize.
 */

define variable cProcName        as character no-undo.

define variable cEnvironment     as character no-undo.
define variable oDCCAppConfigSvc as Progress.Lang.Object no-undo.

define variable iStrSize         as integer   no-undo.

define variable cDefaultFont     as character no-undo.

gcCustomLevel = dynamic-invoke( 'pACStartupSvc':U, 'cParameterValue':U, 'CustomLevel':U ) no-error.

assign
  glInvertQuery:hidden in frame {&FRAME-NAME}
      = yes
  menu-item mi_ShowQueryTypeModifier:checked in menu M_Options
      = {&K_SHOW_QUERY_TYPE_MODIFIER}
  glAlwaysUseFindFirst    = {&K_ALWAYS_USE_FIND_FIRST}
  menu-item mi_AlwaysUseFindFirst:checked in menu M_Options
      = glAlwaysUseFindFirst
  glAlwaysUseCanFindFirst = {&K_ALWAYS_USE_CANFIND_FIRST}
  menu-item mi_AlwaysUseCanFindFirst:checked in menu M_Options
      = glAlwaysUseCanFindFirst
  glUseVirtualIndexApi    = {&K_DEFAULT_USE_VIRTUAL_INDEX_API}
  menu-item mi_UseVirtualIndexApi:checked in menu M_Options
      = glUseVirtualIndexApi
  cProcName               = replace(this-procedure:name, '\':U, '/':U)
  file-info:file-name     = substitute('&1/../icons':U, cProcName)
  .

run qg_SetShowQueryTypeModifier({&K_SHOW_QUERY_TYPE_MODIFIER}).

if file-info:full-pathname = ? then
  file-info:file-name = substitute('&1/../../icons':U, cProcName).

if file-info:full-pathname > '':U then
  gcIconDir = file-info:full-pathname.

if gcIconDir = '':U then
  hQueryWindow:load-icon(substitute('adeicon/sqlexp.ico':U)) no-error.

else
do:

  hQueryWindow:load-icon(substitute('&1/32/query_wizard.ico':U,
                                      gcIconDir)) no-error.

  hQueryWindow:load-small-icon(substitute('&1/16/query_wizard.ico':U,
                                          gcIconDir)) no-error.

end.

gcCursorHand = qg_cReadRegistryValue({&K_WIN_CONST_HKEY_CURRENT_USER},
                                     'Control Panel\Cursors':U,
                                     'Hand':U).

if gcCursorHand > '':U then
  run ExpandEnvironmentStringsA(gcCursorHand,
                                output gcCursorHand,
                                length(gcCursorHand),
                                output iStrSize).

get-key-value section "startup" key "DefaultFont" value cDefaultFont.

glUnicode = (session:charset = 'UTF-8':U).

if glUnicode then
  assign
    gcSpace                = chr(14909568)
    gcBulletChar1          = chr(14849926)
    gcBulletChar1White     = chr(14849927)
    gcBulletChar2          = chr(14850181)
    gcBulletChar2White     = chr(14850182)
    gcLineVertical         = chr(14849155)
    gcLineUpAndRight       = chr(14849175)
    gcLineVerticalAndRight = chr(14849187)
    .

else
  if lookup(entry(1, cDefaultFont), 'MS Sans Serif,MS Serif,System,Courier':U) = 0 then
//  if entry(1, cDefaultFont) = 'Microsoft Sans Serif':U
    assign
      gcSpace                = '    ':U
      gcBulletChar1          = '':U
      gcBulletChar1White     = '':U
      gcBulletChar2          = '':U
      gcBulletChar2White     = '':U
      gcLineVertical         = '    ':U 
      gcLineUpAndRight       = '    ':U
      gcLineVerticalAndRight = '    ':U
      .

//else
//  if lookup(entry(1, cDefaultFont), 'MS Sans Serif,MS Serif,System,Courier':U) = 0 then

  else
    assign
      gcSpace                = '    ':U
      gcBulletChar1          = '->':U
      gcBulletChar1White     = '->':U
      gcBulletChar2          = '=>':U
      gcBulletChar2White     = '=>':U
      gcLineVertical         = '    ':U 
      gcLineUpAndRight       = '    ':U
      gcLineVerticalAndRight = '    ':U
      .

if OEIDEIsRunning then
  gcIDEProjectName = getProjectName().

// Try to get the session title.
&IF keyword-all('dynamic-property':U) <> ? &THEN

  gcSessionTitle = dynamic-property('pACConnectionSvc':U,
                                    'prpcSessionTitle':U) no-error.

  &IF   keyword-all('dynamic-invoke':U) <> ?
    and keyword-all('valid-object':U)   <> ? &THEN

    if   gcSessionTitle       = ?
      or trim(gcSessionTitle) = '':U then
    do:

      cEnvironment = dynamic-invoke('pACStartupSvc',
                                    'cParameterValue':U,
                                    'Environment':U) no-error.

      if    not error-status:error
        and cEnvironment > '':U then
      do:

        oDCCAppConfigSvc = dynamic-property('adm.config.cls.DCCAppConfigSvc', 'prpoInstance') no-error.

        if    not error-status:error
          and valid-object(oDCCAppConfigSvc) then
        do:

          gcSessionTitle = trim(dynamic-invoke(oDCCAppConfigSvc,
                                               'cParamValByRefParamVal':U,
                                               'DB_Environment_desc':U,
                                               cEnvironment)) no-error.

        end.

      end.

    &ENDIF

  end.

&ENDIF

if gcSessionTitle = ? then
  gcSessionTitle = dynamic-function('pa_cConfgParameterValue':U in target-procedure,
                                    'SessionTitle':U) no-error.

if gcSessionTitle > '':U then
  gcTitlePrefix = substitute('&1 - ':U,
                             gcSessionTitle).

else if gcIDEProjectName > '':U then
  gcTitlePrefix = substitute('&1 - ':U,
                             gcIDEProjectName).

hQueryWindow:title = trim(substitute('&1Query Generator v&2':U,
                                     gcTitlePrefix,
                                     {&K_Version})).

if not valid-handle(gchMerge) then
  create 'Merge70.Application':U gchMerge no-error.

if not valid-handle(gchMerge) then
  create 'Merge65.Application':U gchMerge no-error.

if not valid-handle(gchMerge) then
  create 'Merge2000.Application':U gchMerge no-error.
//if valid-handle(gchMerge) then
//gchMerge:visible = no.
run qg_InitializeVirtualDBFieldFramework.
run qg_InitializeVirtualIndexFramework.

menu-item mi_OpenQueryWindowPersistentTT:checked in menu m_Options = yes.

run qg_InitBrowse(browse brDatabase:handle).
run qg_InitBrowse(browse brTable:handle).
run qg_InitBrowse(browse brField:handle).
run qg_InitBrowse(browse brIndex:handle).
run qg_InitBrowse(browse brRelation:handle).

run qg_SetDefaultValues.

assign
  glSessionTriggerShowMessage = {&K_SESSIONTRIGGER_SHOWMESSAGE} 
  glSessionTriggerWriteLog    = {&K_SESSIONTRIGGER_WRITELOG} 
  gcSessionTriggerLogFileName = {&K_SESSIONTRIGGER_LOGFILENAME} 
  glSessionTriggerIndexValues = {&K_SESSIONTRIGGER_INDEXVALUES} 
  glSessionTriggerStackTrace  = {&K_SESSIONTRIGGER_STACKTRACE} 
  .

if gcSessionTriggerLogFileName = '':U then
  gcSessionTriggerLogFileName = '%Temp%\session-triggers.log':U.

// Assign buffer prefix button labels.
assign
  glCompanyViaClass:label in frame {&FRAME-NAME} = '{&K_CLASS_COMPANY_STATEMENT}':U
  btnBuffer1:label in frame {&FRAME-NAME}        = qg_cSubstituteChar({&K_BUFFER_PATTERN_LABEL_1}, '#':U, '':U)
  btnBuffer1:hidden in frame {&FRAME-NAME}       = ({&K_BUFFER_PATTERN_1} = '':U)
  btnBuffer2:label in frame {&FRAME-NAME}        = qg_cSubstituteChar({&K_BUFFER_PATTERN_LABEL_2}, '#':U, '':U)
  btnBuffer2:hidden in frame {&FRAME-NAME}       = ({&K_BUFFER_PATTERN_2} = '':U)
  btnBuffer3:label in frame {&FRAME-NAME}        = qg_cSubstituteChar({&K_BUFFER_PATTERN_LABEL_3}, '#':U, '':U)
  btnBuffer3:hidden in frame {&FRAME-NAME}       = ({&K_BUFFER_PATTERN_3} = '':U)
  btnBuffer4:label in frame {&FRAME-NAME}        = qg_cSubstituteChar({&K_BUFFER_PATTERN_LABEL_4}, '#':U, '':U)
  btnBuffer4:hidden in frame {&FRAME-NAME}       = ({&K_BUFFER_PATTERN_4} = '':U)
  btnBlock1:label in frame {&FRAME-NAME}         = {&K_BLOCK_PATTERN_LABEL_1}
  btnBlock1:hidden in frame {&FRAME-NAME}        = ({&K_BLOCK_PATTERN_1} = '':U)
  btnBlock2:label in frame {&FRAME-NAME}         = {&K_BLOCK_PATTERN_LABEL_2}
  btnBlock2:hidden in frame {&FRAME-NAME}        = ({&K_BLOCK_PATTERN_2} = '':U)
  btnBlock3:label in frame {&FRAME-NAME}         = {&K_BLOCK_PATTERN_LABEL_3}
  btnBlock3:hidden in frame {&FRAME-NAME}        = ({&K_BLOCK_PATTERN_3} = '':U)
  btnBlock4:label in frame {&FRAME-NAME}         = {&K_BLOCK_PATTERN_LABEL_4}
  btnBlock4:hidden in frame {&FRAME-NAME}        = ({&K_BLOCK_PATTERN_4} = '':U)
  .

&IF {&K_NUM_BUFFER_PATTERN_INDICES} > 0 &THEN

  run qg_CreateBufferButtonMenu(btnBuffer1:handle,
                                {&K_BUFFER_PATTERN_1},
                                {&K_BUFFER_PATTERN_LABEL_1}).

  run qg_CreateBufferButtonMenu(btnBuffer2:handle,
                                {&K_BUFFER_PATTERN_2},
                                {&K_BUFFER_PATTERN_LABEL_2}).

  run qg_CreateBufferButtonMenu(btnBuffer3:handle,
                                {&K_BUFFER_PATTERN_3},
                                {&K_BUFFER_PATTERN_LABEL_3}).

  run qg_CreateBufferButtonMenu(btnBuffer4:handle,
                                {&K_BUFFER_PATTERN_4},
                                {&K_BUFFER_PATTERN_LABEL_4}).

&ENDIF

// Set display mode.
run qg_SetDisplayMode({&K_DISPLAYMODE_INDEX}).

assign
  btnClearTableFilter:height in frame {&FRAME-NAME}         = gcTableFilter:height in frame {&FRAME-NAME}
  gcTableFilter:delimiter in frame {&FRAME-NAME}            = chr(1)
  btnClearTableFieldFilter:height in frame {&FRAME-NAME}    = gcTableFieldFilter:height in frame {&FRAME-NAME}
  gcTableFieldFilter:delimiter in frame {&FRAME-NAME}       = chr(1)
  btnClearFieldFilter:height in frame {&FRAME-NAME}         = gcFieldFilter:height in frame {&FRAME-NAME}
  gcFieldFilter:delimiter in frame {&FRAME-NAME}            = chr(1)
  btnClearFieldLabelFilter:height in frame {&FRAME-NAME}    = gcFieldLabelFilter:height in frame {&FRAME-NAME}
  gcFieldLabelFilter:delimiter in frame {&FRAME-NAME}       = chr(1)
  btnClearIndexFilter:height in frame {&FRAME-NAME}         = gcIndexFilter:height in frame {&FRAME-NAME}
  gcIndexFilter:delimiter in frame {&FRAME-NAME}            = chr(1)
  btnClearIndexFieldFilter:height in frame {&FRAME-NAME}    = gcIndexFieldFilter:height in frame {&FRAME-NAME}
  gcIndexFieldFilter:delimiter in frame {&FRAME-NAME}       = chr(1)
  btnClearRelationFilter:height in frame {&FRAME-NAME}      = gcRelationFilter:height in frame {&FRAME-NAME}
  gcRelationFilter:delimiter in frame {&FRAME-NAME}         = chr(1)
  btnClearRelationFieldFilter:height in frame {&FRAME-NAME} = gcRelationFieldFilter:height in frame {&FRAME-NAME}
  gcRelationFieldFilter:delimiter in frame {&FRAME-NAME}    = chr(1)
  .

assign
  hQueryWindow:max-width-pixels      = session:width-pixels
  hQueryWindow:virtual-width-pixels  = hQueryWindow:max-width-pixels
  hQueryWindow:max-height-pixels     = session:height-pixels
  hQueryWindow:virtual-height-pixels = hQueryWindow:max-height-pixels
  .

run qg_InitWidgetConstraints(frame {&FRAME-NAME}:handle).

assign
  gdOriginalWidth  = hQueryWindow:width-chars
  gdOriginalHeight = hQueryWindow:height-chars
  .

if {&K_SET_SLIM_MODE_ON_STARTUP} then
  run qg_SetSlimMode(yes).

// Init temp-tables and selection-list widgets.
run qg_LoadCache(?).

//assign
//hQueryWindow:width-chars  = maximum(minimum(hQueryWindow:width-chars,
//                                            session:width-chars),
//                                    {&K_WINDOW_MIN_WIDTH})
//hQueryWindow:height-chars = maximum(minimum(hQueryWindow:height-chars,
//                                            session:height-chars),
//                                    {&K_WINDOW_MIN_HEIGHT})
//.

//apply 'window-resized':U to hQueryWindow.
//> Performance-Test
//etime(yes).

//define buffer bttTable for temp-table ttTable.
//define variable i as integer       no-undo.

//for each bttTable
//where bttTable.DatabaseName = {&K_BASE_DB_NAME}
//on error undo, throw:

//run qg_AddTableDetails(bttTable.DatabaseName, bttTable.TableName).
//i = i + 1.

//end.

//message
//string(etime / 1000) skip
//i skip
//view-as alert-box
//title program-name(1).
// <- Performance-Test

// Subscribe to snapshot events.

subscribe
  to 'qgEvt_Snapshot':U
  anywhere
  run-procedure 'qg_AddSnapshot':U.

subscribe
  to 'qgEvt_SnapshotLine':U
  anywhere
  run-procedure 'qg_AddSnapshotLine':U.

apply 'entry':U to gcTableFilter in frame {&FRAME-NAME}.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_InitWidgetConstraints hQueryWindow 
PROCEDURE qg_InitWidgetConstraints :
/**
 * Adds widget size and position information to its private data. Children
 * of given handle are added recursively.
 *
 * @param phWidget = Widget handle.
 */

define input parameter phWidget as handle    no-undo.

define variable hChild as handle    no-undo.

if can-query(phWidget, 'private-data':U) then
do:

  assign
    phWidget:private-data = qg_cParamListWriteDecimal(phWidget:private-data,
                                                      'OriginalCol':U,
                                                      phWidget:col,
                                                      ',':U)
      when can-query(phWidget, 'col':U)
    phWidget:private-data = qg_cParamListWriteDecimal(phWidget:private-data,
                                                      'OriginalRow':U,
                                                      phWidget:row,
                                                      ',':U)
      when can-query(phWidget, 'row':U)
    phWidget:private-data = qg_cParamListWriteDecimal(phWidget:private-data,
                                                      'OriginalWidth':U,
                                                      phWidget:width-chars,
                                                      ',':U)
      when can-query(phWidget, 'width':U)
    phWidget:private-data = qg_cParamListWriteDecimal(phWidget:private-data,
                                                      'OriginalHeight':U,
                                                      phWidget:height-chars,
                                                      ',':U)
      when can-query(phWidget, 'height':U)
    .

  // Adjust side label position.
  if    can-query(phWidget, 'side-label-handle':U)
    and valid-handle(phWidget:side-label-handle)
    and can-query(phWidget:side-label-handle, 'private-data':U) then
    assign
      phWidget:side-label-handle:private-data = qg_cParamListWriteDecimal(phWidget:side-label-handle:private-data,
                                                                          'OriginalCol':U,
                                                                          phWidget:side-label-handle:col,
                                                                          ',':U)
        when can-query(phWidget:side-label-handle, 'col':U)
      phWidget:side-label-handle:private-data = qg_cParamListWriteDecimal(phWidget:side-label-handle:private-data,
                                                                          'OriginalRow':U,
                                                                          phWidget:side-label-handle:row,
                                                                          ',':U)
        when can-query(phWidget:side-label-handle, 'row':U)
        .

end.

if    can-query(phWidget, 'first-child':U)
  and can-query(phWidget, 'next-sibling':U) then
do:

  hChild = phWidget:first-child.

  do while valid-handle(hChild):
    run qg_InitWidgetConstraints(hChild).
    hChild = hChild:next-sibling.
  end.

end.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_InsertBufferDefinition hQueryWindow 
PROCEDURE qg_InsertBufferDefinition :
/**
 * Insert buffer definition for current table into ide.
 */

if glInsertMode then
  run qg_IDE_InsertText(substitute('define buffer $~{&1~} $~{cursor}for &2.':U,
                                   (if glSlimMode then
                                      substitute({&K_DEFAULT_BUFFER_PATTERN},
                                                 qg_cGetBufferBaseName(no))
                                    else
                                      input frame {&FRAME-NAME} gcBufferName),
                                   ttTable.TableName)).

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_InsertFieldAssigments hQueryWindow 
PROCEDURE qg_InsertFieldAssigments :
/**
 * Insert field assignments into ide.
 */

define variable cAssigments as character no-undo.

cAssigments = qg_cFieldAssignments(yes).

if cAssigments > '':U then
  run qg_IDE_InsertText(cAssigments).

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_InsertFieldAssignStatement hQueryWindow 
PROCEDURE qg_InsertFieldAssignStatement :
/**
 * Insert field assign statement into ide.
 */

define variable cAssignStatement as character no-undo.

cAssignStatement = qg_cFieldAssignStatement(yes).

if cAssignStatement > '':U then
  run qg_IDE_InsertText(cAssignStatement).

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_InsertPutStatement hQueryWindow 
PROCEDURE qg_InsertPutStatement :
/**
 * Insert field assign statement into ide.
 */

define variable cPutStatement as character no-undo.

cPutStatement = qg_cPutStatement(yes).

if cPutStatement > '':U then
  run qg_IDE_InsertText(cPutStatement).

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_InsertQueryText hQueryWindow 
PROCEDURE qg_InsertQueryText :
/**
 * Insert current query text.
 */

if    OEIDEIsRunning
  and glIDECanInsert
  and glInsertMode then
  run qg_IDE_InsertText( qg_cCreateQueryText( /* pcFieldList */ qg_cCurrentFieldList(),
                                              /* plAddTags   */ yes ) ).

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_InsertTextLines hQueryWindow 
PROCEDURE qg_InsertTextLines :
/**
 * Inserts given Text after line of given offset index.
 *
 * @param pcLines = Text that should be inserted.
 * @param piOffset = offset of the line after that the text should be inserted.
 * @param iopcText = Text in which the line should be inser- ted.
 * @param opiLine = Line number of the inserted line.
 */

define input        parameter pcLines  as character no-undo.
define input        parameter piOffset as integer   no-undo.
define input-output parameter iopcText as character no-undo.
define       output parameter opiLine  as integer   no-undo.

define variable i       as integer   no-undo.
define variable iOffset as integer   no-undo initial 1.

if length(iopcText) = 0 then
  assign
    opiLine  = 1
    iopcText = pcLines
    .

else
do:

  do i = 1 to num-entries(iopcText, '~n':U):

    if iOffset > piOffset then
      leave.

    iOffset = iOffset + length(entry(i, iopcText, '~n':U)) + length('~n':U). 

  end.

  if    iOffset - 1 > length(iopcText)
    and not iopcText matches '*~n':U then
    iopcText = substitute('&1~n':U, iopcText).

  assign
    opiLine = i
    iopcText  = substitute('&1&2&3':U,
                         substring(iopcText, 1, iOffset - 1),
                         (if pcLines matches('*~n':U) then
                            pcLines
                          else
                            substitute('&1~n':U, pcLines)),
                         substring(iopcText, iOffset)).
    .

end.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_LoadCache hQueryWindow 
PROCEDURE qg_LoadCache :
/**
 * Fill temp-tables for all connected Databases.
 */

define input parameter pcDatabaseName as character no-undo.

define variable cDatabaseName as character no-undo.

define buffer bttDatabase   for temp-table ttDatabase.
define buffer bttTable      for temp-table ttTable.

cDatabaseName = (if pcDatabaseName <> ? then
                   pcDatabaseName
                 else if available ttDatabase then
                   ttDatabase.DatabaseName
                 else
                   ?).

if pcDatabaseName > '':U then
  run qg_RemoveDatabase(pcDatabaseName).

else
do:

  for each bttDatabase
    where bttDatabase.PhysicalDB = yes
    on error undo, throw:

    run qg_RemoveDatabase(bttDatabase.DatabaseName).

  end.

  // Remove all invalid virtual tables.
  for each bttTable
    where bttTable.PhysicalTable = no
      and not valid-handle(bttTable.TableHandle)
    on error undo, throw:

    run qg_RemoveTable(bttTable.DatabaseName, bttTable.TableName).

  end.

  // Remove all virtual databases without temp-tables.
  for each bttDatabase
    where bttDatabase.PhysicalDB = no
      and not can-find(first ttTable
                         where ttTable.DatabaseName = bttDatabase.DatabaseName)
    on error undo, throw:

    run qg_RemoveDatabase(bttDatabase.DatabaseName).

  end.

end.

run qg_RefreshDatabaseBrowse(cDatabaseName).

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_LoadDataDefinitions hQueryWindow 
PROCEDURE qg_LoadDataDefinitions :
/**
 * Loads a df file.
 */

define input parameter phParentWindow as handle    no-undo.

define variable cDatabaseName as character no-undo.

define variable cOptions      as character no-undo.
define variable cWarnings     as character no-undo.

define variable cDataDefinitionFileName as character no-undo
  format 'x(255)':U
  label 'Filename':t
  view-as fill-in
  size 60 by 1.

define button btnFileDialog
  label '...':T
  size 7 by 1.

define variable lAddObjectsOnline as logical   no-undo
  format 'yes/no':U
  label 'Load new tables and sequences on-line':T
  view-as toggle-box
  size 50 by 1.

define variable lForceCommit as logical   no-undo
  format 'yes/no':U
  label 'Commit even with errors':T
  view-as toggle-box
  size 50 by 1.

define variable lForceIndexDeactivate as logical   no-undo
  format 'yes/no':U
  label 'Create new indexes inactive':T
  view-as toggle-box
  size 50 by 1.

define variable lForceSharedSchema as logical   no-undo
  format 'yes/no':U
  label 'Ignore multi-tenant properties':T
  view-as toggle-box
  size 50 by 1.

define button btnOk
  label 'Ok':T6
  size 20 by 1.14
  auto-go.

define button btnCancel
  label 'Cancel':T6
  size 20 by 1.14
  auto-end-key.

define buffer bttDatabase for temp-table ttDatabase.

define frame fDataDefintionsSettings
  cDataDefinitionFileName at row 1.5 col 12 colon-aligned
  btnFileDialog at row 1.5 col 72 colon-aligned
  lAddObjectsOnline at row 3 col 12 colon-aligned
  lForceCommit at row 4 col 12 colon-aligned
  lForceIndexDeactivate at row 5 col 12 colon-aligned
  lForceSharedSchema at row 6 col 12 colon-aligned
  btnOk at row 8 col 22
  btnCancel at row 8 col 42
  with 1 down keep-tab-order overlay
    view-as dialog-box 
    side-labels no-underline three-d 
    size 83 by 9.94
    title '':T
    default-button btnOk
    cancel-button btnCancel.

on window-close of frame fDataDefintionsSettings
  apply 'end-error' to self.

on choose of btnFileDialog in frame fDataDefintionsSettings
do:

  define variable lOk       as logical   no-undo.
  define variable cFilename as character no-undo.

  cFilename = input frame fDataDefintionsSettings cDataDefinitionFileName.

  system-dialog get-file cFileName
    title             substitute('&1Select df file for database "&2" ...':U,
                                 gcTitlePrefix,
                                 cDatabaseName)
    filters           'Data definitions (*.df)':U '*.df':U
    default-extension '.df':U
    use-filename
    update lOk
    .

  if lOk then
  do:

    cDataDefinitionFileName = cFilename.

    display unless-hidden
      cDataDefinitionFileName
      with frame fDataDefintionsSettings
        in window phParentWindow.

  end.

end.


if available ttDatabase then
do:

  cDatabaseName = ttDatabase.DatabaseName.

  frame fDataDefintionsSettings:title = substitute('&1Load data definition for database "&2"':U,
                                                   gcTitlePrefix,
                                                   cDatabaseName).

  &IF   keyword-all('dynamic-invoke':U) <> ?
    and keyword-all('valid-object':U)   <> ? &THEN

    cDataDefinitionFileName = dynamic-invoke('pACStartupSvc',
                                             'cParameterValue':U,
                                             'DumpDir':U) no-error.

  &ENDIF

  cDataDefinitionFileName = ( if cDataDefinitionFileName > '':U then
                                substitute( '&1\&2.df':U,
                                            cDataDefinitionFileName,
                                            ttDatabase.PhysicalName )
                              else
                                substitute( '&1.df':U, ttDatabase.PhysicalName ) ).

  update unless-hidden
    cDataDefinitionFileName
    btnFileDialog
    lAddObjectsOnline
    lForceCommit
    lForceIndexDeactivate
    lForceSharedSchema
    btnOk
    btnCancel
    with frame fDataDefintionsSettings
      in window phParentWindow. 

  assign
    cOptions = substitute('&1,&2':U,
                          cOptions,
                          'AddObjectsOnline':U)
        when lAddObjectsOnline
    cOptions = substitute('&1,&2':U,
                          cOptions,
                          'ForceCommit':U)
        when lForceCommit
    cOptions = substitute('&1,&2':U,
                          cOptions,
                          'ForceIndexDeactivate':U)
        when lForceIndexDeactivate
    cOptions = substitute('&1,&2':U,
                          cOptions,
                          'ForceSharedSchema':U)
        when lForceSharedSchema
    .

  run qg_SetWorkingDatabase.

  run prodict/load_df_silent.p (cDataDefinitionFileName, /* code checked by mth 30.07.2015 */
                                cOptions,
                                output cWarnings).

  // Reload cache.
  run qg_LoadCache(cDatabaseName).

  find bttDatabase
    where bttDatabase.DatabaseName = cDatabaseName
    no-error.

  if available bttDatabase then
  do:
    reposition brDatabase to rowid rowid(bttDatabase).
    apply 'value-changed':U to brDatabase in frame fQuery.
  end.

end.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_LoadIDESetting hQueryWindow 
PROCEDURE qg_LoadIDESetting :
/**
 * Loads given setting for current project.
 *
 * This has to be a procedure (may not be a function) due to progress error
 * 2780.
 *
 * @param pcSettingName = Name of the setting that should be loaded.
 * @param opcSettingValue = Output of setting value.
 */

define input  parameter pcSettingName   as character no-undo.
define output parameter opcSettingValue as character no-undo.

define variable cParamString  as character no-undo.

if    OEIDEIsRunning
  and glIDECanLoadSetting then
do:

  assign
    cParamString = qg_cParamListWriteCharacter(cParamString,
                                               'ProjectName':U,
                                               (if gcIDEProjectName <> ? then
                                                  gcIDEProjectName
                                                else
                                                  '':U),
                                               {&K_PARAM_SPLITTER})
    cParamString = qg_cParamListWriteCharacter(cParamString,
                                               'ParameterName':U,
                                               pcSettingName,
                                               {&K_PARAM_SPLITTER})
    .

  run qg_IDE_SendRequest({&K_LOAD_PLUGIN_SETTING_HANDLER},
                         cParamString,
                         yes /* plWaitForResult */,
                         output opcSettingValue).

end.

end procedure.

/* _UIB-CODE-BLOCK-END */
&ANALYZE-RESUME

&ANALYZE-SUSPEND _UIB-CODE-BLOCK _PROCEDURE qg_LoadQueryScenario hQueryWindow 
PROCEDURE qg_LoadQueryScenario :
/**
 * Load a previously stored query scenario.
 *
 * @param pcFileName = Filename that contains the scenario. If ? the scenario will be loaded from clipboard.
 */

define input parameter pcFileName          as character no-undo.
define input parameter plCloseQueryWindows as logical   no-undo.

define variable i                as integer   no-undo.

define variable clText           as longchar  no-undo.

define variable cBufferList      as character no-undo.
define variable cTargetQueryText as character no-undo.
define variable cParamList       as character no-undo.

define variable iWindowMode      as integer   no-undo.
define variable iWindowSize      as integer   no-undo.

define variable hSplitter1       as handle    no-undo.
define variable hRawValues       as handle    no-undo.

define variable lFieldOverlay    as logical   no-undo.
define variable cWindowList      as character no-undo.

define buffer bttQueryWindow             for temp-table ttQueryWindow.
define buffer bttRecentQuery             for temp-table ttRecentQuery.
define buffer bttFieldOverlay            for temp-table ttFieldOverlay.

define buffer bttQueryWindowExport       for temp-table ttQueryWindowExport.
define buffer btt2QueryWindowExport      for temp-table ttQueryWindowExport.
define buffer bttQueryBufferExport       for temp-table ttQueryBufferExport.
define buffer bttQueryFieldOverlayExport for temp-table ttQueryFieldOverlayExport.
define buffer bttRecentQueryExport       for temp-table ttRecentQueryExport.

if pcFileName <> ? then
  dataset dsQueryWindowExport:read-xml('File':U,
                                        pcFileName,
                                        'empty':U,
                                        ?,
                                        no).

else if lookup('PRO_TEXT':U, clipboard:available-formats) > 0 then
do:

  clText = qg_lcClipboardValue().

  if clText > '':U then
    dataset dsQueryWindowExport:read-xml('longchar':U,
                                          clText,
                                          'empty':U,
                                          ?,
                                          no).

end.

else
  return.

if    plCloseQueryWindows <> no
  and can-find(first ttQueryWindow) then
do:

  if plCloseQueryWindows = ? then
    message /* code checked by mth */
      'Do you want to close all currenty open query windows?':U
      view-as alert-box question
      buttons yes-no-cancel
      update plCloseQueryWindows
      in window hQueryWindow
      .

  if plCloseQueryWindows = ? then
    return.

  else if plCloseQueryWindows then
  do:

    for each bttQueryWindow
      on error undo, throw:

      if valid-handle(bttQueryWindow.WindowHandle) then
        run qg_QueryWindowClose(bttQueryWindow.WindowHandle, no).

    end.

  end.

end.

// Generate new seqence numbers.
for each bttQueryWindowExport
  on error undo, throw:

  assign
    giQuerySeq                       = giQuerySeq + 1
    bttQueryWindowExport.NewQuerySeq = giQuerySeq
    .

end.

// Now update external references in the query texts.
for each bttQueryWindowExport
  on error undo, throw:

  assign
    cBufferList   = '':U
    cParamList    = '':U
    lFieldOverlay = no
    .

  // Fix external references.
  cTargetQueryText = qg_cFixQuerySeq(bttQueryWindowExport.QueryText,
                                     bttQueryWindowExport.QuerySeq).

  // If the query scenario contains window state information for a
  // different window mode than the active mode the corresponding frame has
  // to be created as well. If this is the case then we start the query
  // window with the not avtivce window mode and switch it later to ensure
  // all needed frames are available.

  iWindowMode = (if bttQueryWindowExport.WindowMode = {&K_QUERY_WINDOW_MODE_RECORD_STR} then
                   {&K_QUERY_WINDOW_MODE_RECORD}
                 else
                   {&K_QUERY_WINDOW_MODE_QUERY}).

  if      iWindowMode = {&K_QUERY_WINDOW_MODE_RECORD}
    and ( num-entries(bttQueryWindowExport.BrowseColumns) > 0
       or bttQueryWindowExport.HideFieldList
       or bttQueryWindowExport.Splitter1Pos > 0 ) then
    assign
      iWindowMode = {&K_QUERY_WINDOW_MODE_QUERY}
      iWindowSize = {&K_QUERY_SIZE_MODE_DEFAULT}
      .

  else
    if    iWindowMode = {&K_QUERY_WINDOW_MODE_QUERY}
      and ( num-entries(bttQueryWindowExport.RecordBrowseColumns) > 0
         or num-entries(bttQueryWindowExport.RecordBrowseFields) > 0
         or bttQueryWindowExport.DisplayRawValues) then
      assign
        iWindowMode = {&K_QUERY_WINDOW_MODE_RECORD}.
        iWindowSize = {&K_