/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum Team {
    ALL("<ALL>", ".*"),
    UNASSIGNED("Unassigned modules", ".*"),
    COMMON("common modules (I_, IA, S_, SB, *)", "I_ IA S_ SB \\*"),
    CORE("Basis-Team (B*, D*, IB, IS)", "B\\w D\\w IB IS"),
    CAL("CA-Link-Team (PC)", "PC"),
    CCI("CCI-Team (U*)", "U\\w"),
    EVS("EVS-Team (E*, IE, IK, IV, V*)", "E\\w IE IK IV V\\w"),
    IDE("IDE-Team (DD, DU, DV)", "DD DU DV"),
    INWB("INWB/DMS/BI/WEB-Team (BI, BO, DI, O*, W*)", "BI BO DI O\\w W\\w"),
    MAWI("Mawi-Team (IJ, IM, J*, M*, SD, SE, SO, WS)", "IJ IM J\\w M\\w SD SE SO WS"),
    PK("PK-Team (MU)", "MU"),
    PPS("PPS-Team (IP, MA, MB, P*)", "IP MA MB P\\w"),
    REWE("Rewe-Team (A*, F*, IF, K*, L*, R*, SA, SK, T*)", "A\\w F\\w IF K\\w L\\w R\\w SA SK T\\w");

    private static final List<String> TEAM_LABELS;
    private static final Map<String, Team> BY_LABEL;
    private final String label;
    private final List<String> modules;

    static {
        TEAM_LABELS = new ArrayList<String>();
        BY_LABEL = new HashMap<String, Team>();
        Team[] teamArray = Team.values();
        int n = teamArray.length;
        int n2 = 0;
        while (n2 < n) {
            Team t = teamArray[n2];
            if (t.compareTo(COMMON) != 0) {
                TEAM_LABELS.add(t.label);
            }
            BY_LABEL.put(t.label, t);
            ++n2;
        }
    }

    private Team(String label, String modules) {
        this.label = label;
        this.modules = Arrays.asList(modules.split(" "));
    }

    public static Team valueOfLabel(String label) {
        return BY_LABEL.get(label);
    }

    public static String[] getTeams() {
        return (String[])TEAM_LABELS.stream().toArray(String[]::new);
    }

    public String getLabel() {
        return this.label;
    }

    public List<String> getModules() {
        return this.modules;
    }
}

