/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.gitutils.cherrypick;

import com.proalpha.pds.gitutils.cherrypick.CherryPick;
import com.proalpha.pds.gitutils.cherrypick.CherryPickOperation;
import com.proalpha.pds.gitutils.cherrypick.CherryPickResultDialog;
import com.proalpha.pds.gitutils.cherrypick.CherryPickSettings;
import com.proalpha.pds.gitutils.common.CheckoutOperation;
import com.proalpha.pds.pagit.PaGit;
import com.proalpha.pds.pagit.commands.PaIssueConveyanceCommand;
import com.proalpha.pds.pagit.model.PaCherryPickResult;
import com.proalpha.pds.pagit.util.PaBranchName;
import com.proalpha.pds.pagit.util.PaCommitMsg;
import com.proalpha.pds.pagit.util.PaRepository;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.staging.StagingView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.CherryPickResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CherryPickJob
extends Job {
    private final Logger logger = LoggerFactory.getLogger(CherryPickJob.class);
    private int noOfCommits = 0;

    public CherryPickJob(int noOfCommits) {
        super(MessageFormat.format("Cherry picking {0} commits", noOfCommits));
        this.noOfCommits = noOfCommits;
    }

    protected IStatus run(IProgressMonitor monitor) {
        PaIssueConveyanceCommand picCo = CherryPick.getInstance().getCherryPickCommand();
        CherryPickSettings cherryPickSettings = CherryPick.getInstance().getCherryPickSettings();
        PaCherryPickResult cpResult = null;
        CherryPickResult.CherryPickStatus cpStatus = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Pa CherryPick", (int)(this.noOfCommits + 2));
        CherryPickOperation cpOp = new CherryPickOperation(picCo);
        CheckoutOperation coOp = cherryPickSettings.getTargetBranchPoint().startsWith("origin") ? new CheckoutOperation(picCo.getRepository(), "origin", cherryPickSettings.getTargetBranchPoint(), PaBranchName.getShortBranchName(picCo.getTargetRef()), cherryPickSettings.isUpdateTargetBranchPoint(), true) : new CheckoutOperation(picCo.getRepository(), PaBranchName.getShortBranchName(picCo.getTargetRef()));
        try {
            try {
                progress.setTaskName("Creating the target branch");
                coOp.run();
                progress.worked(1);
                progress.setTaskName("Picking the commits");
                PaGit.getInstance().setProgressMonitor((ProgressMonitor)new EclipseGitProgressTransformer((IProgressMonitor)progress.newChild(this.noOfCommits)));
                cpOp.execute();
                CherryPick.getInstance().setCherryPickResult(cpOp.getOperationResult());
                cpResult = CherryPick.getInstance().getCherryPickResult();
                cpStatus = CherryPick.getInstance().getCherryPickResult().getStatus();
                if (cpStatus != CherryPickResult.CherryPickStatus.OK) {
                    this.setConflictMessage(cherryPickSettings, cpResult);
                } else {
                    try {
                        PaRepository.disconnectRemote(String.valueOf('_') + cherryPickSettings.getSourceRepoString());
                    }
                    catch (IOException | GitAPIException e) {
                        this.logger.error("Exception while disconnecting remote {}", (Object)picCo.getSourceRef(), (Object)e);
                    }
                }
                this.showResultDialog(monitor, picCo.getRepository(), cpResult);
            }
            catch (InvocationTargetException | GitAPIException e) {
                Throwable cause = e.getCause() == null ? e : e.getCause();
                String msg = cause.getMessage();
                Display.getDefault().asyncExec(() -> MessageDialog.openError(null, (String)"Cherry pick failed", (String)msg));
                if (CherryPick.getInstance().getCherryPickResult() == null || CherryPick.getInstance().getCherryPickResult() != null && CherryPick.getInstance().getCherryPickResult().getStatus() == CherryPickResult.CherryPickStatus.OK) {
                    CherryPick.getInstance().reinitialize();
                }
                monitor.done();
            }
        }
        finally {
            if (CherryPick.getInstance().getCherryPickResult() == null || CherryPick.getInstance().getCherryPickResult() != null && CherryPick.getInstance().getCherryPickResult().getStatus() == CherryPickResult.CherryPickStatus.OK) {
                CherryPick.getInstance().reinitialize();
            }
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        if (JobFamilies.CHERRY_PICK.equals(family)) {
            return true;
        }
        return super.belongsTo(family);
    }

    private void setConflictMessage(CherryPickSettings settings, PaCherryPickResult result) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            StagingView view = (StagingView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.egit.ui.StagingView");
            this.logger.debug("Commit failed: Initialize the commit msg of the git staging view.");
            if (view != null) {
                String msg = PaCommitMsg.getCherryPickMsg(settings.getTargetIssue(), result.getOpenPicks().get(0).getFullMessage(), result.getOpenPicks().get(0).getId().name());
                msg = String.valueOf(msg) + System.getProperty("line.separator");
                msg = String.valueOf(msg) + System.getProperty("line.separator");
                msg = String.valueOf(msg) + "Conflict resolution: DO NOT EDIT THIS MESSAGE";
                view.setCommitText(msg);
                view.setFocus();
            }
        });
    }

    private void showResultDialog(IProgressMonitor monitor, Repository repository, PaCherryPickResult cherryPickResult) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            int n = new CherryPickResultDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), monitor, cherryPickResult).open();
        });
    }
}

