/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.pagit.util.bitbucket;

import com.proalpha.pds.pagit.PaGitConfig;
import com.proalpha.pds.pagit.model.server.GitServerRepository;
import com.proalpha.pds.pagit.util.bitbucket.BitbucketCloudRestCallGetRepoList;
import com.proalpha.pds.pagit.util.bitbucket.BitbucketRestCallGetRepoList;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketGetRepoList {
    private final Logger logger = LoggerFactory.getLogger(BitbucketGetRepoList.class);
    private final String baseUrl = PaGitConfig.getStringFromConfig("bitbucket.server");
    private final Boolean isCloud = this.baseUrl.contains("bitbucket.org");

    public ArrayList<GitServerRepository> fetchRepositories() {
        this.logger.info("Fetching repositories from {}", (Object)this.baseUrl);
        if (this.isCloud.booleanValue()) {
            BitbucketCloudRestCallGetRepoList restCall = new BitbucketCloudRestCallGetRepoList();
            restCall.setSubUrl(String.format("repositories/%s", PaGitConfig.getStringFromConfig("bitbucket.workspace")));
            return restCall.fetchAllPages();
        }
        BitbucketRestCallGetRepoList restCall = new BitbucketRestCallGetRepoList();
        restCall.setSubUrl("repos");
        restCall.execute();
        return (ArrayList)restCall.getRestResponse();
    }
}

