/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.paconnector.repository;

import com.proalpha.pds.paconnector.Activator;
import com.proalpha.pds.paconnector.PaProject;
import com.proalpha.pds.paconnector.RunCommonPaProgram;
import com.proalpha.pds.paconnector.exception.ProALPHANotAvailableException;
import com.proalpha.pds.paconnector.repository.DatasetCatalog;
import com.proalpha.pds.paconnector.repository.RepositoryInformations;
import com.proalpha.pds.paconnector.utils.ExceptionUtils;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class RepositoryInformationsImpl
extends RunCommonPaProgram
implements RepositoryInformations {
    public static final List<String> instanceExtentions = Collections.unmodifiableList(new ArrayList<String>(){
        private static final long serialVersionUID = 459592606466143041L;
        {
            this.add("w");
            this.add("p");
            this.add("cls");
            this.add("dyn");
        }
    });

    public RepositoryInformationsImpl(PaProject paProject) throws ProALPHANotAvailableException {
        super(paProject);
    }

    @Override
    public Boolean exitsInstanceInRepository(String instanceName) {
        return this.runSupportProcedure("ds_oea12.p", instanceName).equals("yes");
    }

    @Override
    public Boolean exitsTableInRepository(String tableName) {
        return this.runSupportProcedure("ds_oea29.p", tableName).endsWith("yes");
    }

    @Override
    public DatasetCatalog getDatasetCatalog() {
        String datasetCatalogXmlString = this.runProgressCommand(this.getSupportProcedurePath("ds_oea71.p"), "", false, true);
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DatasetCatalog.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            return (DatasetCatalog)jaxbUnmarshaller.unmarshal((Reader)new StringReader(datasetCatalogXmlString));
        }
        catch (JAXBException e) {
            ExceptionUtils.showAndLogErrorMessage(Activator.getDefault(), e);
            return null;
        }
    }

    @Override
    public String getAbsolutPath(String fileName) {
        String projectRoot = new File(".").getAbsolutePath();
        return this.runSupportProcedure("ds_oea02.p", projectRoot, fileName);
    }

    @Override
    public String getClassName(String classOID) {
        return this.runSupportProcedure("ds_oea11.p", classOID, "DRC_Class_ID");
    }

    @Override
    public String getClassInformation(String drcClassObj, String request) {
        return this.runSupportProcedure("ds_oea11.p", drcClassObj, request);
    }

    @Override
    public String getClassOBJ(String fileName) {
        if (this.isInstanceObject(fileName)) {
            return this.runSupportProcedure("ds_oea10.p", fileName, "DRC_Class_Obj");
        }
        return "";
    }

    @Override
    public String getInstanceID(String instanceObj) {
        return this.runSupportProcedure("ds_oea46.p", instanceObj, "DRC_Instance_ID");
    }

    @Override
    public String getInstanceObj(String fileName) {
        return this.runSupportProcedure("ds_oea48.p", fileName, "DRC_Instance_Obj");
    }

    @Override
    public String getClassGroupOf(String className) {
        return this.getClassInformation(className, "ClassGroupCode");
    }

    @Override
    public String getListOfTableFields(String tableName) {
        return this.runSupportProcedure("ds_oea28.p", tableName, "ListOfFieldNames");
    }

    @Override
    public String getListOFSubClasses(String rootClass) {
        return this.getClassInformation(rootClass, "ListOfSubClasses");
    }

    @Override
    public String getMessageText(String messageCode, String text) {
        return this.runSupportProcedure("ds_oea16.p", messageCode, text);
    }

    @Override
    public String getModule(String fileName) {
        Hashtable<String, String> selection = new Hashtable<String, String>();
        selection.put("ModulName", this.getProductName(fileName));
        selection.put("Kennbuchstabe", fileName.substring(1, 2));
        return this.getRecordField("D_UnterModul", selection, "UnterModulName");
    }

    @Override
    public String getModuleDescription(String fileName) {
        Hashtable<String, String> selection = new Hashtable<String, String>();
        selection.put("ModulName", this.getProductName(fileName));
        selection.put("UnterModulName", this.getModule(fileName));
        selection.put("Sprache", "###Language###");
        return this.getRecordField("D_UnterModulSpr", selection, "Bezeichnung");
    }

    @Override
    public String getProductDescription(String fileName) {
        Hashtable<String, String> selection = new Hashtable<String, String>();
        selection.put("ModulName", this.getProductName(fileName));
        selection.put("Sprache", "###Language###");
        return this.getRecordField("D_ModulSpr", selection, "Bezeichnung");
    }

    @Override
    public String getProductName(String fileName) {
        Hashtable<String, String> selection = new Hashtable<String, String>();
        selection.put("Kennbuchstabe", fileName.substring(0, 1));
        return this.getRecordField("D_Modul", selection, "ModulName");
    }

    @Override
    public String getProgramShortDesc(String fileName) {
        if (this.isInstanceObject(fileName)) {
            return this.runSupportProcedure("ds_oea10.p", fileName, "ShortDesc1");
        }
        return "";
    }

    @Override
    public String getRelativePath(String fileName) {
        return this.runSupportProcedure("ds_oea13.p", fileName);
    }

    @Override
    public String getTableCompanyInclude(String tableName) {
        return this.getTableInformation(tableName, "CompanyInclude");
    }

    @Override
    public String getTableInformation(String tableName, String request) {
        return this.runSupportProcedure("ds_oea28.p", tableName, request);
    }

    @Override
    public Object isInstanceOfClass(String instance, String className) {
        return this.runSupportProcedure("ds_oea52.p", instance, className);
    }

    @Override
    public boolean isObjectBlockable(String fileName) {
        if (this.isInstanceObject(fileName)) {
            return this.runSupportProcedure("ds_oea10.p", fileName, "blockable").equals("yes");
        }
        return false;
    }

    private boolean isInstanceObject(String fileName) {
        if (fileName.contains(".")) {
            String FileExt = fileName.split(Pattern.quote("."))[1];
            return instanceExtentions.contains(FileExt);
        }
        return false;
    }
}

