/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.projconf.importwizards;

import com.proalpha.pds.paconnector.Activator;
import com.proalpha.pds.projconf.utils.Project;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class ImportPageOne
extends WizardPage {
    private static final String DEMAS_CONFIG_FILE = "PDSconfig.properties";
    private static final String DEMAS_CONFIG_LABEL = "DEMAS Install Files";
    private static final String COM_OPENEDGE_PDT_CORE_BUNDLE = "com.openedge.pdt.core";
    private Text freeProjectInputTextBox;
    private CheckboxTableViewer projectTableCheckboxes;
    private List<Project> projects;
    private List<Project> importableProjects;
    private String progressVersion;

    public ImportPageOne() {
        super("First Page");
        this.setTitle("select proALPHA Installations");
        this.setDescription("Import proALPHA DEMAS installations into the PDS");
        Bundle openEdgeBundle = Platform.getBundle((String)COM_OPENEDGE_PDT_CORE_BUNDLE);
        Version version = openEdgeBundle.getVersion();
        this.progressVersion = String.format("%s.%s.%s", version.getMajor(), version.getMinor(), version.getMicro());
        this.projects = Project.all(Paths.get(Activator.getDefault().getPreferenceStore().getString("PaProjectDirectory"), new String[0]));
        Collections.sort(this.projects);
        this.importableProjects = this.projects.stream().filter(project -> !project.imported()).filter(project -> project.progressVersion().equals(this.progressVersion)).collect(Collectors.toList());
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        this.setControl((Control)container);
        Label freeProjectInputLabel = new Label(container, 0);
        freeProjectInputLabel.setText("Project Information File");
        this.freeProjectInputTextBox = new Text(container, 2052);
        this.freeProjectInputTextBox.setLayoutData((Object)new GridData(768));
        this.freeProjectInputTextBox.addKeyListener((KeyListener)new CheckTextboxListener());
        Button freeProjectInputButton = new Button(container, 8);
        freeProjectInputButton.setText("...");
        freeProjectInputButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileopen = new FileDialog(Display.getCurrent().getActiveShell());
                String[] filterExtensions = new String[]{ImportPageOne.DEMAS_CONFIG_FILE};
                fileopen.setFilterExtensions(filterExtensions);
                String[] filterNames = new String[]{ImportPageOne.DEMAS_CONFIG_LABEL};
                fileopen.setFilterNames(filterNames);
                String targetFile = fileopen.open();
                if (targetFile != null) {
                    ImportPageOne.this.freeProjectInputTextBox.setText(targetFile);
                }
                ImportPageOne.this.validate();
            }
        });
        new Label(container, 0);
        GridData projectsTableLayout = new GridData();
        projectsTableLayout.heightHint = 254;
        projectsTableLayout.horizontalAlignment = 4;
        Table projectsTable = new Table(container, 546);
        projectsTable.setLayoutData((Object)projectsTableLayout);
        projectsTable.setBackground(freeProjectInputLabel.getBackground());
        this.projectTableCheckboxes = new CheckboxTableViewer(projectsTable);
        this.projectTableCheckboxes.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ImportPageOne.this.validate();
            }
        });
        for (Project project : this.importableProjects) {
            this.projectTableCheckboxes.add((Object)project.name());
        }
        new Label(container, 0);
        new Label(container, 0);
        Button projectTableSelectAll = new Button(container, 32);
        projectTableSelectAll.setText("select all items");
        projectTableSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button btn = (Button)event.getSource();
                ImportPageOne.this.projectTableCheckboxes.setAllChecked(btn.getSelection());
                ImportPageOne.this.validate();
            }
        });
        new Label(container, 0);
        this.validate();
    }

    public List<Project> getSelectedProjects() {
        List<Project> selectedProjects = Arrays.stream(this.projectTableCheckboxes.getCheckedElements()).map(Object::toString).map(name -> Project.findProjectByName(name, this.projects)).filter(project -> project != null).collect(Collectors.toList());
        Project singleProject = Project.findProjectByDeMasConfigFile(Paths.get(this.freeProjectInputTextBox.getText(), new String[0]), this.projects);
        if (singleProject != null) {
            selectedProjects.add(singleProject);
        }
        return selectedProjects;
    }

    private boolean validate() {
        boolean resetMessage = true;
        for (Project project : this.getSelectedProjects()) {
            if (project.imported()) {
                this.setMessage(String.format("Unable to import project %s (Already imported)", project.name()), 3);
                this.setPageComplete(false);
                return false;
            }
            if (!project.progressVersion().equals(this.progressVersion)) {
                this.setMessage(String.format("Unable to import project %s (Wrong progress version)", project.name()), 3);
                this.setPageComplete(false);
                return false;
            }
            if (project.type().equals("cons") && !project.fullyCreated()) {
                this.setMessage(String.format("Unable to import project %s (Not fully created yet (Wait for the first reconcile and update your local Git Repository))", project.name()), 3);
                this.setPageComplete(false);
                return false;
            }
            String missingKey = project.demasFile().missingPropertyKey();
            if (missingKey != null) {
                this.setMessage(String.format("Unable to import project %s (Missing key %s in the DeMaS config file)", project.name(), missingKey), 3);
                this.setPageComplete(false);
                return false;
            }
            Project projectWithSamePort = this.projects.stream().filter(p -> !p.equals(project) && p.dbPort() == project.dbPort()).findFirst().orElse(null);
            if (projectWithSamePort == null) continue;
            String msg = String.format("You try to import %s, but %s uses the same database ports.", project.name(), projectWithSamePort.name());
            this.setMessage(msg, 2);
            resetMessage = false;
        }
        if (resetMessage) {
            this.setMessage(null);
        }
        this.setPageComplete(true);
        return true;
    }

    private final class CheckTextboxListener
    implements KeyListener {
        private CheckTextboxListener() {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            ImportPageOne.this.validate();
        }
    }
}

