/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.templates.helper;

import com.openedge.core.metadata.DataTypes;
import com.openedge.core.metadata.IDataType;
import com.openedge.core.reflect.IParameter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplatesUtils {
    public static String generateReturnStatement(String returnType, String returnValue, String NL) {
        StringBuilder buf = new StringBuilder();
        if (!TemplatesUtils.isVoid(returnType).booleanValue()) {
            buf.append("RETURN ");
            buf.append(returnValue);
            buf.append(".");
        }
        buf.append(NL);
        return buf.toString();
    }

    public static String generateReturnVariableComment(String returnType, String returnValue, String NL) {
        StringBuilder buf = new StringBuilder();
        if (!TemplatesUtils.isVoid(returnType).booleanValue()) {
            buf.append("/* ");
            buf.append(returnValue);
            buf.append(" method return value                                       */");
        }
        return buf.toString();
    }

    public static String generateReturnVariable(String returnType, String returnValue, String NL, Integer extent) {
        StringBuilder buf = new StringBuilder();
        if (!TemplatesUtils.isVoid(returnType).booleanValue()) {
            buf.append("DEFINE VARIABLE ");
            buf.append(returnValue);
            buf.append(" AS ");
            buf.append(returnType);
            buf.append(" NO-UNDO");
            buf.append(TemplatesUtils.generateExtent(extent));
            buf.append(".");
        }
        return buf.toString();
    }

    public static String generateParameter(IParameter parameter, String NL) {
        StringBuilder buf = new StringBuilder();
        buf.append(parameter.getMode());
        buf.append(" ");
        buf.append(parameter.getName());
        buf.append(" AS ");
        buf.append(parameter.getDataType());
        buf.append(TemplatesUtils.generateExtent(parameter.getExtent()));
        return buf.toString();
    }

    public static String generateExtent(Integer extent) {
        StringBuilder buf = new StringBuilder();
        if (extent > 0) {
            buf.append(" EXTENT ");
            buf.append(extent);
        }
        return buf.toString();
    }

    private static Boolean isVoid(String returnType) {
        IDataType dataType = DataTypes.getDataType((String)returnType);
        if (dataType != null && dataType.equals(DataTypes.VOID)) {
            return true;
        }
        return false;
    }

    public static Boolean isFileUserExitInclude(String fileName) {
        Pattern pattern = Pattern.compile(".*\\..{1}x.{1}", 2);
        Matcher matcher = pattern.matcher(fileName);
        return matcher.matches();
    }
}

