/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.templates.jet;

import com.proalpha.pds.paconnector.PaVersion;
import com.proalpha.pds.templates.Activator;
import com.proalpha.pds.templates.jet.IpaTemplateGenerator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public final class JetTemplateFactory {
    private static final String COM_PROALPHA_PDS_TEMPLATES = "com.proalpha.pds.templates";
    private static final String JET_FOLDER = ".jet.";
    private static final String TRUNK = "trunk.";
    private static final String VERSION = "version";
    private PaVersion proALPHAVersion;
    private static JetTemplateFactory factory;

    public static JetTemplateFactory getFactoryInstance(PaVersion proALPHAVersion) {
        if (factory == null) {
            factory = new JetTemplateFactory(proALPHAVersion);
        } else {
            JetTemplateFactory.factory.proALPHAVersion = proALPHAVersion;
        }
        return factory;
    }

    private JetTemplateFactory(PaVersion proALPHAVersion) {
        this.proALPHAVersion = proALPHAVersion;
    }

    public IpaTemplateGenerator getTemplate(String instanceName) throws Exception {
        IpaTemplateGenerator template = null;
        try {
            try {
                template = this.getSelectedTemplate("com.proalpha.pds.templates.jet.version" + this.getProalphaVersionNumber(JetTemplateFactory.factory.proALPHAVersion) + instanceName);
            }
            catch (ClassNotFoundException e) {
                template = this.getSelectedTemplate("com.proalpha.pds.templates.jet.trunk." + instanceName);
            }
        }
        catch (Exception e) {
            this.logErrorMessage(e);
        }
        return template;
    }

    private void logErrorMessage(Throwable exception) {
        String message = exception.getMessage().length() >= 0 ? exception.getMessage() : "The error message could not be extracted. Please check the error log.";
        Status status = new Status(4, COM_PROALPHA_PDS_TEMPLATES, message);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    private IpaTemplateGenerator getSelectedTemplate(String instanceName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Bundle bundle = Platform.getBundle((String)COM_PROALPHA_PDS_TEMPLATES);
        Class myClass = bundle.loadClass(instanceName);
        IpaTemplateGenerator template = (IpaTemplateGenerator)myClass.newInstance();
        return template;
    }

    private String getProalphaVersionNumber(PaVersion proVersion) {
        return String.valueOf(String.valueOf(proVersion.getMajorVersionNo())) + String.valueOf(proVersion.getMinorVersionNo());
    }
}

