/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.generator;

import com.proalpha.pds.generator.ContentGenerator;
import com.proalpha.pds.paconnector.parameter.StartparameterReader;
import com.proalpha.pds.paconnector.userexit.UserExitDelegate;
import com.proalpha.pds.templates.data.IGeneratorDataContainer;
import com.proalpha.pds.templates.helper.FileSystemUtils;
import com.proalpha.pds.templates.jaxb.JaxUnmarshallerGeneric;
import com.proalpha.pds.templates.jaxb.TtBAlpLine;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BalpGenerator {
    private static final Logger logger = LoggerFactory.getLogger(BalpGenerator.class);
    private static final String CUSTOM_LEVEL_CUSTOMER = "Y";
    private static final String CUSTOM_LEVEL_PARTNER = "X";
    private static final String CUSTOM_LEVEL_COUNTRY = "C";
    private static final String CUSTOM_LEVEL_INDUSTRY = "U";
    private static final String CUSTOM_LEVEL_COMPONENT = "Q";
    private static final String B_ALP95_CDF = "b__alp95.cdf";
    private static final String B_ALP94_CDF = "b__alp94.cdf";
    private static final String B_ALP93_CDF = "b__alp93.cdf";
    private static final String B_ALP92_CDF = "b__alp92.cdf";
    private static final String B_ALP91_CDF = "b__alp91.cdf";
    private final IGeneratorDataContainer dataContainer;
    private final UserExitDelegate userExitDelegate;
    private final StartparameterReader startparameterReader;

    public BalpGenerator(IGeneratorDataContainer datacontainer, UserExitDelegate userExitDelegate, StartparameterReader startparameterReader) throws Exception {
        this.dataContainer = datacontainer;
        this.userExitDelegate = userExitDelegate;
        this.startparameterReader = startparameterReader;
        this.initializeGenerator();
    }

    private void readXmlBalpFile(File xmlFile) throws Exception {
        String line;
        if (!xmlFile.exists()) {
            throw new Exception("File " + xmlFile.getAbsolutePath() + " does not exist.");
        }
        JaxUnmarshallerGeneric<TtBAlpLine> jaxb = new JaxUnmarshallerGeneric<TtBAlpLine>(TtBAlpLine.class);
        TtBAlpLine lines = jaxb.readXMLFile(xmlFile);
        List<TtBAlpLine.TtBAlpLineRow> elementList = lines.getTtBAlpLineRow();
        ArrayList<String> userExitList = new ArrayList<String>();
        ArrayList<String> balpFileHeader = new ArrayList<String>();
        ListIterator<TtBAlpLine.TtBAlpLineRow> iterator = elementList.listIterator();
        Boolean isHeaderFound = Boolean.FALSE;
        while (iterator.hasNext()) {
            line = iterator.next().getContent();
            balpFileHeader.add(line);
            if (!line.contains("_MAIN-BLOCK")) continue;
            isHeaderFound = Boolean.TRUE;
            break;
        }
        if (!isHeaderFound.booleanValue()) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)(String.valueOf(xmlFile.getAbsolutePath()) + " has the wrong format"), (String)(String.valueOf(xmlFile.getAbsolutePath()) + " file has the wrong format. The file has been regenerated. Please check the file."));
            iterator = elementList.listIterator();
            balpFileHeader.clear();
            balpFileHeader.add("&ANALYZE-SUSPEND _UIB-CODE-BLOCK _CUSTOM _MAIN-BLOCK Include");
        }
        while (iterator.hasNext()) {
            line = iterator.next().getContent();
            if (!this.isLineUserExitDefinition(line)) continue;
            userExitList.add(line);
        }
        this.dataContainer.setUserExitFiles(userExitList);
        this.dataContainer.setBALPTemplateList(balpFileHeader);
        xmlFile.deleteOnExit();
    }

    private boolean isLineUserExitDefinition(String line) {
        Pattern patternUserExit = Pattern.compile("^&GLOB.+");
        Pattern patternInheritsClass = Pattern.compile("^&GLOB.+_INHERITS.+");
        return patternUserExit.matcher(line).find() || patternInheritsClass.matcher(line).find();
    }

    private void loadBalpValues() throws Exception {
        String balpFile = this.getBAlpFile(this.dataContainer.getCustomLevel());
        File xmlFile = this.userExitDelegate.extractBalpFileToXMLFile(balpFile);
        this.readXmlBalpFile(xmlFile);
    }

    private String getBAlpFile(String customLevel) {
        switch (customLevel) {
            case "C": {
                return B_ALP91_CDF;
            }
            case "X": {
                return B_ALP92_CDF;
            }
            case "Y": {
                return B_ALP93_CDF;
            }
            case "U": {
                return B_ALP94_CDF;
            }
            case "Q": {
                return B_ALP95_CDF;
            }
        }
        return B_ALP92_CDF;
    }

    private IFile getGeneratorOutputFile() {
        IFile outputFile = null;
        String bAlpFile = this.getBAlpFile(this.dataContainer.getCustomLevel());
        try {
            outputFile = FileSystemUtils.createFileInWorkingDirectory(this.startparameterReader.getWorkingDirectory(), "basis/incl", bAlpFile);
            if (outputFile.exists()) {
                ResourceAttributes resourceAttributes = new ResourceAttributes();
                resourceAttributes.setReadOnly(false);
                outputFile.setResourceAttributes(resourceAttributes);
            }
        }
        catch (Exception e) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Error create output file", (String)("Could not create generator output file: " + bAlpFile + "\n" + e.getMessage()));
            logger.error(e.getMessage(), (Throwable)e);
        }
        return outputFile;
    }

    private void initializeGenerator() throws Exception {
        this.loadBalpValues();
        this.dataContainer.setOutputFile(this.getGeneratorOutputFile());
    }

    public void generate() throws Exception {
        ContentGenerator generator = new ContentGenerator("b__alp Generator", this.dataContainer, "pABalpxxcdf");
        generator.disableOpenFileInEditor();
        generator.schedule();
    }
}

