/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.wizards.wizardpages;

import com.proalpha.pds.paconnector.PaProject;
import com.proalpha.pds.templates.data.OOInterfaceTemplate;
import com.proalpha.pds.templates.data.OOType;
import com.proalpha.pds.ui.Activator;
import com.proalpha.pds.ui.wizards.wizardpages.IpaWizardPage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class InstanceListenerWizardPage
extends WizardPage
implements IpaWizardPage {
    private static final String GENERATE_SAMPLES_INIT_VALUE = "GENERATE_SAMPLES_INIT_VALUE";
    private PaProject paProject = null;
    private Set<OOInterfaceTemplate> selectedTemplates = new HashSet<OOInterfaceTemplate>();
    private Button generateSamplesButton = null;
    private boolean generateSamples = true;

    public InstanceListenerWizardPage(PaProject paProject) {
        super("InstanceListenerWizardPage");
        this.paProject = paProject;
        this.setTitle("Instance Listener Options");
        this.setDescription("Select Instance Listener types to implement");
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.createDatabaseTriggerGroup(container);
        this.createUserInterfaceGroup(container);
        this.createSampleGroup(container);
        this.setControl((Control)container);
        this.initState();
    }

    private void initState() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings.get(GENERATE_SAMPLES_INIT_VALUE) != null) {
            this.generateSamples = settings.getBoolean(GENERATE_SAMPLES_INIT_VALUE);
        }
        this.generateSamplesButton.setSelection(this.generateSamples);
        this.updateSampleButtonState();
    }

    private void createDatabaseTriggerGroup(Composite parent) {
        Group databaseTriggerGroup = new Group(parent, 0);
        databaseTriggerGroup.setText("Database Trigger");
        databaseTriggerGroup.setBackgroundMode(1);
        databaseTriggerGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        databaseTriggerGroup.setLayout((Layout)new RowLayout(512));
        this.createInterfaceButton((Composite)databaseTriggerGroup, "Database Trigger Events", new OOInterfaceTemplate(new OOType("adm.method.cls", "DMITriggerProcedureLst"), "paOOAblInterfaceImplDMITriggerProcedureLst", new String[]{"paOOAblTriggerEventSubscriptionMethodSample"}));
    }

    private void createUserInterfaceGroup(Composite parent) {
        Group userInterfaceGroup = new Group(parent, 0);
        userInterfaceGroup.setText("User Interface");
        userInterfaceGroup.setBackgroundMode(1);
        userInterfaceGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        userInterfaceGroup.setLayout((Layout)new RowLayout(512));
        this.createInterfaceButton((Composite)userInterfaceGroup, "Window Events", new OOInterfaceTemplate(new OOType("adm.method.cls", "DMIWindowEventLst"), "paOOAblInterfaceImplDMIWindowEventLst", new String[]{"paOOAblWindowEventSubscriptionMethodSample"}));
        this.createInterfaceButton((Composite)userInterfaceGroup, "Widget Events", new OOInterfaceTemplate(new OOType("adm.method.cls", "DMIWidgetEventLst"), "paOOAblInterfaceImplDMIWidgetEventLst", new String[]{"paOOAblWidgetEventSubscriptionMethodSample"}));
        this.createInterfaceButton((Composite)userInterfaceGroup, "UI Procedure Events", new OOInterfaceTemplate(new OOType("adm.method.cls", "DMIUIProcedureEventLst"), "paOOAblInterfaceImplDMIUIProcedureEventLst", new String[]{"paOOAblUIProcedureEventSubscriptionMethodSample"}));
        this.createInterfaceButton((Composite)userInterfaceGroup, "Browse Events", new OOInterfaceTemplate(new OOType("adm.method.cls", "DMIBrowseEventLst"), "paOOAblInterfaceImplDMIBrowseEventLst", new String[]{"paOOAblBrowseEventSubscriptionMethodSample"}));
    }

    private void createSampleGroup(Composite parent) {
        Group sampleGroup = new Group(parent, 0);
        sampleGroup.setText("Examples");
        sampleGroup.setBackgroundMode(1);
        sampleGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        sampleGroup.setLayout((Layout)new RowLayout(512));
        this.generateSamplesButton = new Button((Composite)sampleGroup, 32);
        this.generateSamplesButton.setText("Generate Examples");
        this.generateSamplesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstanceListenerWizardPage.this.generateSamples = InstanceListenerWizardPage.this.generateSamplesButton.getSelection();
                IDialogSettings settings = InstanceListenerWizardPage.this.getDialogSettings();
                settings.put(InstanceListenerWizardPage.GENERATE_SAMPLES_INIT_VALUE, InstanceListenerWizardPage.this.generateSamples);
            }
        });
    }

    private Button createInterfaceButton(Composite parent, String labelText, final OOInterfaceTemplate sampleTemplate) {
        final Button button = new Button(parent, 32);
        button.setText(labelText);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (button.getSelection()) {
                    InstanceListenerWizardPage.this.selectedTemplates.add(sampleTemplate);
                } else {
                    InstanceListenerWizardPage.this.selectedTemplates.remove(sampleTemplate);
                }
                InstanceListenerWizardPage.this.updateSampleButtonState();
            }
        });
        String relativeName = sampleTemplate.getOoType().getRelativeName().concat(".cls");
        IPath ooTypePath = this.paProject.getOeProject().getPropath().search(relativeName, false);
        button.setEnabled(ooTypePath != null);
        return button;
    }

    private void updateSampleButtonState() {
        this.generateSamplesButton.setEnabled(this.selectedTemplates.size() > 0);
    }

    @Override
    public Map<String, Object> getSettings() {
        HashMap<String, Object> wizardSettings = new HashMap<String, Object>();
        TreeSet<String> selectedInterfaces = new TreeSet<String>();
        TreeSet<String> selectedUsingStatements = new TreeSet<String>();
        ArrayList<String> selectedTemplatesNames = new ArrayList<String>();
        for (OOInterfaceTemplate ooTypeSampleTemplate : this.selectedTemplates) {
            selectedInterfaces.add(ooTypeSampleTemplate.getOoType().getTypeName());
            selectedUsingStatements.add(String.valueOf(ooTypeSampleTemplate.getOoType().getPackageName()) + ".*");
            selectedTemplatesNames.add(ooTypeSampleTemplate.getImplementationTemplateName());
        }
        if (this.generateSamples) {
            for (OOInterfaceTemplate ooTypeSampleTemplate : this.selectedTemplates) {
                selectedTemplatesNames.addAll(ooTypeSampleTemplate.getAdditionalTemplateNames());
            }
        }
        wizardSettings.put("UsingStatements", selectedUsingStatements);
        wizardSettings.put("ImplementedInterfaces", selectedInterfaces);
        wizardSettings.put("MethodSnippetTemplates", selectedTemplatesNames);
        return wizardSettings;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings dialogSettings = Activator.getDefault().getDialogSettings();
        return DialogSettings.getOrCreateSection((IDialogSettings)dialogSettings, (String)this.getName());
    }
}

