/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.handlers;

import com.proalpha.pds.generator.GeneratorFactory;
import com.proalpha.pds.generator.TriggerFileGenerator;
import com.proalpha.pds.paconnector.Activator;
import com.proalpha.pds.paconnector.PaProject;
import com.proalpha.pds.paconnector.exception.ProALPHANotAvailableException;
import com.proalpha.pds.paconnector.jaxb.TtDECMissingTrigger;
import com.proalpha.pds.paconnector.utils.ExceptionUtils;
import com.proalpha.pds.paconnector.utils.JaxbUnmarshallerGeneric;
import com.proalpha.pds.templates.data.DataContainerFactory;
import com.proalpha.pds.templates.data.IGeneratorDataContainer;
import com.proalpha.pds.ui.AbstractProAlphaHandler;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.IProgressService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateMissingDbTriggerHandler
extends AbstractProAlphaHandler {
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            PaProject paProject = this.getPaProjectOfEvent(event);
            GenerateMissingDbTriggerHandler.runProgram(paProject);
        }
        catch (ProALPHANotAvailableException e) {
            ExceptionUtils.showAndLogErrorMessage((AbstractUIPlugin)Activator.getDefault(), (Throwable)e);
        }
        return null;
    }

    private static void runProgram(final PaProject paProject) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){
            private final Logger logger = LoggerFactory.getLogger(GenerateMissingDbTriggerHandler.class);

            public void run(IProgressMonitor monitor) {
                try {
                    try {
                        monitor.beginTask("Create missing database triggers", 2);
                        monitor.worked(1);
                        monitor.subTask("Fetch list of missing triggers");
                        File file = paProject.getBridge().createMissingTriggersXMLFile();
                        this.logger.debug("Exported missing triggers to file {}", (Object)file);
                        List<TtDECMissingTrigger.TtDECMissingTriggerRow> missingTriggers = this.retrieveMissingTriggers(file);
                        monitor.beginTask("Create missing database triggers", missingTriggers.size() + 1);
                        for (TtDECMissingTrigger.TtDECMissingTriggerRow trigger : missingTriggers) {
                            String triggerName = (String)trigger.getTriggerFileName().getValue();
                            this.logger.debug("Create trigger {}", (Object)triggerName);
                            monitor.subTask("Create trigger " + triggerName);
                            DataContainerFactory dataContainerFactory = new DataContainerFactory();
                            IGeneratorDataContainer datacontainer = dataContainerFactory.createDataContainer(paProject);
                            datacontainer.setFileName((String)trigger.getTriggerFileName().getValue());
                            datacontainer.setTriggerMode((String)trigger.getTriggerMode().getValue());
                            datacontainer.setTableName((String)trigger.getTriggerTableName().getValue());
                            datacontainer.setAuthor(System.getProperty("user.name"));
                            datacontainer.setVersion(paProject.getVersion());
                            GeneratorFactory generatorFactory = new GeneratorFactory();
                            TriggerFileGenerator gen = generatorFactory.createTriggerFileGenerator(datacontainer);
                            gen.generate();
                            monitor.worked(1);
                        }
                    }
                    catch (Exception exception) {
                        ExceptionUtils.showAndLogErrorMessage((AbstractUIPlugin)Activator.getDefault(), (Throwable)exception);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }

            private List<TtDECMissingTrigger.TtDECMissingTriggerRow> retrieveMissingTriggers(File file) {
                JaxbUnmarshallerGeneric unmarshaller = new JaxbUnmarshallerGeneric(TtDECMissingTrigger.class);
                TtDECMissingTrigger missingTriggers = (TtDECMissingTrigger)unmarshaller.readXMLFile(file);
                return missingTriggers.getTtDECMissingTriggerRow();
            }
        };
        IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
        IProgressService context = PlatformUI.getWorkbench().getProgressService();
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, runnable, (ISchedulingRule)rule);
        }
        catch (InvocationTargetException e) {
            ExceptionUtils.showAndLogErrorMessage((AbstractUIPlugin)Activator.getDefault(), (Throwable)e);
        }
        catch (InterruptedException e) {
            ExceptionUtils.showAndLogErrorMessage((AbstractUIPlugin)Activator.getDefault(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

