/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.wizards.wizardpages;

import com.proalpha.pds.paconnector.repository.DatasetCatalogEntry;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class PaDatasetCatalogTree
extends FilteredTree {
    private static final Color COLOR_YELLOW = Display.getCurrent().getSystemColor(7);
    private static final int TREE_STYLE = 68352;
    private TreeViewer treeViewer = null;

    public PaDatasetCatalogTree(Composite parent) {
        super(parent, 68352, (PatternFilter)new DatasetFilter(), true, true);
        this.init();
    }

    private void init() {
        this.treeViewer = this.getViewer();
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setExpandPreCheckFilters(true);
        Tree tree = this.treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(false);
        this.treeViewer.setContentProvider((IContentProvider)new DatasetTreeContentProvider());
        TreeViewerColumn treeViewerColumn1 = new TreeViewerColumn(this.treeViewer, 16384);
        treeViewerColumn1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((DatasetCatalogEntry)element).getName();
            }

            public Color getBackground(Object element) {
                if (((DatasetCatalogEntry)element).isCustomDataset()) {
                    return COLOR_YELLOW;
                }
                return super.getForeground(element);
            }
        });
        TreeColumn treeColumn1 = treeViewerColumn1.getColumn();
        treeColumn1.setAlignment(16384);
        treeColumn1.setText("Dataset Name");
        treeColumn1.setWidth(250);
        TreeViewerColumn treeViewerColumn2 = new TreeViewerColumn(this.treeViewer, 16384);
        treeViewerColumn2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((DatasetCatalogEntry)element).getDescription();
            }

            public Color getBackground(Object element) {
                if (((DatasetCatalogEntry)element).isCustomDataset()) {
                    return COLOR_YELLOW;
                }
                return super.getForeground(element);
            }
        });
        TreeColumn treeColumn2 = treeViewerColumn2.getColumn();
        treeColumn2.setAlignment(16384);
        treeColumn2.setText("Description");
        treeColumn2.setWidth(250);
    }

    private static class DatasetFilter
    extends PatternFilter {
        public DatasetFilter() {
            this.setIncludeLeadingWildcard(true);
        }

        public boolean isElementVisible(Viewer viewer, Object element) {
            if (element instanceof DatasetCatalogEntry) {
                DatasetCatalogEntry datasetCatalogEntry = (DatasetCatalogEntry)element;
                return this.wordMatches(datasetCatalogEntry.getName()) || this.wordMatches(datasetCatalogEntry.getDescription()) || this.wordMatches(datasetCatalogEntry.getDefinitionFile());
            }
            return false;
        }
    }

    private static class DatasetTreeContentProvider
    implements ITreeContentProvider {
        private static Object[] noElements = new Object[0];

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return noElements;
        }

        public Object[] getChildren(Object parentElement) {
            return noElements;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }
}

