/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.wizards.controller;

import com.proalpha.pds.generator.GeneratorFactory;
import com.proalpha.pds.generator.OOABLExitFileGenerator;
import com.proalpha.pds.paconnector.parameter.CustomLevel;
import com.proalpha.pds.paconnector.repository.Instance;
import com.proalpha.pds.paconnector.repository.RepositoryDelegate;
import com.proalpha.pds.paconnector.repository.RepositoryInformations;
import com.proalpha.pds.paconnector.utils.PaOOABLUtil;
import com.proalpha.pds.templates.data.DataContainerFactory;
import com.proalpha.pds.templates.data.IGeneratorDataContainer;
import com.proalpha.pds.ui.wizards.controller.PaWizard;
import com.proalpha.pds.ui.wizards.wizardpages.WizardMainPageConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OOABLObject
extends PaWizard
implements INewWizard {
    private static final Logger logger = LoggerFactory.getLogger(OOABLObject.class);
    private static final String OO_ROOT_CLASS = "OOABL";
    private static final String PARENT_CLASS_TYPE_OO_JOB = "OO Job";
    private static final String PARENT_CLASS_TYPE_OO_WORKFLOW_JOB = "OO Workflow Job";
    private static final String OO_JOB_WRAPPER = "bjvjob02.p";
    private static final String OO_JOB_WRAPPER_PARENT_CLASS = "bjvjob02.p";
    private CustomLevel currentCustomLevel = null;
    private Map<String, GenerationPreprocessor> generationPreprocessorsByParentClass = new HashMap<String, GenerationPreprocessor>();
    private boolean useDIFramework = false;
    private Boolean isGenerateUserExit;

    public OOABLObject() {
        try {
            this.isGenerateUserExit = Boolean.FALSE;
            this.useDIFramework = PaOOABLUtil.useDIFramework((RepositoryInformations)this.getRepositoryInformations());
            ArrayList<String> extensionList = new ArrayList<String>();
            extensionList.add("cls");
            WizardMainPageConfiguration configuration = new WizardMainPageConfiguration();
            configuration.setWizardTitle("Proalpha OOABL Class File");
            configuration.setWizardDescription("This wizard creates a new Proalpha OOABL Class File.");
            configuration.setTemplateName(this.useDIFramework ? "pAOOABLClassDI" : "pAOOABLClass");
            configuration.setExtensionList(extensionList);
            configuration.setRootClass(OO_ROOT_CLASS);
            configuration.setThirdDigit("C");
            configuration.setCheckRepository(true);
            configuration.setSupportRepositoryCreateButton(true);
            configuration.setCheckFileNameLength(false);
            configuration.setCheckLowerCase(false);
            this.generationPreprocessorsByParentClass.put(PARENT_CLASS_TYPE_OO_JOB, new OOJobPreprocessor(this.getRepositoryDelegate(), null, "basis.job.cls.BJCBaseJob", Arrays.asList("paOOJobConstructorImpl"), this.useDIFramework ? Arrays.asList("paOOJobDIMethodImpl", "paOOJobMethodImpl") : Arrays.asList("paOOJobMethodImpl")));
            this.generationPreprocessorsByParentClass.put(PARENT_CLASS_TYPE_OO_WORKFLOW_JOB, new OOJobPreprocessor(this.getRepositoryDelegate(), null, "basis.job.cls.BJCWorkflowBaseWfj", Arrays.asList("paOOJobConstructorImpl"), this.useDIFramework ? Arrays.asList("paOOJobDIMethodImpl", "paOOWorkflowJobMethodImpl") : Arrays.asList("paOOWorkflowJobMethodImpl")));
            WizardMainPageConfiguration configuration1 = new WizardMainPageConfiguration();
            configuration1.setWizardTitle("Proalpha OOABL Form File");
            configuration1.setWizardDescription("This wizard creates a new Proalpha OOABL Form File.");
            configuration1.setTemplateName("pAOOABLForm");
            configuration1.setExtensionList(extensionList);
            configuration1.setRootClass(OO_ROOT_CLASS);
            configuration1.setThirdDigit("C");
            configuration1.setCheckRepository(true);
            configuration1.setSupportRepositoryCreateButton(true);
            configuration1.setCheckFileNameLength(false);
            configuration1.setCheckLowerCase(false);
            WizardMainPageConfiguration configuration2 = new WizardMainPageConfiguration();
            configuration2.setWizardTitle("Proalpha Interface File");
            configuration2.setWizardDescription("This wizard creates a new Proalpha Interface File.");
            configuration2.setTemplateName(this.useDIFramework ? "pAOOABLInterfaceDI" : "pAOOABLInterface");
            configuration2.setExtensionList(extensionList);
            configuration2.setRootClass(OO_ROOT_CLASS);
            configuration2.setThirdDigit("I");
            configuration2.setCheckRepository(true);
            configuration2.setSupportRepositoryCreateButton(true);
            configuration2.setCheckFileNameLength(false);
            configuration2.setCheckLowerCase(false);
            LinkedHashMap<String, WizardMainPageConfiguration> configList = new LinkedHashMap<String, WizardMainPageConfiguration>();
            configList.put("OOABL Class", configuration);
            configList.put("OOABL Form", configuration1);
            configList.put("OOABL Interface", configuration2);
            this.setConfigList(configList);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Unable to initialize Template", (String)e.getMessage());
        }
    }

    @Override
    protected boolean doFinish() {
        try {
            if (this.isGenerateUserExit.booleanValue()) {
                this.generateUserExitClassAndBalpEntry();
            } else {
                this.generatorMainClassAndStdClass();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private void generatorMainClassAndStdClass() throws Exception {
        String fileName = (String)this.wizardSettings.get("FileName");
        fileName = PaOOABLUtil.removeCustomClassSuffix((String)fileName);
        fileName = PaOOABLUtil.addClassSuffix((String)fileName, (CustomLevel)this.getCurrentCustomLevel());
        this.wizardSettings.put("CustomLevel", this.getCurrentCustomLevel().getValue());
        this.wizardSettings.put("CustomFileName", fileName);
        this.wizardSettings.put("StandardFileName", fileName);
        String parentClass = (String)this.wizardSettings.get("ParentObject");
        this.addRepresentationInterfaceOrParentClass(this.wizardSettings, parentClass);
        GenerationPreprocessor preprocessor = this.generationPreprocessorsByParentClass.get(parentClass);
        if (preprocessor != null) {
            preprocessor.run(this.wizardSettings);
        }
        if (!this.useDIFramework) {
            DataContainerFactory factory = new DataContainerFactory();
            IGeneratorDataContainer datacontainer = factory.createDataContainer(this.paProject, this.cloneWizardSettings());
            GeneratorFactory generatorFactory = new GeneratorFactory();
            String stdTemplate = this.wizardSettings.get("TemplateName").toString();
            if (!stdTemplate.endsWith("Form")) {
                stdTemplate = stdTemplate.replace("pAOOABL", "pAOOABLStd");
            }
            OOABLExitFileGenerator oOABLClass = generatorFactory.createOOABLExitFileGenerator(datacontainer, stdTemplate);
            oOABLClass.generate();
        }
        super.doFinish();
    }

    private void generateUserExitClassAndBalpEntry() throws Exception {
        String fileName = (String)this.wizardSettings.get("FileName");
        this.wizardSettings.put("CustomLevel", this.getCurrentCustomLevel().getValue());
        this.wizardSettings.put("CustomFileName", fileName);
        DataContainerFactory factory = new DataContainerFactory();
        IGeneratorDataContainer datacontainer = factory.createDataContainer(this.paProject, this.wizardSettings);
        OOABLExitFileGenerator oOABLClass = null;
        GeneratorFactory generatorFactory = new GeneratorFactory();
        oOABLClass = this.wizardSettings.get("TemplateName").toString().equals("pAOOABLInterface") ? generatorFactory.createOOABLExitFileGenerator(datacontainer, "pAOOABLStdInterface") : generatorFactory.createOOABLExitFileGenerator(datacontainer, "pAOOABLStdClass");
        oOABLClass.generateUserExitClassAndBalpEntry();
    }

    public void setCurrentCustomLevel(CustomLevel currentCustomLevel) {
        this.currentCustomLevel = currentCustomLevel;
    }

    public CustomLevel getCurrentCustomLevel() {
        if (this.currentCustomLevel == null) {
            this.currentCustomLevel = CustomLevel.getByValue((String)this.getStartparameterReader().getCurrentCustomLevel());
        }
        return this.currentCustomLevel;
    }

    public void setIsGerateUserExit(Boolean value) {
        this.isGenerateUserExit = value;
    }

    private void addRepresentationInterfaceOrParentClass(Map<String, Object> wizardSettings, String parentClass) {
        RepositoryInformations repositoryInformations = this.getRepositoryInformations();
        String representationClass = repositoryInformations.getClassInformation(parentClass, "Rend_DRC_Instance_Obj");
        if (representationClass == null || representationClass.isEmpty()) {
            return;
        }
        String className = repositoryInformations.getInstanceInformation(representationClass, "DRC_Instance_ID");
        className = PaOOABLUtil.removeClassSuffix((String)className);
        String classPackage = repositoryInformations.getInstanceInformation(representationClass, "Directory");
        if (!classPackage.isEmpty()) {
            classPackage = classPackage.replace('/', '.');
        }
        String qualifiedClassName = PaOOABLUtil.getQualifiedClassName((String)classPackage, (String)className);
        if (PaOOABLUtil.isInterface((String)className)) {
            this.addImplementedInterface(wizardSettings, qualifiedClassName);
        } else {
            wizardSettings.put("qualifiedParentClassName", qualifiedClassName);
        }
    }

    private void addImplementedInterface(Map<String, Object> wizardSettings, String interfaceToAdd) {
        TreeSet<String> interfacesSet = new TreeSet<String>();
        interfacesSet.add(interfaceToAdd);
        this.addImplementedInterfaces(wizardSettings, interfacesSet);
    }

    private void addImplementedInterfaces(Map<String, Object> wizardSettings, Set<String> interfacesToAdd) {
        TreeSet<String> interfacesSet = (TreeSet<String>)wizardSettings.get("ImplementedInterfaces");
        if (interfacesSet == null) {
            interfacesSet = new TreeSet<String>();
            wizardSettings.put("ImplementedInterfaces", interfacesSet);
        }
        interfacesSet.addAll(interfacesToAdd);
    }

    private static interface GenerationPreprocessor {
        public void run(Map<String, Object> var1);
    }

    private class OOClassPreprocessor
    implements GenerationPreprocessor {
        private Set<String> usingStatements = null;
        private String parentClassName = "";
        private List<String> constructorSnippetTemplates = null;
        private List<String> methodSnippetTemplates = null;

        public OOClassPreprocessor(Set<String> usingStatements, String parentClass, List<String> constructorSnippetTemplates, List<String> methodSnippetTemplates) {
            this.usingStatements = usingStatements;
            this.parentClassName = parentClass;
            this.constructorSnippetTemplates = constructorSnippetTemplates;
            this.methodSnippetTemplates = methodSnippetTemplates;
        }

        @Override
        public void run(Map<String, Object> wizardSettings) {
            if (this.usingStatements != null) {
                wizardSettings.put("UsingStatements", this.usingStatements);
            }
            if (this.parentClassName != null) {
                wizardSettings.put("qualifiedParentClassName", this.parentClassName);
            }
            if (this.constructorSnippetTemplates != null) {
                wizardSettings.put("ConstructorSnippetTemplates", this.constructorSnippetTemplates);
            }
            if (this.methodSnippetTemplates != null) {
                wizardSettings.put("MethodSnippetTemplates", this.methodSnippetTemplates);
            }
        }
    }

    private class OOJobPreprocessor
    extends OOClassPreprocessor {
        RepositoryDelegate repositoryDelegate;

        public OOJobPreprocessor(RepositoryDelegate repositoryDelegate, Set<String> usingStatements, String parentClass, List<String> constructorSnippetTemplates, List<String> methodSnippetTemplates) {
            super(usingStatements, parentClass, constructorSnippetTemplates, methodSnippetTemplates);
            this.repositoryDelegate = null;
            this.repositoryDelegate = repositoryDelegate;
        }

        @Override
        public void run(Map<String, Object> wizardSettings) {
            super.run(wizardSettings);
            this.createOOJobWrapperRepositoryInstance((String)wizardSettings.get("FileName"), (String)wizardSettings.get("FileDescription"), (String)wizardSettings.get("Description"));
        }

        private void createOOJobWrapperRepositoryInstance(String filename, String description, String shortDescription) {
            String className = filename.substring(0, filename.indexOf("."));
            String ooJobWrapperProcName = "bjvjob02.p#" + className;
            Instance instance = this.repositoryDelegate.getEmptyInstance();
            instance.setName(ooJobWrapperProcName);
            instance.setDescription(description);
            instance.setShortDescription(shortDescription);
            instance.setParentClass("bjvjob02.p");
            this.repositoryDelegate.createRepositoryEntryforInstance(instance);
        }
    }
}

