/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.listener;

import com.openedge.pdt.project.IOpenEdgeProject;
import com.proalpha.pds.paconnector.repository.RepositoryInformations;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;

public class InstanceListenerTools {
    private static final String DB_TRIGGER_CLASS = "Database Trigger";
    private static final Set<String> publisherInstanceExtensions = new HashSet<String>(Arrays.asList("p", "w"));

    public static boolean isInstanceListenerPossible(IFile filename) {
        if (filename == null) {
            return false;
        }
        return publisherInstanceExtensions.contains(filename.getFileExtension().toLowerCase());
    }

    public static boolean canRegisterInstanceListener(IOpenEdgeProject project) {
        IPath path = project.getPropath().search("adm/support/proc/ds_oea73.p", false);
        return path != null && !path.isEmpty();
    }

    public static String getTableNameFromTriggerInstanceOrNull(RepositoryInformations repositoryInformations, String triggerInstanceId) {
        if (triggerInstanceId == null) {
            return null;
        }
        Object isInstanceOfTriggerClass = repositoryInformations.isInstanceOfClass(triggerInstanceId, DB_TRIGGER_CLASS);
        if (!"yes".equals(isInstanceOfTriggerClass) && !"true".equals(isInstanceOfTriggerClass)) {
            return null;
        }
        String dumpName = triggerInstanceId.substring(0, 7);
        if (!repositoryInformations.existsTableInRepositoryByDumpName(dumpName).booleanValue()) {
            return null;
        }
        return repositoryInformations.getTableInformationByDumpName(dumpName, "DRC_Table_ID");
    }

    public static String getTriggerFunctionFromTriggerInstance(String triggerName) {
        switch (triggerName.substring(7, 8).toLowerCase()) {
            case "d": {
                return "Delete";
            }
            case "w": {
                return "Write";
            }
            case "c": {
                return "Create";
            }
        }
        throw new IllegalArgumentException("\"" + triggerName + "\" is not a valid trigger instance name");
    }
}

