/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.wizards.wizardpages;

import com.proalpha.pds.paconnector.PaProject;
import com.proalpha.pds.paconnector.repository.RepositoryInformations;
import com.proalpha.pds.templates.data.OOInterfaceTemplate;
import com.proalpha.pds.templates.data.OOType;
import com.proalpha.pds.ui.listener.InstanceListenerType;
import com.proalpha.pds.ui.wizards.wizardpages.InstanceListenerTargetPage;
import com.proalpha.pds.ui.wizards.wizardpages.InterfaceSelectionWizardPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class InstanceListenerInterfaceWizardPage
extends InterfaceSelectionWizardPage {
    private static final String GENERATE_SAMPLES_INIT_VALUE = "GENERATE_SAMPLES_INIT_VALUE";
    private Button generateSamplesButton = null;
    private RepositoryInformations repositoryInformations = null;
    private InstanceListenerTargetPage instanceListenerTargetPage = null;
    private Map<InstanceListenerType, Button> listenerTypeButtonMap = new HashMap<InstanceListenerType, Button>();
    private String[] targetInstances = new String[0];
    private Set<InstanceListenerType> listenerTypes = new HashSet<InstanceListenerType>();

    public InstanceListenerInterfaceWizardPage(PaProject paProject, RepositoryInformations repositoryInformations) {
        super("InstanceListenerWizardPage");
        this.repositoryInformations = repositoryInformations;
        this.setPaProject(paProject);
        this.setTitle("Instance Listener");
        this.setDescription("Select the instances, this listener should implement");
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.createUserInterfaceGroup(container);
        this.createDatabaseTriggerGroup(container);
        this.createSampleGroup(container);
        this.setControl((Control)container);
        container.computeSize(-1, 400);
        this.setControl((Control)container);
        this.initState();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.updateTargetInstances();
        }
        super.setVisible(visible);
    }

    private void initState() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings.get(GENERATE_SAMPLES_INIT_VALUE) != null) {
            this.setUseAdditionalTemplates(settings.getBoolean(GENERATE_SAMPLES_INIT_VALUE));
        }
        this.generateSamplesButton.setSelection(this.getUseAdditionalTemplates());
        for (InstanceListenerType listenerType : this.listenerTypes) {
            Button listenerTypeButton = this.listenerTypeButtonMap.get((Object)listenerType);
            if (listenerTypeButton != null) {
                listenerTypeButton.setSelection(true);
                listenerTypeButton.notifyListeners(13, new Event());
            }
            if (listenerType != InstanceListenerType.DB_TRIGGER_PROCEDURE) continue;
            this.generateSamplesButton.setSelection(true);
        }
        this.updateSampleButtonState();
    }

    public void addListenerType(InstanceListenerType listenerType) {
        this.listenerTypes.add(listenerType);
    }

    private void updateTargetInstances() {
        if (this.getInstanceListenerTargetPage() != null) {
            Map<String, Object> config = this.getInstanceListenerTargetPage().getSettings();
            this.targetInstances = (String[])config.get("ListenerTargetInstances");
        }
        this.enableInterfaceButtons();
    }

    private void enableInterfaceButtons() {
        if (this.targetInstances.length > 0) {
            HashSet<String> listenerTypes = new HashSet<String>(Arrays.asList(this.getSupprtedListenerTypes().split(",")));
            int supportedTypeCount = 0;
            for (Map.Entry<InstanceListenerType, Button> listenerTypeEntry : this.listenerTypeButtonMap.entrySet()) {
                InstanceListenerType listenerType = listenerTypeEntry.getKey();
                Button listenerButton = listenerTypeEntry.getValue();
                boolean isSupported = listenerTypes.contains(listenerType.getId());
                listenerButton.setEnabled(isSupported);
                if (!listenerButton.isEnabled()) {
                    listenerButton.setSelection(false);
                }
                if (!isSupported) continue;
                ++supportedTypeCount;
            }
            if (supportedTypeCount == 0) {
                this.setErrorMessage("None of the selected instances publishes listener events!");
            } else {
                this.setErrorMessage(null);
            }
        } else {
            for (Button listenerButton : this.listenerTypeButtonMap.values()) {
                listenerButton.setEnabled(true);
            }
        }
        this.updateSampleButtonState();
    }

    private String getSupprtedListenerTypes() {
        return this.repositoryInformations.getSupportedListenerTypesForPublishers(String.join((CharSequence)";", this.targetInstances));
    }

    private String[] getSelectedListenerTypes() {
        ArrayList<String> selectedListeners = new ArrayList<String>();
        for (Map.Entry<InstanceListenerType, Button> listenerTypeEntry : this.listenerTypeButtonMap.entrySet()) {
            InstanceListenerType listenerType = listenerTypeEntry.getKey();
            Button listenerButton = listenerTypeEntry.getValue();
            if (!listenerButton.getSelection()) continue;
            selectedListeners.add(listenerType.getId());
        }
        return selectedListeners.toArray(new String[selectedListeners.size()]);
    }

    private void createDatabaseTriggerGroup(Composite parent) {
        Group databaseTriggerGroup = this.createGroup(parent, "Database Trigger");
        Button databaseTriggerEventButton = this.createInterfaceButton((Composite)databaseTriggerGroup, "Database Trigger Events", new OOInterfaceTemplate(new OOType("adm.method.cls", "DMITriggerProcedureLst"), new String[]{"adm.method.cls.DMITriggerProcedureLst", "adm.method.cls.DMCTriggerProcedureSvo"}, "paOOAblInterfaceImplDMITriggerProcedureLst", new String[]{"paOOAblTriggerEventSubscriptionMethodSample"}));
        this.addSelectionListenerToUpdateSampleButtonState(databaseTriggerEventButton);
        this.listenerTypeButtonMap.put(InstanceListenerType.DB_TRIGGER_PROCEDURE, databaseTriggerEventButton);
    }

    private void createUserInterfaceGroup(Composite parent) {
        Group userInterfaceGroup = this.createGroup(parent, "User Interface");
        Button windowEventButton = this.createInterfaceButton((Composite)userInterfaceGroup, "Window Events", new OOInterfaceTemplate(new OOType("adm.method.cls", "DMIWindowEventLst"), new String[]{"adm.method.cls.DMIWindowEventLst", "adm.method.cls.DMCWindowSvo"}, "paOOAblInterfaceImplDMIWindowEventLst", new String[]{"paOOAblWindowEventSubscriptionMethodSample"}));
        this.addSelectionListenerToUpdateSampleButtonState(windowEventButton);
        this.listenerTypeButtonMap.put(InstanceListenerType.WINDOW, windowEventButton);
        Button widgetEventButton = this.createInterfaceButton((Composite)userInterfaceGroup, "Widget Events", new OOInterfaceTemplate(new OOType("adm.method.cls", "DMIWidgetEventLst"), new String[]{"adm.method.cls.DMIWidgetEventLst", "adm.method.cls.DMCUIProcedureSvo", "adm.method.cls.DMCWidgetSvo"}, "paOOAblInterfaceImplDMIWidgetEventLst", new String[]{"paOOAblWidgetEventSubscriptionMethodSample"}));
        this.addSelectionListenerToUpdateSampleButtonState(widgetEventButton);
        this.listenerTypeButtonMap.put(InstanceListenerType.WIDGETS, widgetEventButton);
        Button uiProcedureEventsButton = this.createInterfaceButton((Composite)userInterfaceGroup, "UI Procedure Events", new OOInterfaceTemplate(new OOType("adm.method.cls", "DMIUIProcedureEventLst"), new String[]{"adm.method.cls.DMIUIProcedureEventLst", "adm.method.cls.DMCUIProcedureSvo"}, "paOOAblInterfaceImplDMIUIProcedureEventLst", new String[]{"paOOAblUIProcedureEventSubscriptionMethodSample"}));
        this.addSelectionListenerToUpdateSampleButtonState(uiProcedureEventsButton);
        this.listenerTypeButtonMap.put(InstanceListenerType.UI_PROCEDURE, uiProcedureEventsButton);
        Button browseEventButton = this.createInterfaceButton((Composite)userInterfaceGroup, "Browse Events", new OOInterfaceTemplate(new OOType("adm.method.cls", "DMIBrowseEventLst"), new String[]{"adm.method.cls.DMIBrowseEventLst", "adm.method.cls.DMCUIProcedureSvo", "adm.method.cls.DMCBrowseSvo"}, "paOOAblInterfaceImplDMIBrowseEventLst", new String[]{"paOOAblBrowseEventSubscriptionMethodSample"}));
        this.addSelectionListenerToUpdateSampleButtonState(browseEventButton);
        this.listenerTypeButtonMap.put(InstanceListenerType.BROWSE, browseEventButton);
        Button printOrFilterDialogEventButton = this.createInterfaceButton((Composite)userInterfaceGroup, "Print or Filter Dialog Events", new OOInterfaceTemplate(new OOType("adm.method.cls", "DMIPrintOrFilterDialogEventLst"), new String[]{"adm.method.cls.DMIPrintOrFilterDialogEventLst", "adm.method.cls.DMCPrintOrFilterDialogSvo"}, "paOOAblInterfaceImplDMIPrintOrFilterDialogEventLst", new String[]{"paOOAblDMIPrintOrFilterDialogEventSubscriptionMethodSample"}));
        this.addSelectionListenerToUpdateSampleButtonState(printOrFilterDialogEventButton);
        this.listenerTypeButtonMap.put(InstanceListenerType.PRINT_OR_FILTER_DIALOG, printOrFilterDialogEventButton);
    }

    @Override
    public Map<String, Object> getSettings() {
        Map<String, Object> settings = super.getSettings();
        settings.put("ListenerTypes", this.getSelectedListenerTypes());
        return settings;
    }

    private void addSelectionListenerToUpdateSampleButtonState(Button button) {
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstanceListenerInterfaceWizardPage.this.updateSampleButtonState();
            }
        });
    }

    private void createSampleGroup(Composite parent) {
        Group sampleGroup = this.createGroup(parent, "Examples");
        this.generateSamplesButton = new Button((Composite)sampleGroup, 32);
        this.generateSamplesButton.setText("Generate Examples");
        this.generateSamplesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstanceListenerInterfaceWizardPage.this.setUseAdditionalTemplates(InstanceListenerInterfaceWizardPage.this.generateSamplesButton.getSelection());
                IDialogSettings settings = InstanceListenerInterfaceWizardPage.this.getDialogSettings();
                settings.put(InstanceListenerInterfaceWizardPage.GENERATE_SAMPLES_INIT_VALUE, InstanceListenerInterfaceWizardPage.this.getUseAdditionalTemplates());
            }
        });
    }

    private void updateSampleButtonState() {
        this.generateSamplesButton.setEnabled(this.getSelectedTemplates().size() > 0);
    }

    public InstanceListenerTargetPage getInstanceListenerTargetPage() {
        return this.instanceListenerTargetPage;
    }

    public void setInstanceListenerTargetPage(InstanceListenerTargetPage instanceListenerTargetPage) {
        this.instanceListenerTargetPage = instanceListenerTargetPage;
    }
}

