/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.wizards.wizardpages;

import com.proalpha.pds.paconnector.repository.RepositoryInformations;
import com.proalpha.pds.ui.wizards.wizardpages.IpaWizardPage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class InstanceListenerTargetPage
extends WizardPage
implements IpaWizardPage {
    private RepositoryInformations repositoryInformations = null;
    private TreeViewer instancesTreeViewer = null;
    private List<Instance> instanceList = new ArrayList<Instance>();

    public InstanceListenerTargetPage(RepositoryInformations repositoryInformations) {
        super("InstanceListenerWizardPage");
        this.repositoryInformations = repositoryInformations;
        this.setTitle("Instance Listener");
        this.setDescription("Select the target instances for this instance listener");
        this.setPageComplete(true);
    }

    public void createControl(final Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        this.instancesTreeViewer = new TreeViewer(container, 68352);
        Tree tree = this.instancesTreeViewer.getTree();
        GridData instanceTreeGridData = new GridData(4, 4, true, true, 1, 2);
        tree.setLayoutData((Object)instanceTreeGridData);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(false);
        this.instancesTreeViewer.setContentProvider((IContentProvider)new InterfaceContentProvider());
        TreeViewerColumn treeViewerColumn1 = new TreeViewerColumn(this.instancesTreeViewer, 16384);
        treeViewerColumn1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Instance)element).getId();
            }
        });
        TreeColumn treeColumn1 = treeViewerColumn1.getColumn();
        treeColumn1.setAlignment(16384);
        treeColumn1.setText("Instance");
        treeColumn1.setWidth(150);
        TreeViewerColumn treeViewerColumn2 = new TreeViewerColumn(this.instancesTreeViewer, 16384);
        treeViewerColumn2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Instance)element).getShortDescription();
            }
        });
        TreeColumn treeColumn2 = treeViewerColumn2.getColumn();
        treeColumn2.setAlignment(16384);
        treeColumn2.setText("Short Description");
        treeColumn2.setWidth(300);
        this.instancesTreeViewer.setInput(this.instanceList);
        Composite buttonContainer = new Composite(container, 0);
        RowLayout buttonContainerLayout = new RowLayout(512);
        buttonContainerLayout.fill = true;
        buttonContainer.setLayout((Layout)buttonContainerLayout);
        Button addButton = new Button(buttonContainer, 8);
        addButton.setText("Add");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object result;
                FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(parent.getShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
                dialog.setTitle("Select Instance");
                dialog.setMessage("Choose an instance file from the workspace:");
                if (dialog.open() == 0 && (result = dialog.getFirstResult()) instanceof IFile) {
                    InstanceListenerTargetPage.this.addFile((IFile)result);
                }
            }
        });
        Button removeButton = new Button(buttonContainer, 8);
        removeButton.setText("Remove");
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection structuredSelection = (IStructuredSelection)InstanceListenerTargetPage.this.instancesTreeViewer.getSelection();
                Object firstElement = structuredSelection.getFirstElement();
                if (firstElement != null && firstElement instanceof Instance) {
                    InstanceListenerTargetPage.this.instanceList.remove(firstElement);
                    InstanceListenerTargetPage.this.instancesTreeViewer.refresh();
                }
            }
        });
        container.computeSize(-1, 400);
        this.setControl((Control)container);
    }

    public void addFile(IFile file) {
        String filename = file.getName().trim();
        if (!this.repositoryInformations.existsInstanceInRepository(filename).booleanValue()) {
            return;
        }
        Instance instance = new Instance(filename);
        if (!this.instanceList.contains(instance)) {
            instance.setShortDescription(this.repositoryInformations.getInstanceInformation(filename, "ShortDesc1"));
            this.instanceList.add(instance);
            if (this.instancesTreeViewer != null) {
                this.instancesTreeViewer.refresh();
            }
        }
    }

    @Override
    public Map<String, Object> getSettings() {
        HashMap<String, Object> wizardSettings = new HashMap<String, Object>();
        ArrayList<String> targetInstanceNames = new ArrayList<String>();
        for (Instance instance : this.instanceList) {
            targetInstanceNames.add(instance.getId());
        }
        wizardSettings.put("ListenerTargetInstances", targetInstanceNames.toArray(new String[targetInstanceNames.size()]));
        return wizardSettings;
    }

    public class Instance {
        private String id = "";
        private String ShortDescription = "";

        public Instance(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String getShortDescription() {
            return this.ShortDescription;
        }

        public void setShortDescription(String shortDescription) {
            this.ShortDescription = shortDescription;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof Instance && this.getId().equals(((Instance)obj).getId());
        }
    }

    private class InterfaceContentProvider
    implements ITreeContentProvider {
        private static Object[] noElements = new Object[0];

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return noElements;
        }

        public Object[] getChildren(Object parentElement) {
            return noElements;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }
}

