/*
 * Decompiled with CFR 0.152.
 */
package com.proalpha.pds.ui.wizards.wizardpages;

import com.proalpha.pds.paconnector.PaProject;
import com.proalpha.pds.templates.data.OOInterfaceTemplate;
import com.proalpha.pds.ui.Activator;
import com.proalpha.pds.ui.wizards.wizardpages.IpaWizardPage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public abstract class InterfaceSelectionWizardPage
extends WizardPage
implements IpaWizardPage {
    private PaProject paProject = null;
    private boolean useAdditionalTemplates = false;
    private Set<OOInterfaceTemplate> selectedTemplates = new HashSet<OOInterfaceTemplate>();

    public InterfaceSelectionWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public InterfaceSelectionWizardPage(String pageName) {
        super(pageName);
    }

    protected PaProject getPaProject() {
        return this.paProject;
    }

    protected void setPaProject(PaProject paProject) {
        this.paProject = paProject;
    }

    protected boolean getUseAdditionalTemplates() {
        return this.useAdditionalTemplates;
    }

    protected void setUseAdditionalTemplates(boolean useAdditionalTemplates) {
        this.useAdditionalTemplates = useAdditionalTemplates;
    }

    protected Set<OOInterfaceTemplate> getSelectedTemplates() {
        return this.selectedTemplates;
    }

    protected Group createGroup(Composite parent, String labelText) {
        Group group = new Group(parent, 0);
        group.setText(labelText);
        group.setBackgroundMode(1);
        group.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        group.setLayout((Layout)new RowLayout(512));
        return group;
    }

    protected Button createInterfaceButton(Composite parent, String labelText, final OOInterfaceTemplate sampleTemplate) {
        final Button button = new Button(parent, 32);
        button.setText(labelText);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (button.getSelection()) {
                    InterfaceSelectionWizardPage.this.getSelectedTemplates().add(sampleTemplate);
                } else {
                    InterfaceSelectionWizardPage.this.getSelectedTemplates().remove(sampleTemplate);
                }
            }
        });
        String relativeName = sampleTemplate.getOoType().getRelativeName().concat(".cls");
        IPath ooTypePath = this.getPaProject().getOeProject().getPropath().search(relativeName, false);
        button.setEnabled(ooTypePath != null);
        return button;
    }

    protected Set<String> getSelectedInterfaces() {
        TreeSet<String> selectedInterfaces = new TreeSet<String>();
        for (OOInterfaceTemplate ooTypeSampleTemplate : this.getSelectedTemplates()) {
            selectedInterfaces.add(ooTypeSampleTemplate.getOoType().getQualifiedName());
        }
        return selectedInterfaces;
    }

    protected Set<String> getSelectedUsingStatements() {
        TreeSet<String> selectedUsingStatements = new TreeSet<String>();
        for (OOInterfaceTemplate ooTypeSampleTemplate : this.getSelectedTemplates()) {
            selectedUsingStatements.addAll(ooTypeSampleTemplate.getUsingStatements());
        }
        return selectedUsingStatements;
    }

    protected List<String> getSelectedTemplatesNames() {
        ArrayList<String> selectedTemplatesNames = new ArrayList<String>();
        for (OOInterfaceTemplate ooTypeSampleTemplate : this.getSelectedTemplates()) {
            selectedTemplatesNames.add(ooTypeSampleTemplate.getImplementationTemplateName());
        }
        if (this.getUseAdditionalTemplates()) {
            for (OOInterfaceTemplate ooTypeSampleTemplate : this.getSelectedTemplates()) {
                selectedTemplatesNames.addAll(ooTypeSampleTemplate.getAdditionalTemplateNames());
            }
        }
        return selectedTemplatesNames;
    }

    @Override
    public Map<String, Object> getSettings() {
        HashMap<String, Object> wizardSettings = new HashMap<String, Object>();
        wizardSettings.put("UsingStatements", this.getSelectedUsingStatements());
        wizardSettings.put("ImplementedInterfaces", this.getSelectedInterfaces());
        wizardSettings.put("MethodSnippetTemplates", this.getSelectedTemplatesNames());
        return wizardSettings;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings dialogSettings = Activator.getDefault().getDialogSettings();
        return DialogSettings.getOrCreateSection((IDialogSettings)dialogSettings, (String)this.getName());
    }
}

