/*
 * Decompiled with CFR 0.152.
 */
package com.progress.tools.reportbug.zipper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class SizeCalculator {
    public static long calculateSize(File file) {
        long size = 0L;
        if (file.isDirectory()) {
            size = SizeCalculator.getFolderSize(file);
        } else {
            try {
                size = SizeCalculator.calculateSize(file.getName(), new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return size;
    }

    private static long getFolderSize(File folder) {
        File[] files;
        long size = 0L;
        File[] fileArray = files = folder.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            size = file.isDirectory() ? (size += SizeCalculator.getFolderSize(file)) : (size += file.length());
            ++n2;
        }
        return size;
    }

    public static long calculateSize(String fileName, InputStream in) {
        File saveFile;
        block20: {
            saveFile = SizeCalculator.getTempFile(fileName);
            ZipOutputStream zipOutputStream = null;
            ZipEntry zipEntry = null;
            try {
                zipOutputStream = SizeCalculator.getZipOutputStream(saveFile);
                zipEntry = new ZipEntry(fileName);
                zipEntry.setMethod(8);
                try {
                    try {
                        zipOutputStream.putNextEntry(zipEntry);
                        byte[] bytes = new byte[131072];
                        int readChunk = 0;
                        while ((readChunk = in.read(bytes, 0, bytes.length)) != -1) {
                            zipOutputStream.write(bytes, 0, readChunk);
                        }
                    }
                    catch (Exception exception) {
                        try {
                            zipOutputStream.closeEntry();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        zipOutputStream.closeEntry();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    zipOutputStream.closeEntry();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            finally {
                try {
                    if (zipOutputStream != null) {
                        zipOutputStream.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return saveFile.length();
    }

    private static File getTempFile(String fileName) {
        File file = null;
        try {
            file = File.createTempFile(fileName, ".zip");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        file.deleteOnExit();
        return file;
    }

    private static ZipOutputStream getZipOutputStream(File file) {
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return zipOutputStream;
    }
}

